<?php 
defined( 'ABSPATH' ) || exit;

// PAGE OPTIONS
add_action( 'cmb2_admin_init', 'modeltheme_framework_page_metaboxs' );
function modeltheme_framework_page_metaboxs() { 
  
      // REVSLIDERS
      global $wpdb;
      $limit_small    = 0;
      $limit_high     = 50;
      $tablename      = $wpdb->prefix . "revslider_sliders";
      if($wpdb->get_var("SHOW TABLES LIKE '$tablename'") == $tablename) {
            $sql            = $wpdb->prepare( "SELECT * FROM $tablename LIMIT %d, %d", $limit_small, $limit_high);
            $sliders        = $wpdb->get_results($sql, ARRAY_A);

            $revliders = array(); 
            if ($sliders) {
                  $revliders[''] = 'Please select a slider';
                  foreach($sliders as $slide){
                        $revliders[$slide['alias']] = $slide['title'];
                  }
            }
      }else{
            $revliders = array(); 
      }


      // SIDEBARS
      $sidebar_options = array();
      $sidebars = $GLOBALS['wp_registered_sidebars'];

      if($sidebars){
            foreach ( $sidebars as $sidebar ){
                  $sidebar_options[$sidebar['id']] = $sidebar['name'];
            }
      }

      $fields_group = new_cmb2_box( array(
            'id'           => 'page_metaboxs',
            'title'        => esc_html__( 'Page Custom Options', 'eistruttore-child' ),
            'object_types' => array( 'page' ),
            'priority' => 'high',
      ) );

      $fields_group->add_field( array(
            'name' => __( '<h1>Custom Header Options</h1>', 'cmb2' ),
            'desc' => __( 'These options replaces the Theme Options for current page.', 'cmb2' ),
            'id'   => 'mt_test_title1',
            'type' => 'title',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Transparent Header', 'modeltheme' ),
            'desc'    => __( 'If "Yes" - Navigation will go over Header', 'modeltheme' ),
            'id'      => 'enefti_metabox_header_transparent',
            'type'             => 'select',
            'show_option_none' => true,
            'options' => array(
                'yes' => __( 'Yes', 'modeltheme' ),
                'no' => __( 'No', 'modeltheme' ),
            ),
            'default' => 'no',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Header (Texts and Nav links color)', 'modeltheme' ),
            'desc'    => __( 'This option will override the options from the Theme Panel (and will only be applied to this page only). To change it globally, please go to Theme Panel.', 'modeltheme' ),
            'id'      => 'enefti_header_nav_links_color',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Header (Nav links color) - Hover', 'modeltheme' ),
            'desc'    => __( 'This option will override the options from the Theme Panel (and will only be applied to this page only). To change it globally, please go to Theme Panel.', 'modeltheme' ),
            'id'      => 'enefti_header_nav_links_color_hover',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Header Top Background (Override)', 'modeltheme' ),
            'desc'    => __( 'This option will override the options from the Theme Panel (and will only be applied to this page only). To change it globally, please go to Theme Panel.', 'modeltheme' ),
            'id'      => 'enefti_header_top_custom_background',
            'type'    => 'colorpicker',
            'default' => '',
            'options' => array(
               'alpha' => true, // Make this a rgba color picker.
            ),
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Header Main Background (Override)', 'modeltheme' ),
            'desc'    => __( 'This option will override the options from the Theme Panel (and will only be applied to this page only). To change it globally, please go to Theme Panel.', 'modeltheme' ),
            'id'      => 'enefti_header_main_custom_background',
            'type'    => 'colorpicker',
            'default' => '',
            'options' => array(
               'alpha' => true, // Make this a rgba color picker.
            ),
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Header Main Background (Override) - Sticky', 'modeltheme' ),
            'desc'    => __( 'Only if sticky header option is enabled. This option will override the options from the Theme Panel (and will only be applied to this page only). To change it globally, please go to Theme Panel.', 'modeltheme' ),
            'id'      => 'enefti_header_main_custom_background_sticky',
            'type'    => 'colorpicker',
            'default' => '',
            'options' => array(
               'alpha' => true, // Make this a rgba color picker.
            ),
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Custom Logo', 'modeltheme' ),
            'desc' => __( 'Important: The logo is usually set from the Theme Panel -> Header (Only upload a custom logo here if you want to replace the global logo on this page only).', 'modeltheme' ),
            'id'   => 'enefti_metabox_header_logo',
            'type' => 'file',
            'save_id' => true,
            'allow' => array( 'url', 'attachment' )
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Custom Logo (Sticky Header)', 'modeltheme' ),
            'desc' => __( 'Important: The logo is usually set from the Theme Panel -> Header (Only upload a custom logo here if you want to replace the global logo on this page only).', 'modeltheme' ),
            'id'   => 'enefti_metabox_header_logo_sticky',
            'type' => 'file',
            'save_id' => true,
            'allow' => array( 'url', 'attachment' )
      ) );
      $fields_group->add_field( array(
          'name'    => 'Select Header Variant',
          'id'      => 'enefti_header_custom_variant',
          'type'    => 'radio',
          'options' => array(
              ''        => 'Default - As Selected from the Theme Panel',
              '2'        => 'Header v1',
              '3'        => 'Header v2',
              '8'        => 'Header v3',                 
          ),
          'default' => '',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Select Revolution Slider', 'modeltheme' ),
            'desc'    => __( 'Select an option', 'modeltheme' ),
            'id'      => 'select_revslider_shortcode',
            'type'    => 'select',
            'options' => $revliders,
            'default' => 'default',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Page title-breadcrumbs', 'modeltheme' ),
            'desc'    => __( 'Select an option', 'modeltheme' ),
            'id'      => 'breadcrumbs_on_off',
            'type'    => 'select',
            'options' => array(
                  'no' => __( 'Off - Hide title-breadcrumbs area', 'modeltheme' ),
                  'yes' => __( 'On - Show title-breadcrumbs area', 'modeltheme' ),
            ),
            'default' => 'yes',
      ) );


      /**
      General Page Options
      */
      $fields_group->add_field( array(
            'name' => __( '<h1>General Options</h1>', 'cmb2' ),
            'desc' => __( 'These options replaces the Theme Options for current page.', 'cmb2' ),
            'id'   => 'mt_test_title2',
            'type' => 'title',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Page top/bottom spacing', 'modeltheme' ),
            'desc'    => __( 'Select an option', 'modeltheme' ),
            'id'      => 'page_spacing',
            'type'    => 'select',
            'options' => array(
                  'high-padding' => __( 'High Padding', 'modeltheme' ),
                  'no-padding' => __( 'No Padding', 'modeltheme' ),
                  'no-padding-top' => __( 'No Padding top', 'modeltheme' ),
                  'no-padding-bottom' => __( 'No Padding bottom', 'modeltheme' ),
            ),
            'default' => 'high-padding',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Select Sidebar', 'modeltheme' ),
            'desc'    => __( 'Select an option (if the page supports a sidebar)', 'modeltheme' ),
            'id'      => 'select_page_sidebar',
            'type'    => 'select',
            'options' => $sidebar_options,
            'default' => 'default',
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'First Skin Gradient Color', 'modeltheme' ),
            'desc'    => __( 'Replaces theme options main color', 'modeltheme' ),
            'id'      => 'enefti_global_page_color_1',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Second Skin Gradient Color', 'modeltheme' ),
            'desc'    => __( 'Replaces theme options main color', 'modeltheme' ),
            'id'      => 'enefti_global_page_color_2',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Skin Color - Hover', 'modeltheme' ),
            'desc'    => __( 'Replaces theme options main color', 'modeltheme' ),
            'id'      => 'enefti_global_page_color_hover',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
 
      /**
      FOOTER
      */
      $fields_group->add_field( array(
            'name' => '<h1>Custom Footer Options</h1>',
            'desc' => 'These options replaces the Theme Options for current page.',
            'type' => 'title',
            'id'   => 'mt_test_title3',
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Disable Footer Top Row', 'modeltheme' ),
            'desc' => __( 'Check to disable footer top row', 'modeltheme' ),
            'id'   => 'mt_footer_row_top_status',
            'type' => 'checkbox',
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Disable Footer Row #1', 'modeltheme' ),
            'desc' => __( 'Check to disable footer row 1 (if enabled from Theme Options Panel)', 'modeltheme' ),
            'id'   => 'mt_footer_row1_status',
            'type' => 'checkbox',
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Disable Footer Row #2', 'modeltheme' ),
            'desc' => __( 'Check to disable footer row 2 (if enabled from Theme Options Panel)', 'modeltheme' ),
            'id'   => 'mt_footer_row2_status',
            'type' => 'checkbox',
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Disable Footer Row #3', 'modeltheme' ),
            'desc' => __( 'Check to disable footer row 3 (if enabled from Theme Options Panel)', 'modeltheme' ),
            'id'   => 'mt_footer_row3_status',
            'type' => 'checkbox',
      ) );
      $fields_group->add_field( array(
            'name' => __( 'Disable Footer Bottom Bar', 'modeltheme' ),
            'desc' => __( 'Check to disable footer bottom copyright bar', 'modeltheme' ),
            'id'   => 'mt_footer_bottom_bar',
            'type' => 'checkbox',
      ) );
      // BG color/img
      $fields_group->add_field( array(
            'name'    => __( 'Footer Background Image', 'modeltheme' ),
            'desc'    => __( 'Replaces theme panel footer background image option', 'modeltheme' ),
            'id'      => 'enefti_footer_bg_image',
            'type' => 'file',
            'save_id' => true,
            'allow' => array( 'url', 'attachment' ),
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Footer Background Color', 'modeltheme' ),
            'desc'    => __( '(Optional): Replaces theme panel footer background color option', 'modeltheme' ),
            'id'      => 'enefti_footer_bg_color',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      // Texts color
      $fields_group->add_field( array(
            'name'    => __( 'Footer Headings color', 'modeltheme' ),
            'desc'    => __( '(Optional): Replaces theme options color (widget titles & copyright text)', 'modeltheme' ),
            'id'      => 'enefti_footer_headings_color',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Footer texts color', 'modeltheme' ),
            'desc'    => __( '(Optional): Replaces theme options color (links, social media, texts, headings and more)', 'modeltheme' ),
            'id'      => 'enefti_footer_texts_color',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Footer texts color - hover', 'modeltheme' ),
            'desc'    => __( '(Optional): Replaces theme options color (links & social media)', 'modeltheme' ),
            'id'      => 'enefti_footer_texts_color_hover',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
      $fields_group->add_field( array(
            'name'    => __( 'Footer Bottom Border', 'modeltheme' ),
            'desc'    => __( '(Optional): Replaces theme options footer bottom border color', 'modeltheme' ),
            'id'      => 'enefti_footer_bottom_border',
            'type'    => 'colorpicker',
            'default' => ''
      ) );
} 


// MEMBERS
add_action( 'cmb2_admin_init', 'modeltheme_framework_members_metaboxs' );
function modeltheme_framework_members_metaboxs() { 
  
      $fields_group = new_cmb2_box( array(
            'id'           => 'members_metaboxs',
            'title'        => esc_html__( 'Members Custom Options', 'eistruttore-child' ),
            'object_types' => array( 'member' ),
            'priority' => 'high',
      ) );

      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Job Position', 'mtknowledge' ), 
            'id'       =>'av-job-position', 
            'type'     => 'text',
            'default'  => '', 
      ) ); 
      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Facebook URL', 'mtknowledge' ), 
            'desc'     => esc_html__( 'Enter facebook link', 'mtknowledge' ), 
            'id'       =>'av-facebook-link', 
            'type'     => 'text',
            'default'  => '', 
      ) );  
      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Twitter URL', 'mtknowledge' ), 
            'desc'     => esc_html__( 'Enter Twitter link', 'mtknowledge' ), 
            'id'       =>'av-twitter-link', 
            'type'     => 'text',
            'default'  => '', 
      ) ); 
      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Google Plus URL', 'mtknowledge' ), 
            'desc'     => esc_html__( 'Enter Google Plus link', 'mtknowledge' ), 
            'id'       =>'av-gplus-link', 
            'type'     => 'text',
            'default'  => '', 
      ) );   
      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Instagram URL', 'mtknowledge' ), 
            'desc'     => esc_html__( 'Enter Instagram link', 'mtknowledge' ), 
            'id'       =>'av-instagram-link', 
            'type'     => 'text',
            'default'  => '', 
      ) );   
} 


// TESTIMONIALS
add_action( 'cmb2_admin_init', 'modeltheme_framework_testimonials_metaboxs' );
function modeltheme_framework_testimonials_metaboxs() { 
  
      $fields_group = new_cmb2_box( array(
            'id'           => 'testimonials_metaboxs',
            'title'        => esc_html__( 'Testimonials Custom Options', 'eistruttore-child' ),
            'object_types' => array( 'testimonial' ),
            'priority' => 'high',
      ) );

      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Job Position', 'mtknowledge' ), 
            'desc'     => esc_html__( 'Enter testimonial author job position', 'mtknowledge' ), 
            'id'       =>'job-position', 
            'type'     => 'text',
            'default'  => '', 
      ) ); 
      $fields_group->add_field( array( 
            'name'     => esc_html__( 'Company', 'mtknowledge' ), 
            'desc'     => esc_html__( 'Enter testimonial author company name', 'mtknowledge' ), 
            'id'       =>'company', 
            'type'     => 'text',
            'default'  => '', 
      ) );   
} 