<?php

/**
 * Post Type: Auctions
 */

function netstorm_auction() {

	$labels = [
		"name" => __( "Auctions", "netstorm" ),
		"singular_name" => __( "Auction", "netstorm" ),
		"menu_name" => __( "Live Auctions", "netstorm" ),
		"all_items" => __( "All Live Auctions", "netstorm" ),
		"featured_image" => __( "Auction Image", "netstorm" ),
		"set_featured_image" => __( "Set Auction Image", "netstorm" ),
		"remove_featured_image" => __( "Remove Auction Image", "netstorm" ),
		"use_featured_image" => __( "Use Auction Image", "netstorm" ),
	];

	$args = [
		"label" => __( "Auctions", "netstorm" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"has_archive" => false,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"delete_with_user" => false,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => [ "slug" => "auction", "with_front" => true ],
		"query_var" => true,
		"menu_icon" => "dashicons-hammer",
		"supports" => [ "title", "thumbnail", "excerpt", "custom-fields" ],
		"taxonomies" => [ "collections", "seller", "owner" ],
		"show_in_graphql" => false,
	];

	register_post_type( "auction", $args );
}

add_action( 'init', 'netstorm_auction' );