<?php

/**
 * Post Type: Collections
 */

function netstorm_collection() {

	$labels = [
		"name" => __( "Collections", "netstorm" ),
		"singular_name" => __( "Collection", "netstorm" ),
		"featured_image" => __( "Collection Image", "netstorm" ),
		"set_featured_image" => __( "Set Collection Image", "netstorm" ),
		"remove_featured_image" => __( "Remove Collection Image", "netstorm" ),
		"use_featured_image" => __( "Use Collection Image", "netstorm" ),
	];

	$args = [
		"label" => __( "Collections", "netstorm" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"has_archive" => false,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"delete_with_user" => false,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => [ "slug" => "collections", "with_front" => true ],
		"query_var" => true,
		"menu_icon" => "dashicons-schedule",
		"supports" => [ "title", "thumbnail", "excerpt", "custom-fields" ],
		"show_in_graphql" => false,
	];

	register_post_type( "collection", $args );
}

add_action( 'init', 'netstorm_collection' );