<?php

/**
 * Post Type: Portfolios
 */

function netstorm_portfolio() {

	$labels = [
		"name" => __( "Portfolios", "netstorm" ),
		"singular_name" => __( "Portfolio", "netstorm" ),
		"featured_image" => __( "Portfolio Image", "netstorm" ),
		"set_featured_image" => __( "Set Portfolio Image", "netstorm" ),
		"remove_featured_image" => __( "Remove Portfolio Image", "netstorm" ),
		"use_featured_image" => __( "Use Portfolio Image", "netstorm" ),
	];

	$args = [
		"label" => __( "Portfolios", "netstorm" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"has_archive" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"delete_with_user" => false,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => [ "slug" => "explore", "with_front" => true ],
		"query_var" => true,
		"menu_icon" => "dashicons-portfolio",
		"supports" => [ "title", "thumbnail", "excerpt", "custom-fields" ],
		"taxonomies" => [ "collections", "seller", "owner" ],
		"show_in_graphql" => false,
	];

	register_post_type( "portfolio", $args );
}

add_action( 'init', 'netstorm_portfolio' );

/**
 * Post Type: Taxonomy
 */

function netstorm_taxes() {

	/**
	 * Taxonomy: Collections.
	 */

	$labels = [
		"name" => __( "Collections", "netstorm" ),
		"singular_name" => __( "Collection", "netstorm" ),
	];

	
	$args = [
		"label" => __( "Collections", "netstorm" ),
		"labels" => $labels,
		"public" => true,
		"publicly_queryable" => true,
		"hierarchical" => true,
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => [ 'slug' => 'collections', 'with_front' => false,  'hierarchical' => true, ],
		"show_admin_column" => false,
		"show_in_rest" => true,
		"show_tagcloud" => false,
		"rest_base" => "collections",
		"rest_controller_class" => "WP_REST_Terms_Controller",
		"show_in_quick_edit" => false,
		"show_in_graphql" => false,
	];
	register_taxonomy( "collections", [ "portfolio", "auction", "product" ], $args );

	/**
	 * Taxonomy: Owners.
	 */

	$labels = [
		"name" => __( "Owners", "netstorm" ),
		"singular_name" => __( "Owner", "netstorm" ),
	];

	
	$args = [
		"label" => __( "Owners", "netstorm" ),
		"labels" => $labels,
		"public" => true,
		"publicly_queryable" => true,
		"hierarchical" => false,
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => [ 'slug' => 'owner', 'with_front' => true, ],
		"show_admin_column" => false,
		"show_in_rest" => true,
		"show_tagcloud" => false,
		"rest_base" => "owner",
		"rest_controller_class" => "WP_REST_Terms_Controller",
		"show_in_quick_edit" => false,
		"show_in_graphql" => false,
	];
	register_taxonomy( "owner", [ "portfolio", "auction", "product" ], $args );

	/**
	 * Taxonomy: Creators.
	 */

	$labels = [
		"name" => __( "Creators", "netstorm" ),
		"singular_name" => __( "Creator", "netstorm" ),
	];

	
	$args = [
		"label" => __( "Creators", "netstorm" ),
		"labels" => $labels,
		"public" => true,
		"publicly_queryable" => true,
		"hierarchical" => false,
		"show_ui" => true,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"query_var" => true,
		"rewrite" => [ 'slug' => 'creator', 'with_front' => true, ],
		"show_admin_column" => false,
		"show_in_rest" => true,
		"show_tagcloud" => false,
		"rest_base" => "creator",
		"rest_controller_class" => "WP_REST_Terms_Controller",
		"show_in_quick_edit" => false,
		"show_in_graphql" => false,
	];
	register_taxonomy( "creator", [ "portfolio", "auction", "product" ], $args );
}
add_action( 'init', 'netstorm_taxes' );