<?php

/**
 * Post Type: Sellers
 */

function netstorm_seller() {

	$labels = [
		"name" => __( "Sellers", "netstorm" ),
		"singular_name" => __( "Seller", "netstorm" ),
		"menu_name" => __( "Top Sellers", "netstorm" ),
		"all_items" => __( "All Top Sellers", "netstorm" ),
		"featured_image" => __( "Seller Image", "netstorm" ),
		"set_featured_image" => __( "Set Seller Image", "netstorm" ),
		"remove_featured_image" => __( "Remove Seller Image", "netstorm" ),
		"use_featured_image" => __( "Use Seller Image", "netstorm" ),
	];

	$args = [
		"label" => __( "Sellers", "netstorm" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"has_archive" => false,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"delete_with_user" => false,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => [ "slug" => "creator", "with_front" => true ],
		"query_var" => true,
		"menu_icon" => "dashicons-admin-users",
		"supports" => [ "title", "thumbnail", "excerpt", "custom-fields" ],
		"show_in_graphql" => false,
	];

	register_post_type( "seller", $args );
}

add_action( 'init', 'netstorm_seller' );