<?php

/**
 * Post Type: Vendors
 */

function netstorm_vendor() {

	$labels = [
		"name" => __( "Vendors", "netstorm" ),
		"singular_name" => __( "Vendor", "netstorm" ),
		"menu_name" => __( "Authors", "netstorm" ),
		"all_items" => __( "All Authors", "netstorm" ),
		"featured_image" => __( "Author Image", "netstorm" ),
		"set_featured_image" => __( "Set Author Image", "netstorm" ),
		"remove_featured_image" => __( "Remove Author Image", "netstorm" ),
		"use_featured_image" => __( "Use Author Image", "netstorm" ),
	];

	$args = [
		"label" => __( "Vendors", "netstorm" ),
		"labels" => $labels,
		"description" => "",
		"public" => true,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"has_archive" => false,
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
		"delete_with_user" => false,
		"exclude_from_search" => false,
		"capability_type" => "post",
		"map_meta_cap" => true,
		"hierarchical" => false,
		"rewrite" => [ "slug" => "creator", "with_front" => true ],
		"query_var" => true,
		"menu_icon" => "dashicons-megaphone",
		"supports" => [ "title", "thumbnail", "custom-fields" ],
		"show_in_graphql" => false,
	];

	register_post_type( "vendor", $args );
}

add_action( 'init', 'netstorm_vendor' );