<?php
/**
 * Helper Functions
 *
 * @package Bdevs_Addons
 */
defined( 'ABSPATH' ) || die();

/** Form activated **/

function netstorm_elements_is_cf7_activated() {
    return class_exists( 'WPCF7' );
}

/**
 * Get a list of all CF7 forms
 *
 * @return array
 */
function netstorm_elements_get_cf7_forms() {
    $forms = [];
    if ( netstorm_elements_is_cf7_activated() ) {
        $_forms = get_posts( [
            'post_type'      => 'wpcf7_contact_form',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'orderby'        => 'title',
            'order'          => 'ASC',
        ] );

        if ( ! empty( $_forms ) ) {
            $forms = wp_list_pluck( $_forms, 'post_title', 'ID' );
        }
    }
    return $forms;
}

/**
* Call a shortcode function by tag name.
*
* @since 1.0.0
*
* @param string $tag The shortcode whose function to call.
* @param array $atts The attributes to pass to the shortcode function. Optional.
* @param array $content The shortcode's content. Default is null (none).
*
* @return string|bool False on failure, the result of the shortcode on success.
*/
function netstorm_elements_do_shortcode( $tag, array $atts = array(), $content = null ) {
global $shortcode_tags;
    if ( ! isset( $shortcode_tags[ $tag ] ) ) {
    return false;
}
    return call_user_func( $shortcode_tags[ $tag ], $atts, $content, $tag );
}

/**
* Sanitize html class string
*
* @param $class
* @return string
*/
function netstorm_elements_sanitize_html_class_param( $class ) {
$classes = ! empty( $class ) ? explode( ' ', $class ) : [];
$sanitized = [];
if ( ! empty( $classes ) ) {
$sanitized = array_map( function( $cls ) {
return sanitize_html_class( $cls );
}, $classes );
}
return implode( ' ', $sanitized );
}

/**
 * ACF JSON Data
 */
define( 'MY_PLUGIN_DIR_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
add_filter('acf/settings/save_json', 'my_acf_json_save_point');
 
function my_acf_json_save_point( $path ) {
    
    // Update path
    $path = MY_PLUGIN_DIR_PATH. '/acf-json';
    // Return path
    return $path;
    
}

add_filter( 'acf/settings/load_json', 'my_acf_json_load_point' );

function my_acf_json_load_point( $paths ) {

	$paths = array( MY_PLUGIN_DIR_PATH. '/acf-json' );
    
	if ( is_child_theme() ) {
		$paths[] = get_stylesheet_directory() . '/acf-json';
	}

	return $paths;
}