<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;

class Activity extends \Elementor\Widget_Base {

	public function get_name() {
		return 'activity';
	}

	public function get_title() {
		return __( 'Activity', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-radio';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'activity_section',
            [
                'label' => __( 'Activity', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'activity_section_all',
			[
				'label' => __( 'All', 'netstorm' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'bid_seller_image',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $repeater->add_control(
			'bid_item_title',
			[
				'label' => __( 'Bid Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'item_url', [
                'label' => __( 'Item Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the item link', 'netstorm' ),
            ]
        );

        $repeater->add_control(
			'bid_price',
			[
				'label' => __( 'Bid Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_time',
			[
				'label' => __( 'Bid Time', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_seller',
			[
				'label' => __( 'Seller', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'bid_seller_url', [
                'label' => __( 'Seller Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the seller link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'bid_list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Bid List #1', 'netstorm' ),
                        'bid_item_title' => __( 'Walking On Air', 'netstorm' ),
                        'bid_price' => __( '14 ETH', 'netstorm' ),
                        'bid_time' => __( '4 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@arham', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #2', 'netstorm' ),
                        'bid_item_title' => __( 'Virtual Worlds', 'netstorm' ),
                        'bid_price' => __( '10 ETH', 'netstorm' ),
                        'bid_time' => __( '8 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@junaid', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #3', 'netstorm' ),
                        'bid_item_title' => __( 'Collectibles', 'netstorm' ),
                        'bid_price' => __( '12 ETH', 'netstorm' ),
                        'bid_time' => __( '3 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@yasmin', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #4', 'netstorm' ),
                        'bid_item_title' => __( 'Digital Arts', 'netstorm' ),
                        'bid_price' => __( '22 ETH', 'netstorm' ),
                        'bid_time' => __( '9 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@john', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #5', 'netstorm' ),
                        'bid_item_title' => __( 'Design Illusions', 'netstorm' ),
                        'bid_price' => __( '42 ETH', 'netstorm' ),
                        'bid_time' => __( '7 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@william', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #6', 'netstorm' ),
                        'bid_item_title' => __( 'Industrial', 'netstorm' ),
                        'bid_price' => __( '36 ETH', 'netstorm' ),
                        'bid_time' => __( '10 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@sara', 'netstorm' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->add_control(
			'activity_section_recent',
			[
				'label' => __( 'Recent List', 'netstorm' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'bid_history_seller_image',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $repeater->add_control(
			'bid_history_item_title',
			[
				'label' => __( 'Bid Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'item_history_url', [
                'label' => __( 'Item Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the item link', 'netstorm' ),
            ]
        );

        $repeater->add_control(
			'bid_history_price',
			[
				'label' => __( 'Bid Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_history_time',
			[
				'label' => __( 'Bid Time', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_history_seller',
			[
				'label' => __( 'Seller', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'bid_history_seller_url', [
                'label' => __( 'Seller Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the seller link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'bid_history_list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Bid List #1', 'netstorm' ),
                        'bid_history_item_title' => __( 'Virtual Worlds', 'netstorm' ),
                        'bid_history_price' => __( '10 ETH', 'netstorm' ),
                        'bid_history_time' => __( '8 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@artnox', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #2', 'netstorm' ),
                        'bid_history_item_title' => __( 'Collectibles', 'netstorm' ),
                        'bid_history_price' => __( '12 ETH', 'netstorm' ),
                        'bid_history_time' => __( '3 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@yasmin', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #3', 'netstorm' ),
                        'bid_history_item_title' => __( 'Digital Arts', 'netstorm' ),
                        'bid_history_price' => __( '22 ETH', 'netstorm' ),
                        'bid_history_time' => __( '9 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@john', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #4', 'netstorm' ),
                        'bid_history_item_title' => __( 'Photography', 'netstorm' ),
                        'bid_history_price' => __( '29 ETH', 'netstorm' ),
                        'bid_history_time' => __( '10 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@keil', 'netstorm' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->add_control(
			'activity_section_purchase',
			[
				'label' => __( 'Purchase List', 'netstorm' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'after',
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'bid_purchase_seller_image',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $repeater->add_control(
			'bid_purchase_item_title',
			[
				'label' => __( 'Bid Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'item_purchase_url', [
                'label' => __( 'Item Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the item link', 'netstorm' ),
            ]
        );

        $repeater->add_control(
			'bid_purchase_price',
			[
				'label' => __( 'Bid Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_purchase_time',
			[
				'label' => __( 'Bid Time', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_purchase_seller',
			[
				'label' => __( 'Seller', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'bid_purchase_seller_url', [
                'label' => __( 'Seller Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the seller link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'bid_purchase_list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Bid List #1', 'netstorm' ),
                        'bid_purchase_item_title' => __( 'Design Illusions', 'netstorm' ),
                        'bid_purchase_price' => __( '10 ETH', 'netstorm' ),
                        'bid_purchase_time' => __( '8 hours ago', 'netstorm' ),
                        'bid_purchase_seller' => __( '@junaid', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #2', 'netstorm' ),
                        'bid_purchase_item_title' => __( 'Digital Arts', 'netstorm' ),
                        'bid_purchase_price' => __( '12 ETH', 'netstorm' ),
                        'bid_purchase_time' => __( '3 hours ago', 'netstorm' ),
                        'bid_purchase_seller' => __( '@yasmin', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #3', 'netstorm' ),
                        'bid_purchase_item_title' => __( 'Photography', 'netstorm' ),
                        'bid_purchase_price' => __( '22 ETH', 'netstorm' ),
                        'bid_purchase_time' => __( '9 hours ago', 'netstorm' ),
                        'bid_purchase_seller' => __( '@john', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #4', 'netstorm' ),
                        'bid_purchase_item_title' => __( 'Virtual Worlds', 'netstorm' ),
                        'bid_purchase_price' => __( '69 ETH', 'netstorm' ),
                        'bid_purchase_time' => __( '12 hours ago', 'netstorm' ),
                        'bid_purchase_seller' => __( '@arham', 'netstorm' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();
        
	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro .intro-content h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .intro.text-center h3' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro h3',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Content Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro.text-center p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro.text-center p',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section class="activity-area load-more">
            <div class="container">

                <?php if ($settings['heading_switch'] == true): ?>

                    <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                        <?php if ($settings['show_button'] == true): ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro d-flex justify-content-between align-items-end m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>

                                    <?php if ($settings['show_button'] == true): ?>

                                    <div class="intro-btn">
                                        <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php else : ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro mb-4">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                    <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                        <div class="row justify-content-center">
                            <div class="col-12 col-md-8 col-lg-7">
                                <!-- Intro -->
                                <div class="intro text-center">
                                    <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                    <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>

                <?php endif; ?>

                <div class="row items">
                    <div class="col-12 col-md-6 col-lg-8">
                        <!-- Netstorm Tab -->
                        <ul class="netstorm-tab nav nav-tabs" id="nav-tab">
                            <li>
                                <a class="active" id="nav-home-tab" data-toggle="pill" href="#nav-home">
                                    <h5 class="m-0">All</h5>
                                </a>
                            </li>
                            <li>
                                <a id="nav-profile-tab" data-toggle="pill" href="#nav-profile">
                                    <h5 class="m-0">Recent</h5>
                                </a>
                            </li>
                            <li>
                                <a id="nav-contact-tab" data-toggle="pill" href="#nav-contact">
                                    <h5 class="m-0">Purchase</h5>
                                </a>
                            </li>
                        </ul>
                        <!-- Tab Content -->
                        <div class="tab-content" id="nav-tabContent">
                            <div class="tab-pane fade show active" id="nav-home">
                                <ul class="list-unstyled">

                                    <?php if ( $settings['bid_list'] ) : ?>

                                        <?php foreach ( $settings['bid_list'] as $item ) : ?>

                                        <!-- Single Tab List -->
                                        <li class="single-tab-list d-flex align-items-center">
                                            <a href="<?php echo esc_url( $item['item_url']['url'] ); ?>">
                                                <img class="avatar-lg" src="<?php echo esc_url( $item['bid_seller_image']['url'], 'large' ); ?>" alt="">
                                            </a>
                                            <!-- Activity Content -->
                                            <div class="activity-content ml-4">
                                                <a href="<?php echo esc_url( $item['item_url']['url'] ); ?>">
                                                    <h5 class="mt-0 mb-2"><?php echo esc_html( $item['bid_item_title'] ); ?></h5>
                                                </a>
                                                <p class="m-0">Bid listed for <strong><?php echo esc_html( $item['bid_price'] ); ?></strong> <?php echo esc_html( $item['bid_time'] ); ?> <br>by <a href="<?php echo esc_url( $item['bid_seller_url']['url'] ); ?>"><span><?php echo esc_html( $item['bid_seller'] ); ?></span></a></p>
                                            </div>
                                        </li>

                                        <?php endforeach; ?>

                                    <?php endif; ?>

                                </ul>
                            </div>
                            <div class="tab-pane fade" id="nav-profile">
                                <ul class="list-unstyled">

                                    <?php if ( $settings['bid_history_list'] ) : ?>

                                        <?php foreach ( $settings['bid_history_list'] as $item ) : ?>
                                        
                                        <!-- Single Tab List -->
                                        <li class="single-tab-list d-flex align-items-center">
                                            <a href="<?php echo esc_url( $item['item_history_url']['url'] ); ?>">
                                                <img class="avatar-lg" src="<?php echo esc_url( $item['bid_history_seller_image']['url'], 'large' ); ?>" alt="">
                                            </a>
                                            <!-- Activity Content -->
                                            <div class="activity-content ml-4">
                                                <a href="<?php echo esc_url( $item['item_history_url']['url'] ); ?>">
                                                    <h5 class="mt-0 mb-2"><?php echo esc_html( $item['bid_history_item_title'] ); ?></h5>
                                                </a>
                                                <p class="m-0">Bid listed for <strong><?php echo esc_html( $item['bid_history_price'] ); ?></strong> <?php echo esc_html( $item['bid_history_time'] ); ?> <br>by <a href="<?php echo esc_url( $item['bid_history_seller_url']['url'] ); ?>"><span><?php echo esc_html( $item['bid_history_seller'] ); ?></span></a></p>
                                            </div>
                                        </li>

                                        <?php endforeach; ?>

                                    <?php endif; ?>

                                </ul>
                            </div>
                            <div class="tab-pane fade" id="nav-contact">
                                <ul class="list-unstyled">

                                    <?php if ( $settings['bid_purchase_list'] ) : ?>

                                        <?php foreach ( $settings['bid_purchase_list'] as $item ) : ?>

                                        <!-- Single Tab List -->
                                        <li class="single-tab-list d-flex align-items-center">
                                            <a href="<?php echo esc_url( $item['item_purchase_url']['url'] ); ?>">
                                                <img class="avatar-lg" src="<?php echo esc_url( $item['bid_purchase_seller_image']['url'], 'large' ); ?>" alt="">
                                            </a>
                                            <!-- Activity Content -->
                                            <div class="activity-content ml-4">
                                                <a href="<?php echo esc_url( $item['item_purchase_url']['url'] ); ?>">
                                                    <h5 class="mt-0 mb-2"><?php echo esc_html( $item['bid_purchase_item_title'] ); ?></h5>
                                                </a>
                                                <p class="m-0">Bid listed for <strong><?php echo esc_html( $item['bid_purchase_price'] ); ?></strong> <?php echo esc_html( $item['bid_purchase_time'] ); ?> <br>by <a href="<?php echo esc_url( $item['bid_purchase_seller_url']['url'] ); ?>"><span><?php echo esc_html( $item['bid_purchase_seller'] ); ?></span></a></p>
                                            </div>
                                        </li>

                                        <?php endforeach; ?>

                                    <?php endif; ?>

                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 pl-lg-5 p-0 mt-5 mt-lg-0 float-right sidebar">
                        <div id="search-2" class="row item">
                            <div class="col-12 align-self-center">
                                <?php get_search_form(); ?>
                            </div>
                        </div>
                        <div id="categories-2" class="row item collections">
                            <div class="col-12 align-self-center">
                                <h4 class="title">Collections</h4>
                                <ul>
                                    <li class="cat-item cat-item-2">
                                        <?php
                                        $terms = get_terms(
                                            array(
                                                'taxonomy'   => 'collections',
                                                'hide_empty' => false,
                                            )
                                        );

                                        // Check if any term exists
                                        if ( ! empty( $terms ) && is_array( $terms ) ) {
                                            // Run a loop and print them all
                                            foreach ( $terms as $term ) { ?>
                                                <a href="<?php echo esc_url( get_term_link( $term ) ) ?>" class="tag text-left my-1">
                                                    <?php echo $term->name; ?>
                                                </a><?php
                                            }
                                        } ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php

	}

}