<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;

class Author_Profile extends \Elementor\Widget_Base {

	public function get_name() {
		return 'author-profile';
	}

	public function get_title() {
		return __( 'Author Profile', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

		$this->register_content_controls();
        $this->register_style_controls();
		
	}

	function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'author_profile_settings',
            [
                'label' => __( 'Author Profile', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'author_item_image',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

		$this->add_control(
			'author_title', [
				'label' => __( 'Author Name', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'author_content', [
				'label' => __( 'Content', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'author_code', [
				'label' => __( 'Author Code', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
            'author_profile_image',
            [
                'label' => __( 'Author Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'facebook_button_url', [
                'label' => __( 'Facebook Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your Facebook link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'twitter_button_url', [
                'label' => __( 'Twitter Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your Twitter link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'google_button_url', [
                'label' => __( 'Google Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your Google link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'vine_button_url', [
                'label' => __( 'Vine Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your Vine link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'follow_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Follow', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'follow_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'author_collections_settings',
            [
                'label' => __( 'Author Collections', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'item_image',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $repeater->add_control(
            'item_url', [
                'label' => __( 'Item Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your item link', 'netstorm' ),
            ]
        );

        $repeater->add_control(
			'item_group',
			[
				'label' => __( 'Group Name', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'placeholder' => __( '"art","music","collectibles"', 'netstorm' ),
			]
		);

        $repeater->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Author Name', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'author_image',
            [
                'label' => __( 'Author Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'author_url', [
                'label' => __( 'Author Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your author link', 'netstorm' ),
            ]
        );

        $repeater->add_control(
			'item_price', [
				'label' => __( 'Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'item_likes', [
				'label' => __( 'Likes', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'list',
			[
				'label' => __( 'Collection List', 'netstorm' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Item Title', 'netstorm' ),
                        'list_content' => __( 'ERC-729', 'netstorm' ),
                        'item_price' => __( '4.37 BNB', 'netstorm' ),
                        'item_likes' => __( '154', 'netstorm' ),
					],
                    [
						'list_title' => __( 'Item Title', 'netstorm' ),
                        'list_content' => __( 'ERC-543', 'netstorm' ),
                        'item_price' => __( '2.37 BNB', 'netstorm' ),
                        'item_likes' => __( '74', 'netstorm' ),
					],
                    [
						'list_title' => __( 'Item Title', 'netstorm' ),
                        'list_content' => __( 'ERC-932', 'netstorm' ),
                        'item_price' => __( '1.89 BNB', 'netstorm' ),
                        'item_likes' => __( '', 'netstorm' ),
					],
                    [
						'list_title' => __( 'Item Title', 'netstorm' ),
                        'list_content' => __( 'ERC-250', 'netstorm' ),
                        'item_price' => __( '0.74 BNB', 'netstorm' ),
                        'item_likes' => __( '184', 'netstorm' ),
					],
                    [
						'list_title' => __( 'Item Title', 'netstorm' ),
                        'list_content' => __( 'ERC-167', 'netstorm' ),
                        'item_price' => __( '4.23 BNB', 'netstorm' ),
                        'item_likes' => __( '126', 'netstorm' ),
					],
                    [
						'list_title' => __( 'Item Title', 'netstorm' ),
                        'list_content' => __( 'ERC-037', 'netstorm' ),
                        'item_price' => __( '3.41 BNB', 'netstorm' ),
                        'item_likes' => __( '23', 'netstorm' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

	}

	// Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'author_name_style_settings',
            [
                'label' => __( 'Author Name', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'author_name_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card.author-card h5' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_name_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card.author-card h5',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'author_name_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card.author-card h5',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'author_content_style_settings',
            [
                'label' => __( 'Author Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'author_content_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card.author-card p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_content_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card.author-card p',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'author_content_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card.author-card p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style_settings',
            [
                'label' => __( 'Title', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body a h5' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style_settings',
            [
                'label' => __( 'Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body > span' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body > span',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'content_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body > span',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'price_style_settings',
            [
                'label' => __( 'Price', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'price_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'price_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'likes_style_settings',
            [
                'label' => __( 'Likes', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'likes_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'likes_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'likes_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section class="author-area explore-area popular-collections-area">
            <div class="container">
                <div class="row justify-content-between">

                    <div class="col-12 col-md-4">
                        <!-- Author Profile -->
                        <div class="author-card card no-hover text-center">
                            <div class="image-over">
                                <img class="card-img-top" src="<?php echo esc_url( $settings['author_item_image']['url'], 'netstorm-grid-image' ); ?>" alt="">
                                <!-- Author -->
                                <div class="seller">
                                    <div class="seller-thumb avatar-lg">
                                        <img class="rounded-circle" src="<?php echo esc_url( $settings['author_profile_image']['url'], 'thumbnail' ); ?>" alt="">
                                    </div>
                                </div>
                            </div>
                            <!-- Card Caption -->
                            <div class="card-caption col-12 p-0">
                                <!-- Card Body -->
                                <div class="card-body mt-4">
                                    <h5 class="mb-3"><?php echo esc_html( $settings['author_title'] ); ?></h5>
                                    <p class="my-3"><?php echo esc_html( $settings['author_content'] ); ?></p>
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="<?php echo esc_html( $settings['author_code'] ); ?>">
                                        <div class="input-group-append">
                                          <button><i class="icon-docs"></i></button>
                                        </div>
                                    </div>
                                    <!-- Social Icons -->
                                    <div class="social-icons d-flex justify-content-center my-3">
                                        <a class="facebook" href="<?php echo esc_url( $settings['facebook_button_url']['url'] ); ?>">
                                            <i class="fab fa-facebook-f"></i>
                                            <i class="fab fa-facebook-f"></i>
                                        </a>
                                        <a class="twitter" href="<?php echo esc_url( $settings['twitter_button_url']['url'] ); ?>">
                                            <i class="fab fa-twitter"></i>
                                            <i class="fab fa-twitter"></i>
                                        </a>
                                        <a class="google-plus" href="<?php echo esc_url( $settings['google_button_url']['url'] ); ?>">
                                            <i class="fab fa-google-plus-g"></i>
                                            <i class="fab fa-google-plus-g"></i>
                                        </a>
                                        <a class="vine" href="<?php echo esc_url( $settings['vine_button_url']['url'] ); ?>">
                                            <i class="fab fa-vine"></i>
                                            <i class="fab fa-vine"></i>
                                        </a>
                                    </div>
                                    <a class="btn btn-bordered-white btn-smaller" href="<?php echo esc_url( $settings['follow_button_url']['url'] ); ?>"><?php echo esc_html( $settings['follow_button'] ); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-md-8">

                        <div class="row justify-content-center text-center mt-5 mt-lg-0">
                            <div class="col-12">
                                <!-- Explore Menu -->
                                <div class="explore-menu btn-group btn-group-toggle flex-wrap justify-content-center text-center mb-4" data-toggle="buttons">
                                    <label class="btn active d-table text-uppercase p-2">
                                        <input type="radio" value="all" checked class="explore-btn">
                                        <span>All</span>
                                    </label>
                                    <label class="btn d-table text-uppercase p-2">
                                        <input type="radio" value="art" class="explore-btn">
                                        <span>Art</span>
                                    </label>
                                    <label class="btn d-table text-uppercase p-2">
                                        <input type="radio" value="music" class="explore-btn">
                                        <span>Music</span>
                                    </label>
                                    <label class="btn d-table text-uppercase p-2">
                                        <input type="radio" value="collectibles" class="explore-btn">
                                        <span>Collectibles</span>
                                    </label>
                                    <label class="btn d-table text-uppercase p-2">
                                        <input type="radio" value="sports" class="explore-btn">
                                        <span>Sports</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="row items explore-items">

                        <?php if ( $settings['list'] ) : ?>

                            <?php foreach ( $settings['list'] as $item ) : ?>

                            <div class="col-12 col-md-6 item explore-item" data-groups='[<?php echo esc_html( $item['item_group'] ); ?>]'>
                                <div class="author-card card no-hover text-center">
                                    <div class="image-over">
                                        <a href="<?php echo esc_url( $item['item_url']['url'] ); ?>">
                                            <img class="card-img-top" src="<?php echo esc_url( $item['item_image']['url'], 'netstorm-grid-image' ); ?>" alt="">
                                        </a>
                                        <!-- Author -->
                                        <a class="seller" href="<?php echo esc_url( $item['author_url']['url'] ); ?>">
                                            <div class="seller-thumb avatar-lg">
                                                <img class="rounded-circle" src="<?php echo esc_url( $item['author_image']['url'], 'netstorm-grid-image' ); ?>" alt="">
                                            </div>
                                        </a>
                                    </div>
                                    <!-- Card Caption -->
                                    <div class="card-caption col-12 p-0">
                                        <!-- Card Body -->
                                        <div class="card-body mt-4">
                                            <a href="<?php echo esc_url( $item['item_url']['url'] ); ?>">
                                                <h5 class="mb-2"><?php echo esc_html( $item['list_title'] ); ?></h5>
                                            </a>
                                            <span><?php echo esc_html( $item['list_content'] ); ?></span>
                                            <hr>
                                            <div class="card-bottom d-flex justify-content-between">
                                                <span><?php echo esc_html( $item['item_price'] ); ?></span>
                                                <span><i class="icon-heart mr-2"></i><?php echo esc_html( $item['item_likes'] ); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php endforeach; ?>

                        <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php

	}

}