<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;

class Authors extends \Elementor\Widget_Base {

	public function get_name() {
		return 'authors';
	}

	public function get_title() {
		return __( 'Authors', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-kit-parts';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'authors_section',
			[
				'label' => __( 'Authors', 'netstorm' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'posts_per_page',
            [
                'label'         => __('Post per page', 'netstorm'),
                'type'          => Controls_Manager::NUMBER,
                'label_block'   => false,
                'min'           => -1,
                'max'           => 100,
                'step'          => 1,
                'default'       => 8,
            ]
        );

        $this->add_control(
            'post_view_type_order',
            [
                'label'   => __('Type', 'netstorm'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'      => esc_html__('None', 'netstorm'),
                    'latest'    => esc_html__('Latest', 'netstorm'),
                ],

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'netstorm'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'netstorm'),
                    'ASC' => esc_html__('Ascending', 'netstorm')
                ],
                'condition' => ['post_view_type_order' => 'none'],

            ]
        );

        $this->end_controls_section();
        
	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro .intro-content h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .intro.text-center h3' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro h3',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Content Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro.text-center p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro.text-center p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style_settings',
            [
                'label' => __( 'Title', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .popular-collections-area .card .card-body a h5' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .popular-collections-area .card .card-body a h5',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .popular-collections-area .card .card-body a h5',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display();

        $paged = (get_query_var('paged')) ? get_query_var('paged') : -1;

        $args = array(
            'post_type'         => 'vendor',
            'post_status'       => 'publish',
            'paged'             => $paged,
            'suppress_filters'  => 0,
            'posts_per_page'    => isset($settings['posts_per_page']) ? $settings['posts_per_page'] : -1
        );

        if ( !empty( $settings['post_view_type_order'] ) && $settings['post_view_type_order'] !== 'none' ) {
            if ( $settings['post_view_type_order'] === 'latest' ) {
                $args['orderby'] = 'publish_date';
                $args['order'] = 'DESC';
            }
        }

        if ( !empty( $settings['order'] ) && $settings['post_view_type_order'] !== 'latest' ) {
            $args['order'] = $settings['order'];
        }

        $wp_query  = new \WP_Query($args); ?>

        <section class="popular-collections-area">
            <div class="container">

                <?php if ($settings['heading_switch'] == true): ?>

                    <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                        <?php if ($settings['show_button'] == true): ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro d-flex justify-content-between align-items-end m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>

                                    <?php if ($settings['show_button'] == true): ?>

                                    <div class="intro-btn">
                                        <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php else : ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                    <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                        <div class="row justify-content-center">
                            <div class="col-12 col-md-8 col-lg-7">
                                <!-- Intro -->
                                <div class="intro text-center">
                                    <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                    <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>

                <?php endif; ?>

                <div class="row items">

                    <?php
                    if ($wp_query->have_posts()) :
                        while ($wp_query->have_posts()) :
                            $wp_query->the_post();
                    ?>

                    <div class="col-12 col-sm-6 col-lg-3 item">
                        <div class="author-card card no-hover text-center">
                            <div class="image-over">
                                <?php 
                                if ( has_post_thumbnail() ) : ?>
                                    <div class="author-image">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php echo the_post_thumbnail( 'netstorm-grid-image', array( 'class' => 'card-img-top' ) ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <!-- Seller -->
                                <a class="seller" href="<?php the_permalink(); ?>">
                                    <div class="seller-thumb avatar-lg">
                                        <?php 
                                        $image = get_field( 'creator_image' );
                                        if( !empty( $image ) ): ?>
                                            <img class="rounded-circle" src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" />
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                            <!-- Card Caption -->
                            <div class="card-caption col-12 p-0">
                                <!-- Card Body -->
                                <div class="card-body mt-4">
                                    <a href="<?php the_permalink(); ?>">
                                        <h5 class="mb-3"><?php the_title(); ?></h5>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                        endwhile;
                    endif;
                    ?>

                </div>
            </div>
        </section>

        <?php

	}

}