<?php

use \Elementor\Utils;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;

class Breadcrumb extends \Elementor\Widget_Base {

	public function get_name() {
		return 'breadcrumb';
	}

	public function get_title() {
		return __( 'Breadcrumb', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-archive-title';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Counter Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'breadcrumb_bg',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-full-image',
            ]
        );

        $this->add_control(
            'breadcrumb_heading', [
                'label' => __( 'Breadcrumb Heading', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Breadcrumb Heading', 'netstorm' ),
            ]
        );

        $this->add_control(
            'breadcrumb_search_heading', [
                'label' => __( 'Breadcrumb Search For Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'breadcrumb_main_btn', [
                'label' => __( 'Main Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Home', 'netstorm' ),
                'placeholder' => __( 'Main Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'breadcrumb_main_btn_url', [
                'label' => __( 'Main Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your main button link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'breadcrumb_page_btn', [
                'label' => __( 'Page Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Page Name', 'netstorm' ),
                'placeholder' => __( 'Page Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'breadcrumb_page_btn_url', [
                'label' => __( 'Page Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your page button link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'breadcrumb_item_active', [
                'label' => __( 'Breadcrumb Active Item', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Page', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'counter_style',
            [
                'label' => __( 'Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'breadcrumb_heading_color', [
                'label' => __( 'Breadcrumb Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .breadcrumb-area h2' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'breadcrumb_heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .breadcrumb-area h2',
			]
		);

        $this->add_control(
            'breadcrumb_btn_color', [
                'label' => __( 'Button Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .breadcrumb-item a:not(.btn)' => 'color: {{VALUE}} !important',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'breadcrumb_btn_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .breadcrumb-item a:not(.btn)',
			]
		);

        $this->add_control(
            'breadcrumb_active_item_color', [
                'label' => __( 'Active Item Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .breadcrumb-item.active' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'breadcrumb_active_item_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .breadcrumb-item.active',
			]
		);

        $this->add_control(
            'breadcrumb_item_before_color', [
                'label' => __( 'Item Before Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .breadcrumb-item + .breadcrumb-item::before' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section id="slider" class="p-0 featured bg-odd">
            <div class="swiper-container no-slider slider-h-auto">
                <div class="swiper-wrapper">

                    <div class="swiper-slide slide-center">
                        
                        <img class="full-image mask" src="<?php echo esc_html( $settings['breadcrumb_bg']['url'], 'netstorm-full-image' ); ?>" alt="">

                        <div class="slide-content row text-center">
                            <div class="col-12 mx-auto inner">

                                <h2 data-aos="zoom-out-up" data-aos-delay="400">

                                    <?php if ( is_sticky() && is_single() ) : ?>
                                    <i class="icon icon-pin"></i>
                                    <?php endif; ?>

                                    <?php
                                    if ( is_page() || is_single() ) {
                                        the_title();

                                    }  elseif ( is_category() || is_tag() || is_author() || is_archive() ) {
                                        the_archive_title();

                                    } elseif ( is_search() ) {
                                        printf( esc_html__( 'Searching for: %s', 'netstorm' ), '<em>' . get_search_query() . '</em>' );
                                    
                                    } elseif ( is_404() ) {
                                        printf( esc_html__( '404 %s', 'netstorm' ), '<em>'.esc_html__( 'Nothing Found', 'netstorm' ).'</em>' );
                                    
                                    } elseif ( is_front_page() ) {
                                        echo get_bloginfo( 'name' );
                                        
                                    } else {
                                        echo get_the_title( get_option('page_for_posts', true) );
                                    }
                                    ?>
                                </h2>

                                <?php if ( ! is_front_page() ) : ?>

                                <nav data-aos="zoom-out-up" data-aos-delay="800" aria-label="breadcrumb">
                                    <ol class="breadcrumb"><?php netstorm_breadcrumb(); ?></ol>
                                </nav>
                                
                                <?php endif; ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php

	}

}