<?php

use \Elementor\Utils;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;

class Create extends \Elementor\Widget_Base {

	public function get_name() {
		return 'create';
	}

	public function get_title() {
		return __( 'Create', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-kit-upload';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

		$this->register_content_controls();
        $this->register_style_controls();
		
	}

	function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

	}

	// Register Style
    function register_style_controls() {

        

        $this->start_controls_section(
            'title_style_settings',
            [
                'label' => __( 'Title', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body a h5' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'seller_style_settings',
            [
                'label' => __( 'Seller', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'seller_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .seller a h6' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'seller_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .seller a h6',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'seller_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .seller a h6',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'price_style_settings',
            [
                'label' => __( 'Price', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'price_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'price_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'quantity_style_settings',
            [
                'label' => __( 'Quantity', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'quantity_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'quantity_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'quantity_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section class="author-area">
            <div class="container">

                <?php if ($settings['heading_switch'] == true): ?>

                    <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                        <?php if ($settings['show_button'] == true): ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro d-flex justify-content-between align-items-end m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>

                                    <?php if ($settings['show_button'] == true): ?>

                                    <div class="intro-btn">
                                        <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php else : ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                    <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                        <div class="row justify-content-center">
                            <div class="col-12 col-md-8 col-lg-7">
                                <!-- Intro -->
                                <div class="intro text-center">
                                    <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                    <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>

                <?php endif; ?>

                <form action="">
                    <div class="row justify-content-center item-form card no-hover flex-row">
                        <div class="col-12 col-md-5">
                            <h4 class="m-0">Upload file</h4>
                            <p class="mt-2">Drag or choose your file to upload</p>
                            <!-- Upload File -->
                            <div class="upload-input text-center my-5">
                                <div class="icon-box">
                                    <i class="icons icon-cloud-upload text-effect"></i>
                                    <h5 class="my-3">Drag and drop your file</h5>
                                    <p>PNG, GIF, WEBP, MP4 or MP3. Max 100Mb</p>
                                </div>
                                <div class="input-box mt-5">
                                    <span class="d-block">or choose a file</span>
                                    <a class="btn btn-smaller btn-bordered mt-3" href="#">Browse Files</a>
                                    <input type="file">
                                </div>
                            </div>
                            <!-- Service Fee -->
                            <div class="service-fee">
                                <h5 class="mb-2">Note:</h5>
                                <span class="d-block">Service fee : <strong>2.5%</strong></span>
                            </div>
                        </div>
                        <div class="col-12 col-md-7">
                            <div class="row create-item mt-5 mt-md-0">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="inputName">Product Name</label>
                                        <input type="text" class="form-control mt-2" id="inputName" name="name" placeholder="e. g. `Skull Punk`" required="required">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="inputDescription">Description</label>
                                        <textarea class="form-control mt-2" id="inputDescription" name="textarea" placeholder="e. g. “The highest quality NFT in the marketplace...”" cols="30" rows="3"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-4">
                                    <div class="form-group">
                                        <label for="itemPrice">Item Price in $</label>
                                        <input type="text" class="form-control mt-2" id="itemPrice" name="price" placeholder="e. g. `20$`" required="required">
                                    </div>
                                </div>
                                <div class="col-12 col-md-4">
                                    <div class="form-group">
                                        <label for="itemSize">Size</label>
                                        <input type="text" class="form-control mt-2" id="itemSize" placeholder="e. g. `Size`" required="required">
                                    </div>
                                </div>
                                <div class="col-12 col-md-4">
                                    <div class="form-group">
                                        <label for="itemCopies">No of Copies</label>
                                        <input type="text" class="form-control mt-2" id="itemCopies" name="copies" placeholder="e. g. `Copies`" required="required">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="itemRoyality">Royality</label>
                                        <input type="text" class="form-control mt-2" id="itemRoyality" name="royality" placeholder="e. g. `20%`" required="required">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group mt-3">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="inlineRadio1" value="option1" checked>
                                            <label class="form-check-label" for="inlineRadio1">Put on Sale</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="inlineRadio2" value="option2">
                                            <label class="form-check-label" for="inlineRadio2">Instant Sale Price</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="inlineRadio3" value="option3">
                                            <label class="form-check-label" for="inlineRadio3">Unlock Purchased</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button class="btn w-100 mt-3 mt-sm-4" type="submit">Create Item</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </section>

        <?php

	}

}