<?php

use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Shadow;

class Hero extends \Elementor\Widget_Base {

	public function get_name() {
		return 'hero';
	}

	public function get_title() {
		return __( 'Hero', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-inner-section';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
			'hero_section',
			[
				'label' => __( 'Content', 'netstorm' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'hero_intro',
			[
				'label' => __( 'Intro Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Netstorm', 'netstorm' ),
				'placeholder' => __( 'Type your title here', 'netstorm' ),
			]
		);

        $this->add_control(
			'hero_heading',
			[
				'label' => __( 'Heading', 'netstorm' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 10,
				'default' => __( 'Discover, collect, and sell extraordinary NFTs', 'netstorm' ),
				'placeholder' => __( 'Type your description here', 'netstorm' ),
			]
		);

        $this->add_control(
			'hero_description',
			[
				'label' => __( 'Description', 'netstorm' ),
				'type' => Controls_Manager::TEXTAREA,
				'rows' => 10,
                'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'netstorm' ),
				'placeholder' => __( 'Type your description here', 'netstorm' ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'hero_buttons',
			[
				'label' => __( 'Buttons', 'netstorm' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'hero_button_one', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Explore', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'hero_button_one_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'hero_button_two', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Create', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'hero_button_two_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'hero_shape',
			[
				'label' => __( 'Shapes', 'netstorm' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'shape_switch',
			[
				'label' => __('Hero Shape', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->end_controls_section();

	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'intro_style_settings',
            [
                'label' => __( 'Intro', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'intro_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .hero-section span',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'intro_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .hero-section span',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .hero-section h1' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .hero-section h1',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'heading_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .hero-section h1',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'description_style_settings',
            [
                'label' => __( 'Description', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .hero-section p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .hero-section p',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'description_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .hero-section p',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section id="slider" class="hero-section intro mb-0">
            <div class="container">
                <div class="row">
                    <div class="col-12 col-md-6 col-lg-7">
                        
                        <?php if( $settings['hero_intro'] ) : ?>
                            <span><?php echo esc_html( $settings['hero_intro'] ); ?></span>
                        <?php endif; ?>

                        <h1 class="mt-4"><?php echo wp_kses_post($settings['hero_heading']); ?></h1>
                        <p><?php echo wp_kses_post($settings['hero_description']); ?></p>
                        <!-- Buttons -->
                        <div class="button-group">
                            <?php if( $settings['hero_button_one'] ) : ?>
                                <a class="btn btn-bordered-white" href="<?php echo esc_url( $settings['hero_button_one_url']['url'] ); ?>"><i class="icon-rocket mr-2"></i><?php echo esc_html( $settings['hero_button_one'] ); ?></a>
                            <?php endif; ?>

                            <?php if( $settings['hero_button_two'] ) : ?>
                                <a class="btn btn-bordered-white" href="<?php echo esc_url( $settings['hero_button_two_url']['url'] ); ?>"><i class="icon-note mr-2"></i><?php echo esc_html( $settings['hero_button_two'] ); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Shape -->
            <?php if ($settings['shape_switch'] == true): ?>
                <div class="hero-shape">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 465" version="1.1">
                        <defs>
                            <linearGradient x1="49.7965246%" y1="28.2355058%" x2="49.7778147%" y2="98.4657689%" id="linearGradient-1">
                                <stop stop-color="rgba(69,40,220, 0.15)" offset="0%" />
                                <stop stop-color="rgba(87,4,138, 0.15)" offset="100%" />
                            </linearGradient>
                        </defs>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <polygon points="" fill="url(#linearGradient-1)">
                                <animate id="graph-animation" xmlns="http://www.w3.org/2000/svg" dur="2s" repeatCount="" attributeName="points" values="0,464 0,464 111.6,464 282.5,464 457.4,464 613.4,464 762.3,464 912.3,464 1068.2,464 1191.2,464 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,323.3 282.5,373 457.4,423.8 613.4,464 762.3,464 912.3,464 1068.2,464 1191.2,464 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,336.6 457.4,363.5 613.4,414.4 762.3,464 912.3,464 1068.2,464 1191.2,464 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,323.3 613.4,340 762.3,425.6 912.3,464 1068.2,464 1191.2,464 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,290.4 762.3,368 912.3,446.4 1068.2,464 1191.2,464 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,329.6 912.3,420 1068.2,427.6 1191.2,464 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,272 912.3,402.4 1068.2,373 1191.2,412 1328.1,464 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,272 912.3,376 1068.2,336.6 1191.2,334 1328.1,404 1440.1,464 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,272 912.3,376 1068.2,282 1191.2,282 1328.1,314 1440.1,372.8 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,272 912.3,376 1068.2,282 1191.2,204 1328.1,254 1440.1,236 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,272 912.3,376 1068.2,282 1191.2,204 1328.1,164 1440.1,144.79999999999998 1440.1,464 0,464; 0,464 0,367 111.6,263 282.5,282 457.4,263 613.4,216 762.3,272 912.3,376 1068.2,282 1191.2,204 1328.1,164 1440.1,8 1440.1,464 0,464;" fill="freeze" />
                            </polygon>
                        </g>
                    </svg>
                </div>
            <?php endif; ?>
		</section>

        <?php

	}

}