<?php

use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;

class Icon_Box extends \Elementor\Widget_Base {

	public function get_name() {
		return 'icon-box';
	}

	public function get_title() {
		return __( 'Icon Box', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-icon-box';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

		$this->register_content_controls();
        $this->register_style_controls();
		
	}

	function register_content_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Icon Box', 'netstorm' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
            'list_icon', [
                'label' => __( 'Icon', 'netstorm' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'include' => [
                    'icons icon-fire text-effect',
                    'icons icon-feed text-effect',
                    'icons icon-earphones-alt text-effect',
                ],
                'default' => 'icons icon-fire text-effect',
            ]
        );

		$repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'netstorm' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __( 'Promo List', 'netstorm' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Title #1', 'netstorm' ),
						'list_content' => __( 'Item content. Click the edit button to change this text.', 'netstorm' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

	}

	// Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'icon_box_style',
            [
                'label' => __( 'Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Title Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .service-text h4' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .service-text h4',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Description Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .service-text p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .service-text p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'position',
            [
                'label' => __( 'Icon Box Position', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'alignment',
			[
				'label' => __( 'Alignment', 'netstorm' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'netstorm' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'netstorm' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'netstorm' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'toggle' => false,
                'selectors' => [
					'{{WRAPPER}} .promo-area .card' => 'text-align: {{VALUE}}',
				]
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display();

        if ( $settings['list'] ) : ?>

		<section class="promo-area">
            <div class="container">
                <div class="row">

                    <?php foreach (  $settings['list'] as $item ) : ?>

                        <div class="col-12 col-sm-6 col-lg-4 res-margin">
                            <!-- Single Service -->
                            <div class="card">
                                <i class="<?php echo esc_html( $item['list_icon'] ); ?>"></i>
                                <!-- Service Text -->
                                <div class="service-text">
                                    <h4><?php echo esc_html( $item['list_title'] ); ?></h4>
                                    <p><?php echo wp_kses_post( $item['list_content'] ); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php endforeach; ?>

                </div>
            </div>
        </section>

        <?php endif;

	}

}