<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;

class Item_Details extends \Elementor\Widget_Base {

	public function get_name() {
		return 'item-details';
	}

	public function get_title() {
		return __( 'Item Details', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-posts-group';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'item_details_section',
            [
                'label' => __( 'Item Details', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'item_image',
            [
                'label' => __( 'Choose Item Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $this->add_control(
			'due_date_switch',
			[
				'label' => __('Live Starts', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
			'due_date',
			[
				'label' => __( 'Auction Starting Date', 'netstorm' ),
				'type' => Controls_Manager::DATE_TIME,
                'picker_options' => [
                    'enableTime' => false,
                ],
			]
		);

        $this->add_control(
			'item_title',
			[
				'label' => __( 'Item Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'default' => __( 'Walking On Air', 'netstorm' ),
			]
		);

        $this->add_control(
            'item_content', [
                'label' => __( 'Item Content', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Laborum obcaecati dignissimos quae quo ad iste ipsum officiis deleniti asperiores sit.', 'netstorm' ),
            ]
        );

        $this->add_control(
			'item_seller',
			[
				'label' => __( 'Seller', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'default' => __( 'Themeland', 'netstorm' ),
			]
		);

        $this->add_control(
            'seller_image',
            [
                'label' => __( 'Choose Seller Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'seller_thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $this->add_control(
            'seller_url', [
                'label' => __( 'Seller Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the seller link', 'netstorm' ),
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
			'item_price',
			[
				'label' => __( 'Item Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '1.5 ETH', 'netstorm' ),
			]
		);

        $this->add_control(
			'item_currency',
			[
				'label' => __( 'Currency', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '$500.89', 'netstorm' ),
			]
		);

        $this->add_control(
			'item_quantity',
			[
				'label' => __( 'Quantity', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '1 of 5', 'netstorm' ),
			]
		);

        $this->add_control(
			'item_size',
			[
				'label' => __( 'Size', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '14000 x 14000 px', 'netstorm' ),
			]
		);

        $this->add_control(
			'item_volume',
			[
				'label' => __( 'Volume', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '64.1', 'netstorm' ),
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
            'collection_section',
            [
                'label' => __( 'Collection Details', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'author_name',
			[
				'label' => __( 'Author Name', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '@ArtNoxStudio', 'netstorm' ),
			]
		);

        $this->add_control(
			'author_position',
			[
				'label' => __( 'Position', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Creator', 'netstorm' ),
			]
		);

        $this->add_control(
            'author_image',
            [
                'label' => __( 'Choose Author Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'author_thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $this->add_control(
            'author_url', [
                'label' => __( 'Author Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the author link', 'netstorm' ),
            ]
        );

        $this->add_control(
			'collection_name',
			[
				'label' => __( 'Collection Name', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Virtual Worlds', 'netstorm' ),
			]
		);

        $this->add_control(
			'collection_location',
			[
				'label' => __( 'Collection Location', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Collection', 'netstorm' ),
			]
		);

        $this->add_control(
            'collection_image',
            [
                'label' => __( 'Choose Collection Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'collection_thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $this->add_control(
            'collection_url', [
                'label' => __( 'Collection Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the collection link', 'netstorm' ),
            ]
        );

        $this->add_control(
			'highest_bid',
			[
				'label' => __( 'Highest Bid', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '2.9 BNB', 'netstorm' ),
			]
		);

        $this->add_control(
			'bid_quantity',
			[
				'label' => __( 'Bid Quantity', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( '1 of 5', 'netstorm' ),
			]
		);

        $this->add_control(
            'bid_button', [
                'label' => __( 'Bid Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Place a Bid', 'netstorm' ),
            ]
        );

        $this->add_control(
            'bid_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'activity_section',
            [
                'label' => __( 'Activity', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'bid_seller_image',
            [
                'label' => __( 'Choose Seller Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $repeater->add_control(
			'bid_price',
			[
				'label' => __( 'Bid Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_time',
			[
				'label' => __( 'Bid Time', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_seller',
			[
				'label' => __( 'Seller', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'bid_seller_url', [
                'label' => __( 'Seller Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the seller link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'bid_list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Bid List #1', 'netstorm' ),
                        'bid_price' => __( '14 ETH', 'netstorm' ),
                        'bid_time' => __( '4 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@arham', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #2', 'netstorm' ),
                        'bid_price' => __( '10 ETH', 'netstorm' ),
                        'bid_time' => __( '8 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@junaid', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #3', 'netstorm' ),
                        'bid_price' => __( '12 ETH', 'netstorm' ),
                        'bid_time' => __( '3 hours ago', 'netstorm' ),
                        'bid_seller' => __( '@yasmin', 'netstorm' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'bid_seller_history_image',
            [
                'label' => __( 'Choose Seller Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

        $repeater->add_control(
			'bid_history_price',
			[
				'label' => __( 'Bid Price', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_history_time',
			[
				'label' => __( 'Bid Time', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
			'bid_history_seller',
			[
				'label' => __( 'Seller', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $repeater->add_control(
            'bid_history_seller_url', [
                'label' => __( 'Seller Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter the seller link', 'netstorm' ),
            ]
        );

        $this->add_control(
            'bid_history_list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Bid List #1', 'netstorm' ),
                        'bid_history_price' => __( '32 ETH', 'netstorm' ),
                        'bid_history_time' => __( '10 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@hasan', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #2', 'netstorm' ),
                        'bid_history_price' => __( '24 ETH', 'netstorm' ),
                        'bid_history_time' => __( '6 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@artnox', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'Bid List #3', 'netstorm' ),
                        'bid_history_price' => __( '29 ETH', 'netstorm' ),
                        'bid_history_time' => __( '12 hours ago', 'netstorm' ),
                        'bid_history_seller' => __( '@meez', 'netstorm' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_info_section',
            [
                'label' => __( 'Item Info', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'creation_date',
			[
				'label' => __( 'Creation Date', 'netstorm' ),
				'type' => Controls_Manager::DATE_TIME,
                'picker_options' => [
                    'enableTime' => false,
                    'dateFormat' => 'd M Y',
                ],
			]
		);

        $this->end_controls_section();
        
	}

    // Register Style
    function register_style_controls() {

        

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section class="item-details-area">
            <div class="container">
                <div class="row justify-content-between">
                    <div class="col-12 col-lg-5">
                        <div class="item-info">
                            <div class="item-thumb text-center">
                                <img src="<?php echo esc_url( $settings['item_image']['url'], 'netstorm-grid-image' ); ?>" alt="">
                            </div>

                            <?php if ($settings['due_date_switch'] == true): ?>

                                <?php if( $settings['due_date'] ) : ?>

                                <div class="card no-hover countdown-times my-4">
                                    <div class='countdown d-flex justify-content-center' data-date="<?php echo esc_html( $settings['due_date'] ); ?>"></div>
                                </div>

                                <?php endif; ?>

                            <?php endif; ?>

                            <!-- Netstorm Tab -->
                            <ul class="netstorm-tab nav nav-tabs" id="nav-tab">
                                <li>
                                    <a class="active" id="nav-home-tab" data-toggle="pill" href="#nav-home">
                                        <h5 class="m-0">Bids</h5>
                                    </a>
                                </li>
                                <li>
                                    <a id="nav-profile-tab" data-toggle="pill" href="#nav-profile">
                                        <h5 class="m-0">History</h5>
                                    </a>
                                </li>
                                <li>
                                    <a id="nav-contact-tab" data-toggle="pill" href="#nav-contact">
                                        <h5 class="m-0">Details</h5>
                                    </a>
                                </li>
                            </ul>

                            <!-- Tab Content -->
                            <div class="tab-content" id="nav-tabContent">

                                <div class="tab-pane fade show active" id="nav-home">
                                    <ul class="list-unstyled">

                                    <?php if ( $settings['bid_list'] ) : ?>

                                        <?php foreach ( $settings['bid_list'] as $item ) : ?>

                                        <!-- Single Tab List -->
                                        <li class="single-tab-list d-flex align-items-center">
                                            <img class="avatar-sm rounded-circle mr-3" src="<?php echo esc_url( $item['bid_seller_image']['url'], 'large' ); ?>" alt="">
                                            <p class="m-0">Bid listed for <strong><?php echo esc_html( $item['bid_price'] ); ?></strong> <?php echo esc_html( $item['bid_time'] ); ?> <br>by <a href="<?php echo esc_url( $item['bid_seller_url']['url'] ); ?>"><?php echo esc_html( $item['bid_seller'] ); ?></a></p>
                                        </li>

                                        <?php endforeach; ?>

                                    <?php endif; ?>

                                    </ul>
                                </div>

                                <div class="tab-pane fade" id="nav-profile">
                                    <ul class="list-unstyled">

                                    <?php if ( $settings['bid_history_list'] ) : ?>

                                        <?php foreach ( $settings['bid_history_list'] as $item ) : ?>

                                        <!-- Single Tab List -->
                                        <li class="single-tab-list d-flex align-items-center">
                                            <img class="avatar-sm rounded-circle mr-3" src="<?php echo esc_url( $item['bid_seller_history_image']['url'], 'large' ); ?>" alt="">
                                            <p class="m-0">Bid listed for <strong><?php echo esc_html( $item['bid_history_price'] ); ?></strong> <?php echo esc_html( $item['bid_history_time'] ); ?> <br>by <a href="<?php echo esc_url( $item['bid_history_seller_url']['url'] ); ?>"><?php echo esc_html( $item['bid_history_seller'] ); ?></a></p>
                                        </li>

                                        <?php endforeach; ?>

                                    <?php endif; ?>

                                    </ul>
                                </div>

                                <div class="tab-pane fade" id="nav-contact">
                                    <!-- Single Tab List -->
                                    <div class="owner-meta d-flex align-items-center mt-3">
                                        <span>Owner</span>
                                        <a class="owner d-flex align-items-center ml-2" href="<?php echo esc_url( $settings['seller_url']['url'] ); ?>">
                                            <img class="avatar-sm rounded-circle" src="<?php echo esc_url( $settings['seller_image']['url'], 'seller_thumbnail' ); ?>" alt="">
                                            <h6 class="ml-2"><?php echo esc_html( $settings['item_seller'] ); ?></h6>
                                        </a>
                                    </div>
                                    <p class="mt-2">Created : <?php echo esc_html( $settings['creation_date'] ); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-lg-6">
                        <!-- Content -->
                        <div class="content mt-5 mt-lg-0">
                            <h3 class="m-0"><?php echo esc_html( $settings['item_title'] ); ?></h3>
                            <p><?php echo esc_html( $settings['item_content'] ); ?></p>

                            <!-- Owner -->
                            <div class="owner d-flex align-items-center">
                                <span>Owned By</span>
                                <a class="owner-meta d-flex align-items-center ml-3" href="<?php echo esc_url( $settings['seller_url']['url'] ); ?>">
                                    <img class="avatar-sm rounded-circle" src="<?php echo esc_url( $settings['seller_image']['url'], 'thumbnail' ); ?>" alt="">
                                    <h6 class="ml-2"><?php echo esc_html( $settings['item_seller'] ); ?></h6>
                                </a>
                            </div>

                            <!-- Item Info List -->
                            <div class="item-info-list mt-4">
                                <ul class="list-unstyled">
                                    <li class="price d-flex justify-content-between">
                                        <span><strong>Current Price</strong> <?php echo esc_html( $settings['item_price'] ); ?></span>
                                        <span><?php echo esc_html( $settings['item_currency'] ); ?></span>
                                        <span><?php echo esc_html( $settings['item_quantity'] ); ?></span>
                                    </li>
                                    <li>
                                        <span><strong>Size</strong></span>
                                        <span><?php echo esc_html( $settings['item_size'] ); ?></span>
                                    </li>
                                    <li>
                                        <span><strong>Volume Traded</strong></span>
                                        <span><?php echo esc_html( $settings['item_volume'] ); ?></span>
                                    </li>
                                </ul>
                            </div>

                            <div class="row items">
                                <div class="col-12 col-md-6 item p-0 pr-md-2">
                                    <div class="card no-hover">
                                        <div class="single-seller d-flex align-items-center">
                                            <a href="<?php echo esc_url( $settings['author_url']['url'] ); ?>">
                                                <img class="avatar-md rounded-circle" src="<?php echo esc_url( $settings['author_image']['url'], 'author_thumbnail' ); ?>" alt="">
                                            </a>
                                            <!-- Seller Info -->
                                            <div class="seller-info ml-3">
                                                <a class="seller mb-2" href="<?php echo esc_url( $settings['author_url']['url'] ); ?>"><?php echo esc_html( $settings['author_name'] ); ?></a>
                                                <span><?php echo esc_html( $settings['author_position'] ); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 item p-0 pl-md-2">
                                    <div class="card no-hover">
                                        <div class="single-seller d-flex align-items-center">
                                            <a href="<?php echo esc_url( $settings['collection_url']['url'] ); ?>">
                                                <img class="avatar-md rounded-circle" src="<?php echo esc_url( $settings['collection_image']['url'], 'collection_thumbnail' ); ?>" alt="">
                                            </a>
                                            <!-- Seller Info -->
                                            <div class="seller-info ml-3">
                                                <a class="seller mb-2" href="<?php echo esc_url( $settings['collection_url']['url'] ); ?>"><?php echo esc_html( $settings['collection_name'] ); ?></a>
                                                <span><?php echo esc_html( $settings['collection_location'] ); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 item p-0">
                                    <div class="card no-hover">
                                        <h4 class="mt-0 mb-2">Highest Bid</h4>
                                        <div class="price d-flex justify-content-between align-items-center">
                                            <span><?php echo esc_html( $settings['highest_bid'] ); ?></span>
                                            <span><?php echo esc_html( $settings['bid_quantity'] ); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a class="d-block btn btn-bordered-white mt-4" href="<?php echo esc_url( $settings['bid_button_url']['url'] ); ?>"><?php echo esc_html( $settings['bid_button'] ); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php

	}

}