<?php

use \Elementor\Utils;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;

class Login extends \Elementor\Widget_Base {

	public function get_name() {
		return 'login';
	}

	public function get_title() {
		return __( 'Login', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-lock-user';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

		$this->register_content_controls();
        $this->register_style_controls();
		
	}

	function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'author_profile_settings',
            [
                'label' => __( 'Author Profile', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'author_item_image',
            [
                'label' => __( 'Choose Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'netstorm-grid-image',
            ]
        );

		$this->add_control(
			'author_title', [
				'label' => __( 'Author Name', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'author_content', [
				'label' => __( 'Content', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
			'author_code', [
				'label' => __( 'Author Code', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
            'author_profile_image',
            [
                'label' => __( 'Author Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'follow_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Follow', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'follow_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'create_section',
            [
                'label' => __( 'Create', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'heading_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Get Started', 'netstorm' ),
            ]
        );

        $this->add_control(
            'heading_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Create Item', 'netstorm' ),
            ]
        );

        $this->add_control(
            'create_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Create Item', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

	}

	// Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro .intro-content h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .intro.text-center h3' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro h3',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Content Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro.text-center p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro.text-center p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style_settings',
            [
                'label' => __( 'Title', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body a h5' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'seller_style_settings',
            [
                'label' => __( 'Seller', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'seller_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .seller a h6' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'seller_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .seller a h6',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'seller_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .seller a h6',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'price_style_settings',
            [
                'label' => __( 'Price', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'price_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'price_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'quantity_style_settings',
            [
                'label' => __( 'Quantity', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'quantity_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'quantity_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'quantity_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section class="author-area">
            <div class="container">

                <?php if ($settings['heading_switch'] == true): ?>

                    <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                        <?php if ($settings['show_button'] == true): ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro d-flex justify-content-between align-items-end m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>

                                    <?php if ($settings['show_button'] == true): ?>

                                    <div class="intro-btn">
                                        <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php else : ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                    <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                        <div class="row justify-content-center">
                            <div class="col-12 col-md-8 col-lg-7">
                                <!-- Intro -->
                                <div class="intro text-center">
                                    <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                    <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>

                <?php endif; ?>

                <div class="row justify-content-center">
                    <div class="col-12 col-md-8 col-lg-7">
                        <!-- Item Form -->
                        <form class="item-form card no-hover">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mt-3">
                                        <input type="email" class="form-control" name="email" placeholder="Enter your Email" required="required">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group mt-3">
                                        <input type="password" class="form-control" name="password" placeholder="Enter your Password" required="required">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group mt-3">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="inlineRadioOptions" id="inlineRadio1" value="option1" checked>
                                            <label class="form-check-label" for="inlineRadio1">Remember Me</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button class="btn w-100 mt-3 mt-sm-4" type="submit">Sign In</button>
                                </div>
                                <div class="col-12">
                                    <hr>
                                    <div class="other-option">
                                        <span class="d-block text-center mb-4">Or</span>
                                        <!-- Social Icons -->
                                        <div class="social-icons d-flex justify-content-center">
                                            <a class="facebook" href="#">
                                                <i class="fab fa-facebook-f"></i>
                                                <i class="fab fa-facebook-f"></i>
                                            </a>
                                            <a class="twitter" href="#">
                                                <i class="fab fa-twitter"></i>
                                                <i class="fab fa-twitter"></i>
                                            </a>
                                            <a class="google-plus" href="#">
                                                <i class="fab fa-google-plus-g"></i>
                                                <i class="fab fa-google-plus-g"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <?php

	}

}