<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;

//tony edit

class My_Wallet extends \Elementor\Widget_Base {

	public function get_name() {
		return 'my-wallet';
	}

	public function get_title() {
		return __( 'My Wallet', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-slider-album';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

		$this->register_content_controls();
        $this->register_style_controls();
		
	}

	function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'design_settings',
            [
                'label' => __( 'Design Settings', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => __( 'Design Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                    'style_3' => __( 'Style 3', 'netstorm' ),
                    'style_4' => __( 'Style 4', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'explore_settings',
            [
                'label' => __( 'Explore Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label'         => __('Post per page', 'netstorm'),
                'type'          => Controls_Manager::NUMBER,
                'label_block'   => false,
                'min'           => -1,
                'max'           => 100,
                'step'          => 1,
                'default'       => 12,
            ]
        );

        $this->add_control(
            'post_view_type_order',
            [
                'label'   => __('Type', 'netstorm'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'      => esc_html__('None', 'netstorm'),
                    'latest'    => esc_html__('Latest', 'netstorm'),
                ],

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'netstorm'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'netstorm'),
                    'ASC' => esc_html__('Ascending', 'netstorm')
                ],
                'condition' => ['post_view_type_order' => 'none'],

            ]
        );

        $this->end_controls_section();

	}

	// Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro .intro-content h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .intro.text-center h3' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro h3',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Content Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro.text-center p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro.text-center p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style_settings',
            [
                'label' => __( 'Title', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body a h5' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body a h5',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'seller_style_settings',
            [
                'label' => __( 'Seller', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'seller_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .seller a h6' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'seller_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .seller a h6',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'seller_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .seller a h6',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'price_style_settings',
            [
                'label' => __( 'Price', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'price_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'price_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:first-child',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'quantity_style_settings',
            [
                'label' => __( 'Quantity', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'quantity_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'quantity_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'quantity_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .explore-area .card .card-body .card-bottom span:last-child',
			]
		);

        $this->end_controls_section();

	}
    protected function render() {
        $this->_render("For Sale","yes");
        $this->_render("Unlisted","no");


    }

    protected function _render($heading,$ownershipForSell) {
        if( !session_id() )
        {
            session_start();
        }
        $exchange_wp_user_id = floatval($_SESSION["exchange_wp_user_id"]);
        $user_current_username_term_id = get_user_meta($exchange_wp_user_id,"exchange_username_term_id",true);


		$settings = $this->get_settings_for_display();

        $paged = (get_query_var('paged')) ? get_query_var('paged') : -1;
        if($ownershipForSell == "no"){
            $meta_query = array(
                array(
                    'key' => '_stock',
                    'value' => 0,
                    'compare' => '=',
                )
            );
        }else{
            $meta_query = array(
                array(
                    'key' => '_stock',
                    'value' => 0,
                    'compare' => '>',
                )
            );
        }
        

        $args = array(
            // 'post_type'         => 'portfolio',
            'post_type'         => 'product',
            // 'post_status'       => $post_status,
            'paged'             => $paged,
            'suppress_filters'  => 0,
            'posts_per_page'    => isset($settings['posts_per_page']) ? $settings['posts_per_page'] : -1,
            'meta_query' => $meta_query,
            'tax_query' => array(
                array(
                    'taxonomy' => 'owner',
                    'field' => 'term_id',
                    'terms' => $user_current_username_term_id
                ),
                array(
                    'taxonomy' => 'utility',
                    'field' => 'name',
                    'terms' => array('ownership')
                )
              )
        );

        if ( !empty( $settings['post_view_type_order'] ) && $settings['post_view_type_order'] !== 'none' ) {
            if ( $settings['post_view_type_order'] === 'latest' ) {
                $args['orderby'] = 'publish_date';
                $args['order'] = 'DESC';
            }
        }

        if ( !empty( $settings['order'] ) && $settings['post_view_type_order'] !== 'latest' ) {
            $args['order'] = $settings['order'];
        }

        $wp_query  = new \WP_Query($args); ?>

        <?php if ( $settings['design_style'] === 'style_1' ): ?>

            <section class="explore-area">
                <div class="container">

                    <?php if ($settings['heading_switch'] == true): ?>

                        <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                            <?php if ($settings['show_button'] == true): ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro d-flex justify-content-between align-items-end m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>

                                        <?php if ($settings['show_button'] == true): ?>

                                        <div class="intro-btn">
                                            <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                        </div>

                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>

                            <?php else : ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php endif; ?>

                        <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                            <div class="row justify-content-center">
                                <div class="col-12 col-md-8 col-lg-7">
                                    <!-- Intro -->
                                    <div class="intro text-center">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                    </div>
                                </div>
                            </div>

                        <?php endif; ?>

                    <?php endif; ?>

                    <div class="row items">

                        <?php
                        if ($wp_query->have_posts()) :
                            while ($wp_query->have_posts()) :
                                $wp_query->the_post();
                                $product = wc_get_product( get_the_ID() ); 

                        ?>
                        
                        <div class="col-12 col-sm-6 col-lg-3 item">
                            <div class="card">
                                <?php 
                                if ( has_post_thumbnail() ) : ?>
                                    <div class="image-over">
                                        <a href="<?php echo the_permalink(); ?>">
                                            <?php echo the_post_thumbnail( 'netstorm-grid-image', array( 'class' => 'card-img-top' ) ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <!-- Card Caption -->
                                <div class="card-caption col-12 p-0">
                                    <!-- Card Body -->
                                    <div class="card-body">
                                        <a href="<?php echo the_permalink(); ?>">
                                            <h5 class="mb-0"><?php echo the_title(); ?></h5>
                                        </a>
                                        <div class="seller d-flex align-items-center my-3">
                                            <span>Owned By</span>
                                            <?php
                                            $terms = get_the_terms( get_the_ID(), 'owner' );
                                            if ($terms && ! is_wp_error($terms)): ?>
                                                <?php foreach($terms as $term): ?>
                                                    <a href="<?php echo get_term_link( $term->slug, 'owner'); ?>" rel="tag" class="<?php echo $term->slug; ?>">
                                                        <h6 class="ml-2 mb-0"><?php echo $term->name; ?></h6>
                                                    </a>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="card-bottom d-flex justify-content-between">
                                            <!-- <span><?php echo the_field('item_price'); ?></span> -->
                                            <span><?php echo $product->get_price_html(); ?></span>
                                            <!-- <span><?php echo $product->get_price_html(); ?></span> -->
                                        </div>
                                        <!-- <a class="btn btn-bordered-white btn-smaller mt-3" href="<?php echo the_permalink(); ?>"><i class="icon-handbag mr-2"></i><?php echo the_field('button_text'); ?></a> -->
                                        <a class="btn btn-bordered-white btn-smaller mt-3" href="<?php echo the_permalink(); ?>">View</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                            endwhile;
                        endif;
                        ?>

                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style'] === 'style_2' ): ?>

            <section class="explore-area">
                <div class="container">

                    <?php if ($settings['heading_switch'] == true): ?>

                        <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                            <?php if ($settings['show_button'] == true): ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro d-flex justify-content-between align-items-end m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>

                                        <?php if ($settings['show_button'] == true): ?>

                                        <div class="intro-btn">
                                            <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                        </div>

                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>

                            <?php else : ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php endif; ?>

                        <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                            <div class="row justify-content-center">
                                <div class="col-12 col-md-8 col-lg-7">
                                    <!-- Intro -->
                                    <div class="intro text-center">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                    </div>
                                </div>
                            </div>

                        <?php endif; ?>

                    <?php endif; ?>

                    <div class="row justify-content-center text-center">
                        <div class="col-12">
                            <!-- Explore Menu -->
                            <div class="explore-menu btn-group btn-group-toggle flex-wrap justify-content-center text-center mb-4" data-toggle="buttons">
                                <label class="btn active d-table text-uppercase p-2">
                                    <input type="radio" value="all" checked class="explore-btn">
                                    <span>All</span>
                                </label>
                                <label class="btn d-table text-uppercase p-2">
                                    <input type="radio" value="art" class="explore-btn">
                                    <span>Art</span>
                                </label>
                                <label class="btn d-table text-uppercase p-2">
                                    <input type="radio" value="music" class="explore-btn">
                                    <span>Music</span>
                                </label>
                                <label class="btn d-table text-uppercase p-2">
                                    <input type="radio" value="collectibles" class="explore-btn">
                                    <span>Collectibles</span>
                                </label>
                                <label class="btn d-table text-uppercase p-2">
                                    <input type="radio" value="sports" class="explore-btn">
                                    <span>Sports</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="row items explore-items">

                        <?php
                        if ($wp_query->have_posts()) :
                            while ($wp_query->have_posts()) :
                                $wp_query->the_post();
                        ?>

                        <div class="col-12 col-sm-6 col-lg-3 item explore-item" data-groups='[<?php echo the_field( 'group_name' ); ?>]'>
                            <div class="card">
                                <?php 
                                if ( has_post_thumbnail() ) : ?>
                                    <div class="image-over">
                                        <a href="<?php echo the_permalink(); ?>">
                                            <?php echo the_post_thumbnail( 'netstorm-grid-image', array( 'class' => 'card-img-top' ) ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <!-- Card Caption -->
                                <div class="card-caption col-12 p-0">
                                    <!-- Card Body -->
                                    <div class="card-body">
                                        <a href="<?php echo the_permalink(); ?>">
                                            <h5 class="mb-0"><?php echo the_title(); ?></h5>
                                        </a>
                                        <div class="seller d-flex align-items-center my-3">
                                            <span>Owned By</span>
                                            <?php
                                            $terms = get_the_terms( get_the_ID(), 'owner' );
                                            if ($terms && ! is_wp_error($terms)): ?>
                                                <?php foreach($terms as $term): ?>
                                                    <a href="<?php echo get_term_link( $term->slug, 'owner'); ?>" rel="tag" class="<?php echo $term->slug; ?>">
                                                        <h6 class="ml-2 mb-0"><?php echo $term->name; ?></h6>
                                                    </a>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="card-bottom d-flex justify-content-between">
                                            <span><?php echo the_field( 'item_price' ); ?></span>
                                            <span><?php echo the_field( 'item_quantity' ); ?></span>
                                        </div>
                                        <a class="btn btn-bordered-white btn-smaller mt-3" href="<?php echo the_permalink(); ?>"><i class="icon-handbag mr-2"></i><?php echo the_field( 'button_text' ); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                            endwhile;
                        endif;
                        ?>

                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style'] === 'style_3' ): ?>

            <section class="explore-area load-more">
                <div class="container">

                    <?php if ($settings['heading_switch'] == true): ?>

                        <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                            <?php if ($settings['show_button'] == true): ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro d-flex justify-content-between align-items-end m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>

                                        <?php if ($settings['show_button'] == true): ?>

                                        <div class="intro-btn">
                                            <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                        </div>

                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>

                            <?php else : ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php endif; ?>

                        <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                            <div class="row justify-content-center">
                                <div class="col-12 col-md-8 col-lg-7">
                                    <!-- Intro -->
                                    <div class="intro text-center">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                    </div>
                                </div>
                            </div>

                        <?php endif; ?>

                    <?php endif; ?>

                    <div class="row items">

                        <?php
                        if ($wp_query->have_posts()) :
                            while ($wp_query->have_posts()) :
                                $wp_query->the_post();
                        ?>

                        <div class="col-12 col-sm-6 col-lg-3 item">
                            <div class="card">
                                <?php 
                                if ( has_post_thumbnail() ) : ?>
                                    <div class="image-over">
                                        <a href="<?php echo the_permalink(); ?>">
                                            <?php echo the_post_thumbnail( 'netstorm-grid-image', array( 'class' => 'card-img-top' ) ); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <!-- Card Caption -->
                                <div class="card-caption col-12 p-0">
                                    <!-- Card Body -->
                                    <div class="card-body">
                                        <a href="<?php echo the_permalink(); ?>">
                                            <h5 class="mb-0"><?php echo the_title(); ?></h5>
                                        </a>
                                        <div class="seller d-flex align-items-center my-3">
                                            <span>Owned By</span>
                                            <?php
                                            $terms = get_the_terms( get_the_ID(), 'owner' );
                                            if ($terms && ! is_wp_error($terms)): ?>
                                                <?php foreach($terms as $term): ?>
                                                    <a href="<?php echo get_term_link( $term->slug, 'owner'); ?>" rel="tag" class="<?php echo $term->slug; ?>">
                                                        <h6 class="ml-2 mb-0"><?php echo $term->name; ?></h6>
                                                    </a>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="card-bottom d-flex justify-content-between">
                                            <span><?php echo the_field( 'item_price' ); ?></span>
                                            <span><?php echo the_field( 'item_quantity' ); ?></span>
                                        </div>
                                        <a class="btn btn-bordered-white btn-smaller mt-3" href="<?php echo the_permalink(); ?>"><i class="icon-handbag mr-2"></i><?php echo the_field( 'button_text' ); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php
                            endwhile;
                        endif;
                        ?>

                    </div>

                    <div class="row">
                        <div class="col-12 text-center">
                            <a id="load-btn" class="btn btn-bordered-white mt-5" href="#">Load More</a>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style'] === 'style_4' ): ?>

            <section class="explore-area">
                <div class="container">

                    <?php if ($settings['heading_switch'] == true): ?>

                        <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                            <?php if ($settings['show_button'] == true): ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro d-flex justify-content-between align-items-end m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>

                                        <?php if ($settings['show_button'] == true): ?>

                                        <div class="intro-btn">
                                            <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                        </div>

                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>

                            <?php else : ?>

                            <div class="row">
                                <div class="col-12">
                                    <!-- Intro -->
                                    <div class="intro m-0">
                                        <div class="intro-content">
                                            <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                            <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php endif; ?>

                        <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                            <div class="row justify-content-center">
                                <div class="col-12 col-md-8 col-lg-7">
                                    <!-- Intro -->
                                    <div class="intro text-center">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $heading ); ?></h3>
                                        <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                    </div>
                                </div>
                            </div>

                        <?php endif; ?>

                    <?php endif; ?>

                    <div class="explore-slides">
                        <div class="swiper-container slider-mid items">
                            <div class="swiper-wrapper">

                            <?php
                            if ($wp_query->have_posts()) :
                                while ($wp_query->have_posts()) :
                                    $wp_query->the_post();
                            ?>

                                <!-- Single Slide -->
                                <div class="swiper-slide item">
                                    <div class="card">
                                        <?php 
                                        if ( has_post_thumbnail() ) : ?>
                                            <div class="image-over">
                                                <a href="<?php echo the_permalink(); ?>">
                                                    <?php echo the_post_thumbnail( 'netstorm-grid-image', array( 'class' => 'card-img-top' ) ); ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <!-- Card Caption -->
                                        <div class="card-caption col-12 p-0">
                                            <!-- Card Body -->
                                            <div class="card-body">
                                                <a href="<?php echo the_permalink(); ?>">
                                                    <h5 class="mb-0"><?php echo the_title(); ?></h5>
                                                </a>
                                                <div class="seller d-flex align-items-center my-3">
                                                    <span>Owned By</span>
                                                    <?php
                                                    $terms = get_the_terms( get_the_ID(), 'owner' );
                                                    if ($terms && ! is_wp_error($terms)): ?>
                                                        <?php foreach($terms as $term): ?>
                                                            <a href="<?php echo get_term_link( $term->slug, 'owner'); ?>" rel="tag" class="<?php echo $term->slug; ?>">
                                                                <h6 class="ml-2 mb-0"><?php echo $term->name; ?></h6>
                                                            </a>
                                                        <?php endforeach; ?>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="card-bottom d-flex justify-content-between">
                                                    <span><?php echo the_field( 'item_price' ); ?></span>
                                                    <span><?php echo the_field( 'item_quantity' ); ?></span>
                                                </div>
                                                <a class="btn btn-bordered-white btn-smaller mt-3" href="<?php echo the_permalink(); ?>"><i class="icon-handbag mr-2"></i><?php echo the_field( 'button_text' ); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php
                                    endwhile;
                                endif;
                                ?>

                            </div>
                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif;

	}

}