<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;

class Post_Details extends \Elementor\Widget_Base {

	public function get_name() {
		return 'post-details';
	}

	public function get_title() {
		return __( 'Post Details', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-inner-section';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'heading', [
                'label' => __( 'Content Heading', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Content', 'netstorm' ),
            ]
        );

        $this->add_control(
            'content_one', [
                'label' => __( 'Content One', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your content description here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'content_two', [
                'label' => __( 'Content Two', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your content description here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'blockquote', [
                'label' => __( 'Blockquote Text', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your blockquote here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'content_three', [
                'label' => __( 'Content Three', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your content description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'image',
			[
				'label' => __( 'Blog Image', 'netstorm' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'exclude' => [
                    'full',
                    'custom',
                    'medium_large'
                ]
            ]
        );

        $this->add_control(
			'image_two',
			[
				'label' => __( 'Gallery Image', 'netstorm' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'image_three',
			[
				'label' => __( 'Gallery Image Two', 'netstorm' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
            'content_four', [
                'label' => __( 'Content Four', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your content description here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'content_five', [
                'label' => __( 'Content Five', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your content description here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'content_six', [
                'label' => __( 'Content Six', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your content description here', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'content_slides',
			[
				'label' => __('Slides', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'content_slides_title', [
                'label' => __( 'Content Slides Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Lorem ipsum dolor', 'netstorm' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'content_list_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
                        'content_list_title' => __( 'List Item #1', 'netstorm' ),
					],
				]
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'post_content',
			[
				'label' => __('Post Content', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'posted_on', [
                'label' => __( 'Posted On', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Posted On', 'netstorm' ),
            ]
        );

        $this->add_control(
            'post_date', [
                'label' => __( 'Post Date', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'May 12, 2021', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'post_comments',
			[
				'label' => __('Post Comments', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'comments_text', [
                'label' => __( 'Comments Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Leave a Reply', 'netstorm' ),
            ]
        );

        $this->add_control(
            'comments_description', [
                'label' => __( 'Comments Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Type your comments description here', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'category_slides',
			[
				'label' => __('Category Slides', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'category_slides_title', [
                'label' => __( 'Category Slides Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Categories', 'netstorm' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'cat_list_url', [
                'label' => __( 'URL', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'cat_list_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'cat_list_number', [
                'label' => __( 'Number', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'cat_slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
                        'cat_list_title' => __( 'List Item #1', 'netstorm' ),
                        'cat_list_number' => __( '23', 'netstorm' ),
					],
				]
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'tags_slides',
			[
				'label' => __('Tags Slides', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'tags_slides_title', [
                'label' => __( 'Tag Slides Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Popular Tags', 'netstorm' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tag_list_url', [
                'label' => __( 'URL', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'tag_list_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'tag_slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
                        'tag_list_title' => __( 'netstorm', 'netstorm' ),
					],
				]
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'social_slides',
			[
				'label' => __('Social Slides', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'social_slides_title', [
                'label' => __( 'Social Slides Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Share This', 'netstorm' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_list_url', [
                'label' => __( 'URL', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'social_list_icon', [
                'label' => __( 'Icon', 'netstorm' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'include' => [
                    'icon-social-instagram ml-0',
                    'icon-social-facebook',
                    'icon-social-linkedin',
                    'icon-social-twitter'
                ],
                'default' => 'icon-social-instagram ml-0'
            ]
        );

        $this->add_control(
			'socials',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'post_content_settings',
            [
                'label' => __( 'Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_title_color', [
                'label' => __( 'Post Title Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .single h2' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single h2',
			]
		);

        $this->add_control(
            'blockquote_color', [
                'label' => __( 'Blockquote Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .single blockquote' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'blockquote_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single blockquote',
			]
		);

        $this->add_control(
            'post_description_color', [
                'label' => __( 'Post Description Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .single p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'post_description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single p',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section id="content" class="section-1 single featured post-details">
            <div class="container">
                <div class="row">

                    <!-- Main -->
                    <main class="col-12 col-lg-8 p-0">
                        <div class="row">
                            <div class="col-12 align-self-center">
                                <!-- Image -->
                                <img src="<?php echo esc_html( $settings['image']['url'], 'large' ); ?>" class="w-100">
                                <h2 class="featured ml-0"><?php echo esc_html( $settings['heading'] ); ?></h2>
                                <p><?php echo wp_kses_post( $settings['content_one'] ); ?></p>
                                <p>
                                    <blockquote><?php echo wp_kses_post( $settings['blockquote'] ); ?></blockquote>
                                </p>
                                <p><?php echo wp_kses_post( $settings['content_two'] ); ?></p>

                                <p><?php echo wp_kses_post( $settings['content_four'] ); ?></p>

                                <!-- Post Holder -->
                                <ul class="mb-5 post-holder">
                                    <li class="post-meta-item">
                                        <time class="date"><span class="posted-on"><?php echo esc_html( $settings['posted_on'] ); ?> <a href="#" rel="bookmark"><time class="entry-date published updated" datetime="2018-11-01T06:18:46+00:00"><?php echo esc_html( $settings['post_date'] ); ?></time></a></span></time>
                                    </li>
                                </ul>

                                <!-- Comments -->
                                <h3 class="comments-reply-text"><?php echo esc_html( $settings['comments_text'] ); ?></h3>
                                <p><?php echo wp_kses_post( $settings['comments_description'] ); ?></p>
                                <form>
                                    <fieldset>
                                        <div class="row">
                                            <div class="col-12 col-lg-6 input-group p-0 pr-lg-3">
                                                <input type="text" name="name" data-minlength="3" class="form-control" placeholder="Name" required>
                                            </div>
                                            <div class="col-12 col-lg-6 input-group p-0">
                                                <input type="email" name="email" data-minlength="3" class="form-control" placeholder="Email" required>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12 input-group p-0">
                                                <textarea name="message" data-minlength="3" rows="4" class="form-control" placeholder="Message" required></textarea>
                                            </div>
                                        </div>
                                        <div class="col-12 input-group p-0">
                                            <a id="next-3" class="btn">POST COMMENT<i class="icon-login left ml-2"></i></a>
                                        </div>
                                    </fieldset>
                                </form>
                            </div>
                        </div>        
                    </main>

                    <!-- Sidebar -->
                    <aside class="col-12 col-lg-4 pl-lg-5 p-0 float-right sidebar">                    
                        <div class="row">
                            <div class="col-12 align-self-center text-left">

                                <!-- Widget [categories] -->
                                <div class="item widget-categories">  
                                    <h4 class="title"><?php echo esc_html( $settings['category_slides_title'] ); ?></h4>
                                    <ul class="list-group list-group-flush">

                                        <?php if ( $settings['cat_slides'] ) : ?>
                                            <?php foreach ( $settings['cat_slides'] as $item ) : ?>
                                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                                    <a href="<?php echo esc_url( $item['cat_list_url']['url'] ); ?>"><?php echo esc_html( $item['cat_list_title'] ); ?></a>
                                                    <span class="badge circle"><?php echo esc_html( $item['cat_list_number'] ); ?></span>
                                                </li>
                                            <?php endforeach;
                                        endif; ?>

                                    </ul>                                
                                </div>

                                <!-- Widget [tags] -->
                                <div class="item widget-tags">  
                                    <h4 class="title"><?php echo esc_html( $settings['tags_slides_title'] ); ?></h4>

                                    <?php if ( $settings['tag_slides'] ) : ?>
                                        <?php foreach ( $settings['tag_slides'] as $item ) : ?>
                                            <a href="<?php echo esc_url( $item['tag_list_url']['url'] ); ?>" class="badge tag"><?php echo esc_html( $item['tag_list_title'] ); ?></a>
                                        <?php endforeach;
                                    endif; ?>

                                </div>

                                <!-- Widget [share-this] -->
                                <div class="item widget-share-this">
                                    <h4 class="title"><?php echo esc_html( $settings['social_slides_title'] ); ?></h4>
                                    <ul class="navbar-nav social share-list">

                                        <?php if ( $settings['socials'] ) : ?>
                                            <?php foreach ( $settings['socials'] as $item ) : ?>
                                                <li class="nav-item">
                                                    <a href="<?php echo esc_url( $item['social_list_url']['url'] ); ?>" class="nav-link"><i class="<?php echo esc_attr( $item['social_list_icon'] ); ?>"></i></a>
                                                </li>
                                            <?php endforeach;
                                        endif; ?>

                                    </ul>
                                </div>

                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </section>

        <?php

	}

}