<?php

use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;

class Posts extends \Elementor\Widget_Base {

	public function get_name() {
		return 'posts';
	}

	public function get_title() {
		return __( 'Posts', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-post-list';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'heading_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
                'placeholder' => __( 'Type your heading title here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'heading_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your heading short description here', 'netstorm' ),
                'placeholder' => __( 'Type your heading description here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'heading_btn', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Button', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'heading_btn_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_slides',
			[
				'label' => __('Recent Posts', 'netstorm'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'netstorm' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

		$repeater->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'large',
                'exclude' => [
                    'full',
                    'custom',
                    'medium_large'
                ]
            ]
        );

        $repeater->add_control(
            'title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Post title #1', 'netstorm' ),
            ]
        );

        $repeater->add_control(
            'description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your post short description here', 'netstorm' ),
            ]
        );

        $repeater->add_control(
            'post_url', [
                'label' => __( 'Post URL', 'netstorm' ),
                'type' => Controls_Manager::URL,
            ]
        );

		$this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro h2' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .intro h2',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Description Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .intro p',
			]
		);

        $this->add_control(
            'heading_btn_color', [
                'label' => __( 'Button Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro .btn' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_btn_typography',
				'label' => __( 'Button Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .intro .btn',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slides_style',
            [
                'label' => __( 'Slide Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'slides_title_style',
			[
				'label' => __( 'Title', 'netstorm' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'slides_title_color', [
                'label' => __( 'Title Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .blog-area.showcase .card-caption h4' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'slides_title_typography',
				'label' => __( 'Title Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .blog-area.showcase .card-caption h4',
			]
		);

        $this->add_control(
			'slides_description_style',
			[
				'label' => __( 'Description', 'netstorm' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'slides_description_color', [
                'label' => __( 'Description Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .blog-area.showcase .card-caption p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'slides_description_typography',
				'label' => __( 'Description Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .blog-area.showcase .card-caption p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slides_position',
            [
                'label' => __( 'Slide Position', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'slides_alignment',
			[
				'label' => __( 'Alignment', 'netstorm' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'netstorm' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'netstorm' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'netstorm' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'center',
				'toggle' => false,
                'selectors' => [
					'{{WRAPPER}} .blog-area.showcase .card' => 'text-align: {{VALUE}}',
				]
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section id="showcase" class="showcase blog-grid masonry">
            <div class="container">
                <div class="row content blog-grid masonry">
                    <main class="col-12 p-0">
                        <div class="<?php if( ! have_posts() ) { echo 'row items justify-content-center'; } else { echo 'bricklayer items'; } ?>">

                            <?php
                            if ( have_posts() ) :
                                while ( have_posts() ) : the_post(); ?>
                                    
                                    <div id="post-<?php the_ID(); ?>" <?php post_class( 'card p-0 text-center item' ); ?>>

                                    <div class="card-caption col-12 p-0">
                                        <div class="card-body">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php if ( is_sticky() ) : ?>
                                                <i class="icon icon-pin mb-4"></i>
                                                <?php endif; ?>
                                                <h4><?php the_title(); ?></h4>
                                                <?php the_excerpt(); ?>
                                            </a>
                                        </div>
                                        <div class="card-footer d-lg-flex align-items-center justify-content-center">
                                            <a href="<?php the_permalink(); ?>" class="d-lg-flex align-items-center">
                                                <i class="icon-user"></i>
                                                <?php echo get_the_author_meta( 'display_name' ); ?>
                                            </a>
                                            <a href="<?php the_permalink(); ?>" class="d-lg-flex align-items-center">
                                                <i class="icon-clock"></i>
                                                <?php echo the_time( get_option( 'date_format' ) ); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>

                                <?php endwhile;
                                wp_reset_postdata();

                            else : ?>
                                No Items here

                            <?php endif;
                            ?>
                
                        </div>
                        
                    </main>			
                </div>
            </div>
        </section>

        <?php

	}

}