<?php

use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Shadow;

class Work extends \Elementor\Widget_Base {

	public function get_name() {
		return 'work';
	}

	public function get_title() {
		return __( 'Work', 'netstorm' );
	}

	public function get_icon() {
		return 'eicon-shape';
	}

	public function get_categories() {
		return [ 'netstorm-elements' ];
	}

    protected function _register_controls() {

        $this->register_content_controls();
        $this->register_style_controls();

    }

    function register_content_controls() {

        $this->start_controls_section(
            'section_heading',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'heading_switch',
			[
				'label' => __('Show', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'heading_style',
            [
                'label' => __( 'Heading Style', 'netstorm' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style_1' => __( 'Style 1', 'netstorm' ),
                    'style_2' => __( 'Style 2', 'netstorm' ),
                ],
                'default' => 'style_1',
                'frontend_available' => true,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

        $this->add_control(
            'section_intro', [
                'label' => __( 'Intro', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Netstorm', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_title', [
                'label' => __( 'Title', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Heading Title', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_description', [
                'label' => __( 'Description', 'netstorm' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Enter your section short description here', 'netstorm' ),
                'placeholder' => __( 'Type your section description here', 'netstorm' ),
            ]
        );

        $this->add_control(
			'show_button',
			[
				'label' => __('Show Button', 'netstorm'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Show', 'netstorm'),
				'label_off' => __('Hide', 'netstorm'),
				'return_value' => 'yes',
				'default' => 'yes',
				'style_transfer' => true,
			]
		);

        $this->add_control(
            'section_button', [
                'label' => __( 'Button Text', 'netstorm' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'View All', 'netstorm' ),
                'placeholder' => __( 'Button text here', 'netstorm' ),
            ]
        );

        $this->add_control(
            'section_button_url', [
                'label' => __( 'Button Link', 'netstorm' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'netstorm' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'work_settings',
            [
                'label' => __( 'How It Works', 'netstorm' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'list_icon', [
                'label' => __( 'Icon', 'netstorm' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'include' => [
                    'icons icon-wallet text-effect',
                    'icons icon-grid text-effect',
                    'icons icon-drawer text-effect',
                    'icons icon-bag text-effect',
                ],
                'default' => 'icons icon-wallet text-effect',
            ]
        );

        $repeater->add_control(
			'list_title',
			[
				'label' => __( 'Item Title', 'netstorm' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

        $repeater->add_control(
			'list_content', [
				'label' => __( 'Content', 'netstorm' ),
				'type' => Controls_Manager::TEXTAREA,
			]
		);

        $this->add_control(
            'list',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'List Item #1', 'netstorm' ),
                        'list_content' => __( 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Eum, repellendus.', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'List Item #2', 'netstorm' ),
                        'list_content' => __( 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Eum, repellendus.', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'List Item #3', 'netstorm' ),
                        'list_content' => __( 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Eum, repellendus.', 'netstorm' ),
                    ],
                    [
                        'list_title' => __( 'List Item #4', 'netstorm' ),
                        'list_content' => __( 'Lorem ipsum dolor, sit amet consectetur adipisicing elit. Eum, repellendus.', 'netstorm' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();

	}

    // Register Style
    function register_style_controls() {

        $this->start_controls_section(
            'heading_style_settings',
            [
                'label' => __( 'Section Heading', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_color', [
                'label' => __( 'Heading Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro .intro-content h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .intro.text-center h3' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'heading_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro h3',
			]
		);

        $this->add_control(
            'description_color', [
                'label' => __( 'Content Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .intro.text-center p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .intro.text-center p',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style_settings',
            [
                'label' => __( 'Title', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .single-work h4' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-work h4',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .single-work h4',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style_settings',
            [
                'label' => __( 'Content', 'netstorm' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color', [
                'label' => __( 'Text Color', 'netstorm' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .single-work p' => 'color: {{VALUE}}',
				],
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'netstorm' ),
				'scheme' => Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .single-work p',
			]
		);

        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'content_text_shadow',
				'label' => __( 'Text Shadow', 'netstorm' ),
				'selector' => '{{WRAPPER}} .single-work p',
			]
		);

        $this->end_controls_section();

	}

    protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <section class="work-area">
            <div class="container">
                
                <?php if ($settings['heading_switch'] == true): ?>

                    <?php if ( $settings['heading_style'] === 'style_1' ): ?>

                        <?php if ($settings['show_button'] == true): ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro d-flex justify-content-between align-items-end m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>

                                    <?php if ($settings['show_button'] == true): ?>

                                    <div class="intro-btn">
                                        <a class="btn content-btn" href="<?php echo esc_url( $settings['section_button_url']['url'] ); ?>"><?php echo esc_html( $settings['section_button'] ); ?></a>
                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>

                        <?php else : ?>

                        <div class="row">
                            <div class="col-12">
                                <!-- Intro -->
                                <div class="intro m-0">
                                    <div class="intro-content">
                                        <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                        <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                    <?php elseif ( $settings['heading_style'] === 'style_2' ): ?>

                        <div class="row justify-content-center">
                            <div class="col-12 col-md-8 col-lg-7">
                                <!-- Intro -->
                                <div class="intro text-center">
                                    <span><?php echo esc_html( $settings['section_intro'] ); ?></span>
                                    <h3 class="mt-3 mb-0"><?php echo esc_html( $settings['section_title'] ); ?></h3>
                                    <p><?php echo wp_kses_post( $settings['section_description'] ); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php endif; ?>

                <?php endif; ?>

                <div class="row items">

                    <?php foreach (  $settings['list'] as $item ) : ?>

                        <div class="col-12 col-sm-6 col-lg-3 item">
                            <!-- Single Work -->
                            <div class="single-work">
                                <i class="<?php echo esc_html( $item['list_icon'] ); ?>"></i>
                                <h4><?php echo esc_html( $item['list_title'] ); ?></h4>
                                <p><?php echo wp_kses_post( $item['list_content'] ); ?></p>
                            </div>
                        </div>

                    <?php endforeach; ?>

                </div>
            </div>
        </section>

        <?php

	}

}