/**

 * <wallet>

 * -----------------------------------------------------------------------------

 * wallet.

 *



 * @type {Component}

 *

 * @event close   [emitted when the closing process begins]

 * @event opened  [emitted when the opening process is completely done]

 * -----------------------------------------------------------------------------

 */

 jQuery(document).ready(function( $ ) {





	Vue.component('wallet', {

  



    //  ╔═╗╦═╗╔═╗╔═╗╔═╗

    //  ╠═╝╠╦╝║ ║╠═╝╚═╗

    //  ╩  ╩╚═╚═╝╩  ╚═╝

    props: [

      // 'markets',// « The JS timestamp to format

      'spendAccounts',

      'amount',

      'toAddress',

      'toTokenId',

      'toAccountId',

      'paymentAddress',

      'paymentTokenId',

      'note',

      // 'type',

    ],



    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗

    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣

    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝

    data: function (){

      return {

        isBillingEnabled: false,



        hasBillingCard: false,



        // Syncing/loading states for this page.

        syncingOpenCheckout: false,

        syncingUpdateCard: false,

        syncingRemoveCard: false,

        checkoutAction:"depositUnits",

        // toAccountId:"",

        

        // Form data

        formData: { 

          walletType: "internal"

        },



        // For tracking client-side validation errors in our form.

        // > Has property set to `true` for each invalid property in `formData`.

        formErrors: { /* … */ },



        // Syncing / loading state

        syncing: false,



        // Server error state

        cloudError: '',



        // Success state when form has been submitted

        cloudSuccess: false,



        userType:"",

        primeTrustForcePayment:"",

        adminAccount:{},

        exchangeError:"",

        error:{},

        appTokenAccounts:[],

        spendAccountIdFilter:[],

        accountIdFilter:[],

        tokens:[],

        // spendAccounts:[],

        internalAccounts:[],

        accounts:[],

        stripePublishableKey: "",

        appToken:{},

        stableToken:{},

        trasnferView:"",

        environment:"",



        loadingTransfer: true,

        cloudLoadingError: '',

            

      };

    },



    /*

                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 

                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )

                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 

                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )

    */



    //  ╦ ╦╔╦╗╔╦╗╦

    //  ╠═╣ ║ ║║║║

    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `

    <div class="wallet-component">

      <div v-if="loadingTransfer" class="text-center">

        <h1>Your balances are being loaded...</h1>

        <ajax-button type="submit" :syncing="loadingTransfer" class="btn btn-primary mint">Refesh</ajax-button>

      </div>

      <div v-else=""> 

        <div class="row">

          <div class="col-md-12">

            <ajax-form action="wallet" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">

              

              <div  class="form-group">

                <label for="wallet-type">From Account</label>

                <select class="form-control" @change="changeTransferType" name="account_id" id="account_id" type="text"  :class="[formErrors.account_id ? 'is-invalid' : '']" v-model.trim="formData.account_id" focus-first>

                  <option  value="myWallet" class="blockchain"> My Wallet </option>

                  <option v-for="spendAccount in spendAccounts" v-if="spendAccount.currency.buyCurrency && spendAccount.name == "Spending"  :value="spendAccount.id"> {{spendAccount.wallet.name }} ({{spendAccount.name}}) - {{spendAccount.spendingBalance.toFixed(2)}} {{spendAccount.currency.name}}  </option>

                </select>

                <div class="invalid-feedback" v-if="formErrors.account_id">Select this wallet type.</div>

              </div>

              

              <p class="text-danger" v-if="cloudError==='emailAlreadyInUse'"><small>It looks like there's already an account with your email address. If you forgot your password, you can recover it <a href="password/forgot">here</a>.</small></p>

              <p class="text-danger" v-else-if="cloudError"><small>An error occured while processing your request. Please check your information and try again, or <a href="/support">contact support</a> if the error persists.</small></p>



            </ajax-form>



          </div>

        </div>

        <div class="row">

          <div style="display:none" class="alert alert-secondary success msg col-md-12" >

            Your wallet was successfully complete.

          </div>

          <div style="display:none" class="alert alert-secondary error msg col-md-12" >

            There was an error completing your wallet.

          </div>

        </div>

       

      </div>

    </div>

      

    `,

    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >

    //

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗

    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣

    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝

    beforeMount: async function() {

        // Attach any initial data from the server.



          // _.extend(this, NFT_PAY_PAYMENT_LOCALS);

          _.extend(this, NFT_PAY_PAYMENT_LOCALS);



          // await this.listen();  



    },

    mounted: async function() {

        //…

      $(".msg").hide();







    

       

      },







    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗

    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗

    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝

    methods: {

      listen: async function() {

        // The auto-connecting socket is exposed as `io.socket`.

  

        // Use `io.socket.on()` to listen for the 'hello' event:

        // io.socket.on(this.market.id, function (data) {

        //   console.log('Socket `' + data.id + '` joined the party!');

        // });

        var Transfer = this;

      

        //show loading// syincing

        this.loadingTransfer = true;

        // $(".market .market-pg").hide().addClass("d-none");

        // $(".market .loading").show().removeClass("d-none");

        // get market 

        

        // var data =  await Cloud.getTransfer.with({tradeType:this.tradeType,symbol:this.symbol})

        // .tolerate(()=>{

        //   this.cloudLoadingError = true;

        // });

  

        // if(data.flag){

        //   _.extend(this, data);

        //   this.loadingTransfer = false;

  

        // }else if(data.mustLogin){

        //   window.location.href = data.redirect;

        // } else{

        //   this.loadingTransfer = false;

        // }



        // var csrf = await CSRF.token();

        //   var apiRequestHeader = {

        //       'X-CSRF-Token':csrf._csrf,

        //         // 'cookie':cookie

        //     };

        //   $.ajax({

        //         type: "POST",

        //       //   url: this.refreshUrl+"/markets/orders/cancel",

        //       // url: '/api/walletAccounts',

        //       url: '/wp-json/yohshow/api/v1/wallet/overview',

        //       data: {userType:this.userType},

        //         headers:apiRequestHeader,

        //         success: function(resData, textStatus, request)

        //         {

        //           resData = JSON.parse(resData);

        //           if(resData.flag){

        //             _.extend(Transfer, resData);

        //             Transfer.loadingTransfer = false;

        //             $(".msg").hide();

        //             Transfer.changeTransferType();

        

        //           }else if(resData.mustLogin){

        //             window.location.href = resData.redirect;

        //           } else{

        //             Transfer.loadingTransfer = false;

        //           }

    

        //         }

        //       });

  

  



  

      },

      changeTransferType: function(e) {

        // var type = $("#walletType").val();

        // this.formData.type = type;

        // // var isFreeze = $(e.target).hasClass("freeze");

        // // var isClose = $(e.target).hasClass("close");

        // // var isView = $(e.target).hasClass("view");

        // // var isOpen = $(e.target).hasClass("open");

        // $(".nav-wallets .walletType").hide();

        // $(".nav-wallets ."+type).show();

      },

      submittedForm: async function(result) {

        result = JSON.parse(result);

        console.log("submittedForm");

        this.syncing = true;

        if(result.flag){

          //show success emssage

          $(".success").show();

        }else{

          // show error message

          $(".error").show();

          this.syncing = false;

  

        }

  

        setTimeout(function(){ $(".msg").hide(); }, 8000);

  

        if(result.flag){

          //show success emssage

          // window.location = '/cards';

          // location.reload();

          await this.listen();

          // this.$router.push(redirectLink);



        }

      },

  

      handleParsingForm: function() {

        // Clear out any pre-existing error messages.

        this.formErrors = {};

  

        var argins = this.formData;

  



        if (Object.keys(this.formErrors).length > 0) {

          return;

        }

  

        this.syncing = true;

        argins.type = argins.walletType;

  

        return argins;

      },

    

    }







  });



});



