<?php
try {
  /**
   * Creates the nftpay api item for the plugin.
   *
   * @package NftPay
   */
  require_once(ABSPATH . 'wp-admin/includes/screen.php');

  /*
    let people pay in stable tokens
  */
  
  /*
  * This action hook registers our PHP class as a WooCommerce payment gateway
  */
  add_filter( 'woocommerce_payment_gateways', 'nftpay_add_gateway_class' );
  function nftpay_add_gateway_class( $gateways ) {
    $gateways[] = 'Nftpay_Payments'; // your class name is here
    return $gateways;
  }
  
  /*
  * The class itself, please note that it is inside plugins_loaded action hook
  */
  add_action( 'plugins_loaded', 'nftpay_init_gateway_class' );
  function nftpay_init_gateway_class() {
  
    class Nftpay_Payments extends WC_Payment_Gateway {
      /**
       * A reference the class responsible for rendering the submenu page.
       *
       * @$   NftPay_API
       * @access protected
       */
      protected $nftpay_api;

      /**
       * nftpay_api_base_url
       *
       * @$   NftPay_API
       * @access protected
       */
      protected $nftpay_api_base_url;

      
  
      /**
       * Class constructor, more about it in Step 3
      */
        public function __construct() {
          $this->init();

  
          $this->id = 'nftpay'; // payment gateway plugin ID
          $this->icon = ''; // URL of the icon that will be displayed on checkout page near your gateway name
          $this->has_fields = true; // in case you need a custom credit card form
          $this->method_title = 'Nft Pay Gateway';
          $this->method_description = 'Buy nfts with debit and credit cards'; // will be displayed on the options page
        
          // gateways can support subscriptions, refunds, saved payment methods,
          // but in this tutorial we begin with simple payments
          $this->supports = array(
            'products'
          );
        
          // Method with all the options fields
          $this->init_form_fields();
        
          // Load the settings.
          $this->init_settings();
          $this->nftpay_id = get_option( 'nftpay_id' );
          $this->title = $this->get_option( 'title' );
          $this->description = $this->get_option( 'description' );
          $this->enabled = $this->get_option( 'enabled' );

          $apiKey = get_option('nftpay_apiKey');
          $apiSecret = get_option('nftpay_apiSecret');

          $apiKeyTest = get_option('nftpay_apiKeyTest');
          $apiSecretTest = get_option('nftpay_apiSecretTest');

          

          $nftpay_environment = get_option('nftpay_environment');
          $this->testmode = false;
          if($nftpay_environment !== "production"){
            $apiKey = $apiKeyTest;
            $apiSecret = $apiSecretTest;
            $this->testmode = true;

          }

          $this->private_key = $apiSecret;
          $this->publishable_key = $apiKey;

          // $this->testmode = 'yes' === $this->get_option( 'testmode' );
          // $this->private_key = $this->testmode ? $this->get_option( 'nftpay_apiSecretTest' ) : $this->get_option( 'nftpay_apiSecret' );
          // $this->publishable_key = $this->testmode ? $this->get_option( 'nftpay_apiKeyTest' ) : $this->get_option( 'nftpay_apiKey' );

          if ($this->publishable_key){
            // $this->nftpay_api = new Nftpay_Api( $this->publishable_key,$this->private_key );
          }

          //$nftpay_tokenize = new Nftpay_Tokenize( $this->nftpay_api );
        
          // This action hook saves the settings
          add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
        
          // We need custom JavaScript to obtain a token
          add_action( 'wp_enqueue_scripts', array( $this, 'payment_scripts' ) );
        
          // You can also register a webhook here
          // add_action( 'woocommerce_api_{webhook name}', array( $this, 'webhook' ) );

          // $nftpay_api_base_url = get_option('nftpay_api_base_url');
          // $nftpay_api_base_url = "https://sandbox.nftpay.xyz/api/v1";
          $nftpay_api_base_url = "https://payments.nftpay.xyz/api/v1";

     
          $this->nftpay_api_base_url = $nftpay_api_base_url;
        }
  
      /**
       * Plugin options, we deal with it in Step 3 too
      */
        public function init_form_fields(){
  
          $this->form_fields = array(
            'enabled' => array(
              'title'       => 'Enable/Disable',
              'label'       => 'Nft Pay Gateway',
              'type'        => 'checkbox',
              'description' => '',
              'default'     => 'no'
            ),
            'title' => array(
              'title'       => 'Title',
              'type'        => 'text',
              'description' => 'This controls the title which the user sees during checkout.',
              'default'     => 'My Card',
              'desc_tip'    => true,
            ),
            'description' => array(
              'title'       => 'Description',
              'type'        => 'textarea',
              'description' => 'This controls the description which the user sees during checkout.',
              'default'     => 'Pay with your credit card via our super-cool payment gateway.',
            ),
            // 'testmode' => array(
            //   'title'       => 'Test mode',
            //   'label'       => 'Enable Test Mode',
            //   'type'        => 'checkbox',
            //   'description' => 'Place the payment gateway in test mode using test API keys.',
            //   'default'     => 'yes',
            //   'desc_tip'    => true,
            // ),
            'nftpay_apiKeyTest' => array(
              'title'       => 'Test Publishable Key',
              'type'        => 'text'
            ),
            'nftpay_apiSecretTest' => array(
              'title'       => 'Test Private Key',
              'type'        => 'password',
            ),
            'nftpay_apiKey' => array(
              'title'       => 'Live Publishable Key',
              'type'        => 'text'
            ),
            'nftpay_apiSecret' => array(
              'title'       => 'Live Private Key',
              'type'        => 'password'
            )
          );
        }


  
      /**
       * You will need it if you want your custom credit card form, Step 4 is about it
       */
      public function payment_fields() {
  
        global $woocommerce;
        $total_amount = $woocommerce->cart->get_total("int");

        $nftpayProductId =  $this->product_id(); 
        // $nftpayProductId = "test";




        //get app info 
        $nftpay_api =  $this->nftpay_api;
        $apiKey =  $this->publishable_key;


        //
        //make note
        $uuid_id = uniqid();
        $time_stamp = time();
//        $now = now();
          $payment_id = $uuid_id ."_". $time_stamp;
          $note["id"] = $payment_id; 
          $note["amount"] = $total_amount;
          $note["note"] = "payment";
        

        // ok, let's display some description before the payment form
        if ( $this->description ) {
          // you can instructions for test mode, I mean test card numbers etc.
          if ( $this->testmode ) {
            $this->description .= ' TEST MODE ENABLED. In test mode, you can use the card numbers listed in <a href="#" target="_blank" rel="noopener noreferrer">documentation</a>.';
            $this->description  = trim( $this->description );
          }
          // display the description with <p> tags etc.
          echo wpautop( wp_kses_post( $this->description ) );
        }
      
        // I will echo() the form, but you can close PHP tags and print it directly in HTML
        echo '<fieldset id="wc-' . esc_attr( $this->id ) . '-cc-form" class="wc-credit-card-form wc-payment-form "" style="background:transparent;">';
      
        // Add this action hook if you want your custom payment gateway to support it
        do_action( 'woocommerce_credit_card_form_start', $this->id );

        if ( $this->testmode ) {

          $NFT_PAY_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
          $NFT_PAY_PAYMENT_LOCALS["paymentNetworks"] = array("goerli");

        }else{

            $NFT_PAY_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
            $NFT_PAY_PAYMENT_LOCALS["paymentNetworks"] = array("main");

        }
 
        $NFT_PAY_PAYMENT_LOCALS["note"] = $note;
        $NFT_PAY_PAYMENT_LOCALS["amount"] = $total_amount;
        $NFT_PAY_PAYMENT_LOCALS["payment_id"] = $payment_id;
        $NFT_PAY_PAYMENT_LOCALS = json_encode($NFT_PAY_PAYMENT_LOCALS);


        $card_form = $this->card_form($nftpayProductId,$NFT_PAY_PAYMENT_LOCALS);
        $script = $card_form['script'];
        $form = $card_form['form'];
     

        echo '<div class="form-row form-row-wide nftpay-payment-fields">


          <div class="form-row form-row-first bootstrap">
          '.$form.'

          <input type="hidden" name="payment_id" value="'.$payment_id.'" />
          <input type="hidden" class="transactionHash" name="transactionHash" />
          <input type="hidden" class="network" name="network" />

          '.$script.'
          ';
      
        do_action( 'woocommerce_credit_card_form_end', $this->id );
      
        echo '<div class="clear test  yoh-wallet"></div></fieldset>';
        /*



          show accounts select box
        */
      
      }
      /*
      * get nft pay product id
      */
      public function product_id() {

        global $woocommerce;
        $total_amount = $woocommerce->cart->get_total("int");

        //TODO for contracts and unique id for products. if more than one product might need to use pure charge as default

        // $items = $woocommerce->cart->get_cart();
        // foreach($items as $item => $values) { 
        //     $_product =  wc_get_product( $values['data']->get_id()); 
        //     $price = get_post_meta($values['product_id'] , '_price', true);
        //     $line_item["price"] = $price; 
        //     $line_item["quantity"] = $values['quantity']; 
        //     $line_item["title"] = $_product->get_title(); 
        //     $note["items"][] = $line_item; 

        // } 

        $product_key = "giftcard_".$total_amount;
        $product_option_key = "nftpay_product_id_".$product_key;
        $product_key_id = get_option($product_option_key);

        error_log( "nftpay payments product_id total_amount ". print_r( $total_amount, true ) );
        error_log( "nftpay payments product_id product_option_key ". print_r( $product_option_key, true ) );
        error_log( "nftpay payments product_id product_key_id ". print_r( $product_key_id, true ) );


        if(!$product_key_id){
          error_log( "nftpay payments product_id must make product_key_id ". print_r( $product_key_id, true ) );



          $partner_notes = $product_option_key;
          $product_name = "Gift Crard";
          $product_description = "Gift Crard for $total_amount";
          $price_cents = floatval($total_amount) * 100;
          $product_description = "Gift Crard for $total_amount";


          $data['price_cents'] = $price_cents;
          $data['product_description'] = $product_description;
          $data['product_name'] = $product_name;
          $data['partner_notes'] = $partner_notes;


          error_log( "nftpay payments product_id data ". print_r( $data, true ) );





          $result = $this->request("post","/products",$data);
          error_log( "nftpay payments product_id result ". print_r( $result, true ) );

          if($result){
            $product_key_id = $result->product_uuid;
            update_option($product_option_key,$product_key_id);
          }else{
            $product_key_id = false;
          }
          error_log( "nftpay payments product_id must make final product_key_id ". print_r( $product_key_id, true ) );

        }
   
        return $product_key_id ;
      }

      /*
      * get nft pay product id
      */
      public function verify_payment($nftpay_payment_uuid) {


        error_log( "nftpay payments verify_payment nftpay_payment_uuid ". print_r( $nftpay_payment_uuid, true ) );

        $data = array();

        error_log( "nftpay payments verify_payment data ". print_r( $data, true ) );





          $payments = $this->request("get","/partner_payments",$data);
          error_log( "nftpay payments verify_payment payments ". print_r( $payments, true ) );

          $valid = false;

          for ($i=0; $i < count($payments) ; $i++) { 
            $payment = $payments[$i];
            
            $uuid = $payment->payment_uuid;
            error_log( "nftpay payments verify_payment payment ". print_r( $payment, true ) );
            error_log( "nftpay payments verify_payment uuid ". print_r( $uuid, true ) );

            if($uuid == $nftpay_payment_uuid){
              $valid = true;
              break;
            }
          }
          return $valid;


      }
      /*
      * Custom CSS and JS, in most cases required only when you decided to go with a custom credit card form
      */
      public function card_form($nftpayProductId,$NFT_PAY_PAYMENT_LOCALS) {

       
        $result["form"] =  $this->card_form_form($nftpayProductId,$NFT_PAY_PAYMENT_LOCALS);
        $result["script"] =  $this->card_form_script($nftpayProductId,$NFT_PAY_PAYMENT_LOCALS);
        return $result ;
      }

      /*
      * Custom CSS and JS, in most cases required only when you decided to go with a custom credit card form
      */
      public function card_form_script($nftpayProductId,$NFT_PAY_PAYMENT_LOCALS) {

        $html = '
        <script>

              var NFT_PAY_PAYMENT_LOCALS = JSON.parse(\''.$NFT_PAY_PAYMENT_LOCALS.'\');


              var amount = NFT_PAY_PAYMENT_LOCALS["amount"];
              var note = NFT_PAY_PAYMENT_LOCALS["note"];
              note =  JSON.stringify(note);
              console.log("NFT_PAY_PAYMENT_LOCALS",NFT_PAY_PAYMENT_LOCALS);


              jQuery( "#place_order" ).click(async function(event) {

                console.log("NFT_PAY_PAYMENT_LOCALS",NFT_PAY_PAYMENT_LOCALS);
                console.log("note",note);

              });

              //nftpay script
              window.addEventListener("message", (message) => {


                if (message.data.source == "nftpay") {
    
                    console.log("payment received!", JSON.stringify(message.data));
                    console.log("payment received!!", message.data);
                    jQuery(".nftpay-payment-uuid").val(message.data.payment_uuid);
                    jQuery("#place_order").click();
                    
    
                    //  example message.data returned:
    
                    // cust_name: "John Smith"
                    // email: "n@nftpay.xyz"
                    // payment_uuid: "434c5c1f-f28c-45bd-81f0-bdefe7f22346"
                    // querystring: "{}"
                    // source: "nftpay"
    
                  // **** REDIRECT THE IFRAME TO https://smartchain.consulting/nft-checkout HERE BY ADJUSTING ITS SRC ATTRIBUTE ****
    
                }
    
            });
    

          </script>
          ';
          return  $html;
        
      }
      public function card_form_form($nftpayProductId,$NFT_PAY_PAYMENT_LOCALS) {

        // $html = '
        // <iframe src="https://sandbox.nftpay.xyz/iframe/iframe_charge/'.$nftpayProductId.'">

        //   </iframe>
        //   <input type="hidden" class="nftpay-payment-uuid" name="nftpay_payment_uuid"  />
          
        //   ';
        $html = '
        <iframe src="https://payments.nftpay.xyz/iframe/iframe_charge/'.$nftpayProductId.'">

          </iframe>
          <input type="hidden" class="nftpay-payment-uuid" name="nftpay_payment_uuid"  />
          
          ';
          return  $html;
        
      }
  
      /*
      * Custom CSS and JS, in most cases required only when you decided to go with a custom credit card form
      */
      public function payment_scripts() {
  
        // // we need JavaScript to process a token only on cart/checkout pages, right?
        // if ( ! is_cart() && ! is_checkout() && ! isset( $_GET['pay_for_order'] ) ) {
        //   return;
        // }
      
        // // if our payment gateway is disabled, we do not have to enqueue JS too
        // if ( 'no' === $this->enabled ) {
        //   return;
        // }
      
        // // no reason to enqueue JavaScript if API keys are not set
        // if ( empty( $this->private_key ) || empty( $this->publishable_key ) ) {
        //   return;
        // }
      
        // // do not work with card detailes without SSL unless your website is in a test mode
        // if ( ! $this->testmode && ! is_ssl() ) {
        //   return;
        // }
      
        // // let's suppose it is our payment processor JavaScript that allows to obtain a token
        // wp_enqueue_script( 'nftpay_js', 'https://www.nftpaypayments.com/api/token.js' );
      
        // // and this is our custom JS in your plugin directory that works with token.js
        // wp_register_script( 'woocommerce_nftpay', plugins_url( 'nftpay.js', __FILE__ ), array( 'jquery', 'nftpay_js' ) );
      
        // // in most payment processors you have to use PUBLIC KEY to obtain a token
        // wp_localize_script( 'woocommerce_nftpay', 'nftpay_params', array(
        //   'publishableKey' => $this->publishable_key
        // ) );
      
        // wp_enqueue_script( 'woocommerce_nftpay' );
      
      }
  
      /*
      * Fields validation, more in Step 5
      */
      public function validate_fields(){
        /*
          make sure user has stable token balance 
        */
        if( empty( $_POST[ 'nftpay_payment_uuid' ]) ) {
          wc_add_notice(  'Please complete card payment', 'error' );
          return false;
        }
        return true;
      
      }
  
      /*
      * We're processing the payments here, everything about it is in Step 5
      */
      public function process_payment( $order_id ) {
        /*
          pay token with order note info make sure they only pay with nftpay account 
        */
  
        global $woocommerce;
        
        // we need it to get any order detailes
        $order = wc_get_order( $order_id );
        $total_amount = $order->get_total();

        //TODO add code to to que web transaction

        $nftpay_payment_uuid = $_POST[ 'nftpay_payment_uuid' ];
        $verified =  $this->verify_payment($nftpay_payment_uuid);

        if(!$verified){
          wc_add_notice(  'Payment processing ID error.', 'error' );
          return;

        }

        error_log( "nftpay payments process_payment verified ". print_r( $verified, true ) );


        if($verified){
          // we received the payment
          $order->payment_complete();
            wc_reduce_stock_levels( $order_id );
          //$order->wc_reduce_stock_levels();

    
          // some notes to customer (replace true with false to make it private)
          $order->add_order_note( 'Hey, your order is paid! Thank you!', true );
    
          // Empty cart
          $woocommerce->cart->empty_cart();


    
          // Redirect to the thank you page
          return array(
            'result' => 'success',
            'redirect' => $this->get_return_url( $order )
          );

        }else {
          wc_add_notice(  'Payment processing ID error.', 'error' );
          return;
        }


        
          
      
        // if( !is_wp_error( $response ) ) {
      
        //   $body = json_decode( $response['body'], true );
      
        //   // it could be different depending on your payment processor
        //   if ( $body['response']['responseCode'] == 'APPROVED' ) {
      
        //     // we received the payment
        //     $order->payment_complete();
        //     $order->wc_reduce_stock_levels();
      
        //     // some notes to customer (replace true with false to make it private)
        //     $order->add_order_note( 'Hey, your order is paid! Thank you!', true );
      
        //     // Empty cart
        //     $woocommerce->cart->empty_cart();
      
        //     // Redirect to the thank you page
        //     return array(
        //       'result' => 'success',
        //       'redirect' => $this->get_return_url( $order )
        //     );
      
        //   } else {
        //     error_log( "there was an error " );
        //     error_log( $response );

        //     wc_add_notice(  'Please try again.', 'error' );
        //     return;
        //   }
      
        // } else {
        //   wc_add_notice(  'Connection error.', 'error' );
        //   return;
        // }
      
      }
  
      /*
      * In case you need a webhook, like PayPal IPN etc
      */
      public function webhook() {
  
      // ...
  
      }
      
      public function order_totals($order){
          $total_amount = $order->get_total();
          $line_items = $order->get_items();
          $tokenized_total = 0;
          $nontokenized_total = 0;
          // // var_dump("buy order line_items",$line_items);
          // for ($i=0; $i < count($line_items); $i++) { 

          return $total_amount;
          

      }
      function init(){
          $this->enqueue_scripts();
          $this->create_endpoints();
          // $this->add_shortcodes();
      }
      public function create_endpoints(){

          $register_result = add_action( 'rest_api_init', function () {
              register_rest_route( 'nftpay/v1', '/payment', array(
                'methods' => 'POST',
                'callback' => array($this,"payment")
              ) );

          } );


        
      }
      public function payment($request) {
        $params = $request->get_params();

          error_log( "nftpay payments payment params ". print_r( $params, true ) );

  
          return $params;
       
      }
      public function enqueue_scripts(){
          $this->enqueue_scripts_folder("assets/dependencies");
          $this->enqueue_scripts_folder("assets/js");
          $this->enqueue_scripts_folder("assets/js/components");
          $this->enqueue_scripts_folder("assets/js/components/nftpay");
          $this->enqueue_scripts_folder("assets/js/pages");

      }




      public function enqueue_scripts_folder($path){
          foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
              // $file contains the name and extension of the file
              $file_name = basename($file);
              $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
              //echo '<pre>'; 
              //// var_dump("file_url",$file_url);
              //echo '</pre>';
              // exit;
              wp_enqueue_script( $file_name, $file_url,array("jquery","vue","vueRouter"));
          }
          // // var_dump("$path/*.css" );

          foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
              // $file contains the name and extension of the file
              $file_name = basename($file);
              $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
              // echo '<pre>'; 
              // // var_dump("file_url",$file_url);
              // echo '</pre>';
              // exit;
              wp_enqueue_style( $file_name, $file_url);
          }
          foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
              // $file contains the name and extension of the file
              $file_name = basename($file);
              $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
              // echo '<pre>'; 
              // // var_dump("file_url",$file_url);
              // echo '</pre>';
              // exit;
              wp_enqueue_style( $file_name, $file_url,array("jquery","vue","vueRouter"));
          }
      }

      //request 
      /**
       * Initializes all of the partial classes.
       *
       * @param string $method post, get or put
       * @param string $endpoint endpont to send request to
       * @param object $data payload to post to end point
       * @param bool $save_cookie wether or not to save the session cookie
       *                                                                  
       */

      function request($method,$endpoint,$data,$save_cookie = false,$use_cookie = true){
        try {
            $result = $this->request_try($method,$endpoint,$data,$save_cookie,$use_cookie);
            if($result == "Unauthorized"){

                $result = $this->request_try($method,$endpoint,$data,$save_cookie,$use_cookie);
            }else{
                return $result;
            }
        } catch (\Throwable $th) {
            //throw $th;
            error_log( "nftpay payments request th ". print_r( $th, true ) );
            return false;

        }

    }
      /**
       * Initializes all of the partial classes.
       *
       * @param string $method post, get or put
       * @param string $endpoint endpont to send request to
       * @param object $data payload to post to end point
       * @param bool $save_cookie wether or not to save the session cookie
       *                                                                  
       */

      function request_try($method,$endpoint,$data,$save_cookie = false, $use_cookie = true){
          $method = strtolower($method);
          (array) $data;
          $nftpay_api_base_url = $this->nftpay_api_base_url;
          $nftpay_api_url = $nftpay_api_base_url.$endpoint;

          $apiKey = $this->get_option('nftpay_apiKey');
          $apiSecret = $this->get_option('nftpay_apiSecret');

          $apiKeyTest = $this->get_option('nftpay_apiKeyTest');
          $apiSecretTest = $this->get_option('nftpay_apiSecretTest');

          error_log( "nftpay payments request_try apiSecretTest ". print_r( $apiSecretTest, true ) );


          $nftpay_environment = get_option('nftpay_environment');
          $this->testmode = false;
          if($nftpay_environment !== "production"){
            $apiKey = $apiKeyTest;
            $apiSecret = $apiSecretTest;
            $this->testmode = true;

          }
          
          $cookie =  'Cookie:'.$_SESSION["nftpay_cookie"];
      
          $cURLConnection = curl_init();
          curl_setopt($cURLConnection, CURLOPT_URL, $nftpay_api_url);
          curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);

          if($method == "post"){
              // curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
              curl_setopt($cURLConnection, CURLINFO_HEADER_OUT, true);
              curl_setopt($cURLConnection, CURLOPT_POST, true);
              curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, $data);

          }

          if($save_cookie){
              curl_setopt($cURLConnection, CURLOPT_HEADER, 1);
          }else if($_SESSION["nftpay_cookie"] && $use_cookie){
              curl_setopt($cURLConnection, CURLOPT_COOKIE, $_SESSION["nftpay_cookie"] );
          }
          error_log( "nftpay payments request_try apiSecret ". print_r( $apiSecret, true ) );


          curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, [
              "Authorization: Bearer $apiSecret"
          ]);
          

      
          $data_response = curl_exec($cURLConnection);
          error_log( "nftpay payments request_try data_response ". print_r( $data_response, true ) );


          if($data_response == "Unauthorized"){
              return $data_response;
          }

          $jsonArrayResponse = json_decode($data_response);

          if($save_cookie){
              $header_size = curl_getinfo($cURLConnection, CURLINFO_HEADER_SIZE);
              $header = substr($data_response, 0, $header_size);
              $body = substr($data_response, $header_size);
          


              $ResponseHeader = explode("\n",trim(mb_substr($data_response, 0, CURLINFO_HEADER_SIZE)));
              unset($ResponseHeader[0]);
              $aHeaders = array();
              foreach($ResponseHeader as $line){
              list($key,$val) = explode(':',$line,2);
                  $aHeaders[strtolower($key)] = trim($val);
              }

              $url =  'https://nftpay-staging.herokuapp.com/api/v1/balances';
     
              session_start();
              $_SESSION["nftpay_cookie"] = $aHeaders["set-cookie"];

              $jsonArrayResponse = json_decode($body);


          }
          curl_close($cURLConnection);

          return $jsonArrayResponse;

      }


    }
  }
} catch (\Throwable $th) {
  //throw $th;
  error_log("Payment error - ".$th);
}
