/**
 * <card-nav>
 * -----------------------------------------------------------------------------
 * Crard nav.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('cardNav', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'activeTab',// active nav / page
      'admin',// active nav / page
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {

      };
    },

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
      <nav>
          <div v-if="admin" class="nav nav-tabs" id="nav-tab" role="tablist">
              <a v-bind:class="[activeTab == 'accounts' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-accounts-tab"  href="/admin/accounts" aria-controls="nav-accounts" aria-selected="true">Accounts</a>
              <a  v-bind:class="[activeTab == 'account' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-activity-tab"  href="/admin/account" aria-controls="nav-activity" aria-selected="false">Activity</a>
              <a v-bind:class="[activeTab == 'transfer' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-transfers-tab"  href="/admin/transfer" aria-controls="nav-transfers" aria-selected="false">Transfer Funds</a>
              <a v-bind:class="[activeTab == 'cards' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-cards-tab"  href="/admin/cards" aria-controls="nav-cards" aria-selected="false">Cards</a>
              <!-- <a v-bind:class="[activeTab == 'manage' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-manage-tab" data-toggle="tab" href="/cards/manage" aria-controls="nav-manage" aria-selected="false">Manage</a> -->
          </div>
          <div v-else class="nav nav-tabs" id="nav-tab" role="tablist">
              <a v-bind:class="[activeTab == 'accounts' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-accounts-tab"  href="/cards/accounts" aria-controls="nav-accounts" aria-selected="true">Accounts</a>
              <a  v-bind:class="[activeTab == 'account' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-activity-tab"  href="/cards/account" aria-controls="nav-activity" aria-selected="false">Activity</a>
              <a v-bind:class="[activeTab == 'transfer' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-transfers-tab"  href="/cards/transfer" aria-controls="nav-transfers" aria-selected="false">Transfer Funds</a>
              <a v-bind:class="[activeTab == 'cards' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-cards-tab"  href="/cards/cards" aria-controls="nav-cards" aria-selected="false">Cards</a>
              <!-- <a v-bind:class="[activeTab == 'manage' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-manage-tab" data-toggle="tab" href="/cards/manage" aria-controls="nav-manage" aria-selected="false">Manage</a> -->
          </div>
      </nav>

      
    `,

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
      //   console.log("this.at",this.totals);
        console.log("this.activeTab",this.activeTab);
        

    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
  

    }

  });

});

