/**
 * <account>
 * -----------------------------------------------------------------------------
 * account.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('account', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        formData: { },

        paymentDecimal:"",
        factor:"",
        adminAccount:{},
        exchangeError:false,
        error:{},
        accountIdFilter:[],
        accountId:"",
        account:{},
        accounts:[],
        transactions:[],
        appToken:{},
        stableToken:{},
    
        loadingAccount: true,
        cloudLoadingError: '',
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="account-component">
        <div v-if="loadingAccount" class="text-center">
            <h1>Your balances are being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingAccount" class="btn btn-primary mint">Refesh</ajax-button>
        </div>
        <div v-else="">
            <card-nav active-tab="account" :admin="adminAccount"></card-nav>
            <div class="tab-content" id="nav-tabContent">
            <!-- {{transactions}} -->
            <div class="tab-pane fade show active nav-account" id="nav-activity" role="tabpanel" aria-labelledby="nav-activity-tab">
                <!-- add 
                    account activity
                    //date
                    //description
                    //account type
                    //category/ transaction type
                    //ammount
                    //account select
                    -->
                <div class="row" >
                    <div class="col-md-6" >
                    <h3>Account Activity</h3>
                        <!-- {{account}} -->
                        <!-- {{transactions}} -->
                        <!-- {{accounts}} -->

                    
                    </div>
                    <div class="col-md-6 text-right" >
                    <select id="accountId" v-model.trim="formData.accountId" @change="changeAccountId" class="form-control title accountId" >
                        <!-- <option v-for="account in accounts" :value="account.id" v-if="accountIdFilter.includes(account.bankAccountId) -->
                        <!-- <option v-for="account in accounts" :value="account.id" v-if="
                            account.ownerType == 'token'
                            && account.currency.appId == stableToken.appId">  -->
                        <option v-for="account in accounts" :value="account.id" v-if="
                            account.ownerType == 'token'
                            && accountIdFilter.includes(account.bankAccountId)"  > 
                            {{account.wallet.name }} ({{account.name}}) - $ {{Math.floor(account.spendingBalance * factor) / factor}}  {{account.currency.symbol}}
                        </option>
                    </select>
                    </div>
                </div>
                <table class="table">
                    <thead>
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Description</th>
                        <th scope="col">Account</th>
                        <th scope="col">Category</th>
                        <th scope="col">Amount</th>
                    </tr>
                    </thead>
                    <tbody>
            
                    <tr v-for="transaction in transactions" class="">
                        <!-- {{transaction}} -->
                        <td class="createdAt"><js-timestamp :at="transaction.createdAt" ></js-timestamp> </td>
                        <td class="note">{{transaction.note}} </td>
                        <td class="type">{{account.name}}</td>
                        <td class="category">{{transaction.type}}</td>
                        <td v-bind:class="[transaction.toAccount == account.id ? 'totalAmount text-success' : 'totalAmount text-danger']" >
                            <span v-if="transaction.fromAccount == account.id" >-</span>
                            {{Math.floor(transaction.totalAmount * factor) / factor}}
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            
            </div>

        </div>

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.currency = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          this.formData.accountId = this.accountId;
          await this.listen();  

    },
    mounted: async function() {
        //…


    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        listen: async function() {
          // The auto-connecting socket is exposed as `io.socket`.
    
          // Use `io.socket.on()` to listen for the 'hello' event:
          // io.socket.on(this.market.id, function (data) {
          //   console.log('Socket `' + data.id + '` joined the party!');
          // });
          var Account = this;
        
          //show loading// syincing
          this.loadingAccount = true;
          // $(".market .market-pg").hide().addClass("d-none");
          // $(".market .loading").show().removeClass("d-none");
          // get market 
          
          // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
          // .tolerate(()=>{
          //   this.cloudLoadingError = true;
          // });
    
          // if(data.flag){
          //   _.extend(this, data);
          //   this.loadingAccount = false;
    
          // }else if(data.mustLogin){
          //   window.location.href = data.redirect;
          // } else{
          //   this.loadingAccount = false;
          // }

          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/api/account',
              data: {userType:this.userType,accountId:this.accountId},
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                    if(resData.flag){
                        _.extend(Account, resData);
                        Account.loadingAccount = false;
            
                      }else if(resData.mustLogin){
                        window.location.href = resData.redirect;
                      } else{
                        Account.loadingAccount = false;
                      }
    
                }
              });
    
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/account',
        //       data: {userType:this.userType,accountId:this.accountId},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(Account, resData);
        //         Account.loadingAccount = false;
    
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Account.loadingAccount = false;
        //       }
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
        },
        changeAccountId: async function(e) {
          var accountId = $("#accountId").val();
          window.location = '/cards/account/'+accountId;
    
        },
      }



  });

});

