/**
 * <transfer>
 * -----------------------------------------------------------------------------
 * transfer.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('transfer', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        isBillingEnabled: false,

        hasBillingCard: false,

        // Syncing/loading states for this page.
        syncingOpenCheckout: false,
        syncingUpdateCard: false,
        syncingRemoveCard: false,
        checkoutAction:"depositUnits",
        toAccountId:"",
        
        // Form data
        formData: { 
          transferType: "internal"
        },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // Syncing / loading state
        syncing: false,

        // Server error state
        cloudError: '',

        // Success state when form has been submitted
        cloudSuccess: false,

        userType:"",
        primeTrustForcePayment:"",
        adminAccount:{},
        exchangeError:"",
        error:{},
        appTokenAccounts:[],
        spendAccountIdFilter:[],
        accountIdFilter:[],
        tokens:[],
        spendAccounts:[],
        internalAccounts:[],
        accounts:[],
        stripePublishableKey: "",
        appToken:{},
        stableToken:{},
        trasnferView:"",
        environment:"",

        loadingTransfer: true,
        cloudLoadingError: '',
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="transfer-component">
      <div v-if="loadingTransfer" class="text-center">
        <h1>Your balances are being loaded...</h1>
        <ajax-button type="submit" :syncing="loadingTransfer" class="btn btn-primary mint">Refesh</ajax-button>
      </div>
      <div v-else=""> 
        <card-nav active-tab="transfer" :admin="adminAccount"></card-nav>
        <div class="tab-content" id="nav-tabContent">
          <div class="tab-pane fade nav-transfers show active" id="nav-transfers" role="tabpanel" aria-labelledby="nav-transfers-tab">
              <!-- 
              transfeers
                internal transfer
                  //from 
                  //to
                // amount
                external transfer
                  //from 
                  to
                  add account
                  //amount
                  //note
                other people
                  //from 
                  to
                  //amount
                  //note
              -->
              <div class="row" >
                  <div class="col-md-6" >
                    <h3>Transfer</h3>
                    <!-- {{accounts}} -->
                    <!-- {{me.isSuperAdmin}} -->
                    <!-- {{spendAccounts}} -->
                    <!-- {{appTokenAccounts}} -->
                    <!-- {{spendAccounts[0].id}} -->

                  </div>
                  <div class="col-md-6 text-right" >
                    <!-- <select>
                      <option v-for="token in tokens" :value="token.id"> {{token.name}}</option>
                    </select> -->
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-12">
                    <ajax-form action="transfer" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">
                      
                      <div v-if="trasnferView !== 'exchange'" class="form-group">
                        <label for="transfer-type">Type</label>
                        <select class="form-control" @change="changeTransferType" id="transferType" type="text"  :class="[formErrors.transferType ? 'is-invalid' : '']" v-model.trim="formData.transferType" focus-first>
                          <option v-if="trasnferView == 'exchange'" selected="selected" value="exchange">Payment</option>
                          <option v-else selected="selected" value="payment">Payment</option>
                          <option v-if="trasnferView !== 'exchange'" value="internal">Internal Transfer</option>
                          <option v-if="trasnferView !== 'exchange'" value="deposit">Deposit</option>
                          <option value="external">Withdrawal</option>
                        </select>
                        <div class="invalid-feedback" v-if="formErrors.transferType">Select this transfer type.</div>
                      </div>
                      <div class="form-group transferType internal external" style="display:none">
                        <label for="fromAccountId">From</label>
                        <select v-model.trim="formData.fromAccountId" class="form-control title" id="fromAccountId" type="text"  :class="[formErrors.fromAccountId ? 'is-invalid' : '']">
                          <option v-for="account in internalAccounts"  :value="account.id" v-if=" account.ownerType == 'token' "> {{account.wallet.name }} ({{account.name}}) - {{account.spendingBalance.toFixed(2)}} {{account.displaySymbol}} </option>
                        </select>
                        <div class="invalid-feedback" v-if="formErrors.fromAccountId">Select which account this transfer is coming fromAccountId.</div>
                      </div>
                      <div class="form-group transferType payment" >
                        <label for="fromAccountId">From</label>
                        <select v-if="trasnferView == 'exchange'"  v-model.trim="formData.fromSpendAccountId" class="form-control title" id="fromSpendAccountId" type="text"  :class="[formErrors.fromSpendAccountId ? 'is-invalid' : '']">
                          <option v-for="spendAccount in spendAccounts" v-if="spendAccount.ownerType == 'token' "  :value="spendAccount.id"> {{spendAccount.wallet.name }} ({{spendAccount.name}}) - {{spendAccount.spendingBalance.toFixed(2)}} {{spendAccount.currency.name}}  </option>
                        </select>
                        <select v-else v-model.trim="formData.fromSpendAccountId" class="form-control title" id="fromSpendAccountId" type="text"  :class="[formErrors.fromSpendAccountId ? 'is-invalid' : '']">
                          <option v-for="spendAccount in spendAccounts" v-if="spendAccountIdFilter.includes(spendAccount.bankAccountId) 
                          && spendAccount.ownerType == 'token' "  :value="spendAccount.id"> {{spendAccount.wallet.name }} ({{spendAccount.name}}) - {{spendAccount.spendingBalance.toFixed(2)}} {{spendAccount.displaySymbol}}  </option>
                        </select>
                        
                        <div class="invalid-feedback" v-if="formErrors.fromAccountId">Select which account this transfer is coming fromAccountId.</div>
                      </div>
                      
                      <div class="form-group transferType external" style="display:none">
                        <!-- <add-card label="To" class="pl-4"></add-card> -->
                        <label for="accountNumber">Account Number</label>
                        <input v-model.trim="formData.accountNumber" class="form-control" id="accountNumber" type="text"  :class="[formErrors.accountNumber ? 'is-invalid' : '']" v-model.trim="formData.accountNumber" >
                        <div class="invalid-feedback" v-if="formErrors.accountNumber">Please enter a valid email address.</div>
                        <label for="routingNumber">Routing Number</label>
                        <input v-model.trim="formData.routingNumber" class="form-control" id="routingNumber" type="text"  :class="[formErrors.routingNumber ? 'is-invalid' : '']" v-model.trim="formData.routingNumber" >
                        <div class="invalid-feedback" v-if="formErrors.routingNumber">Please enter a valid email address.</div>

                      </div>
                      <div class="form-group transferType internal" style="display:none" >
                        <label for="toInternal">To</label>
                        <select v-model.trim="formData.toInternal" class="form-control title" id="toInternal" type="text" name="toInternal" :class="[formErrors.toInternal ? 'is-invalid' : '']" >
                          <option v-for="account in internalAccounts" :value="account.id" v-if="account.ownerType == 'token'
                          && account.currency.id == stableToken.id"> {{account.wallet.name }} ({{account.name}}) - {{account.spendingBalance.toFixed(2)}} {{account.displaySymbol}}  </option>
                        </select>
                        <div class="invalid-feedback" v-if="formErrors.toInternal">Select where this deposit is going.</div>
                      </div>
                      <div class="form-group transferType deposit" style="display:none" >
                        <label for="toDeposit">To</label>
                        <select v-model.trim="formData.toDeposit" class="form-control title" id="toDeposit" type="text" name="toDeposit" :class="[formErrors.toDeposit ? 'is-invalid' : '']" >
                          <option v-for="account in internalAccounts" :value="account.id" v-if="account.ownerType == 'token'
                          && account.currency.id == stableToken.id"> {{account.wallet.name }} ({{account.name}}) - {{account.spendingBalance.toFixed(2)}} {{account.displaySymbol}}  </option>
                        </select>
                        <div class="invalid-feedback" v-if="formErrors.to">Select where this deposit is going.</div>
                      </div>
                      <div class="form-group transferType payment">
                        <label for="toPayment">To</label>
                        <input v-if="trasnferView == 'exchange'" v-model.trim="formData.toPayment" class="form-control" id="toPayment" type="text"  :class="[formErrors.toPayment ? 'is-invalid' : '']" v-model.trim="formData.toPayment" placeholder="Email">
                        <input v-else v-model.trim="formData.toPayment" class="form-control" id="toPayment" type="text"  :class="[formErrors.toPayment ? 'is-invalid' : '']" v-model.trim="formData.toPayment" placeholder="Email Or Coin Symbol">
                        <div class="invalid-feedback" v-if="formErrors.toPayment">Please enter a valid email address.</div>
                      </div>
                      
                      <div class="form-group">
                        <label for="amount">Amount</label>
                        <input v-model.trim="formData.amount" class="form-control" id="amount" type="number"  :class="[formErrors.amount ? 'is-invalid' : '']" min="0" >
                        <div class="invalid-feedback" v-if="formErrors.amount">Please enter a valid amount.</div>
                      </div>
                      <div class="form-group transferType payment deposit external" > 
                        <label for="note">Note</label>
                          <textarea v-model.trim="formData.note" class="form-control" id="note" name="note"  v-model.trim="formData.note"  aria-describedby="noteHelp" ></textarea>
                          <div class="invalid-feedback" v-if="formErrors.note">Please enter a note.</div>
                      </div>
                      
                      <p class="text-danger" v-if="cloudError==='emailAlreadyInUse'"><small>It looks like there's already an account with your email address. If you forgot your password, you can recover it <a href="password/forgot">here</a>.</small></p>
                      <p class="text-danger" v-else-if="cloudError"><small>An error occured while processing your request. Please check your information and try again, or <a href="/support">contact support</a> if the error persists.</small></p>
                      <div class="form-group">
                        <% if(primeTrustForcePayment) { %>
                          <ajax-button type="submit" :syncing="syncing" class="btn-dark btn-lg btn-block">Submit Transfer</ajax-button>
                        <% } else if(me&&!me.primeTrustKycComplete) { %>
                          <a href="/kyc" class="btn-dark btn-lg btn-block text-center">Refresh Verification Status</a>
                        <% } else{ %>
                          <ajax-button type="submit" :syncing="syncing" class="btn-dark btn-lg btn-block">Submit Transfer</ajax-button>
                        <% } %>
                      </div>
                    </ajax-form>

                    <div class="form-group transferType deposit" style="display:none">
                      <div :class="stableToken.shopifyBuyProductHandle +' '+ stableToken.symbol + '  united-product united-token-product stable-token col-md-6 text-right'" >
                        <button class="btn btn-sm btn-primary cart" style="display:none">Buy Units</button>
                        <input type="hidden" class="shopifyVariantId" value="" >
                        <!-- <input type="hidden" class="productId" :value="stableToken.productId" > -->
                        <!-- <input type="hidden" class="title" :value="stableToken.name" > -->
                        <!-- <input type="hidden" class="img" :value="stableToken.logo" > -->
                        <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                        <input type="hidden" class="variantPrice" :value="stableToken.price" >
                        
                        <input type="hidden" class="form-control orderNote"  v-model.trim="formData.note"></input>


                        <input type="hidden" class="tokenId" :value="stableToken.id" >
                        <input type="hidden" class="productId" :value="stableToken.buyProductId" >
                        <!-- <input type="hidden" class="accountId" :value="balance.id" > -->
                        <input type="hidden" class="price" :value="stableToken.price" >
                        <input type="hidden" class="market" :value="stableToken.market" >
                        <input type="hidden" class="title" :value="stableToken.name" >
                        <input type="hidden" class="img" :value="stableToken.logo" >
                        <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                        <input type="hidden" class="variantPrice" :value="stableToken.price" >
                        <!-- <input type="hidden" class="quantity" value="1" > -->
                        <input type="hidden" class="type" value="token" >


                        <!-- {{stableToken.price}} -->
                        <input type="hidden" class="quantity" value="1" >
                        <!-- <cart-modal id="cart" :environment="environment" :syncing="syncing" checkout-redirect="/cards/" :checkout-action="checkoutAction" :to-account-id="toAccountId" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
                        <token-cart-modal id="token-cart" :environment="environment" :syncing="syncing" checkout-redirect="/cards/transfer" :checkout-action="checkoutAction" :to-account-id="toAccountId" product-class="united-token-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>
                        <!-- <token-cart-modal id="token-cart" :environment="environment" checkout-redirect="/balances/" checkout-action="buyUnits" :payment-methods="paymentMethods" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal> -->

                      </div>
                    </div>

                  
                  </div>
                </div>
                <div class="row">
                  <div style="display:none" class="alert alert-secondary success msg col-md-12" >
                    Your transfer was successfully complete.
                  </div>
                  <div style="display:none" class="alert alert-secondary error msg col-md-12" >
                    There was an error completing your transfer.
                  </div>
                </div>


          </div>

          
        </div>

      </div>
    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.currency = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          this.formData.transferType = this.trasnferView == "exchange" ? "exchange":"payment"
          this.formData.fromSpendAccountId = this.trasnferView == "exchange" && this.spendAccounts[0] ? this.spendAccounts[0].id:undefined;
          $(".msg").hide();
          await this.listen();  

    },
    mounted: async function() {
        //…
      $(".msg").hide();



    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Transfer = this;
      
        //show loading// syincing
        this.loadingTransfer = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getTransfer.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingTransfer = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingTransfer = false;
        // }

        var csrf = await CSRF.token();
          var apiRequestHeader = {
              'X-CSRF-Token':csrf._csrf,
                // 'cookie':cookie
            };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/api/transferAccounts',
              data: {tradeType:this.tradeType,symbol:this.symbol},
                headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                  if(resData.flag){
                    _.extend(Transfer, resData);
                    Transfer.loadingTransfer = false;
                    $(".msg").hide();
        
                  }else if(resData.mustLogin){
                    window.location.href = resData.redirect;
                  } else{
                    Transfer.loadingTransfer = false;
                  }
    
                }
              });
  
  
        // var csrf = await CSRF.token();
        //   console.log('csrf',csrf);
        //   var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        // io.socket.request({
        //     method: 'post',
        //     url: '/api/transferAccounts',
        //     data: {tradeType:this.tradeType,symbol:this.symbol},
        //     headers: apiRequestHeader
        //   }, function (resData, jwres) {
  
        //     if(resData.flag){
        //       _.extend(Transfer, resData);
        //       Transfer.loadingTransfer = false;
        //       $(".msg").hide();
  
        //     }else if(resData.mustLogin){
        //       window.location.href = resData.redirect;
        //     } else{
        //       Transfer.loadingTransfer = false;
        //     }
            
        //     if (jwres.error) {
        //       console.log(jwres.statusCode); // => e.g. 403
        //       this.cloudLoadingError = true;
  
        //       return;
        //     }
          
        //     console.log(jwres.statusCode); // => e.g. 200
          
        // });
  
      },
      changeTransferType: async function(e) {
        var type = $("#transferType").val();
        // var isFreeze = $(e.target).hasClass("freeze");
        // var isClose = $(e.target).hasClass("close");
        // var isView = $(e.target).hasClass("view");
        // var isOpen = $(e.target).hasClass("open");
        $(".nav-transfers .transferType").hide();
        $(".nav-transfers ."+type).show();
      },
      submittedForm: async function(result) {
        console.log("submittedForm");
        this.syncing = true;
        if(result.flag){
          //show success emssage
          $(".success").show();
        }else{
          // show error message
          $(".error").show();
          this.syncing = false;
  
        }
  
        setTimeout(function(){ $(".msg").hide(); }, 8000);
  
        if(result.flag){
          //show success emssage
          // window.location = '/cards';
          location.reload();
        }
      },
  
      handleParsingForm: function() {
        // Clear out any pre-existing error messages.
        this.formErrors = {};
  
        var argins = this.formData;
  
        // Validate type:
        if(!argins.transferType) {
          this.formErrors.transferType = true;
        }
        
        // Validate description:
        if(!argins.amount) {
          this.formErrors.amount = true;
        }
        if(argins.transferType == "payment"){
          var validToPayment = this.validPhoneOrEmail(argins.toPayment);
          console.log("validToPayment",validToPayment);
          if(!validToPayment){
            this.formErrors.toPayment = true;
          }
        }else{
          
        }
        
        // Validate name:
        if(argins.transferType == "deposit"){
          if(!argins.toDeposit) {
            this.formErrors.toDeposit = true;
          }
        }else if(argins.transferType == "internal"){
          if(!argins.toInternal) {
            this.formErrors.toInternal = true;
          }
        }else if(!argins.fromAccountId) {
          this.formErrors.fromAccountId = true;
        }
        if(argins.transferType == "external"){
          if(!argins.accountNumber) {
            this.formErrors.accountNumber = true;
          }
          if(!argins.routingNumber) {
            this.formErrors.routingNumber = true;
          }
        }
  
  
        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }
  
        if (argins.transferType == "deposit") {
          //start synicing
          this.syncing = true;
          this.toAccountId =  argins.toDeposit;
          // add depposite amount to cart
          $(".stable-token .quantity").val(argins.amount);
          // check out
        
          setTimeout(function(){ $(".stable-token .cart" ).click(); }, 1000);
          setTimeout(function(){ $(".checkout").click(); }, 3000);
          return;
        }
        this.syncing = true;
  
        return argins;
      },
      validPhoneOrEmail: function(phoneOrEmail){
        var validEmail = false;
        var validPhone = false;
        var validSymbol = false;
        //validate email
        phoneOrEmail =  phoneOrEmail.toLowerCase();
        var emailReg = /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/i;
        if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
        {
          console.log('Please enter a valid email address.');
          validEmail = false;
        }else{
          validEmail = true;
          this.formData.toPaymentMethod = "email";
          console.log('valid email address.');
  
        }
  
        //validate phone
        var intRegex = /[0-9 -()+]+$/;
        if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
        {
          console.log('Please enter a valid phone number.');
          validPhone = false;
        }else{
          validPhone = true;
          this.formData.toPaymentMethod = "phone";
          console.log('valid phone.');
        }
  
        //validate phone
        var intRegex = /^[a-zA-Z0-9]+$/;
        if( !intRegex.test(phoneOrEmail) )
        {
          console.log('Please enter a valid symbol.');
          validSymbol = false;
        }else{
          validSymbol = true;
          this.formData.toPaymentMethod = "symbol";
          console.log('valid symbol.');
        }
  
        if(!validPhone && !validEmail && !validSymbol){
          this.formData.toPaymentMethod = undefined;
          return false;
        }else{
          this.formData.fromAccountId = this.formData.fromSpendAccountId;
          return true;
        }
        
      },
    }



  });

});

