jQuery(function() {
    if(jQuery(".yoh-balances").length > 0){

      var vm = new Vue({ 
          el: '.yoh-balances',
        //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
        //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
        //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
        data: {
          //…
          paymentMethods:[],
          balances:[],
          refreshUrl:'',
          isBillingEnabled: false,
      
          hasBillingCard: false,
      
          // Syncing/loading states for this page.
          syncingOpenCheckout: false,
          syncingUpdateCard: false,
          syncingRemoveCard: false,
          // Form data
          formData: { 
            transferType: "internal"
          },
      
          // For tracking client-side validation errors in our form.
          // > Has property set to `true` for each invalid property in `formData`.
          formErrors: { /* … */ },
      
          // Syncing / loading state
          syncing: false,
      
          // Server error state
          cloudError: '',
      
          // Success state when form has been submitted
          cloudSuccess: false,
        },
      
        //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
        //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
        //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
        beforeMount: function() {
          // Attach any initial data from the server.
          _.extend(this, YOH_SHOW_LOCALS);
          this.refreshUrl = this.baseUrl;
        },
        mounted: async function() {
          this.refresh();
          var Balances = this;
          jQuery(".deposit").on("click", function(event) {
            var currency = jQuery(event.target).attr("href");
            console.log("currency",currency);
            Balances.confirmDeposit(currency);
        });
        jQuery(".withdraw").on("click", function(event) {
              var currency = jQuery(event.target).attr("href");
              console.log("currency",currency);
              Balances.confirmWithdraw(currency);
          });
          jQuery(".send").on("click", function(event) {
              var currency = jQuery(event.target).attr("href");
              console.log("currency",currency);
              Balances.confirmSend(currency);
          });
      
        },
      
        //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
        //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
        //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
        methods: {
          refresh: async function() {
            var page = this;
            jQuery.ajax({
                  type: "GET",
                  url: this.refreshUrl+"/api/balances",
                  data: {}, // serializes the form's elements.
                  success: function(data, textStatus, request)
                  {
                      console.log('got the data!!!',data); // show response from the php script.
                      var balances = data.balances;
                      page.render(balances);
      
                  }
                });
            // window.location = '/';
          },
          confirmSend: async function(currency) {
            var Balances = this;
            jQuery(".modal .action").html("send");
            jQuery(".modal .currency").html(currency);
            jQuery(".modal .withdraw-btn, .modal .deposit-btn").hide();
            jQuery(".modal .send-btn").show();
            var accountId = jQuery("."+currency +" .accountId").val();
            console.log("accountId",accountId);
            console.log("currency",currency);
            this.formData.fromAccountId = accountId;
            this.formData.currency = currency;
            console.log("this.formData.fromAccountId",this.formData.fromAccountId);
            this.formData

      
            Balances.withdrawMax(currency);
            this.formData.confirm = false;
            this.formData.transferType = "exchange";
            this.formData.note = jQuery("#note").val();
            jQuery(".transferSend").off("click").on("click", function(event) {
              this.syncing = true;
              Balances.send(currency);
            });
          },
          confirmDeposit: async function(currency) {
            var Balances = this;
            jQuery(".modal .action").html("deposit");
            jQuery(".modal .currency").html(currency);
            jQuery(".modal .withdraw-btn").hide();
            jQuery(".modal .withdraw-btn, .modal .send-btn").hide();
            jQuery(".modal .deposit-btn").show();
            jQuery(".confirmDeposit").off("click").on("click", function(event) {
              console.log("confirm deposit cliked");
              Balances.depositAddress(currency);
            });
          },
          confirmWithdraw: async function(currency) {
            var Balances = this;
            jQuery(".modal .action").html("withdraw");
            jQuery(".modal .currency").html(currency);
            jQuery(".modal .deposit-btn, .modal .send-btn").hide();
      
            jQuery(".modal .withdraw-btn").show();
            Balances.withdrawMax(currency);
            jQuery(".transferWithdraw").off("click").on("click", function(event) {
              Balances.withdraw(currency);
            });
          },
          withdrawMax: async function(currency) {
            var Balances = this;
            var balance = jQuery("."+currency +" .balance").html();
            var locked = jQuery("."+currency +" .locked").html();
            balance =  parseFloat(balance);
            locked =  parseFloat(locked);
            // var withdrawMax = balance - locked;
            var withdrawMax = balance;
            console.log("balance",balance);
            console.log("locked",locked);
            console.log("withdrawMax",withdrawMax);
            jQuery(".withdrawMaxSpan").html(withdrawMax);
            jQuery(".withdrawMax").off("click").on("click", function(event) {
              console.log("withdrawMax",withdrawMax);
              jQuery("#withdrawAmount").val(withdrawMax);
              Balances.formData.amount = withdrawMax;
              console.log("withdrawMax Balances.formData.amount",Balances.formData.amount);
      
            });
          },
          send: async function(currency){
              console.log("send " + currency);
              var Balances = this;
              var send_data = {};
              this.syncing = true;


            send_data.withdrawAmount = Balances.formData.amount;
            send_data.amount = Balances.formData.amount;
            send_data.toPayment =  Balances.formData.toPayment;
            send_data.fromAccountId = Balances.formData.fromAccountId;
            send_data.transferType = "exchange";
            
            send_data.note = jQuery("#note").val();
            send_data.toPaymentMethod = Balances.formData.toPaymentMethod;
            console.log('send send_data',send_data);

              
              
              var csrf = await CSRF.token();
              console.log('csrf',csrf);
              console.log('currency',currency);
              var apiRequestHeader = {
                'X-CSRF-Token':csrf._csrf,
                  // 'cookie':cookie
              };
              jQuery.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
                url: '/wp-json/yohshow/api/v1/balances/send',
                data: send_data, // serializes the form's elements.
                headers:apiRequestHeader,
                success: function(data, textStatus, request)
                {
                    data = JSON.parse(data);
                    this.syncing = true;

                    console.log('got balance the data!!!',data); // show response from the php script.
                    if(data.flag){
                      location.reload();
                      
                    }
                  //   var balances = data.balances;
                  //   page.render(balances);
    
                }
              });


            
          },
          withdraw: async function(currency){
            console.log("withdraw " + currency);
      
            var Balances = this;
            var withdrawAmount = jQuery("#withdrawAmount").val();
            var withdrawAddress = jQuery("#withdrawAddress").val();
            
            var csrf = await CSRF.token();
            console.log('csrf',csrf);
            console.log('currency',currency);
            var apiRequestHeader = {
              'X-CSRF-Token':csrf._csrf,
                // 'cookie':cookie
            };
          return jQuery.ajax({
            method: 'post',
            url: '/balances/withdraw',
            data: {currency:currency,address:withdrawAddress,amount:withdrawAmount},
            headers: apiRequestHeader
            }, function (resData, jwres) {
            console.log('resData',resData); // => e.g. 403
            window.location.href = "/balances";
            // jQuery("#transfer .withdraw").html(address.address);
            // if(resData.flag){
            //   // Balances.refresh(resData.market);
            // }
      
      
            if (jwres.error) {
              console.log(jwres.statusCode); // => e.g. 403
              return;
            }
          
            console.log(jwres.statusCode); // => e.g. 200
          
          });
          
        },
          depositAddress: async function(currency){
            console.log("depositAddress " + currency);
      
            var Balances = this;
            
            var csrf = await CSRF.token();
            console.log('csrf',csrf);
            console.log('currency',currency);
            var apiRequestHeader = {
              'X-CSRF-Token':csrf._csrf,
                // 'cookie':cookie
            };
          return jQuery.ajax({
            method: 'get',
            url: '/balances/address',
            data: {currency:currency},
            headers: apiRequestHeader
          }, function (resData, jwres) {
            var address = resData.address;
            console.log('balance',address); // => e.g. 403
            jQuery("#transfer .depositAddress").html(address.address);
            // if(resData.flag){
            //   // Balances.refresh(resData.market);
            // }
      
      
            if (jwres.error) {
              console.log(jwres.statusCode); // => e.g. 403
              return;
            }
          
            console.log(jwres.statusCode); // => e.g. 200
          
          });
          
        },
          render: async function(balances) {
            jQuery.each( balances, function( id, market ) {
              console.log( id + ": " + market );
              console.log( jQuery("#"+id).length );
              var ticker = market.ticker;
              /*
                avg_price: "0.0"
                buy: "0.0"
                high: "0.0"
                last: "0.0"
                low: "0.0"
                open: "0.0"
                price_change_percent: "+0.00%"
                sell: "0.0"
                vol: "0.0"
                volume: "0.0"
              */
            //  jQuery(".tickers").append(
            //     jQuery("<div id='"+id+"'>")
            //       .append("<h3 class='avg_price'>"+ticker.avg_price+"</h3>")
            //   );
      
              // var tr = jQuery("<tr id='"+id+"'>");
              // jQuery("<td class='avg_price'>"+ticker.avg_price+"</td>")
              // console.log("tr",tr.html());
              // jQuery(".tickers").append(tr);
              // console.log( jQuery(".tickers").length, "tickets length" );
      
            });
          },
          listen: async function() {
            
            // window.location = '/';
          },
          //transer/send 
          changeTransferType: async function(e) {
            var type = jQuery("#transferType").val();
            // var isFreeze = jQuery(e.target).hasClass("freeze");
            // var isClose = jQuery(e.target).hasClass("close");
            // var isView = jQuery(e.target).hasClass("view");
            // var isOpen = jQuery(e.target).hasClass("open");
            jQuery(".nav-transfers .transferType").hide();
            jQuery(".nav-transfers ."+type).show();
          },
          submittedForm: async function() {
            console.log("submittedForm");
            window.location = '/balances';
          },
      
          handleParsingForm: async function() {
            // Clear out any pre-existing error messages.
            console.log("handleParsingForm");
            this.formErrors = {};
      
            var argins = this.formData;
            var currency = argins.currency;
      
            var balance = jQuery("."+currency +" .balance").html();
            balance = parseFloat(balance);
            console.log("balance",balance);
            
            if(!argins.amount || argins.amount == 0 ) {
              this.formErrors.amount = true;
            }
            if(!argins.toPayment) {
              this.formErrors.toPayment = true;
            }
            if(argins.amount > balance){
              this.formErrors.tooMuch = true;
      
              console.log("balance too much ",argins.amount,balance);
            }
            console.log("argins.toPayment",argins.toPayment);
      
            var validToPayment = this.validPhoneOrEmail(argins.toPayment);
            console.log("validToPayment",validToPayment);
            if(!validToPayment){
              this.formErrors.toPayment = true;
            }
      
            // If there were any issues, they've already now been communicated to the user,
            // so simply return undefined.  (This signifies that the submission should be
            // cancelled.)
            if (Object.keys(this.formErrors).length > 0) {
              return;
            }else{
              if(!argins.confirm){
                jQuery('#confirmModal').modal("show");
                jQuery('#transferModal').modal("hide");
                this.formData.confirm = true;
      
              }
            }
            this.formData.transferType = "exchange";
            
            this.formData.note = jQuery("#note").val();
            // var sendResult = await this.send(currency);
            // console.log("sendResult",sendResult);
            return argins;
          },
          validPhoneOrEmail: function(phoneOrEmail){
            var validEmail = false;
            var validPhone = false;
            //validate email
            phoneOrEmail =  phoneOrEmail.toLowerCase();
            var emailReg = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
            if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
            {
              console.log('Please enter a valid email address.');
              validEmail = false;
            }else{
              validEmail = true;
              this.formData.toPaymentMethod = "email";
              console.log('valid email address.');
      
            }
      
            //validate phone
            var intRegex = /[0-9 -()+]+jQuery/;
            if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
            {
              console.log('Please enter a valid phone number.');
              validPhone = false;
            }else{
              validPhone = true;
              this.formData.toPaymentMethod = "phone";
              console.log('valid phone.');
            }
      
            if(!validPhone && !validEmail){
              this.formData.toPaymentMethod = undefined;
              return false;
            }else{
              // this.formData.fromAccountId = this.formData.fromSpendAccountId;
              return true;
            }
            
          },
        }
      });
      
      // vm = Object.assign(vm, YOH_SHOW_LOCALS);
      // vm.paymentMethods = [];
      // console.log("vm",vm);
      // console.log("vm.paymentMethods",vm.paymentMethods);
    }
    
});
