<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */
require_once(ABSPATH . 'wp-admin/includes/screen.php');


class Yohshow_Balances extends Yohshow_WP {

   public $spendAccountId = 1;//spendAccountId;
   public $reserveAccountId = 4;//rese$reserveAccountId;
   public $accountIdFilter = [0,1,5,4];//accountIdFilter;
   public $internalAccountIdFilter = [1,2,5,4];//internalAccountIdFilter;
   public $spendAccountIdFilter = [1,4];//spendAccountIdFilter;
   public $reserveAccountIdFilter = [2,3,4];//reserveAccountIdFilter;



    public function __construct($yohshow_api) {
        parent::__construct($yohshow_api);
        $this->init();

        // // var_dump("test balances yohshow_api",$this->yohshow_api );


    }
    function init(){
        // // var_dump("test balances init");
        $this->enqueue_scripts();
        // // var_dump("test balances enqueue_scripts called");

        // $this->register_scripts();
        $this->create_endpoints();
        $this->add_shortcodes();

        // $this->add_actions();
            // $this->tokenize_app();

    }
    public function create_endpoints(){

        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/balances/send', array(
              'methods' => 'POST',
              'callback' => array($this,"transfer")
            ) );
          } );

    }

    //scripts


    public function add_shortcodes(){
        add_shortcode('balances', array($this,'balances_shortcode') );
        add_shortcode('accounts', array($this,'accounts_shortcode') );
        add_shortcode('account', array($this,'account_shortcode') );
        add_shortcode('transfer', array($this,'transfer_shortcode') );
    }
    /**
    * Displays account of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function transfer_shortcode() {
      $is_user_logged_in = is_user_logged_in();
      if($is_user_logged_in === false){
        // // var_dump("is_user_logged_in",$is_user_logged_in);
        $result["public"] = true;
        $result["accounts"] = [];
        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;
        return  "<h2>Please login or register</h2>";

        ob_start();
        include 'views/accounts.php';
        return ob_get_clean();

      }else{
        $result["public"] = false;
      }
      //is admin


    try {
      // $ownerId = sails.config.exchange.ownerId;
      // $userId = this.req.me.id;
      // console.log("view sails_environment",sails_environment);
      $sails_environment = "staging";
      $yohshow_api =  $this->yohshow_api;
      $isSuperAdmin = is_super_admin();
      $apiKey =  $this->yohshow_api_key;
      $apiSecret =  $this->yohshow_api_secret;
      $userType =  $_GET["userType"];
      $accountId =  $_GET["accountId"];
      $accountIdFilter = $this->accountIdFilter;
      $cards = [];
      $tokens = [];





      $shareLink = "";
      $reserveAccountId = $this->reserveAccountId;
      $spendAccountId = $this->spendAccountId;

      $accountIdFilter = $this->accountIdFilter;
      $internalAccountIdFilter = $this->internalAccountIdFilter;

      $spendAccountIdFilter = $this->spendAccountIdFilter;
      // $apiKey = $this->yohshow
      $apiKey =  $this->yohshow_api_key;
      $apiSecret =  $this->yohshow_api_secret;

      // console.log("veiw transfer userType",userType);
      $adminlogin["apiKey"] = $apiKey;
      $adminlogin["apiSecret"] = $apiSecret;
      if($userType == "admin" && $isSuperAdmin){
        $adminAccount = true;
        $adminlogin["apiKey"] = $apiKey;
        $adminlogin["apiSecret"] = $apiSecret;
        $wallets = $yohshow_api->request("post","/admin/wallets",$adminlogin);
        // $cards = await Card.find({userId:ownerId}).populate("tokenId").populate("walletId");
        // $tokens = await Token.find({userId:ownerId});
        // $stripePublishableKey = sails.config.custom.enableBillingFeatures? sails.config.custom.stripePublishableKey : undefined;
        $stripePublishableKey = "";
        $accounts = (object)$yohshow_api->request("post","/admin/accounts/admin",$adminlogin);
        $adminAccountsResult = $accounts;
        $adminAccounts = $adminAccountsResult->accounts;
        $trasnferView = "admin";

      }else if($userType == "exchange"){
        //NOTE should not be called because of view-exchange-transfer.js
        $adminAccount = false;
        // $cards = await Card.find({userId:userId}).populate("tokenId").populate("walletId");
        // $tokens = await Token.find({userId:userId});
        // $stripePublishableKey = sails.config.custom.enableBillingFeatures? sails.config.custom.stripePublishableKey : undefined;
        $stripePublishableKey = "";

        $accounts = (object)$yohshow_api->request("get","/accounts/");

        $adminAccountsResult = (object)$yohshow_api->request("get","/accounts/admin",[]);
        $adminAccounts = $adminAccountsResult->accounts;
        $trasnferView = "admin";

      }else{
        $adminAccount = false;
        // $cards = await Card.find({userId:userId}).populate("tokenId").populate("walletId");
        // $tokens = await Token.find({userId:userId});
        // $stripePublishableKey = sails.config.custom.enableBillingFeatures? sails.config.custom.stripePublishableKey : undefined;
        $stripePublishableKey = "";

        $accounts = (object)$yohshow_api->request("get","/accounts/",[]);

        $adminAccountsResult = (object)$yohshow_api->request("get","/accounts/admin",[]);
        $adminAccounts = $adminAccountsResult->accounts;
        $trasnferView = "admin";
      }



      $appTokenResult = (object) $yohshow_api->request("get","/appToken/$apiKey",$adminlogin);
      $appToken = $appTokenResult->appToken;
      $stableToken = $appTokenResult->stableToken;

      $spendAccounts = [];
      $internalAccounts = [];
      $appTokenAccounts = [];
      if($userType == "exchange"){
        for ($i=0; $i < count($adminAccounts) ; $i++) {
          $spendAccount = (object)$adminAccounts[$i];
          if($spendAccount->name == "Exchange"){
            $symbolMatch = $symbol && strtolower($spendAccount->currency->symbol) == strtolower($symbol);

            if($symbolMatch){
              $spendAccounts[] = $spendAccount;
            }else if(!$symbol){
              $spendAccounts[] = $spendAccount;
            }
          }
        }

      }else{
        for ($i=0; $i < count($adminAccounts) ; $i++) {

          $spendAccount = $adminAccounts[$i];
          if($spendAccount->currency->id == $stableToken->id && in_array($spendAccount->bankAccountId,$internalAccountIdFilter) ){
            $spendAccount->displaySymbol = "USD";
            $internalAccounts[]= $spendAccount;
          }
          if($spendAccount->currency->id == $stableToken->id && $spendAccount->bankAccountId == $spendAccountId){
            $spendAccount->displaySymbol = "USD";
            $spendAccounts[] =  $spendAccount;
          }
          if($spendAccount->bankAccountId == $reserveAccountId){
            if($spendAccount->currency->id == $appToken->id){
              $spendAccount->displaySymbol = $appToken->symbolBase;
            }
            $spendAccounts[] =  $spendAccount;
          }
          if($spendAccount->currency->id == $appToken->id ){
            $spendAccount->displaySymbol = $appToken->symbolBase;

            $appTokenAccounts[] = $spendAccount;
          }
        }

      }




      // Respond with view.
        $result['adminAccount'] = $adminAccount;
        $result['appTokenAccounts'] = $appTokenAccounts;
        $result['spendAccountIdFilter'] = $spendAccountIdFilter;
        $result['accountIdFilter'] = $accountIdFilter;
        $result['tokens'] = $tokens;
        $result['spendAccounts'] = $spendAccounts->accounts;
        $result['accounts'] = $accounts->accounts;
        $result['stripePublishableKey'] = $stripePublishableKey;
        $result['appToken'] = $appToken;
        $result['stableToken'] = $stableToken;
        $result['spendAccounts'] = $spendAccounts;
        $result['internalAccounts'] = $internalAccounts;
        $result['trasnferView'] = $trasnferView;
        $result['environment'] = $sails_environment;




    } catch (\Throwable $error) {
        $result['exchangeError'] = $true;
        $result['error'] = $error;

        $result['adminAccount'] = (object)[];
        $result['appTokenAccounts'] = [];
        $result['spendAccountIdFilter'] = $spendAccountIdFilter;
        $result['accountIdFilter'] = $accountIdFilter;
        $result['tokens'] = [];
        $result['spendAccounts'] = [];
        $result['accounts'] = [];
        $result['stripePublishableKey'] = '';
        $result['appToken'] = (object)[];
        $result['stableToken'] = (object)[];
        $result['spendAccounts'] = [];
        $result['internalAccounts'] = [];
        $result['trasnferView'] = "";
        $result['environment'] = "";

    }



      // wp_enqueue_script( 'vue' );
      // $result["paymentMethods"] = $accounts;
      // print_r($result);
      // echo"test";
      $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;

        // return  "<h2>test 2</h2>";
        ob_start();
        include 'views/transfer.php';
        // include_once('views/transfer.php');
        return ob_get_clean();

  }
        /**
    * Displays account of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function account_shortcode() {
      $is_user_logged_in = is_user_logged_in();
      if($is_user_logged_in === false){
        // // var_dump("is_user_logged_in",$is_user_logged_in);
        $result["public"] = true;
        $result["accounts"] = [];
        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;
        return  "<h2>Please login or register</h2>";

        ob_start();
        include 'views/account.php';
        return ob_get_clean();

      }else{
        $result["public"] = false;
      }
      //is admin


    try {
      $yohshow_api =  $this->yohshow_api;
      $isSuperAdmin = is_super_admin();
      $apiKey =  $this->yohshow_api_key;
      $apiSecret =  $this->yohshow_api_secret;
      $userType =  $_GET["userType"];
      $accountId =  $_GET["accountId"];
      $accountIdFilter = $this->accountIdFilter;

      if($userType == "admin" && $isSuperAdmin){
        $adminAccount = true;
        $adminlogin["apiKey"] = $apiKey;
        $adminlogin["apiSecret"] = $apiSecret;
        $accounts = (object)$yohshow_api->request("post","/admin/accounts/admin",$adminlogin);

      }else{
        $adminAccount = false;
        $accounts = (object)$yohshow_api->request("get","/accounts/",[]);
      }
      // print_r($accounts);

      $accounts = $accounts->accounts;

      if($accountId){
        $accountData["accountId"] = $accountId;

        if($adminAccount){
          $account = (object) $yohshow_api->request("get","/admin/accounts/".$accountId,$accountData);
        }else{
          $account = (object) $yohshow_api->request("get","/accounts/".$accountId,$accountData);
        }
        $account = $account->account;
        $transactions = $account->transactionHistory;
      }else{
        $account = $accounts[0];
        $transactions = $account->transactionHistory;
      }
      $accountId  = $account->id;

      $appTokenResult = (object) $yohshow_api->request("get","/appToken/$apiKey",$adminlogin);
      $appToken = $appTokenResult->appToken;
      $stableToken = $appTokenResult->stableToken;



      $result['adminAccount'] = $adminAccount;
      $result['accountIdFilter'] = $accountIdFilter;
      $result['accountId'] = $accountId;
      $result['account'] = $account;
      $result['accounts'] = $accounts;
      $result['transactions'] = $transactions;
      $result['appToken'] = $appToken;
      $result['stableToken'] = $stableToken;

    } catch (\Throwable $error) {
        $result['adminAccount'] = $adminAccount;
        $result['exchangeError'] = $true;
        $result['error'] = $error;
        $result['adminAccount'] = (object)[];
        $result['accountIdFilter'] = $accountIdFilter;
        $result['accountId'] = (object)[];
        $result['account'] = (object)[];
        $result['accounts'] = [];
        $result['transactions'] = [];
        $result['appToken'] = (object)[];
        $result['stableToken'] = (object)[];
        // return $result;
    }



      // wp_enqueue_script( 'vue' );
      // $result["paymentMethods"] = $accounts;
      // print_r($result);
      // echo"test";
      $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;

        // return  "<h2>test 2</h2>";
        ob_start();
        include 'views/account.php';
        // include_once('views/account.php');
        return ob_get_clean();

  }
    /**
    * Displays accounts of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function accounts_shortcode() {
      $is_user_logged_in = is_user_logged_in();
      if($is_user_logged_in === false){
        // // var_dump("is_user_logged_in",$is_user_logged_in);
        $result["public"] = true;
        $result["accounts"] = [];
        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;
        return  "<h2>Please login or register</h2>";

        ob_start();
        include 'views/accounts.php';
        return ob_get_clean();

      }else{
        $result["public"] = false;
      }
      //is admin


    try {
      $yohshow_api =  $this->yohshow_api;
      $isSuperAdmin = is_super_admin();


      $apiKey =  $this->yohshow_api_key;
      $apiSecret =  $this->yohshow_api_secret;
      $userType =  $_GET["userType"];
      // console.log("veiw accounts userType",userType);

      if($userType == "admin" && $isSuperAdmin){
        $adminAccount = true;
        $adminlogin["apiKey"] = $apiKey;
        $adminlogin["apiSecret"] = $apiSecret;
        $wallets = $yohshow_api->request("post","/admin/wallets",$adminlogin);

      }else{
        $adminAccount = false;
        $wallets = $yohshow_api->request("get","/wallets/",[]);

      }
      // console.log("veiw accounts adminAccount",adminAccount);

      $accountIdFilter = [0,1,5,4];//accountIdFilter;
      $reserveAccountIdFilter = [2,3,4]; //reserveAccountIdFilter;



      // console.log("veiw card wallets",wallets);
      if(!$cardEmailVerified){
        $orderCardLink = "/cards/verify-email";
      }else if(!$cardMobileVerified){
        $orderCardLink = "/cards/verify-phone";
      }else {
        $orderCardLink = "/order-card";
      }
      $orderCardLink = "/order-card";


      $appTokenResult = (object) $yohshow_api->request("get","/appToken/$apiKey",$adminlogin);
      $appToken = $appTokenResult->appToken;
      $stableToken = $appTokenResult->stableToken;


        $result['adminAccount'] = $adminAccount;
        $result['accountIdFilter'] = $accountIdFilter;
        $result['wallets'] = $wallets;
        $result['reserveWallets'] = [$wallets[0]];
        $result['orderCardLink'] = $orderCardLink;
        $result['appToken'] = $appToken;
        $result['stableToken'] = $stableToken;
        $result['reserveAccountIdFilter'] = $reserveAccountIdFilter;
        // return $result;


    } catch (\Throwable $error) {
        $result['adminAccount'] = $adminAccount;
        $result['exchangeError'] = $true;
        $result['error'] = $error;
        $result['accountIdFilter'] = [];
        $result['wallets'] = [];
        $result['orderCardLink'] = "";
        $result['appToken'] = (object)[];
        $result['stableToken'] = (object)[];
        $result['reserveAccountIdFilter'] = $reserveAccountIdFilter;
        // return $result;
    }



      // wp_enqueue_script( 'vue' );
      // $result["paymentMethods"] = $accounts;
      // print_r($result);
      // echo"test";
      $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;

        // return  "<h2>test 2</h2>";
        ob_start();
        include 'views/accounts.php';
        // include_once('views/accounts.php');
        return ob_get_clean();

  }
    /**
    * Displays balances of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function balances_shortcode() {
        $is_user_logged_in = is_user_logged_in();




        if($is_user_logged_in === false){
          // // var_dump("is_user_logged_in",$is_user_logged_in);
          $result["public"] = true;
          $result["balances"] = [];
          $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;
          return  "<h2>Please login or register</h2>";

          ob_start();
          include 'views/balances.php';
          return ob_get_clean();

        }else{
          $result["public"] = false;

        }
        $yohshow_api =  $this->yohshow_api;

        $user_using_correct_app = $_SESSION["user_exchange_api_key"] == $_SESSION["exchange_api_key"];
      // // var_dump("balance shortcode app check user_exchange_api_key ",$_SESSION["user_exchange_api_key"]);
      // // var_dump("balance shortcode app check exchange_api_key ",$_SESSION["exchange_api_key"]);
      // // var_dump("balance shortcode app check user_using_correct_app",$user_using_correct_app);

        // //get balances based off login user
        $accountsResult = (object)$yohshow_api->balances();
        $accounts = $accountsResult->accounts;
        //echo '<pre>';
        // // var_dump("accountsResult result",$accountsResult);
        //echo '</pre>';
        // exit;
        $paymentMethods = array();
        $balances = array();
        // print_r($accounts);

        for ($i=0; $i < count($accounts); $i++) {
            $account = (object) $accounts[$i];
            //echo '<pre>';
            //// var_dump("balances payment loop balance",$balance);
            //// var_dump("balances payment loop balance->currency->buyCurrency",$balance->currency->buyCurrency);
            // echo '</pre>';
            // print_r($account);
            // print_r($balance->currency);
            if($account->currency->buyCurrency && $account->name == "Spending"){
              $paymentMethods[] = $account;
            }else if($account->name !== "Exchange")
                continue;
            else
                $balances[] = $account;

        }
        //echo '<pre>';
        //// var_dump("balances paymentMethods",$paymentMethods);
        //echo '</pre>';



        // wp_enqueue_script( 'vue' );
        $result["paymentMethods"] = $paymentMethods;
        // $result["paymentMethods"] = $balances;
        $result["balances"] = $balances;
        // print_r($result);
        // echo"test";
        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;

          // return  "<h2>test 2</h2>";
          ob_start();
          include 'views/balances.php';
          // include_once('views/balances.php');
          return ob_get_clean();

    }

    public function transfer($request){
        $user = $_SESSION["me"];
        $yohshow_api =  $this->yohshow_api;


        $csrf = $request->get_header('X-CSRF-Token');
        // $inputs = $request['params']['POST'];
        // (object) $inputs;
        // TODO convert  to php
        $fromAccountId = $request['fromAccountId'];
        $transferType = $request['transferType'];
        $toDeposit = $request['toDeposit'];
        $toInternal = $request['toInternal'];
        $toExternal = $request['toExternal'];
        $toPayment = $request['toPayment'];
        $toPaymentMethod = $request['toPaymentMethod'];
        $amount = $request['amount'];
        $note = $request['note'];
        // error_log("transfer fromAccountId ".$fromAccountId);
        // error_log("transfer transferType ".$transferType);
        // error_log("transfer toDeposit ".$toDeposit);
        // error_log("transfer toInternal ".$toInternal);
        // error_log("transfer toExternal ".$toExternal);
        // error_log("transfer toPayment ".$toPayment);
        // error_log("transfer toPaymentMethod ".$toPaymentMethod);
        // error_log("transfer amount ".$amount);
        // error_log("transfer note ".$note);


        if($transferType == 'deposit'){
          if(!$toDeposit){
            return [
              'flag' => false,
              'msg' =>  "To deposit not set",
            ];
          }

        }else{
          if(!$fromAccountId){
            return [
              'flag' => false,
              'msg' =>  "From account not set",
            ];
          }

        }


        $transfer = array(
          'type' => $transferType,
          'fromAccountId' => $fromAccountId,
          'amount' => $amount,
        );
        // (object) $transfer;
        // error_log("transfer transfer",$transfer);
        // error_log("transfer transfer",$transferType);

        if($transferType == 'internal'){
          $transfer['toAccountId'] = $toInternal;
          $transfer['note'] = $inputs->note ? $inputs->note: "Internal Transfer" ;
        }else if($transferType == 'payment' || $transferType == 'exchange'){
          if($toPaymentMethod == "email"){
            $toPayment = strtolower($toPayment);
            $toUser = get_user_by_email($toPayment);
            // error_log("transfer email toPaymentMethod",$toPaymentMethod);
            // error_log("transfer email toUser",$toUser);
          }else if($toPaymentMethod == "phone"){
            $toUser = get_users(array('meta_key' => 'phone', 'meta_value' => $toPaymentMethod));
            $toUser = count($toUser) > 0 ? $toUser[0] : false;
            // error_log("transfer email toPaymentMethod",$toPaymentMethod);
            // error_log("transfer email toUser",$toUser);
          }
          if($toUser){
            (object) $toUser;
            // error_log("transfer user set toUser->ID",$toUser->ID);
            $userId = $toUser->ID;
            $exchangeTokenId = get_user_meta($userId,"exchangeTokenId",true);
            // error_log("transfer user set exchangeTokenId",$exchangeTokenId);
            if($exchangeTokenId == false){
              // error_log("transfer user exchange token not set exchangeTokenId",$exchangeTokenId);

              $fullName = "tony test";
              // $emailAddress = "tony201@yohshow.com";
              $emailAddress = $toPayment;
              // error_log("transfer user exchange token not set toPayment",$toPayment);


              // $signup = $this->yohshow_api->signup($fullName,$emailAddress);
              //echo '<pre>';
              // error_log("signup result",$signup);
              //echo '</pre>';
              $login = (object) $this->yohshow_api->login($emailAddress);
              //echo '<pre>';
              // error_log("login result",$login);
              //echo '</pre>';
              // error_log("transfer user exchange token not set login",$login);
              $exchangeTokenId =  $login->tokenId;
              // error_log("transfer user exchange token not set exchangeTokenId",$exchangeTokenId);
              $exchangeTokenIdMetaId = update_user_meta($userId,"exchangeTokenId",$exchangeTokenId);




            }else{
              // $fullName = "New User";
              // // $emailAddress = "tony201@yohshow.com";
              // $emailAddress = $toPaymentMethod;

              // $signup = (object)$this->yohshow_api->signup($fullName,$emailAddress);
              // //echo '<pre>';
              // error_log("signup result",$signup);
              // //echo '</pre>';
              // // $login = (object) $this->yohshow_api->login($emailAddress);
              // //echo '<pre>';
              // // error_log("login result",$login);
              // //echo '</pre>';
              // error_log("transfer user exchange token not set signup signup",$signup);
              // $exchangeTokenId =  $signup->tokenId;
              // error_log("transfer user exchange token not set signup exchangeTokenId",$exchangeTokenId);
              // $exchangeTokenIdMetaId = get_user_meta($userId,"exchangeTokenId",$exchangeTokenId);

            }



            $transfer['toTokenId'] = $exchangeTokenId;


            $paymentNote = $user->fullName . " - " . $inputs->note;
            $transfer['note'] = $inputs->note ? $paymentNote : "Payment" ;
            $transfer['payOwner'] = true;
            $toUserExist = true;
            // error_log("transfer user exchange to user updated exchangeTokenId",$exchangeTokenId);
            // error_log("transfer user exchange to user updated transfer",$transfer);
            // error_log("transfer user exchange to user updated transfer->toTokenId",$transfer['toTokenId']);

          }else{
            //invite user
            // Send "confirm account" email
            $toUserExist = false;
            $this->sendTemplateEmail([
              'to' => $toPayment,
              'subject' => '$Websitename Payment Sent',
              'template' => 'payment-invite',
              'templateData' => [
                'amount' => $inputs->amount,
                'fromUser' => $user,
                'fullName' => "",
              ]
            ]);
          }

        }else if($transferType == 'deposit'){
          //need to charge user here
          $transfer['note'] = $inputs->note ? $inputs->note: "Deposit" ;
          $transfer['apiKey'] = $this->yohshow_api_key;
          $transfer['apiSecret'] = $this->yohshow_api_secret;
          $transfer['toAccountId'] = $toDeposit;

        }else if($transferType == 'external'){
          $transfer['note'] = $inputs->note ? $inputs->note: "Withdral" ;
          $transfer['apiKey'] = $this->yohshow_api_key;
          $transfer['apiSecret'] = $this->yohshow_api_secret;
        }
        // error_log("transfer post transfer transfer->note",$transfer['note']);
        // error_log("transfer pre transfer transfer",$transfer);


        $transfer = (object) $this->yohshow_api->request("post","/accountTransfer",$transfer);
        // error_log("transfer post call transfer transfer",$transfer);

        $flag = true;
        $msg = "Your transfer was sent successfully";
        if($transfer == false){
            $flag = false;
            $msg = "There was an error sending your transfer";
        }
        if($flag){
          if( ($transferType == "payment" || $transferType == "exchange") && $toUserExist ){
            $this->sendTemplateEmail([
              'to' =>  $user->emailAddress,
              'subject' =>  '$Websitename Payment Sent',
              'template' =>  'payment-sent',
              'templateData' =>  [
                'amount' =>  $inputs->amount,
                'fromUser' =>  $user,
                'toUser' =>  $toUser,
                'fullName' =>  $toUser->fullName,
                'transferType' => $transferType,
              ]
            ]);

          }else if( ($transferType == "payment" || $transferType == "exchange") && !$toUserExist ){
            $this->sendTemplateEmail([
              'to' =>  $user->emailAddress,
              'subject' =>  '$Websitename Payment Sent',
              'template' =>  'payment-sent',
              'templateData' =>  [
                'amount' =>  $inputs->amount,
                'fromUser' =>  $user,
                'toUser' =>  $toPayment,
                'fullName' =>  $toPayment,
                'transferType' => $transferType,
              ]
            ]);
          }else{
            $this->sendTemplateEmail([
              'to' =>  $user->emailAddress,
              'subject' =>  '$Websitename Payment Sent',
              'template' =>  'payment-sent',
              'templateData' =>  [
                'amount' =>  $inputs->amount,
                'fromUser' =>  $user,
                'toUser' =>  $user,
                'fullName' =>  $user->fullName,
                'transferType' => $transferType,
              ]
            ]);

          }

          if(!$toUserExist){
            $this->sendTemplateEmail([
              'to' =>  $toUser->emailAddress,
              'subject' =>  '$Websitename Payment Sent',
              'template' =>  'payment-recieved',
              'templateData' =>  [
                'amount' =>  $inputs->amount,
                'fromUser' =>  $user,
                'fullName' =>  $user->fullName,
                'transferType' => $transferType,
              ]
            ]);
            $flag = false;
            $msg = "This user does not have an account yet but we them an invite";
          }
        }
        //email
        $result = [
          'transfer' => $transfer,
          'flag' => $flag,
          'msg' => $msg,
        //   baseUrl:$this->baseUrl,

        ];

        // // var_dump($request);
        // // var_dump("csrf",$csrf);
        // // var_dump("inputs",$inputs);
        // // var_dump("withdrawAmount",$request['withdrawAmount']);
        // // var_dump("params",$request['params']);
        // // var_dump("params post",$request['params']['POST']);
        return json_encode($result);
        return $token;
        // return json_encode($data);

    }

    public function enqueue_scripts(){
      $this->enqueue_scripts_folder("assets/dependencies");
      $this->enqueue_scripts_folder("assets/js");
      $this->enqueue_scripts_folder("assets/js/components");
      $this->enqueue_scripts_folder("assets/js/components/tokens");
      $this->enqueue_scripts_folder("assets/js/components/debit-card");
      $this->enqueue_scripts_folder("assets/js/components/shopify");
      $this->enqueue_scripts_folder("assets/js/pages");
  }




  public function enqueue_scripts_folder($path){
      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          //echo '<pre>';
          //// var_dump("file_url",$file_url);
          //echo '</pre>';
          // exit;
          wp_enqueue_script( $file_name, $file_url,array("jquery"));
      }
      // // var_dump("$path/*.css" );

      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          // echo '<pre>';
          // // var_dump("file_url",$file_url);
          // echo '</pre>';
          // exit;
          wp_enqueue_style( $file_name, $file_url);
      }
      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          // echo '<pre>';
          // // var_dump("file_url",$file_url);
          // echo '</pre>';
          // exit;
          wp_enqueue_style( $file_name, $file_url,array("jquery"));
      }
  }



}