/**
 * <card-nav>
 * -----------------------------------------------------------------------------
 * Crard nav.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('cardNav', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'activeTab',// active nav / page
      'admin',// active nav / page
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {

      };
    },

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
      <div>
          <div v-if="admin" class="nav nav-tabs" id="nav-tab" role="tablist">
              <router-link v-bind:class="[activeTab == 'accounts' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-accounts-tab"  to="/admin/accounts" aria-controls="nav-accounts" aria-selected="true">Accounts</router-link>
              <router-link  v-bind:class="[activeTab == 'account' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-activity-tab"  to="/admin/account" aria-controls="nav-activity" aria-selected="false">Activity</router-link>
              <router-link v-bind:class="[activeTab == 'transfer' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-transfers-tab"  to="/admin/transfer" aria-controls="nav-transfers" aria-selected="false">Transfer Funds</router-link>
              <router-link v-bind:class="[activeTab == 'liquidity' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-liquidity-tab"  to="/admin/liquidity" aria-controls="nav-liquidity" aria-selected="false">Liquidity Pool</router-link>
              <router-link v-bind:class="[activeTab == 'edit' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-account-tab"  to="/profile" aria-controls="nav-cards" aria-selected="false">Edit Profile</router-link>
              <!-- 
              <router-link v-bind:class="[activeTab == 'cards' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-cards-tab"  to="/admin/cards" aria-controls="nav-cards" aria-selected="false">Cards</router-link>
              <router-link v-bind:class="[activeTab == 'manage' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-manage-tab" data-toggle="tab" to="/manage" aria-controls="nav-manage" aria-selected="false">Manage</router-link> 
              
              -->
          </div>
          <div v-else class="nav nav-tabs" id="nav-tab" role="tablist">
              <router-link v-bind:class="[activeTab == 'accounts' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-accounts-tab"  to="/accounts" aria-controls="nav-accounts" aria-selected="true">Accounts</router-link>
              <router-link  v-bind:class="[activeTab == 'account' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-activity-tab"  to="/account" aria-controls="nav-activity" aria-selected="false">Activity</router-link>
              <router-link v-bind:class="[activeTab == 'transfer' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-transfers-tab"  to="/transfer" aria-controls="nav-transfers" aria-selected="false">Transfer Funds</router-link>
              <router-link v-bind:class="[activeTab == 'liquidity' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-liquidity-tab"  to="/liquidity" aria-controls="nav-liquidity" aria-selected="false">Liquidity Pool</router-link>
              <router-link v-bind:class="[activeTab == 'edit' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-account-tab"  to="/profile" aria-controls="nav-cards" aria-selected="false">Edit Profile</router-link>
              <!-- 
                <router-link v-bind:class="[activeTab == 'cards' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-cards-tab"  to="/cards" aria-controls="nav-cards" aria-selected="false">Cards</router-link>
                <router-link v-bind:class="[activeTab == 'manage' ? 'nav-item nav-link active' : 'nav-item nav-link']" id="nav-manage-tab" data-toggle="tab" to="/manage" aria-controls="nav-manage" aria-selected="false">Manage</router-link> 
              -->
          </div>
      </div>

   

      
    `,

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
      //   console.log("this.at",this.totals);
        console.log("this.activeTab",this.activeTab);
        

    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
  

    }

  });

});

