/**
 * <accounts>
 * -----------------------------------------------------------------------------
 * accounts.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('accountsOld', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
          // Form data
            formData: { 
                type: "personal"
            },
        
            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },
        
            // Syncing / loading state
            syncing: false,
            loadingAccounts:true,
            mustLogin:false,
            
        
            // Server error state
            cloudError: '',
        
            // Success state when form has been submitted
            cloudSuccess: false,
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="accounts-component">
        <div v-if="loadingAccounts" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingAccounts" class="btn btn-primary mint">Refesh</ajax-button>


        </div>
        <div v-else="">
            <!-- {{adminAccount}} -->
            <!-- {{wallets}} -->
            <card-nav active-tab="accounts" :admin="adminAccount"></card-nav>
            <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane show active" id="nav-accounts" role="tabpanel" aria-labelledby="nav-accounts-tab">
                <div class="row" >
                <div class="col-xs-6" >
                    <h3>My Accounts Summary</h3>
                </div>
                <div class="col-xs-6 text-right" >
                    
                    <!-- 
                    <router-link class="" tabindex="0" role="button" :to="orderCardLink">
                    <button type="button" class="btn btn-primary">
                        Order Card
                    </button>
                    </router-link>
                    
                    <button type="button" class="" data-toggle="modal" data-target="#addWalletModal">
                    Add Wallet
                    </button> 
                    
                    -->
                    <!-- Button trigger modal -->
                
                </div>
                
                </div>
                <!-- add 
                accou summary
                //account number
                //account name
                //account description
                //wallet name
                //wallet description
                //add wallet
                -->
                <div class="accounts">
                <div class="row">
                    <div class="col-xs-12">
                        <!-- {{account.balance}} -->
                        <div  class="col-xs-4 name"></div>
                        <div  class="col-xs-2 accountKey">Account Number</div>
                        <div  class="col-xs-2 pending">Pending</div>
                        <div  class="col-xs-2 available">Balance</div>
                    </div>
                </div>
                <div v-for="wallet in wallets" class="row">
                    <div class="col-xs-12 title">
                    <b>{{wallet.name}} </b> - {{wallet.type}}
                    </div>
                    <!-- <div v-for="account in wallet.allAccounts"  class="account col-xs-12"> -->
                    <div v-for="account in wallet.allAccounts" class="account col-xs-12" 
                    v-if="accountIdFilter.includes(account.bankAccountId) 
                    && account.ownerType == 'token'
                    && account.currency == stableToken.id" 
                    >
                        <!-- {{account.currency}}  -->
                        <!-- {{account.ownerType}}  -->
                        <div  class="col-xs-3 name">{{account.name}} <span class="d-sm-none">- {{account.description}}</span> </div>
                        <div  class="col-xs-3 bankAccountId">00{{account.bankAccountId}}</div>
                        <div  class="col-xs-2 pending">$ {{ (Math.floor((account.pending + account.spendingBalance) * factor) / factor).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")  }}</div>
                        <div  class="col-xs-2 available">$ {{(Math.floor(account.spendingBalance * factor) / factor).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") }}</div>
                    </div>
                </div>
                    
                </div>
                <div class="row mt-5" >
                <div class="col-xs-12" >
                    <h3>UNITS Reserves</h3>
                </div>
                </div>
                <div>
                <table class="table table-borderless">
                    <!-- <thead> -->
                    <tr>
                        <td scope="col" class="name"></td>
                        <td scope="col" class="accountKey">Account Number</td>
                        <!-- <td scope="col" class="pending">Pending</td> -->
                        <td scope="col" class="available">Balance</tdv>
                        <td scope="col" class="value">USD Value</tdv>
                        <td scope="col" class="action"></td>
                    </tr>
                    <!-- </thead> -->
                    <tbody>

                    <template v-for="wallet in wallets">
                        <tr>
                        <div class="pt-3 pb-3 title">
                            <b>{{wallet.name}} </b> - {{wallet.type}}
                        </div>
                        <tr v-if="wallet.type == 'personal'" class="account " >
                            <td scope="row" class="name">SMS <span class="d-sm-none"></span> </td>
                            <td class="bankAccountId">009</td>
                            <!-- <td class="pending">0.00 UNITS_STELLAR</td> -->
                            <td class="available">{{(smsBalance.spendingBalance)}} UNITS_STELLAR</td>
                            <td class="value">$ {{(smsBalance.spendingBalance * appToken.price).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}} USD</td>
                            <td class="action"></td>
                        </tr>
                        <tr v-for="account in wallet.allAccounts" class="account " 
                            v-if="account.ownerType == 'token'
                            && account.spendingBalance > 0
                            && reserveAccountIdFilter.includes(account.bankAccountId)"
                        >
                            <td scope="row" class="name">{{account.name}} <span class="d-sm-none">- {{account.description}}</span> </td>
                            <td class="bankAccountId">00{{account.bankAccountId}}</td>
                            <!-- <td class="pending">{{ (Math.floor((account.pending + account.spendingBalance) * factor) / factor).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")  }} {{wallet.tokens[account.currency].symbol}}</td> -->
                            <td class="available">{{(Math.floor(account.spendingBalance * factor) / factor) }} {{wallet.tokens[account.currency].symbol}}</td>
                            <td v-if="wallet.tokens[account.currency].id == stableToken.id" class="value">$ {{((1 * account.spendingBalance ).toFixed(2) ).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") }} USD</td>
                            <td v-else="wallet.tokens[account.currency].id == stableToken.id" class="value">$ {{(wallet.tokens[account.currency].lastPrice ? (wallet.tokens[account.currency].lastPrice * account.spendingBalance ).toFixed(2) : 0).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") }} USD</td>
                            <td class="action"><a v-if="wallet.tokens[account.currency].personal && !wallet.tokens[account.currency].icoOrder " :href="account.currency" class="ico btn btn-sm btn-danger" data-toggle="modal" data-target="#exampleModal">Sell</a></td>
                        </tr>
                        </tr>
                        
                    </template>
                    
                    </tbody>
                </table>

                </div>
            
            
            </div>
            
            </div>

            <!-- promote Coin modal start -->
            <div class="modal fade" id="promoteCoin" tabindex="-1" role="dialog" aria-labelledby="promoteCoinLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="promoteCoinLabel">Create Your NFT Now!</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <h3>
                    </h3>
                    <!-- <p>... </p> -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <!-- <button type="button" class="btn btn-primary">Comfirm Sell</button> -->
                    <a href="/mint"  class="btn btn-primary">Ok</a>
                </div>
                </div>
            </div>
            </div>
            <!-- promote Coin modal end -->

            <!-- promote Card modal start -->
            <div class="modal fade" id="promoteCard" tabindex="-1" role="dialog" aria-labelledby="promoteCardLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="promoteCardLabel">Pre Order Your Debit Card!</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <h3>
                    </h3>
                    <!-- <p>... </p> -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <!-- <button type="button" class="btn btn-primary">Comfirm Sell</button> -->
                    <a :href="orderCardLink"  class="btn btn-primary">Ok</a>
                </div>
                </div>
            </div>
            </div>
            <!-- promote Card modal end -->
            


            <!-- ICO Modal -->
            <ajax-form action="placeIcoOrder" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedIcoForm($event)" :handle-parsing="handleParsingIcoForm">

            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Sell Your Coin!</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    </div>
                    <div class="modal-body">
                    <h3>
                        Sell 10% of your gross revenue for 1 million dollars.
                    </h3>
                    <p>- $500,000 will be available in your spending account.</p>
                    <p>- $500,000 will be deposited into your coin's reserve account. </p>
                    </div>
                    <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <!-- <button type="button" class="btn btn-primary">Comfirm Sell</button> -->
                    <ajax-button type="submit" :syncing="syncing" class="btn btn-primary">Confirm Sell</ajax-button>

                    </div>
                </div>
                </div>
            </div>
            </ajax-form>

            <!-- Add Wallet Modal -->
            <ajax-form action="createWallet" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">
            <div class="modal fade" id="addWalletModal" tabindex="-1" role="dialog" aria-labelledby="addWalletModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                    <h5 class="modal-title" id="addWalletModalLabel">Add Wallet</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    </div>
                    <div class="modal-body">
                    <!-- 
                        type
                        name
                        description
                    -->
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="name">Type</label>
                            <select id="type" class="form-control"  name="type"  v-model.trim="formData.type">
                                <option value="personal">Personal</option>
                                <option value="business">Business</option>
                                <option value="investment">Investment</option>
                                <option value="charity">Charity</option>
                            </select>
                            <div class="invalid-from" v-if="formErrors.from">Please select your wallet type.</div>
                            <!-- <small id="adminHelp" class="form-text text-muted">How much of your net income form orders do you want to allocate to your shop token holders?</small> -->
                        </div>
                        <div class="form-group pay">
                            <label for="name">Name</label>
                            <!-- {{maxPromoterCharge}} -->
                            <input class="form-control name" type="text" id="name" name="name" v-model.trim="formData.name">
                            <div class="invalid-name" v-if="formErrors.name">Please enter your a valid name.</div>
                            <!-- <small id="adminHelp" class="form-text text-muted">How much of your net income form orders do you want to allocate to your shop token holders?</small> -->
                        </div>
                        <div class="form-group pay description">
                            <label for="description">Description</label>
                            <textarea class="form-control description"  id="description"  name="description"  v-model="formData.description"></textarea>
                            <div class="invalid-description" v-if="formErrors.description">Please enter your a valid description.</div>
                        </div>
                        
                    </div>
                    <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <!-- <button type="button" class="btn btn-primary">Create Wallet</button> -->
                    <ajax-button type="submit" :syncing="syncing" class="btn btn-primary">Create Wallet</ajax-button>

                    </div>
                </div>
                </div>
            </div>
            </ajax-form>

        </div>
    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.action = this.$route.params.action;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

        await this.listen();  

    },
    mounted: async function() {
        //…
    //     var Accounts = this;
    //     var mustLogin = this.mustLogin;
    //     var promoteCard = this.promoteCard;
    //     // var promoteCoin = this.promoteCoin;
    //     var promoteCoin = this.wallets.length <= 2;
    
        
    //     if(mustLogin){
    //     Accounts.login();
    //     }else if(promoteCoin) {
        
    //     setTimeout(function(){ $('#promoteCoin').modal("show"); }, 6000);
    //     }else if(promoteCard) {
        
    //     setTimeout(function(){ $('#promoteCard').modal("show"); }, 6000);

        
    //     }
        
    //     $(".ico").on("click", function(event) {
    //     var currency = $(event.target).attr("href");
    //     console.log("currency",currency);
    //     Accounts.confirmICO(currency);
    // });

    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      init:  function() {
        //…
        var Accounts = this;
        var mustLogin = this.mustLogin;
        var promoteCard = this.promoteCard;
        // var promoteCoin = this.promoteCoin;
        var promoteCoin = this.wallets.length <= 2;
    
        
        if(mustLogin){
        Accounts.login();
        }else if(promoteCoin) {
        
        // setTimeout(function(){ $('#promoteCoin').modal("show"); }, 6000);
        }else if(promoteCard) {
        
        // setTimeout(function(){ $('#promoteCard').modal("show"); }, 6000);

        
        }
        
        $(".ico").on("click", function(event) {
            var currency = $(event.target).attr("href");
            console.log("currency",currency);
            Accounts.confirmICO(currency);
        });

    
       
      },

      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingAccounts = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingAccounts = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingAccounts = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/accounts',

            data: {userType:this.userType,action:this.action,subaction:this.subaction},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingAccounts = false;
                      // await Account.init();
                      Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                    } else{
                      Account.loadingAccounts = false;
                    }
  
              }
            });

  
      },
        login: async function(currency) {
          var Accounts = this;
          this.syncing = true;
          var redirectLink = Accounts.redirectLink;
    
          var loginResult =  await Cloud.session.with({})
          .tolerate(()=>{
            this.cloudError = true;
          });
    
          console.log("loginResult",loginResult);
          if(loginResult.success){
            if(redirectLink){
              window.location.href = redirectLink;
            }else{
              location.reload();
            }
          }
          
        },
        confirmICO: async function(currency) {
          var Accounts = this;
          Accounts.formData.tokenId = currency;
          // $(".modal .action").html("deposit");
          // $(".modal .currency").html(currency);
          // $(".modal .withdraw-btn").hide();
          // $(".modal .withdraw-btn, .modal .send-btn").hide();
          // $(".modal .deposit-btn").show();
          // $(".confirmICO").off("click").on("click", function(event) {
          //   console.log("confirm deposit cliked");
          //   Accounts.depositAddress(currency);
          // });
        },
        submittedIcoForm: async function(data) {
          console.log("submittedIcoForm");
          this.syncing = true;
          console.log("order data.order",data.order);
          if(data.flag){
            window.location = '/markets/'+data.order.market;
          }else{
            // window.location = '/markets/'+data.order.market;
            location.reload();
          }
        },
    
        handleParsingIcoForm: function() {
          // Clear out any pre-existing error messages.
          this.formErrors = {};
    
          var argins = this.formData;
    
          // // Validate type:
          // if(!argins.type) {
          //   this.formErrors.type = true;
          // }
          // // Validate name:
          // if(!argins.name) {
          //   this.formErrors.name = true;
          // }
          // // Validate description:
          // if(!argins.description) {
          //   this.formErrors.description = true;
          // }
    
    
          // If there were any issues, they've already now been communicated to the user,
          // so simply return undefined.  (This signifies that the submission should be
          // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
    
        submittedForm: async function() {
          console.log("submittedForm");
          window.location = '/cards';
        },
    
        handleParsingForm: function() {
          // Clear out any pre-existing error messages.
          this.formErrors = {};
    
          var argins = this.formData;
    
          // Validate type:
          if(!argins.type) {
            this.formErrors.type = true;
          }
          // Validate name:
          if(!argins.name) {
            this.formErrors.name = true;
          }
          // Validate description:
          if(!argins.description) {
            this.formErrors.description = true;
          }
    
    
          // If there were any issues, they've already now been communicated to the user,
          // so simply return undefined.  (This signifies that the submission should be
          // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
      }



  });

});

