/**
 * <contact>
 * -----------------------------------------------------------------------------
 * contact.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('contact', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
            loadingComponent:true,
            
        
            // Main syncing/loading state for this page.
            syncing: false,

            // Form data
            formData: { /* … */ },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // Server error state for the form
            cloudError: '',

            // Success state when form has been submitted
            cloudSuccess: false,
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="contact-component">
        <div v-if="loadingComponent" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>


        </div>
        <div v-else="" id="contact" v-cloak>
          <div class="container">
            <h1 class="text-center">Get in touch</h1>
            <div class="contact-form" v-if="!cloudSuccess">
              <p class="text-center">Have a question for us?  Maybe some feedback?  We love talking to users about UnitedCoin, and we're happy to answer questions about our pricing, roadmap, or business solutions.  Send us a note and we'll get back to you as soon as possible.</p>
              <hr/>
              <ajax-form action="deliverContactFormMessage" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm()" :handle-parsing="handleParsingForm">
                <div class="form-group">
                  <label for="full-name">Name</label>
                  <input class="form-control" id="full-name" name="full-name" type="text"  :class="[formErrors.fullName ? 'is-invalid' : '']" v-model.trim="formData.fullName" placeholder="Sturgis P. Sturgeon" autocomplete="name" focus-first>
                  <div class="invalid-feedback" v-if="formErrors.fullName">Please let us know what to call you.</div>
                </div>
                <div class="form-group">
                  <label for="email-address">Email address</label>
                  <input class="form-control" id="email-address" name="email-address" type="email"  :class="[formErrors.emailAddress ? 'is-invalid' : '']" v-model.trim="formData.emailAddress" placeholder="sturgeon@example.com" autocomplete="email">
                  <div class="invalid-feedback" v-if="formErrors.emailAddress">Please enter a valid email address.</div>
                </div>
                <div class="form-group">
                  <label for="topic">Topic</label>
                  <input class="form-control" id="topic" name="topic" type="text"  :class="[formErrors.topic ? 'is-invalid' : '']" v-model.trim="formData.topic" placeholder="Pricing question" autocomplete="none">
                  <div class="invalid-feedback" v-if="formErrors.topic">Please choose a topic for your message.</div>
                </div>
                <div class="form-group">
                  <label for="message">Message</label>
                  <textarea class="form-control" id="message" name="message" :class="[formErrors.message ? 'is-invalid' : '']" v-model.trim="formData.message" placeholder="What is the difference between the &quot;Individual&quot; plan and the &quot;Professional&quot; plan?" autocomplete="none"></textarea>
                  <div class="invalid-feedback" v-if="formErrors.message">Message cannot be empty.</div>
                </div>
                <p class="text-danger" v-if="cloudError"><small>An error occured while processing your request. Please check your information and try again, or <a href="/contact">contact support</a> if the error persists.</small></p>
                <div class="form-group">
                  <ajax-button type="submit" :syncing="syncing" class="btn btn-dark btn-lg btn-block">Send message</ajax-button>
                </div>
              </ajax-form>
            </div>
            <div class="success-message" v-if="cloudSuccess">
              <p class="text-center">Thanks for reaching out!</p>
              <hr/>
              <p>We have received your message, and someone from our team will get back to you soon.</p>
            </div>
          </div>
        </div>
    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.action = this.$route.params.action;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          

        await this.listen();  

    },
    mounted: async function() {


    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

      init: function () {
         // Set the form data.
        // this.formData.fullName = this.me.fullName;
        // this.formData.phoneCountryCode = this.me.phoneCountryCode;
        // this.formData.phone = this.me.phone;
        // this.formData.emailAddress = this.me.emailChangeCandidate ? this.me.emailChangeCandidate : this.me.emailAddress;
        
      },
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/contact',

            data: {userType:this.userType,action:this.action,subaction:this.subaction},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingComponent = false;
                      // Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                    } else{
                      Account.loadingComponent = false;
                    }
  
              }
            });

  
      },
      submittedForm: async function() {

        // Show the success message.
        this.cloudSuccess = true;
  
      },
  
      handleParsingForm: function() {
  
        // Clear out any pre-existing error messages.
        this.formErrors = {};
  
        var argins = this.formData;
  
        // Validate email:
        if(!argins.emailAddress) {
          this.formErrors.emailAddress = true;
        }
  
        // Validate name:
        if(!argins.fullName) {
          this.formErrors.fullName = true;
        }
  
        // Validate topic:
        if(!argins.topic) {
          this.formErrors.topic = true;
        }
  
        // Validate message:
        if(!argins.message) {
          this.formErrors.message = true;
        }
  
        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }
  
        return argins;
      },


      }



  });

});

