/**
 * <deploy>
 * -----------------------------------------------------------------------------
 * deploy table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {

   Vue.component('deploy', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'deploy',// « The JS timestamp to format
    'label',// « The JS timestamp to format
    'tokenId',// « The JS timestamp to format
    'type',// « The JS timestamp to format
    'tokenSymbol',
    'networks',
    'id',
    'networkLabelList',
    
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
        formData:{},
        formErrors:{},
        deployViews: {}

    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  
  <div :id="id+'-deploy'" class="deploy-box">
        <div class="row  ">
            <h4 class="col-12">Networks </h4>

            <div class="col-md-12">
                <div class="form-group required-field">
                    <label class="control-label" for="deployToNetwork">Which Network do you want to deploy to?</label>
                    <select class="form-control deployToNetwork-select" required :class="[formErrors.deployToNetwork ? 'is-invalid' : '']" v-model.trim="formData.deployToNetwork"  name="deployToNetwork" >
                        
                        <option v-for="network in networkLabelList"  :value="network.key" v-if=" network.key !== 'mainnet' && network.key !== 'ethereum'  "> {{ network.label.charAt(0).toUpperCase() + network.label.slice(1) }} </option>
                        <!--
                        <option class="mainNet" value="mainNet">
                            Etherum Main network 
                        </option>
                        <option class="bianace" value="bianace">
                            Bianace Smart chain 
                        </option>
                        <option class="avalanche" value="avalanche">
                            Avalanche
                        </option>
                        <option class="sepolia testnet" value="sepolia">
                          Sepolia Testnet
                        </option>
                        -->
                    </select>
        
                    <div class="invalid-feedback" v-if="formErrors.deployToNetwork">Please a choose nework to deploy to.</div>
            
                </div>
            </div>
        
        </div>
        
        

        <div class="row  ">
            <div class="col-12">
                <button type="button"  class="btn btn-primary" @click="deployNewtowrkToken()">Deploy</button>
            </div>
        </div>
        <div class="networks">
        </div>


        
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {

  },
  mounted: async function() {
    // document.addEventListener('DOMContentLoaded', function() {
      this.attributeCnt = 0;
      this.attributeIds = [];
      this.setNetwork();
      console.log("this.deploy",this.deploy);
      this.loadNetworks();
      this.bindUIActions();

      

    // });
    //1-213-373-4253
    

    
  },

  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    deployNewtowrkToken : async function () {
        var deployNewtowrkTokenResult =  await this.deployTokenInit(this.tokenId, this.tokenSymbol, this.formData.deployToNetwork);
        console.log("deployNewtowrkTokenResult",deployNewtowrkTokenResult);

        
    },
    deployTokenInit : async function (tokenId,tokenSymbol,network) {
      // var csrf = await CSRF.token();
      var Network = this;
      // var apiRequestHeader = {
      //     'X-CSRF-Token':csrf._csrf,
      //       // 'cookie':cookie
      //   };
      $.ajax({
            type: "POST",
          //   url: this.refreshUrl+"/markets/orders/cancel",
          // url: '/api/account',
          url: '/wp-json/yohshow/api/v1/mint/deploy/init',
    
          data: {tokenId:tokenId,tokenSymbol:tokenSymbol,network:network},
            // headers:apiRequestHeader,
            success:  function(resData, textStatus, request)
            {
                  resData = JSON.parse(resData);
    
                  if(resData.success){
                   
                      Network.renderNetwork(resData.tokenTokenBookConfig);
                  }else{
                      
                  }
    
            }
          });
      
  },
    deployToken : async function (tokenId,tokenSymbol,network) {
        // var csrf = await CSRF.token();
        var Network = this;
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/mint/deploy',
      
            data: {tokenId:tokenId,tokenSymbol:tokenSymbol,network:network},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                    resData = JSON.parse(resData);
      
                    if(resData.success){
                     
                        Network.loadNetwork(resData.tokenTokenBookConfig);
                        return resData.tokenTokenBookConfig;
                    }else{
                        
                    }
      
              }
            });
        
    },
    renderNetwork: function(network) {
        var Networks = this;
        var id = this.id;
        var type = this.type;
        var label = this.label;
        console.log("render newtowrk",network);

        var networkId = ".networkId-"+network.id;
        if($(networkId).length == 0){
          var  deploymentStatus = network.deploymentStatus;
          var hasAllData = network.tokenBookAddress && network.libraryId && network.erc20Address;

          if(deploymentStatus == "Underfueled"|| deploymentStatus == "no fuel"){            
            var deployView = "Underfueled";
            var sendGasView = ""; 
            var sendPaymentView = "d-none"; 
            var sendRefreshView = "d-none"; 
  

          }else if(deploymentStatus == "unpaid" || deploymentStatus == "Unpaid"){
            var deployView = "Unpaid";
            var sendGasView = "d-none"; 
            var sendPaymentView = ""; 
            var tokenInfoView = "d-none"
            var sendRefreshView = "d-none"; 
  
          }else if(deploymentStatus == "pending" || deploymentStatus == "Pending") {
            var deployView = "Pending";  
            var sendGasView = "d-none"; 
            var sendPaymentView = "d-none"; 
            var tokenInfoView = "d-none"
            var sendRefreshView = ""; 
  
          }else if(deploymentStatus == "deployed" &&  !hasAllData){
            var deployView = "Pending";  
            var sendGasView = "d-none"; 
            var sendPaymentView = "d-none"; 
            var tokenInfoView = "d-none"
            var sendRefreshView = "";  
  
          }else if(deploymentStatus == "deployed"){
            var deployView = "deployed";
            var sendGasView = "d-none"; 
            var sendPaymentView = "d-none"; 
            var tokenInfoView = ""
            var sendRefreshView = "d-none"; 
            
  
          }else{
            var deployView = "Underfueled";
            var sendGasView = ""; 
            var sendPaymentView = "d-none"; 
            var tokenInfoView = "d-none"
            var sendRefreshView = "d-none"; 
  
          }
          Networks.deployViews[networkId] = deployView;
          var networkObj = `
                <div class="network mt-3 networkId-`+network.id+` `+type+` `+network.status+` `+network.network+`" >
                  <div class="row ">
                      <div class="form-group col-6">
                        <label for="key">Network</label>
                        <h5 class="networkLabel ">`+network.network+` </h5>
    
                        <label for="key">Deployment Status</label>
                        <h5 class="deploymentStatus">`+network.deploymentStatus+`  </h5>

                        

                      </div>
                      <div class="form-group col-6">
                        <button type="button"   class= " `+sendGasView+` btn btn-warning sendGas" @click="sendGas()">Fuel Transaction</button>
                        <button type="button"   class= " `+sendPaymentView+` btn btn-success sendPayment" @click="sendPayment()">Fund Transaction</button>
                        <button type="button"   class= " `+sendRefreshView+` btn btn-primary refresh" @click="refresh()">Refresh</button>
                        <div class="tokenInfo `+tokenInfoView+`">
                          <label for="key">NFT Address</label>
                          <h5 class="tokenBookAddress"> `+network.tokenBookAddress+` </h5>

                          <label for="key">Token ID</label>
                          <h5 class="libraryId" > `+network.libraryId+`  </h5>

                          <label for="key">ERC 20 Address</label>
                          <h5 class="balanceTetherAddress"> `+network.erc20Address+` </h5>
                        </div>
                      </div>
                      
      
                      <input class="networkId"  type="hidden"   value="`+network.id+`" >
                      <input class="networkName"  type="hidden"   value="`+network.network+`" >
                      
    
                  </div>
    
                  
                </div>             
            
          `;
          $( "#"+id+"-deploy .networks" ).append( networkObj );
          // network.id = parseInt(network.id);
          // this.networkIds.push(network.id);

        }
  

        
        Networks.loadNetwork(network);
  
  
    },
    sendGas: async function() {
        var Network = this;
        var id = this.id;
        $( "#"+id+"-deploy .sendGas").off("click").on("click", async function(event) {
            try {
                event.preventDefault();
                var networkId = $(event.target).parents(".network").find(".networkId").val();
                var network = $(event.target).parents(".network").find(".networkName").val();
                $(event.target).attr("disabled","disabled");
                const addressToValue = "0xA179f0bCfe1C7a9ea0Ba9B814E73A630350CE5Eb";
                const ETHAmountValue = ".5";
                let web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");

                var accountsRequestResult = await web3.eth.requestAccounts();
                var currentUserAddress = accountsRequestResult[0];
                console.log("currentUserAddress",currentUserAddress);

                const amountToSend = web3.utils.toWei(ETHAmountValue, "ether"); // Convert to wei value
                var send = await web3.eth.sendTransaction({ from: currentUserAddress, to: addressToValue, value: amountToSend });
                console.log(send);
                
                var transaction = await Network.saveTransaction("deploy","sendGas",network,networkId,send.transactionHash);
                if (typeof transaction === 'string' || transaction instanceof String){
                  transaction = JSON.parse(transaction);

                }
                // else{

                // }
                if(transaction.flag){
                    await Network.loadNetwork(transaction.network);
                }else{
                  $(event.target).removeAttr("disabled");
                }
                                
            } catch (error) {
                if(error.message == "Transaction was not mined within 50 blocks, please make sure your transaction was properly sent. Be aware that it might still be mined!"
                  || error.message == "Internal JSON-RPC error."
                ){
                  var transaction = await Network.saveTransaction("deploy","sendGas",network,networkId,"Transaction was not mined within 50 blocks, please make sure your transaction was properly sent. Be aware that it might still be mined!");
                  // var transaction = await Network.saveTransaction("deploy","sendGas",network,networkId,error.message);
                  if (typeof transaction === 'string' || transaction instanceof String){
                    transaction = JSON.parse(transaction);

                  }
                  // else{

                  // }
                  if(transaction.flag){
                      await Network.loadNetwork(transaction.network);
                  }else{
                    $(event.target).removeAttr("disabled");
                  }

                }else{
                  alert("Please make sure you approve all the transactions we send you to sign.");
                  $(event.target).removeAttr("disabled");

                }
                

                
            }
            



        });
        
    },
    sendPayment: async function() {
        var Network = this;
        var id = this.id;
        $( "#"+id+"-deploy .sendPayment").off("click").on("click", async function(event) {
            try {
                event.preventDefault();
                var networkId = $(event.target).parents(".network").find(".networkId").val();
                var network = $(event.target).parents(".network").find(".networkName").val();
                $(event.target).attr("disabled","disabled");

                const addressToValue = "0xA179f0bCfe1C7a9ea0Ba9B814E73A630350CE5Eb";
                const ETHAmountValue = ".6";
                let web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");

                var accountsRequestResult = await web3.eth.requestAccounts();
                var currentUserAddress = accountsRequestResult[0];
                console.log("currentUserAddress",currentUserAddress);

                const amountToSend = web3.utils.toWei(ETHAmountValue, "ether"); // Convert to wei value
                var send = await web3.eth.sendTransaction({ from: currentUserAddress, to: addressToValue, value: amountToSend });
                console.log(send);
                var transaction = await Network.saveTransaction("deploy","sendPayment",network,networkId,send.transactionHash);
                if (typeof transaction === 'string' || transaction instanceof String){
                  transaction = JSON.parse(transaction);

                }
                // else{

                // }
                if(transaction.flag){
                    await Network.loadNetwork(transaction.network);
                    var deployNewtowrkTokenResult =  await Network.deployToken(Network.tokenId, Network.tokenSymbol, network);
                    console.log("deployNewtowrkTokenResult",deployNewtowrkTokenResult);
                }else{
                  $(event.target).removeAttr("disabled");
                }
                                
            } catch (error) {
              if(error.message == "Transaction was not mined within 50 blocks, please make sure your transaction was properly sent. Be aware that it might still be mined!"
                || error.message == "Internal JSON-RPC error."
              ){
                var transaction = await Network.saveTransaction("deploy","sendPayment",network,networkId,"Transaction was not mined within 50 blocks, please make sure your transaction was properly sent. Be aware that it might still be mined!");
                //var transaction = await Network.saveTransaction("deploy","sendPayment",network,networkId,error.message);
                if (typeof transaction === 'string' || transaction instanceof String){
                  transaction = JSON.parse(transaction);

                }
                // else{

                // }
                if(transaction.flag){
                    await Network.loadNetwork(transaction.network);
                    var deployNewtowrkTokenResult =  await Network.deployToken(Network.tokenId, Network.tokenSymbol, network);
                    console.log("deployNewtowrkTokenResult",deployNewtowrkTokenResult);
                }else{
                  $(event.target).removeAttr("disabled");
                }

              }else{
                alert("Please make sure you approve all the transactions we send you to sign.");
                $(event.target).removeAttr("disabled");

              }
                

                
            }
            
        });
        
    },
    refresh: async function() {
      var Network = this;
      var id = this.id;
      $( "#"+id+"-deploy .refresh").off("click").on("click", async function(event) {
          try {
              event.preventDefault();
              var networkId = $(event.target).parents(".network").find(".networkId").val();
              var network = $(event.target).parents(".network").find(".networkName").val();

              var deployNewtowrkTokenResult =  await Network.deployToken(Network.tokenId, Network.tokenSymbol, network);
              console.log("deployNewtowrkTokenResult",deployNewtowrkTokenResult);
              if(deployNewtowrkTokenResult && deployNewtowrkTokenResult.flag){
                  await Network.loadNetwork(deployNewtowrkTokenResult.network);
              }
                              
          } catch (error) {
              alert("Please make sure you approve all the transactions we send you to sign.");
              
          }
          
      });
      
  },
    loadNetwork: function(network) {
        var Networks = this;
        var deploymentStatus = network.deploymentStatus;
        var id = network.id;
        var networkId = ".networkId-"+network.id;
        var hasAllData = network.tokenBookAddress && network.libraryId && network.erc20Address;

        
        $(".deployToNetwork-select ."+network.network).hide();

        if(deploymentStatus == "Underfueled"|| deploymentStatus == "no fuel"){
            $(networkId +" .networkLabel").html(network.network);
            $(networkId +" .deploymentStatus").html("Underfueled");
            $(networkId +" .tokenBookAddress").html(network.tokenBookAddress);
            $(networkId +" .libraryId").html(network.libraryId);
            $(networkId +" .balanceTetherAddress").html(network.balanceTetherAddress);
            $(networkId +" .tokenInfo").hide();
            $(networkId +" .sendPayment").hide();
            $(networkId +" .refresh").hide();
            $(networkId +" .sendGas").show().removeClass("d-none");;

        }else if(deploymentStatus == "unpaid" || deploymentStatus == "Unpaid"){
            $(networkId +" .networkLabel").html(network.network);
            $(networkId +" .deploymentStatus").html("Unpaid");
            $(networkId +" .tokenBookAddress").html(network.tokenBookAddress);
            $(networkId +" .libraryId").html(network.libraryId);
            $(networkId +" .balanceTetherAddress").html(network.balanceTetherAddress);
            $(networkId +" .tokenInfo").hide();
            $(networkId +" .sendPayment").show().removeClass("d-none");;
            $(networkId +" .sendGas").hide();
            $(networkId +" .refresh").hide();

            
        }else if(deploymentStatus == "pending" || deploymentStatus == "Pending"){
            $(networkId +" .networkLabel").html(network.network);
            $(networkId +" .deploymentStatus").html("Pending");
            $(networkId +" .tokenBookAddress").html(network.tokenBookAddress);
            $(networkId +" .libraryId").html(network.libraryId);
            $(networkId +" .balanceTetherAddress").html(network.balanceTetherAddress);
            $(networkId +" .tokenInfo").hide();
            $(networkId +" .sendPayment").hide();
            
            $(networkId +" .sendGas").hide();

            $(networkId +" .refresh").html("Deploying Now...").attr("disabled","disabled");
            $(networkId +" .refresh").show().removeClass("d-none");

            setTimeout(() => {
              $(networkId +" .refresh").html("Refresh").removeAttr("disabled");

            }, "90000");
            
        }else if(deploymentStatus == "deployed" && !hasAllData){
            $(networkId +" .networkLabel").html(network.network);
            $(networkId +" .deploymentStatus").html("Pending");
            $(networkId +" .tokenBookAddress").html(network.tokenBookAddress);
            $(networkId +" .libraryId").html(network.libraryId);
            $(networkId +" .balanceTetherAddress").html(network.balanceTetherAddress);
            $(networkId +" .tokenInfo").hide();
            $(networkId +" .sendPayment").hide();
            
            $(networkId +" .sendGas").hide();

            $(networkId +" .refresh").html("Deploying Now...").attr("disabled","disabled");
            $(networkId +" .refresh").show().removeClass("d-none");

            setTimeout(() => {
              $(networkId +" .refresh").html("Refresh").removeAttr("disabled");

            }, "90000");
            
        }else if(deploymentStatus == "deployed"){
            $(networkId +" .networkLabel").html(network.network);
            $(networkId +" .deploymentStatus").html("Deployed");
            $(networkId +" .tokenBookAddress").html(network.tokenBookAddress);
            $(networkId +" .libraryId").html(network.libraryId);
            $(networkId +" .balanceTetherAddress").html(network.balanceTetherAddress);
            $(networkId +" .tokenInfo").removeClass("d-none");
            $(networkId +" .tokenInfo").show().removeClass("d-none");;
            $(networkId +" .sendPayment").hide();
            $(networkId +" .refresh").hide();
            $(networkId +" .sendGas").hide();
            
        }
        Networks.bindUIActions();

    },
    saveTransaction : async function (type,action,network,networkId,hash) {
        // var csrf = await CSRF.token();
        var Network = this;
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        return $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/transaction/save',
      
            data: {type:type,action:action,network:network,networkId:networkId,hash:hash},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                    resData = JSON.parse(resData);
                    return resData;
      
                    if(resData.success){
                     
   
                    }else{
                        
                    }
      
              }
            });
        
    },
    loadNetworks: function() {
      var networks = this.networks;
      var Networks = this;
      if(networks){
        for (let i = 0; i < networks.length; i++) {
          const network = networks[i];
          Networks.renderNetwork(network);
          
        }
      }
      
    },
    ////////////////////////////////////////////////////
    bindUIActions: function() {
      var Networks = this;
      Networks.sendGas();
      Networks.sendPayment();
      Networks.refresh();
    //   Networks.approve();
    //   Networks.pickup();
    },
    approve: async function(){
        var Network = this;
        var id = this.id;

        $( "#"+id+"-deploy .approve").off("click").on("click", function(event) {
          event.preventDefault();
          console.log($(event.target).parents(".attribute").length);
          console.log($(event.target).parents(".attribute").find(".attributeId").length);
          var attributeId = $(event.target).parents(".attribute").find(".attributeId").val();
          console.log("approve attributeId",attributeId);
          Network.approveNetwork(attributeId);
          $(event.target).parents(".attribute").remove();

        });


    },

   

    setNetwork: function() {
      var id = this.id;
      console.log("id",id);
      var attribute = $( "#"+id+"-deploy .attribute" ).clone();
      this.attribute = attribute;
      console.log("this.attribute",this.attribute);
    },
    addNetwork: function() {
      var Networks = this;
      var id = this.id;
      console.log("added addNetwork click");

      $( "#"+id+"-deploy .add-attribute").off("click").on("click", function(event) {
        event.preventDefault();
        var attribute = Networks.renderNewNetwork();
      });
    },
    activateDelete: function() {
      var Networks = this;
      var id = this.id;

      $( "#"+id+"-deploy .delete").off("click").on("click", function(event) {
        event.preventDefault();
        console.log("children delete length",$(event.target).parents(".attribute").find(".delete").length);
        $(event.target).parents(".attribute").find(".delete").val("true");
        $(event.target).parents(".attribute").remove();
      });
    },
    cloneNetwork: function() {
      var Networks = this;
      var attribute = Networks.attribute;
      Networks.attribute = attribute.clone();
      return attribute;
    },
    renderView: function() {
      // var Networks = this;
      // var type = this.type;
      // if
      
      // return attribute;
    },
    
    renderNewNetwork: function() {
      this.attributeCnt++; 
      var id = this.id;
      var attributeCnt = this.attributeCnt;
      var label = this.label;

      var attributeObj = `
            <div class="attribute `+label+`" >
              <div class="row edit value">
                  <div class="form-group col-md-4 col-sm-12">
                    <label for="key">Network</label>
                    <input name="deploy[`+attributeCnt+`][key]" type="text"  class="form-control key" id="key" aria-describedby="keyHelp" placeholder="Enter key">
                    <small id="keyHelp" class="form-text text-muted"></small>
                  </div>
                  <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                    <label for="meta">Value</label>
                    <input name="deploy[`+attributeCnt+`][meta]" type="text"    class="form-control meta" id="meta" aria-describedby="toHelp" placeholder="Enter to">
                    <small id="toHelp" class="form-text text-muted"></small>
                  </div>
                  <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                    <label for="meta">Type</label>
                    <select name="deploy[`+attributeCnt+`][metaType]" class="form-control metaType" id="metaType">
                      <option value="text">Text</option>
                      <option value="link">Link</option>
                    </select>
                    <small id="toHelp" class="form-text text-muted">Is this attribute text or a link?</small>
                  </div>
                  <div class="form-group fl-r pl-2 pt-4" style="position: relative;right: -2%;top: 11px;">
                    <label> </label>
                    <label class="delete">X</label>
                  </div>
                  <input name="deploy[`+attributeCnt+`][new]" type="hidden"  class="new" value="true" >
              </div>
              
            </div>              
        
      `;
      console.log("deploy length",$( "#"+id+"-deploy .deploy" ).length );
      $( "#"+id+"-deploy .deploy" ).append( attributeObj );
      console.log("add deploy component ",attributeObj);
      this.activateDelete();


    },
  }

});

});

