/**
 * <kyc>
 * -----------------------------------------------------------------------------
 * kyc.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('kyc', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
            loadingComponent:true,
            
        
            // Main syncing/loading state for this page.
            syncing: false,

            // Form data
            formData: { /* … */ },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // Server error state for the form
            cloudError: '',
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="kyc-component">
        <div v-if="loadingComponent" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>


        </div>
        <div v-else="" id="kyc" class="exchange-pg" v-cloak>
  
            <div v-if="kycApplicationError" class="container">
              <h1 class="text-center">Sorry, this service is currently unavailable. Please check back again later...</h1> 
              <p class="text-center"> <strong><a href="javascript:history.back()"class="btn btn-primary">Back</a>  </strong>. </p>
            </div>
            <div v-else-if="kycImpossible" id="sumsub-websdk-container"></div>
            <div v-if="mustRestartKyc">
              <h3 class="text-center">We had the following issue verifying your identity documents.</h3> 
              <p class="text-center"><b>{{primeTrustKycMessage}}</b></p>
              <div id="sumsub-websdk-container"></div>
              <p class="text-center"> <strong><a href="/kyc/restart" class="btn btn-primary">Restart Kyc Process</a>  </strong>. </p>
            </div>
            <div v-else id="sumsub-websdk-container"></div>
          
        </div>

    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.action = this.$route.params.action;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          

        await this.listen();  

    },
    mounted: async function() {


    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

      init: function () {
        var KYC = this;
          // provide your clientId (shown in the demo in the top left corner)
        var clientId = this.clientId;
        // access token generated for $YOUR_USER_ID
        var accessToken = this.accessToken;
        // your user id for which you generated $ACCESS_TOKEN
        var externalUserId = this.userId;
        var kycUrl = this.kycUrl;
        var kycFlowName = this.kycFlowName;
        var emailAddress = this.me.emailAddress;
        var phone = this.me.phone;
        
        console.log("kyc",kyc);
        KYC.launchWebSdk(kycUrl,kycFlowName,accessToken,emailAddress,phone); 

        if(this.kycDocumentForce){
          setTimeout(() => {
            location.reload();
          }, 5000);
        }
        
      },
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     // 'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/kyc',

            data: {userType:this.userType,action:this.action,subaction:this.subaction},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingComponent = false;
                      Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                    } else{
                      Account.loadingComponent = false;
                    }
  
              }
            });

  
      },
      launchWebSdk : function  (apiUrl, flowName, accessToken, applicantEmail, applicantPhone, customI18nMessages) {
        var kycImpossible = this.kycImpossible;
        var mustRestartKyc = this.mustRestartKyc;
        var KYC = this;

        let snsWebSdkInstance = snsWebSdk.init(
          accessToken,
          () => KYC.getNewAccessToken()
      )
      .withConf({
          lang: 'en',
          email: applicantEmail,
          phone: applicantPhone,
          i18n: {"document":{"subTitles":{"IDENTITY": "Upload a document that proves your identity"}}},
          onMessage: (type, payload) => {
              // console.log('WebSDK onMessage', type, payload)
              console.log('WebSDK onMessage', type, payload);
            if(type == "idCheck.applicantStatus"){
              var reviewStatus = payload.reviewStatus;
              if(reviewStatus == "completed" && !kycImpossible && !mustRestartKyc){
                window.location = '/kyc/now';
              }
            }
          },
          uiConf: {
              customCssStr: ":root {\n  --black: #000000;\n   --grey: #F5F5F5;\n  --grey-darker: #B2B2B2;\n  --border-color: #DBDBDB;\n}\n\np {\n  color: var(--black);\n  font-size: 16px;\n  line-height: 24px;\n}\n\nsection {\n  margin: 40px auto;\n}\n\ninput {\n  color: var(--black);\n  font-weight: 600;\n  outline: none;\n}\n\nsection.content {\n  background-color: var(--grey);\n  color: var(--black);\n  padding: 40px 40px 16px;\n  box-shadow: none;\n  border-radius: 6px;\n}\n\nbutton.submit,\nbutton.back {\n  text-transform: capitalize;\n  border-radius: 6px;\n  height: 48px;\n  padding: 0 30px;\n  font-size: 16px;\n  background-image: none !important;\n  transform: none !important;\n  box-shadow: none !important;\n  transition: all 0.2s linear;\n}\n\nbutton.submit {\n  min-width: 132px;\n  background: none;\n  background-color: var(--black);\n}\n\n.round-icon {\n  background-color: var(--black) !important;\n  background-image: none !important;\n}"
          },
          onError: (error) => {
              console.error('WebSDK onError', error)
          },
      })
      .withOptions({ addViewportTag: false, adaptIframeHeight: true})
      .on('stepCompleted', (payload) => {
          console.log('stepCompleted', payload)
      })
      .on('onError', (error) => {
          console.log('onError', payload)
      })
      .onMessage((type, payload) => {
          // console.log('onMessage', type, payload)
          console.log('WebSDK onMessage', type, payload);
            if(type == "idCheck.applicantStatus"){
              var reviewStatus = payload.reviewStatus;
              if(reviewStatus == "completed" && !kycImpossible && !mustRestartKyc){
                window.location = '/kyc/now';
              }
            }
      })
      .build();
      snsWebSdkInstance.launch('#sumsub-websdk-container')



      //   let snsWebSdkInstance = snsWebSdk.init(
      //       accessToken,
      //       // token update callback, must return Promise
      //       // Access token expired
      //       // get a new one and pass it to the callback to re-initiate the WebSDK
      //       () => KYC.getNewAccessToken()
      //   )
      //   .withConf({
      //       lang: 'en', //language of WebSDK texts and comments (ISO 639-1 format)
      //       email: applicantEmail,
      //       phone: applicantPhone,
      //       i18n: customI18nMessages, //JSON of custom SDK Translations
      //       uiConf: {
      //           customCss: "https://url.com/styles.css"
      //           // URL to css file in case you need change it dynamically from the code
      //           // the similar setting at Customizations tab will rewrite customCss
      //           // you may also use to pass string with plain styles `customCssStr:`
      //       },
      //   })
      //   .withOptions({ addViewportTag: false, adaptIframeHeight: true})
      //   // see below what kind of messages WebSDK generates
      //   .on('idCheck.stepCompleted', (payload) => {
      //       console.log('stepCompleted', payload)
      //   })
      //   .on('idCheck.onError', (error) => {
      //       console.log('onError', error)
      //   })
      //   .onMessage((type, payload) => {
      //       // see below what kind of messages the WebSDK generates
      //       console.log('WebSDK onMessage', type, payload);
      //       if(type == "idCheck.applicantStatus"){
      //         var reviewStatus = payload.reviewStatus;
      //         if(reviewStatus == "completed" && !kycImpossible && !mustRestartKyc){
      //           window.location = '/kyc';
      //         }
      //       }
      //   })
      //   .build();

      // // you are ready to go:
      // // just launch the WebSDK by providing the container element for it
      // snsWebSdkInstance.launch('#sumsub-websdk-container')
    },
    getNewAccessToken : function  () {
      return Promise.resolve(newAccessToken)// get a new token from your backend
    },
    // launchWebSdk : function  (apiUrl, flowName, accessToken, applicantEmail, applicantPhone, customI18nMessages) {
    //     var kycImpossible = this.kycImpossible;
    //     var mustRestartKyc = this.mustRestartKyc;
    //     let snsWebSdkInstance = snsWebSdk.Builder(apiUrl, flowName)
    //         .withAccessToken(
    //             accessToken,
    //             (newAccessTokenCallback) => {
    //                 // Access token expired
    //                 // get a new one and pass it to the callback to re-initiate the WebSDK
    //                 let newAccessToken = '...'; // get a new token from your backend
    //                 newAccessTokenCallback(newAccessToken)
    //             }
    //         )
    //         .withConf({
    //             lang: 'en',
    //             email: applicantEmail,
    //             phone: applicantPhone,
    //             i18n: customI18nMessages,
    //             onMessage: (type, payload) => {
    //                 // see below what kind of messages the WebSDK generates
    //                 console.log('WebSDK onMessage', type, payload);
    //                 if(type == "idCheck.applicantStatus"){
    //                   var reviewStatus = payload.reviewStatus;
    //                   if(reviewStatus == "completed" && !kycImpossible && !mustRestartKyc){
    //                     window.location = '/kyc';
    //                   }
    //                 }
    //             },
    //             uiConf: {
    //                 customCss: "https://url.com/styles.css"
    //                 // URL to css file in case you need change it dynamically from the code
    //                 // the similar setting at Applicant flow will rewrite customCss
    //                 // you may also use to pass string with plain styles `customCssStr:`
    //             },
    //             onError: (error) => {
    //                 console.error('WebSDK onError', error)
    //             },
    //         })
    //         .build();
    
    //     // you are ready to go:
    //     // just launch the WebSDK by providing the container element for it
    //     snsWebSdkInstance.launch('#sumsub-websdk-container')
    // },
    kycCompleted: async function (payload) {
      // var csrf = await CSRF.token();
        // console.log('csrf',csrf);
        console.log('payload',payload);
        // var apiRequestHeader = {
        //   'X-CSRF-Token':csrf._csrf,
        // };
       return io.socket.request({
        method: 'post',
        url: '/kycCompleted',
        data: payload,
        // headers: apiRequestHeader
      }, function (resData, jwres) {
        console.log(resData); // => e.g. 403
        if(resData.success){
          window.location = '/cards';
        }
        if (jwres.error) {
          console.log(jwres.statusCode); // => e.g. 403
          return;
        }
        console.log(jwres.statusCode); // => e.g. 200
      });
    },
      


      }



  });

});

