/**
 * <profile>
 * -----------------------------------------------------------------------------
 * profile.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('profile', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
            loadingComponent:true,
            
        
            // Success state when form has been submitted
            cloudSuccess: false,

            isBillingEnabled: false,

            hasBillingCard: false,

            // Syncing/loading states for this page.
            syncingOpenCheckout: false,
            syncingUpdateCard: false,
            syncingRemoveCard: false,

            // Form data
            formData: { /* … */ },

            // Server error state for the form
            cloudError: '',

            // For the Stripe checkout window
            checkoutHandler: undefined,

            // For the confirmation modal:
            removeCardModalVisible: false,
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="profile-component">
        <div v-if="loadingComponent" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>


        </div>
        <div v-else="" class="" v-cloak>
            <card-nav active-tab="edit" :admin="adminAccount"></card-nav>
                <div class="tab-content" id="nav-tabContent">
                <div class="tab-pane show active" id="nav-accounts" role="tabpanel" aria-labelledby="nav-accounts-tab">
                    <div class="">
                    <!-- <h3>My account</h3> -->
                    <!-- <hr/> -->
                    <div class="row mb-3">
                        <div class="col-sm-6">
                        <h4>Personal information</h4>
                        </div>
                        <div class="col-sm-6">
                        <span class="float-sm-right">
                            <router-link class="btn btn-sm btn-primary account-settings-button" to="/info">Edit profile</router-link>
                        </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3">Profile Photo:</div>
                        <div class="col"> <img v-if="me.avatar" v-bind:src="me.avatar" height="200" alt="profile photo"></div>
                    </div>
                    <div class="row">
                        <div class="col-3">Name:</div>
                        <div class="col"><strong>{{me.fullName}}</strong></div>
                    </div>
                    <div class="row">
                        <div class="col-3">Username:</div>
                        <div class="col"><strong>{{me.username}}</strong></div>
                    </div>
                    <div class="row">
                        <div class="col-3">Email:</div>
                        <div class="col">
                        <strong :class="[me.emailStatus === 'unconfirmed' || me.emailStatus === 'change-requested' ? 'text-muted' : '']">{{me.emailChangeCandidate ? me.emailChangeCandidate : me.emailAddress}}</strong>
                        <span v-if="me.emailStatus === 'unconfirmed' || me.emailStatus === 'change-requested'" class="badge badge-pill badge-warning">Unverified</span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3">Phone:</div>
                        <div class="col"><strong> {{me.phone? "+": ""}}{{me.phone}}</strong></div>
                    </div>
                    <hr/>
                    <div class="row mb-3">
                        <div class="col-sm-6">
                        <h4>Password</h4>
                        </div>
                        <div class="col-sm-6">
                        <span class="float-sm-right">
                            <router-link class="btn btn-sm btn-primary account-settings-button" to="/password">Change password</router-link>
                        </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-3">Password:</div>
                        <div class="col"><strong>••••••••••</strong></div>
                    </div>
                    <hr/>
                    <!-- <div class="row mb-3" v-if="isBillingEnabled">
                        <div class="col-sm-6">
                        <h4>Billing</h4>
                        </div>
                        <div class="col-sm-6">
                        <span class="float-sm-right">
                            <ajax-button :syncing="syncingOpenCheckout || syncingUpdateCard" class="btn btn-sm  account-settings-button" @click="clickStripeCheckoutButton()">
                            <span slot="syncing-state">
                                <span v-if="syncingOpenCheckout">Connecting...</span>
                                <span v-else>Updating...</span>
                            </span>
                            <span slot="default">{{ me.hasBillingCard ? 'Change card' : 'Add card' }}</span>
                            </ajax-button>
                        </span>
                        </div>
                    </div>
                    <div v-if="isBillingEnabled && me.hasBillingCard">
                        <div class="row">
                        <div class="col-3">Credit card:</div>
                        <div class="col">{{me.billingCardBrand}} ending in <strong>{{me.billingCardLast4}}</strong> <a class="remove-button ml-2" @click="clickRemoveCardButton()">Remove</a></div>
                        </div>
                        <div class="row">
                        <div class="col-3">Expiration:</div>
                        <div class="col">{{me.billingCardExpMonth}}/{{me.billingCardExpYear}}</div>
                        </div>
                    </div>
                    <div class="alert alert-danger" v-else-if="isBillingEnabled && cloudError">
                        There was an error updating your credit card information. Please check your information and try again, or <router-link to="/contact">contact support</router-link> if the error persists.
                    </div>
                    <div class="alert alert-secondary" v-else-if="isBillingEnabled">
                        You have not linked a payment source to your account. In order to access paid features, you'll need to provide your credit card information. (Don't worry: you will only be charged when you've reached the limit of your free plan.)
                    </div> -->
                    <!-- {{creditCardResourceToken}} -->
                    <!-- <add-prime-trust-card v-if="creditCardResourceToken"
                        :credit-card-resource-token="creditCardResourceToken" 
                        :prime-trust-billing-card-brand="me.primeTrustBillingCardBrand" 
                        :prime-trust-billing-card-last4="me.primeTrustBillingCardLast4" 
                        :prime-trust-billing-card-exp-month="me.primeTrustBillingCardExpMonth" 
                        :prime-trust-billing-card-exp-year="me.primeTrustBillingCardExpYear" 
                    ></add-prime-trust-card> -->
                    </div>
                
                </div>
                
                </div>
            



            <!-- /* Confirm Remove Card Info Modal */ -->
            <modal v-if="removeCardModalVisible" @close="closeRemoveCardModal()" v-cloak>
                <div class="modal-header">
                <h5 class="modal-title">Remove Card Info?</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
                </div>
                <ajax-form action="updateBillingCard" :syncing.sync="syncingRemoveCard" :cloud-error.sync="cloudError" :handle-parsing="handleParsingRemoveCardForm" @submitted="submittedRemoveCardForm()">
                <div class="modal-body">
                    <p>Are you sure you want to remove your {{me.billingCardBrand}} ending in <strong>{{me.billingCardLast4}}</strong>?</p>
                    <p class="text-muted">This may restrict your access to paid features.</p>
                    <p class="text-danger" v-if="cloudError"><small>An error occured while processing your request. Please check your information and try again, or <router-link to="/contact">contact support</router-link> if the error persists.</small></p>
                </div>
                <div class="modal-footer">
                    <button data-dismiss="modal" class="btn btn-outline-secondary mr-1">Nevermind</button>
                    <ajax-button type="submit" :syncing="syncingRemoveCard" class="btn btn-danger ml-1">Remove</ajax-button>
                </div>
                </ajax-form>
            </modal>
            </div>

    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.action = this.$route.params.action;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

        await this.listen();  

    },
    mounted: async function() {
        //…
    //     var Accounts = this;
    //     var mustLogin = this.mustLogin;
    //     var promoteCard = this.promoteCard;
    //     // var promoteCoin = this.promoteCoin;
    //     var promoteCoin = this.wallets.length <= 2;
    
        
    //     if(mustLogin){
    //     Accounts.login();
    //     }else if(promoteCoin) {
        
    //     setTimeout(function(){ $('#promoteCoin').modal("show"); }, 6000);
    //     }else if(promoteCard) {
        
    //     setTimeout(function(){ $('#promoteCard').modal("show"); }, 6000);

        
    //     }
        
    //     $(".ico").on("click", function(event) {
    //     var currency = $(event.target).attr("href");
    //     console.log("currency",currency);
    //     Accounts.confirmICO(currency);
    // });

    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {


      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/profile',

            data: {userType:this.userType,action:this.action,subaction:this.subaction},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingComponent = false;
                      // await Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                    } else{
                      Account.loadingComponent = false;
                    }
  
              }
            });

  
      },
      clickStripeCheckoutButton: async function() {

        // Prevent double-posting if it's still loading.
        if(this.syncingUpdateCard) { return; }
  
        // Show syncing state for opening checkout.
        this.syncingOpenCheckout = true;
  
        // Clear out error states.
        this.cloudError = false;
  
        // Open Stripe Checkout.
        var billingCardInfo = await parasails.util.openStripeCheckout(this.stripePublishableKey, this.me.emailAddress);
        // Clear the loading state for opening checkout.
        this.syncingOpenCheckout = false;
        if (!billingCardInfo) {
          // (if the user canceled the dialog, avast)
          return;
        }
  
        // Now that payment info has been successfully added, update the billing
        // info for this user in our backend.
        this.syncingUpdateCard = true;
        await Cloud.updateBillingCard.with(billingCardInfo)
        .tolerate(()=>{
          this.cloudError = true;
        });
        this.syncingUpdateCard = false;
  
        // Upon success, update billing info in the UI.
        if (!this.cloudError) {
          Object.assign(this.me, _.pick(billingCardInfo, ['billingCardLast4', 'billingCardBrand', 'billingCardExpMonth', 'billingCardExpYear']));
          this.me.hasBillingCard = true;
        }
      },
  
      clickRemoveCardButton: async function() {
        this.removeCardModalVisible = true;
      },
  
      closeRemoveCardModal: async function() {
        this.removeCardModalVisible = false;
        this.cloudError = false;
      },
  
      submittedRemoveCardForm: async function() {
  
        // Update billing info on success.
        this.me.billingCardLast4 = undefined;
        this.me.billingCardBrand = undefined;
        this.me.billingCardExpMonth = undefined;
        this.me.billingCardExpYear = undefined;
        this.me.hasBillingCard = false;
  
        // Close the modal and clear it out.
        this.closeRemoveCardModal();
  
      },
  
      handleParsingRemoveCardForm: function() {
        return {
          // Set to empty string to indicate the default payment source
          // for this customer is being completely removed.
          stripeToken: ''
        };
      },

      }



  });

});

