/**
 * <transfer-network>
 * -----------------------------------------------------------------------------
 * transferNetwork.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('transferNetwork', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
        'id',
        'network',
        'networkAccounts',
   
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        networkAccounts:[],
        isBillingEnabled: false,

        hasBillingCard: false,
        paymentMethodAddress: "0xd938FF47d23458B33f993fBb7Ba22cE1A3fd621d",
        paymentMethodTokenId: 2,
        tokenBankContractAddress: "0xd938FF47d23458B33f993fBb7Ba22cE1A3fd621d",
        tokenBankContractInterface: [{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"owners","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_upgradedAddress","type":"address"}],"name":"deprecate","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"tokenRewards","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_tokenID","type":"uint256"},{"name":"from","type":"address"},{"name":"to","type":"address"}],"name":"preTransfer","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"deprecated","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newTokenBookConfigAddress","type":"address"}],"name":"config","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"upgradedAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"tetherBooks","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBook","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenKey","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"fromAccountKey","type":"uint256"},{"name":"paymentAddressKey","type":"uint256"},{"name":"toAccountKey","type":"uint256"},{"name":"a","type":"uint256"},{"name":"n","type":"string"}],"name":"internalTransfer","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"tokenRewardsAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"paymentCurrency","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"receiptBook","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"worthBookAccountID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tID","type":"uint256"},{"name":"aID","type":"uint256"},{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"_from","type":"address"},{"name":"amount","type":"uint256"},{"name":"note","type":"string"}],"name":"payment","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"tetherBookAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentMethodInfo","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"paymentMethods","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"paymentMethodsAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"receiptBookAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBookAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"}],"name":"tetherIndex","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tetherBook","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBank","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"tethers","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_tokenID","type":"uint256"},{"name":"from","type":"address"},{"name":"to","type":"address"}],"name":"postTransfer","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"worthBookAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"manageable","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenKeyAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tID","type":"uint256"},{"name":"aID","type":"uint256"},{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"},{"name":"note","type":"string"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"newTokenOwner","type":"address"}],"name":"transferTokenOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"from","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"value","type":"uint256"}],"name":"onTetherBookDeposit","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"manageableAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"paymentMethodCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"inputs":[],"payable":false,"stateMutability":"nonpayable","type":"constructor"},{"anonymous":false,"inputs":[{"indexed":true,"name":"currencyAddress","type":"address"},{"indexed":true,"name":"paymentTokenID","type":"uint256"},{"indexed":true,"name":"info","type":"string"},{"indexed":false,"name":"isValid","type":"bool"}],"name":"UpdatePaymentToken","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"currencyAddress","type":"address"},{"indexed":true,"name":"info","type":"string"}],"name":"StopPaymentMethod","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"from","type":"address"},{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"value","type":"uint256"}],"name":"TetherBookDeposit","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tetherBookAddress","type":"address"},{"indexed":true,"name":"tokenBookAddress","type":"address"},{"indexed":true,"name":"manageableAddress","type":"address"}],"name":"Config1","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"worthBookAddress","type":"address"},{"indexed":true,"name":"receiptBookAddress","type":"address"},{"indexed":true,"name":"tokenRewardsAddress","type":"address"}],"name":"Config2","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"newAddress","type":"address"}],"name":"Deprecate","type":"event"}],
        erc20Interface: [{"constant":true,"inputs":[],"name":"name","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_upgradedAddress","type":"address"}],"name":"deprecate","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"_spender","type":"address"},{"name":"_value","type":"uint256"}],"name":"approve","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"deprecated","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_evilUser","type":"address"}],"name":"addBlackList","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"totalSupply","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_from","type":"address"},{"name":"_to","type":"address"},{"name":"_value","type":"uint256"}],"name":"transferFrom","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"upgradedAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"}],"name":"balances","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"decimals","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"maximumFee","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"_totalSupply","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[],"name":"unpause","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"_maker","type":"address"}],"name":"getBlackListStatus","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"},{"name":"","type":"address"}],"name":"allowed","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"paused","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"who","type":"address"}],"name":"balanceOf","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[],"name":"pause","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"getOwner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"symbol","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_to","type":"address"},{"name":"_value","type":"uint256"}],"name":"transfer","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"newBasisPoints","type":"uint256"},{"name":"newMaxFee","type":"uint256"}],"name":"setParams","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"amount","type":"uint256"}],"name":"issue","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"amount","type":"uint256"}],"name":"redeem","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"_owner","type":"address"},{"name":"_spender","type":"address"}],"name":"allowance","outputs":[{"name":"remaining","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"basisPointsRate","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"}],"name":"isBlackListed","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_clearedUser","type":"address"}],"name":"removeBlackList","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"MAX_UINT","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"_blackListedUser","type":"address"}],"name":"destroyBlackFunds","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"inputs":[{"name":"_initialSupply","type":"uint256"},{"name":"_name","type":"string"},{"name":"_symbol","type":"string"},{"name":"_decimals","type":"uint256"}],"payable":false,"stateMutability":"nonpayable","type":"constructor"},{"anonymous":false,"inputs":[{"indexed":false,"name":"amount","type":"uint256"}],"name":"Issue","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"amount","type":"uint256"}],"name":"Redeem","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"newAddress","type":"address"}],"name":"Deprecate","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"feeBasisPoints","type":"uint256"},{"indexed":false,"name":"maxFee","type":"uint256"}],"name":"Params","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"_blackListedUser","type":"address"},{"indexed":false,"name":"_balance","type":"uint256"}],"name":"DestroyedBlackFunds","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"_user","type":"address"}],"name":"AddedBlackList","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"_user","type":"address"}],"name":"RemovedBlackList","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"owner","type":"address"},{"indexed":true,"name":"spender","type":"address"},{"indexed":false,"name":"value","type":"uint256"}],"name":"Approval","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"from","type":"address"},{"indexed":true,"name":"to","type":"address"},{"indexed":false,"name":"value","type":"uint256"}],"name":"Transfer","type":"event"},{"anonymous":false,"inputs":[],"name":"Pause","type":"event"},{"anonymous":false,"inputs":[],"name":"Unpause","type":"event"}],
        tetherBookContractInterface: [{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"name","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"owners","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_upgradedAddress","type":"address"}],"name":"deprecate","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_owner","type":"address"},{"name":"_spender","type":"address"}],"name":"allowance","outputs":[{"name":"remaining","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"deprecated","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newTokenBookConfigAddress","type":"address"}],"name":"config","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"_evilUser","type":"address"}],"name":"addBlackList","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"isDepletable","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBookConfigAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_from","type":"address"},{"name":"_to","type":"address"},{"name":"_value","type":"uint256"}],"name":"transferFrom","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"address"}],"name":"balances","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"upgradedAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"decimals","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"who","type":"address"}],"name":"balanceOf","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[],"name":"unpause","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"amount","type":"uint256"}],"name":"issue","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"basisPointsRate","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"symbol","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentTokenID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBookConfig","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"maxRtoSupply","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"_totalSupply","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"_maker","type":"address"}],"name":"getBlackListStatus","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tID","type":"uint256"}],"name":"setParams","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"paused","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_value","type":"uint256"}],"name":"sendAmount","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"isStableToken","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_name","type":"string"},{"name":"_symbol","type":"string"},{"name":"_owner","type":"address"},{"name":"stableCoin","type":"bool"},{"name":"depletable","type":"bool"}],"name":"addTether","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"address"},{"name":"","type":"address"}],"name":"allowed","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"amount","type":"uint256"}],"name":"redeem","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[],"name":"pause","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"getOwner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_spender","type":"address"},{"name":"_value","type":"uint256"}],"name":"approve","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_blackListedUser","type":"address"}],"name":"destroyBlackFunds","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"bankID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentMethodID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"maximumFee","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenID","type":"uint256"}],"name":"totalSupply","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_value","type":"uint256"}],"name":"transferFee","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"}],"name":"isBlackListed","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_clearedUser","type":"address"}],"name":"removeBlackList","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"MAX_UINT","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"newTokenOwner","type":"address"}],"name":"transferTokenOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"_to","type":"address"},{"name":"_value","type":"uint256"}],"name":"transfer","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"inputs":[],"payable":false,"stateMutability":"nonpayable","type":"constructor"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tokenBookConfigAddress","type":"address"}],"name":"Config","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"}],"name":"AddTether","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"amount","type":"uint256"}],"name":"Issue","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"amount","type":"uint256"}],"name":"Redeem","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"newAddress","type":"address"}],"name":"Deprecate","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"feeBasisPoints","type":"uint256"},{"indexed":false,"name":"maxFee","type":"uint256"},{"indexed":false,"name":"bankID","type":"uint256"},{"indexed":false,"name":"paymentMethodID","type":"uint256"}],"name":"Params","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tokenID","type":"uint256"},{"indexed":true,"name":"owner","type":"address"},{"indexed":true,"name":"spender","type":"address"},{"indexed":false,"name":"value","type":"uint256"}],"name":"Approval","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"_blackListedUser","type":"address"},{"indexed":false,"name":"_balance","type":"uint256"}],"name":"DestroyedBlackFunds","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"_user","type":"address"}],"name":"AddedBlackList","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"_user","type":"address"}],"name":"RemovedBlackList","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"from","type":"address"},{"indexed":false,"name":"from_balance","type":"uint256"},{"indexed":true,"name":"to","type":"address"},{"indexed":false,"name":"to_balance","type":"uint256"}],"name":"BalanceCheck","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tokenID","type":"uint256"},{"indexed":true,"name":"from","type":"address"},{"indexed":true,"name":"to","type":"address"},{"indexed":false,"name":"value","type":"uint256"}],"name":"Transfer","type":"event"},{"anonymous":false,"inputs":[],"name":"Pause","type":"event"},{"anonymous":false,"inputs":[],"name":"Unpause","type":"event"}],
        tokenBookConfigContractInterface: [{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"owners","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"uint256"}],"name":"updateContractMetaUint","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"contractBools","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"contractUints","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"contractPages","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"contractAddresses","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"tokenUints","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"address"}],"name":"updateContractMetaAddress","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"uint256"}],"name":"updateTokenMetaUint","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"string"}],"name":"updateContractMetaPage","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"address"}],"name":"updateTokenMetaAddress","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"string"}],"name":"updateTokenMetaPage","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"tokenPages","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"tokenBools","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"newTokenOwner","type":"address"}],"name":"transferTokenOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"bool"}],"name":"updateTokenMetaBool","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"metaDataIndex","type":"uint256"},{"name":"metaData","type":"bool"}],"name":"updateContractMetaBool","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"tokenAddresses","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"anonymous":false,"inputs":[{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateContractMetaAddress","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateContractMetaUint","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateContractMetaPage","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateContractMetaBool","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateTokenMetaAddress","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateTokenMetaUint","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateTokenMetaPage","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"metaDataIndex","type":"uint256"}],"name":"UpdateTokenMetaBool","type":"event"}],
        receiptBookContractInterface: [{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"owners","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"bankBalance","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newTokenBookConfigAddress","type":"address"}],"name":"config","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutAccountID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"totalBankPayments","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"accountID","type":"uint256"},{"name":"_paymentTokenID","type":"uint256"},{"name":"_payee","type":"address"},{"name":"note","type":"string"}],"name":"recordPayOut","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentAccountID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"fromAccountKey","type":"uint256"},{"name":"paymentAddressKey","type":"uint256"},{"name":"toAccountKey","type":"uint256"},{"name":"a","type":"uint256"},{"name":"n","type":"string"}],"name":"internalTransfer","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"stockKey","type":"uint256"},{"name":"accountKey","type":"uint256"},{"name":"currencyKey","type":"uint256"},{"name":"_payee","type":"address"},{"name":"amount","type":"uint256"}],"name":"reportPayOut","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"tokenRewardsAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"totalBankPayOuts","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payer","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentTokenID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"totalPayments","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutNote","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"tokenPayOutCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"paymentMethodsAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"bankAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payments","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payee","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutTx","outputs":[{"name":"","type":"bytes32"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutContract","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"stockKey","type":"uint256"},{"name":"accountKey","type":"uint256"},{"name":"currencyKey","type":"uint256"},{"name":"_payer","type":"address"},{"name":"amount","type":"uint256"}],"name":"reportPayment","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutTime","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"}],"name":"tetherIndex","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"totalBalance","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentTx","outputs":[{"name":"","type":"bytes32"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"accountBalance","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"worthBookAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"accountID","type":"uint256"},{"name":"_paymentTokenID","type":"uint256"},{"name":"_payer","type":"address"},{"name":"note","type":"string"}],"name":"recordPayment","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"tokenPayOuts","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentFee","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"totalPayOuts","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"tokenPayments","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutFee","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenKeyAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentTime","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"newTokenOwner","type":"address"}],"name":"transferTokenOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"totalPayOutCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"totalPaymentCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOuts","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentNote","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"tokenPaymentCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"manageableAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"_payment","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"payOutTokenID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"paymentContract","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"inputs":[],"payable":false,"stateMutability":"nonpayable","type":"constructor"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tokenID","type":"uint256"},{"indexed":true,"name":"accountID","type":"uint256"}],"name":"Account","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"noteIndex","type":"uint256"},{"indexed":false,"name":"_from","type":"address"},{"indexed":true,"name":"paymentMethod","type":"address"},{"indexed":true,"name":"paymentTokenID","type":"uint256"},{"indexed":false,"name":"payment","type":"uint256"}],"name":"Payment","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"noteIndex","type":"uint256"},{"indexed":false,"name":"_to","type":"address"},{"indexed":true,"name":"paymentMethod","type":"address"},{"indexed":true,"name":"paymentTokenID","type":"uint256"},{"indexed":false,"name":"payment","type":"uint256"}],"name":"PayOut","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"bankAddress","type":"address"},{"indexed":true,"name":"worthBookAddress","type":"address"},{"indexed":true,"name":"tokenRewardsAddress","type":"address"}],"name":"Config","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"manageableAddress","type":"address"}],"name":"Config2","type":"event"}],
        tokenKeyContractInterface: [{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"owners","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"accountKeyContract","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"}],"name":"addressKeyCreate","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"newTokenBookConfigAddress","type":"address"}],"name":"config","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"accountID","type":"uint256"},{"name":"subAccountID","type":"uint256"}],"name":"subAccountKeyCreate","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"subAccountKeyTokenID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"accountID","type":"uint256"}],"name":"accountKeySet","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"accountKeyTokenID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"accountID","type":"uint256"},{"name":"subAccountID","type":"uint256"}],"name":"subAccountKeySet","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"}],"name":"addressKey","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"subAccountKeySubAccountID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"subAccountKeyContract","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"addressKeyTokenID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"addressKeyContract","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"accountID","type":"uint256"},{"name":"subAccountID","type":"uint256"}],"name":"subAccountKey","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"}],"name":"addressKeySet","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"accountID","type":"uint256"}],"name":"accountKey","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"accountKeyAccountID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenAddress","type":"address"},{"name":"tokenID","type":"uint256"},{"name":"accountID","type":"uint256"}],"name":"accountKeyCreate","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"subAccountKeyAccountID","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"newTokenOwner","type":"address"}],"name":"transferTokenOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"manageableAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"anonymous":false,"inputs":[{"indexed":true,"name":"newManageableAddress","type":"address"}],"name":"Config","type":"event"}],
        tokenBookContractInterface: [{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"owners","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"name","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"_tokenId","type":"uint256"}],"name":"getApproved","outputs":[{"name":"allowedUser","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_approved","type":"address"},{"name":"_tokenId","type":"uint256"}],"name":"approve","outputs":[],"payable":true,"stateMutability":"payable","type":"function"},{"constant":true,"inputs":[],"name":"deprecated","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"newTokenBookConfigAddress","type":"address"}],"name":"config","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"},{"name":"","type":"uint256"}],"name":"verifiedTokenMeta","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"","type":"address"},{"name":"","type":"address"},{"name":"","type":"uint256"},{"name":"","type":"bytes"}],"name":"onERC721Received","outputs":[{"name":"","type":"bytes4"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"tokenBookConfigAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"allowed","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_from","type":"address"},{"name":"_to","type":"address"},{"name":"_tokenId","type":"uint256"}],"name":"transferFrom","outputs":[],"payable":true,"stateMutability":"payable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"},{"name":"","type":"address"}],"name":"operators","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"upgradedAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"}],"name":"balances","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"verifiedToken","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBook","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenKey","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_from","type":"address"},{"name":"_to","type":"address"},{"name":"_tokenId","type":"uint256"}],"name":"safeTransferFrom","outputs":[],"payable":true,"stateMutability":"payable","type":"function"},{"constant":false,"inputs":[{"name":"tokenOwner","type":"address"},{"name":"tokenAdmin","type":"address"},{"name":"tokenManager","type":"address"},{"name":"tokenData","type":"string"},{"name":"metaData","type":"string"}],"name":"addToken","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"sC","type":"address"},{"name":"ptID","type":"uint256"},{"name":"pay_to","type":"address"},{"name":"a","type":"uint256"}],"name":"payOut","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"tokens","outputs":[{"name":"","type":"string"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBookConfig","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"uint256"}],"name":"isPublic","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"_tokenId","type":"uint256"}],"name":"ownerOf","outputs":[{"name":"owner","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"metaDataIndex","type":"uint256"},{"name":"tokenMetaPage","type":"uint256"},{"name":"verified","type":"bool"}],"name":"verifyTokenMeta","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"_owner","type":"address"}],"name":"balanceOf","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"contractAddress","type":"address"},{"name":"newExecutive","type":"address"}],"name":"transferExecutive","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"owner","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenBookAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_operator","type":"address"},{"name":"_approved","type":"bool"}],"name":"setApprovalForAll","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"tokenCnt","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"_from","type":"address"},{"name":"_to","type":"address"},{"name":"_tokenId","type":"uint256"},{"name":"data","type":"bytes"}],"name":"safeTransferFrom","outputs":[],"payable":true,"stateMutability":"payable","type":"function"},{"constant":true,"inputs":[],"name":"tokenMetaAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"tokenKeyAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[],"name":"MAX_UINT","outputs":[{"name":"","type":"uint256"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":true,"inputs":[{"name":"","type":"address"},{"name":"","type":"address"}],"name":"executives","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"metaDataIndex","type":"uint256"},{"name":"verified","type":"bool"}],"name":"verifyToken","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[{"name":"_owner","type":"address"},{"name":"_operator","type":"address"}],"name":"isApprovedForAll","outputs":[{"name":"","type":"bool"}],"payable":false,"stateMutability":"view","type":"function"},{"constant":false,"inputs":[{"name":"tokenID","type":"uint256"},{"name":"newTokenOwner","type":"address"}],"name":"transferTokenOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"","type":"address"},{"name":"","type":"uint256"},{"name":"","type":"bytes"}],"name":"onERC721Received","outputs":[{"name":"","type":"bytes4"}],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"newOwner","type":"address"}],"name":"transferOwnership","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":false,"inputs":[{"name":"contractAddress","type":"address"},{"name":"newExecutive","type":"address"},{"name":"isExecutive","type":"bool"}],"name":"updateExecutive","outputs":[],"payable":false,"stateMutability":"nonpayable","type":"function"},{"constant":true,"inputs":[],"name":"manageableAddress","outputs":[{"name":"","type":"address"}],"payable":false,"stateMutability":"view","type":"function"},{"inputs":[{"name":"_name","type":"string"}],"payable":false,"stateMutability":"nonpayable","type":"constructor"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tokenOwner","type":"address"},{"indexed":true,"name":"tokenAdmin","type":"address"},{"indexed":true,"name":"tokenManager","type":"address"},{"indexed":false,"name":"tokenID","type":"uint256"}],"name":"AddToken","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"}],"name":"UpdateToken","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"}],"name":"UpdateMetaPage","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"tokenMetaID","type":"uint256"}],"name":"UpdateTokenMetaPage","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"tokenMetaID","type":"uint256"}],"name":"AddTokenMetaPage","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"verified","type":"bool"}],"name":"VerifyToken","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"tokenID","type":"uint256"},{"indexed":false,"name":"tokenMetaPage","type":"uint256"},{"indexed":false,"name":"verified","type":"bool"}],"name":"VerifyTokenMeta","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"tokenBookConfigAddress","type":"address"},{"indexed":true,"name":"manageableAddress","type":"address"},{"indexed":true,"name":"tokenMetaAddress","type":"address"}],"name":"Config","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"newTokenBookAddress","type":"address"},{"indexed":true,"name":"newTokenKeyAddress","type":"address"}],"name":"Config","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"owner","type":"address"},{"indexed":false,"name":"opperator","type":"address"},{"indexed":false,"name":"hasAccess","type":"bool"}],"name":"updateOperatorAccess","type":"event"},{"anonymous":false,"inputs":[{"indexed":false,"name":"manager","type":"address"},{"indexed":false,"name":"hasAccess","type":"bool"}],"name":"updateExecutiveAccess","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"_from","type":"address"},{"indexed":true,"name":"_to","type":"address"},{"indexed":true,"name":"_tokenId","type":"uint256"}],"name":"Transfer","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"_owner","type":"address"},{"indexed":true,"name":"_approved","type":"address"},{"indexed":true,"name":"_tokenId","type":"uint256"}],"name":"Approval","type":"event"},{"anonymous":false,"inputs":[{"indexed":true,"name":"_owner","type":"address"},{"indexed":true,"name":"_operator","type":"address"},{"indexed":false,"name":"_approved","type":"bool"}],"name":"ApprovalForAll","type":"event"}],
        // Syncing/loading states for this page.
        syncingOpenCheckout: false,
        syncingUpdateCard: false,
        syncingRemoveCard: false,
        checkoutAction:"depositUnits",
        toAccountId:"",

        tokenPaymentMethodAddressIdIndex:5,
        tokenPaymentMethodTokenIdIndex:2,

        standardPaymentMethodAddressIdIndex:5,
        standardPaymentMethodTokenIdIndex:2,
        paymentAccountId:0,
        tokenCustomParamsIdIndex:1,
        
        // Form data
        formData: { 
          transferType: "internal",
          transferNetwork: "lightning"
        },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // Syncing / loading state
        syncing: false,

        // Server error state
        cloudError: '',

        // Success state when form has been submitted
        cloudSuccess: false,

        userType:"",
        primeTrustForcePayment:"",
        adminAccount:{},
        exchangeError:"",
        error:{},
        appTokenAccounts:[],
        spendAccountIdFilter:[],
        accountIdFilter:[],
        tokens:[],
        spendAccounts:[],
        internalAccounts:[],
        accounts:[],
        stripePublishableKey: "",
        appToken:{},
        stableToken:{},
        trasnferView:"",
        environment:"",

        loadingTransfer: true,
        cloudLoadingError: '',

        accountKeys : {},
        accountBalances : {},
        _networkAccounts : {},

        accountsById : {},
        accountKeys : {},
        accountBalances : {},
        tokenKeyContract : {},
        receiptBookContract : {},
        tokenBankContractAddress : "",
        currentUserAddress : "",
        networkAccounts : [],
        paymentMethodSymbol : "",
        token : {},
        networkTokenBankAddresses : {
          ropsten: "0xd938FF47d23458B33f993fBb7Ba22cE1A3fd621d",
          goerli: "0xd938FF47d23458B33f993fBb7Ba22cE1A3fd621d",
        }

            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="transfer-network-component" :class="network" >

        <form action="transfer" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">

            <div v-if="trasnferView !== 'exchange'" class="form-group">
                <label for="transfer-type">Type</label>
                <select class="form-control" @change="changeTransferType" id="transferType" type="text"  :class="[formErrors.transferType ? 'is-invalid' : '']" v-model.trim="formData.transferType" focus-first>
                <option v-if="trasnferView == 'exchange'" selected="selected" value="exchange">Payment</option>
                <option v-else selected="selected" value="payment">Payment</option>
                <option v-if="trasnferView !== 'exchange'" value="internal">Internal Transfer</option>
                <option v-if="trasnferView !== 'exchange'" value="deposit">Deposit</option>
                <option value="external">Withdrawal</option>
                </select>
                <div class="invalid-feedback" v-if="formErrors.transferType">Select this transfer type.</div>
            </div>

            <div class="form-group transferType internal external" style="display:none">
                <label for="fromAccountId">From</label>
                
                <select v-model.trim="formData.fromAccountId" class="form-control title transferNetwork unitedcoin" id="fromAccountId" type="text"  :class="[formErrors.fromAccountId ? 'is-invalid' : '']">
                    <option v-for="account in internalAccounts"  :value="account.id" v-if=" account.ownerType == 'token' "> {{account.wallet.name }} ({{account.name}}) - {{account.spendingBalance.toFixed(2)}} {{account.displaySymbol}} </option>
                </select>

        
                <select v-model.trim="formData.fromAccountId" class="form-control title transferNetwork network" id="fromAccountId" type="text"  :class="[formErrors.fromAccountId ? 'is-invalid' : '']">
                    <option v-for="account in networkAccounts"  :value="account.id" v-if=" account.ownerType == 'token' "> {{account.wallet.name }} ({{account.name}}) - {{account.spendingBalance.toFixed(2)}} {{account.displaySymbol}} </option>
                </select>
            
                <div class="invalid-feedback" v-if="formErrors.fromAccountId">Select which account this transfer is coming fromAccountId.</div>
            </div>

            <div class="form-group transferType payment" >
                <label for="fromAccountId">From</label>
                
                <select v-if="trasnferView == 'exchange'"  v-model.trim="formData.fromSpendAccountId" class="form-control title" id="fromSpendAccountId" type="text"  :class="[formErrors.fromSpendAccountId ? 'is-invalid' : '']">
                    <option  value="myWallet" class="blockchain"> My Wallet </option>
                    <option v-for="spendAccount in spendAccounts" v-if="spendAccount.ownerType == 'token' "  :value="spendAccount.id"> {{spendAccount.wallet.name }} ({{spendAccount.name}}) - {{spendAccount.spendingBalance.toFixed(2)}} {{spendAccount.currency.name}}  </option>
                </select>
                
                <select v-else v-model.trim="formData.fromSpendAccountId" class="form-control title transferNetwork unitedcoin" id="fromSpendAccountId" type="text"  :class="[formErrors.fromSpendAccountId ? 'is-invalid' : '']">
                    
                    <option v-for="spendAccount in spendAccounts" v-if="spendAccountIdFilter.includes(spendAccount.bankAccountId) 
                    && spendAccount.ownerType == 'token' "  :value="spendAccount.id"> {{spendAccount.wallet.name }} ({{spendAccount.name}}) - {{spendAccount.spendingBalance.toFixed(2)}} {{spendAccount.displaySymbol ? spendAccount.displaySymbol : spendAccount.currency.symbol }}  </option>
                </select>

            
                <select style="display:none" v-model.trim="formData.fromSpendAccountId" class="form-control title transferNetwork network" id="fromSpendAccountId" type="text"  :class="[formErrors.fromSpendAccountId ? 'is-invalid' : '']">
                    <option  value="myWallet" class="blockchain"> My Wallet </option>
                    
                    <option v-for="spendAccount in networkAccounts" v-if="spendAccountIdFilter.includes(spendAccount.bankAccountId) 
                    && spendAccount.ownerType == 'token' "  :value="spendAccount.id"> {{spendAccount.wallet.name }} ({{spendAccount.name}}) - {{spendAccount.spendingBalance.toFixed(2)}} {{spendAccount.displaySymbol ? spendAccount.displaySymbol : spendAccount.currency.symbol }}  </option>
                </select>
                
                
                <div class="invalid-feedback" v-if="formErrors.fromAccountId">Select which account this transfer is coming fromAccountId.</div>
            </div>
                      



        </form>
        
      
    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.userType = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          this.formData.transferType = this.trasnferView == "exchange" ? "exchange":"payment"
          this.formData.fromSpendAccountId = this.trasnferView == "exchange" && this.spendAccounts[0] ? this.spendAccounts[0].id:undefined;
          $(".msg").hide();
          Transfer.syncing = false;
            Transfer.loadingTransfer = false;
        //   await this.listen();  

    },
    mounted: async function() {
        //…
      $(".msg").hide();



    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Transfer = this;
      
        //show loading// syincing
        this.loadingTransfer = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getTransfer.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingTransfer = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingTransfer = false;
        // }

        // var csrf = await CSRF.token();
        //   var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              // url: '/api/transferAccounts',
              url: '/wp-json/yohshow/api/v1/transfer/overview',
              data: {userType:this.userType},
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                  resData = JSON.parse(resData);
                  if(resData.flag){
                    _.extend(Transfer, resData);
                    Transfer.syncing = false;
                    Transfer.loadingTransfer = false;
                    $(".msg").hide();
                    Transfer.formData = { 
                      transferType: "payment",
                      transferNetwork: "lightning"
                    };
                    setTimeout(myGreeting, 5000);

                    setTimeout(() => {
                      Transfer.changeTransferType();
                    }, "1000");
                    
                    
        
                  }else if(resData.mustLogin){
                    window.location.href = resData.redirect;
                  } else{
                    Transfer.loadingTransfer = false;
                    Transfer.syncing = false;

                  }
    
                }
              });
  
  
        // var csrf = await CSRF.token();
        //   console.log('csrf',csrf);
        //   var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        // io.socket.request({
        //     method: 'post',
        //     url: '/api/transferAccounts',
        //     data: {tradeType:this.tradeType,symbol:this.symbol},
        //     headers: apiRequestHeader
        //   }, function (resData, jwres) {
  
        //     if(resData.flag){
        //       _.extend(Transfer, resData);
        //       Transfer.loadingTransfer = false;
        //       $(".msg").hide();
  
        //     }else if(resData.mustLogin){
        //       window.location.href = resData.redirect;
        //     } else{
        //       Transfer.loadingTransfer = false;
        //     }
            
        //     if (jwres.error) {
        //       console.log(jwres.statusCode); // => e.g. 403
        //       this.cloudLoadingError = true;
  
        //       return;
        //     }
          
        //     console.log(jwres.statusCode); // => e.g. 200
          
        // });
  
      },
      transfer: async function(data) {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Transfer = this;
      
        //show loading// syincing
        this.syncing = true;

        // var csrf = await CSRF.token();
        //   var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
          return $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              // url: '/api/transferAccounts',
              url: '/wp-json/yohshow/api/v1/account/transfer/',
              data:data,
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                  resData = JSON.parse(resData);
                  if(resData.flag){
                    // _.extend(Transfer, resData);
                    Transfer.syncing = false;
                    // $(".msg").hide();
                    // Transfer.changeTransferType();
                    // Transfer.changeTransferNetwork();
                    
        
                  }else if(resData.mustLogin){
                    window.location.href = resData.redirect;
                  } else{
                    Transfer.syncing = false;
                  }
                  return resData;
    
                }
              });
  

  
      },
      transferWeb3: async function(data) {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Transfer = this;
      
        //show loading// syincing
        this.syncing = true;

        let web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");
        var accountsRequestResult = await web3.eth.requestAccounts();
        var currentUserAddress = accountsRequestResult[0];
        console.log("transferWeb3 currentUserAddress",currentUserAddress);
        data.fromAddress = currentUserAddress;
        data.getWeb3Transactions = true;

        // var csrf = await CSRF.token();
        //   var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
          return $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              // url: '/api/transferAccounts',
              url: '/wp-json/yohshow/api/v1/account/transfer',
              data:data,
                // headers:apiRequestHeader,
                success: async function(resData, textStatus, request)
                {
                  resData = JSON.parse(resData);
                  if(resData.flag){
                    var executeTransactionsResult = await Transfer.executeTransactions(resData.transactions);
                    if(executeTransactionsResult.success){
                      // should say syncing because this result with last transaction hash executed must be sent to the backend 
                      // Transfer.syncing = false;
                      return executeTransactionsResult;

                    }else{
                      Transfer.syncing = false;

                    }
        
                    
        
                  }else if(resData.mustLogin){
                    window.location.href = resData.redirect;
                  } else{
                    Transfer.syncing = false;
                  }
                  return resData;
    
                }
              });
  

  
      },
      executeTransactions: async function(transactions) {
        try {
          var problem = false;

          let web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");
          var accountsRequestResult = await web3.eth.requestAccounts();
          var currentUserAddress = accountsRequestResult[0];
          console.log("executeTransactions currentUserAddress",currentUserAddress);
          var lastTransactionHash = false;
          var transactionResults = [];

          for (let i = 0; i < transactions.length; i++) {
            var transaction = transactions[i];
            transaction.from = currentUserAddress;

                

            var send = await web3.eth.sendTransaction(transaction);
            
            lastTransactionHash = send.transactionHash;
            transactionResults.push(send);
            console.log('execute transactions  transaction result send',send);
            console.log('execute transactions  transaction result lastTransactionHash',lastTransactionHash);

            
          }
          var success = true;

          
        } catch (error) {
          var success = false;
          var problem = error;
        }

        return {
          success:success,
          flag:success,
          lastTransactionHash:lastTransactionHash,
          error:problem,
        }

      },
      changeTransferType: function(e) {
        var type = $("#transferType").val();
        this.formData.type = type;
        // var isFreeze = $(e.target).hasClass("freeze");
        // var isClose = $(e.target).hasClass("close");
        // var isView = $(e.target).hasClass("view");
        // var isOpen = $(e.target).hasClass("open");
        $(".nav-transfers .transferType").hide();
        $(".nav-transfers ."+type).show();
        this.changeTransferNetwork();

      },
      changeTransferNetwork: function(e) {
        var network = this.network;
        this.formData.network = network;
        // var isFreeze = $(e.target).hasClass("freeze");
        // var isClose = $(e.target).hasClass("close");
        // var isView = $(e.target).hasClass("view");
        // var isOpen = $(e.target).hasClass("open");
        if(network == "lightning"){
          var networkClass = network;
        }else{
          var networkClass = "network";
        }
        $(".nav-transfers .transferNetwork").hide();
        $(".nav-transfers ."+networkClass).show();
      },
      submittedForm: async function(result) {
        var Transfer = this;
        result = JSON.parse(result);
        console.log("submittedForm");
        this.syncing = true;
        if(result.flag){
          //show success emssage
          $(".success").show();
        }else{
          // show error message
          $(".error").show();

          if(result.msg){
            $(".error").html(result.msg);
          }else{
          $(".error").html("There was an error completing your transfer.");

          }
          
          this.syncing = false;
  
        }
  
        setTimeout( async function(){ 
          $(".msg").hide(); 
          if(result.flag){
            //show success emssage
            // window.location = '/cards';
            // location.reload();
            await Transfer.listen();
            // this.$router.push(redirectLink);
  
          }
        
        }, 3000);
  
        
      },
  
      handleParsingForm: async function() {
        // Clear out any pre-existing error messages.

        this.formErrors = {};
    
          var argins = this.formData;
          var Transfer = this;
        
  
        // Validate type:
        if(!argins.transferType) {
          this.formErrors.transferType = true;
        }
        
        // Validate description:
        if(!argins.amount) {
          this.formErrors.amount = true;
        }
        if(argins.transferType == "payment"){
          var validToPayment = this.validPhoneOrEmail(argins.toPayment);
          console.log("validToPayment",validToPayment);
          if(!validToPayment){
            this.formErrors.toPayment = true;
          }
        }else{
          
        }
        
        // Validate name:
        if(argins.transferType == "deposit"){
          if(!argins.toDeposit) {
            this.formErrors.toDeposit = true;
          }
        }else if(argins.transferType == "internal"){
          if(!argins.toInternal) {
            this.formErrors.toInternal = true;
          }
        }else if(!argins.fromAccountId) {
          this.formErrors.fromAccountId = true;
        }
        if(argins.transferType == "external"){
          // if(!argins.accountNumber) {
          //   this.formErrors.accountNumber = true;
          // }
          // if(!argins.routingNumber) {
          //   this.formErrors.routingNumber = true;
          // }
        }
  
  
        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }
        if(argins.transferNetwork == "lightning"){
          if (argins.transferType == "deposit") {
            //start synicing
            this.syncing = true;
            this.toAccountId =  argins.toDeposit;
            // add depposite amount to cart
            $(".stable-token .quantity").val(argins.amount);
            // check out
          
            setTimeout(function(){ $(".stable-token .cart" ).click(); }, 1000);
            setTimeout(function(){ $(".checkout").click(); }, 3000);
            return;
          }else if (argins.transferType == "external" && Transfer.mustOnboard) {
            //start synicing
            this.syncing = true;
            window.location.href =Transfer.onboardUrl;
            return;
          }
          
          // if (argins.fromSpendAccountId == "myWallet") {
          //   this.syncing = true;

          //   var tokenBankContractAddress = this.tokenBankContractAddress;
          //   var tokenBankContractInterface = this.tokenBankContractInterface;
          //   var tetherBookContractInterface = this.tetherBookContractInterface;
          //   var erc20Interface = this.erc20Interface;
          //   var currentUserAddress = this.currentUserAddress;
          //   var paymentMethodAddress = this.paymentMethodAddress;
          //   var paymentMethodTokenId = this.paymentMethodTokenId;
          //   var tokenPaymentMethodAddressIdIndex = this.tokenPaymentMethodAddressIdIndex;
          //   var tokenPaymentMethodTokenIdIndex = this.tokenPaymentMethodTokenIdIndex;
          //   var standardPaymentMethodAddressIdIndex = this.standardPaymentMethodAddressIdIndex;
          //   var standardPaymentMethodTokenIdIndex = this.standardPaymentMethodTokenIdIndex;
          //   var paymentAccountId = this.paymentAccountId;
          //   var tokenCustomParamsIdIndex = this.tokenCustomParamsIdIndex;


          //   var paymentAmount = argins.amount;
          //   var note = argins.note;
          //   var to = argins.toPayment;
          //   if(argins.transferType == "payment"){
          //     var tokenId = parseInt(to);

          //   }else if(argins.transferType == "payout"){
          //     var fromAccountId = this.fromAccountId;
          //     var fromAccountIdList = this.fromAccountId.split("_");
          //     var tokenId = fromAccountIdList[0];
          //     var transactionAccountId = fromAccountIdList[1];
              
          //   }
          //   if(!tokenId || tokenId <= 0){
          //     this.formErrors.invalidTokenId = true;
          //     return;


          //   }
          //   //get bank smart contract //
          //   //get token id //
          //   //get token paymenthod //
          //   //get payment amount //
          //   //create payment transactions //

          //   //start syncing //

          //   //get alloance for payment amount / request approval //
          //   //excute payment transaction //
          //   //if trandasaction approved// 
          //     // show success
          //     //reload page // listen
          //   //else 
          //     // end synicng //
          //     //show transacion canceled message //
          //     // hid transaction cacnelled message after 3 seconds //

          //   let web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");
          //   var Contract = web3.eth.Contract;
          //   // var Contract = require('web3-eth-contract');

          //   // set provider for all later instances to use
          //   Contract.setProvider(Web3.givenProvider || "ws://localhost:8545");
          //   // Contract.setProvider('ws://localhost:8546');

          //   var accountsRequestResult = await web3.eth.requestAccounts();
          //   var currentUserAddress = accountsRequestResult[0];

          //   /*
          //       // TetherBook tetherBook = TetherBook(tetherBookAddress);
          //   uint _paymentMethodID = tetherBook.paymentMethodID(tID);
          //   uint _paymentTokenID = tetherBook.paymentTokenID(tID);
          //   bool customParams = tokenBookConfig.tokenBools(tID,1);
          //       address _paymentMethod;
          //       if(customParams){
          //           _paymentMethod = tokenBookConfig.tokenAddresses(tID,_paymentMethodID);
        
          //       }else{
          //           _paymentMethod = tokenBookConfig.contractAddresses(_paymentMethodID);
          //       }
          //   bool paidOut = bank.payOut(tID, worthBookID, _paymentMethod, _paymentTokenID, pay_to, amount, note);
          //   */
            
          //   var tokenBankContract = new Contract(tokenBankContractInterface, tokenBankContractAddress);
          //   // var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress({}).call({from:currentUserAddress});

          //   var tokenPaymentMethod = await this.tokenPaymentMethod(tokenId);
          //   if(!tokenPaymentMethod.success){
          //     this.formErrors.paymentMethodError = true;
          //     this.formErrors.cloudError = true;
          //     return;

          //   }else{
          //     var tokenPaymentMethodAddress = tokenPaymentMethod.tokenPaymentMethodAddress;
          //     var tokenPaymentMethodTokenId = tokenPaymentMethod.tokenPaymentMethodTokenId;
          //   }

          //   if(argins.transferType == "payment"){
          //     var transactionAccountId = this.paymentAccountId;
          //     // bool customParams = tokenBookConfig.tokenBools(_tokenID,1);
          //     // function payment(uint tID, uint aID, address sC, uint ptID, address _from, uint amount, string memory note ) public  {

          //     // must approve before 

          //       var paymentTransactionResult = await tokenBankContract.methods.payment(tokenId,transactionAccountId,tokenPaymentMethodAddress,tokenPaymentMethodTokenId,currentUserAddress,amount,note).send({from:currentUserAddress});
          //   }else if(argins.transferType == "payout"){
          //     var fromAccountId = this.fromAccountId;
          //     var fromAccountIdList = fromAccountId.split("_");
          //     var tokenId = fromAccountIdList[0];
          //     var transactionAccountId = fromAccountIdList[1];
              
          //     // bool customParams = tokenBookConfig.tokenBools(_tokenID,1);
          //     // function payment(uint tID, uint aID, address sC, uint ptID, address _from, uint amount, string memory note ) public  {

          //       var paymentTransactionResult = await tokenBankContract.methods.payout(tokenId,transactionAccountId,tokenPaymentMethodAddress,tokenPaymentMethodTokenId,currentUserAddress,amount,note).send({from:currentUserAddress});
          //   }else if(argins.transferType == "internal" ){
          //     var fromAccountId = this.fromAccountId;
          //     var fromAccountIdList = fromAccountId.split("_");
          //     var fromTokenId = fromAccountIdList[0];
          //     var fromTransactionAccountId = fromAccountIdList[1];

          //     var toAccountId = this.toAccountId;
          //     var toAccountIdList = toAccountId.split("_");
          //     var toTokenId = toAccountIdList[0];
          //     var toTransactionAccountId = toAccountIdList[1];
              
          //     // bool customParams = tokenBookConfig.tokenBools(_tokenID,1);
          //     // function payment(uint tID, uint aID, address sC, uint ptID, address _from, uint amount, string memory note ) public  {

          //       var paymentTransactionResult = await tokenBankContract.methods.internalTransfer(tokenId,transactionAccountId,tokenPaymentMethodAddress,tokenPaymentMethodTokenId,currentUserAddress,amount,note).send({from:currentUserAddress});
          //   }


            
            

          

        


            
          //   /*
          //     get tetherBookAddress
          //     get tokenBookConfigAddress from tetherBookAddress
          //   */

          //   var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress({}).call({from:currentUserAddress});


          //   var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress().call({from:currentUserAddress});
          //   // var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress();
          //   // var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress();
            
          //   // var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress().send({from: currentUserAddress})
          //   // .on('receipt', function(){
          //   //     return result;
          //   // });
          //   var paymentMethodTokenID = await tokenBankContract.methods.paymentMethodTokenID().send({from: currentUserAddress})
          //   .on('receipt', function(){
          //       return result;
          //   });

          //   var paymentMethodContract = new Contract(erc20Interface, paymentMethodsAddress);

          //   var allowanceResult = await paymentMethodContract.methods.approve(tokenBankContractAddress, paymentAmount).send({from: currentUserAddress})
          //   .on('receipt', function(){
          //       return result;
          //   });

          //   if(allowanceResult.success){
          //     var paymentResult = await tokenBankContract.methods.payment(tokenId,paymentMethodsAddress,paymentMethodTokenID,paymentAmount,note).send({from: currentUserAddress})
          //     .on('receipt', function(){
          //         return result;
          //     });
          //     paymentResult.flag = success;
             
          //     if(!paymentResult.success){
          //       // this.formErrors.blockchainPaymentError = true;
          //       paymentResult.blockchainPaymentError = true;

          //     }
          //     await this.submittedForm(paymentResult);

          //   }else{
          //       // this.formErrors.blockchainAllowanceError = true;
          //       paymentResult.blockchainAllowanceError = true;
          //       await this.submittedForm(paymentResult);
          //   }

   

           
          // }
          this.syncing = true;
          argins.type = argins.transferType;
    
          //todo return if ajax works
          // return argins;

          //no ajaxform method
          // this.syncing = true;
          
          var transferResult = await Transfer.transfer(argins);
          var transferResultSubmited =  await Transfer.submittedForm(transferResult);
        
        return ;

        }else{
          //blockchain shit
          
          var transferWeb3Result = await Transfer.transferWeb3(argins);
          if(transferWeb3Result.success){
            argins.transactionHash = transferWeb3Result.transactionHash;
            var transferResult = await Transfer.transfer(argins);
            var transferResultSubmited =  await Transfer.submittedForm(transferResult);
          }
          

        }
  
        
      },
      tokenPaymentMethod: async function(tokenId){
          try {
            var tokenBankContractAddress = this.tokenBankContractAddress;
            var tokenBankContractInterface = this.tokenBankContractInterface;
            var tokenKeyContractInterface = this.tokenKeyContractInterface;

            var tetherBookContractInterface = this.tetherBookContractInterface;
            var erc20Interface = this.erc20Interface;
            var currentUserAddress = this.currentUserAddress;
            var paymentMethodAddress = this.paymentMethodAddress;
            var paymentMethodTokenId = this.paymentMethodTokenId;
            var tokenPaymentMethodAddressIdIndex = this.tokenPaymentMethodAddressIdIndex;
            var tokenPaymentMethodTokenIdIndex = this.tokenPaymentMethodTokenIdIndex;
            var standardPaymentMethodAddressIdIndex = this.standardPaymentMethodAddressIdIndex;
            var standardPaymentMethodTokenIdIndex = this.standardPaymentMethodTokenIdIndex;
            var paymentAccountId = this.paymentAccountId;
            var tokenCustomParamsIdIndex = this.tokenCustomParamsIdIndex;

          var tokenBankContract = new Contract(tokenBankContractInterface, tokenBankContractAddress);

          var paymentMethodsAddress = await tokenBankContract.methods.paymentMethodsAddress({}).call({from:currentUserAddress});
          var tetherBookContractAddress = await tokenBankContract.methods.tetherBookAddress({}).call({from:currentUserAddress});
          var tokenKeyContractAddress = await tokenBankContract.methods.tokenKeyAddress({}).call({from:currentUserAddress});

          var tetherBookContract = new Contract(tetherBookContractInterface, tetherBookContractAddress);
          var tokenKeyContract = new Contract(tokenKeyContractInterface, tokenKeyContractAddress);


          var tokenBookConfigContractAddress = await tetherBookContract.methods.tokenBookConfigAddress({}).call({from:currentUserAddress});
          
          var tokenPaymentMethodAddressIdIndex = await tetherBookContract.methods.paymentMethodID(tokenId).call({from:currentUserAddress});
          var tokenPaymentMethodTokenId = await tetherBookContract.methods.paymentTokenID(tokenId).call({from:currentUserAddress});
          
          var tokenBookConfigContract = new Contract(tokenBookConfigContractInterface, tokenBookConfigContractAddress);

          var tokenCustomParams = await tokenBookConfigContract.methods.tokenBools(tokenId, tokenCustomParamsIdIndex).call({from:currentUserAddress});
          if(tokenCustomParams){
            var tokenPaymentMethodAddress = await tokenBookConfigContract.methods.tokenAddresses(tokenId, tokenPaymentMethodAddressIdIndex).call({from:currentUserAddress});

          }else{
            var tokenPaymentMethodAddress = await tokenBookConfigContract.methods.contractAddresses(tokenId, tokenPaymentMethodAddressIdIndex).call({from:currentUserAddress});
          }
          var currecyKey = await tokenKeyContract.methods.addressKey(tokenPaymentMethodAddress,tokenPaymentMethodTokenId).call({from:currentUserAddress});

          if(tokenPaymentMethodTokenId == 0){
            var tokenPaymentMethodContract = new Contract(tokenPaymentMethodAddress, erc20Interface);
            var symbol = await tokenPaymentMethodContract.methods.symbol().call({from:currentUserAddress});

          }else{
            var tokenPaymentMethodContract = new Contract(tokenPaymentMethodAddress, tetherBookContractInterface);
            var symbol = await tokenPaymentMethodContract.methods.symbol(tokenPaymentMethodTokenId).call({from:currentUserAddress});


          }

          return {
            success:true,
            currecyKey:currecyKey,
            symbol:symbol,
            tokenPaymentMethodAddress:tokenPaymentMethodAddress,
            tokenPaymentMethodTokenId:tokenPaymentMethodTokenId,
          }
            
          } catch (error) {
            return {
              success:false,
              error:error,
            }
            
          }
          
      },
      importBalances: async function(){
        /*
        import all nfts from token book
          permission
            import kurrent owner and get owner managers
            see tokenbook konfig to see if permission is given to nft
            db - addresses and akkouts
          balankes
            get balankes 
            db -  akkouts





          get current balances
            code
              function hasOnlyAccountAdminPermission ( address objectID, uint256 _tokenID, uint256 _aID, address sender, uint senderTID) public  view returns (bool) {
              Manageable object = Manageable(objectID);
              address _tokenOwner = object.owners(_tokenID);
              bool accountKeySet = tokenKey.accountKeySet(objectID,_tokenID,_aID);
              bool senderKeySet = tokenKey.addressKeySet(sender,senderTID);
              require(accountKeySet,"addressKeySet not set");
              require(senderKeySet,"senderKeySet not set");

              uint accountKey = tokenKey.accountKey(objectID,_tokenID,_aID);
              uint senderKey = tokenKey.addressKey(sender,0);
              bool permission = admins[_tokenOwner][accountKey][senderKey] == true;
              return permission ;
            }



          



                    mapping (address => mapping (uint => mapping (uint => bool))) public admins;
            mapping (address => mapping (uint => mapping (uint => bool))) public accountAdmins;

                //bankBalance[currencyKey] = currencyBalance
                mapping(uint => uint)  public bankBalance;
                //totalBankPayments[currencyKey] = totalCurrencyPayments
                mapping(uint => uint)  public totalBankPayments;
                //totalBankPayOuts[currencyKey] = totalCurrencyPayOuts
                mapping(uint => uint)  public totalBankPayOuts;


                //totalPayments[accountKey][currencyKey] = totalPayments
                mapping(uint => mapping(uint => uint ) ) public totalPayments;
                //totalPayOuts[accountKey][currencyKey] = totalPayOuts
                mapping(uint => mapping(uint => uint ) ) public totalPayOuts;
                //accountBalance[accountKey][currencyKey] = accountBalance
                mapping(uint => mapping(uint => uint ) ) public accountBalance;
                //totalBalance[tokenKey][currencyKey] = totalBalance
                mapping(uint => mapping(uint => uint ) ) public totalBalance;
            logic
              get list of all token ids //
              get user contract key //
              get list of spend account ids 
              for each token 
                get token key //
                for each spend account
                  //spend account for payment method

                does user have account admin access
                  get account keys
                  get total balance
                  save account balance in accounts array
              need to loop through every reserve and spend account to get other token balances




        */



                  let web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");
                  var Contract = web3.eth.Contract;
                  // var Contract = require('web3-eth-contract');
      
                  // set provider for all later instances to use
                  Contract.setProvider(Web3.givenProvider || "ws://localhost:8545");
                  // Contract.setProvider('ws://localhost:8546');
      
                  var accountsRequestResult = await web3.eth.requestAccounts();

                  var currentUserAddress = accountsRequestResult[0];
                  var transferNetwork =  this.formDataTransferNetwork;
                  var networkTokenBankAddresses =  this.networkTokenBankAddresses; // get from bakend
                  var tokenBankContractAddress = networkTokenBankAddresses[transferNetwork];
                  
         
                  var tokenBankContractInterface = this.tokenBankContractInterface;
                  var tokenKeyContractInterface = this.tokenKeyContractInterface;
                  var tokenBookContractInterface = this.tokenBookContractInterface;
                  var receiptBookContractInterface = this.receiptBookContractInterface;
                  var spendAccountIdFilter = this.spendAccountIdFilter;
                  var accountsById = this.accountsById;
                  // var currentUserAddress = currentUserAddress;
                  var tokens = this.tokens;
                  var tokensDict = {}

                  var tokenBankContract = new Contract(tokenBankContractInterface, tokenBankContractAddress);

      
                  // var tetherBookContractAddress = await tokenBankContract.methods.tetherBookAddress({}).call({from:currentUserAddress});
                  var tokenKeyContractAddress = await tokenBankContract.methods.tokenKeyAddress({}).call({from:currentUserAddress});
                  var tokenBookContractAddress = await tokenBankContract.methods.tokenBookAddress({}).call({from:currentUserAddress});
                  var receiptBookContractAddress = await tokenBankContract.methods.receiptBookAddress({}).call({from:currentUserAddress});

                  // var tetherBookContract = new Contract(tetherBookContractInterface, tetherBookContractAddress);
                  var tokenKeyContract = new Contract(tokenKeyContractInterface, tokenKeyContractAddress);
                  // var tokenBookContract = new Contract(tokenBookContractInterface, tokenBookContractAddress);
                  var receiptBookContract = new Contract(receiptBookContractInterface, receiptBookContractAddress);
                  
                  

                  var senderKey = await tokenKeyContract.methods.addressKey(currentUserAddress,0).call({from:currentUserAddress});

                  var networkAccounts = [];
                  var tokenKeys = [];
            


                  this.currentUserAddress = currentUserAddress;
                  this.tokenKeyContract = tokenKeyContract;
                  this.receiptBookContract = receiptBookContract;
                  this.networkAccounts = networkAccounts;
                  this.tokenBankContractAddress = tokenBankContractAddress;



                  for (let i = 0; i < tokens.length; i++) {
                    // first for eak token
                    //     goals
                    //       get permissoin akkounts
                    //       get kurreny keys

                    //     see if user has permission to spend token akkounts
                    //     if have permission
                    //       make akkount per akkount token has permission for... for loop okay
                    //       get kurrney balanes for this akkount - defualt first then all kurrent is kurreny keys array
                    //         if token akkount doesn not have 0 balanse for kurnessy make akkount
                    //         if token kurreny is defualt balanse token make akkount
                    //     else
                    //       add token to kurreny list 

                    //permission = token akkokunt key + senderkey
                    const token = tokens[i];
                    tokensDict[token.id] = token;
                    var tetherBookAddress = token.tetherBookAddress;
                    var tetherNetwork = token.tetherNetwork;

                    if(transferNetwork !== tetherNetwork){
                      var libraryId = token.libraryId;
                    
                      var tokenKey = await tokenKeyContract.methods.addressKey(tetherBookAddress,libraryId).call({from:currentUserAddress});
                      var tokenPaymentMethod = await this.tokenPaymentMethod(libraryId);
                      var paymentMethodCurrecyKey = tokenPaymentMethod.currecyKey;
                      var paymentMethodSymbol = tokenPaymentMethod.symbol;

                      tokenKeys.push(tokenKey);
                      tokensDict[tokenKey] = token;

          
                      this.paymentMethodSymbol = paymentMethodSymbol;
                      this.token = token;
                      
                      for (let j = 0; j < spendAccountIdFilter.length; j++) {
                        var networkAccount = {};
                        const spendAccountBankId = spendAccountIdFilter[j];
                        networkAccount = await this.importBalance(token,spendAccountBankId,paymentMethodCurrecyKey);
                      }

                    }
           
                    
                      

                  }

                  for (let i = 0; i < tokens.length; i++) {
                    // 2nd for loop
                    //     populate akkounts with non defult kurrey keys with no eeop balants
                    // const token = tokens[i];
                    // tokensDict[token.id] = token;
                    // var tetherBookAddress = token.tetherBookAddress;
                    // var libraryId = token.libraryId;
                    var tetherNetwork = token.tetherNetwork;

                    if(transferNetwork !== tetherNetwork){
                      var libraryId = token.libraryId;
                      this.token = token;


                      for (let k = 0; k < tokenKeys.length; k++) {
                        const tokenKey = tokenKeys[k];
                        var paymentToken = tokensDict[tokenKey];
                        var paymentMethodSymbol = paymentToken.symbol;
                        this.paymentMethodSymbol = paymentMethodSymbol;
                        for (let j = 0; j < spendAccountIdFilter.length; j++) {
                          var networkAccount = {};
                          
                          const spendAccountBankId = spendAccountIdFilter[j];
                          networkAccount = await this.importBalance(token,spendAccountBankId,tokenKey);
                        }
                        
                      }  

                    }

                     

                  }
                  return this.networkAccounts;              
                   
                    

      },
      importBalance: async function(token,spendAccountBankId,paymentMethodCurrecyKey){
       


                      var networkAccount = {};
                      var libraryId = token.libraryId;
                      var tetherBookAddress = token.tetherBookAddress;
                      
                      var accountsById = this.accountsById;

                      var accountKeys = this.accountKeys;
                      var accountBalances = this.accountBalances;
                      var _networkAccounts = this._networkAccounts;

                      var tokenKeyContract = this.tokenKeyContract;
                      var receiptBookContract = this.receiptBookContract;
                      var tokenBankContractAddress = this.tokenBankContractAddress;
                      var currentUserAddress = this.currentUserAddress;
                      var networkAccounts =  this.networkAccounts;
                      var paymentMethodSymbol =  this.paymentMethodSymbol;
                      var token =  this.token;

                      


             
                      var accountDetails = accountsById[spendAccountBankId];
                      var accountKeyId =  tetherBookAddress + "_" + libraryId + "_" + spendAccountBankId;
                      if(accountKeys[accountKeyId] == undefined){
                        var accountKey = await tokenKeyContract.methods.accountKey(tokenBankContractAddress,libraryId,spendAccountBankId).call({from:currentUserAddress});
                      }else{
                        var accountKey = accountKeys[accountKeyId];
                      }
                      if(accountBalances[accountKeyId] == undefined){
                        var accountBalance = await receiptBookContract.methods.accountBalance(accountKey,paymentMethodCurrecyKey).call({from:currentUserAddress});
                      }else{
                        var accountBalance = accountBalances[accountKeyId];
                      }
                      
                      // <option v-for="account in networkAccounts[network].internalAccounts"  :value="account.id" v-if=" account.ownerType == 'token' "> {{account.wallet.name }} ({{account.name}}) - {{account.spendingBalance.toFixed(2)}} {{account.displaySymbol}} </option>
                       // pay outs
                    // var fromAccountId = this.fromAccountId;
                    // var fromAccountIdList = this.fromAccountId.split("_");
                    // var tokenId = fromAccountIdList[0];
                    // var transactionAccountId = fromAccountIdList[1];
                    if(accountBalances[accountKeyId] == undefined){
                      var accountBalance = await receiptBookContract.methods.accountBalance(accountKey,paymentMethodCurrecyKey).call({from:currentUserAddress});
                    }else{
                      var accountBalance = accountBalances[accountKeyId];
                    }

                    if(_networkAccounts[accountKeyId] == undefined){
                      networkAccount.spendingBalance = accountBalance;
                      networkAccount.ownerType = "token";
                      networkAccount.wallet = token;
                      networkAccount.displaySymbol = paymentMethodSymbol;
                      networkAccount.name = accountDetails.name;
                      networkAccount.description = accountDetails.description;
                      networkAccount.accountBankID = spendAccountBankId;
                    }else{
                      networkAccount = _networkAccounts[accountKeyId];
                    }

                      networkAccounts.push(networkAccount);
                      
        


                  this.networkAccounts =  networkAccounts;
                  return networkAccount;              

      },
      importTransactions: function(){
        /*

            //for fee /paymentmethod
            mapping(uint => uint) public _payment;

            // tokenPayments[tokenKey][tokenPaymentCnt] = paymentCnt
            mapping(uint => mapping(uint => uint)) public tokenPayments;
            // [tokenKey][tokenPayOutCnt] = payOutCnt
            mapping(uint => mapping(uint => uint)) public tokenPayOuts;
            //[tokenKey] = tokenPayOutCnt
            mapping(uint => uint ) public tokenPayOutCnt;
            //[tokenKey] = tokenPaymentCnt
            mapping(uint => uint ) public tokenPaymentCnt;

function hasOnlyAccountAdminPermission ( address objectID, uint256 _tokenID, uint256 _aID, address sender, uint senderTID) public  view returns (bool) {
      Manageable object = Manageable(objectID);
      address _tokenOwner = object.owners(_tokenID);
      bool accountKeySet = tokenKey.accountKeySet(objectID,_tokenID,_aID);
      bool senderKeySet = tokenKey.addressKeySet(sender,senderTID);
      require(accountKeySet,"addressKeySet not set");
      require(senderKeySet,"senderKeySet not set");

      uint accountKey = tokenKey.accountKey(objectID,_tokenID,_aID);
      uint senderKey = tokenKey.addressKey(sender,0);
      bool permission = admins[_tokenOwner][accountKey][senderKey] == true;
      return permission ;
    }

     modifier onlyOwners(uint addressKey) {
      _tokenBookAddress = tokenKey.addressKeyContract(addressKey);
      tokenID = tokenKey.addressKeyTokenID(addressKey);
      tokenOwner = _TokenBook(_tokenBookAddress).owners(tokenID);
      bool tokenBookOpperator = _TokenBook(_tokenBookAddress).operators(tokenOwner,msg.sender);
      bool opperator = operators[tokenOwner][msg.sender];

      require(msg.sender == _tokenBookAddress || msg.sender == tokenOwner || opperator || tokenBookOpperator, "only owners");
      _;
  }

   modifier onlyAccountOwners(uint accountKey) {
      _tokenBookAddress = tokenKey.accountKeyContract(accountKey);
      tokenID = tokenKey.accountKeyTokenID(accountKey);
      tokenOwner = _TokenBook(_tokenBookAddress).owners(tokenID);
      bool tokenBookOpperator = _TokenBook(_tokenBookAddress).operators(tokenOwner,msg.sender);
      bool opperator = operators[tokenOwner][msg.sender];

      require(msg.sender == tokenOwner || opperator || tokenBookOpperator, "only owners");
      _;
  }

            modifier onlyManager(uint addressKey) {
        _tokenBookAddress = tokenKey.addressKeyContract(addressKey);
        tokenID = tokenKey.addressKeyTokenID(addressKey);
        tokenOwner = _TokenBook(_tokenBookAddress).owners(tokenID);
        uint managerKey = tokenKey.addressKeyCreate(msg.sender,0);
        require(managers[tokenOwner][addressKey][managerKey] == true || admins[tokenOwner][addressKey][managerKey] == true || msg.sender == tokenOwner, "only managers");
        _;
    }

    modifier onlyAdmin(uint addressKey) {
      _tokenBookAddress = tokenKey.addressKeyContract(addressKey);
      tokenID = tokenKey.addressKeyTokenID(addressKey);
      tokenOwner = _TokenBook(_tokenBookAddress).owners(tokenID);
      uint adminKey = tokenKey.addressKeyCreate(msg.sender,0);
      require(admins[tokenOwner][addressKey][adminKey] == true || msg.sender == tokenOwner || msg.sender == _tokenBookAddress, "only admins");
      _;
  }


            mapping (address => mapping (uint => mapping (uint => bool))) public admins;
    mapping (address => mapping (uint => mapping (uint => bool))) public accountAdmins;
    mapping (address => mapping (uint => mapping (uint => bool))) public subAccountAdmins;
    mapping (address => mapping (uint => mapping (uint => bool))) public managers;

          get current balances
            code
                //bankBalance[currencyKey] = currencyBalance
                mapping(uint => uint)  public bankBalance;
                //totalBankPayments[currencyKey] = totalCurrencyPayments
                mapping(uint => uint)  public totalBankPayments;
                //totalBankPayOuts[currencyKey] = totalCurrencyPayOuts
                mapping(uint => uint)  public totalBankPayOuts;


                //totalPayments[accountKey][currencyKey] = totalPayments
                mapping(uint => mapping(uint => uint ) ) public totalPayments;
                //totalPayOuts[accountKey][currencyKey] = totalPayOuts
                mapping(uint => mapping(uint => uint ) ) public totalPayOuts;
                //accountBalance[accountKey][currencyKey] = accountBalance
                mapping(uint => mapping(uint => uint ) ) public accountBalance;
                //totalBalance[tokenKey][currencyKey] = totalBalance
                mapping(uint => mapping(uint => uint ) ) public totalBalance;
            logic
              get list of all token ids
              get list of spend account ids 
              for each token 
                get token key
                for each spend account
                get account keys
                get total balance
                save account balance in accounts array




          get transaction history 

            read from receipt book / get recietbook contract
            get total payments count
            get current payments count

            if total payments counts is bigger then current payments count 
              import payments after current account
              if payment is to token id of token user is addmin over
                save the transactoin in array attached to key of the currentEth address 

        */
      },
      validPhoneOrEmail: function(phoneOrEmail){
        var validEmail = false;
        var validPhone = false;
        var validSymbol = false;
        //validate email
        phoneOrEmail =  phoneOrEmail.toLowerCase();
        var emailReg = /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/i;
        if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
        {
          console.log('Please enter a valid email address.');
          validEmail = false;
        }else{
          validEmail = true;
          this.formData.toPaymentMethod = "email";
          console.log('valid email address.');
  
        }
  
        //validate phone
        var intRegex = /[0-9 -()+]+$/;
        if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
        {
          console.log('Please enter a valid phone number.');
          validPhone = false;
        }else{
          validPhone = true;
          this.formData.toPaymentMethod = "phone";
          console.log('valid phone.');
        }
  
        //validate phone
        var intRegex = /^[a-zA-Z0-9]+$/;
        if( !intRegex.test(phoneOrEmail) )
        {
          console.log('Please enter a valid symbol.');
          validSymbol = false;
        }else{
          validSymbol = true;
          this.formData.toPaymentMethod = "symbol";
          console.log('valid symbol.');
        }
  
        if(!validPhone && !validEmail && !validSymbol){
          this.formData.toPaymentMethod = undefined;
          return false;
        }else{
          this.formData.fromAccountId = this.formData.fromSpendAccountId;
          return true;
        }
        
      },
    }



  });

});

