/**
 * <google-address>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
function initAutocomplete() {
    jQuery(".autocompleteCallBack").click();
}

jQuery(document).ready(function( jQuery ) {


	Vue.component('googleAddress', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
        'formErrors',
        'formData',
        'useGoogleMaps',
    ],
  
    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝jQuery
    data: function (){
      return {
        cloudError:false,
        syncingUpdateCard:false,
        syncing:false,
        // This example uses the autocomplete feature of the Google Places API.
        // It allows the user to find all hotels in a given place, within a given
        // country. It then displays markers for all the hotels returned,
        // with on-click details for each hotel.
  
        // This example requires the Places library. Include the libraries=places
        // parameter when you first load the API. For example:
        // <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">
  
        placeSearch : "",
        autocomplete : "",

        componentForm : {
            street_number: 'short_name',
            route: 'long_name',
            locality: 'long_name',
            administrative_area_level_1: 'short_name',
            country: 'short_name',
            postal_code: 'short_name'
        }

      }
    },
  
    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="google-address location">
        <div v-if="useGoogleMaps"  class="form-group">
            <label for="address">Enter Your City, State and Country</label>
            <input class="form-control" name="autocomplete" type="text"    aria-describedby="addressHelp"  
            id="autocomplete"
            placeholder="Enter your address">
            <div class="invalid-feedback" >Please a valid address.</div>
        </div>
        <div class="form-group">
            <label for="street_number">Street Number</label>
            <input  class="form-control" id="street_number" type="text"  :class="[formErrors.street_number ? 'is-invalid' : '']" v-model.trim="formData.street_number" placeholder="Sturgis" autocomplete="street_number" >
            <div class="invalid-feedback" v-if="formErrors.street_number">Please enter your full street number.</div>
        </div>
        <div class="form-group">
            <label for="route">Street Name</label>
            <input  class="form-control" id="route" type="text"  :class="[formErrors.route ? 'is-invalid' : '']" v-model.trim="formData.route" placeholder="Sturgis" autocomplete="route" >
            <div class="invalid-feedback" v-if="formErrors.route">Please enter your full street name.</div>
        </div>
        <div class="form-group">
            <label for="address2">Apartment,suite, ect (optional)</label>
            <input class="form-control" id="address2" type="text"  :class="[formErrors.address2 ? 'is-invalid' : '']" v-model.trim="formData.address2" placeholder="Sturgis" autocomplete="address2" >
            <div class="invalid-feedback" v-if="formErrors.address2">Please enter your apartment,suite, ect</div>
        </div>

        <div class="form-group">
            <label for="locality">City</label>
            <input v-if="useGoogleMaps" disabled="disabled" class="form-control" id="locality" type="text"  :class="[formErrors.locality ? 'is-invalid' : '']" v-model.trim="formData.locality" placeholder="Sturgis" autocomplete="locality" >
            <input v-else="" class="form-control" id="locality" type="text"  :class="[formErrors.locality ? 'is-invalid' : '']" v-model.trim="formData.locality" placeholder="Sturgis" autocomplete="locality" >
            <div class="invalid-feedback" v-if="formErrors.locality">Please enter your city.</div>
        </div>
        <div class="form-group">
            <label for="administrative_area_level_1">State</label>
            <input v-if="useGoogleMaps" disabled="disabled" class="form-control" id="administrative_area_level_1" type="text"  :class="[formErrors.administrative_area_level_1 ? 'is-invalid' : '']" v-model.trim="formData.administrative_area_level_1" placeholder="Sturgis" autocomplete="administrative_area_level_1" >
            <input v-else=""  class="form-control" id="administrative_area_level_1" type="text"  :class="[formErrors.administrative_area_level_1 ? 'is-invalid' : '']" v-model.trim="formData.administrative_area_level_1" placeholder="Sturgis" autocomplete="administrative_area_level_1" >
            <div class="invalid-feedback" v-if="formErrors.administrative_area_level_1">Please enter your state.</div>
        </div>
        <div class="form-group">
            <label for="postal_code">Zip Code</label>
            <input  class="form-control" id="postal_code" type="text"  :class="[formErrors.postal_code ? 'is-invalid' : '']" v-model.trim="formData.postal_code" placeholder="Sturgis" autocomplete="postal_code" >
            <div class="invalid-feedback" v-if="formErrors.postal_code">Please enter your zip code.</div>
        </div>
        <div class="form-group">
            <label for="country">Country</label>
            <input v-if="useGoogleMaps" disabled="disabled" class="form-control" id="country" type="text"  :class="[formErrors.country ? 'is-invalid' : '']" v-model.trim="formData.country" placeholder="Sturgis" autocomplete="country" >
            <input v-else=""  class="form-control" id="country" type="text"  :class="[formErrors.country ? 'is-invalid' : '']" v-model.trim="formData.country" placeholder="Sturgis" autocomplete="country" >
            <div class="invalid-feedback" v-if="formErrors.country">Please enter your country.</div>
        </div>


        <div class="autocompleteCallBack" ></div>


       
      
  

  
    </div>

      
    `,
  
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        console.log("pre mount this.formData",this.formData);
        console.log("pre mount this.formErrors",this.formErrors);
  
    },
  
    mounted: function() {
      Address = this;
      console.log("post mount this.formData",this.formData);
      console.log("post mount this.formErrors",this.formErrors);
      if(this.useGoogleMaps){
        jQuery(".autocompleteCallBack").click(function() {
            // alert( "Handler for .click() called." );
            Address.initAutocomplete();
    
          });
    
          jQuery("#autocomplete").focus(function() {
            // alert( "Handler for .focus() called." );
            Address.geolocate();
    
          });
      }

      
        
    //   initAutocomplete();
      
  
    },
  
  
  
    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        // This sample uses the Autocomplete widget to help the user select a
        // place, then it retrieves the address components associated with that
        // place, and then it populates the form fields with those details.
        // This sample requires the Places library. Include the libraries=places
        // parameter when you first load the API. For example:
        // <script
        // src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&libraries=places">



        initAutocomplete : function() {
            var Address = this;
            // Create the autocomplete object, restricting the search predictions to
            // geographical location types.
            Address.autocomplete = new google.maps.places.Autocomplete(
                document.getElementById('autocomplete'), {types: ['geocode']});

            // Avoid paying for data that you don't need by restricting the set of
            // place fields that are returned to just the address components.
            Address.autocomplete.setFields(['address_component']);

            // When the user selects an address from the drop-down, populate the
            // address fields in the form.
            Address.autocomplete.addListener('place_changed', Address.fillInAddress);
            jQuery( ".google-address .street_number" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".street_number" ).val(val);

                var route = jQuery(this).parents(".google-address").find(".route").val();
                var street_address = val + " " + route;
                jQuery( ".street_address" ).val(street_address);

                console.log("change",val);
            });
            jQuery( ".google-address .route" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".route" ).val(val);
                var street_number = jQuery(this).parents(".google-address").find(".street_number").val();
                var street_address = street_number + " " + val;
                jQuery( ".street_address" ).val(street_address);

                console.log("change",val);
            });
            jQuery( ".google-address .address2" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".address2" ).val(val);
                console.log("change",val);
            });
            jQuery( ".google-address .locality" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".locality" ).val(val);
                console.log("change",val);
            });
            jQuery( ".google-address .administrative_area_level_1" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".administrative_area_level_1" ).val(val);
                console.log("change",val);
            });
            jQuery( ".google-address .postal_code" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".postal_code" ).val(val);
                console.log("change",val);
            });
            jQuery( ".google-address .country" ).change(function() {
                var val = jQuery(this).val();
                jQuery( ".country" ).val(val);
                console.log("change",val);
            });
    
        },

        fillInAddress : function() {
            var Address = this;
            // Get the place details from the autocomplete object.
            var place = Address.autocomplete.getPlace();

            for (var component in Address.componentForm) {
                document.getElementById(component).value = '';
                document.getElementById(component).disabled = false;
            }

            // Get each component of the address from the place details,
            // and then fill-in the corresponding field on the form.
            for (var i = 0; i < place.address_components.length; i++) {
                var addressType = place.address_components[i].types[0];
                if (Address.componentForm[addressType]) {
                    var val = place.address_components[i][Address.componentForm[addressType]];
                    document.getElementById(addressType).value = val;
                    document.getElementsByClassName(addressType).value = val;
                    jQuery("#"+addressType)[0].dispatchEvent(new Event('change'));
                    Address.formData[addressType] =  val;
                 }
            }
        },

        // Bias the autocomplete object to the user's geographical location,
        // as supplied by the browser's 'navigator.geolocation' object.
        geolocate : function() {
            var Address = this;
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle(
                    {center: geolocation, radius: position.coords.accuracy});
                    Address.autocomplete.setBounds(circle.getBounds());
                });
            }
        }
    }
  
  });

});

  