/**
 * <payment-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('paymentTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'payments',// « The JS timestamp to format
    'assets',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {

    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 payments">
    <div class="col-md-12">
            <table class="table table-striped" align="center">
                <thead>
                    <tr>
                        <th>Type</th>
                        <!--  <th>Total</th> -->
                        <th>User</th>
                        <th>Status</th>
                        <th>Updated</th>
                        <th>Created</th>
                        <th>Total</th>
                        <th>Total Fee</th>
                        <!-- <th>External Fee</th>
                        <th>Net Fee</th> -->
                        <th>Currency</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                <tr v-for="payment in payments"   class="payment">

                    <td>
                        {{ payment.type}}
                    </td>
                    <!--
                    <td >
                        {{payment.price}}
                    </td>
                    -->
                    <td >
                        {{payment.userId ? payment.userId.fullName : "No Name" }}
                    </td>
                    <td>
                        {{payment.status}}
                    </td>
                    <td >
                        <js-timestamp :at="payment.updatedAt" format="timeago" short="false"></js-timestamp> 
                    </td>
                    <td >
                        <js-timestamp :at="payment.createdAt" format="timeago" short="false"></js-timestamp> 
                    </td>
                    <td >

                        $ <span class="total">{{parseFloat(payment.totalAmount)}}</span>
                    </td>
                    <td >
                        $ <span class="totalFee">{{parseFloat(payment.totalFee) }}</span>
                    </td>
                    <!-- <td >
                        $ <span class="externalFee">{{payment.totalFee - payment.serviceFee}}</span>
                    </td>
                    <td >
                        $ <span class="netFee">{{payment.serviceFee}}</span>
                    </td> -->
                    <td class="currency" >
                        {{payment.assetType == "crypto"? assets[payment.primeTrustAssetId].attributes.label:"USD"}}
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
      console.log("this.at",this.totals);

  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    clickTransactionDetails: async function(event) {
        this.modal = 'example';
        var tokenFee = $(event.target).parents('tr').find('.tokenFee').html();
        var serviceFee = $(event.target).parents('tr').find('.serviceFee').html();
        var totalAmount = $(event.target).parents('tr').find('.totalAmount').html();
        var createdAt = $(event.target).parents('tr').find('.createdAt').html();
        var netAmount = $(event.target).parents('tr').find('.netAmount').html();
        var paymentHash = $(event.target).parents('tr').find('.paymentHash').val();
        var blockHash = $(event.target).parents('tr').find('.blockHash').val();
        var blockNumber = $(event.target).parents('tr').find('.blockNumber').val();
        var note = $(event.target).parents('tr').find('.note').val();
        var type = $(event.target).parents('tr').find('.type').val();

        /*
          paymentHash:
          '0xb2b8e820258d375c0085aba53583a4566c28e6e7fcc49e67c45238e20501a68e',
        paymentIndex: 0,
        blockHash:
          '0xb2e0fafb8e022773e0cc0d257e2dd0f652c3b008b054c57826ca0646fcc88b40',
        blockNumber: 479,
        */
  
        $('.detailsModal .netAmount').html(netAmount);
        $('.detailsModal .tokenFee').html(tokenFee);
        $('.detailsModal .serviceFee').html(serviceFee);
        $('.detailsModal .totalAmount').html(totalAmount);
        $('.detailsModal .createdAt').html(createdAt);
        $('.detailsModal .paymentHash').html(paymentHash);
        $('.detailsModal .blockHash').html(blockHash);
        $('.detailsModal .blockNumber').html(blockNumber);
        $('.detailsModal .note').html(note);
        $('.detailsModal .type').html(type);
        $('.detailsModal .submit').html("Pay Invoice");
        
      },

  }

});
});

