/**
 * <token-cart-Modal>
 * -----------------------------------------------------------------------------
 * Transaction Modal.
 *

 main goal 
    click token 
    select quanty
    confirm buy
    place order goes to market
    there shouldbe automatic trade from app token holder
    tell user thier order has been placed
    once trade happens  refresh balanc epage
 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
jQuery(document).ready(function( $ ) {

	Vue.component('tokenCartModal', {

	//  ╔═╗╦═╗╔═╗╔═╗╔═╗
	//  ╠═╝╠╦╝║ ║╠═╝╚═╗
	//  ╩  ╩╚═╚═╝╩  ╚═╝
	props: [
		'id',// « The JS timestamp to format
		'shop',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
		'storefrontAccessToken',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
		'paymentMethods',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
		'syncing',
		'orderId',
		'shopSlug',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
		'productClass',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
		'checkoutRedirect',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
		'checkoutAction',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
		'checkoutSession',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
		'defaultCheckout',
		'toAccountId',
		'sellCurrencyId',
		'environment',
		'validatePaymentMethod',
		'showCart',
	],

	//  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
	//  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
	//  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
	data: function (){
		return {
			formData: {},
			formErrors: {},
			formatType: undefined,
			formattedTimestamp: '',
			interval: undefined,
			test:'test',
			variantIds:[],
			_defaultCheckout:[],
			_showCart:[],
		};
	},

	//  ╦ ╦╔╦╗╔╦╗╦
	//  ╠═╣ ║ ║║║║
	//  ╩ ╩ ╩ ╩ ╩╩═╝
	template: `
	<div :id="id+'-token-cart-modals'" class="row mb-3 token-cart-modals">
		<!-- Trade Modal -->
		<div class="modal  cartModal" :id="id+'-cartModal'" tabindex="-1" role="dialog" :aria-labelledby="id+'-cartModalLabel'" aria-hidden="true">
		  <div class="modal-dialog" role="document">
			<div class="modal-content">
			  <div class="modal-header">
				<h5 class="modal-title"  :id="id+'-cartModalLabel'" >Cart</h5>
				<!--
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				  <span aria-hidden="true">&times;</span>
				</button>
				-->
			  </div>
			  <form class="modal-body cart-form content p-4">
				  <div class="items mb-5">
				  </div>
				  <div class="empty mb-5">
					  <h3>Your cart is empty</h3>
				  </div>
				  <div class="total">
					  <h5>Total Charge: <span class="totalPrice"></span> USD </h5>
				  </div>
  
			  </form>
			  <div class="modal-footer border-0">
				<button type="button" class="btn btn-secondary d-none" data-dismiss="modal">Close</button>
				<!--
				  <button type="button" class="btn btn-primary checkout " data-dismiss="modal" >Checkout</button>
				  <button type="button" class="btn btn-primary checkout " data-dismiss="modal" data-toggle="modal" :data-target="'#'+id+'-checkoutModal'">Checkout</button>
				  <ajax-button type="button" :class="'btn btn-primary'" :syncing="syncing" >Checkout</ajax-button>
  
			  -->
				  <button type="button" class="btn btn-primary checkout " >Checkout</button>
  
  
			  </div>
			</div>
		  </div>
		</div>
		<!-- end Trade Modal -->
  
		<!-- Confrim Modal -->
		<div class="modal  checkoutModal" :id="id+'-checkoutModal'"  tabindex="-1" role="dialog" :aria-labelledby="id+'checkoutModalLabel'" aria-hidden="true">
		  <div class="modal-dialog" role="document">
			<div class="modal-content">
			  <div class="modal-header">
				<h5 class="modal-title" :id="id+'-checkoutModalLabel'" >Check Out</h5>
				<!--
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				  <span aria-hidden="true">&times;</span>
				</button>
				-->
  
			  </div>
			  <form class="modal-body cart-form content p-4">
				  <div class="items mb-5">
				  </div>
				  <div class="empty mb-5">
					  <h3>Your cart is empty</h3>
				  </div>
				  <div class="total">
					  <h5>Total Charge: <span class="totalPrice"></span> USD </h5>
				  </div>
				  <div class="form-group mt-4">
					  <label for="name">Payment Method</label>
					  <select id="fromBalanceId" class="form-control mt-4" v-model.trim="formData.from"  name="from" >
						  <option v-for="paymentMethod in paymentMethods" :value="paymentMethod.id" >
							  {{paymentMethod.currency.name}} ({{paymentMethod.available}} {{paymentMethod.currency.symbol}})
						  </option>
					  </select>
					  <div class="invalid-from" v-if="formErrors.from">Please enter your a valid payment method.</div>
					  <!-- <small id="adminHelp" class="form-text text-muted">How much of your net income form orders do you want to allocate to your shop token holders?</small> -->
				  </div>
  
			  </form>
			  <div class="modal-footer border-0">
				<button type="button" :class="'btn btn-secondary ' +id+'-view-cart-button' " data-dismiss="modal" data-toggle="modal" :data-target="'#'+id+'-cartModal'" >Back</button>
				<ajax-button type="button" :class="'btn btn-primary submit '+id+'-submit-cart' " data-dismiss="modal" data-toggle="modal" :data-target="'#'+id+'-confirmatioModal'">Confirm & Pay</ajax-button>
			  </div>
			</div>
		  </div>
		</div>
		<!-- end Confrim Modal -->
  
		<!-- Thank you Modal -->
		<div class="modal  confirmationModal" :id="id+'-confirmationModal'"  tabindex="-1" role="dialog" :aria-labelledby="id+'confirmationModalLabel'" aria-hidden="true">
		  <div class="modal-dialog" role="document">
			<div class="modal-content">
			  <div class="modal-header">
				<h5 class="modal-title" :id="id+'-confirmationModalLabel'" >Your Order Has Been Placed</h5>
				<!--
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				  <span aria-hidden="true">&times;</span>
				</button>
				-->
  
			  </div>
			  <form class="modal-body cart-form content p-4">
				  <h3>Your Order Has Been Placed</h3>
  
			  </form>
			  <div class="modal-footer border-0">
				<button type="button" :class="'btn btn-secondary ' +id+'-view-cart-button' " data-dismiss="modal" data-toggle="modal" :data-target="'#'+id+'-cartModal'" >Back</button>
				<ajax-button type="button" class="btn btn-primary confirmation confirmation-cart" data-dismiss="modal">Confirm & Pay</ajax-button>
			  </div>
			</div>
		  </div>
		</div>
		<!-- end Thank you Modal -->
		<input type="hidden" class="checkout-token-id">
		<input type="hidden" class="checkout-external-token-id">
  
  
  
	</div>
  
	`,

	//  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
	//  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
	//  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
	beforeMount: function() {

	},
	mounted: async function() {
		console.log('carts',this.carts);
		  console.log('beforeMount pre this',this);
		  console.log('beforeMount pre this.storefrontAccessToken',this.storefrontAccessToken);
		  console.log('beforeMount pre this.productClass',this.productClass);
		  console.log('beforeMount pre this.shop',this.shop);
	
		  this._defaultCheckout = this.defaultCheckout ? this.defaultCheckout : [];
		  console.log('_defaultCheckout',this._defaultCheckout);
  
		  this._showCart = this.showCart ? this.showCart : false; // if not true it will never show
  
	
	
		var shop =  this.shop;
		var storefrontAccessToken =  this.storefrontAccessToken;
		var productClass =  this.productClass;
		this.init(shop,storefrontAccessToken,productClass);
		  console.log('beforeMount pre this',this);
	
	
	  },



	//  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
	//  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
	//  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
	methods: {
		init: function(shop,storefrontAccessToken, productClass) {
		  console.log('init this',this);
	
		  var Cart = this;
		  var id = this.id;
		  Cart.allLineItems = [];
		  Cart.formatDefaultCheckout(Cart._defaultCheckout);
	
		  Cart =  Cart.copyInstance(Cart);
		  console.log('shop',shop);
		  // Cart = {};
		  Cart.shop  = shop;
		  Cart.productClass  = productClass;
		  Cart.storefrontAccessToken  = storefrontAccessToken;
		  console.log('init this',this);
		  console.log('shop',shop);
		  console.log('storefrontAccessToken',storefrontAccessToken);
		  Cart = Cart.activate(shop,storefrontAccessToken,productClass);
		  return Cart;
		},
		formatDefaultCheckout: function(_defaultCheckout) {
		  var Cart = this;
		  Cart._defaultCheckoutDict = {};
	
		  for (let i = 0; i < _defaultCheckout.length; i++) {
			const _defaultCheckoutItem = _defaultCheckout[i];
			Cart._defaultCheckoutDict[_defaultCheckoutItem.variantId] = {
			  variantId : _defaultCheckoutItem.variantId,
			  variant_id : _defaultCheckoutItem.variant_id,
			  fulfillable_quantity : _defaultCheckoutItem.fulfillable_quantity,
			  quantity : _defaultCheckoutItem.quantity,
			  frequency : _defaultCheckoutItem.frequency,
			  portfolioId : _defaultCheckoutItem.portfolioId,
			  type : _defaultCheckoutItem.type,
			  variant : _defaultCheckoutItem.variant,
			};
	
	
		  }
		},
		getDefaultCheckout: function() {
		  var Cart = this;
		  var variantIds = Cart.variantIds;
		  var defautCheoutItmes = [];
		  console.log('getDefaultCheckout variantIds',variantIds);
		  $.each( Cart._defaultCheckoutDict, ( variantId, _defaultCheckoutItem ) => {
			console.log('getDefaultCheckout _defaultCheckoutItem', variantId + ': ' + _defaultCheckoutItem );
			var line_item = {
			  variantId:_defaultCheckoutItem.variantId,
			  variant_id:_defaultCheckoutItem.variantId,
			  type:_defaultCheckoutItem.type,
			  quantity:_defaultCheckoutItem.quantity,
			  fulfillable_quantity:_defaultCheckoutItem.quantity,
			  frequency:_defaultCheckoutItem.frequency,
			  portfolioId:_defaultCheckoutItem.portfolioId,
			  variant:_defaultCheckoutItem.variant,
			};
			defautCheoutItmes.push(line_item);
		  });
	
	
		  console.log('getDefaultCheckout defautCheoutItmes',defautCheoutItmes);
	
		  return defautCheoutItmes;
	
		},
		place_order: async function(){
		  var Cart = this;
		  var order =  Cart.checkout;
		  // $(form_id+" .submit").attr("disabled","disabled");
		  Cart.$emit('update:syncing', true);
		  console.log('order',order);
		  // return io.socket.post('/markets/orders', order, function (resData, jwRes) {
		  //   jwRes.statusCode; // => 200
		  //   console.log('jwRes.statusCode',jwRes.statusCode);
		  //   console.log('resData',resData);
		  // });
	
		//   var csrf = await CSRF.token();
		//   console.log('csrf',csrf);
		  console.log('order',order);
		//   var apiRequestHeader = {
        //     // 'X-CSRF-Token':csrf._csrf,
        //     'X-CSRF-Token':"test",
        //       // 'cookie':cookie
        //   };
          jQuery.ajax({
            type: "POST",
          //   url: this.refreshUrl+"/markets/orders/cancel",
            url: '/wp-json/yohshow/api/v1/place-orders',
			data: {order:order},
            // headers:apiRequestHeader,
            success: function(resData, textStatus, request)
            {
                resData = JSON.parse(resData);
				if(resData.flag){
					location.reload();
				  }
				  // $(form_id+" .submit").removeAttr("disabled");
				  Cart.$emit('update:syncing', true);
            }
          });
		  
		//   var apiRequestHeader = {
		// 	'X-CSRF-Token':csrf._csrf,
		// 	// 'cookie':cookie
		//   };
		//   return io.socket.request({
		// 	method: 'post',
		// 	url: '/place-orders',
		// 	data: {order:order},
		// 	headers: apiRequestHeader
		//   }, (resData, jwres) => {
		// 	console.log(resData); // => e.g. 403
		// 	if(resData.flag){
		// 	  location.reload();
		// 	}
		// 	// $(form_id+" .submit").removeAttr("disabled");
		// 	Cart.$emit('update:syncing', true);
	
	
	
		// 	if (jwres.error) {
		// 	  console.log(jwres.statusCode); // => e.g. 403
		// 	  return;
		// 	}
	
		// 	console.log(jwres.statusCode); // => e.g. 200
	
		//   });
	
		},
	
	
		copyInstance: function(original) {
		  var copied = Object.assign(
			Object.create(
			  Object.getPrototypeOf(original)
			),
			original
		  );
		  return copied;
		},
		activate: function() {
		  var Cart = this;
		  var id = this.id;
		  console.log('active Cart', Cart);
		  Cart.products = {};
	
	
	
		  this.load_store();
		  // $("#"+id+"-cartModal").modal({width:"100%"});
		  Cart.activate_checkout();
		  Cart.activate_btns();
		  return Cart;
	
		},
		activate_checkout: function  () {
		  var Cart = this;
		  var id = this.id;
		  console.log('activate_checkout checkout click activated');
		  $( '#'+id+'-cartModal .checkout' ).on( 'click', (e) => {
			console.log('activate_checkout checkout clicked');
			e.preventDefault();
				  Cart.checkoutClick();
		  });
		  $( '.'+id+'-view-cart-button' ).on( 'click', (e) => {
			e.preventDefault();
			console.log('token cart activate_checkout view cart clicked');
				  Cart.open_cart();
		  });
		  $( '.'+id+'-submit-cart' ).on( 'click', (e) => {
			e.preventDefault();
			console.log('token cart activate_checkout submit cart  clicked');
				  Cart.place_order();
		  });
	
		},
		activate_btns: function  () {
		  var Cart = this;
		  var id = this.id;
		  $( '#'+id+'-cartModal .update' ).off('click').on( 'click', (e) => {
			e.preventDefault();
				  Cart.update_cart();
		  });
		  $( '#'+id+'-cartModal .continue' ).off('click').on( 'click', (e) => {
			e.preventDefault();
			$('#'+id+'-cartModal').modal('hide');
		  });
		  $( '.open-cart' ).off('click').on( 'click', (e) => {
			e.preventDefault();
			Cart.open_cart();
		  });
		  $( '#'+id+'-cartModal .remove' ).off('click').on( 'click', function(e) {
			e.preventDefault();
				  var line_item_id = $(this).attr('href');
			var line_items = [line_item_id];
				 Cart.remove_from_cart(line_items);
		  });
	
		  $( '#'+id+'-cartModal .quantity input' ).off('change').on( 'change', function(e) {
			e.preventDefault();
				 Cart.update_cart();
				 $(this).focus();
				 console.log('focus ',$(this).focus());
		  });
	
	
		},
		update_cart: function() {
		  var Cart = this;
		  var id = this.id;
		  var checkout = Cart.checkout;
		  var checkoutId = Cart.checkout.id;
		  var webUrl = checkout.webUrl;
		  lineItemsToUpdate = [];
		  $('#'+id+'-cartModal .line-item').each(function(e) {
			var frequency = $(this).find('.frequency input').val();
			var portfolioId = $(this).find('.portfolioId input').val();
			var quantity = $(this).find('.quantity input').val();
			var variant_id = $(this).find('.variant-id').val();
			var line_item_id = $(this).find('.line-item-id').val();
			quantity = parseFloat(quantity);
				  updated_item =  {id: line_item_id, portfolioId:portfolioId, frequency:frequency, quantity: quantity, fulfillable_quantity: quantity, variantId: variant_id, variant_id: variant_id};
				  lineItemsToUpdate.push(updated_item);
		  });
		  $(lineItemsToUpdate).each(function() {
			// $( this ).addClass( "foo" );
			var lineItemToUpdate = this;
			console.log('token cart update_cart lineItemToUpdate',lineItemToUpdate);
			checkout.lineItemsDict[lineItemToUpdate.variantId].quantity = lineItemToUpdate.quantity;
			checkout.lineItemsDict[lineItemToUpdate.variantId].frequency = lineItemToUpdate.frequency;
			checkout.lineItemsDict[lineItemToUpdate.variantId].portfolioId = lineItemToUpdate.portfolioId;
			checkout.lineItemsDict[lineItemToUpdate.variantId].fulfillable_quantity = lineItemToUpdate.quantity;
		  });
		  $.cookie(checkoutId,checkout);
		  Cart.checkout = checkout;
		  console.log('token cart update_cart pre set_line_items Cart.checkout',Cart.checkout);
		  Cart.set_line_items();
		  console.log('token cart update_cart post set_line_items Cart.checkout',Cart.checkout);
		  Cart.open_cart();
		  // Cart.client.checkout.updateLineItems(checkoutId, lineItemsToUpdate).then((checkout) => {
		  //   Cart.checkout = checkout;
		  //   Cart.open_cart();
		  // });
	
		},
		remove_item: async function() {
		  var Cart = this;
		  var id = this.id;
		  var variant = [{ variantId : variant_id, quantity: 1, fulfillable_quantity: 1 }];
		  await Cart.add_to_cart(variant);
		},
		save_checkout: async function(checkout){
		  var Cart = this;
		  var id = this.id;
		  var csrf = await CSRF.token();
		  console.log('csrf',csrf);
		  var checkoutAction = Cart.checkoutAction;
		  var checkoutRedirect = Cart.checkoutRedirect;
		  var toAccountId = Cart.toAccountId;
		  var orderId = Cart.orderId;
		  var sellCurrencyId = Cart.sellCurrencyId;
	
		  checkout.redirect = checkoutRedirect;
		  checkout.orderId = orderId;
		  checkout.order_id = orderId;
		  checkout.action = checkoutAction;
		  checkout.toAccountId = toAccountId;
		  checkout.to_account_id = toAccountId;
		  checkout.toAccountId = toAccountId;
		  checkout.sell_currency_exchange_token_id = sellCurrencyId;
		  checkout.line_items =  checkout.lineItems;
		  checkout.checkout_type =  'exchange';
	
	
	
	
		  checkout.checkout_token = csrf._csrf;
		  checkout.tokenId = $('#'+id+'-token-cart-modals .checkout-token-id').val();
		  checkout.tokenId = $('#'+id+'-token-cart-modals .checkout-token-id').val();
		  checkout.token_id = $('#'+id+'-token-cart-modals .checkout-token-id').val();

		  checkout.externalTokenId = $('#'+id+'-token-cart-modals .checkout-external-token-id').val();
		  checkout.externalTokenId = $('#'+id+'-token-cart-modals .checkout-external-token-id').val();
		  checkout.external_token_id = $('#'+id+'-token-cart-modals .checkout-external-token-id').val();


		  console.log('save checkout checkout',checkout);
		  console.log('save checkout Cart.environment',Cart.environment);
		  // const input = {customAttributes: [
		  // 	{key: "checkout_token", value: csrf._csrf},
		  // 	{key: "environment", value: Cart.environment},
		  // ]};
	
		  // var updated_checkout = await Cart.client.checkout.updateAttributes(checkout.id, input).then((checkout) => {
		  // 	// Do something with the updated checkout
		  // 	Cart.checkout = checkout;
		  // 	console.log("saved checkout updated attribues checkout",checkout);
		  // 	return checkout;
	
		  // });
		  // console.log("saved checkout updated attribues updated_checkout",updated_checkout);
		  Cart.checkout_token = csrf._csrf;
  
  
		  
		  let checkoutResult = new Promise((resolve, reject) => {
			// var apiRequestHeader = {
			// 	// 'X-CSRF-Token':csrf._csrf,
			// 	'X-CSRF-Token':"test",
			// 	  // 'cookie':cookie
			//   };
			  jQuery.ajax({
				type: "POST",
			  //   url: this.refreshUrl+"/markets/orders/cancel",
				url: '/wp-json/yohshow/api/v1/exchange/checkout/save',
				data: {checkout:checkout},
				// headers:apiRequestHeader,
				success: function(resData, textStatus, request)
				{
					resData = JSON.parse(resData);
					console.log('save checkout data',resData); // => e.g. 403
					  if(resData.flag){
						  // location.reload();
						  var saved_checkout = resData.checkout;
						  saved_checkout.csrf = csrf._csrf;
						  console.log('saved checkout saved_checkout',saved_checkout);
						  // return saved_checkout;
							resolve(saved_checkout); 
						  
		  
		  
					  }
					  resolve(resData); 
				}
			  });  
			
			// var apiRequestHeader = {
			//   'X-CSRF-Token':csrf._csrf,
			// 	  // 'cookie':cookie
			//   };
			//   io.socket.request({
			// 	  method: 'post',
			// 	  url: '/exchange/checkout/save',
			// 	  data: {checkout:checkout},
			// 	  headers: apiRequestHeader
			// 	  }, function (resData, jwres) {
	  
			// 		  console.log('save checkout data',resData); // => e.g. 403
			// 		  if(resData.flag){
			// 			  // location.reload();
			// 			  var saved_checkout = resData.checkout;
			// 			  saved_checkout.csrf = csrf._csrf;
			// 			  console.log('saved checkout saved_checkout',saved_checkout);
			// 			  // return saved_checkout;
			// 				resolve(saved_checkout); 
						  
		  
		  
			// 		  }
			// 		  resolve(resData); 
  
			// 		  // return resData;
				  
			// 	  if (jwres.error) {
			// 		  console.log(jwres.statusCode); // => e.g. 403
			// 		  // this.cloudLoadingError = true;
			// 		  return;
			// 	  }
			// 	  console.log(jwres.statusCode); // => e.g. 200
				  
			//   });
		
  
			  
		  
			});
  
		  var result =  await checkoutResult;
	
	
		  // var apiRequestHeader = {
		  //   'X-CSRF-Token':csrf._csrf,
		  // };
	
		  // var result = await $.ajax({
		  //   type: 'POST',
		  //   //   url: this.refreshUrl+"/markets/orders/cancel",
		  //   url: '/exchange/checkout/save',
		  //   data: {checkout:checkout},
	
		  //   headers:apiRequestHeader,
		  //   success: function(data, textStatus, request)
		  //   {
		  // 	console.log('save checkout data',data); // => e.g. 403
		  // 	if(data.flag){
		  // 	  // location.reload();
		  // 	  var saved_checkout = data.checkout;
		  // 	  saved_checkout.csrf = csrf._csrf;
		  // 	  console.log('saved checkout saved_checkout',saved_checkout);
		  // 	  return saved_checkout;
	
	
		  // 	}
		  // 	return data;
	
		  //   }
		  // });
		  console.log('save checkout result',result);
	
		  if(result.flag){
			// location.reload();
			var saved_checkout = result.checkout;
			saved_checkout.csrf = csrf._csrf;
			console.log('saved checkout saved_checkout',saved_checkout);
			return saved_checkout;
	
	
		  }
	
		  //    var result = await  io.socket.request({
		  //     method: 'post',
		  //     url: '/checkout/save',
		  //     data: {checkout:checkout},
		  //     headers: apiRequestHeader
		  //   }, function (resData, jwres) {
		  //     console.log("save checkout resData",resData); // => e.g. 403
		  //     if(resData.flag){
		  // 		// location.reload();
		  // 		var saved_checkout = resData.checkout;
		  // 		saved_checkout.csrf = csrf._csrf;
		  // 		console.log("saved checkout saved_checkout",saved_checkout);
	
	
		  // 	}
		  // 	return resData;
		  // 	// $(form_id+" .submit").removeAttr("disabled");
		  // 	// Cart.$emit('update:syncing', true);
	
	
	
		  //     if (jwres.error) {
		  //       console.log(jwres.statusCode); // => e.g. 403
		  //       return;
		  //     }
	
		  //     console.log(jwres.statusCode); // => e.g. 200
	
		  //   });
		  return result;
	
		},
		checkoutClick: async function() {
		  var Cart = this;
		  var id = this.id;
		  var checkout = Cart.checkout;
		  // var webUrl = checkout.webUrl;
		  $('#'+id+'-cartModal').modal('hide');
		  $('#'+id+'-cartModal .checkout').attr('disabled','disabled');
	
		  // $("#"+id+"-checkoutModal").modal({
		  // 	iframe: true,
		  // 	iframeHeight: 400,
			// 	iframeURL: webUrl,
		  // });
		  // console.log("checkout webUrl",webUrl);
		  var checkoutModalId = '#'+id+'-checkoutModal';
		  console.log('checkout checkoutModalId',checkoutModalId);
	
		  // var myWindow = window.open(webUrl, "_blank", "width=500,height=500");
		  // var myWindow = window.open(webUrl, "_parent");
		  var _defaultCheckoutItems =  this.getDefaultCheckout();
		  console.log('checkout click  _defaultCheckoutItems',_defaultCheckoutItems);
		  if(_defaultCheckoutItems){
			  await Cart.add_to_cart(_defaultCheckoutItems);
		  }
		  var checkout = Cart.checkout;
	
	
		  // this.syncing =  true;
		  var saved_checkout = await Cart.save_checkout(checkout);
		  // var webUrl = saved_checkout.webUrl;
		  var webUrl = '/pay-now/'+saved_checkout.csrf;
	
		  console.log('checkout saved_checkout',saved_checkout);
		  console.log('checkout webUrl',webUrl);
		  var checkoutModalId = '#'+id+'-checkoutModal';
		  console.log('checkout checkoutModalId',checkoutModalId);
	
		  // var checkoutWindow = window.open(webUrl, "Checkout", "height=750,width=750");
	
		  // var myWindow = window.open(webUrl, "_blank", "width=500,height=500");
		//   var myWindow = window.open(webUrl, '_parent');

		//erase check out cookie data
		var saved_checkout =  Cart.delete_checkout(checkout);

		  Cart.$router.push(webUrl);
	
		  // $(checkoutModalId).modal("show");
		  // Cart.checkoutListen(Cart.checkout_token,myWindow);
	
	
		  // setTimeout(function(){
		  // 	console.log("checkout show modal called checkoutModalId",checkoutModalId);
		  // 	$("#"+id+"-checkoutModal .iframe").attr("src", webUrl);
	
		  // }, 1000);
		  console.log('checkout set time out called checkoutModalId',checkoutModalId);
	
	
		  // setTimeout(function(){
		  // 	$(checkoutModalId).modal("show");
		  // 	console.log("checkout show modal called checkoutModalId",checkoutModalId);
		  // 	// $("#"+id+"-checkoutModal .iframe").attr("src", webUrl);
		  // }, 1000);
		  // console.log("checkout set time out called checkoutModalId",checkoutModalId);
	
		},
		delete_checkout: function(checkout) {
			var Cart = this;
			var id = this.id;

			var productClass = Cart.productClass;
		  	var checkout_name = productClass+'_checkout_id';
		  	console.log('delete checkout checkout_name',checkout_name);
			console.log('delete checkout checkout',checkout);
	
			$.cookie(checkout_name, null);
			$.cookie(checkout.id, null);
			
			return checkout;
		  },
		load_products: function(products) {
		  var Cart = this;
		  var id = this.id;
		  var productClass = this.productClass;
		  for (var i = 0; i < products.length; i++) {
			var product = products[i];
			var variant = product.variants[0];
			console.log('product',product);
			console.log('variant',variant.id);
			Cart.products[variant.id] = variant;
			var variant_class = '.'+productClass +'-'+variant.id;
			variant_class = variant_class.replace('==','');
			$(variant_class + ' .price .value').html(variant.price);
		  }
		  console.log('Cart.products',Cart.products);
		  return Cart.products;
		},
		activate_variants: function() {
		  var Cart = this;
		  var id = this.id;
		  var productClass = Cart.productClass;
		  console.log('activate_variants called productClass',productClass);
		  console.log('activate_variants called productClass length',$( '.'+ productClass  ).length);
	
		  // $( "."+ productClass +" .variant" ).each(function( i ) {
		  $( '.'+ productClass  ).each(function( i ) {
			// var product_dom = $(this).parents(".token-shop");
			var product_dom = $(this);
			console.log('activate_variants product_dom',product_dom);
				Cart.activate_variant(product_dom);
		  });
		},
		activate_variant: function(variant_dom) {
		  var Cart = this;
		  var id = this.id;
		  var validatePaymentMethod = this.validatePaymentMethod;
		  var paymentMethods = this.paymentMethods;
		  
		  var buy_btn = variant_dom.find('.cart');
		  var fast_buy_btn = variant_dom.find('.fast-cart');
		  var fast_sell_btn = variant_dom.find('.fast-sell-cart');
	
		  // var variant_id = variant_dom.find(".tokenId").val();
		  var variant_id = variant_dom.find('.productId').val();
		  var title = variant_dom.find('.title').val();
		  var img_src = variant_dom.find('.img').val();
		  var price = variant_dom.find('.price').val();
		  var market = variant_dom.find('.market').val();
		  var tokenId = variant_dom.find('.tokenId').val();
		  var sellCurrencyId = variant_dom.find('.sellCurrencyId').val();
		  var type = variant_dom.find('.type').val();
		  price = parseFloat(price);
		  price = price.toFixed(6);
		  console.log('token-cart activate_variant pre variant_dom',variant_dom);
	
		  buy_btn.off('click');
		  buy_btn.click(async (e) => {
			e.preventDefault();
			//add varint to cart and bring up cart modal
			console.log('activate_variant buy_btn click variant_id',variant_id);
				   Cart.load_checkout();
				 // Cart.load_checkout().then(function() {
				  
			var frequency = variant_dom.find('.frequency').val();
			var portfolioId = variant_dom.find('.portfolioId').val();
			var quantity = variant_dom.find('.quantity').val();
			var note = variant_dom.find('.orderNote').val();
			var paymentMethodId = variant_dom.find('.paymentMethod').val();
  
			variant_dom.find('.error').hide().addClass("d-none");
  
	
					 var variant = [{
			  id:Cart.guidGenerator(),
			  variantId : variant_id,
			  variant_id : variant_id,
			  note: note,
			  portfolioId: portfolioId,
			  frequency: frequency,
			  quantity: quantity,
			  fulfillable_quantity: quantity,
			  price: price,
			  title: title,
			  market: market,
			  tokenId: tokenId,
			  paymentMethodId: paymentMethodId,
			  fromAccountId: paymentMethodId,
			  sellCurrencyId: sellCurrencyId,
			  type: type,
			  variant:{
				id : variant_id,
				price: price,
				image : {
				  src:img_src
				}
			  }
			}];
			
				if(validatePaymentMethod){
			  var total = price * quantity;
			  var funded = true;
			  for (let i = 0; i < paymentMethods.length; i++) {
				  const paymentMethod = paymentMethods[i];
				  if(paymentMethodId == paymentMethod.id){
					  var spendingBalance = paymentMethod.spendingBalance;
					  if(total > spendingBalance){
						  var funded = false;
					  }
				  }
				  
			  }
			  if(funded){
				  await Cart.add_to_cart(variant);
			  }
			  else{
				  // error
				  variant_dom.find('.invalid-quantity').show().removeClass("d-none");
			  }
			  
			  }else{
				  await Cart.add_to_cart(variant);
			  }
  
	
				// });
	
	
	
		  });
		  // fast_buy_btn.off('click');
		  fast_buy_btn.click(async (e) => {
			e.preventDefault();
			Cart.$emit('update:syncing', true);
  
			var product_box = $(e.target).parents('.'+Cart.productClass);
			var frequency = product_box.find('.frequency').val();
			var portfolioId = product_box.find('.portfolioId').val();
			var quantity = product_box.find('.quantity').val();
			var note = variant_dom.find('.orderNote').val();
			var type = product_box.find('.type').val();
		  //   var price = product_box.find('.price').val();
			var price = product_box.find('.variantPrice').val();
  
			var sellCurrencyId = product_box.find('.sellCurrencyId').val();
			variant_dom.find('.error').hide().addClass("d-none");
			console.log('cart clicked pre parse quantity',quantity);
			quantity = parseFloat(quantity);
			console.log('cart clicked quantity',quantity);
			//add varint to cart and bring up cart modal
			console.log('activate_variant buy_btn click variant_id',variant_id);
				 Cart.load_checkout();
			//  .then(async function() {
			  var paymentMethodId = variant_dom.find('.paymentMethod').val();
		  
			var variant = [{
			  id:Cart.guidGenerator(),
			  variantId: variant_id,
			  variant_id: variant_id,
			  note: note,
			  portfolioId: portfolioId,
			  frequency: frequency,
			  quantity: quantity,
			  fulfillable_quantity: quantity,
			  price: price,
			  title: title,
			  market: market,
			  tokenId: tokenId,
			  paymentMethodId: paymentMethodId,
			  fromAccountId: paymentMethodId,
			  sellCurrencyId: sellCurrencyId,
			  type: type,
			  variant:{
				id : variant_id,
				price: price,
				image : {
				  src:img_src
				}
			  }
			}];
			variant.variant = variant;
			if(validatePaymentMethod){
			  var total = price * quantity;
			  var funded = true;
			  for (let i = 0; i < paymentMethods.length; i++) {
				  const paymentMethod = paymentMethods[i];
				  if(paymentMethodId == paymentMethod.id){
					  var spendingBalance = paymentMethod.spendingBalance;
					  if(total > spendingBalance){
						  var funded = false;
					  }
				  }
				  
			  }
			  if(funded){
				  await Cart.add_to_cart(variant,true);
			  }
			  else{
				  // error
				  variant_dom.find('.invalid-quantity').show().removeClass("d-none");
			  }
			  
			  }else{
				  await Cart.add_to_cart(variant,true);
			  }
			
	
				// });
		  });
		  variant_dom.find('.maxQuantity').click(async (e) => {
			  e.preventDefault();
			  var fromAccountSpendingBalance = variant_dom.find('.fromAccountSpendingBalance').val();
  
			  variant_dom.find('.quantity,.sellCurrency-quantity').val(fromAccountSpendingBalance).change();
		  });
		  // fast_sell_btn.off('click');
		  fast_sell_btn.click(async (e) => {
			e.preventDefault();
			Cart.$emit('update:syncing', true);
  
			var product_box = $(e.target).parents('.'+Cart.productClass);
			
			var frequency = product_box.find('.frequency').val();
			var portfolioId = product_box.find('.portfolioId').val();
			var quantity = product_box.find('.quantity').val();
			var type = product_box.find('.type').val();
		  //   var price = product_box.find('.price').val();
			var price = product_box.find('.variantPrice').val();
			var sellCurrencyId = product_box.find('.sellCurrencyId').val();
			var fromAccountId = product_box.find('.fromAccountId').val();
			var fromAccountSpendingBalance = product_box.find('.fromAccountSpendingBalance').val();
			console.log('cart clicked pre parse quantity',quantity);
			quantity = parseFloat(quantity);
			fromAccountSpendingBalance = parseFloat(fromAccountSpendingBalance);
			console.log('cart clicked quantity',quantity);
			product_box.find('.error').hide();
			
			  
			if(quantity > fromAccountSpendingBalance){
				  product_box.find('.invalid-quantity').show();
				return;
			}
			//add varint to cart and bring up cart modal
			console.log('activate_variant buy_btn click variant_id',variant_id);
				 Cart.load_checkout();
			//  .then(async function() {
			var variant = [{
			  id:Cart.guidGenerator(),
			  variantId: variant_id,
			  variant_id: variant_id,
			  fromAccountId: fromAccountId,
			  portfolioId:portfolioId,
			  frequency:frequency,
			  quantity: quantity,
			  fulfillable_quantity: quantity,
			  price: price,
			  title: title,
			  market: market,
			  tokenId: tokenId,
			  sellCurrencyId: sellCurrencyId,
			  type: type,
			  variant:{
				id : variant_id,
				price: price,
				image : {
				  src:img_src
				}
			  }
			}];
			variant.variant = variant;
			await Cart.add_to_cart(variant,true);
	
				// });
		  });
	
		},
		add_to_cart: async function  (lineItemsToAdd, fastCheckout = false) {
		  var Cart = this;
		  var id = this.id;
		  var productClass = this.productClass;
		  var checkoutId = Cart.checkout.id;
		  console.log('add_to_cart lineItemsToAdd',lineItemsToAdd);
		  var checkout_name = productClass+'_checkout_id';
		  var checkout = $.cookie(checkoutId);
		  $(lineItemsToAdd).each(function() {
			// $( this ).addClass( "foo" );
			var lineItemToAdd = this;
			console.log('token cart add to cart checkout',checkout);
			console.log('token cart add to cart lineItemToAdd',lineItemToAdd);
			checkout.lineItemsDict[lineItemToAdd.variantId] = lineItemToAdd;
		  });
		  console.log('add to cart pre set line items checkout',checkout); // Array with one additional line item
	
		  $.cookie(checkoutId,checkout);
	
		  Cart.set_line_items();
		  console.log('add to cart',Cart.checkout.lineItems); // Array with one additional line item
		  console.log('add_to_cart fastCheckout',fastCheckout);
		  if(fastCheckout){
			await Cart.checkoutClick();
		  }else{
			Cart.open_cart();
		  }
	
		  // Cart.client.checkout.addLineItems(checkoutId, lineItemsToAdd).then((checkout) => {
		  //   // Do something with the updated checkout
		  //   Cart.checkout = checkout;
		  //   // $("#"+id+"-cartModal").modal("setZindex", 99999);
		  //     // $("#"+id+"-cartModal").modal("open", { zindex: 99999 });
		  // });
		},
		remove_from_cart: function  (lineItemIdsToRemove) {
		  var Cart = this;
		  var id = this.id;
		  var checkoutId = Cart.checkout.id;
		  var checkout = $.cookie(checkoutId);
		  $(lineItemIdsToRemove).each(function() {
			// $( this ).addClass( "foo" );
			var lineItemIdToRemove = this;
			console.log('token cart add to cart lineItemIdToRemove',lineItemIdToRemove);
			delete checkout.lineItemsDict[lineItemIdToRemove];
		  });
		  console.log('remove from to cart pre set line items checkout',checkout); // Array with one additional line item
		  $.cookie(checkoutId,checkout);
		  Cart.set_line_items();
		  console.log('remove from cart',Cart.checkout.lineItems); // Array with one additional line item
		  Cart.open_cart();
		  // Cart.client.checkout.removeLineItems(checkoutId, lineItemIdsToRemove).then((checkout) => {
		  //   // Do something with the updated checkout
		  //   console.log("remove from cart",checkout.lineItems); // Array with one additional line item
		  //   Cart.checkout = checkout;
		  //   Cart.open_cart();
		  //   // $("#"+id+"-cartModal").modal("setZindex", 99999);
		  //     // $("#"+id+"-cartModal").modal("open", { zindex: 99999 });
		  // });
		},
		set_line_items: function  () {
		  var Cart = this;
		  var id = this.id;
		  var checkoutId = Cart.checkout.id;
		  var checkout = $.cookie(checkoutId);
		  checkout.lineItems = [];
		  var totalCharge = 0;
		  for (const lineItemId in checkout.lineItemsDict) {
			if (checkout.lineItemsDict.hasOwnProperty(lineItemId)) {
			  const lineItem = checkout.lineItemsDict[lineItemId];
			  console.log('token cart set line items lineItem',lineItem);
			  var totalLineItemCharge = lineItem.price * lineItem.quantity;
			  totalCharge+=totalLineItemCharge;
	
			  checkout.lineItems.push(lineItem);
			}
		  }
		  checkout.totalCharge = totalCharge.toFixed(6);
		  checkout.totalPrice = totalCharge.toFixed(6);
		  console.log('token cart set line items checkout',checkout);
	
		  Cart.checkout = checkout;
		  $.cookie(checkoutId,checkout);
	
		},
		load_cart: function  () {
		  var Cart = this;
		  var id = this.id;
		  checkout = Cart.checkout;
		  checkout.lineItems;
		  $('#'+id+'-token-cart-modals .content .items').html('');
		  var item_length = checkout.lineItems.length;
		  if (item_length == 0 ) {
			$('#'+id+'-token-cart-modals .content .empty').show();
			$('#'+id+'-token-cart-modals .content .total').hide();
		  }else{
			$('#'+id+'-token-cart-modals .content .empty').hide();
			$('#'+id+'-token-cart-modals .content .total').show();
	
		  }
		  $(checkout.lineItems).each(function() {
			  // $( this ).addClass( "foo" );
			  var line_item = this;
			  console.log('load',line_item);
			  Cart.load_item(line_item);
		  });
		  checkout.lineItems;
		  $('#'+id+'-token-cart-modals .totalPrice').html(checkout.totalPrice);
		  Cart.activate_btns();
		  $('#'+id+'-checkoutModal input').attr('disabled','disabled');
		  $('#'+id+'-checkoutModal .remove').hide();
		},
		load_item: function  (line_item) {
		  var Cart = this;
		  var id = this.id;
		  var row = $('<div></div>').addClass('line-item row');
		  var title = $('<label></label>').html(line_item.title).addClass('col-4');
		  // var price = $("<label></label>").html(line_item.variant.price);
		  var price = $('<label></label>').html(line_item.price);
		  // var src = line_item.variant.image && line_item.variant.image.src ? line_item.variant.image.src : "";
		  var src = line_item.image && line_item.image.src ? line_item.image.src : '';
		  var img = $('<img/>').attr('src',src).addClass('');
		  var quantity = $('<input></input>').val(line_item.quantity);
		  quantity.attr('type','number');
		  quantity.addClass('form-control');
  
		  var frequency = $('<input></input>').val(line_item.frequency);
		  frequency.attr('type','number');
		  frequency.addClass('form-control');
		  var portfolioId = $('<input></input>').val(line_item.portfolioId);
		  portfolioId.attr('type','number');
		  portfolioId.addClass('form-control');
  
		  var variant_id = $('<input></input>').val(line_item.variant_id);
		  // var variant_id = $("<input></input>").val(line_item.variant.id);
		  variant_id.attr('type','hidden').addClass('variant-id');
		  var line_item_id = $('<input></input>').val(line_item.id);
		  line_item_id.attr('type','hidden').addClass('line-item-id');
		  var btn = $('<a>X</a>').addClass('remove').attr('href',line_item.id);
		  var img_box = $('<div></div>').addClass('col-2').append(img);
		  var number_box = $('<div></div>').addClass('quantity col-2').append(quantity);
		  var portfolioId_box = $('<div></div>').addClass('portfolioId col-2 d-none').append(portfolioId);
		  var frequency_box = $('<div></div>').addClass('frequency col-2 d-none').append(frequency);
		  var price_box = $('<div></div>').addClass('price col-2').append(price);
		  var remove_box = $('<div></div>').addClass('remove col-1').append(btn);
		  row.append(line_item_id);
		  row.append(variant_id);
		  row.append(img_box);
		  row.append(title);
		  row.append(price_box);
		  row.append(number_box);
		  row.append(frequency_box);
		  row.append(portfolioId_box);
		  row.append(remove_box);
		  $('#'+id+'-token-cart-modals .content .items').append(row);
	
		},
		open_cart: function  () {
		  var Cart = this;
		  var id = this.id;
		  Cart.load_cart();
		  if(this._showCart){
			  $('#'+id+'-cartModal').modal('show');
		  }
	
		},
		load_store: function() {
		  var Cart = this;
		  var id = this.id;
		  storefrontAccessToken = Cart.storefrontAccessToken;
		  domain = Cart.shop;
		  var cart = this;
		  $.cookie.json = true;
	
		  // $.getScript( "https://sdks.token-shopcdn.com/js-buy-sdk/v1/latest/index.umd.min.js", function( data, textStatus, jqxhr ) {
		  // 	console.log( ShopifyBuy ); // Success
	
		  // 	// $.getScript( "http://sdks.token-shopcdn.com/buy-button/1.0.0/buybutton.js", function( data, textStatus, jqxhr ) {
		  // 	console.log( ShopifyBuy ); // Success
		  // 	console.log( textStatus ); // Success
		  // 	console.log( jqxhr.status ); // 200
		  // 	console.log( jqxhr ); // 200
		  // 	console.log( "Cart Load was performed." );
		  // 		const client = ShopifyBuy.buildClient({
		  // 		domain: domain,
		  // 		storefrontAccessToken: storefrontAccessToken
		  // 		});
		  // 		Cart.client = client;
		  // Cart.load_checkout().then(function() {
		  // 	// Cart.get_products();
		  // 	Cart.activate_variants();
	
		  // });
		  Cart.load_checkout();
		  Cart.activate_variants();
		  // var ui = ShopifyBuy.UI.init(client);
		  // console.log("load_store ShopifyBuy.UI" ,ui);
		  // ShopifyBuy.UI.onReady(client).then(function (ui) {
		  // 		ui.createComponent('product', {
		  // 		id: '4364604440629',
		  // 		node: document.getElementById('product-component-1575250675382'),
		  // 		moneyFormat: '%24%7B%7Bamount%7D%7D',
		  // 		options: {
		  // 			"product": {
		  // 			"styles": {
		  // 				"product": {
		  // 				"@media (min-width: 601px)": {
		  // 					"max-width": "calc(25% - 20px)",
		  // 					"margin-left": "20px",
		  // 					"margin-bottom": "50px"
		  // 				}
		  // 				}
		  // 			},
		  // 			"text": {
		  // 				"button": "Add to cart"
		  // 			}
		  // 			},
		  // 			"productSet": {
		  // 			"styles": {
		  // 				"products": {
		  // 				"@media (min-width: 601px)": {
		  // 					"margin-left": "-20px"
		  // 				}
		  // 				}
		  // 			}
		  // 			},
		  // 			"modalProduct": {
		  // 			"contents": {
		  // 				"img": false,
		  // 				"imgWithCarousel": true,
		  // 				"button": false,
		  // 				"buttonWithQuantity": true
		  // 			},
		  // 			"styles": {
		  // 				"product": {
		  // 				"@media (min-width: 601px)": {
		  // 					"max-width": "100%",
		  // 					"margin-left": "0px",
		  // 					"margin-bottom": "0px"
		  // 				}
		  // 				}
		  // 			},
		  // 			"text": {
		  // 				"button": "Add to cart"
		  // 			}
		  // 			},
		  // 			"cart": {
		  // 			"text": {
		  // 				"total": "Subtotal",
		  // 				"button": "Checkout"
		  // 			}
		  // 			}
		  // 		},
		  // 		});
		  // 	});
	
		  // });
		  // });
	
		},
		load_checkout: function  () {
		  var Cart = this;
		  var id = this.id;
		  var productClass = Cart.productClass;
		  var checkout_name = productClass+'_checkout_id';
		  var checkout_id = $.cookie(checkout_name);
		  return Cart.new_checkout();
	
		  if (checkout_id == undefined || checkout_id == null) {
			return Cart.new_checkout();
		  }else{
			console.log('load_checkout checkout_id',checkout_id);
			// return;
			// return Cart.client.checkout.fetch(checkout_id).then((checkout) => {
			var checkout = $.cookie(checkout_id);
	
			// Do something with the checkout
				  console.log('checkout',checkout);
				  if (checkout.order !== null){
					  return Cart.new_checkout();
				  }else{
						  Cart.checkout = checkout;
			  // $.removeCookie(checkout_name);
			  $.cookie(checkout_name, checkout.id);
			  return checkout;
				  }
	
			// });
	
		  }
		},
		new_checkout: function  () {
		  var Cart = this;
		  var id = this.id;
		  var productClass = Cart.productClass;
		  var checkout_name = productClass+'_checkout_id';
		  console.log('new checkout checkout_name',checkout_name);
		  var checkout = {
			id:Cart.guidGenerator(),
			lineItems : [],
			lineItemsDict : {},
			order : null,
		  };
		  console.log('new checkout checkout',checkout);
	
		  Cart.checkout = checkout;
		  $.cookie(checkout_name, checkout.id);
		  $.cookie(checkout.id, checkout);
		  return checkout;
		  // return Cart.client.checkout.create().then((checkout) => {
		  //   // Do something with the checkout
		  //   console.log("checkout",checkout);
		  //   Cart.checkout = checkout;
		  //   $.cookie(checkout_name, checkout.id);
		  // });
		},
		guidGenerator: function() {
		  var S4 = function() {
			return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
		  };
		  return (S4()+S4()+'-'+S4()+'-'+S4()+'-'+S4()+'-'+S4()+S4()+S4());
		},
		get_products: function  () {
		  var Cart = this;
		  var id = this.id;
		  // // 	// Fetch all products in your shop
		  return Cart.client.product.fetchAll().then((products) => {
			  // Do something with the products
			  console.log(' cart products',products);
				Cart.load_products(products);
				Cart.activate_variants();
		  });
		}
	
	  }

	});
});
