<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */
require_once(ABSPATH . 'wp-admin/includes/screen.php');
require_once(ABSPATH . 'wp-admin/includes/taxonomy.php'); 
 

class Yohshow_Balances extends Yohshow_WP {

   public $spendAccountId = 1;//spendAccountId;
   public $reserveAccountId = 4;//rese$reserveAccountId;
   public $accountIdFilter = [0,1,5,4];//accountIdFilter;
   public $internalAccountIdFilter = [1,2,5,4];//internalAccountIdFilter;
   public $spendAccountIdFilter = [1,4];//spendAccountIdFilter;
   public $reserveAccountIdFilter = [2,3,4];//reserveAccountIdFilter;

       

    public function __construct($yohshow_api) {
        parent::__construct($yohshow_api);
        $this->init();

        // // var_dump("test balances yohshow_api",$this->yohshow_api );

      
    }
    function init(){
        // // var_dump("test balances init");
        $this->enqueue_scripts();
        // // var_dump("test balances enqueue_scripts called");

        // $this->register_scripts();
        $this->create_endpoints();
        $this->add_shortcodes();

        $this->process_withdraws();


        // $this->add_actions();
            // $this->tokenize_app();
        // add_action( 'wp_loaded', array( $this, 'rest_api_includes' ), 5 );

    }
    public function process_withdraws(){
      //job should be hourly
      //get last time job was ran
      $now = time();
      $exchange_last_withdraw_timestamp = get_option( "exchange_last_withdraw_timestamp" );
      $mustWithdraw = $exchange_last_withdraw_timestamp ? round(($exchange_last_withdraw_timestamp - $now) / 3600) : true;
      //if job was ran longer than a hour ago,
//        $mustWithdraw = true;
      if($mustWithdraw){
        $exchange_pending_withdraws = get_option( "exchange_pending_withdraws");
        $exchange_pending_withdraws =  $exchange_pending_withdraws  === false ? array() : $exchange_pending_withdraws;
        $still_pending_withdraws = array();
        for ($i=0; $i < count($exchange_pending_withdraws) ; $i++) {
          $exchange_pending_withdraw = $exchange_pending_withdraws[$i];  
          $exchange_pending_withdraw_clearing_date = $exchange_pending_withdraw["clearing_date"]; 
          $withdrawNow = $now > $exchange_pending_withdraw_clearing_date;
//          $withdrawNow = true;
          if($withdrawNow){
            //do withdraw
            $stripe_withdraw = $this->stripe_withdraw($exchange_pending_withdraw);
            if($stripe_withdraw["success"]){
              //update pending to finished
              //add to finished withdraws
              //remove from pending

            }else{
              $still_pending_withdraws[] = $exchange_pending_withdraw;
            }
            
          }else{
            //add to new pending list 
            $still_pending_withdraws[] = $exchange_pending_withdraw;
           }

        }
        $exchange_pending_withdraws_meta_id = update_option( "exchange_pending_withdraws",$still_pending_withdraws);
        $exchange_last_withdraw_timestamp_meta_id = update_option( "exchange_last_withdraw_timestamp",$now);

      }
        //get pending withdraws
        //if withdraw time is schedule
          //run withdraw
          //if with draw was success update withdraw and add to success ful withdraw and out of pending 

    }
    // public function rest_api_includes() {
    //   require_once( WC_ABSPATH . 'includes/wc-cart-functions.php' );
    //   require_once( WC_ABSPATH . 'includes/wc-notice-functions.php' );
    // }
    public function create_endpoints(){

      /*
      routes and pages that must exist 

      balances page //
        'GET /markets': { action: 'view-markets' }, //
        'POST /balances': { action: 'exchange/balances' },

      accounts page
        'GET /cards': { action: 'cards/view-accounts' },
        
        //doesnt existn mostly through market page and should be udpated
        'POST /accounts': { action: 'exchange/accounts' },  

      account page
        'GET /cards/account/:accountId?': { action: 'cards/view-account' },
        'POST /account': { action: 'exchange/account' },  

      transfer page
        'GET /cards/transfer': { action: 'cards/view-transfer' },
        'POST /transferAccounts': { action: 'exchange/transfer-accounts' }, 

      liquidity
        'GET /cards/liquidity': { action: 'cards/view-liquidity' },
        'POST /accounts': { action: 'exchange/accounts' },  
      
      edit profile / profile over view / edit password

        'GET /account':            { action: 'account/view-account-overview' },
        'GET /account/password':   { action: 'account/view-edit-password' },
        'GET /account/profile':    { action: 'account/view-edit-profile' },

      cards
        GET /cards/cards': { action: 'cards/view-cards' },

      paymentmethods
        'GET /payment-methods': { action: 'view-payment-methods' },

      member rewards
        'GET /MemberRewards': { action: 'view-member-rewards' },

      mint token 
      

      
        





missing pages
    in balances
      balances //
      account summary //
      account //
      transfer //
      edit profile //
      cards //
      cards //

      liquidty pool //
      payment methods //
      member rewards //nces
      mint token 

    
    
    markets
      order page
      kyc
      prime trust 
      
    
    cards
      debit cards
    
    static
      contact page
      about page / tokenomics 
      login page
      sign up
      faq
      otc



      //admin stuff
      'GET /appToken': { action: 'view-app-token' },
      'GET /:userType?/cards': { action: 'cards/view-cards' },
      'GET /:userType?/transfer': { action: 'cards/view-transfer' },
      'GET /:userType?/account': { action: 'cards/view-account' },
      'GET /:userType?/account/:accountId?': { action: 'cards/view-account' },
      'GET /:userType?/accounts': { action: 'cards/view-accounts' },
      'GET /:userType?/liquidity': { action: 'cards/view-liquidity' },



 
      market page
        'GET /markets/:market?': { action: 'view-market' }, //
        'POST /market': { action: 'exchange/market' },  // ..
        'POST /place-orders': { action: 'exchange/place-orders' }, // ..


      buy quote page
        'GET /buyUnits': { action: 'view-buy-units' },
        'POST /getQuote': { action: 'exchange/get-quote' },  .. //
        'POST /exchange/checkout/save': { action: 'exchange/save-checkout' }, ..



      sell quote page
        'GET /sell/:symbol?': { action: 'view-sell-units' },
        'POST /getQuote': { action: 'exchange/get-quote' },  ..
        'POST /exchange/checkout/save': { action: 'exchange/save-checkout' }, ..


      pay now page
        'GET /pay-now/:checkoutId?': { action: 'view-pay-now' },
        'POST /payNow': { action: 'exchange/pay-now' }, 


        'POST /update-checkout-payment-method': { action: 'prime-trust/update-checkout-payment-method' }, ..

        


      checkout page
        'GET /checkout/:checkoutId?': { action: 'view-checkout' },
        'POST /pay-now': { action: 'prime-trust/pay-checkout' }, ..
        'POST /checkout': { action: 'exchange/checkout' }, ..



      orders page
        'GET /orders': { action: 'view-orders' },
        'POST /orders': { action: 'exchange/orders' }, ..
        'POST /subscriptions/pause': { action: 'exchange/pause-subscription' }, ..



      place order action
        'POST /place-orders': { action: 'exchange/place-orders' }, // ..

      referes market action 
              'POST /market': { action: 'exchange/market' },  ...


      cancel orders
        'POST /markets/orders/cancel': { action: 'exchange/cancel-order' }, ..


  */

        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/balances', array(
              'methods' => 'POST',
              'callback' => array($this,"balances")
            ) ); //
            register_rest_route( 'yohshow/api/v1', '/addresses', array(
              'methods' => 'POST',
              'callback' => array($this,"addresses")
            ) ); //
            register_rest_route( 'yohshow/api/v1', '/withdraw/fee', array(
              'methods' => 'POST',
              'callback' => array($this,"withdraw_fee")
            ) ); //

            
            register_rest_route( 'yohshow/api/v1', '/account', array(
              'methods' => 'POST',
              'callback' => array($this,"account")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/accounts', array(
              'methods' => 'POST',
              'callback' => array($this,"accounts")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/profile', array(
              'methods' => 'POST',
              'callback' => array($this,"profile")
            ) );  //
            // register_rest_route( 'yohshow/api/v1', '/mint', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"mint")
            // ) );  //

            // register_rest_route( 'yohshow/api/v1', '/mint/overview', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"mint_overview")
            // ) );  //

            register_rest_route( 'yohshow/api/v1', '/orders', array(
              'methods' => 'POST',
              'callback' => array($this,"orders")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/paymentMethods', array(
              'methods' => 'POST',
              'callback' => array($this,"paymentMethods")
            ) );  //




            register_rest_route( 'yohshow/api/v1', '/contact', array(
              'methods' => 'POST',
              'callback' => array($this,"contact")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/kyc', array(
              'methods' => 'POST',
              'callback' => array($this,"kyc")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/register', array(
              'methods' => 'POST',
              'callback' => array($this,"register")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/debitCards', array(
              'methods' => 'POST',
              'callback' => array($this,"debitCards")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/tokenomics', array(
              'methods' => 'POST',
              'callback' => array($this,"tokenomics")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/entrance/login', array(
              // 'methods' => 'POST',
              'methods' => 'PUT',
              'callback' => array($this,"login")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/login/overview', array(
              'methods' => 'POST',
              'callback' => array($this,"login_overview")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/signup/overview', array(
              'methods' => 'POST',
              'callback' => array($this,"signup_overview")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/entrance/signup', array(
              'methods' => 'POST',
              'callback' => array($this,"signup")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/account/update-password', array(
              'methods' => 'PUT',
              // 'methods' => 'POST',
              'callback' => array($this,"update_password")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/account/update-profile', array(
              'methods' => 'PUT',
              // 'methods' => 'POST',
              'callback' => array($this,"update_profile")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/account/upload', array(
              'methods' => 'POST',
              'callback' => array($this,"profile_upload")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/transfer/overview', array(
              'methods' => 'POST',
              'callback' => array($this,"transfer_overview")
            ) );  //
           
            register_rest_route( 'yohshow/api/v1', '/account/transfer', array(
              // 'methods' => 'PUT',
              'methods' => 'POST',
              'callback' => array($this,"transfer")
            ) );  //

           
            register_rest_route( 'yohshow/api/v1', '/account/register', array(
              // 'methods' => 'PUT',
              'methods' => 'POST',
              'callback' => array($this,"register")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/ico', array(
              // 'methods' => 'PUT',
              'methods' => 'POST',
              'callback' => array($this,"ico")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/deliver-contact-form-message', array(
              // 'methods' => 'PUT',
              'methods' => 'POST',
              'callback' => array($this,"contact")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/subscriptions/pause', array(
              // 'methods' => 'PUT',
              'methods' => 'POST',
              'callback' => array($this,"subscriptions")
            ) );  //

            






            

            

            
            register_rest_route( 'yohshow/api/v1', '/faq', array(
              'methods' => 'POST',
              'callback' => array($this,"faq")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/otc', array(
              'methods' => 'POST',
              'callback' => array($this,"otc")
            ) );  //
  

            // register_rest_route( 'yohshow/api/v1', '/market', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"market")
            // ) );//

            // register_rest_route( 'yohshow/api/v1', '/place-orders', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"place_order")
            // ) ); //

            // register_rest_route( 'yohshow/api/v1', '/getQuote', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"get_quote")
            // ) ); //

            // register_rest_route( 'yohshow/api/v1', '/exchange/checkout/save', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"save_checkout")
            // ) ); //


            //   // pay now page view
            // register_rest_route( 'yohshow/api/v1', '/payNow', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"pay_now")
            // ) ); //

            // register_rest_route( 'yohshow/api/v1', '/update-checkout-payment-method', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"update_checkout_payment_method")
            // ) );//
            // // pay now checkout to lead to process checkout and such 
            // register_rest_route( 'yohshow/api/v1', '/pay-now', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"pay_checkout")
            // ) );//

            // register_rest_route( 'yohshow/api/v1', '/checkout', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"checkout")
            // ) );//

            // register_rest_route( 'yohshow/api/v1', '/orders', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"orders")
            // ) );

            // register_rest_route( 'yohshow/api/v1', '/subscriptions/pause', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"pause_subscription")
            // ) );




            

            

            

          } );
      
    }

    // in balances
    //   balances //
    //   account summary //
    //   account //
    //   transfer //
    //   edit profile //
    //   liquidty pool //
    //   payment methods //
    //   member rewards //nces
    //   mint token 

    // 'GET /appToken': { action: 'view-app-token' },
    //   'GET /:userType?/cards': { action: 'cards/view-cards' },
    //   'GET /:userType?/transfer': { action: 'cards/view-transfer' },
    //   'GET /:userType?/account': { action: 'cards/view-account' },
    //   'GET /:userType?/account/:accountId?': { action: 'cards/view-account' },
    //   'GET /:userType?/accounts': { action: 'cards/view-accounts' },
    //   'GET /:userType?/liquidity': { action: 'cards/view-liquidity' },

    //scripts 
    public function subscriptions($request){
      $post = $request->get_params();
      $result = $this->send_request("/subscriptions/pause",$post);
      return  $result;
    }
    public function balances($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $post['refresh'] = true;
      $refreshFilter = $post['refreshFilter'];
      $quote_source_key = "exchange_quote_source";
      $quote_source = get_option( $quote_source_key );
      if($refreshFilter == "exchange" || $quote_source){
        

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

        $quote_source_api_key_key = "exchange_quote_source_api_key";
        $quote_source_api_key = get_option( $quote_source_api_key_key );

        $quote_source_api_secret_key = "exchange_quote_source_api_secret";
        $quote_source_api_secret = get_option( $quote_source_api_secret_key );

        $quote_source_api_memo_key = "exchange_quote_source_api_memo";
        $quote_source_api_memo = get_option( $quote_source_api_memo_key );

        
        $post["exchange"] = $quote_source;
        $post["exchangeApiKey"] = $quote_source_api_key;
        $post["exchangeApiSecret"] = $quote_source_api_secret;
        $post["exchangeApiMemo"] = $quote_source_api_memo;

      }
      if(!isset($post['refreshFilter']) && $quote_source){
        $post['refreshFilter'] = "exchange";

      }
      $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
      $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

      $post["exchangeBuyCurrency"] = $quote_source_buy_currency;

      
      $result = $this->send_request("/balances",$post);
      $result = json_decode($result,true);
      $result["shareLink"] = "/test";
      $result = json_encode($result);
      // overide share link here
      return  $result;
    }
    public function addresses($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
        $quote_source_key = "exchange_quote_source";
        $quote_source = get_option( $quote_source_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

        $quote_source_api_key_key = "exchange_quote_source_api_key";
        $quote_source_api_key = get_option( $quote_source_api_key_key );

        $quote_source_api_secret_key = "exchange_quote_source_api_secret";
        $quote_source_api_secret = get_option( $quote_source_api_secret_key );

        $quote_source_api_memo_key = "exchange_quote_source_api_memo";
        $quote_source_api_memo = get_option( $quote_source_api_memo_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );




      
        $post["exchange"] = $quote_source;
        $post["exchangeApiKey"] = $quote_source_api_key;
        $post["exchangeApiSecret"] = $quote_source_api_secret;
        $post["exchangeApiMemo"] = $quote_source_api_memo;
        $post["exchangeBuyCurrency"] = $quote_source_buy_currency;


      $result = $this->send_request("/addresses",$post);
      $result = json_decode($result,true);
      $result = json_encode($result);
      // overide share link here
      return  $result;
    }
    public function withdraw_fee($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $post['apiSecret'] = $this->yohshow_api_secret;

        $quote_source_key = "exchange_quote_source";
        $quote_source = get_option( $quote_source_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

        $quote_source_api_key_key = "exchange_quote_source_api_key";
        $quote_source_api_key = get_option( $quote_source_api_key_key );

        $quote_source_api_secret_key = "exchange_quote_source_api_secret";
        $quote_source_api_secret = get_option( $quote_source_api_secret_key );

        $quote_source_api_memo_key = "exchange_quote_source_api_memo";
        $quote_source_api_memo = get_option( $quote_source_api_memo_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );




      
        $post["exchange"] = $quote_source;
        $post["exchangeApiKey"] = $quote_source_api_key;
        $post["exchangeApiSecret"] = $quote_source_api_secret;
        $post["exchangeApiMemo"] = $quote_source_api_memo;
        $post["exchangeBuyCurrency"] = $quote_source_buy_currency;


      $result = $this->send_request("/balances/withdraw/fee",$post);
      $result = json_decode($result,true);
      $result = json_encode($result);
      // overide share link here
      return  $result;
    }
    public function accounts($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/accounts",$post);
      return  $result;
    }
    public function account($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/account",$post);
      return  $result;
    }
    
    

    public function register($request){
        $post = $request->get_params();
        $post['apiKey'] = $this->yohshow_api_key;
        $result = $this->send_request("/account/register",$post);
        return  $result;
    }
    public function ico($request){
        $post = $request->get_params();
        $post['apiKey'] = $this->yohshow_api_key;
        $result = $this->send_request("/ICO",$post);
        return  $result;
    }

    public function profile($request){
      $user_id = $_SESSION["exchange_wp_user_id"];

      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/me",$post);
      $result = json_decode($result,true);
      $getUserNameResult = $this->get_username($user_id);
      $username = $getUserNameResult["username"];
      $avatar = $getUserNameResult["avatar"];
      


      $result["username"] = $username;
      $result["avatar"] = $avatar;
      $result["me"]["username"] = $username;
      $result["me"]["avatar"] = $avatar;
      

      return  json_encode($result);
    }
    public function liquidty($request){
      $result = $this->send_request("/liquidty",$request['params']);
      return  $result;
    }
    public function paymentMethods($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/paymentMethods",$post);
      return  $result;
    }
    public function memberRewards($request){
      $result = $this->send_request("/memberRewards",$request['params']);
      return  $result;
    }
    
    
    public function orders($request){
      $post = $request->get_params();
        $post['apiKey'] = $this->yohshow_api_key;
        $result = $this->send_request("/orders",$post);
        return  $result;
    }



    public function contact($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/deliver-contact-form-message",$post);
      return  $result;
    }
    public function kyc($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/kyc",$post);
      return  $result;
    }


    public function debitCards($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/debitCards",$post);
      return  $result;
    }
    public function tokenomics($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/tokenomics",$post);
      return  $result;
    }
    public function login($request){
        if( !session_id() )
        {
            session_start();
        }
      //if current user is admin. this a otc sign in

        $user_id = $_SESSION["exchange_wp_user_id"];
        $user = get_user_by( 'ID', $user_id );

        $roles = ( array ) $user->roles;
       $isAdmin = in_array("administrator",$roles);
        // $isAdmin = false;
      if ( $isAdmin ) {
        $result = $this->login_or_signup($request, "otc");

      } else {
        $result = $this->login_or_signup($request, "login");

      }
      return $result;
    }
    
    public function login_overview($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/login/overview",$post);
      return  $result;
    }
    public function signup($request){
      $result = $this->login_or_signup($request, "signup");
      return $result;
    }
    public function signup_overview($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/signup/overview",$post);
      return  $result;
    }
    public function login_or_signup($request, $action = "login"){
      $post = $request->get_params();

      $post['apiKey'] = $this->yohshow_api_key;
      $post['apiSecret'] = $this->yohshow_api_secret;

      /*
        authenticate with unitedcoin
        if user exist in unitedcoin
          find or create user in wordpress 
        login with wordpress because that should trigger login with excchange backend


      */
      // $result = $this->send_request("/app/auth/".$action,$post);
      if($action == "signup"){
        //check to see if user name exisits
        $username = $post["username"];
        $ownerTerm = get_term_by('name',$username, 'owner');
        $emailExist = $this->check_user_email_exists($post["emailAddress"] );
        error_log( "yoh show balances login_or_signup emailExist ". print_r( $emailExist, true ) );

        if($ownerTerm){
          $result["success"] = false;
          $result["usernameTaken"] = true;
          $result["error"] = "Username taken";
          return json_encode($result);
          
        }else if (!$emailExist ) {
            $result["success"] = false;
            $result["emailTaken"] = true;
            $result["error"] = "Email already exists!";
            return json_encode($result);
        } 


        $result['sucess'] =true;
        $result['sucess'] =true;
        $auth["success"] = true;
      }
      if($action == "otc"){
        $result['sucess'] =true;
        $auth["success"] = true;
          $authUser['emailAddress'] = $post["emailAddress"];
          $auth["user"] = $authUser;
      }else{
        $auth_login_key = "exchange_auth_login";
        $auth_login = get_option( $auth_login_key );
        if($auth_login == "yes"){
          $result = $this->send_request("/auth/".$action,$post);
          $auth = json_decode($result,true);
        }else{
          $result['sucess'] =true;
          $auth["success"] = true;
          $auth["noAuth"] = true;
        }
        
        

        //check of there is no auth method and the user needs to  have an wp account
        // if user is loging in send error if user password is not correct
      }
      
      //must check if this need a wordpress login or now or check before
      if($auth['success']){
        //find or create wordpress site 
        $authUser = $auth['noAuth'] ? $post : $auth['user'];
        $emailAddress = $authUser['emailAddress'];
        $password = $post["password"];
        $user = get_user_by( 'email', $emailAddress );
        if($user === false){

          if($action == "otc"){
              //dont log user error
              //return error message
              $_result["success"] = false;
              $_result["msg"] = "Missing Account Error";
              $_result["error"] = "badCombo";
          }else if($auth["noAuth"] && $action == "login"){
            //email should exist, throw error
            $_result["success"] = false;
            // $_result["msg"] = "Missing Email Error";
            $_result["msg"] = "Login Error";
            $_result["error"] = "badCombo";

   
          }else{
            //create user
            // wp_create_user( $emailAddress, $password, $emailAddress);
            $username = $username ? $username : $authUser['emailAddress'];
            $user_id = wp_insert_user( array(
              'user_login' => $username,
              'user_pass' => $password,
              'user_email' => $authUser['emailAddress'],
              'first_name' => $authUser['firstName'],
              'last_name' => $authUser['lastName'],
              'display_name' => $authUser['fullName'],
              // 'role' => 'editor'
            ));
            if(is_int($user_id)){
              //success
              //crete and save username
              if($action == "signup"){
                //create username with create_term
                $_SESSION["exchange_wp_user_id"] = $user_id;
                $_SESSION["exchange_guest_user"] = false;

                $this->update_username($username);

                // $ownerTerm = wp_create_term( $username, "owner");
                // $ownerTermId = $ownerTerm["term_id"];
                // $user_current_username_term_id = update_user_meta($user_id,"exchange_username_term_id",$ownerTermId);
              }else if($action == "login"){
                $getUserNameResult = $this->get_username($user_id);
                $username = $getUserNameResult["username"];
                $user_current_username_term_id = $getUserNameResult["ownerTermId"];
              }
              


              // log user in 
              wp_clear_auth_cookie();
              wp_set_current_user ( $user_id ); // Set the current user detail
              wp_set_auth_cookie  ( $user_id ); // Set auth details in cookie
            $this->_login($user_id);

              $_result["success"] = true;

            }else{
              //dont log user error
              //return error message
              $_result["success"] = false;
              $_result["msg"] = "cloudError";
              // $_result["error"] = $user_id;

            }
          }
          

        }else{
          $logIn = true;
          if($auth["noAuth"] && $action == "login"){
            
            //authinicate user with wordpress
            $user = wp_authenticate($post["emailAddress"], $post["password"]);
            if(is_wp_error($user)) {
              //email should exist, throw error
              $_result["success"] = false;
              $_result["msg"] = "Login Error";
              $_result["error"] = "badCombo";

              $logIn = false;

            } 
          }
          //login user
          if($logIn){
            $user_id =  $user->ID;
            wp_clear_auth_cookie();
            wp_set_current_user ( $user_id ); // Set the current user detail
            wp_set_auth_cookie  ( $user_id ); // Set auth details in cookie
            $this->_login($user_id);
            $_result["success"] = true;

          }
          
        }
        return json_encode($_result);


      }else{
        return $result;
      }
      
    }
    public function check_user_email_exists($email) {
        // Sanitize email input
        $email = sanitize_email($email);
    
        // Use WordPress function to get user by email
        $user = get_user_by('email', $email);
    
        // If user exists, return false (email is taken)
        return $user ? false : true;
    }
    public function update_password($request){
        if( !session_id() )
        {
            session_start();
        }
//      $user_id = get_current_user_id();
        $user_id = $_SESSION["exchange_wp_user_id"];
//        $current_user = wp_get_current_user();
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $post['apiSecret'] = $this->yohshow_api_secret;
      $password = $post["password"];

      $result = $this->_update_password($user_id,$password);

      // $result = $this->send_request("/auth/password/update",$post);
      // $auth = json_decode($result,true);

      wp_set_password( $password, $user_id );
      return  $result;
    }
    public function _update_password($user_id,$password){
      $user = get_user_by( 'ID', $user_id );
      $emailAddress = $user->user_email;
      $post['emailAddress'] = $emailAddress;
      $post['password'] = $password;
      $post['apiKey'] = $this->yohshow_api_key;
      $post['apiSecret'] = $this->yohshow_api_secret;
      $password = $post["password"];


      $result = $this->send_request("/auth/update-password",$post);
      $auth = json_decode($result,true);

      // wp_set_password( $password, $user_id );
      return  $result;
    }

    
    public function update_profile($request){
      if( !session_id() )
        {
            session_start();
        }
      $exchange_wp_user_id = isset($_SESSION["exchange_wp_user_id"]) ? $_SESSION["exchange_wp_user_id"] : false;

      $post = $request->get_params();
      $username = $post["username"];
      $firstName = $post["firstName"];
      $lastName = $post["lastName"];
      $emailAddress = $post["emailAddress"];
      $fullName = $firstName ." ". $lastName;
      $post["fullName"] = $fullName;
      $updateUsernameResult = $this->update_username($username);
      if($updateUsernameResult['success'] !== true){
        return json_encode($updateUsernameResult);
      }



      //update user first, lastname, phone number
      $user_data = wp_update_user( array( 
        'ID' => $exchange_wp_user_id,
        'user_firstname' => $firstName, 
        'user_lastname' => $lastName,  
        'user_email' => $emailAddress,  
        'display_name' => $fullName,  
        ) );

      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/account/update-profile",$post);
      return  $result;
    }
    public function profile_upload($request){
      $avatar_upload_result = $this->avatar_upload($request);
      return  $avatar_upload_result;
    }
    

    public function faq($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/profile",$post);
      return  $result;
    }
    public function otc($request){
      $post = $request->get_params();
      $post['apiKey'] = $this->yohshow_api_key;
      $result = $this->send_request("/otc/overview",$post);
      return  $result;
    }
    // public function transfer($request){
    //     $post = $request->get_params();
    //     $post['apiKey'] = $this->yohshow_api_key;
    //     $post['apiSecret'] = $this->yohshow_api_secret;
    //     $result = $this->send_request("/account/transfer",$post);
    //     return  $result;
    // }

        //TODO make withdraw_asset_init function here


    public function withdraw_asset_init($withdrawId, $exchange_wp_user_id, $totalCost,$exchangeTokenId,$toAddress,$totalFee,$network = "lightning", $disbursementId = false)  {

      try {
          $amount = floatval($totalCost);
          $totalFee = floatval($totalFee);
          $netAmount = $amount - $totalFee;


          $order = wc_create_order();
          $order->set_customer_id($exchange_wp_user_id);
          $apiKey =  $this->yohshow_api_key;


          $appTokenInfo = array(
            'apiKey' => $apiKey,
          );


          $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/".$apiKey,$appTokenInfo);
          //console.log("view appTokenResult ",appTokenResult );

          $appToken = $appTokenResult->appToken;
          $stableToken = $appTokenResult->stableToken;
          $paymentMethods = $appTokenResult->paymentMethods;

          if($stableToken->id == $exchangeTokenId 
          || $stableToken->symbolBase == $exchangeTokenId
          || $stableToken->symbol == $exchangeTokenId
          || "stable" == $exchangeTokenId
          ){
            $exchangeToken = $stableToken;
            $exchangeTokenId = $stableToken->id;

            $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
            $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

            $currency = strtoupper($quote_source_buy_currency);
            $exchangeAssetId = strtoupper($quote_source_buy_currency);

          }else {
            $exchangeTokenResult = (object) $this->yohshow_api->request("get","/tokens/".$exchangeTokenId,array());
            $exchangeToken = $exchangeTokenResult->token;
            $exchangeTokenId = $exchangeTokenResult->token->id;
            // $currency = $exchangeToken->symbolBase;
            $currency = strtoupper($exchangeToken->symbolBase);
            $exchangeAssetId = strtoupper($exchangeToken->symbolBase);

          }

          
          $network = $network == "lightning" ?  get_option( $quote_source_key ) : $network ;

        

          
          $withdraw_order_key_order_id = $order->get_id();
          // $withdraw_order_key_order_id_updated = update_option($withdraw_order_key, $withdraw_order_key_order_id);
          update_post_meta($withdraw_order_key_order_id, 'exchange_withdraw_id', $withdrawId );
          update_post_meta($withdraw_order_key_order_id, 'exchange_order_withdraw_id', $withdrawId );
          update_post_meta($withdraw_order_key_order_id, 'exchange_payment_id', $withdrawId );
          update_post_meta($withdraw_order_key_order_id, 'exchange_order_payment_id', $withdrawId );
          update_post_meta($withdraw_order_key_order_id, 'exchange_order_action', "withdraw" );


          update_post_meta($withdraw_order_key_order_id,"exchange_totalAmount", $amount);
          update_post_meta($withdraw_order_key_order_id,"exchange_netAmount", $netAmount);
          update_post_meta($withdraw_order_key_order_id,"exchange_type", "withdraw");
          update_post_meta($withdraw_order_key_order_id,"exchange_totalFee", $totalFee);
          update_post_meta($withdraw_order_key_order_id,"exchangeTokenId", $exchangeTokenId);
          update_post_meta($withdraw_order_key_order_id,"exchange_token_id", $exchangeTokenId);
          update_post_meta($withdraw_order_key_order_id,"exchange_toAddress", $toAddress);
          update_post_meta($withdraw_order_key_order_id,"exchange_status", "unpaid");
          update_post_meta($withdraw_order_key_order_id,"exchange_wp_user_id", $exchange_wp_user_id);
          update_post_meta($withdraw_order_key_order_id,"exchangeAssetId", $exchangeAssetId);
          update_post_meta($withdraw_order_key_order_id,"exchange_asset_id", $exchangeAssetId);
          update_post_meta($withdraw_order_key_order_id,"exchange_assetType", $network);
          update_post_meta($withdraw_order_key_order_id,"exchange_network", $network);
          update_post_meta($withdraw_order_key_order_id,"exchange_asset", $currency);

          $flag = true;
          $message = "success";

          $order->add_order_note( "Exchange Withdraw: $exchangeAssetId - $netAmount - $toAddress " );
          $order->add_order_note( "Exchange Withdraw To Address: $toAddress" );
          $order->add_order_note( "Exchange Total Amount: $amount $exchangeAssetId" );
          $order->add_order_note( "Exchange Net Amount: $netAmount $exchangeAssetId" );
          $order->add_order_note( "Exchange Withdraw Fee: $totalFee $exchangeAssetId" );


          if($disbursementId){
            $exchangeDisbursementId = $disbursementId;
            $update_order_error_meta_id = update_post_meta($withdraw_order_key_order_id,"exchange_error","");
            $update_order_exchange_status_meta_id = update_post_meta($withdraw_order_key_order_id,"exchange_status","paid");
            $flag = true;
            $message = "success";
            $order->add_order_note( "Withdraw successful: network - $network, disbursement ID - $exchangeDisbursementId " );

            $update_order_exchangeDisbursementId_meta_id = update_post_meta($withdraw_order_key_order_id,"exchangeDisbursementId",$exchangeDisbursementId);
            $update_order_exchange_disbursement_id_meta_id = update_post_meta($withdraw_order_key_order_id,"exchange_disbursement_id",$exchangeDisbursementId);

          }else {
            $paymentTransfer = $this->withdraw_asset($withdraw_order_key_order_id);
            if($paymentTransfer->success){

            }else{
                $flag = false;
                $message = $paymentTransfer->message;
            }

          }
          
          $updatedPayment = $order;


          $chargeResult = [
              'flag' => $flag,
              'success' => $flag,
              'paid' => $flag,
              'msg' => $message,
              'message' => $message,
              'payment' => $updatedPayment,
          ];

          return $chargeResult;
      } catch (\Throwable $th) {
        //throw $th;
        error_log( "init asset withdraw error th ". print_r( $th, true ) );

      }

      




   
      
    }

    


    public function transfer($request){
      $toToken = false;
      $exchange_wp_user_id = isset($_SESSION["exchange_wp_user_id"]) ? $_SESSION["exchange_wp_user_id"] : false;
      $user = get_user_by("id",$exchange_wp_user_id);
      $user_id = $user->ID;
      $first_name = get_user_meta($user_id, 'first_name',true);
      $last_name = get_user_meta($user_id, 'last_name',true);
      $fullName =  $first_name . " " .$last_name;
      $currentUserfullName = $fullName;
        $Websitename = get_bloginfo( 'name' );

      // $user = $_SESSION["me"];
      $yohshow_api =  $this->yohshow_api;


//      $csrf = $request->get_header('X-CSRF-Token');
      $post = $request->get_params();

      // $inputs = $request['params']['POST'];
      // (object) $inputs;
      // TODO convert  to php
        $fromSpendAccountId = $post['fromSpendAccountId'];
      $fromAccountId = $post['fromAccountId'];
        $fromAccountId = !$fromAccountId && $fromSpendAccountId ? $fromSpendAccountId : $fromAccountId;
      $transferType = $post['transferType'];
      $toDeposit = $post['toDeposit'];
      $toInternal = $post['toInternal'];
      $toExternal = $post['toExternal'];
      $toPayment = $post['toPayment'];
      $toPaymentMethod = $post['toPaymentMethod'];
      $amount = $post['amount'];
      $note = $post['note'];
      $getWeb3Transactions = $post['getWeb3Transactions'];
      $fromAddress = $post['fromAddress'];
      $network = $post['network'];
      $transactionHash = $post['transactionHash'];
      $toAddress =  $post['toAddress'];
      $tokenBankTransaction =  $post['tokenBankTransaction'];

      $fromSwapCurrency =  $post['fromSwapCurrency'];
      $toSwapCurrency =  $post['toSwapCurrency'];
      $toSwapEmail =  $post['toSwapEmail'];
      $toSwapName =  $post['toSwapName'];

      

      // error_log("transfer fromAccountId ".$fromAccountId);
      // error_log("transfer transferType ".$transferType);
      // error_log("transfer toDeposit ".$toDeposit);
      // error_log("transfer toInternal ".$toInternal);
      // error_log("transfer toExternal ".$toExternal);
      // error_log("transfer toPayment ".$toPayment);
      // error_log("transfer toPaymentMethod ".$toPaymentMethod);
      // error_log("transfer amount ".$amount);
      // error_log("transfer note ".$note);
      // error_log("transfer getWeb3Transactions ".$getWeb3Transactions);
      // error_log("transfer fromAddress ".$fromAddress);
      error_log( "transfer post". print_r( $post, true ) );
      


      if($transferType == 'deposit'){
        if(!$toDeposit){
          $result =  [
            'flag' => false,
            'msg' =>  "To deposit not set",
          ];
            return json_encode($result);
        }

      }else{
        if(!$fromAccountId ) {
          $result = [
            'fromAccountId' => $fromAccountId,
            'post' => $post,
            
            'flag' => false,
            'msg' =>  "From account not set",
          ];
          return json_encode($result);
        }

      }


      $transfer = array(
        'type' => $transferType,
        'fromAccountId' => $fromAccountId,
        'amount' => $amount,
      );
      // (object) $transfer;
      // error_log("transfer transfer",$transfer);
      // error_log("transfer transfer",$transferType);

      error_log( "transfer deposit transferType". print_r( $transferType, true ) );


      if($transferType == 'internal'){
        $transfer['toAccountId'] = $toInternal;
        $transfer['note'] = $note ? $note: "Internal Transfer" ;
      }else if($transferType == 'payment' || $transferType == 'exchange'){
        if($toPaymentMethod == "email"){
          $toPayment = strtolower($toPayment);
          $toUser = get_user_by_email($toPayment);
          // error_log("transfer email toPaymentMethod",$toPaymentMethod);
          // error_log("transfer email toUser",$toUser);
        }else if($toPaymentMethod == "phone"){
          $toUser = get_users(array('meta_key' => 'phone', 'meta_value' => $toPaymentMethod));
          $toUser = count($toUser) > 0 ? $toUser[0] : false;
          // error_log("transfer email toPaymentMethod",$toPaymentMethod);
          // error_log("transfer email toUser",$toUser);
        }else{
          $toUser = false;
          $toToken = true;

          //TODO code to import non imported producted/ tokens
          $exchange_action = "payment";
          $symbolKey = "exchange_product_".$exchange_action."_symbol_".$toPayment;
          $symbolKey_product_id = get_option( $symbolKey );
          if($symbolKey_product_id){
            $exchangeTokenId = get_post_meta($symbolKey_product_id,"exchange_token_id",true);


          }else{
            $toUserExist = false;

            //return error token not found
          }


        }
        if($fromAccountId == "myWallet"){
          $transfer['apiKey'] = $this->yohshow_api_key;
          $transfer['apiSecret'] = $this->yohshow_api_secret;
        }
        if($toUser){
          (object) $toUser;
          // error_log("transfer user set toUser->ID",$toUser->ID);
          $toUserId = $toUser->ID;
          $toUserFirstName  = $toUser->user_firstname;
          $toUserLastName  = $toUser->user_lastname;
          $toUsername  = $toUser->user_login;
          $toUserFullName  = $toUserFirstName ." ". $toUserLastName;

          // $toUserEmailAddress = $toUser->user_email;
          $toUserEmailAddress = strtolower($toPayment) ;

          $toUserId = $toUser->ID;



          $toUserlogin = (object) $this->yohshow_api->get_user($toUserFullName, $toUserEmailAddress, $toUsername );
          $exchangeTokenId =  $toUserlogin->tokenId;
          $exchangeTokenIdMetaId = update_user_meta($toUserId,"exchangeTokenId",$exchangeTokenId);


          $exchangeTokenId = get_user_meta($toUserId,"exchangeTokenId",true);
          // error_log("transfer user set exchangeTokenId",$exchangeTokenId);
          if($exchangeTokenId == false){
            // error_log("transfer user exchange token not set exchangeTokenId",$exchangeTokenId);


          }else{
            // $fullName = "New User";
            // // $emailAddress = "tony201@yohshow.com";
            // $emailAddress = $toPaymentMethod;

            // $signup = (object)$this->yohshow_api->signup($fullName,$emailAddress);
            // //echo '<pre>';
            // error_log("signup result",$signup);
            // //echo '</pre>';
            // // $login = (object) $this->yohshow_api->login($emailAddress);
            // //echo '<pre>';
            // // error_log("login result",$login);
            // //echo '</pre>';
            // error_log("transfer user exchange token not set signup signup",$signup);
            // $exchangeTokenId =  $signup->tokenId;
            // error_log("transfer user exchange token not set signup exchangeTokenId",$exchangeTokenId);
            // $exchangeTokenIdMetaId = get_user_meta($userId,"exchangeTokenId",$exchangeTokenId);

          }



          $transfer['toTokenId'] = $exchangeTokenId;


          $paymentNote = $currentUserfullName . " - " . $note;
          $transfer['note'] = $note ? $paymentNote : "Payment" ;
          $transfer['payOwner'] = true;
          $toUserExist = true;
          // error_log("transfer user exchange to user updated exchangeTokenId",$exchangeTokenId);
          // error_log("transfer user exchange to user updated transfer",$transfer);
          // error_log("transfer user exchange to user updated transfer->toTokenId",$transfer['toTokenId']);

        }else if($toToken){
          $transfer['toTokenId'] = $exchangeTokenId;
          $paymentNote = $currentUserfullName . " - " . $note;
          $transfer['note'] = $note ? $paymentNote : "Payment" ;
          $transfer['payOwner'] = true;
          $toUserExist = true;

        }else{
          //invite user
          // Send "confirm account" email
          $toUserExist = false;
          $this->sendTemplateEmail([
            'to' => $toPayment,
            'subject' => "$Websitename Payment Sent",
            'template' => 'payment-invite',
            'templateData' => [
              'amount' => $amount,
              'fromUser' => $user,
              'fullName' => "",
            ]
          ]);
        }

      }else if($transferType == 'deposit' || $transferType == 'swap'){
        //need to charge user here
        $transfer['apiKey'] = $this->yohshow_api_key;
        $transfer['apiSecret'] = $this->yohshow_api_secret;
        if($transferType == 'swap'){

          $transfer['note'] =  "Swap" ;
          $transfer['fromSwapCurrency'] =  $fromSwapCurrency;
          $transfer['toSwapCurrency'] =  $toSwapCurrency;
          $transfer['toSwapEmail'] =  $toSwapEmail;
          $transfer['toSwapName'] =  $toSwapName;
        }else{
          $transfer['note'] = $note ? $note: "Deposit" ;

          $transfer['toAccountId'] = $toDeposit;

        }
        $toUserExist = true;
        error_log( "transfer deposit transfer". print_r( $transfer, true ) );



      }else if($transferType == 'external'){
        $toUser = $user;
        $toUserExist = true;
        $transfer['toAddress'] = $toAddress ? $toAddress: false ;
        $transfer['tokenBankTransaction'] = $tokenBankTransaction ? $tokenBankTransaction: false ;

        $transfer['note'] = $note ? $note: "Withdral" ;
        $transfer['apiKey'] = $this->yohshow_api_key;
        $transfer['apiSecret'] = $this->yohshow_api_secret;
        $quote_source_key = "exchange_quote_source";
        $quote_source = get_option( $quote_source_key );
        if($tokenBankTransaction){
          //dont add exchange info and do nothing

        }else if($quote_source){
          
  
          $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
          $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );
  
          $quote_source_api_key_key = "exchange_quote_source_api_key";
          $quote_source_api_key = get_option( $quote_source_api_key_key );
  
          $quote_source_api_secret_key = "exchange_quote_source_api_secret";
          $quote_source_api_secret = get_option( $quote_source_api_secret_key );
  
          $quote_source_api_memo_key = "exchange_quote_source_api_memo";
          $quote_source_api_memo = get_option( $quote_source_api_memo_key );

          $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
          $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

          $transfer["exchangeBuyCurrency"] = $quote_source_buy_currency;
  
          
          $transfer["exchange"] = $quote_source;
          $transfer["exchangeApiKey"] = $quote_source_api_key;
          $transfer["exchangeApiSecret"] = $quote_source_api_secret;
          $transfer["exchangeApiMemo"] = $quote_source_api_memo;
  
        }


        
      }
      // error_log("transfer post transfer transfer->note",$transfer['note']);
      // error_log("transfer pre transfer transfer",$transfer);
      error_log("transfer pre transfer transactionHash ".print_r( $transactionHash, true ) );
      if($transactionHash){
        $transfer['apiKey'] = $this->yohshow_api_key;
        $transfer['apiSecret'] = $this->yohshow_api_secret;
      error_log("transfer pre transfer transactionHash set transfer ". print_r( $transfer, true ));

      }else{
        error_log("transfer pre transfer  transfer ". print_r( $transfer, true ));

      }

      $transferInfo = $transfer;

      error_log( "transfer not getWeb3Transactions". print_r( $getWeb3Transactions, true ) );


      // todo add if else to check to see if we should get web3 transactions or send transaction
      if($getWeb3Transactions){
        $transfer['fromAddress'] = $fromAddress;
        $transfer['network'] = $network;
        $transfer = (object) $this->yohshow_api->request("post","/account/transfer/web3",$transfer);
        error_log( "transfer getWeb3Transactions transfer". print_r( $transfer, true ) );


      }else{
        $transfer['transactionHash'] = $transactionHash;
        $transfer['network'] = $network;

        $transfer = (object) $this->yohshow_api->request("post","/accountTransfer",$transfer);
        error_log( "transfer not getWeb3Transactions transfer". print_r( $transfer, true ) );



      }
      // error_log("transfer post call transfer transfer",$transfer);

      $flag = true;
      $msg = "Your transfer was sent successfully";
      if($transfer == false){
          $flag = false;
          $msg = "There was an error sending your transfer";
      }else if ($transfer->transfer && $transfer->transfer->success === false) {
          $flag = false;
          $msg = $transfer->transfer->msg;
      }
      if($flag && $transferType == "external"){
          $payment = $transfer->transfer->payment;
          $withdrawTransfer = $transfer->withdrawTransfer;

          $netAmount = $payment->netAmount;
          $exchange_payment_id = $payment->id;
        $exchange_environment = get_option( "exchange_environment" );
        if($exchange_environment == "production"){
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );
        }else{
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );
        }

        //TODO use withdraw_asset_init function here
        $quote_source_key = "exchange_quote_source";
        $quote_source = get_option( $quote_source_key );

        if($tokenBankTransaction) {
          // error_log( "transfer transfer". print_r( $transfer, true ) );
          // error_log( "transfer post". print_r( $post, true ) );
          // error_log( "transfer transferInfo". print_r( $transferInfo, true ) );
          $payment = $transfer->transfer->payment;
          $netAmount =  $payment->netAmount;
          $totalFee =  $payment->totalFee;
          $totalAmount =  $payment->totalAmount;
          $exchangeTokenId =  $payment->paymentMethod;
          $withdrawId =  $payment->id;
          $toAddress =  $post['toAddress'];
          $disbursementId = $withdrawTransfer &&  $withdrawTransfer->success ?  $withdrawTransfer->disbursementId : false;
          


          // error_log( "tranfer transfer ". print_r( $transfer, true ) );
          // error_log( "tranfer transfer->transfer->payment ". print_r( $transfer->transfer->payment, true ) );



          // error_log( "transfer netAmount $netAmount" );
          // error_log( "transfer totalFee $totalFee" );
          // error_log( "transfer totalAmount $totalAmount" );
          // error_log( "transfer exchangeTokenId $exchangeTokenId" );
          // error_log( "transfer withdrawId $withdrawId" );
          // error_log( "transfer toAddress $toAddress" );

          $withdrawResult = $this->withdraw_asset_init($withdrawId,$exchange_wp_user_id, $totalAmount,$exchangeTokenId,$toAddress,$totalFee,$network,$disbursementId) ;
        }else if($network !== "lightning"){
          // error_log( "transfer transfer". print_r( $transfer, true ) );
          // error_log( "transfer post". print_r( $post, true ) );
          // error_log( "transfer transferInfo". print_r( $transferInfo, true ) );
          $payment = $transfer->transfer->payment;
          $netAmount =  $payment->netAmount;
          $totalFee =  $payment->totalFee;
          $totalAmount =  $payment->totalAmount;
          $exchangeTokenId =  $payment->paymentMethod;
          $withdrawId =  $payment->id;
          $toAddress =  $post['toAddress'];
          $disbursementId = $withdrawTransfer &&  $withdrawTransfer->success ?  $withdrawTransfer->disbursementId : false;


          // error_log( "tranfer transfer ". print_r( $transfer, true ) );
          // error_log( "tranfer transfer->transfer->payment ". print_r( $transfer->transfer->payment, true ) );



          // error_log( "transfer netAmount $netAmount" );
          // error_log( "transfer totalFee $totalFee" );
          // error_log( "transfer totalAmount $totalAmount" );
          // error_log( "transfer exchangeTokenId $exchangeTokenId" );
          // error_log( "transfer withdrawId $withdrawId" );
          // error_log( "transfer toAddress $toAddress" );

          $withdrawResult = $this->withdraw_asset_init($withdrawId,$exchange_wp_user_id, $totalAmount,$exchangeTokenId,$toAddress,$totalFee,$network,$disbursementId)  ;
        } else if($quote_source){
          // error_log( "transfer transfer". print_r( $transfer, true ) );
          // error_log( "transfer post". print_r( $post, true ) );
          // error_log( "transfer transferInfo". print_r( $transferInfo, true ) );
          $payment = $transfer->transfer->payment;
          $netAmount =  $payment->netAmount;
          $totalFee =  $payment->totalFee;
          $totalAmount =  $payment->totalAmount;
          $exchangeTokenId =  $payment->paymentMethod;
          $withdrawId =  $payment->id;
          $toAddress =  $post['toAddress'];
          $disbursementId = $withdrawTransfer &&  $withdrawTransfer->success ?  $withdrawTransfer->disbursementId : false;


          // error_log( "tranfer transfer ". print_r( $transfer, true ) );
          // error_log( "tranfer transfer->transfer->payment ". print_r( $transfer->transfer->payment, true ) );



          // error_log( "transfer netAmount $netAmount" );
          // error_log( "transfer totalFee $totalFee" );
          // error_log( "transfer totalAmount $totalAmount" );
          // error_log( "transfer exchangeTokenId $exchangeTokenId" );
          // error_log( "transfer withdrawId $withdrawId" );
          // error_log( "transfer toAddress $toAddress" );

          $withdrawResult = $this->withdraw_asset_init($withdrawId,$exchange_wp_user_id, $totalAmount,$exchangeTokenId,$toAddress,$totalFee,"lightning",$disbursementId) ;
        }



        // if(true){
          else if($exchange_stripe_apiSecret){
            //add to pending withdraw
            $now = time();
            $clearing_date = strtotime('+7 days', $now);

            $exchange_environment = get_option( "exchange_environment" );
            if($exchange_environment == "production"){
              $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );
            }else{
              $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );
            }

            //do stripe withdraw
            $stripe = new \Stripe\StripeClient($exchange_stripe_apiSecret);

            $yohshow_stripe = new Yohshow_Stripe( $this->yohshow_api );
            $stripe_account_result = $yohshow_stripe->get_account();
            $exchange_stripe_account_id = $stripe_account_result["exchange_stripe_account_id"];

            $pending_withdraw["netAmount"] =  $netAmount;
            $pending_withdraw["exchange_stripe_account_id"] =  $exchange_stripe_account_id;
            $pending_withdraw["exchange_wp_user_id"] =  $user_id;
            $pending_withdraw["exchange_payment_id"] =  $exchange_payment_id;
            $pending_withdraw["exchange_environment"] =  $exchange_environment;
            $pending_withdraw["exchange_transaction_type"] =  "withdraw";
            $pending_withdraw["exchange_transaction_network"] =  "stripe";
            $pending_withdraw["clearing_date"] =  $clearing_date;

            //save site withdraw

            $exchange_pending_withdraws = get_option( "exchange_pending_withdraws",array() );
            array_push($exchange_pending_withdraws,$pending_withdraw);
            $exchange_pending_withdraws_meta_id = update_option( "exchange_pending_withdraws",$exchange_pending_withdraws );

            //save user withdraw

            $exchange_pending_withdraws = get_user_meta($exchange_wp_user_id,"exchange_pending_withdraws",true);
            $exchange_pending_withdraws = $exchange_pending_withdraws? $exchange_pending_withdraws : array();
            $exchange_pending_withdraws[$exchange_payment_id] =  $pending_withdraw;
            $exchange_pending_withdraws_user_meta_id = update_user_meta($exchange_wp_user_id,"exchange_pending_withdraws",$exchange_pending_withdraws);

            $exchange_enviorment_pending_withdraws = get_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_pending_withdraws",true);
            $exchange_enviorment_pending_withdraws = $exchange_enviorment_pending_withdraws? $exchange_enviorment_pending_withdraws : array();
            $exchange_enviorment_pending_withdraws[$exchange_payment_id]  =  $pending_withdraw;
            $exchange_enviorment_pending_withdraws_user_meta_id = update_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_pending_withdraws",$exchange_enviorment_pending_withdraws);

//            $exchange_pending_withdraws = get_option( "exchange_pending_withdraws",array() );

        }

        
        
      }
      if($flag && $transferType !== "internal"){
        if( ($transferType == "payment" || $transferType == "exchange") && $toUserExist ){
          $this->sendTemplateEmail([
            'to' =>  $user->emailAddress,
            'subject' =>  '$Websitename Payment Sent',
            'template' =>  'payment-sent',
            'templateData' =>  [
              'amount' =>  $amount,
              'fromUser' =>  $user,
              'toUser' =>  $toUser,
              'fullName' =>  $toUser->fullName,
              'transferType' => $transferType,
            ]
          ]);

        }else if( ($transferType == "payment" || $transferType == "exchange") && !$toUserExist ){
          $this->sendTemplateEmail([
            'to' =>  $user->emailAddress,
            'subject' =>  '$Websitename Payment Sent',
            'template' =>  'payment-sent',
            'templateData' =>  [
              'amount' =>  $amount,
              'fromUser' =>  $user,
              'toUser' =>  $toPayment,
              'fullName' =>  $toPayment,
              'transferType' => $transferType,
            ]
          ]);
        }else{
          $this->sendTemplateEmail([
            'to' =>  $user->emailAddress,
            'subject' =>  '$Websitename Payment Sent',
            'template' =>  'payment-sent',
            'templateData' =>  [
              'amount' =>  $amount,
              'fromUser' =>  $user,
              'toUser' =>  $user,
              'fullName' =>  $currentUserfullName,
              'transferType' => $transferType,
            ]
          ]);

        }

        if(!$toUserExist && $transferType !== "swap" ){
          $this->sendTemplateEmail([
            'to' =>  $toUser->emailAddress,
            'subject' =>  '$Websitename Payment Sent',
            'template' =>  'payment-recieved',
            'templateData' =>  [
              'amount' =>  $amount,
              'fromUser' =>  $user,
              'fullName' =>  $currentUserfullName,
              'transferType' => $transferType,
            ]
          ]);
          $flag = false;
          $msg = "This user does not have an account yet but we them an invite";
        }
      }
      //email
      $result = [
        'transfer' => $transfer,
        'flag' => $flag,
        'msg' => $msg,
      //   baseUrl:$this->baseUrl,

      ];

      // // var_dump($request);
      // // var_dump("csrf",$csrf);
      // // var_dump("inputs",$inputs);
      // // var_dump("withdrawAmount",$request['withdrawAmount']);
      // // var_dump("params",$request['params']);
      // // var_dump("params post",$request['params']['POST']);
      return json_encode($result);
      return $token;
      // return json_encode($data);

  }
  public function stripe_withdraw($withdraw_request){
    $netAmount = $withdraw_request["netAmount"];
    $exchange_wp_user_id = $withdraw_request["exchange_wp_user_id"];
    $exchange_payment_id = $withdraw_request["exchange_payment_id"];

    $exchange_transaction_type = $withdraw_request["exchange_transaction_type"];
    $exchange_transaction_network = $withdraw_request["exchange_transaction_network"];
    
    $exchange_stripe_account_id = $withdraw_request["exchange_stripe_account_id"];
    try {
        $exchange_environment = get_option( "exchange_environment" );
        if($exchange_environment == "production"){
            $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );
        }else{
            $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );
        }
        $stripe = new \Stripe\StripeClient($exchange_stripe_apiSecret);

        $yohshow_stripe = new Yohshow_Stripe( $this->yohshow_api );
      //do payment to account of net fee
      $stripe_transfer = $stripe->transfers->create([
        "amount" => $netAmount,
        "currency" => "usd",
        "destination" => $exchange_stripe_account_id,
      ]);
      $stripe_transfer_id = $stripe_transfer->id;
      if($stripe_transfer_id){
        //info to store
          //site trandsaction index //
          //user transaction index?? probably not
          //exchange payment id //
          //stripe payment id //
          //payment type //
          //transaction composit key // external record/payment info - expayment infno
          //transaction type //
          //transaction type //
          //trandsaction index
          //trandsaction index
          //trandsaction index
          // $exchange_transaction_site_meta_ids = update_option("exchange_transaction_ids", array());
          // $exchange_withdraw_site_meta_ids = update_option("exchange_withdraw_ids", array());
          // $exchange_stripe_site_meta_ids = update_option("exchange_stripe_ids", array());
          // $exchange_stripe_withdraw_site_meta_ids = update_option("exchange_stripe_withdraw_ids", array());
          

          $exchange_transaction_ids = get_option("exchange_transaction_ids",array());
          $exchange_withdraw_ids = get_option("exchange_withdraw_ids",array());
          $exchange_stripe_ids = get_option("exchange_stripe_ids",array());
          $exchange_stripe_withdraw_ids = get_option("exchange_stripe_withdraw_ids",array());

          $exchange_environment_transaction_ids = get_option("exchange_".$exchange_environment."_transaction_ids",array());
          $exchange_environment_withdraw_ids = get_option("exchange_".$exchange_environment."_withdraw_ids",array());
          $exchange_environment_stripe_ids = get_option("exchange_".$exchange_environment."_stripe_ids",array());
          $exchange_environment_stripe_withdraw_ids = get_option("exchange_".$exchange_environment."_stripe_withdraw_ids",array());

          $exchange_transaction_cnt = count($exchange_transaction_ids);
          $exchange_transaction_type = "withdraw";
          $exchange_transaction_network = "stripe";

          //add enviorment to transation key
          $exchange_transaction_key = $exchange_transaction_cnt."_".$exchange_environment."_".$exchange_transaction_type."_".$exchange_transaction_network."_".$stripe_transfer_id."_".$exchange_payment_id. "_". $exchange_wp_user_id;


        //save site transfer
          //stripe withdraw ids
          //stripe ids
          // exchange withdraw ids / payment id
          // exchange transaction  ids / payment id

          array_push($exchange_transaction_ids,$exchange_transaction_key);
          array_push($exchange_withdraw_ids,$exchange_transaction_key);
          array_push($exchange_stripe_ids,$exchange_transaction_key);
          array_push($exchange_stripe_withdraw_ids,$exchange_transaction_key);

          $exchange_transaction_site_meta_ids = update_option("exchange_transaction_ids",$exchange_transaction_ids);
          $exchange_withdraw_site_meta_ids = update_option("exchange_withdraw_ids",$exchange_withdraw_ids);
          $exchange_stripe_site_meta_ids = update_option("exchange_stripe_ids",$exchange_stripe_ids);
          $exchange_stripe_withdraw_site_meta_ids = update_option("exchange_stripe_withdraw_ids",$exchange_stripe_withdraw_ids);

          array_push($exchange_environment_transaction_ids,$exchange_transaction_key);
          array_push($exchange_environment_withdraw_ids,$exchange_transaction_key);
          array_push($exchange_environment_stripe_ids,$exchange_transaction_key);
          array_push($exchange_environment_stripe_withdraw_ids,$exchange_transaction_key);

          $exchange_environment_transaction_site_meta_ids = update_option("exchange_".$exchange_environment."_transaction_ids",$exchange_environment_transaction_ids);
          $exchange_environment_withdraw_site_meta_ids = update_option("exchange_".$exchange_environment."_withdraw_ids",$exchange_environment_withdraw_ids);
          $exchange_environment_stripe_site_meta_ids = update_option("exchange_".$exchange_environment."_stripe_ids",$exchange_environment_stripe_ids);
          $exchange_environment_stripe_withdraw_site_meta_ids = update_option("exchange_".$exchange_environment."_stripe_withdraw_ids",$exchange_environment_stripe_withdraw_ids);


   


        //save user transfer
        $exchange_transaction_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_transaction_ids",$exchange_transaction_key);
        $exchange_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_withdraw_ids",$exchange_transaction_key);
        $exchange_stripe_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_stripe_ids",$exchange_transaction_key);
        $exchange_stripe_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_stripe_withdraw_ids",$exchange_transaction_key);

        $exchange_environment_transaction_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_transaction_ids",$exchange_transaction_key);
        $exchange_environment_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_withdraw_ids",$exchange_transaction_key);
        $exchange_environment_stripe_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_stripe_ids",$exchange_transaction_key);
        $exchange_environment_stripe_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_stripe_withdraw_ids",$exchange_transaction_key);

        $exchange_pending_withdraws = get_user_meta($exchange_wp_user_id,"exchange_pending_withdraws",true);
        $exchange_pending_withdraws = $exchange_pending_withdraws? $exchange_pending_withdraws : array();
        unset($exchange_pending_withdraws[$exchange_payment_id]);
        $exchange_pending_withdraws_user_meta_id = update_user_meta($exchange_wp_user_id,"exchange_pending_withdraws",$exchange_pending_withdraws);

        $exchange_enviorment_pending_withdraws = get_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_pending_withdraws",true);
        $exchange_enviorment_pending_withdraws = $exchange_enviorment_pending_withdraws? $exchange_enviorment_pending_withdraws : array();
        unset($exchange_enviorment_pending_withdraws[$exchange_payment_id]);
        $exchange_enviorment_pending_withdraws_user_meta_id = update_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_pending_withdraws",$exchange_enviorment_pending_withdraws);

        $flag = true;
        $msg = "success";


        

      }else{
        //throw $th;
        $flag = false;
        $msg = "Payment cloud ID error.";
      }
    } catch (\Throwable $th) {
      //throw $th;
      $stripe_transfer =false;
      $flag = false;
      $msg = "Payment cloud error.";
    }
    $result["success"] = $flag;
    $result["msg"] = $msg;
    return $result;

  }
    public function transfer_overview($request){
        $post = $request->get_params();
        $post['apiKey'] = $this->yohshow_api_key;
        $result = $this->send_request("/transfer/accounts",$post);

        $result = json_decode($result,true);
        $exchange_environment = get_option( "exchange_environment" );
        if($exchange_environment == "production"){
          $exchange_stripe_apiKey = get_option( "exchange_stripe_apiKey" );

        }else{
          $exchange_stripe_apiKey = get_option( "exchange_stripe_apiKeyTest" );

        }

        if($exchange_stripe_apiKey){
//            if(true){
          $yohshow_stripe = new Yohshow_Stripe( $this->yohshow_api );
          $stripe_account_result = $yohshow_stripe->get_account();
          $result["mustOnboard"] = $stripe_account_result["mustOnboard"];
          $result["onboardUrl"] = $stripe_account_result["onboardUrl"];

        }else{
          //
          $result["mustOnboard"] = false;
          $result["onboardUrl"] = false;
          
        }


        $result = json_encode($result);

        
        return  $result;
    }

  

    
    public function get_market($currencyPair){
      session_start();
        global $current_user;
        // doesnt work
        // $is_user_logged_in = is_user_logged_in();


      $is_user_logged_in = isset($_SESSION["exchange_wp_user_id"]) && $_SESSION["exchange_wp_user_id"] ? true : false  ;
        // $user = wp_get_current_user();
      $me = array();
      if($is_user_logged_in){
        // $me["exchange_wp_user_id"] = $_SESSION["exchange_wp_user_id"];
        $me["exchangeUserId"] = $_SESSION["exchange_user_id"];
      }

      // var currencyPair = inputs.currencyPair;
      // var req = inputs.req;
      // var session = req.session;
      //if market dont exit and its uppost exist create it
      if($is_user_logged_in){
        // var market = await sails.helpers.exchange.request("post","/markets/"+currencyPair,{},session);
 

  
        $market = (object) $this->yohshow_api->request("post","/markets/".$currencyPair,[]);
      }else{
        $market = (object) $this->yohshow_api->request("get","/public/markets/".$currencyPair,[]);
        // var market = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair,{},session);
    }
      //console.log('market helper return',market);
      // var currencyInfo = await sails.helpers.exchange.currencyPair(currencyPair);
      // market = Object.assign(market, currencyInfo);
      // var buyCurrency = market.buyCurrency;
      // var sellCurrency = market.sellCurrency;
      // market['depth'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/depth",{},session);
      // market['trades'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/trades",{},session);
      // market['orders'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/order-book",{},session);
      // market['kLine'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/k-line",{},session);
      // market[buyCurrency] = await sails.helpers.exchange.request("get","/account/balances/"+buyCurrency.toLowerCase(),{},session);
      // market[sellCurrency] = await sails.helpers.exchange.request("get","/account/balances/"+sellCurrency.toLowerCase(),{},session);
      // market.chartData = {};
      // market.chartData.trades = await sails.helpers.exchange.chartData("trades",market.trades);
      $market->orders = $this->format_orders($market->orders);
      $market->id  = strtolower($market->id);
      $market->loggedIn = $is_user_logged_in;
      $market->me = $me;
      return $market;
    }
    public function format_orders(&$orders){
      // $orders = inputs.orders;
      $total_asks_supply = 0;
      $total_asks_demand = 0;
      $total_bids_supply = 0;
      $total_bids_demand = 0;
      for ($i=0; $i < count($orders->asks) ; $i++) { 
        $ask = $orders->asks[$i];
        $price = floatval($ask->price);
        $remainingVolume = floatval($ask->remainingVolume);
        $total_asks_supply += $remainingVolume;
        $total_asks_demand += $remainingVolume * $price;
        $price = floatval($ask->price);
      }
      
      for ($i=0; $i < count($orders->bids) ; $i++) { 
        $bid = $orders->bids[$i];
        $price = floatval($bid->price);
        $remainingVolume = floatval($bid->remainingVolume);
        $total_bids_supply += $remainingVolume;
        $total_bids_demand += $remainingVolume * $price;
        $price = floatval($bid->price);
      }
      
      $orders->total_asks_supply = $total_asks_supply;
      $orders->total_asks_demand = $total_asks_demand;
      $orders->total_bids_supply = $total_bids_supply;
      $orders->total_bids_demand = $total_bids_demand;

      return $orders;

      // orders.asks.forEach(order => {
      //     //console.log('ask order',order);
      //     var price = parseFloat(order.price);
      //     var remainingVolume = parseFloat(order.remainingVolume);
      //     total_asks_supply += remainingVolume;
      //     total_asks_demand += remainingVolume * price;
      // });
      // orders.bids.forEach(order => {
      //     //console.log('bid order',order);
      //     var price = parseFloat(order.price);
      //     var remainingVolume = parseFloat(order.remainingVolume);
      //     total_bids_supply += remainingVolume;
      //     total_bids_demand += remainingVolume * price;
      // });
      // orders.total_asks_supply = total_asks_supply;
      // orders.total_asks_demand = total_asks_demand;
      // orders.total_bids_supply = total_bids_supply;
      // orders.total_bids_demand = total_bids_demand;
  
      // //console.log(orders);
      // return orders;
    }

    public function add_shortcodes(){
        add_shortcode('balances', array($this,'balances_shortcode') );
    }
    /**
    * Displays account of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called

    /**
    * Displays markets of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function balances_shortcode() { 
      $is_user_logged_in = is_user_logged_in();
      if($is_user_logged_in === false){
        // // var_dump("is_user_logged_in",$is_user_logged_in);
        $result["public"] = true;
        // $result["accounts"] = [];
        // $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;
        // return  "<h2>Please login or register</h2>";

        // ob_start();
        // include 'views/balances.php';
        // return ob_clean();

      }else{
        $result["public"] = false;
      }
      //is admin

    try {
      $yohshow_api =  $this->yohshow_api;
      $isSuperAdmin = is_super_admin();
      $apiKey =  $this->yohshow_api_key;
      $apiSecret =  $this->yohshow_api_secret;
      $userType =  isset($_GET["userType"]) ? $_GET["userType"] : "";
      $accountId =  isset($_GET["accountId"]) ? $_GET["accountId"] : "";
      $accountIdFilter = $this->accountIdFilter;

      //markets
      $excludeCurrencies = $this->excludeCurrencies;
      $filteredMarkets = [];
      $filter["apiKey"] = $apiKey;


      $marketsFilter["filter"] = $filter;
      // $markets = (object)$yohshow_api->request("post","/markets",$marketsFilter);
      // print_r($markets);

//       $appToken = $markets->appToken;
//       $stableToken = $markets->stableToken;
// //      for ($i=0; $i < count($markets->markets) ; $i++) {
//         for ($i=0; $i < 80 ; $i++) {
//         # code...
//         $market = $markets->markets[$i];
//         // if(!in_array($market->sellCurrencySymbolBase,$excludeCurrencies)
//         // && !in_array($market->buyCurrencySymbolBase,$excludeCurrencies)
//         // ){
//           $filteredMarkets[] = $market;
//         // }
//       }
      




       $result['flag'] = true;

//         $result['markets'] = $filteredMarkets;
// //       $result['markets'] = $markets->markets;
// //       $result['filteredMarkets'] = $markets->markets;
// //       $result['filteredMarkets'] = $filteredMarkets;
// //       $result['markets'] = $markets->markets;
//        // $result['baseUrl'] = $baseUrl;
//        $result['appToken'] = $appToken;
//        $result['stableToken'] = $stableToken;

//        $result['appTokenSymbol'] = strtolower($appToken->symbol);
//        $result['stableTokenSymbol'] = strtolower($stableToken->symbol);


//      $result['flag'] = false;
     $result['markets'] = [];
      $result['filteredMarkets'] = [];
//      // $result['baseUrl'] = $baseUrl;
     $result['appToken'] = (object)[];
     $result['stableToken'] =(object)[];
//
     $result['appTokenSymbol'] = "";
     $result['stableTokenSymbol'] = "";
      
    } catch (\Throwable $error) {



      $result['flag'] = false;
      $result['markets'] = [];
      $result['filteredMarkets'] = [];
      // $result['baseUrl'] = $baseUrl;
      $result['appToken'] = (object)[];
      $result['stableToken'] =(object)[];

      $result['appTokenSymbol'] = "";
      $result['stableTokenSymbol'] = "";

      

        // return $result;      
    }

     
      // $test['test'] = "test";
        $result_json = json_encode($result) ;
      $GLOBALS['YOH_SHOW_LOCALS'] = $result_json;

        // return  "<h2>test 2</h2>";
        ob_start();
        include 'views/balances.php';
        // include_once('views/account.php');
        return ob_get_clean();

  }



  // methods

    

    public function markets($request){



      try {
        $csrf = $request->get_header('X-CSRF-Token');
        $user = $_SESSION["me"];
        $yohshow_api =  $this->yohshow_api;
        $yohshow_api_key =  $yohshow_api->yohshow_api_key;
        $yohshow_api_secret =  $yohshow_api->yohshow_api_secret;
        $excludeCurrencies =  $this->excludeCurrencies;
        $filter = array(
          'apiKey' => $yohshow_api_key,
        );
        $marketsFilter = array(
          'filter' => json_encode($filter),
        );
  
        $markets = (object) $this->yohshow_api->request("post","/markets",$marketsFilter);
        $appToken = $markets->appToken;
        $stableToken = $markets->stableToken;
  
        $filteredMarkets = [];
        for ($i=0; $i < count($markets->markets) ; $i++) { 
          $market = $markets->markets[$i];
          if(!in_array($market->sellCurrencySymbolBase,$excludeCurrencies)
          && !in_array($market->buyCurrencySymbolBase,$excludeCurrencies)
          ){
            array_push($filteredMarkets,$market);
          }
  
        }
  
        $result = [
          // markets:[],
          'flag' => true,
          'appToken' => $appToken,
          'stableToken' => $stableToken,
          'appTokenSymbol' => strtolower($appToken->symbol),
          'stableTokenSymbol' => strtolower($stableToken->symbol),
          'markets' => $markets->markets,
          'filteredMarkets' => $filteredMarkets,
          // 'baseUrl' => $this->baseUrl,
        ];

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          // markets:[],
          'flag' => false,
          'exchangeError' => true,
          'error' => $th,
          'appToken' => [],
          'stableToken' => [],
          'appTokenSymbol' => "",
          'stableTokenSymbol' => "",
          'markets' => [],
          'filteredMarkets' => [],
          // 'baseUrl' => $this->baseUrl,
        ];
      }
      return json_encode($result);
  
    }

    public function market($request){

      /*

      */



      try {
        $csrf = $request->get_header('X-CSRF-Token');
        $user = $_SESSION["me"];

        $currencyPair = $request['market'];

        // $signupLink = $this->baseUrl + '/register/markets/'+currencyPair;
        $signupLink = "";
        $promoterReferralCommission = $this->promoterReferralCommission;
        $minOwnerPromoterCommission = $this->minOwnerPromoterCommission;
        $exchangeFee = $this->exchangeFee;
        $minOwnerPromoterCommission = $minOwnerPromoterCommission + $promoterReferralCommission;
        $minPromoterCommission = $this->minPromoterCommission;
        $tokenComission = $this->minOwnerPromoterCommission ;
        $excludeCurrencies = $this->excludeCurrencies ;
        $paymentDecimal = $this->paymentDecimal ;
        $yohshow_api =  $this->yohshow_api;


        if($user){
          //NOTE TODO the following code should not be nesscary because the app
          // should confirm if someone is login in before this code get hit
          // if(!this.req.session.exchange){
          //   //must redirect to login or create account
          //   var redirect = '/cards/markets/'+currencyPair;
          //   return {
          //     flag:false,
          //     mustLogin:true,
          //     redirect:redirect,
          //   }
          // }
          //TODO figure out how share links work  
          // $shareLink = sails.config.custom.baseUrl + '/markets/'+currencyPair+"/referral/"+this.req.me.id;
          $shareLink = "";
          //TODO figure out what this limits
          // $hasBillingCard =  this.req.me.hasPrimeTrustBillingCard;
          $hasBillingCard = true;
          

        }else{
          $shareLink = $signupLink;
          $hasBillingCard =  false;
    
        }
        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
          
        $session = $_SESSION;
          $apiKey =  $yohshow_api->yohshow_api_key;
          
          $currencyPair = strtolower($currencyPair);  
          //console.log("view marekt currencyPair",currencyPair);
          $market = $this->get_market($currencyPair);
          $me = $market->me;
//          $loggedIn = $user ? true:false;
          $loggedIn = isset($_SESSION["exchange_wp_user_id"]) && $_SESSION["exchange_wp_user_id"] ? true : false  ;
          //console.log("view sails_environment",sails_environment);
          //console.log("view market.exist",market.exist);
          //console.log("view market.processing",market.processing);

          if(!$market->exist && !$market->processing){
            $market->openOrders = [];
            $market->tradeHistory = [];
            $buyCurrency = [];
            $sellCurrency = [];
            
          }else{
            // $market->openOrders = await sails.helpers.exchange.request("get","/market/orders/"+currencyPair+"/wait",{},session);
            // $market->tradeHistory = await sails.helpers.exchange.request("get","/market/orders/"+currencyPair+"/done",{},session);
            
            
            $buyCurrency = $market->buyCurrencyId;
            $sellCurrency = $market->sellCurrencyId;
            

          }
          $appTokenInfo = array(
            'apiKey' => $apiKey,
          );
  

          $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/".$apiKey,$appTokenInfo);
          //console.log("view appTokenResult ",appTokenResult );

          $appToken = $appTokenResult->appToken;
          $stableToken = $appTokenResult->stableToken;
          $paymentMethods = $appTokenResult->paymentMethods;
          $buyUnitsAction =  $buyCurrency->id == $stableToken->id  ? "stable": "units";
          $parentToken = $sellCurrency;
          $token = $sellCurrency;
          //current user info




          
        
          $result = [
            'flag' => true,
            'exchangeFee' => $exchangeFee,
            'excludeCurrencies' => $excludeCurrencies,
            'stableToken' => $stableToken,
            'paymentDecimal' => $paymentDecimal,
            'hasBillingCard' => $hasBillingCard,
            'minPromoterCommission' => $minPromoterCommission,
            'minOwnerPromoterCommission' => $minOwnerPromoterCommission,
            'tokenComission' => $tokenComission,
            'token' => $token,
            'parentToken' => $parentToken,
            'shareLink' => $shareLink,
            'signupLink' => $signupLink,
            'paymentMethods' => $paymentMethods,
            'loggedIn' => $loggedIn,
            'me' => $me,
            'market' => $market,
            'buyCurrency' => $buyCurrency,
            'sellCurrency' => $sellCurrency,
            'appToken' => $appToken,
            'buyUnitsAction' => $buyUnitsAction,
            'environment' => $sails_environment,
          ];
        } catch (\Throwable $th) {
          //throw $th;
          
          $result = [

            'flag' => false,
            'stableToken' => [],
            'exchangeFee' => $exchangeFee,
            'excludeCurrencies' => $excludeCurrencies,
            'hasBillingCard' => $hasBillingCard,
            'parentToken' => $parentToken,
            'shareLink' => $shareLink,
            'signupLink' => $signupLink,
            'exchangeError' => $th,
            'error' => $error,
            'paymentMethods' => [],
            'loggedIn' => false,
            'market' => [],
            'buyCurrency' => '',
            'appToken' => [],
            'buyUnitsAction' => $buyUnitsAction,
            'environment' => $sails_environment,
          ];
        }
        return json_encode($result);
    }

    public function place_order($request){

      try {
        $marketUpdate = array();
        $order = array();
        $market = $request['market'];
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $order['market'] = $market;
        $order['side'] = $request['side'];
        $order['volume'] = $request['volume'];
        $order['price'] = $request['price'];

        //define appCommissionFee
        $costInfo = (object) $this->safe_cost($request['side'] ,$request['price'] ,$request['volume']);
        $appCommissionFee =  $costInfo->costFee;

        $orderMeta = array(
          // 'ownerType' => "token",
          // 'ownerId' => $user->exchangeTokenId,
          'appComission' => $this->exchangeFee,
          'appCommissionFee' => $appCommissionFee,
        );

        $order['orderMeta'] = $orderMeta;
        $order = (object) $this->yohshow_api->request("post","/market/orders",$order);
        $flag = true;
        $msg = "Your order was placed successfully";



        if($order == false){
            $flag = false;
            $msg = "There was an error placing your order";
        }else{

        }
        
        
        if($flag){
          $marketUpdate = $this->get_market($market);
        }
        $marketUpdate['openOrders'] = (object) $this->yohshow_api->request("get","/market/orders/".$market."/wait",[]);
        $marketUpdate['tradeHistory'] = (object) $this->yohshow_api->request("get","/market/orders/".$market."/done",[]);


        $result = [
          'flag' => $flag,
          'market' => $marketUpdate,
          'order' => $order,
          'msg' => $msg,
        ];


      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => $flag,
          'market' => $marketUpdate,
          'order' => $order,
          'msg' => $msg,
        ];
      }
      return json_encode($result);
    }

    public function get_quote($request){

      /*

      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $tradeType = $request['tradeType'];
        $symbol = $request['symbol'];
        $yohshow_api =  $this->yohshow_api;

        $apiKey =  $yohshow_api->yohshow_api_key;


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";

        //TODO NOTE this code should not be neede because the user should be loggined before thsi code gets tran 
        // if (this.req.me) {

        //   //console.log("logged in");
        //   if(!this.req.session.exchange){
        //     var exchangeMeResult = await sails.helpers.exchange.me(this.req.session);
        //     //console.log('exchange login',exchangeMeResult );
        //     if(exchangeMeResult.session){
        //       this.req.session = exchangeMeResult.session;
        //     }else{
        //       //must login
        //     }
            
        //   }
    
    
        // }

      
        $quoteInfo = array(
          'tradeType' => $tradeType,
          'symbol' => $symbol,
          'apiKey' => $apiKey,
        );

        $quote = (object) $this->yohshow_api->request("post","/market/quote/",$quoteInfo);
        $flag = true;
        $msg = "Your quote was placed successfully";



        if($quote == false){
            $flag = false;
            $msg = "There was an error placing your quote";
        }else{

        }
        
        
        if($flag){
          return $quote;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            'flag' => false,
            'sellCurrency' => [],
            'stableToken' => [],
            'sellCurrency' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }



      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }

    

    public function save_checkout($request){

      /*
        just needs to take checkout request and pass it to api controller and return result

      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $checkout = $request['checkout'];
        
  

        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $checkoutInfo = array(
            "apiKey" => $this->yohshow_api_key,
          'checkout' => json_encode($checkout),
        );

        $checkout = (object) $this->yohshow_api->request("post","/checkout/save",$checkoutInfo);
        $flag = true;
        $msg = "Your checkout was placed successfully";



        if($checkout == false){
            $flag = false;
            $msg = "There was an error placing your checkout";
        }else{

        }
        
        
        if($flag){
            $result = $checkout;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            'flag' => false,
            'sellCurrency' => [],
            'stableToken' => [],
            'sellCurrency' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }



      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }


    
    public function pay_now($request){

      /*
        just needs to take checkout request and pass it to api controller and return result

        need to get checkout info //
        
        and create / load card in woocommcers.
        
        then this should rout to the chekcout page

      */

      try {


        $yohshow_api =  $this->yohshow_api;
        $apiKey =  $this->yohshow_api_key;

      


        $session = $_SESSION;
        $user = $_SESSION["me"];
        $checkoutToken = $request['checkoutToken'];

        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";

        $checkoutInfo = array(
          'checkoutToken' => $checkoutToken,
          'apiKey' => $apiKey,
        );

        $importCheckoutActions["addToCart"] = true;
        $importCheckoutResult = $this->import_checkout($checkoutInfo,$importCheckoutActions );
          $checkout_redirect = $importCheckoutResult["checkout_redirect"];
          $checkoutResult = $importCheckoutResult["checkoutResult"];


        //return checkout url 

        $checkout_url = wc_get_checkout_url();

        //add checkout page redirect to wc session data
        if(isset($checkout_redirect)){
          WC()->session->set('checkout_redirect',$checkout_redirect);
          //add action to extract redirect from cart add to ordert 
          add_action('woocommerce_add_order_item_meta', array( $this, 'hook_new_order_item_meta' ) , 10, 3);



        }




        $flag = $checkoutResult->success;
        $msg = "Your payNow was placed successfully";









        
        
        if($flag){
          // stableTokenLink:stableTokenLink,
          // checkoutToken:checkoutToken,
          // checkoutId:checkoutId,
          // displayPrice:displayPrice,
          // lineItem:lineItem,
          // transactionType:transactionType,
          // primeTrustForcePayment:primeTrustForcePayment,
          // externalPaymentMethods:externalPaymentMethods,
          // internalPaymentMethods:internalPaymentMethods,
          // externalBuyOk:externalBuyOk,
          // internalBuyOk:internalBuyOk,
          // checkoutAction:checkoutAction,
          // paymentMethods:paymentMethods,
          // checkout:checkout,
          // redirect:redirect,
          // stableToken:stableToken,
          // sellCurrency:sellCurrency,
          // isStableToken:isStableToken,
          // flag:true,
          // environment:sails_environment,

          $checkoutResult->checkout_url = $checkout_url;
          $result = $checkoutResult;
          // return $result = [
          //     'exchangeError' => false,
          //     // 'flag' => false,
          //     'flag' => true, // probably not correct and must be fslse
          //     'lineItem' => $checkout->line_items[0],
          //     'checkout' => $checkout,
          //     'sellCurrency' => $token,
          //     'stableToken' => $stableToken,
          //     'paymentMethods' => [],
          //     'redirect' => $checkout_redirect,
          //     'environment' => $sails_environment,
          //     "checkout_url" => $checkout_url,
          // ];
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
            "checkout_url" => $checkout_url,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }
    public function hook_new_order_item_meta($item_id, $values, $cart_item_key) {
      $session_var  = 'checkout_redirect';
      $session_data = WC()->session->get($session_var);
      if(!empty($session_data))
         wc_add_order_item_meta($item_id, $session_var, $session_data);
      // else
        //  error_log("no session data", 0);
   }
   public function import_checkout($checkoutInfo,$importActions){
       $woocommerce = WC();
       $woocommerce->session = new WC_Session_Handler();
       $woocommerce->session->init();
       $woocommerce->customer = new WC_Customer( );
       $woocommerce->cart = new WC_Cart();

       $apiKey =  $this->yohshow_api_key;
       $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/$apiKey",array("apiKey"=>$apiKey));
       $appId = $appTokenResult->appId;
       $appToken = $appTokenResult->appToken;
       $stableToken = $appTokenResult->stableToken;
       $yohshow_tokenize = new Yohshow_Tokenize( $this->yohshow_api );
      
      $checkoutResult = (object) $this->yohshow_api->request("post","/checkout/get",$checkoutInfo);
      if($checkoutResult->success){
          $checkout = $checkoutResult->checkout;
          $checkoutId = $checkoutResult->checkout->id;
          $checkout_order_key = "exchange_checkout_order_id_".$checkoutId;

          $checkout_order_key_order_id = get_option( $checkout_order_key );
           $mustCreateOrder = $checkout_order_key_order_id == false;
//          $mustCreateOrder = true;


          $checkout_redirect = $checkout->redirect;
          if(isset($importActions["createOrder"]) && $importActions["createOrder"]){
            global $woocommerce;

            // $address = array(
            //     'first_name' => '111Joe',
            //     'last_name'  => 'Conlin',
            //     'company'    => 'Speed Society',
            //     'email'      => 'joe@testing.com',
            //     'phone'      => '760-555-1212',
            //     'address_1'  => '123 Main st.',
            //     'address_2'  => '104',
            //     'city'       => 'San Diego',
            //     'state'      => 'Ca',
            //     'postcode'   => '92121',
            //     'country'    => 'US'
            // );

            if($mustCreateOrder){
              // Now we create the order
              $order = wc_create_order();
              $checkout_order_key_order_id = $order->get_id();
              $checkout_order_key_order_id_updated = update_option($checkout_order_key, $checkout_order_key_order_id);


            }else{
                // Now we create the order
                $order = wc_get_order($checkout_order_key_order_id);
            }

            $order->update_meta_data( 'exchange_checkout_id', $checkoutId );
            

            // The add_product() function below is located in /plugins/woocommerce/includes/abstracts/abstract_wc_order.php
            // $order->add_product( get_product('275962'), 1); // This is an existing SIMPLE product
            // $order->set_address( $address, 'billing' );
            //
             
          }


          for ($i=0; $i < count($checkout->line_items); $i++) {
              $line_item = $checkout->line_items[$i];
              $sellCurrencyId = $line_item->sellCurrencyId;
              $tokenId = $line_item->tokenId;
              $type = $line_item->type;
              $title = $line_item->title;
              $action = $line_item->action;
              $price = $line_item->price;
              $frequency = $line_item->frequency;
              $portfolioId = $line_item->portfolioId;
              $quantity = $line_item->quantity;
              $fulfillable_quantity = $line_item->fulfillable_quantity;
              $line_item_total = $line_item->line_item_total;
              $line_item_sub_total = $line_item->line_item_sub_total;
              $shop_fee = $line_item->shop_fee;
              $external_fee = $line_item->external_fee;
              $total_fee = $line_item->total_fee;

              
              
              $tokenInfo = array();
              if($action == "payment"){
                $getTokenId = $tokenId;
              }else{
                $getTokenId = isset($sellCurrencyId)  ? $sellCurrencyId : $stableToken->id ;
              }
              $tokenResult = (object) $this->yohshow_api->request("get","/tokens/$getTokenId",$tokenInfo);
              $token = $tokenResult->token;

              //if this is a table token, actions should be issueStableTokens
              if($action == "payment"){
                $token->action = $action;
                $token->price = $stableToken->price;
              }else if($action == "sell" || $action == "sellUnits" || $action == "redeem"){
                $token->action = "sell";
                $token->price = $price;
              }else if($token->id == $stableToken->id){
                $token->action = "issueStableTokens";
              }else{
                $token->action = "invest";
              }
              

              $updatePrice = true;
              $tokenProduct = $yohshow_tokenize->create_product($token, $updatePrice );
              $product_id = $tokenProduct->get_id();


               if( isset($importActions['addToCart']) && $importActions['addToCart'] && $token->action !== "sell" ){
//              if( isset($importActions['addToCart']) && $importActions['addToCart']  ){
                $woocommerce->cart->add_to_cart( $product_id, $quantity);
              }

              if(isset($importActions["createOrder"]) && $importActions["createOrder"]){
                $order->add_product( wc_get_product($product_id), $quantity); // This is an existing SIMPLE product
              
              }



              


              

              //get /form exchange product key //
              //search for product by exchange product key //
              //if product doesnt exist //
              //create product //
              //update product price//
              //add product to cart with correct quanity //
          }
          if(isset($importActions["createOrder"]) && $importActions["createOrder"]){
            $order->calculate_totals();
            // $order->update_status("Completed", 'Imported order', TRUE);  
            $order->update_status("Processing", 'Imported order', TRUE);  
          }
      }

      $result["checkout_redirect"] =  $checkout_redirect;
//      $result["products"] =  $products;
//      $result["product_ids"] =  $product_ids;
      $result["success"] =  $checkoutResult->success;
       $result["checkoutResult"] =  $checkoutResult;
      $result["order_id"] =  isset($importActions["createOrder"]) && $importActions["createOrder"] ? $checkout_order_key_order_id : $importActions["creatOrder"];

      return $result;
      

   }

    

    public function update_checkout_payment_method($request){

      /*
        just needs to take checkout request and pass it to api controller and return result

      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $checkoutId = $request['checkoutId'];
        $paymentMethod = $request['paymentMethod'];


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $updatePaymentMethodInfo = array(
          'checkoutId' => $checkoutId,
          'paymentMethod' => $paymentMethod,
        );

        $updatePaymentMethod = (object) $this->yohshow_api->request("post","/update-checkout-payment-method",$updatePaymentMethodInfo);
        $flag = true;
        $msg = "Your updatePaymentMethod was placed successfully";



        if($updatePaymentMethod == false){
            $flag = false;
            $msg = "There was an error placing your updatePaymentMethod";
        }else{

        }
        
        
        if($flag){
          return $updatePaymentMethod;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }

    public function pay_checkout($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $apiKey =  $this->yohshow_api_key;
        $apiSecret =  $this->yohshow_api_secret;


        $checkoutId = $request['checkoutId'];
        $challengeId = $request['challengeId'];
        $forterTokenCookie = $request['forterTokenCookie'];
        $contributionId = $request['contributionId'];
        $fundsTransferMethodId = $request['fundsTransferMethodId'];


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";

        $checkoutInfo = array(
          'checkoutId' => $checkoutId,
          'apiKey' => $apiKey,
        );


        $importCheckoutActions["addToCart"] = false;
        $importCheckoutActions["createOrder"] = true;
        $importCheckoutResult = $this->import_checkout($checkoutInfo,$importCheckoutActions );
        $externalOrderId = $importCheckoutResult["order_id"];
        $order = new WC_Order($externalOrderId);


        

        //checkt to see if there is an order id for the checkout id
        //if not
          //create products for line items
          //create order for checkout
          //save order id under site options for exchange checkout id
        //send order id as external order id



        $payCheckoutInfo = array(
          'checkoutId' => $checkoutId,
          'challengeId' => $challengeId,
          'forterTokenCookie' => $forterTokenCookie,
          'contributionId' => $contributionId,
          'fundsTransferMethodId' => $fundsTransferMethodId,
          'externalOrderId' => $externalOrderId,
          'apiKey' => $apiKey,
          'apiSecret' => $apiSecret,
        );

        $payCheckout = (object) $this->yohshow_api->request("post","/checkout/pay",$payCheckoutInfo);
        $flag = true;
        $msg = "Your payCheckout was placed successfully";



        if($payCheckout == false){
            $flag = false;
            $msg = "There was an error placing your payCheckout";
        }else{

        }
        
        
        if($flag){
          $order->update_meta_data( 'exchange_order_fullfiled', true );
          $order->update_status("Completed", 'Fullfiled exchange order', TRUE);  

          return $payCheckout;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }

    public function checkout($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];


        $checkoutId = $request['checkoutId'];


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $checkoutInfo = array(
          'checkoutId' => $checkoutId,
        );

        $checkout = (object) $this->yohshow_api->request("post","/checkout",$checkoutInfo);
        $flag = true;
        $msg = "Your checkout was placed successfully";



        if($checkout == false){
            $flag = false;
            $msg = "There was an error placing your checkout";
        }else{

        }
        
        
        if($flag){
          $result = $checkout;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }


    public function pause_subscription($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      $post = $request->get_params();

      $responseJson = $this->exchange_request("post","/subscriptions/pause",$inputs,$request);
      return $responseJson;


    }


    public function exchange_request($method,$endpoint,$inputs,$request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];

        $requestInfo = array( );

        for ($i=0; $i < count($inputs); $i++) { 
          $label = $inputs[$i];
          $requestInfo[$label] = $request[$label];
        }


        $request = (object) $this->yohshow_api->request($method,$endpoint,$requestInfo);
        $flag = true;
        $msg = "Your request was placed successfully";

        if($request == false){
            $flag = false;
            $msg = "There was an error placing your request";
        }else{

        }
        
        
        if($flag){
          $result = $request;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => "",
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => "",
        ];


      }
      return json_encode($result);
    }
    

    public function enqueue_scripts(){
      $this->enqueue_scripts_folder("assets/dependencies");
      $this->enqueue_scripts_folder("assets/dependencies/exchange");
      $this->enqueue_scripts_folder("assets/dependencies/exchange/chart-org");
      $this->enqueue_scripts_folder("assets/dependencies/exchange/lightweight-chart");
      $this->enqueue_scripts_folder("assets/js");
      $this->enqueue_scripts_folder("assets/js/components");
      $this->enqueue_scripts_folder("assets/js/components/exchange");
      $this->enqueue_scripts_folder("assets/js/components/google");
      $this->enqueue_scripts_folder("assets/js/components/tokens");
      $this->enqueue_scripts_folder("assets/js/components/transactions");

      // $this->enqueue_scripts_folder("assets/js/components/folder"); // in case you want a to put code in a folder
      $this->enqueue_scripts_folder("assets/js/pages");
  }




  public function enqueue_scripts_folder($path){
      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          //echo '<pre>'; 
          //// var_dump("file_url",$file_url);
          //echo '</pre>';
          // exit;
          wp_enqueue_script( $file_name, $file_url,array("jquery"));
      }
      // // var_dump("$path/*.css" );

      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          // echo '<pre>'; 
          // // var_dump("file_url",$file_url);
          // echo '</pre>';
          // exit;
          wp_enqueue_style( $file_name, $file_url);
      }
      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          // echo '<pre>'; 
          // // var_dump("file_url",$file_url);
          // echo '</pre>';
          // exit;
          wp_enqueue_style( $file_name, $file_url,array("jquery"));
      }
  }

    

}