/**
 * <open-orders-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

Vue.component('openOrdersTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'orders',// « orders
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
      formatType: undefined,
      formattedTimestamp: '',
      interval: undefined,
      totalBuy: 0,
      totalSell: 0,
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 open-orders">
    <div class="col-md-12">
        <table class="table table-striped" align="center">
            <thead>
                <tr>
                <th>Market</th>
                <th>Type</th>
                <th>Price/Share</th>
                <th>Amount</th>
                <th>Remaining</th>
                <th>Executed</th>
                <th>Created</th>
                <th></th>
                </tr>
            </thead>
            <tbody>
            <tr v-for="order in orders" v-if="order.state == 'wait' "  :id="order.id">
                <td >
                    {{order.market}}
                </td>
                <td >
                    <span :class="order.side">{{order.side}}</span>
                </td>
                <td >
                    {{order.price}}
                </td>
                <td >
                    {{order.originVolume}}
                </td>
                <td >
                    {{order.remainingVolume}}
                </td>
                <td >
                    {{order.executedVolume}}
                </td>
                <td >
                  {{order.createdAt}} <br/>
                </td>
                <td >
                    <a class="cancel" :href="order.id">Cancel</a>
                </td>
            </tr>
            </tbody>
        </table>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
    //   console.log("orders",this.orders);
  },
  mounted: function() {
      console.log("mounted orders",this.orders);
      this.bindUIActions();


  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    bindUIActions: function() {
      var Orders = this;
      $(".cancel").on("click", function(event) {
         //set action
         event.preventDefault();
         var id = $(event.target).attr("href");
         Orders.cancel(id);
       });
    },
    cancel: async function (id) {
        var page = this;
        console.log("cancel order",id);
        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
              url: "/markets/orders/cancel",
              data: {orderId:id}, // serializes the form's elements.
              // headers:apiRequestHeader,
              success: function(data, textStatus, request)
              {
                  console.log('got the data!!!',data); // show response from the php script.
                  if(data.flag){
                      $("#"+id).hide();
                  }
                //   var balances = data.balances;
                //   page.render(balances);
  
              }
            });
        // window.location = '/';
      },

  }

});
