jQuery(function() {
    var vm = new Vue({ 
        el: '.yoh-balances',
      //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
      //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
      //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
      data: {
        //…
        paymentMethods:[],
        balances:[],
        refreshUrl:'',
        isBillingEnabled: false,
    
        hasBillingCard: false,
    
        // Syncing/loading states for this page.
        syncingOpenCheckout: false,
        syncingUpdateCard: false,
        syncingRemoveCard: false,
        // Form data
        formData: { 
          transferType: "internal"
         },
    
        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },
    
        // Syncing / loading state
        syncing: false,
    
        // Server error state
        cloudError: '',
    
        // Success state when form has been submitted
        cloudSuccess: false,
      },
    
      //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
      //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
      //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
      beforeMount: function() {
        // Attach any initial data from the server.
        _.extend(this, YOH_SHOW_LOCALS);
        this.refreshUrl = this.baseUrl;
      },
      mounted: async function() {
        this.refresh();
        var Balances = this;
        $(".deposit").on("click", function(event) {
          var currency = $(event.target).attr("href");
          console.log("currency",currency);
          Balances.confirmDeposit(currency);
       });
       $(".withdraw").on("click", function(event) {
            var currency = $(event.target).attr("href");
            console.log("currency",currency);
            Balances.confirmWithdraw(currency);
        });
        $(".send").on("click", function(event) {
            var currency = $(event.target).attr("href");
            console.log("currency",currency);
            Balances.confirmSend(currency);
        });
    
      },
    
      //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
      //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
      //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
      methods: {
        refresh: async function() {
          var page = this;
          $.ajax({
                type: "GET",
                url: this.refreshUrl+"/api/balances",
                data: {}, // serializes the form's elements.
                success: function(data, textStatus, request)
                {
                    console.log('got the data!!!',data); // show response from the php script.
                    var balances = data.balances;
                    page.render(balances);
    
                }
              });
          // window.location = '/';
        },
        confirmSend: async function(currency) {
          var Balances = this;
          $(".modal .action").html("send");
          $(".modal .currency").html(currency);
          $(".modal .withdraw-btn, .modal .deposit-btn").hide();
          $(".modal .send-btn").show();
          var accountId = $("."+currency +" .accountId").val();
          this.formData.fromAccountId = accountId;
          this.formData.currency = currency;
    
          Balances.withdrawMax(currency);
          this.formData.confirm = false;
          $(".transferSend").off("click").on("click", function(event) {
            Balances.send(currency);
          });
        },
        confirmDeposit: async function(currency) {
          var Balances = this;
          $(".modal .action").html("deposit");
          $(".modal .currency").html(currency);
          $(".modal .withdraw-btn").hide();
          $(".modal .withdraw-btn, .modal .send-btn").hide();
          $(".modal .deposit-btn").show();
          $(".confirmDeposit").off("click").on("click", function(event) {
            console.log("confirm deposit cliked");
            Balances.depositAddress(currency);
          });
        },
        confirmWithdraw: async function(currency) {
          var Balances = this;
          $(".modal .action").html("withdraw");
          $(".modal .currency").html(currency);
          $(".modal .deposit-btn, .modal .send-btn").hide();
    
          $(".modal .withdraw-btn").show();
          Balances.withdrawMax(currency);
          $(".transferWithdraw").off("click").on("click", function(event) {
            Balances.withdraw(currency);
          });
        },
        withdrawMax: async function(currency) {
          var Balances = this;
          var balance = $("."+currency +" .balance").html();
          var locked = $("."+currency +" .locked").html();
          balance =  parseFloat(balance);
          locked =  parseFloat(locked);
          // var withdrawMax = balance - locked;
          var withdrawMax = balance;
          console.log("balance",balance);
          console.log("locked",locked);
          console.log("withdrawMax",withdrawMax);
          $(".withdrawMaxSpan").html(withdrawMax);
          $(".withdrawMax").off("click").on("click", function(event) {
            console.log("withdrawMax",withdrawMax);
            $("#withdrawAmount").val(withdrawMax);
            Balances.formData.amount = withdrawMax;
            console.log("withdrawMax Balances.formData.amount",Balances.formData.amount);
    
          });
        },
        send: async function(currency){
            console.log("send " + currency);
            var Balances = this;
            var send_data = {};

           send_data.withdrawAmount = Balances.formData.amount;
           send_data.amount = Balances.formData.amount;
           send_data.toPayment =  Balances.formData.toPayment;
           send_data.fromAccountId = Balances.formData.fromAccountId;
           send_data.transferType = "exchange";
           
           send_data.note = $("#note").val();
           send_data.toPaymentMethod = Balances.formData.toPaymentMethod;
           console.log('send send_data',send_data);

            
            
            // var csrf = await CSRF.token();
            // console.log('csrf',csrf);
            console.log('currency',currency);
            // var apiRequestHeader = {
            //   'X-CSRF-Token':csrf._csrf,
            //     // 'cookie':cookie
            // };
            $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/wp-json/yohshow/api/v1/balances/send',
              data: send_data, // serializes the form's elements.
              // headers:apiRequestHeader,
              success: function(data, textStatus, request)
              {
                  data = JSON.parse(data);

                  console.log('got balance the data!!!',data); // show response from the php script.
                  if(data.flag){
                    location.reload();
                    
                  }
                //   var balances = data.balances;
                //   page.render(balances);
  
              }
            });


          
        },
        withdraw: async function(currency){
          console.log("withdraw " + currency);
    
          var Balances = this;
          var withdrawAmount = $("#withdrawAmount").val();
          var withdrawAddress = $("#withdrawAddress").val();
          
          // var csrf = await CSRF.token();
          // console.log('csrf',csrf);
          console.log('currency',currency);
          // var apiRequestHeader = {
          //   'X-CSRF-Token':csrf._csrf,
          //     // 'cookie':cookie
          // };
         return $.ajax({
          method: 'post',
          url: '/balances/withdraw',
          data: {currency:currency,address:withdrawAddress,amount:withdrawAmount},
          // headers: apiRequestHeader
          }, function (resData, jwres) {
          console.log('resData',resData); // => e.g. 403
          window.location.href = "/balances";
          // $("#transfer .withdraw").html(address.address);
          // if(resData.flag){
          //   // Balances.refresh(resData.market);
          // }
    
    
          if (jwres.error) {
            console.log(jwres.statusCode); // => e.g. 403
            return;
          }
        
          console.log(jwres.statusCode); // => e.g. 200
        
        });
        
      },
        depositAddress: async function(currency){
          console.log("depositAddress " + currency);
    
          var Balances = this;
          
          // var csrf = await CSRF.token();
          // console.log('csrf',csrf);
          console.log('currency',currency);
          // var apiRequestHeader = {
          //   'X-CSRF-Token':csrf._csrf,
          //     // 'cookie':cookie
          // };
         return $.ajax({
          method: 'get',
          url: '/balances/address',
          data: {currency:currency},
          // headers: apiRequestHeader
        }, function (resData, jwres) {
          var address = resData.address;
          console.log('balance',address); // => e.g. 403
          $("#transfer .depositAddress").html(address.address);
          // if(resData.flag){
          //   // Balances.refresh(resData.market);
          // }
    
    
          if (jwres.error) {
            console.log(jwres.statusCode); // => e.g. 403
            return;
          }
        
          console.log(jwres.statusCode); // => e.g. 200
        
        });
        
      },
        render: async function(balances) {
          $.each( balances, function( id, market ) {
            console.log( id + ": " + market );
            console.log( $("#"+id).length );
            var ticker = market.ticker;
            /*
              avg_price: "0.0"
              buy: "0.0"
              high: "0.0"
              last: "0.0"
              low: "0.0"
              open: "0.0"
              price_change_percent: "+0.00%"
              sell: "0.0"
              vol: "0.0"
              volume: "0.0"
            */
          //  $(".tickers").append(
          //     $("<div id='"+id+"'>")
          //       .append("<h3 class='avg_price'>"+ticker.avg_price+"</h3>")
          //   );
    
            // var tr = $("<tr id='"+id+"'>");
            // $("<td class='avg_price'>"+ticker.avg_price+"</td>")
            // console.log("tr",tr.html());
            // $(".tickers").append(tr);
            // console.log( $(".tickers").length, "tickets length" );
    
          });
        },
        listen: async function() {
          
          // window.location = '/';
        },
        //transer/send 
        changeTransferType: async function(e) {
          var type = $("#transferType").val();
          // var isFreeze = $(e.target).hasClass("freeze");
          // var isClose = $(e.target).hasClass("close");
          // var isView = $(e.target).hasClass("view");
          // var isOpen = $(e.target).hasClass("open");
          $(".nav-transfers .transferType").hide();
          $(".nav-transfers ."+type).show();
        },
        submittedForm: async function() {
          console.log("submittedForm");
          window.location = '/balances';
        },
    
        handleParsingForm: async function() {
          // Clear out any pre-existing error messages.
          console.log("handleParsingForm");
          this.formErrors = {};
    
          var argins = this.formData;
          var currency = argins.currency;
    
          var balance = $("."+currency +" .balance").html();
          balance = parseFloat(balance);
          console.log("balance",balance);
          
          if(!argins.amount || argins.amount == 0 ) {
            this.formErrors.amount = true;
          }
          if(!argins.toPayment) {
            this.formErrors.toPayment = true;
          }
          if(argins.amount > balance){
            this.formErrors.tooMuch = true;
    
            console.log("balance too much ",argins.amount,balance);
          }
          console.log("argins.toPayment",argins.toPayment);
    
          var validToPayment = this.validPhoneOrEmail(argins.toPayment);
          console.log("validToPayment",validToPayment);
          if(!validToPayment){
            this.formErrors.toPayment = true;
          }
    
          // If there were any issues, they've already now been communicated to the user,
          // so simply return undefined.  (This signifies that the submission should be
          // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }else{
            if(!argins.confirm){
              $('#confirmModal').modal("show");
              $('#transferModal').modal("hide");
              this.formData.confirm = true;
    
            }
          }
          var sendResult = await this.send(currency);
          console.log("sendResult",sendResult);
          return argins;
        },
        validPhoneOrEmail: function(phoneOrEmail){
          var validEmail = false;
          var validPhone = false;
          //validate email
          phoneOrEmail =  phoneOrEmail.toLowerCase();
          var emailReg = /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/i;
          if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
          {
            console.log('Please enter a valid email address.');
            validEmail = false;
          }else{
            validEmail = true;
            this.formData.toPaymentMethod = "email";
            console.log('valid email address.');
    
          }
    
          //validate phone
          var intRegex = /[0-9 -()+]+$/;
          if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
          {
            console.log('Please enter a valid phone number.');
            validPhone = false;
          }else{
            validPhone = true;
            this.formData.toPaymentMethod = "phone";
            console.log('valid phone.');
          }
    
          if(!validPhone && !validEmail){
            this.formData.toPaymentMethod = undefined;
            return false;
          }else{
            // this.formData.fromAccountId = this.formData.fromSpendAccountId;
            return true;
          }
          
        },
      }
    });
    
    // vm = Object.assign(vm, YOH_SHOW_LOCALS);
    // vm.paymentMethods = [];
    // console.log("vm",vm);
    // console.log("vm.paymentMethods",vm.paymentMethods);
    
});
