<div id="account" class="exchange-pg exchange-wallets yoh-account bootstrap" v-cloak>
  <card-nav active-tab="account"></card-nav>
  <div class="tab-content" id="nav-tabContent">

    <div class="tab-pane fade show active nav-account" id="nav-activity" role="tabpanel" aria-labelledby="nav-activity-tab">
        <!-- add 
            account activity
            //date
            //description
            //account type
            //category/ transaction type
            //ammount
            //account select
          -->
        <div class="row" >
          <div class="col-md-6" >
            <h3>Account Activity</h3>
              <!-- {{account}} -->
                <!-- {{transactions}} -->

            
          </div>
          <div class="col-md-6 text-right" >
            <select id="accountId" v-model.trim="formData.accountId" @change="changeAccountId" class="form-control title accountId" >
              <option v-for="account in accounts" :value="account.id" v-if="accountIdFilter.includes(account.bankAccountId)
                    && account.ownerType == 'token'
                    && account.currency.id == stableToken.id"> {{account.wallet.name }} ({{account.name}}) - ${{account.spendingBalance.toFixed(2)}}</option>
            </select>
          </div>
        </div>
        <table class="table">
          <thead>
            <tr>
              <th scope="col">Date</th>
              <th scope="col">Description</th>
              <th scope="col">Account</th>
              <th scope="col">Category</th>
              <th scope="col">Amount</th>
            </tr>
          </thead>
          <tbody>
    
            <tr v-for="transaction in transactions" class="">
                <!-- {{transaction}} -->
                <td class="createdAt"><js-timestamp :at="transaction.createdAt" ></js-timestamp> </td>
                <td class="note">{{transaction.note}}</td>
                <td class="type">{{account.name}}</td>
                <td class="category">{{transaction.type}}</td>
                <td v-bind:class="[transaction.toAccount == account.id ? 'totalAmount text-success' : 'totalAmount text-danger']" >
                  <span v-if="transaction.fromAccount == account.id" >-</span>
                  {{transaction.totalAmount.toFixed(2)}}
                </td>
            </tr>
          </tbody>
        </table>
    </div>

    
  </div>
  

</div>
<script>
  <?php
        global $YOH_SHOW_LOCALS;
        echo "const YOH_SHOW_LOCALS = JSON.parse('$YOH_SHOW_LOCALS'); "; 
  ?>
   console.log("test YOH_SHOW_LOCALS",YOH_SHOW_LOCALS);
</script>
