<!-- <div id="test">

    <h2>Test</h2>
    <ajax-button type="submit" :syncing="syncing" class="btn btn-sm btn-outline-info getBalances">Refresh</ajax-button>

</div> -->
<?php
$welcomeMessage = "{}";

?>
<div id="homepage" v-cloak>

  <h1>{{refreshUrl}}</h1>
  <ajax-button type="submit" :syncing="syncing" class="btn btn-sm btn-outline-info getBalances">Refresh</ajax-button>
  <button autofocus @click="clickButton()">Click me</button>
</div>

<script>
  SAILS_LOCALS = <?= $welcomeMessage ?> ;
  var vm = new Vue({ 
    el: '#homepage',
    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: {
      //…
      refreshUrl:'',
      isBillingEnabled: false,

      hasBillingCard: false,

      // Syncing/loading states for this page.
      syncingOpenCheckout: false,
      syncingUpdateCard: false,
      syncingRemoveCard: false,
      // Form data
      formData: { 
        transferType: "internal"
      },

      // For tracking client-side validation errors in our form.
      // > Has property set to `true` for each invalid property in `formData`.
      formErrors: { /* … */ },

      // Syncing / loading state
      syncing: false,

      // Server error state
      cloudError: '',

      // Success state when form has been submitted
      cloudSuccess: false,
    },

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
      // Attach any initial data from the server.
      _.extend(this, SAILS_LOCALS);
      this.refreshUrl = this.baseUrl;
    },
    mounted: async function() {
      this.refresh();
      var Balances = this;
      $(".deposit").on("click", function(event) {
        var currency = $(event.target).attr("href");
        console.log("currency",currency);
        Balances.confirmDeposit(currency);
    });
    $(".withdraw").on("click", function(event) {
          var currency = $(event.target).attr("href");
          console.log("currency",currency);
          Balances.confirmWithdraw(currency);
      });
      $(".send").on("click", function(event) {
          var currency = $(event.target).attr("href");
          console.log("currency",currency);
          Balances.confirmSend(currency);
      });

    },

    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      refresh: async function() {
        var page = this;
        $.ajax({
              type: "GET",
              url: this.refreshUrl+"/api/balances",
              data: {}, // serializes the form's elements.
              success: function(data, textStatus, request)
              {
                  console.log('got the data!!!',data); // show response from the php script.
                  var balances = data.balances;
                  page.render(balances);

              }
            });
        // window.location = '/';
      },
      confirmSend: async function(currency) {
        var Balances = this;
        $(".modal .action").html("send");
        $(".modal .currency").html(currency);
        $(".modal .withdraw-btn, .modal .deposit-btn").hide();
        $(".modal .send-btn").show();
        var balanceId = $("."+currency +" .balanceId").val();
        this.formData.fromBalanceId = balanceId;
        this.formData.currency = currency;

        Balances.withdrawMax(currency);
        this.formData.confirm = false;
        $(".transferSend").off("click").on("click", function(event) {
          Balances.send(currency);
        });
      },
      confirmDeposit: async function(currency) {
        var Balances = this;
        $(".modal .action").html("deposit");
        $(".modal .currency").html(currency);
        $(".modal .withdraw-btn").hide();
        $(".modal .withdraw-btn, .modal .send-btn").hide();
        $(".modal .deposit-btn").show();
        $(".confirmDeposit").off("click").on("click", function(event) {
          console.log("confirm deposit cliked");
          Balances.depositAddress(currency);
        });
      },
      confirmWithdraw: async function(currency) {
        var Balances = this;
        $(".modal .action").html("withdraw");
        $(".modal .currency").html(currency);
        $(".modal .deposit-btn, .modal .send-btn").hide();

        $(".modal .withdraw-btn").show();
        Balances.withdrawMax(currency);
        $(".transferWithdraw").off("click").on("click", function(event) {
          Balances.withdraw(currency);
        });
      },
      withdrawMax: async function(currency) {
        var Balances = this;
        var balance = $("."+currency +" .balance").html();
        var locked = $("."+currency +" .locked").html();
        balance =  parseFloat(balance);
        locked =  parseFloat(locked);
        // var withdrawMax = balance - locked;
        var withdrawMax = balance;
        console.log("balance",balance);
        console.log("locked",locked);
        console.log("withdrawMax",withdrawMax);
        $(".withdrawMaxSpan").html(withdrawMax);
        $(".withdrawMax").off("click").on("click", function(event) {
          console.log("withdrawMax",withdrawMax);
          $("#withdrawAmount").val(withdrawMax);
          Balances.formData.amount = withdrawMax;
          console.log("withdrawMax Balances.formData.amount",Balances.formData.amount);

        });
      },
      send: async function(currency){
          console.log("send " + currency);
          var Balances = this;
          var withdrawAmount = $("#withdrawAmount").val();
          var toPayment = $("#toPayment").val();
          var balanceId = $("#balanceId").val();
          var note = $("#note").val();
          var toPaymentMethod = $("#toPaymentMethod").val();
          
          
          var csrf = await CSRF.token();
          console.log('csrf',csrf);
          console.log('currency',currency);
          var apiRequestHeader = {
            'X-CSRF-Token':csrf._csrf,
              // 'cookie':cookie
          };
          return io.socket.request({
            method: 'post',
            url: '/balances/send',
            data: {
              fromBalanceId:balanceId,
              note:note,
              toPayment:toPayment,
              amount:withdrawAmount
            },
            headers: apiRequestHeader
            }, function (resData, jwres) {
            console.log('resData',resData); // => e.g. 403
            window.location.href = "/balances";
            // $("#transfer .send").html(address.address);
            // if(resData.flag){
            //   // Balances.refresh(resData.market);
            // }


            if (jwres.error) {
              console.log(jwres.statusCode); // => e.g. 403
              return;
            }
          
            console.log(jwres.statusCode); // => e.g. 200
          
          });
        
      },
      withdraw: async function(currency){
        console.log("withdraw " + currency);

        var Balances = this;
        var withdrawAmount = $("#withdrawAmount").val();
        var withdrawAddress = $("#withdrawAddress").val();
        
        var csrf = await CSRF.token();
        console.log('csrf',csrf);
        console.log('currency',currency);
        var apiRequestHeader = {
          'X-CSRF-Token':csrf._csrf,
            // 'cookie':cookie
        };
      return io.socket.request({
        method: 'post',
        url: '/balances/withdraw',
        data: {currency:currency,address:withdrawAddress,amount:withdrawAmount},
        headers: apiRequestHeader
        }, function (resData, jwres) {
        console.log('resData',resData); // => e.g. 403
        window.location.href = "/balances";
        // $("#transfer .withdraw").html(address.address);
        // if(resData.flag){
        //   // Balances.refresh(resData.market);
        // }


        if (jwres.error) {
          console.log(jwres.statusCode); // => e.g. 403
          return;
        }
      
        console.log(jwres.statusCode); // => e.g. 200
      
      });
      
    },
      depositAddress: async function(currency){
        console.log("depositAddress " + currency);

        var Balances = this;
        
        var csrf = await CSRF.token();
        console.log('csrf',csrf);
        console.log('currency',currency);
        var apiRequestHeader = {
          'X-CSRF-Token':csrf._csrf,
            // 'cookie':cookie
        };
      return io.socket.request({
        method: 'get',
        url: '/balances/address',
        data: {currency:currency},
        headers: apiRequestHeader
      }, function (resData, jwres) {
        var address = resData.address;
        console.log('balance',address); // => e.g. 403
        $("#transfer .depositAddress").html(address.address);
        // if(resData.flag){
        //   // Balances.refresh(resData.market);
        // }


        if (jwres.error) {
          console.log(jwres.statusCode); // => e.g. 403
          return;
        }
      
        console.log(jwres.statusCode); // => e.g. 200
      
      });
      
    },
      render: async function(balances) {
        $.each( balances, function( id, market ) {
          console.log( id + ": " + market );
          console.log( $("#"+id).length );
          var ticker = market.ticker;
          /*
            avg_price: "0.0"
            buy: "0.0"
            high: "0.0"
            last: "0.0"
            low: "0.0"
            open: "0.0"
            price_change_percent: "+0.00%"
            sell: "0.0"
            vol: "0.0"
            volume: "0.0"
          */
        //  $(".tickers").append(
        //     $("<div id='"+id+"'>")
        //       .append("<h3 class='avg_price'>"+ticker.avg_price+"</h3>")
        //   );

          // var tr = $("<tr id='"+id+"'>");
          // $("<td class='avg_price'>"+ticker.avg_price+"</td>")
          // console.log("tr",tr.html());
          // $(".tickers").append(tr);
          // console.log( $(".tickers").length, "tickets length" );

        });
      },
      listen: async function() {
        
        // window.location = '/';
      },
      //transer/send 
      changeTransferType: async function(e) {
        var type = $("#transferType").val();
        // var isFreeze = $(e.target).hasClass("freeze");
        // var isClose = $(e.target).hasClass("close");
        // var isView = $(e.target).hasClass("view");
        // var isOpen = $(e.target).hasClass("open");
        $(".nav-transfers .transferType").hide();
        $(".nav-transfers ."+type).show();
      },
      submittedForm: async function() {
        console.log("submittedForm");
        window.location = '/balances';
      },

      handleParsingForm: function() {
        // Clear out any pre-existing error messages.
        console.log("handleParsingForm");
        this.formErrors = {};

        var argins = this.formData;
        var currency = argins.currency;

        var balance = $("."+currency +" .balance").html();
        balance = parseFloat(balance);
        console.log("balance",balance);
        
        if(!argins.amount || argins.amount == 0 ) {
          this.formErrors.amount = true;
        }
        if(!argins.toPayment) {
          this.formErrors.toPayment = true;
        }
        if(argins.amount > balance){
          this.formErrors.tooMuch = true;

          console.log("balance too much ",argins.amount,balance);
        }
        console.log("argins.toPayment",argins.toPayment);

        var validToPayment = this.validPhoneOrEmail(argins.toPayment);
        console.log("validToPayment",validToPayment);
        if(!validToPayment){
          this.formErrors.toPayment = true;
        }

        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }else{
          if(!argins.confirm){
            $('#confirmModal').modal("show");
            $('#transferModal').modal("hide");
            this.formData.confirm = true;

          }
        }

        return argins;
      },
      validPhoneOrEmail: function(phoneOrEmail){
        var validEmail = false;
        var validPhone = false;
        //validate email
        phoneOrEmail =  phoneOrEmail.toLowerCase();
        var emailReg = /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/i;
        if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
        {
          console.log('Please enter a valid email address.');
          validEmail = false;
        }else{
          validEmail = true;
          this.formData.toPaymentMethod = "email";
          console.log('valid email address.');

        }

        //validate phone
        var intRegex = /[0-9 -()+]+$/;
        if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
        {
          console.log('Please enter a valid phone number.');
          validPhone = false;
        }else{
          validPhone = true;
          this.formData.toPaymentMethod = "phone";
          console.log('valid phone.');
        }

        if(!validPhone && !validEmail){
          this.formData.toPaymentMethod = undefined;
          return false;
        }else{
          this.formData.fromAccountId = this.formData.fromSpendAccountId;
          return true;
        }
        
      },
    }
  });

  vm.refreshUrl = '<?= $welcomeMessage ?>' ;


</script>