<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */
 

class YohShow_API {

    /**
     * Yoh show api url
     *
     * @var    yohshow_api_base_url
     * @access private
     */
//    private $yohshow_api_base_url =  'https://yohshow-staging.herokuapp.com/api/v1';
//    private $yohshow_api_base_url =  'https://sandbox.api.yohshow.com/api/v1';
//    private $yohshow_api_base_url =  'https://sandbox.api.yohshow.com/api/v1';
    //  private $yohshow_api_base_url =  'http://localhost:3000/api/v1';
     private $yohshow_api_base_url = "" ;

    /**
     * Yoh show api key
     *
     * @var    yohshow_api_key
     * @access private
     */
    public $yohshow_api_key =  '';

    /**
     * Yoh show api secret
     *
     * @var    yohshow_api_secret
     * @access private
     */
    public $yohshow_api_secret =  '';

 
    /**
     * Initializes all of the partial classes.
     */

    public function __construct($yohshow_api_key,$yohshow_api_secret) {
		$exchange_api_base_url = get_option('exchange_api_base_url');

        $this->yohshow_api_key = $yohshow_api_key;
        $this->yohshow_api_secret = $yohshow_api_secret;
        $this->yohshow_api_base_url = $exchange_api_base_url;
        session_start();
        $_SESSION["exchange_api_key"] = $this->yohshow_api_key;
    }
    public function verify_payment($data){
;


        $data['apiKey'] = $this->yohshow_api_key;
        $data['apiSecret'] = $this->yohshow_api_secret; 


        $result = $this->request("post","/payment/verify",$data);


        // $result["stableToken"] = $response->stableToken;

        // $result["status"] = "pending";
        // $result["flag"] = true;
        // $result["error"] = false;
        
        return $result;

    }

    public function csrfToken(){
        $token["_csrf"] = "test_".rand();
        return json_encode($token);
        // return $token;
    }
    function get_user($fullName,$emailAddress,$username = ""){
        $login = $this->login_or_signup($fullName,$emailAddress,$username,false);
        return $login;

    }
    public function enviorment_label(){
        $exchange_environment = get_option('exchange_environment');
        if($exchange_environment !== "production"){
          $enviorment_label = "_".$exchange_environment;
  
        }else{
          $enviorment_label = "";
  
        }
        return $enviorment_label;
    }
    function get_guest_user(){
            $enviorment_label = $this->enviorment_label();

            $guest_email = "guest@yohshow.com";

            $exchange_guest_user_email_meta_id = update_option( 'exchange_guest_user_email',$guest_email);
            $exchange_guest_user_email_enviorment_label = 'exchange_guest_user_email'.$enviorment_label;
            $exchange_guest_user_email_enviorment_meta_id = update_option( $exchange_guest_user_email_enviorment_label,$guest_email);

            // // var_dump("tokenize exchange_guest_user_email",$exchange_guest_user_email);

            $signup = (object) $this->get_user("Guest Customer",$guest_email);
            // // var_dump("tokenize signup",$signup);

            $exchange_guest_user_id = $signup->userId;
            $exchange_guest_token_id = $signup->token->id;
            $exchange_guest_wallet_id = $signup->wallet->id;
            $exchange_guest_stable_token_account_id = $signup->stableTokenAccountId;
            $exchange_guest_app_token_account_id = $signup->appTokenAccountId;
            // // var_dump("tokenize pre exchange_guest_user_id",$exchange_guest_user_id);
            // // var_dump("tokenize pre exchange_guest_token_id",$exchange_guest_token_id);
            // // var_dump("tokenize pre exchange_guest_wallet_id",$exchange_guest_wallet_id);


            $exchange_guest_user_id_meta_id = update_option('exchange_guest_user_id', $exchange_guest_user_id);
            $exchange_guest_user_id_enviorment_label = 'exchange_guest_user_id'.$enviorment_label;
            $exchange_guest_user_id_enviorment_meta_id = update_option( $exchange_guest_user_id_enviorment_label,$exchange_guest_user_id);


            $exchange_guest_token_id_meta_id = update_option('exchange_guest_token_id', $exchange_guest_token_id);
            $exchange_guest_token_id_enviorment_label = 'exchange_guest_token_id'.$enviorment_label;
            $exchange_guest_token_id_enviorment_meta_id = update_option( $exchange_guest_token_id_enviorment_label,$exchange_guest_token_id);


            $exchange_guest_stable_token_account_id_meta_id = update_option('exchange_guest_stable_token_account_id', $exchange_guest_stable_token_account_id);
            $exchange_guest_stable_token_account_id_enviorment_label = 'exchange_guest_stable_token_account_id'.$enviorment_label;
            $exchange_guest_stable_token_account_id_enviorment_meta_id = update_option( $exchange_guest_stable_token_account_id_enviorment_label,$exchange_guest_stable_token_account_id);

            $exchange_guest_app_token_account_id_meta_id = update_option('exchange_guest_app_token_account_id', $exchange_guest_app_token_account_id);
            $exchange_guest_app_token_account_id_enviorment_label = 'exchange_guest_app_token_account_id'.$enviorment_label;
            $exchange_guest_app_token_account_id_enviorment_meta_id = update_option( $exchange_guest_app_token_account_id_enviorment_label,$exchange_guest_app_token_account_id);

            // // var_dump("tokenize post exchange_guest_user_id",$exchange_guest_user_id);
            // // var_dump("tokenize post exchange_guest_token_id",$exchange_guest_token_id);
            // // var_dump("tokenize post exchange_guest_wallet_id",$exchange_guest_wallet_id);

            // exit;
            return $signup ;

    }
    function login_or_signup($fullName,$emailAddress,$username = "",$saveSession = true){
        $login = (object) $this->login($emailAddress,false,"",$saveSession);
        $must_signup = $login->flag === false  && $login->msg == "account does not exist";
        // // var_dump('$login->flag',$login->flag);
        // // var_dump('$login->msg',$login->msg);
        // // var_dump('$must_signup',$must_signup);

        if($must_signup){
            $signup = $this->signup($fullName,$emailAddress,$username,$saveSession);
            return $signup;

        }else{
            return $login;
        }
        
    }

    function signup($fullName,$emailAddress,$username = "",$saveSession = true){
            $user = get_user_by( 'email', $emailAddress );
            $data['externalId'] = $user->ID; 
            $data['externalType'] = "user"; 
            
            $data['fullName'] = $fullName; 
            $data['username'] = $username; 
            $data['emailAddress'] = $emailAddress; 
            $data['apiKey'] = $this->yohshow_api_key; 
            $data['apiSecret'] = $this->yohshow_api_secret; 
            //echo '<pre>';
            //// var_dump("signup data",$data);
            //echo '</pre>';
            $response = (array) $this->request("post","/account/signup",$data, $saveSession,false);
            $app_exchange_app_id = $response['appId'];
            $current_exchange_app_id = get_option( 'exchange_app_id' );
            if($app_exchange_app_id !== $current_exchange_app_id){
                $response["tokenize_app"] = true;
            }else {
                $response["tokenize_app"] = false;
            }
            if($saveSession){
                session_start();
                $_SESSION["exchange_app_id"] = $app_exchange_app_id;
                $_SESSION["user_exchange_api_key"] = $this->yohshow_api_key;
            }
            


            //echo '<pre>';
            //// var_dump("signup response",$response);
            //echo '</pre>';
            return $response;
    }
    function login($emailAddress,$name = false, $username = "",$saveSession = true){
        $user = get_user_by( 'email', $emailAddress );
        $data['externalId'] = $user->ID; 
        $data['externalType'] = "user"; 

        $data['username'] = $username; 
        $data['emailAddress'] = $emailAddress; 
        $data['apiKey'] = $this->yohshow_api_key; 
        $data['apiSecret'] = $this->yohshow_api_secret;
        if($name){
            $data['fullName'] = $name;
        } 
        if($username){
            $data['username'] = $username;
        } 
        //echo '<pre>';
        //// var_dump("login data",$data);
        //echo '</pre>';
        $response = (array) $this->request("post","/account/login",$data, $saveSession,false);

        $app_exchange_app_id = $response['appId'];
        $current_exchange_app_id = get_option( 'exchange_app_id' );
        // var_dump("login app_exchange_app_id",$app_exchange_app_id);
        // var_dump("login $app_exchange_app_id !== $current_exchange_app_id",$$app_exchange_app_id !== $current_exchange_app_id);
        if($app_exchange_app_id !== $current_exchange_app_id){
            $response["tokenize_app"] = true;
        

        }else {
            $response["tokenize_app"] = false;
        }
        if($saveSession){
            session_start();
            $_SESSION["exchange_app_id"] = $app_exchange_app_id;
            $_SESSION["user_exchange_api_key"] = $this->yohshow_api_key;
        }
        
        //echo '<pre>';
        //// var_dump("login response",$response);
        //echo '</pre>';
        return $response;
    }
    function balances(){
        $data = array();
        //echo '<pre>';
        //// var_dump("balances data",$data);
        //echo '</pre>';
        // $response = $this->request("get","/accounts/token",$data);


        $data['apiKey'] = $this->yohshow_api_key;

        $response = $this->request("post","/accounts",$data);
        // "/accounts"
        //echo '<pre>';
        // // var_dump("balances response",$response);
        $balances = [];
        for ($i=0; $i < count($response->wallets) ; $i++) {
            $wallet = $response->wallets[$i];
            if($wallet->type == "personal"){
                $balances = array_merge($balances,$wallet->allAccounts);
            }
        }
        
        //echo '</pre>';
        $result["accounts"] = $balances;
        $result["stableToken"] = $response->stableToken;
        return $result;
    }
    function holdings($tokenId){
        $data = array();
        //echo '<pre>';
        //// var_dump("holdings data",$data);
        //echo '</pre>';
        $response = $this->request("get","/balances/$tokenId",$data);
        //echo '<pre>';
        //// var_dump("holdings response",$response);
        //echo '</pre>';
        return $response;
    }
    function wallets(){
        $data = array();
        //echo '<pre>';
        //// var_dump("balances data",$data);
        //echo '</pre>';
        $response = $this->request("get","/wallets",$data);
        //echo '<pre>';
        //// var_dump("balances response",$response);
        //echo '</pre>';
        return $response;
    }
    function accounts($accountId=""){
        $data = array();
        //echo '<pre>';
        //// var_dump("balances data",$data);
        //echo '</pre>';
        $data['apiKey'] = $this->yohshow_api_key;
        if($accountId){
            $data['accountId'] = $accountId;
        }

        $response = $this->request("post","/account",$data);

        // $response = $this->request("get","/accounts/$accountId",$data);
        //echo '<pre>';
        //// var_dump("balances response",$response);
        //echo '</pre>';
        return $response;
    }

    function promote(){
        $data = array();
        //echo '<pre>';
        //// var_dump("promote data",$data);
        //echo '</pre>';
        $response = $this->request("post","/token/createTransaction",$data);
        //echo '<pre>';
        //// var_dump("promote response",$response);
        //echo '</pre>';
        return $response;
    }
    function payOwner($balanceId){
        $data['id'] = $balanceId;
        //echo '<pre>';
        //// var_dump("payOwner data",$data);
        //echo '</pre>';
        $response = $this->request("post","/token/payOwner",$data);
        //echo '<pre>';
        //// var_dump("payOwner response",$response);
        //echo '</pre>';
        return $response;
    }
    function mint($data){
        //echo '<pre>';
        //// var_dump("tokenize data",$data);
        //echo '</pre>';
        $response = $this->request("post","/tokens/mint",$data);
        //echo '<pre>';
        //// var_dump("tokenize response",$response);
        //echo '</pre>';
        return $response;
    }
    function placeOrder($data){
        // $data = array();
        //echo '<pre>';
        //// var_dump("placeOrder data",$data);
        //echo '</pre>';
        $response = $this->request("post","/market/orders",$data);
        //echo '<pre>';
        //// var_dump("placeOrder response",$response);
        //echo '</pre>';
        return $response;
    }
    
    function appToken(){
        $data = array();
        //echo '<pre>';
        //// var_dump("balances data",$data);
        //echo '</pre>';
        $response = $this->request("get","/wallets",$data);
        //echo '<pre>';
        //// var_dump("balances response",$response);
        //echo '</pre>';
        return $response;
    }
    /**
     * Initializes all of the partial classes.
     *
     * @param string $method post, get or put
     * @param string $endpoint endpont to send request to
     * @param object $data payload to post to end point
     * @param bool $save_cookie wether or not to save the session cookie
     *                                                                  
     */

    function request($method,$endpoint,$data,$save_cookie = false,$use_cookie = true){
        try {
            $result = $this->request_try($method,$endpoint,$data,$save_cookie,$use_cookie);
            if($result == "Unauthorized"){
                // $is_user_logged_in = is_user_logged_in();
                // // var_dump('$is_user_logged_in',$is_user_logged_in);

                if( !session_id() )
                {
                session_start();
                }

                $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];
                if($exchange_wp_user_id){
                    $user = get_user_by( 'id', $exchange_wp_user_id );
                    // $user = wp_get_current_user();
                    // // var_dump('$user',$user);
                    $user_email = $user->user_email;
                    $user_login = $user->user_login;
                    // // var_dump('$user_email',$user_email);
                    // // var_dump('$user_login',$user_login);
                    $_SESSION["exchange_guest_user"] = false;

    
                }else{
                    $user_email = get_option( 'exchange_guest_user_email' );
                    $user_login = "Guest";
                    $_SESSION["exchange_guest_user"] = true;
                    

                }
                
                $login_result = $this->login_or_signup($user_login,$user_email);
                // // var_dump('$login_result',$login_result);

                $result = $this->request_try($method,$endpoint,$data,$save_cookie,$use_cookie = true);
            }else{
                return $result;
            }
        } catch (\Throwable $th) {
            //throw $th;
        }

    }

    /**
     * Initializes all of the partial classes.
     *
     * @param string $method post, get or put
     * @param string $endpoint endpont to send request to
     * @param object $data payload to post to end point
     * @param bool $save_cookie wether or not to save the session cookie
     *                                                                  
     */

    function request_try($method,$endpoint,$data,$save_cookie = false, $use_cookie = true){
        //TODO stud out request if apiKey says stud
        $apiKey = $this->yohshow_api_key;
        $apiSecret = $this->yohshow_api_secret; 

        if($apiKey == "stud" || $apiSecret == "stud"){
            $result["success"] = true;
            $result["flag"] = true;
            $result = json_encode($result);
            $result = json_decode($result);
            return $result;
        }
        $method = strtolower($method);
        (array) $data;
        $yohshow_api_base_url = $this->yohshow_api_base_url;
        $yohshow_api_url = $yohshow_api_base_url.$endpoint;
        // echo '<pre>';
        // var_dump("yohshow_api_url",$yohshow_api_url);
        // echo '</pre>';

        // $endpoint =  "$base_url/balances";
        // // $endpoint =  "$base_url/csrfToken";
        // // $endpoint =  "$base_url/openOrders";
  
        
        $cookie =  'Cookie:'.$_SESSION["exchange_cookie"];
        //echo '<pre>';
        //// var_dump("cookie",$cookie);
        //echo '</pre>';

    
        $cURLConnection = curl_init();
        curl_setopt($cURLConnection, CURLOPT_URL, $yohshow_api_url);
        curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);

        if($method == "post"){
            // curl_setopt($cURLConnection, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($cURLConnection, CURLINFO_HEADER_OUT, true);
            curl_setopt($cURLConnection, CURLOPT_POST, true);
            curl_setopt($cURLConnection, CURLOPT_POSTFIELDS, $data);

        }

        if($save_cookie){
            curl_setopt($cURLConnection, CURLOPT_HEADER, 1);
        }else if($_SESSION["exchange_cookie"] && $use_cookie){
            curl_setopt($cURLConnection, CURLOPT_COOKIE, $_SESSION["exchange_cookie"] );
        }

        // Set the maximum time in seconds that the request is allowed to execute
        curl_setopt($cURLConnection, CURLOPT_TIMEOUT, 90000); // Max time for the entire request (90000 seconds)
        
        
        // curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array(
        //     $cookie
        // ));
        // curl_setopt($cURLConnection, CURLOPT_HTTPHEADER, array("Cookie: test=cookie"));
    
        $data_response = curl_exec($cURLConnection);
        // echo '<pre>';
        // var_dump('$data_response', $data_response);
        // echo '</pre>';
        if($data_response == "Unauthorized"){
            return $data_response;
        }

        $jsonArrayResponse = json_decode($data_response);
        // echo '<pre>';
        // var_dump('$jsonArrayResponse', $jsonArrayResponse);
        // echo '<pre>';
        if($endpoint == "/tokens/createTransaction"){
            $succesSet = isset($jsonArrayResponse['success']);
            error_log( "yoh show api requst try endpoint /tokens/createTransaction jsonArrayResponse". print_r( $jsonArrayResponse, true ) );
            error_log( "yoh show api requst try endpoint /tokens/createTransaction jsonArrayResponse['success']". print_r( $jsonArrayResponse['success'], true ) );
            // Capture the output of var_dump into a variable
            ob_start();
            var_dump($succesSet);
            $dumpOutput = ob_get_clean();

            // Log the output to the error log
            error_log("yoh show api request try endpoint /tokens/createTransaction var dump succesSet " . $dumpOutput);
            error_log( "yoh show api requst try endpoint /tokens/createTransaction succesSet". print_r( $succesSet, true ) );
            $jsonArrayResponse['success'] = true;


        }
        if($endpoint == "/tokens/deploy"){
            $succesSet = isset($jsonArrayResponse['success']);
            error_log( "yoh show api requst try endpoint /tokens/deploy jsonArrayResponse". print_r( $jsonArrayResponse, true ) );
            error_log( "yoh show api requst try endpoint /tokens/deploy jsonArrayResponse['success']". print_r( $jsonArrayResponse['success'], true ) );
            // Capture the output of var_dump into a variable
            ob_start();
            var_dump($succesSet);
            $dumpOutput = ob_get_clean();

            // Log the output to the error log
            error_log("yoh show api request try endpoint /tokens/deploy var dump succesSet " . $dumpOutput);
            error_log( "yoh show api requst try endpoint /tokens/deploy succesSet". print_r( $succesSet, true ) );
            $jsonArrayResponse['success'] = true;


        }



        if($save_cookie){
            $header_size = curl_getinfo($cURLConnection, CURLINFO_HEADER_SIZE);
            $header = substr($data_response, 0, $header_size);
            $body = substr($data_response, $header_size);
        
            //echo '<pre>';
            //// var_dump("header_size",$header_size);
            //echo '</pre>';
            //echo '<pre>';
            //// var_dump("header",$header);
            //echo '</pre>';
            //echo '<pre>';
            //// var_dump("body",$body);
            //echo '</pre>';

            $ResponseHeader = explode("\n",trim(mb_substr($data_response, 0, CURLINFO_HEADER_SIZE)));
            unset($ResponseHeader[0]);
            $aHeaders = array();
            foreach($ResponseHeader as $line){
            list($key,$val) = explode(':',$line,2);
                $aHeaders[strtolower($key)] = trim($val);
            }
            //echo '<pre>';
            //// var_dump($aHeaders);
            //echo '</pre>';
            /////////get  with logined in sessoin
            $url =  'https://yohshow-staging.herokuapp.com/api/v1/balances';
            // $url =  "$base_url/balances";
            // // $url =  "$base_url/csrfToken";
            // // $url =  "$base_url/openOrders";
            session_start();
            $_SESSION["exchange_cookie"] = $aHeaders["set-cookie"];
            //echo '<pre>';
            // // var_dump('$_SESSION["exchange_cookie"]',$_SESSION["exchange_cookie"]);
            // // var_dump('$body',$body);
            //echo '</pre>';
            $jsonArrayResponse = json_decode($body);
            // // var_dump('$jsonArrayResponse', $jsonArrayResponse);


        }
        curl_close($cURLConnection);
        // // var_dump('$jsonArrayResponse', $jsonArrayResponse);

        return $jsonArrayResponse;

    }


 

 

}