<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow WP
 */
 

class Yohshow_WP {
    /**
     * A reference the class responsible for rendering the submenu page.
     *
     * @$   YohShow_API
     * @access protected
     */
    protected $yohshow_api;

    /**
     * Yoh show api key
     *
     * @var    yohshow_api_key
     * @access private
     */
    protected $yohshow_api_key =  '';

    /**
     * Yoh show api secret
     *
     * @var    yohshow_api_secret
     * @access private
     */
    protected $yohshow_api_secret =  '';

    public $excludeCurrencies = [];//excludeCurrencies;
   //public $excludeCurrencies = ["BTC","ETH","USDT","USDC"];//excludeCurrencies;
 


    public function __construct($yohshow_api) {
        // // var_dump("test yoh show wp includes");
        $this->yohshow_api = $yohshow_api;
        $this->yohshow_api_key = $yohshow_api->yohshow_api_key;
        $this->yohshow_api_secret = $yohshow_api->yohshow_api_secret;
        // // var_dump("test yohshow_api",$this->yohshow_api );
        $this->enqueue_scripts();
        add_action( 'wp_logout', array($this,'_logout') );

    }
    public function withdraw_asset($order_id)  {
      error_log("withdraw_asset called! $order_id", 0);

      $exchange_status = get_post_meta($order_id, "exchange_status", true);
      error_log("withdraw_asset exchange_status $exchange_status", 0);

      if($exchange_status == "unpaid"){
        $order = wc_get_order($order_id);

        $totalCost = get_post_meta($order_id, "exchange_totalAmount", true);
        $netAmount = get_post_meta($order_id, "exchange_netAmount", true);
        $assetType = get_post_meta($order_id, "exchange_assetType", true);
        $toAddress = get_post_meta($order_id, "exchange_toAddress", true);
        $asset = get_post_meta($order_id, "exchange_asset", true);
        $wp_user_id = get_post_meta($order_id, "exchange_wp_user_id", true);
        
        $exchangeTokenId = get_post_meta($order_id, "exchangeTokenId", true);
        $network = get_post_meta($order_id, "exchange_network", true);

        $exchange_user_id = get_user_meta($wp_user_id, "exchange_user_id", true);


        
        


        $quote_source_key = "exchange_quote_source";
          $quote_source = get_option( $quote_source_key );

          $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
          $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

          //

          $quote_source_api_key_key = "exchange_quote_source_api_key";
          $quote_source_api_key = get_option( $quote_source_api_key_key );

          $quote_source_api_secret_key = "exchange_quote_source_api_secret";
          $quote_source_api_secret = get_option( $quote_source_api_secret_key );

          $quote_source_api_memo_key = "exchange_quote_source_api_memo";
          $quote_source_api_memo = get_option( $quote_source_api_memo_key );

         

        //TODO plugin in bitmart api keys

        // $network = $quote_source;
        $amount = 1;
        $buyCurrency = $quote_source_buy_currency;
        if(!$reserveQuote){
          $symbol =  $sellCurrencySymbol . "_" . $buyCurrency;
        }
        $symbol = strtoupper($symbol);
        $withdrawInfo["toAddress"] = $toAddress;
        $withdrawInfo["exchange"] = $quote_source;
        $withdrawInfo["network"] = $network;
        $withdrawInfo["amount"] = $netAmount;
        $withdrawInfo['apiKey'] = $this->yohshow_api_key;
        $withdrawInfo['apiSecret'] = $this->yohshow_api_secret;
        $withdrawInfo["userId"] = $exchange_user_id;
        $withdrawInfo["exchangeTokenId"] = $exchangeTokenId;
        $withdrawInfo["symbol"] = $asset;
        $withdrawInfo["currency"] = $asset;
        $withdrawInfo["exchangeApiKey"] = $quote_source_api_key;
        $withdrawInfo["exchangeApiSecret"] = $quote_source_api_secret;
        $withdrawInfo["exchangeApiMemo"] = $quote_source_api_memo;

        $newDisbursement = (object) $this->yohshow_api->request("post","/balances/withdraw",$withdrawInfo);
        $wihdraw = $newDisbursement;

        // error_log( "withdraw asset wihdraw". print_r( $wihdraw, true ) );

        if($newDisbursement->success){
          $newDisbursement->exchangeDisbursementId = $newDisbursement->withdraw->id;
          $exchangeDisbursementId = $newDisbursement->withdraw->id;
          $update_order_error_meta_id = update_post_meta($order_id,"exchange_error","");
          $update_order_exchange_status_meta_id = update_post_meta($order_id,"exchange_status","paid");
          $flag = true;
          $message = "success";
          $order->add_order_note( "Withdraw successful: network - $network, disbursement ID - $exchangeDisbursementId " );
          // $order->update_status("Completed", 'Withdraw completed', TRUE);  


        }else{
          $exchangeDisbursementId = "error";
          $update_order_error_meta_id = update_post_meta($order_id,"exchange_error",$newDisbursement->message);
          $flag = false;
          $message = $newDisbursement->message;
          $order->add_order_note( "Withdraw error: network - $network, error - $message " );
          $order->update_status("Processing", $message, TRUE);  


        }
        $update_order_exchangeDisbursementId_meta_id = update_post_meta($order_id,"exchangeDisbursementId",$exchangeDisbursementId);
        $update_order_exchange_disbursement_id_meta_id = update_post_meta($order_id,"exchange_disbursement_id",$exchangeDisbursementId);

        $chargeResult = [
            'flag' => $flag,
            'success' => $flag,
            'paid' => $flag,
            'msg' => $message,
            'message' => $message,
            'dispersment' => $newDisbursement,
            'payment' => $order,
        ];

        return $chargeResult;



    

        


      }
      
    }
    function _logout() {
        session_destroy();
    }
    public function get_username($wp_user_id){
      try {
        if(!$wp_user_id){
          throw new Exception("no user id", 1);
        }
        $ownerUsername = $this->_get_username("owner","username",$wp_user_id);
        $creatorUsername = $this->_get_username("creator","creator",$wp_user_id);

        $result["success"] = true;
        $result["exchange_wp_user_id"] = $wp_user_id;
        $result["username"] = $ownerUsername['username'];
        $result["avatar"] = $ownerUsername['avatar'];
        $result["username_link"] = $ownerUsername['username_link'];
        $result["link"] = $ownerUsername['username_link'];

        $result["owner_term_id"] = $ownerUsername["owner_term_id"];
        $result["owner_term_id"] = $ownerUsername["ownerTermId"];

        $result["creator_term_id"] = $creatorUsername["creator_term_id"];
        $result["creator_term_id"] = $creatorUsername["creatorTermId"];

      } catch (\Throwable $th) {
        //throw $th;
        $result["success"] = false;
        $result["msg"] = "Cloud error";
        $result["error"] = $th;
        
      }
      



      

        
        return  $result;
    }
    public function _get_username($term,$exchange_label,$wp_user_id){
      try {
        if(!$wp_user_id){
          throw new Exception("no user id", 1);
        }
        $exchange_term_id_label = "exchange_".$exchange_label."_term_id";
        $ownerTermId = get_user_meta($wp_user_id,$exchange_term_id_label,true);
        if($ownerTermId){
          $ownerTerm = get_term_by('id',$ownerTermId, $term);
          $username = $ownerTerm->slug;
          $ownerTerm = get_term_by('id',$ownerTermId, $term);
          $username_link = get_term_link( $ownerTerm);

        }else{
          $user = get_user_by( 'id', $wp_user_id );
          $number = rand(1, 9000);
          $username = $user->first_name . ' ' . $user->last_name .''. $number;
          //get term by name firs to see if uniquie or just add radom number for uiqueness
          $ownerTerm = wp_create_term( $username, $term);
          $ownerTermId = $ownerTerm["term_id"];
          $user_current_username_term_id_meta = update_user_meta($wp_user_id,$exchange_term_id_label,$ownerTermId);
          $ownerTerm = get_term_by('id',$ownerTermId, $term);
          $username_link = get_term_link( $ownerTerm);

        }

        $user_current_username_term_id = $ownerTermId;
       
        $avatarTermKey ="exchange_user_avatar_term_id_attachment_id_$user_current_username_term_id";
        $exchange_user_avatar_term_id_attachment_id = get_option($avatarTermKey);

        $avatar = wp_get_attachment_url($exchange_user_avatar_term_id_attachment_id );

        $result["success"] = true;
        $result["exchange_wp_user_id"] = $wp_user_id;
        $result["username"] = $username;
        $result["avatar"] = $avatar;
        $result["exchange_label"] = $exchange_label;
        $result["username_link"] = $username_link;
        $result["link"] = $username_link;
        $result[$term."_term_id"] = $ownerTermId;
        $result[$term."TermId"] = $ownerTermId;
      } catch (\Throwable $th) {
        //throw $th;
        $result["success"] = false;
        $result["msg"] = "Cloud error";
        $result["error"] = $th;
        
      }
      



      

        
        return  $result;
    }
    public function avatar_upload($request){
      try {
        if( !session_id() )
        {
          session_start();
        }
          $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];
          $files = $_FILES;
          if($files["avatar"]){
            $avatarResult = $this->upload_attachment("avatar");
            $avatar_attach_id = $avatarResult["attach_id"];
            $avatar_attach_url = $avatarResult["attach_url"];
            //attach image or image url with collection term site option 
            $getUserNameResult = $this->get_username($exchange_wp_user_id);
            $username = $getUserNameResult["username"];
            $user_current_username_term_id = $getUserNameResult["owner_term_id"];
            $user_current_username_creator_term_id = $getUserNameResult["creator_term_id"];
       
            $avatarTermKey ="exchange_user_avatar_term_id_attachment_id_$user_current_username_term_id";
            $exchange_user_avatar_term_id_attachment_id = update_option($avatarTermKey,$avatar_attach_id);

            $avatarTermKey ="exchange_user_avatar_term_id_attachment_id_$user_current_username_creator_term_id";
            $exchange_user_avatar_term_id_attachment_id = update_option($avatarTermKey,$avatar_attach_id);
            // done
            $result["avatar_attach_id"] = $avatar_attach_id;


          }

          $result["success"] = true;
          return json_encode($result);

      } catch (Exception $e) {

          $returnData['msg'] = $e->getMessage();
          $returnData['success'] = false;
          return json_encode($returnData);
      }

    }
    public function create_term($wp_tax_name, $term_label, $term_name, $one_to_one = true){
      /*
        check to see if term exist
        if term exist 
          get term owner//
          if curret user owner is term ower//
            return term success // yes but later
          else
            return error term taken //
        else
          create term //
        make current user owner of term //
      */
      // $term_label = "username"
      // $term_name = "tonysparks"
      // $wp_tax_name = "owner"

      $username = $term_name;
      try {
        if( !session_id() )
        {
          session_start();
        }
        
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];
        $exchange_term_id_label = "exchange_".$term_label."_term_id";

        if($one_to_one){
          $user_current_username_term_id = get_user_meta($exchange_wp_user_id,$exchange_term_id_label,true);
          $user_name_update_possible = $user_current_username_term_id ? true : false;
        }else{
          $user_current_username_term_id = false;
          $user_name_update_possible = false;
        }

        $username_update = false;


        $ownerTerm = get_term_by('name',$username, $wp_tax_name);
        if($ownerTerm){
          $ownerTermId = $ownerTerm->term_id;
          $ownerKey ="exchange_".$term_label."_term_id_owner_user_id_$ownerTermId";
          $exchange_username_term_id_owner_user_id = get_option($ownerKey);

          if( floatval($exchange_username_term_id_owner_user_id) && floatval($exchange_wp_user_id)  !== floatval($exchange_username_term_id_owner_user_id)){
            $result["success"] = false;
            $result["msg"] = $term_label." taken";
            $result["error"] = $term_label." taken";
            $result[$term_label."Taken"] = true;
            return  $result;

          }
          if($exchange_username_term_id_owner_user_id){
//            if(true){
//                $user_current_username_term_id = $ownerTermId;//NOTE should not be here for production
                $username_update = true;
          }



        }else{
          $username_update = $user_name_update_possible;
        }

        if($username_update){
          // update user name term

            if(!$user_current_username_term_id){
                $user_current_username_term_id = $ownerTermId;
            }
          $ownerTerm = wp_update_term( $user_current_username_term_id ,$wp_tax_name, array(
            'name' => $username,
            'slug' => $username
          ) );

        }else{
          // make new user name owne term
          $ownerTerm = wp_create_term( $username, $wp_tax_name);
        }
        $ownerTermId = $ownerTerm["term_id"];
//
        if($one_to_one){

          $user_current_username_term_id = update_user_meta($exchange_wp_user_id,$exchange_term_id_label,$ownerTermId);
        }else{
          $user_term_ids_key = "user_".$term_label."_term_ids";
          $user_collection_term_ids = get_user_meta($exchange_wp_user_id,$user_term_ids_key,true);
          if($user_collection_term_ids){
            if(!in_array($ownerTermId,$user_collection_term_ids)){
              $user_collection_term_ids[] = $ownerTermId;
            }
          }else{
            $user_collection_term_ids = [$ownerTermId];
          }
          $user_collection_term_ids_meta_id = update_user_meta($exchange_wp_user_id,$user_term_ids_key,$user_collection_term_ids);
        }
        $ownerKey ="exchange_".$term_label."_term_id_owner_user_id_$ownerTermId";
        $exchange_username_term_id_owner_user_id = update_option($ownerKey,$exchange_wp_user_id);


      


        $result["success"] = true;
        $result["exchange_wp_user_id"] = $exchange_wp_user_id;
        $result[$term_label] = $username;
        $result[$wp_tax_name."_term_id"] = $ownerTermId;
      } catch (\Throwable $th) {
        //throw $th;
        $result["success"] = false;
        $result["msg"] = "Cloud error";
        $result["error"] = $th;
        
      }
      



      

        
        return  $result;
    }
    public function upload_attachment($name){
      try {
          $files = $_FILES;
          $image_url = $files[$name]['tmp_name'];
          $filename = $files[$name]['name'];
           $upload_dir = wp_upload_dir();
           $image_data = file_get_contents( $image_url );

          if ( wp_mkdir_p( $upload_dir['path'] ) ) {
            $file = $upload_dir['path'] . '/' . $filename;
          }
          else {
            $file = $upload_dir['basedir'] . '/' . $filename;
          }

          file_put_contents( $file, $image_data );

          $wp_filetype = wp_check_filetype( $filename, null );

          $attachment = array(
            'post_mime_type' => $wp_filetype['type'],
            'post_title' => sanitize_file_name( $filename ),
            'post_content' => '',
            'post_status' => 'inherit'
          );

          $attach_id = wp_insert_attachment( $attachment, $file );
          require_once( ABSPATH . 'wp-admin/includes/image.php' );
          $attach_data = wp_generate_attachment_metadata( $attach_id, $file );
          wp_update_attachment_metadata( $attach_id, $attach_data );
          $result["success"] = true;
          $result["attach_id"] = $attach_id;
          return $result;
      } catch (Exception $e) {

          $returnData['msg'] = $e->getMessage();
          $returnData['success'] = false;
          return $returnData;

      }

    }
    
    public function update_username($username){
      $one_to_one = true;
      $username_username =  $this->create_term("owner", "username", $username, $one_to_one);
      if($username_username["success"] == false){
        return $username_username;
      }

      $creator_username = $this->create_term("creator", "creator", $username, $one_to_one);
      return array_merge($username_username,$creator_username);
    }
    /**
   * Logins in user
   */
  public function _login($user_id) {

    return $this->_signup($user_id);
    //NOTE: dont user code below like ever...maybe fore session quest user situations
    // // var_dump("login user_id",$user_id);
    $user = get_user_by("login",$user_id);
    $user = get_user_by("id",$user_id);

    // // var_dump("login user",$user);
    $user_id = $user->id;
    // // var_dump("login user_id",$user_id);

    $exchange_token_id = get_user_meta($user_id, 'exchange_token_id',true);
    // // var_dump("login exchange_token_id",$exchange_token_id);

    if($exchange_token_id == false){
        // // var_dump("login must sign up exchange_token_id",$exchange_token_id);

        return $this->_signup($user_id);
    }else{
        // // var_dump("login already signed up exchange_token_id",$exchange_token_id);

        $user = get_user_by("id",$user_id);
        // // var_dump("login already signed up user",$user);

        $emailAddress = $user->user_email;
        // // var_dump("login already signed up emailAddress",$emailAddress);

        $login = (object) $this->yohshow_api->login($emailAddress);
        // var_dump("login result",$login);
        if($login->success == false && $login->msg == "account does not exist" ){
          return $this->_signup($user_id);

        }else{
          // // var_dump("login already signed up login",$login);

          $exchange_user_id = $login->id;
          $exchange_wallet_id = $login->walletId;
          $exchange_stable_token_account_id = $login->stableTokenAccountId;
          $exchange_app_token_account_id = $login->appTokenAccountId;
          $exchange_token_id = $login->tokenId;

        //   $this->var_error_log("login exchange_token_id $exchange_token_id");
        //   $this->var_error_log("login exchange_user_id $exchange_user_id");
        //   $this->var_error_log("login exchange_wallet_id $exchange_wallet_id");
        //   $this->var_error_log("login exchange_stable_token_account_id $exchange_stable_token_account_id");
        //   $this->var_error_log("login exchange_app_token_account_id $exchange_app_token_account_id");


          $exchange_token_id_result = update_user_meta($user_id, 'exchange_token_id',$exchange_token_id);
          $exchange_user_id_result = update_user_meta($user_id, 'exchange_user_id',$exchange_user_id);
          $exchange_wallet_id_result = update_user_meta($user_id, 'exchange_wallet_id',$exchange_wallet_id);
          $exchange_stable_token_account_id_result = update_user_meta($user_id, 'exchange_stable_token_account_id',$exchange_stable_token_account_id);
          $exchange_app_token_account_id_result = update_user_meta($user_id, 'exchange_app_token_account_id',$exchange_app_token_account_id);
          
          // // var_dump("login already signed up exchange_user_id",$exchange_user_id);
          // // var_dump("login already signed up exchange_wallet_id",$exchange_wallet_id);

          $_SESSION["exchange_user_id"] = $exchange_user_id;
          $_SESSION["exchange_token_id"] = $exchange_token_id;
          $_SESSION["exchange_wallet_id"] = $exchange_wallet_id;
          $_SESSION["exchange_stable_token_account_id"] = $exchange_stable_token_account_id;
          $_SESSION["exchange_app_token_account_id"] = $exchange_app_token_account_id;
          $_SESSION["exchange_guest_user"] = false;
          return $login;

        }
        

    }
    // exit;
 }


 /**
   * Signs up user
   */
  public function _signup($user_id) {
    $apiKey = $this->yohshow_api_key;
    $apiSecret = $this->yohshow_api_secret; 

        
    $user = get_user_by("id",$user_id);
    $user = $user ? $user: get_user_by("login",$user_id);
    // // var_dump("signup user",$user);
    $user_id = $user->ID;
      
    $first_name = get_user_meta($user_id, 'first_name',true);
    $last_name = get_user_meta($user_id, 'last_name',true);
    $user_login = $user->user_login;
    // // var_dump("signup first_name", $first_name );
    // // var_dump("signup last_name", $last_name );
    // // var_dump("signup user_login", $user_login );


    if ( $first_name && $last_name  ){
        // update_user_meta($user_id, 'first_name', $_POST['first_name']);
        // update_user_meta($user_id, 'last_name', $_POST['last_name']);
        $fullName =  $first_name . " " .$last_name;
    } else if ( $user_login  ){
        $fullName =  $user_login;
    }else {
        $fullName =  "New User";
    }
    // if ( isset( $_POST['user_email'] )  ){
    //     $fullName =  $_POST['user_email'];
    // }

    $emailAddress = $user->user_email;
    // $emailAddress = "tony300@yohshow.com";
    // // var_dump("signup emailAddress", $emailAddress );

    // $signup = $this->yohshow_api->signup($fullName,$emailAddress);
    //echo '<pre>'; 
    // // var_dump("signup result",$signup);
    //echo '</pre>';
    $getUserNameResult = $this->get_username($user_id);
    $username = $getUserNameResult["username"];
    $user_current_username_term_id = $getUserNameResult["ownerTermId"];
    $login = (object) $this->yohshow_api->login($emailAddress,$fullName,$username);
    // // var_dump("login login", $login );
    if($apiKey == "stud" || $apiSecret == "stud"){
      $exchange_token_id = false;
      $exchange_user_id = false;
      $exchange_wallet_id = false;
      $exchange_stable_token_account_id = false;
      $exchange_app_token_account_id = false;
      $updateExchangeUser = false;
    }else if($login){
      $exchange_token_id = $login->token->id;
      $exchange_user_id = $login->id;
      $exchange_wallet_id = $login->walletId;
      $exchange_stable_token_account_id = $login->stableTokenAccountId;
      $exchange_app_token_account_id = $login->appTokenAccountId;
      $updateExchangeUser = true;


    }else{
      $exchange_token_id = false;
      $exchange_user_id = false;
      $exchange_wallet_id = false;
      $exchange_stable_token_account_id = false;
      $exchange_app_token_account_id = false;
      $updateExchangeUser = false;

    }

    

    // // var_dump("signup exchange_user_id", $exchange_user_id );
    // // var_dump("signup exchange_token_id", $exchange_token_id );
    // // var_dump("signup exchange_wallet_id", $exchange_wallet_id );

    // $this->var_error_log("signup exchange_token_id $exchange_token_id");
    // $this->var_error_log("signup exchange_user_id $exchange_user_id");
    // $this->var_error_log("signup exchange_wallet_id $exchange_wallet_id");
    // $this->var_error_log("signup exchange_stable_token_account_id $exchange_stable_token_account_id");
    // $this->var_error_log("signup exchange_app_token_account_id $exchange_app_token_account_id");

    if($updateExchangeUser){
      $exchange_user_id_result = update_user_meta($user_id, 'exchange_user_id', $exchange_user_id);
      $exchange_token_id_result = update_user_meta($user_id, 'exchange_token_id', $exchange_token_id);
      $exchange_wallet_id_result = update_user_meta($user_id, 'exchange_wallet_id', $exchange_wallet_id);
      $exchange_stable_token_account_id_result = update_user_meta($user_id, 'exchange_stable_token_account_id', $exchange_stable_token_account_id);
      $exchange_app_token_account_id_result = update_user_meta($user_id, 'exchange_app_token_account_id', $exchange_app_token_account_id);

    }


    

    // // var_dump("signup exchange_user_id_result", $exchange_user_id_result );
    // // var_dump("signup exchange_token_id_result", $exchange_token_id_result );
    // // var_dump("signup exchange_wallet_id_result", $exchange_wallet_id_result );

    $_SESSION["exchange_wp_user_id"] = $user_id;
    $_SESSION["exchange_user_id"] = $exchange_user_id;
    $_SESSION["exchange_token_id"] = $exchange_token_id;
    $_SESSION["exchange_wallet_id"] = $exchange_wallet_id;
    $_SESSION["exchange_stable_token_account_id"] = $exchange_stable_token_account_id;
    $_SESSION["exchange_app_token_account_id"] = $exchange_app_token_account_id;
    $_SESSION["exchange_guest_user"] = false;

    if($login->tokenize_app){
    // if(true){
        if($apiKey && $apiSecret && $apiKey !=="stud" && $apiSecret !=="stud"){
            $yohshow_tokenize = new Yohshow_Tokenize( $this->yohshow_api );
            $yohshow_tokenize->tokenize_app(true);
        }
    }

    return $login;



 }
    public function send_request($endpoint,$request,$action = "post"){
        try {
    
          
    
    
    
          $result = (object) $this->yohshow_api->request($action,$endpoint,$request);
    
          $flag = true;
          $msg = "success";
          if($result == false){
              $flag = false;
              throw new Exception("Error Processing Request", 1);
          }
    
    
    
        } catch (\Throwable $th) {
          //throw $th;
          $result =  [ 
            'flag' => true,
            'smsNumber' => "",
            'exchangeError' => true,
            'error' => $th,
            'shareLink' => "",
            'appToken' => [],
            'smsBalance' => [],
            'stableToken' => [],
            'sellCurrencies' => [],
            'paymentMethods' => [],
            'balances' => [],
            'reserves' => [],
            'tethers' => [],
            'unclaimedBalances' => [],
            'baseUrl' => "",
            'environment' => "",
    
          ];
    
        }
    
    
        return json_encode($result);
        // return json_encode($data);
    
      }
    public function var_error_log( $object=null ){
        ob_start();                    // start buffer capture
        // var_dump( $object );           // dump the values
        $contents = ob_get_contents(); // put the buffer into a variable
        ob_end_clean();                // end capture
        error_log( $contents );        // log contents of the result of // var_dump( $object )
    }


    public function enqueue_scripts(){
        $this->enqueue_scripts_folder("assets/dependencies");
        $this->enqueue_scripts_folder("assets/js");
        $this->enqueue_scripts_folder("assets/js/components");
        $this->enqueue_scripts_folder("assets/js/components/tokens");
        $this->enqueue_scripts_folder("assets/js/pages");

      // wp_enqueue_script( 'exchange-font-', 'https://kit.fontawesome.com/793f8c3763.js' );

    }




    public function enqueue_scripts_folder($path){
        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            //echo '<pre>'; 
            //// var_dump("file_url",$file_url);
            //echo '</pre>';
            // exit;
            wp_enqueue_script( $file_name, $file_url,array("jquery"));
        }
        // // var_dump("$path/*.css" );

        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            // echo '<pre>'; 
            // // var_dump("file_url",$file_url);
            // echo '</pre>';
            // exit;
            wp_enqueue_style( $file_name, $file_url);
        }
        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            // echo '<pre>'; 
            // // var_dump("file_url",$file_url);
            // echo '</pre>';
            // exit;
            wp_enqueue_style( $file_name, $file_url,array("jquery"));
        }
    }

    public function sendTemplateEmail($data){
        return $data;
    }


}