/**
 * <market-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('market', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        market : {},
        parentToken : {},
        token : {},

        exchangeFee : {},
        excludeCurrencies : {},
        stableToken : {},
        paymentDecimal : {},
        minPromoterCommission : {},
        hasBillingCard : {},
        minPromoterCommission : {},
        minOwnerPromoterCommission : {},
        tokenComission : {},
        paymentMethods : {},
        loggedIn : {},
        buyCurrency : {},
        sellCurrency : {},
        appToken : {},
        buyUnitsAction : {},
        environment : {},

        chartData : {},
        payments : {},
        id : "",
        syncing: true,
        loadingMarket: true,

        // fund data
        funds: [],
        // profits data
        profits: [],
        // costs data
        costs: [],
        // dividends data
        dividends: [],

        // Form data
        formData: { /* … */ },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // Server error state for the form
        cloudError: '',
        cloudLoadingError: '',
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="market-component">
        <!-- <div v-if="market && market.exist" class="container"> -->
        <div v-if="true" class="container">
        <div v-if="loadingMarket" class="text-center">
            <h1>This market is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingMarket" class="btn btn-primary mint">Refesh</ajax-button>
        </div>
        <div v-else="">
            <div v-if="cloudLoadingError" class=" error market-pg">
            <h1>There was an error please refresh.</h1>
            <ajax-button type="submit" :syncing="loadingMarket" class="btn btn-primary mint">Refesh</ajax-button>
            </div>
            <div v-else-if="!loadingMarket" class=" loaded market-pg">
            <div v-if="market && market.exist" class="row">
            
                <!-- {{market}} -->
                <!-- {{market.orders}} -->
                <!-- {{market[market.buyCurrency]}} -->
                <!-- {{market[market.sellCurrency]}} -->
                <!-- {{market[market.buyCurrency]}} -->
                <!-- {{paymentMethods}} -->
                <!-- {{appToken}} -->
                <!-- {{buyCurrency}} -->
                <!-- {{market.sellCurrencyId}} -->
                <!-- {{market.buyCurrencyId.name}} -->
                <!-- {{market.sellCurrencyStats}} -->
        
                <div class="col-md-6">
                    <div class="title">
                    <h2>{{market.label}}</h2>
                    <h6>{{market.sellCurrency}} / {{market.buyCurrency}}</h6>
                    </div>
                    <div class="soical">
                    <!-- <a href="https://www.facebook.com/UnitedCoinOfficial/" target="_blank" rel="noopener noreferrer">
                        <span class="socialIconHome fa fa-facebook-square  "></span>
                    </a> -->
                    <a v-if="market.sellCurrencyId" class="" :href="'https://twitter.com/'+market.sellCurrencyId.twitter" target="_blank" rel="noopener noreferrer">
                        <i class="fab fa-twitter socialIconHome" aria-hidden="true"></i>
                    </a>
                    <a v-if="market.sellCurrencyId" class="" :href="'https://www.instagram.com/'+market.sellCurrencyId.instagram" target="_blank" rel="noopener noreferrer">
                        <i class="fab fa-instagram socialIconHome" aria-hidden="true"></i>
                        
                    </a>
                    <a v-if="market.sellCurrencyId" class="socialIconHome" :href="market.sellCurrencyId.website" target="_blank" rel="noopener noreferrer" style="top: -2px;position: relative">
                        <i class="fa fa-globe " aria-hidden="true"></i>
                    </a>
                    <a v-if="market.sellCurrencyId" class="socialIconHome" :href="'tel:'+market.sellCurrencyId.phone" target="_blank" rel="noopener noreferrer" style="top: -2px;position: relative">
                        <i class="fa fa-phone " aria-hidden="true"></i>
                    </a>
                    <!-- <a href="https://www.youtube.com/channel/UCcJY37K-LMHVtOGGNJAQORw" rel="noopener noreferrer" target="_blank">
                        <span class="fa fa-youtube-play socialIconHome "></span>
                    </a>
                    <a href="https://t.me/UnitedCoinConnect" target="_blank" rel="noopener noreferrer">
                        <span class="fa fa-location-arrow socialIconHome "></span>
                    </a> -->
                    <!-- <a href="mailto:support@unitedcoin.org" rel="noopener noreferrer">
                        <span class="fa fa-envelope-o socialIconHome "></span>
                    </a> -->
                    </div>
                    <div class="description">
                    {{market.sellCurrencyId.description}}
                    </div>
                </div>
                <!-- <div :class="buyCurrency.shopifyBuyProductHandle +' '+ buyCurrency.symbol + '  united-product col-md-6 text-right'" >
                    <button class="btn btn-sm btn-primary cart">Buy Units</button>
                    <input type="hidden" class="shopifyVariantId" value="" >
                    <input type="hidden" class="productId" :value="buyCurrency.productId" >
                    <input type="hidden" class="title" :value="buyCurrency.name" >
                    <input type="hidden" class="img" :value="buyCurrency.logo" >
                    <input type="hidden" class="shopifyHandle" :value="buyCurrency.shopifyBuyProductHandle" >
                    <input type="hidden" class="variantPrice" :value="buyCurrency.price" >
                    <input type="hidden" class="quantity" value="1" >
                    <cart-modal id="cart" :environment="environment" :checkout-redirect="'/markets/'+market.currencyPair.toLowerCase()" checkout-action="exchangeDeposit" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal>
                </div> -->
                <div :class="buyCurrency.shopifyBuyProductHandle +' '+ buyCurrency.symbol + '  united-product col-md-6 text-right'" >
                    <!-- {{paymentMethods}} -->
                    <!-- {{loggedIn}} -->
                    <pay-button v-if="loggedIn" checkout-action="payment" :checkout-redirect="'/markets/'+market.id" :environment="environment" label="Pay"  :has-billing-card="hasBillingCard" :payment-methods="paymentMethods" :token="token" :min-owner-promoter-commission="minOwnerPromoterCommission"  :parent-token="parentToken" :stable-token="stableToken" ></pay-button>
                    <!-- <pay-button v-if="loggedIn" checkout-action="payment" :checkout-redirect="'/markets/'+market.id" :environment="environment" :label="'Pay '+ parentToken.name"  :has-billing-card="hasBillingCard" :payment-methods="paymentMethods" :token="token" :min-owner-promoter-commission="minOwnerPromoterCommission"  :parent-token="parentToken" :stable-token="stableToken" ></pay-button> -->
                    <!-- <a v-if="loggedIn" class="btn btn-sm btn-primary" id="payment" @click="clickTransaction"  href="#pay"   data-toggle="modal" data-target="#transactionModal" >Pay {{parentToken.name}}</a> -->
                    <a v-else class="btn btn-sm btn-primary" id="payment" :href="signupLink" >Pay {{parentToken.name}}</a>
        
                    <!--
                    <router-link v-if="loggedIn" :to="'/buyUnits/'+buyUnitsAction+'/markets/'+market.currencyPair.toLowerCase()  " class="btn btn-sm btn-primary cart">Buy {{market.buyCurrencyId.name}}</router-link>
                    -->
                    <router-link v-if="loggedIn" :to="'/quote/buy/'+market.buyCurrencyId.id " class="btn btn-sm btn-primary cart">Buy {{market.buyCurrencyId.name}}</router-link>

                    <router-link v-else="" :to="signupLink" class="btn btn-sm btn-primary cart">Buy {{market.buyCurrencyId.name}}</router-link>
                    <!-- {{me.exchangeUserId}} -->
        
                    <!-- pay button code -->
                    <!-- <a v-if="me.exchangeUserId" class="btn btn-sm btn-primary" id="payment" @click="clickTransaction"  href="#pay"   data-toggle="modal" data-target="#transactionModal" >Pay Bill</a>
                    <a v-else class="btn btn-sm btn-primary" id="payment" :href="'/signup/markets/'+market.id" >Pay Bill</a> -->
        
                    <span v-if="loggedIn">
                    <router-link v-if="(market.sellCurrencyId && me.exchangeUserId == market.sellCurrencyId.userId) || isSuperAdmin" :to="'/mint/'+market.sellCurrencyId.id" class="btn btn-sm btn-primary cart">Edit Token</router-link>
                    </span>
                    <!--
                    <share-modal id="share" class="d-inline" :label="'Share '+market.sellCurrencyId.name" :share-link="shareLink"></share-modal>
                    -->
                    
                    
                    
        
        
        
                </div>
        
                <div class="col-md-12">
                    <div class="stats row">
                        <div class="col-md-3 col-sm-3 col-xs-2 text-center">
                        <div class="label">Last Price</div>
                        <h6 class="lastPrice ticker-price">{{market.ticker.last}}</h6>
                        </div>
                        <div class="col-md-3 col-sm-3 col-xs-2 text-center">
                        <div class="label">24hr Change</div>
                        <h6 class="change">{{market.ticker.change}}</h6>
                        </div>
                        <div class="col-md-3 col-sm-3 col-xs-2 text-center">
                        <div class="label">24hr High</div>
                        <h6 class="high ticker-price">{{market.ticker.high}}</h6>
                        </div>
                        <div class="col-md-3 col-sm-3 col-xs-2 text-center">
                        <div class="label">24hr Low</div>
                        <h6 class="low ticker-price">{{market.ticker.low}}</h6>
                        </div>
                        <div class="col-md-12 text-center">
                        <span class="label">24hr Volume: </span>
                        <b class="buyVolume">{{market.ticker.vol}} </b>
                        <span class="buyCurrency">{{market.buyCurrency}} /</span>
                        <b class="sellVolume">{{market.ticker.volume}}  </b>
                        <span class="sellCurrency">{{market.sellCurrency}} </span>
        
                        </div>
                    </div>
                    <!-- main coentent tabs  -->
                    <!-- 
                    chart
                    stats
                    holding 
                    history
        
                    -->
                
                    <div class="row mb-3">
        
                    <div class="col-md-12">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                
                            <li class="nav-item">
                                <!-- <a v-if="userId" class="nav-link " id="payment" @click="clickTransaction"  href="#pay"   data-toggle="modal" data-target="#transactionModal" >Pay Bill</a> -->
                                <!-- <a v-else class="nav-link " id="payment" :href="'/signup/tokens/'+market.token.id" >Pay Bill</a> -->
                            </li>
                        
                            <li class="nav-item">
                                <a class="nav-link active" id="charts-tab" data-toggle="tab" href="#charts" role="tab" aria-controls="charts" aria-selected="true">Chart</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="stats-tab" data-toggle="tab" href="#stats" role="tab" aria-controls="stats" aria-selected="false">Stats</a>
                            </li>
        
                            <li class="nav-item">
                                <a class="nav-link" id="holdings-tab" data-toggle="tab" href="#holdings" role="tab" aria-controls="holdings" aria-selected="false">Holdings</a>
                            </li>
        
                            <!--
                            
                            <li class="nav-item">
                                <a class="nav-link" id="history-tab" data-toggle="tab" href="#history" role="tab" aria-controls="history" aria-selected="false">History</a>
                            </li>
                            -->
            
                            
                            
                        </ul>
        
                        <!-- Tab panes -->
                        <div class="tab-content">
                            
                            <div class="tab-pane active " id="charts" role="tabpanel" aria-labelledby="charts-tab">
                                
                                
                                <!-- new -->
                                <!-- <div id="myChart" class="row"></div> -->

                                <!-- old -->
                                <canvas id="myTokenChart"></canvas> 
                            </div>
        
                            <div class="tab-pane" id="holdings" role="tabpanel" aria-labelledby="holdings-tab">
                                
                                    
                                    <!-- <h3>Promoters</h3> -->
        <!-- 
        name 
        quanity
        rewards comission
        
        -->
        <!-- {{market.holdings}} -->
                                <holdings-table :me="false" :form-data="false"   :balances="market.holdings"></holdings-table>
                            </div>
                            <div class="tab-pane" id="stats" role="tabpanel" aria-labelledby="stats-tab">
                                <canvas id="myChart" ></canvas>
                                <!-- <h3>Token Statistics</h3> -->
                                <table class="table table-striped">
                                    <tbody>
                                        <!-- <tr>
                                            <th scope="row">Total Supply</th>
                                            <td>{{market.token.totalSupply}} {{market.token.symbol}}</td>
                                        </tr> -->
                                        <!--
                                        <tr>
                                            <th scope="row">ICO Supply</th>
                                            <td>{{market.token.icoSupply}} {{market.token.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">CrowdFunding Goal</th>
                                            <td>{{market.token.icoTargetGoal}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr> -->
                                        <tr>
                                            <th scope="row">Total Funding</th>
                                            <td>{{market.tokenBalance.totalFunding}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Total Reserve</th>
                                            <td>{{market.tokenBalance.totalHoldings + market.tokenBalance.totalExchange}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Total Spending</th>
                                            <td>{{market.tokenBalance.totalSpending}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Total Revenue</th>
                                            <td>{{market.tokenBalance.totalProfits}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Total Royalties</th>
                                            <td>{{market.tokenBalance.totalDividends > market.tokenBalance.totalProfits ? market.tokenBalance.totalProfits : market.tokenBalance.totalDividends }} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Exchange Value</th>
                                            <td>{{market.trades.length > 0 ? market.token.exchangeValue : 0}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Reserve Value</th>
                                            <td>{{market.trades.length > 0 ? market.token.exchangeValue : 0}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Royalty Value</th>
                                            <td>{{market.token.tokenWorth}} {{market.token.paymentMethod.symbol}}</td>
                                        </tr>
                                        <!-- 
                                        <tr>
                                            <th scope="row">Transfer Fee</th>
                                            <td>{{market.token.basisPointsRate}} %</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Maximum Transfer Fee</th>
                                            <td>{{market.token.maximumFee}} {{market.token.symbol}}</td>
                                        </tr> -->
                                    </tbody>
                                </table>
                            </div>
        
                            <div class="tab-pane" id="history" role="tabpanel" aria-labelledby="history-tab">
                                <!-- {{market.feed.payments}} -->
                                <transaction-feed label="Feed" v-bind:transactions="market.feed.payments" :token="token" :decimals="paymentDecimal" ></transaction-feed>
                            </div>
                            
        
                            
                            
                        </div>
        
                    </div>
                </div>
                    
                    <!-- main coentent tabs end  -->
        
                    <div class="row">
                    <div class=" col-md-6 ">
                    <!--
                      old
                      <div class=" col-md-6  d-none d-md-block d-lg-block">
                    -->

                        

                            <div class="orders bids">
                              <h4>BUY ORDERS</h4>
                              <div class="sums">
                              <label class="supply">
                                  <b class="total-bids-supply">{{market.orders.total_bids_supply}} </b> 
                                  {{market.sellCurrency}} 
                              </label>
                              <label class="demand">
                                  <span class="total-bids-demand">{{market.orders.total_bids_demand}} </span> 
                                  {{market.buyCurrency}} 
                              </label>
                              </div>
                              <order-table :type="'bids'" :sell="market.sellCurrency" :buy="market.buyCurrency" :orders="market.orders.bids"></order-table>
                            </div> 


                            <div class="orders asks">
                                <h4>SELL ORDERS</h4>
                                <div class="sums">
                                    <label class="supply">
                                        <b class="total-asks-supply">{{market.orders.total_asks_supply}} </b> 
                                        {{market.sellCurrency}} 
                                    </label>
                                    <label class="demand">
                                        <span class="total-asks-demand">{{market.orders.total_asks_demand}} </span> 
                                        {{market.buyCurrency}} 
                                    </label>
                                    </div>
                                <order-table :type="'ask'" :sell="market.sellCurrency" :buy="market.buyCurrency" :orders="market.orders.asks"></order-table>
                            </div> 

                    </div>
                    <div class="col-md-6 order">
                        <ul class="nav nav-tabs tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                            <a class="nav-link active" id="buy-tab" data-toggle="tab" href="#buy" role="tab" aria-controls="buy" aria-selected="true">Buy</a>
                            </li>
                            <li class="nav-item">
                            <a class="nav-link" id="sell-tab" data-toggle="tab" href="#sell" role="tab" aria-controls="sell" aria-selected="false">Sell</a>
                            </li>
                            <!-- <li class="nav-item">
                            <a class="nav-link" id="limit-tab" data-toggle="tab" href="#limit" role="tab" aria-controls="limit" aria-selected="false">Stop Limit</a>
                            </li> -->
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <form class="tab-pane  show active" id="buy" role="tabpanel" aria-labelledby="buy-tab">
                                <div class="col-md-12 text-center order-form buy">
                                <h2>BUY {{market.sellCurrency}}</h2>
                                    <div class="price text-left">
                                    <h6>Price </h6>
                                    <input placeholder="00000000.00" class="price price-info" name="price" type="number" step=".000001" min=".000001"  value="0"  />
                                    <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="amount quantity text-left">
                                    <h6>Amount </h6>
                                    <input placeholder="00000000.00" class="amount price-info"  name="volume" type="number" step=".000001" min=".000001" value="0" />
                                    <label class="text-right">{{market.sellCurrency}}</label>
                                    </div>
                                    <hr>
                                    <div class="total cost text-left">
                                    <h6>Total </h6>
                                    <input placeholder="00000000.00"  class="total price-info" type="number" step=".000001" min=".000001"  value="0"   />
                                    <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="">
                                    <label class="msg error danger text-left"></label>
                                    <label class="msg success text-left"></label>
                                    </div>
                                    <div class="row p-0">
                                    <button v-if="loggedIn" class="col-md-12 buy btn btn-success place-order">Buy {{market.sellCurrency}}</button>
                                    
                                    <a v-else="" :href="signupLink" class="col-md-12 btn btn-success">Buy {{market.sellCurrency}}</a>
        
                                    <input type="hidden" class="action" name="side">
                                    <input type="hidden"  name="ord_type" value="market">
                                    <input type="hidden"  name="market" :value="market.id">
                                    </div>
                                <br>
                                <br>
                                <!-- <hr> -->
                                <div v-if="loggedIn" class="sellBalance text-left">
                                    <label>You have: <span class="balance">{{market[market.sellCurrency].spendingBalance - market[market.sellCurrency].order}}</span> {{market.sellCurrency}}</label>
                                </div>
                                <div v-if="loggedIn" class="buyBalance text-left">
                                    <label>You have: <span class="balance">{{market[market.buyCurrency].spendingBalance - market[market.buyCurrency].order}}</span> {{market.buyCurrency}}</label>
                                </div>
                                <p class="order-result  text-left">
                                </p>
                                <p class="text-left">
                                    All coins and assets are paid with {{buyCurrency.name}}
                                </p>
                                <p class="text-left">
                                    There is a {{exchangeFee * 100}}% exchange fee on all trades.
                                </p>
        
                                </div>
                            </form>
                            <form class="tab-pane " id="sell" role="tabpanel" aria-labelledby="sell-tab">
                                <div class="col-md-12 text-center order-form">
                                <h2>SELL {{market.sellCurrency}}</h2>
                                    <div class="price text-left">
                                    <h6>Price </h6>
                                    <input placeholder="00000000.00" class="price price-info" type="number" step=".000001" min=".000001"  value="0"  name="price" />
                                    <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="amount quantity text-left">
                                    <h6>Amount </h6>
                                    <input placeholder="00000000.00" class="amount price-info" type="number" step=".000001" min=".000001"  value="0"  name="volume"/>
                                    <label class="text-right">{{market.sellCurrency}}</label>
                                    </div>
                                    <hr>
                                    <div class="total cost text-left">
                                    <h6>Total </h6>
                                    <input placeholder="00000000.00"  class="total price-info" type="number" step=".000001" min=".000001"  value="0"  />
                                    <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="">
                                    <label class="error danger text-left"></label>
                                    <label class="success danger text-left"></label>
                                    </div>
                                    <div class="row p-0">
                                    <button v-if="loggedIn" class="col-md-12 sell btn btn-danger place-order">Sell {{market.sellCurrency}}</button>
                                    <a v-else="" :href="signupLink" class="col-md-12 btn btn-danger">Sell {{market.sellCurrency}}</a>
        
                                    <input type="hidden" class="action" name="side">
                                    <input type="hidden"  name="ord_type" value="market">
                                    <input type="hidden"  name="market" :value="market.id">
                                    </div>
                                <br>
                                <br>
                                <!-- <hr> -->
                                <div v-if="loggedIn" class="sellBalance text-left">
                                    <label>You have: <span class="balance">{{market[market.sellCurrency].spendingBalance - market[market.sellCurrency].order}}</span> {{market.sellCurrency}}</label>
                                </div>
                                <div v-if="loggedIn" class="buyBalance text-left">
                                    <label>You have: <span class="balance">{{market[market.buyCurrency].spendingBalance - market[market.buyCurrency].order}}</span> {{market.buyCurrency}}</label>
                                </div>
                                    <p class="order-result  text-left">
                                    </p>
                                    <p class="text-left">
                                        All coins and assets are paid with {{buyCurrency.name}}
                                    </p>
                                    <p class="text-left">
                                        There is a {{exchangeFee * 100}}% exchange fee on all trades.
                                    </p>
                                </div>
                            </form>
                            <form class="tab-pane " id="limit" role="tabpanel" aria-labelledby="limit-tab">
                                <div class="col-md-12 text-center order-form">
                                    <h2>STOP LIMIT</h2>
                                    <form>
                                    <div class="limit text-left">
                                        <h6>Trigger Price </h6>
                                        <input placeholder="00000000.00" class="limit price-info" type="number" step=".000001" min=".000001"  value="0"  name="limit" />
                                        <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="price text-left">
                                        <h6>Price </h6>
                                        <input placeholder="00000000.00" class="price price-info" type="number" step=".000001" min=".000001"  value="0"  name="price" />
                                        <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="amount quantity text-left">
                                        <h6>Amount </h6>
                                        <input placeholder="00000000.00" class="amount price-info" type="number" step=".000001" min=".000001"  value="0"  name="volume" />
                                        <label class="text-right">{{market.sellCurrency}}</label>
                                    </div>
                                    <hr>
                                    <div class="total cost text-left">
                                        <h6>Total </h6>
                                        <input placeholder="00000000.00"  class="total price-info" type="number" step=".000001" min=".000001"  value="0"  />
                                        <label class="text-right">{{market.buyCurrency}}</label>
                                    </div>
                                    <div class="text-left">
                                        <label class="error danger"></label>
                                        <label class="success danger"></label>
                                    </div>
                                    <div class="row p-0">
                                        <button class="col-md-12 buy btn btn-success place-order">Buy {{market.sellCurrency}}</button>
                                        <br>
                                        <br>
                                        <button class="col-md-12 sell btn btn-danger place-order">Sell {{market.sellCurrency}}</button>
                                        <input type="hidden" class="action" name="side">
                                        <input type="hidden"  name="ord_type" value="limit">
                                        <input type="hidden"  name="market" :value="market.id">
        
                                    </div>
                                    </form>
                                    <br>
                                    <br>
                                    <!-- <hr> -->
                                    <div v-if="loggedIn" class="sellBalance text-left">
                                    <label>You have: <span class="balance">{{market[market.sellCurrency].spendingBalance - market[market.sellCurrency].order}}</span> {{market.sellCurrency}}</label>
                                    </div>
                                    <div v-if="loggedIn" class="buyBalance text-left">
                                    <label>You have: <span class="balance">{{market[market.buyCurrency].spendingBalance - market[market.buyCurrency].order}}</span> {{market.buyCurrency}}</label>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!--
                    <div class="orders col-md-4 bids d-md-none d-lg-none  d-sm-block">
                        <h4>BUY ORDERS</h4>
                        <div class="sums">
                        <label class="supply">
                            <b class="total-bids-supply">{{market.orders.total_bids_supply}} </b> 
                            {{market.sellCurrency}} 
                        </label>
                        <label class="demand">
                            <span class="total-bids-demand">{{market.orders.total_bids_demand}} </span> 
                            {{market.buyCurrency}} 
                        </label>
                        </div>
                        <order-table :type="'bids'" :sell="market.sellCurrency" :buy="market.buyCurrency" :orders="market.orders.bids"></order-table>
                    </div>
                    
                      <div class="orders col-md-4 asks">
                          <h4>SELL ORDERS</h4>
                          <div class="sums">
                              <label class="supply">
                                  <b class="total-asks-supply">{{market.orders.total_asks_supply}} </b> 
                                  {{market.sellCurrency}} 
                              </label>
                              <label class="demand">
                                  <span class="total-asks-demand">{{market.orders.total_asks_demand}} </span> 
                                  {{market.buyCurrency}} 
                              </label>
                              </div>
                          <order-table :type="'ask'" :sell="market.sellCurrency" :buy="market.buyCurrency" :orders="market.orders.asks"></order-table>
                      </div> 
                    -->
                    </div>
                    <div v-if="loggedIn" class="open-orders">
                    <h4>YOUR OPEN ORDERS</h4>
                    <open-orders-table  :orders="market.openOrders"></open-orders-table>
                    </div>
                    <div v-if="loggedIn" class="trade-history">
                    <h4>YOUR TRADES</h4>
                    <!-- {{market.tradeHistory}} -->
        
                    <trade-history-table :market-filter="[market.id]" :trades="market.tradeHistory"></trade-history-table>
                    </div>
                    <div class="trades">
                    <h4>TRADE HISTORY</h4>
                    <!-- {{market.trades}} -->
                    <trade-table :market-filter="[market.id]" :sell="market.sellCurrency" :buy="market.buyCurrency" :trades="market.trades"></trade-table>
        
        
                    </div>  
                </div>
                <div class="col-md-3">
                </div>
            </div>
            <div v-else class="container">
                <div class="text-center p-5">
                    <h2>This market is still processing or does not currently exists. If you recently created this market please refresh this page in a couple minutes.</h2>
                    <button type="button" class="btn btn-primary mt-4" onClick="window.location.reload();">
                    Refresh
                    </button>
        
                </div>
            </div>
            </div>

        </div>
        
        
        </div>

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.currencyPair = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);
          console.log("about to listen");
          // this.watchMarkets();
          // this.listen();
          await this.listen();  

          console.log("should listening",this.$route.params.id);

    },
    mounted: async function() {
      // this.updateChart(this.market);
        // this.bindUIActions();  
  
    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        //pay now button  start
        // changeTransaction: async function(e){
        //   var payment = $(".transactionModal #amount").val();
        //   console.log("pre fixed payment",payment);
        //   payment = parseFloat(payment);
        //   payment = payment.toFixed(2);
        //   console.log("post fixed payment",payment);
        //   $(".transactionModal .charge").html(payment);
        //   // this.formData.amount = payment.toFixed(2);
        //   console.log('changeTransaction called',e,payment);
        //   this.calcuatePromotion(payment);
        //   var note = $(".transactionModal #note").val();
        //   console.log("note",note);
        //   $("#confirmModal .note").html(note);
        //   // $("#transactionModal .type").val(id);
        // },
        // calcuatePromotion: async function(amount){
        //   var maxPromoterCharge = this.maxPromoterCharge;
        //   var actionLabel = $(".transactionModal .action").html();
        //   if(actionLabel == "Promote" && amount > maxPromoterCharge){
        //     $(".transactionModal #amount").val(maxPromoterCharge);
        //     amount = maxPromoterCharge;
        //     amount = amount.toFixed(2);
        //   $(".transactionModal .charge").html(amount);
    
        //   }
    
        //   var maxPromoterCommission = this.maxPromoterCommission;
        //   var minOwnerPromoterCommission = this.minOwnerPromoterCommission;
          
          
    
        //   var serviceCommission = 0;
        //   // var serviceCommission = this.serviceCommission;
        //   var minPromoterCommission = this.minPromoterCommission;
        //   var tokenComission = this.minOwnerPromoterCommission ;
        //   var totalSupply = this.token.totalSupply;
        //   var price = this.token.price;
          
        //   var tokenFee = 0;
        //   var netTransferAmount = transferAmount - tokenFee;
        //   var ownershipPercent = netTransferAmount / totalSupply;
    
        //   var serviceFee = amount * serviceCommission;
        //   var sendAmount = amount - serviceFee;
    
    
        //   var maxPaidCommission =  maxPromoterCommission - minPromoterCommission; 
        //   var owedPaidpercentageOfMaxPaidCommission = sendAmount / maxPromoterCharge;
        //   var owedPaidCommission = owedPaidpercentageOfMaxPaidCommission * maxPaidCommission ;
        //   var totalCommission = owedPaidCommission + minPromoterCommission;
    
        //   var transferAmount = totalSupply * totalCommission;
          
    
        //   /*
        //     calculate differenc of minPromoterCommission comission and Max promotion comission
        //   var maxPaidCommission =  maxPromoterCommission - minPromoterCommission; 
            
        //     make sure maxcharge is max value for payment
    
        //     caclulate additonal percentage from payment
        //      owedPaidpercentageOfMaxPaidCommission = divided payment by max charge
    
        //     owedPaidCommission = owedPaidpercentageOfMaxPaidCommission * maxPaidCommission 
    
        //     totalCommission = owedPaidCommission + minCommission
    
        //   */
    
        //   console.log("amount",amount);
        //   console.log("price",price);
        //   console.log("maxPromoterCharge",maxPromoterCharge);
          
        //   console.log("owedPaidCommission",owedPaidCommission);
        //   console.log("minPromoterCommission",minPromoterCommission);
        //   console.log("serviceFee",serviceFee);
        //   console.log("sendAmount",sendAmount);
        //   console.log("transferAmount",transferAmount);
        //   console.log("tokenFee",tokenFee);
        //   console.log("netTransferAmount",netTransferAmount);
        //   console.log("totalCommission",totalCommission);
        //   totalCommission *= 100;
        //   minOwnerPromoterCommission *= 100;
        //   var netPromoterCommission = totalCommission - minOwnerPromoterCommission;
        //   console.log("totalCommission post * 100",totalCommission);
          
          
        //   $(".transactionModal .netPromoterCommission").html(netPromoterCommission);
        //   $(".transactionModal .amount").html(amount);
        //   $(".transactionModal .price").html(maxPromoterCharge);
        //   // $(".transactionModal .maxPromoterCharge").html(maxPromoterCharge);
        //   $(".transactionModal .serviceFee").html(serviceFee);
        //   $(".transactionModal .sendAmount").html(sendAmount);
        //   $(".transactionModal .transferAmount").html(transferAmount);
        //   $(".transactionModal .tokenFee").html(tokenFee);
        //   $(".transactionModal .netTransferAmount").html(transferAmount);
        //   $(".transactionModal .ownershipPercent").html(totalCommission);
        // },
        // calcuateInvestment: async function(amount){
        //   var serviceCommission = this.serviceCommission;
        //   var tokenComission = this.token.basisPointsRate ;
        //   var totalSupply = this.token.totalSupply;
        //   var price = this.token.price;
        //   var serviceFee = amount * serviceCommission;
        //   var sendAmount = amount - serviceFee;
        //   var transferAmount = sendAmount / price;
        //   var tokenFee = transferAmount * tokenComission;
        //   var netTransferAmount = transferAmount - tokenFee;
        //   var ownershipPercent = netTransferAmount / totalSupply;
    
        //   console.log("amount",amount);
        //   console.log("price",price);
        //   console.log("serviceFee",serviceFee);
        //   console.log("sendAmount",sendAmount);
        //   console.log("transferAmount",transferAmount);
        //   console.log("tokenFee",tokenFee);
        //   console.log("netTransferAmount",netTransferAmount);
        //   console.log("ownershipPercent",ownershipPercent);
          
          
        //   $(".transactionModal .amount").html(amount);
        //   $(".transactionModal .price").html(price);
        //   $(".transactionModal .serviceFee").html(serviceFee);
        //   $(".transactionModal .sendAmount").html(sendAmount);
        //   $(".transactionModal .transferAmount").html(transferAmount);
        //   $(".transactionModal .tokenFee").html(tokenFee);
        //   $(".transactionModal .netTransferAmount").html(netTransferAmount);
        //   $(".transactionModal .ownershipPercent").html(ownershipPercent);
        // },
        // createTransaction: async function() {
        //   // Clear out any pre-existing error messages.
        //   var Token = this;
        //   this.formErrors = {};
    
        //   var argins = this.formData;
    
        //   // // // Validate address:
        //   // if(!argins.admin_address) {
        //   //   this.formErrors.admin_address = true;
        //   // }
        //   // // // Validate symbol:
        //   // if(!argins.symbol) {
        //   //   this.formErrors.symbol = true;
        //   // }
        //   // // // Validate symbol:
        //   // if(!argins.name) {
        //   //   this.formErrors.name = true;
        //   // }
    
        //   // // Validate email:
        //   // if(!argins.emailAddress) {
        //   //   this.formErrors.emailAddress = true;
        //   // }
    
        //   // // Validate card:
        //   if(!Token.hasBillingCard) {
        //     if(argins.type == "promote" && 0 == this.token.promoterCharge ) {
        //       //no card needed;
        //       console.log("createTransaction no card needed");
        //     }else{
        //       console.log("createTransaction argins.type",argins.type);
        //       console.log("createTransaction this.promoterCharge",this.promoterCharge);
    
        //       var addedCard = await Token.clickStripeCheckoutButton();
        //       if(!addedCard){
        //         this.formErrors.hasBillingCard = true;
        //       }
        //     }
            
        //   }
          
          
    
        //   // // If there were any issues, they've already now been communicated to the user,
        //   // // so simply return undefined.  (This signifies that the submission should be
        //   // // cancelled.)
        //   console.log("createTransaction clicked argins",argins);
        //   if (Object.keys(this.formErrors).length > 0) {
        //     return;
        //   }
          
        //   return argins;
        // },
        // clickTransaction: async function(e){
        //   var id = e.target.id;
        //   this.formData.type = id;
        //   if(id =="fund"){
        //     $(".transactionModal .action").html("Fund");
        //     $(".transactionModal .fund, .transactionModal .pay").show();
        //     $(".transactionModal .promote").hide();
        //     $(".transactionModal #confirm").html("Confirm and Pay");
        //     $(".transactionModal #amount").removeAttr("max");
        //   } else if(id =="payment"){
        //     $(".transactionModal .action").html("Pay");
        //     $(".transactionModal .fund, .transactionModal .promote").hide();
        //     $(".transactionModal .pay").show();
        //     $(".transactionModal #confirm").html("Confirm and Pay");
        //     $(".transactionModal #amount").removeAttr("max");
        //   } else if(id =="invoice"){
        //     $(".transactionModal .action").html("Invoice");
        //     $(".transactionModal .fund, .transactionModal .promote").hide();
        //     $(".transactionModal .pay").show();
        //     $(".transactionModal #confirm").html("Confirm Request");
        //     $(".transactionModal #amount").removeAttr("max");
        //   } else if(id =="promote"){
        //     $(".transactionModal .action").html("Promote");
        //     $(".transactionModal .fund, .transactionModal .pay").show();
        //     $(".transactionModal .promote").show();
        //     $(".transactionModal .note").hide();
        //     $(".confirmModal .fund").hide();
            
        //     $(".transactionModal #confirm").html("Confirm Request");
        //     $(".transactionModal #amount").attr("max",this.maxPromoterCharge);
            
        //   }
        //   console.log('clickTransaction called',e,id);
        //   $("#fromBalanceId option").removeAttr("selected");
        //   $("#fromBalanceId").val($("#fromBalanceId option:first").val());
        //   this.formData.from = $("#fromBalanceId option:first").val();
    
        //   // $("#transactionModal .type").val(id);
        // },
        //pay now button  end
    
        //market functions
        listen: async function() {
          // The auto-connecting socket is exposed as `io.socket`.
    
          // Use `io.socket.on()` to listen for the 'hello' event:
          // io.socket.on(this.market.id, function (data) {
          //   console.log('Socket `' + data.id + '` joined the party!');
          // });
          var Market = this;
        
          //show loading// syincing
          this.loadingMarket = true;
          // $(".market .market-pg").hide().addClass("d-none");
          // $(".market .loading").show().removeClass("d-none");
          // get market 
          
          // var data =  await Cloud.market.with({market:this.currencyPair})
          // .tolerate(()=>{
          //   this.cloudLoadingError = true;
          // });
    
          // // var id = data.id;
          // // $(cancelButton).show().addClass("d-block").removeClass("d-none");
          // if(data.flag){
          //   this.loadingMarket = false;
    
          //   _.extend(this, data);
          //   var market = data.market;
          //   this.chartData = this.market.chartData;
          //   this.id = market.id;
          //   this.payments = this.market && this.market.feed ? this.market.feed.payments : [];
          //   //refresh
          //   // setTimeout(() => {
          //   //   Market.refresh(market);
          //   // }, 5000);
            
          // //hide loading
    
          //   // $(".market .market-pg").hide().addClass("d-none");
          //   // $(".market .loaded").show().removeClass("d-none");
    
          // }else if(data.mustLogin){
          //   window.location.href = data.redirect;
          // } else{
          //   this.loadingMarket = false;
    
          //   // $(".market .market-pg").hide().addClass("d-none");
          //   // $(".market .error").show().removeClass("d-none");
          // }

          var apiRequestHeader = {
            // 'X-CSRF-Token':csrf._csrf,
            'X-CSRF-Token':"test",
              // 'cookie':cookie
          };
          jQuery.ajax({
            type: "POST",
          //   url: this.refreshUrl+"/markets/orders/cancel",
            url: '/wp-json/yohshow/api/v1/market',
            data: {market:this.currencyPair}, // serializes the form's elements.
            headers:apiRequestHeader,
            success: async function(resData, textStatus, request)
            {
                resData = JSON.parse(resData);
                this.syncing = true;
                console.log("place order result",resData); // => e.g. 403
              if(resData.flag){
                Market.loadingMarket = false;
                _.extend(Market, resData);
                var market = resData.market;
                Market.chartData = Market.market.chartData;
                Market.id = market.id;
                Market.payments = Market.market && Market.market.feed ? Market.market.feed.payments : [];
                //refresh
                setTimeout(() => {
                  Market.refresh(market);
                }, 5000);
                
              //hide loading
        
                // $(".market .market-pg").hide().addClass("d-none");
                // $(".market .loaded").show().removeClass("d-none");
        
              }else if(resData.mustLogin){
                window.location.href = resData.redirect;
              } else{
                Market.loadingMarket = false;
        
                // $(".market .market-pg").hide().addClass("d-none");
                // $(".market .error").show().removeClass("d-none");
              }

                // console.log('got balance the data!!!',data); // show response from the php script.
                // if(data.flag){
                //   location.reload();
                  
                // }
              //   var balances = data.balances;
              //   page.render(balances);

            }
          });
    
          // var csrf = await CSRF.token();
          //   console.log('csrf',csrf);
          //   var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/market',
        //       data: {market:this.currencyPair},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
        //       console.log("place order result",resData); // => e.g. 403
        //       if(resData.flag){
        //         Market.loadingMarket = false;
        //         _.extend(Market, resData);
        //         var market = resData.market;
        //         Market.chartData = Market.market.chartData;
        //         Market.id = market.id;
        //         Market.payments = Market.market && Market.market.feed ? Market.market.feed.payments : [];
        //         //refresh
        //         // setTimeout(() => {
        //         //   Market.refresh(market);
        //         // }, 5000);
                
        //       //hide loading
        
        //         // $(".market .market-pg").hide().addClass("d-none");
        //         // $(".market .loaded").show().removeClass("d-none");
        
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Market.loadingMarket = false;
        
        //         // $(".market .market-pg").hide().addClass("d-none");
        //         // $(".market .error").show().removeClass("d-none");
        //       }
    
    
    
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //     });

        //set intervals
    
        //   io.socket.get("/markets/listen", function gotResponse(data, jwRes) {
        //     console.log('Server responded with status code ' + jwRes.statusCode + ' and data: ', data);
        //   });
        //   io.socket.on(this.market.id, function (market){
        //       console.log("market update",market);
        //       // => 'hi there!'
        //       Market.refresh(market);
        //   });
          
    
    
        },
        refresh: async function(market) {
          /*
            must load
              //last
              //change
              //hight
              //low
              //chart
              //buy orders
              //sell orders
              trade history
    
            personal 
              open orders
              your trades
          */
         Market = this;
         this.market = market;
         this.payments = market.feed.payments;
         Market.updateTicker(market);
         Market.updateChart(market);
         Market.updateOrders(market);
         Market.updateTrades(market);
         if(market.openOrders !== undefined){
          Market.myRefresh(market);
         }
         Market.bindUIActions();  
    
    
        },
        myRefresh:  function(market) {
          /*
            personal 
              open orders
              your trades
          */
         Market = this;
         Market.updateMyOrders(market);
         Market.updateMyTrades(market);
         Market.updateBalances(market);
    
         //refersh balances
    
        },
        updateBalances: function (market) {
          var sellCurrency = market.sellCurrency;
          var buyCurrency = market.buyCurrency;
          var sellBalance = market[sellCurrency];
          var buyBalance = market[buyCurrency];
          console.log("sellCurrency",sellCurrency);
          console.log("buyCurrency",buyCurrency);
          console.log("sellBalance",sellBalance);
          console.log("buyBalance",buyBalance);
          if(sellBalance){
            console.log("sellBalance.spendingBalance - sellBalance.order",sellBalance.spendingBalance - sellBalance.order);
    
            $(".sellBalance .balance").html(sellBalance.spendingBalance - sellBalance.order);
          }
          if(buyBalance){
            console.log("buyBalance.spendingBalance - buyBalance.order",buyBalance.spendingBalance - buyBalance.order);
            $(".buyBalance .balance").html(buyBalance.spendingBalance - buyBalance.order);
          }
    
        },
        updateTicker: function (market) {
          var ticker = market.ticker;
          $(".lastPrice").html(ticker.last);
          $(".change").html(ticker.price_change_percent);
          $(".high").html(ticker.high);
          $(".low").html(ticker.low);
          $(".buyVolume").html(ticker.volume);
          $(".sellVolume").html(ticker.vol);
        },
        updateChart: function (market) {
          // $("#myChart").html("");
          // var chartData = market.chartData;
          // console.log("chartData",chartData);
          // var myChart = document.getElementById("myChart");
          // const chart = LightweightCharts.createChart(myChart, { width: 800, height: 300 });
          // const lineSeries = chart.addLineSeries();
          // lineSeries.setData(chartData.trades);  

          let myChart = document.getElementById("myChart").getContext("2d");
          console.log('myChart',myChart);
          console.log("market",market);
          let massPopCart= new Chart(myChart, {
              type: 'line', //type of chart that we want bar, horizontalBar, pie, line, doughnut, radar, polarArea
              data: {
                  labels: ['Janurary', 'Febraury', 'March', 'April', "May", "June"], //top cities in mass
                  backgroundColor: [
                    'rgba(255,255,255, 0.9)',
                   
                ],
    
                  datasets: [
                    
                    {
                      label: "Payments",
                      data: market.payments.chartData,
                      borderColor: 'green'//['green' , 'blue' ,  'red' , 'organe', 'yellow', 'brown']
                    },{
                      label: "Spending",
                      data: market.costs.chartData,
                      borderColor: 'red'//['green' , 'blue' ,  'red' , 'organe', 'yellow', 'brown']
                    },{
                      label: "Funding",
                      data: market.funds.chartData,
                      borderColor: 'orange'//['green' , 'blue' ,  'red' , 'organe', 'yellow', 'brown']
                    },  {
                      label: "Dividends",
                      data: market.dividends.chartData,
                      // data: [4550,3000,5000,18000,24500],
                      borderColor: 'blue'//['green' , 'blue' ,  'red' , 'organe', 'yellow', 'brown']
                    }

                ]
                  
        
              },
              options: {
                  title: {
                      display: true,
                      text: 'ROI Stats',
                      fontSize: 25
                  },
                  legend: {
                      position: 'right',
                      labels: {
                          fontColor: 'black'
                      }
                  }
              }
          });
          let myTokenChart = document.getElementById("myTokenChart").getContext("2d");
          console.log('myTokenChart',myTokenChart);
          console.log("market",market);
          let massPopTokenCart = new Chart(myTokenChart, {
              type: 'line', //type of chart that we want bar, horizontalBar, pie, line, doughnut, radar, polarArea
              data: {
                  labels: ['Janurary', 'Febraury', 'March', 'April', "May", "June"], //top cities in mass
                  backgroundColor: [
                    'rgba(255,255,255, 0.9)',
                   
                ],
    
                  datasets: [
                    
                    {
                      label: "Price",
                      data: market.prices.chartData,
                      // data: [4550,3000,5000,18000,24500],
                      borderColor: 'black'//['green' , 'blue' ,  'red' , 'organe', 'yellow', 'brown']
                    },
                    // {
                    //   label: "Volume",
                    //   data: market.volumes.chartData,
                    //   // data: [4550,3000,5000,18000,24500],
                    //   borderColor: 'yellow'//['green' , 'blue' ,  'red' , 'organe', 'yellow', 'brown']
                    // },

                ]
                  
        
              },
              options: {
                  title: {
                      display: true,
                      text: 'Token Price',
                      fontSize: 25
                  },
                  legend: {
                      position: 'right',
                      labels: {
                          fontColor: 'black'
                      }
                  }
              }
          });
        },
        updateOrderStatus: function (result) {
          
          if(result.order && result.order.order && result.order.order.flag == false && result.order.order.funded == false){
            $(".order-result").html(result.order.msg);
          }else{
            $(".order-result").html(result.msg);
          }
          $(".order-result").removeClass("pending");
    
          if(result.flag){
            if(result.order && result.order.order && result.order.order.flag == false && result.order.order.funded == false){
              $(".order-result").addClass("text-danger");
            }else{
              $(".order-result").addClass("success");
            }
          }else{
            $(".order-result").addClass("text-danger");
          }
          setTimeout(() => {
            $(".order-result").removeClass("success text-danger pending");
            $(".order-result").html("");
            
          }, 10000);
        },
        updateOrders: function (market) {
          var asks = market.orders.asks;
          var bids = market.orders.bids;
          var total_asks_demand = market.orders.total_asks_demand;
          var total_asks_supply = market.orders.total_asks_supply;
          var total_bids_demand = market.orders.total_bids_demand;
          var total_bids_supply = market.orders.total_bids_supply;
    
          $(".asks tbody").html("");
          $(".bids tbody").html("");
          $(".total-asks-supply").html(total_asks_supply);
          $(".total-asks-demand").html(total_asks_demand);
          $(".total-bids-supply").html(total_bids_supply);
          $(".total-bids-demand").html(total_bids_demand);
          
          asks.forEach(function(ask) {
            var total = ask.price * ask.remainingVolume;
            $(".asks tbody").append(
              $("<tr id='"+ask.id+"'>")
                .append("<td class='price ticker-price'>"+ask.price+"</td>")
                .append("<td class='amount'>"+ask.remainingVolume+"</td>")
                .append("<td class='total'>"+total+"</td>")
                .append("<td class='total'>"+total+"</td>")
            );
          });
          bids.forEach(function(bid) {
            var total = bid.price * bid.remainingVolume;
            $(".bids tbody").append(
              $("<tr id='"+bid.id+"'>")
                .append("<td class='price ticker-price'>"+bid.price+"</td>")
                .append("<td class='amount'>"+bid.remainingVolume+"</td>")
                .append("<td class='total'>"+total+"</td>")
                .append("<td class='total'>"+total+"</td>")
            );
          });
        },
        
        updateMyOrders: function (market) {
          var Market = this;
          var orders = market.openOrders;
          console.log("orders",orders);
          $(".open-orders tbody").html("");
          for (let i = 0; i < orders.length; i++) {
            const order = orders[i];
            if(order.state !== "wait")
              continue;
            // if(order.market !== Market.id)
            //   continue;
            var date = CSRF.timeConverter(order.createdAt);
            console.log("date",date);
            var total = order.price * order.volume;
            console.log("total",total);
            console.log("order",order);
            console.log("order.side",order.side);
            $(".open-orders  tbody").append(
              $("<tr class='trade' id='"+order.id+"'>")
                .append("<td class='market'>"+order.market+"</td>")
                .append("<td class='side type "+order.side+"'>"+order.side+"</td>")
                .append("<td class='price ticker-price'>"+order.price+"</td>")
                .append("<td class='amount'>"+order.originVolume+"</td>")
                .append("<td class='remaining'>"+order.remainingVolume+"</td>")
                .append("<td class='executed'>"+order.executedVolume+"</td>")
                .append("<td class='created'>"+order.createdAt+"</td>")
                .append("<td class=''><a class='cancel' href="+order.id+">Cancel</a></td>")
                
                // .append("<td class='total'>"+total+"</td>")
            );
          }
        },
        updateMyTrades: function (market) {
          var trades = market.tradeHistory;
          var myTrades = [];
          // $(".trade-history tbody").html(`
          //   <tr>
          //     <td> words </td>
          //     <td> words </td>
          //     <td> words </td>
          //     <td> words </td>
          //     <td> words </td>
          //     <td> words </td>
          //     <td> words </td>
          //   </tr>
            
          
          // `);
    
          for (let i = 0; i < trades.length; i++) {
            const trade = trades[i];
            if(trade.state !== "done")
              continue;
            myTrades.push(trade);
          };
          if(myTrades.length > 0){
            setTimeout(function(){ 
              $(".trade-history tbody").html("");
              for (let i = 0; i < myTrades.length; i++) {
                const trade = myTrades[i];
                if(trade.state !== "done")
                  continue;
                // if(trade.market !== Market.id)
                //   continue;
                var date = CSRF.timeConverter(trade.updatedAt);
                if(trade.amount){
                  var amount = trade.amount;
                }else{
                  var amount = trade.executedVolume;
                }
                console.log("date",date);
                var total = parseFloat(trade.price) * parseFloat(amount);
                console.log("total",total);
                console.log("trade",trade);
                
        
                $(".trade-history  tbody").append(
                  $("<tr id='"+trade.id+"'>")
                    .append("<td class='market'>"+trade.market+"</td>")
                    .append("<td class='side type "+trade.side+"'>"+trade.side+"</td>")
                    .append("<td class='state type'>"+trade.state+"</td>")
                    .append("<td class='price ticker-price'>"+trade.price+"</td>")
                    .append("<td class='executed'>"+amount+"</td>")
                    .append("<td class='total'>"+total+"</td>")
                    .append("<td class='created'>"+trade.updatedAt+"</td>")
                );
              };
              
      
            }, 50000);
          }
          
    
    
          
        },
        updateTrades: function (market) {
          var trades = market.trades;
          console.log("trades updateTrades",trades);
          $(".trades tbody").html("");
          trades.forEach(function(trade) {
            var date = CSRF.timeConverter(trade.updatedAt);
            console.log("date",date);
            var total = trade.price * trade.amount;
            console.log("total",total);
            console.log("trade",trade);
    
            $(".trades tbody").append(
              $("<tr id='"+trade.id+"'>")
                .append("<td class='side type "+trade.side+"'>"+trade.side+"</td>")
                .append("<td class='price ticker-price'>"+trade.price+"</td>")
                .append("<td class='amount'>"+trade.amount+"</td>")
                // .append("<td class='total'>"+total+"</td>")
                .append("<td class='total'>"+total+"</td>")
                .append("<td class='date'>"+date+"</td>")
            );
          });
        },
        updateMarketTrades: function (market) {
          var asks = market.orders.asks;
          var bids = market.orders.bids;
          var total_asks_demand = market.orders.total_asks_demand;
          var total_asks_supply = market.orders.total_asks_supply;
          var total_bids_demand = market.orders.total_bids_demand;
          var total_bids_supply = market.orders.total_bids_supply;
    
          $(".asks tbody").html("");
          $(".bids tbody").html("");
          $(".total-asks-supply").html(total_asks_supply);
          $(".total-asks-demand").html(total_asks_demand);
          $(".total-bids-supply").html(total_bids_supply);
          $(".total-bids-demand").html(total_bids_demand);
          
          asks.forEach(function(trade) {
            var total = trade.price * ask.remainingVolume;
            $(".asks tbody").append(
              $("<tr id='"+ask.id+"'>")
                .append("<td class='price ticker-price'>"+ask.price+"</td>")
                .append("<td class='amount'>"+ask.remainingVolume+"</td>")
                .append("<td class='total'>"+total+"</td>")
                .append("<td class='total'>"+total+"</td>")
            );
          });
    
        },
        bindUIActions: function() {
          var Market = this;
          $(".place-order").off("click").on("click", function(event) {
             //set action
             event.preventDefault();
             var action = $( event.target ).hasClass( "buy" )? "buy": "";
             action = $( event.target ).hasClass( "sell" )? "sell": action;
            $(event.target).attr("disabled","disabled");
    
             console.log('action',action);
             var form_id = $( event.target ).parents('form').attr('id');
             console.log('form_id',form_id);
             $("#"+form_id + " .action").val(action);
             var action_value  = $("#"+form_id + " .action").parents('form').attr('id');
             console.log('action_value',action_value);
    
             Market.validateOrder();
           });
          $(".ticker-price").off("click").on("click", function() {
              var price = $(this).html();
              price = parseFloat(price);
              $(".price input").val(price);
              $(".trigger-price input").val(price);
              console.log("price",price);
              Market.updatePrice();
           });
          $(".min-trade, .buyBalance .balance").off("click").on("click", function() {
              var amount = $(this).html();
              $(".cost input").val(amount);
              Market.updateCost();
      
           });
          $(".price-info").off("change").on("change", function() {
              Market.updatePrice();
           });
          // $("#currency_pair, #exchange, #market").off("change").on("change", function() {
          //     Market.loading('on');
          //  });
          $(".cost input").off("change").on("change", function() {
              Market.updateCost();
           });
           Market.activateCancel();
          
        },
        updatePrice : function (){
          var exchangeFee = this.exchangeFee;
          var paymentDecimal = this.paymentDecimal;
          var active_tab = $('.order .tabs .active');
          var href = active_tab.attr('href');
          console.log("price updated",active_tab,href);
    
          
          var price = $(href+" .price input").val();
          var quantity = $(href+" .quantity input").val();
    
          price = parseFloat(price);
          quantity = parseFloat(quantity);
          exchangeFee = parseFloat(exchangeFee);
    
    
          if(price > 0 && quantity > 0){
    
            // var cost = price * quantity;
            // var costFee = cost * exchangeFee;
            if(href == "#buy"){
              var cost = safe.cost("buy",price,quantity,exchangeFee,paymentDecimal);
    
            //   cost = cost + costFee;
            }else{
              var cost = safe.cost("sell",price,quantity,exchangeFee,paymentDecimal);
              //   cost = cost - costFee;
            }
          }
          $(href+" .cost input").val(cost);
          $(".price-label").addClass('active');
      
        },
        updateCost : function (){
          var exchangeFee = this.exchangeFee;
          var paymentDecimal = this.paymentDecimal;
          var active_tab = $('.order .tabs .active');
          var href = active_tab.attr('href');
          var price = $(href+" .price input").val();
          var cost = $(href+" .cost input").val();
    
          price = parseFloat(price);
          cost = parseFloat(cost);
          exchangeFee = parseFloat(exchangeFee);
    
    
    
         
          // var costFee = cost * exchangeFee;
          if(price > 0){
            if(href == "#buy"){
              var quantity = safe.quantity("buy",cost,price,exchangeFee,paymentDecimal);
      
              // var quantity = cost/(price + (price * exchangeFee) ); 
            }else{
              var quantity = safe.quantity("sell",cost,price,exchangeFee,paymentDecimal);
      
              // var quantity = cost/(price - (price * exchangeFee) ); 
            }
    
          }
          
    
    
          $(href+" .quantity input").val(quantity);
          $(href+" .price-label").addClass('active');
          Market.updatePrice();
        },
        validateOrder: function(){
          var Market = this;
          var active_tab = $('.order .tabs .active');
          var href = active_tab.attr('href');
          var price = $(href+" .price input").val();
          var cost = $(href+" .cost input").val();
          var quantity = $(href+" .quantity input").val();
          var min_trade = $(href+".min_trade").val();
          var message = "";
         // $("#place-order").validate();
          var error = false;
         // Market.placeOrder();
         $(".price input,.quantity input,.cost input").removeClass("invalid");
          if (price <= 0) {
            // $(".price label").attr("data-error","wrong");
            $(".price input").addClass("invalid");
            message =  "Invaid Price";
            error = true;
          }else if (quantity <= 0) {
            // $(".quantity label").attr("data-error","wrong");
            $(".quantity input").addClass("invalid");
            message =  "Invaid Quantity";
            error = true;
          }else if (cost < min_trade) {
            // $(".cost label").attr("data-error","wrong");
            $(".cost input").addClass("invalid");
            var cash =  $('.cash').html();
            message =  "Mininum Total Cost " + min_trade + " "+ cash;
            error = true;
          }
          $('.error').html("");
          if (error) {
            console.log('error found href',href);
            $(href +' .error').html(message).show();
            $(".place-order").removeAttr("disabled");
            
    
          }else{
            $(href +' .error').html(message).hide();
            Market.placeOrder(href);
          }
          setTimeout(function(){ $('.error, .success').hide(); }, 30000);
    
      
        },
        placeOrder: async function(form_id){
            var Market = this;
            var order =  $(form_id).serializeArray();
            order = CSRF.objectifyForm(order);
            $(".place-order").attr("disabled","disabled");
            $(".order-result").html("Your order is being placed");
            $(".order-result").addClass("pending");
            Market.syncing = true;
    
    
            console.log("order",order);
            // return io.socket.post('/markets/orders', order, function (resData, jwRes) {
            //   jwRes.statusCode; // => 200
            //   console.log('jwRes.statusCode',jwRes.statusCode);
            //   console.log('resData',resData);
            // });

            var apiRequestHeader = {
              // 'X-CSRF-Token':csrf._csrf,
              'X-CSRF-Token':"test",
                // 'cookie':cookie
            };
            jQuery.ajax({
              type: "POST",
              url: '/wp-json/yohshow/api/v1/markets/orders',
              data: order,
              headers:apiRequestHeader,
              success: async function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  console.log("place order result",resData); // => e.g. 403
                  Market.updateOrderStatus(resData);
                  if(resData.flag){
                    // // check to see if order is funded
                    if(resData.order && resData.order.order && resData.order.order.flag == false && resData.order.order.funded == false){
          
                    }else{
                      Market.refresh(resData.market);
                    }
                    
          
                  }
                  $(".place-order").removeAttr("disabled");
                      
                    }
                  });
    
          //   var csrf = await CSRF.token();
          //   console.log('csrf',csrf);
          //   console.log('form_id',form_id);
          //   console.log('order',order);
          //   var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          //  return io.socket.request({
          //   method: 'post',
          //   url: '/wp-json/yohshow/api/v1/markets/orders',
          //   data: order,
          //   headers: apiRequestHeader
          // }, function (resData, jwres) {
          //   console.log("place order result",resData); // => e.g. 403
          //   Market.updateOrderStatus(resData);
          //   if(resData.flag){
          //     // // check to see if order is funded
          //     if(resData.order && resData.order.order && resData.order.order.flag == false && resData.order.order.funded == false){
    
          //     }else{
          //       Market.refresh(resData.market);
          //     }
              
    
          //   }
          //   $(".place-order").removeAttr("disabled");
    
    
    
          //   if (jwres.error) {
          //     console.log(jwres.statusCode); // => e.g. 403
          //     return;
          //   }
          
          //   console.log(jwres.statusCode); // => e.g. 200
          
          // });
    
        },
      
        activateCancel:function(status){
          var Market = this;
          console.log("activated cancel");
          $(".cancel").off("click").on("click", function(event) {
            //set action
            event.preventDefault();
            var id = $(event.target).attr("href");
            $(event.target).hide();
            Market.cancelTrade(id);
          });
        },
        cancelTrade: async function (id) {
          var Market = this;
          console.log("cancel order",id);
          $("#"+id).remove();
    
          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
                url: "/markets/orders/cancel",
                data: {orderId:id}, // serializes the form's elements.
                // headers:apiRequestHeader,
                success: function(data, textStatus, request)
                {
                    console.log('got markets the data!!!',data); // show response from the php script.
                    if(data.flag){
                      Market.updateBalances(data.order.balances);
    
                      console.log('remove '+"#"+id);
                        $("#"+id).remove();
                    }
                  //   var balances = data.balances;
                  //   page.render(balances);
    
                }
              });
          // window.location = '/';
        },
    
      }



  });

});

