/**
 * <pay-now>
 * -----------------------------------------------------------------------------
 * pay-now.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('payNow', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
         // Form data
        formData: { /* … */ },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // Syncing / loading state
        syncing: false,

        // Server error state
        cloudError: '',

        // Success state when form has been submitted
        cloudSuccess: false,
        loadingPayNow: true,
        cloudLoadingError: '',

        checkoutId:"",
        orderId:"",
        noOrderSet:"",
        displayPrice:"",
        lineItem:{},
        transactionType:"",
        primeTrustForcePayment:"",
        externalPaymentMethods:[],
        internalPaymentMethods:[],
        externalBuyOk:"",
        internalBuyOk:"",
        checkoutAction:"",
        paymentMethods:[],
        checkout:{},
        redirect:"",
        stableToken:{},
        sellCurrency:{},
        flag:true,
        environment:"",
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="pay-now-component">
      <div v-if="loadingPayNow" class="text-center mt-5 container">
        <h1>Your order is being loaded...</h1>
        <ajax-button type="submit" :syncing="loadingPayNow" class="btn btn-primary mint">Refesh</ajax-button>
      </div>
      <div v-else="">
        <div class="container" v-if="!cloudSuccess">
          <h1 class="text-center mt-5">Confirm and Pay</h1>
          <!-- {{orderId}} -->
          <!-- {{checkout}} -->
          <!-- {{checkout.financial_status}} -->
      
          <!--
      
            once ation per checkout
            based off action show price and what they are payin for
      
            actions
            buyUnits
            mint token
            buy debt card
            buyCard
            mint
      
            select payment method
            paymentMethods
      
      
            ----------
            needs
              title//
              quanity//
              price//
              description //
              sub total //
              total//
      
      
          -->
      
          <div class="signup-form">
            <!-- <hr/> -->
            <ajax-form action="updateCheckoutPaymentMethod" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">
            <!-- <ajax-form action="payCheckout" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm"> -->
              <div :class="stableToken.shopifyBuyProductHandle +' '+ stableToken.symbol + ' form-group  united-product'">
                <!-- <ajax-button type="submit" :syncing="syncing" class="btn-dark btn-lg btn-block">Place Order</ajax-button> -->
                <div id="root" class="united-product text-center float-none pt-5 pb-5 col-md-5 ml-auto mr-auto border border-dark">
                  <div class="row">
                          <h6 class="text-center col-12 blue">{{checkout.title}}   </h6>
                          <div class="col-12">
                              <!-- <br><br> -->
                              <!-- {{checkout.description}} <br><br> -->
                              <!-- 💳+ 💰= 😊 <br><br>
                              Buy the UnitedCoin Card one time and get...<br><br><br>
                              ▪️No Monthly Fees ▪️Direct Deposit<br><br>
                              ▪️No Annual Fees ▪️Virtual Debit Card<br><br>
                              ▪️No Account Fees ▪️Physical Debit Card<br><br>
                              ▪️No Minimum Balance ▪️Access to Cash at ATMs <br><br>
                              ▪️No Credit Check ▪️Send Money Worldwide <br><br>
                              ▪️No Interest ▪️Deposit Cryptocurrencies<br><br><br>
                              ⭐️2% CoinBack UNITS Rewards on All Purchases ⭐️<br><br><br><br> -->
      
                              <!-- <br><br><br><br> -->
                          </div>
                          <hr>
                          <div class="col-12 " title="52.08 USD">
                                <!-- <span class="value price"> </span>
                                &nbsp;
                                <span class="payment-currency">USD</span> -->
                                <div class="form-group text-left">
                                    <label class="control-label" for="price">Price</label>
                                    <br><br>
                                    <div>$ 
                                      <span v-if="displayPrice" class="price">{{ parseFloat(displayPrice).toFixed(2) }}</span>
                                      <span v-else="" class="price">{{ parseFloat(checkout.sub_total).toFixed(2) }}</span>
                                    </div>
                                    <!-- <div>$ <span class="price">{{ checkout.price.toFixed(2) }}</span></div> -->
                                    <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                </div>
                                <div class="form-group text-left">
                                  <label class="control-label" for="quantity">Quantity</label>
                                  <br><br>
                                  <div> <span class="quantity sellCurrency-quantity">{{ checkout.quantity }}</span></div>
                                  <!-- <div class="invalid-feedback" v-if="formErrors.quantity">Please enter how much you wan to buy </div> -->
                                  <!-- <small id="quantityHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                              </div>
                              <div class="form-group text-left">
                                  <label class="control-label" for="total">Subtotal</label>
                                  <br><br>
                                  <div>$ 
                                    <span v-if="transactionType == 'sell' && displayPrice" class="total">{{parseFloat(checkout.sub_total).toFixed(2)}}</span>
                                    <span v-else-if="transactionType == 'sell'" class="total">{{parseFloat(checkout.total_charge).toFixed(2)}}</span>
                                    <span v-else="" class="total">{{parseFloat(checkout.sub_total).toFixed(2)}}</span>
                                  </div>
                              </div>
                              <div class="form-group text-left">
                                  <label class="control-label" for="total">Fee</label>
                                  <br><br>
                                  <div>$ 
                                    <span  v-if="displayPrice"  class="total">0.00</span>
                                    <!-- <span   class="total">{{parseFloat(checkout.fee).toFixed(2)}}</span> -->
                                    <span  v-else=""  class="total">{{parseFloat(checkout.fee).toFixed(2)}}</span>
                                  </div>
                              </div>
                              <div class="form-group text-left">
                                  <label class="control-label" for="total">Total</label>
                                  <br><br>
                                  <div>$ 
                                    <span v-if="transactionType == 'sell'" class="total">{{parseFloat(checkout.sub_total).toFixed(2)}}</span>
                                    <span v-else="" class="total">{{parseFloat(checkout.total_charge).toFixed(2)}}</span>
                                  </div>
                                  <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                              </div>
                              <div v-if="checkout.portfolioId && checkout.portfolioId != 'once'"  class="form-group text-left">
                                <label class="control-label" for="total">Frequency</label>
                                <br><br>
                                <div>
                                  <span  class="frequency" style="text-transform: capitalize;">{{checkout.frequency}} </span>
                                </div>
                                <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                            </div>
                            <div v-if="checkout.portfolioId && checkout.portfolioId != 'none'"  class="form-group text-left">
                                <label class="control-label" for="total">Frequency</label>
                                <br><br>
                                <div>
                                  <span  class="portfolioId" style="text-transform: capitalize;">{{checkout.portfolioId.name}} </span>
                                </div>
                                <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                            </div>
      
                          </div>
      
                    </div>
                    <div class="row">
                      <div v-if="(externalPaymentMethods.length > 0 || internalPaymentMethods.length > 0 ) && transactionType !== 'sell'"  class="col-12">
                        <div  class="form-group text-left">
                          <label for="transfer-type">Payment Method</label>
                          <br><br>
                          <select v-if="externalPaymentMethods.length > 0 || internalPaymentMethods.length > 0" class="form-control"  id="paymentMethod" type="text"  :class="[formErrors.paymentMethod ? 'is-invalid' : '']" v-model.trim="formData.paymentMethod" focus-first>
                          <!-- <select class="form-control" @change="changeTransferType" id="transferType" type="text"  :class="[formErrors.transferType ? 'is-invalid' : '']" v-model.trim="formData.transferType" focus-first> -->
                            <option v-for="paymentMethod in externalPaymentMethods" selected="selected" :value="paymentMethod.id">{{paymentMethod.name}}</option>
                            <option v-for="paymentMethod in internalPaymentMethods" selected="selected" :value="'internal_'+paymentMethod.id">{{paymentMethod.name}} - {{paymentMethod.spendingBalance}} {{paymentMethod.currency.symbolBase}}</option>
                            <!-- <option v-if="me.primeTrustChargeCardFundsTransferMethodId" selected="selected" value="card">My Card</option> -->
                            <!-- <option v-if="me.primeTrustChargeBankFundsTransferMethodId"  value="bank">My Bank</option> -->
                            <!-- <option value="deposit">Deposit</option> -->
                            <!-- <option value="external">Withdrawal</option> -->
                          </select>
                          <!-- <router-link class="link" :to="'/payment-methods/'+checkout.checkout_token_base" >+ Add Payment Method</router-link> -->
                          <!-- <div class="invalid-feedback" v-if="formErrors.paymentMethod">Select your payment method.</div> -->
                          <!-- <div class="danger pt-3" v-if="!me.primeTrustChargeCardFundsTransferMethodId && !me.primeTrustChargeBankFundsTransferMethodId">Add a valid payment method.</div> -->
                          <!-- <small id="adminHelp" class="form-text text-muted">How would you like to fund this payment?</small> -->
                          <div class="invalid-quantity text-danger" v-if="formErrors.invalidQuantity">The total charge exceeds your available balance</div>
      
                          <br>
                          <router-link :to="'/payment-methods/pay-now/'+checkout.checkout_token_base" class="">Update Payment Method</router-link>
                          <br>
                          <br>
                        </div>
                      </div>
      
                      <div class=" col-12  row p-0 m-0" >
                        <!-- {{checkout}} -->
                        <router-link v-if="checkout.financial_status == 'paid' && checkout.quoteId && !checkout.primeTrustQuoteExecuted && transactionType == 'buy'" class="col-12 btn btn-primary" :to="'/checkout/'+checkout.id">Confirm Buy</router-link>
                        <router-link v-if="checkout.financial_status == 'paid' && checkout.quoteId && !checkout.primeTrustQuoteExecuted && transactionType == 'sell'" class="col-12 btn btn-primary" :to="'/checkout/'+checkout.id">Confirm Sell</router-link>
                        <router-link v-else-if="checkout.financial_status == 'paid'" class="col-12 btn btn-primary" :to="'/orders/checkout/refresh/'+checkout.id">Refresh</router-link>
                        
                        <router-link v-else-if="transactionType == 'sell'" class="col-12 btn btn-primary" :to="'/checkout/'+checkout.id">Confirm Sell</router-link>
                        
                        <router-link v-else-if="externalPaymentMethods.length == 0 && internalPaymentMethods.length == 0"   :to="'/payment-methods/'+checkout.checkout_token_base"class="col-12 btn btn-primary">Add Payment Method</router-link>
                        <!-- <router-link v-else-if="!me.primeTrustKycComplete"  to="/kyc" class="col-12 btn btn-primary">Refresh Verification Status</router-link> -->
      
                        <ajax-button v-else=""   type="submit" :syncing="syncing" class="col-12 btn btn-primary">Checkout</ajax-button>
                        <!-- <button class="col-12 btn btn-primary fast-cart">Pay Now</button> -->
                        <input type="hidden" class="shopifyVariantId" value="" >
                        <input type="hidden" class="productId" :value="stableToken.productId" >
                        <input type="hidden" class="title" :value="stableToken.name" >
                        <input type="hidden" class="img" :value="stableToken.logo" >
                        <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                        <input type="hidden" class="variantPrice" :value="stableToken.price" >
                        <!-- <input type="hidden" class="sellCurrencyId" :value="sellCurrency.id" > -->
                        <input type="hidden" class="checkoutId" v-model.trim="checkoutId" >
      
      
                        <!-- {{buyCurrency.price}} -->
                        <input type="hidden" class="quantity" value="1" >
                        <token-cart-modal id="token-cart" :payment-methods="paymentMethods" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>
      
                        <!-- <cart-modal id="cart" :environment="environment" :syncing="syncing" :sell-currency-id="sellCurrency.exchangeTokenId" :checkout-redirect="redirect" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
                      </div>
                    </div>
      
                </div>
      
      
      
                <!-- <buy-button id="cart"  ></buy-button>  -->
                <div id='product-component-1575250675382'></div>
      
                <!-- <div id="bestrate-payout"></div> -->
      
              </div>
            </ajax-form>
          </div>
        </div>
        <div class="container" v-if="cloudSuccess">
          <h1 class="text-center">Check your email!</h1>
          <div class="success-message">
            <hr/>
            <p>Your account is nearly ready. All you have to do is click the link we sent to <strong>{{formData.emailAddress}}</strong>.</p>
            <p>(You can still access your dashboard now, but some features will be unvavailable until we've verified your email address.)</p>
            <p><router-link class="btn btn-outline-info" to="/">Go to dashboard</router-link></p>
          </div>
        </div>

      </div>


    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.checkoutToken = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);
          this.formData.checkoutId = this.checkout.id;
        if(this.externalPaymentMethods.length > 0){
        this.formData.paymentMethod = this.externalPaymentMethods[0].id;
        }
        await this.listen();  

    },
    mounted: async function() {
        // this.widget = BRPayoutWidget.init("bestrate-payout", "44830270d912bf6ef75299c14c3b8eaf");

        // console.log("this.widget",this.widget);
        // this.widget.send({},{},{redirectUrl:"/placed-order"});
        // widget.send({email:'test@test.com'},{'Field 1':'Some text'},{});
        var payOrder = this;
        // payOrder.syncing = true;


        //   console.log("fast-cart length",$(".fast-cart").length);
        // $(".sellCurrency-quantity").change();
        await payOrder.updateQuantity();

        //   $(".fast-cart").on("click", function(event) {
        //     payOrder.syncing = true;
        //     console.log("payOrder.syncing",payOrder.syncing);
            
        //  });
        await payOrder.purchaseInit();
    
    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

        listen: async function() {
          var PayNow = this;
          //show loading// syincing
          this.loadingPayNow = true;
          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
				        url: '/wp-json/yohshow/api/v1/payNow' ,

                data: {checkoutToken:this.checkoutToken,orderId:this.orderId},
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                    resData = JSON.parse(resData);

                    if(resData.flag){
                        _.extend(PayNow, resData);
                        //if this his supposed to be paid else where
                        //like woocommcer checkout
                        if(resData.checkoutAction == "sell" || resData.checkoutAction == "sellUnits"  ){
                          PayNow.$router.push(resData.checkout_url);
                          PayNow.loadingPayNow = false;


                        }else{
                          if(resData.checkout_url){
                            PayNow.loadingPayNow = true;

                            location.replace(resData.checkout_url);
                            // window.location.to = resData.checkout_url;
                          }
                        }
                        

            
                      }else if(resData.mustLogin){
                        window.location.to = resData.redirect;
                      } else{
                        PayNow.loadingPayNow = false;
                      }
    
                }
              });
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/payNow',
        //       data: {checkoutToken:this.checkoutToken,orderId:this.orderId},
        //       // data: {},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(PayNow, resData);
        //         PayNow.loadingPayNow = false;
    
        //       }else if(resData.mustLogin){
        //         window.location.to = resData.redirect;
        //       } else{
        //         PayNow.loadingPayNow = false;
        //       }
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
        },
        
        purchaseInit: async function(){
          var amount = this.checkout.total_charge;
          var fundsTransferMethodId = this.fundsTransferMethodId;
          console.log("[primetrust] 1. Loading Prime Trust Embedding API");
          window.onPurchaseProtectionReady = function (purchaseProtection) {
              console.log("[primetrust] 2. Loading embedded account creation...");
              purchaseProtection.start3DS({
                amount: amount,
                fundsTransferMethodId: fundsTransferMethodId,
              }).then(
                (challengeId) => console.log("3ds successfulid: ", challengeId)
              ).catch(
                (err) => console.log("Err: ", err)
              );
          };
    
    
        },
        updateQuantity: async function(){
    
        },
        submittedForm: async function(data) {
          this.syncing = true;
          console.log("data",data);
          console.log("data.flag",data.flag);
          if(data.flag){
            console.log("data.checkoutId",data.checkoutId);
            // window.location.to = "/checkout/"+ data.checkoutId;
            Cart.$router.push("/checkout/"+ data.checkoutId);
          }
    
        },
        submittedFormOld: async function(data) {
          this.syncing = true;
          console.log("data",data);
          console.log("data.flag",data.flag);
          if(data.flag){
            console.log("data.redirect",data.redirect);
            window.location.to = data.redirect;
          }
          // if(this.isEmailVerificationRequired) {
          //   // If email confirmation is enabled, show the success message.
          //   this.cloudSuccess = true;
          // }
          // else {
          //   // Otherwise, redirect to the logged-in dashboard.
          //   // > (Note that we re-enable the syncing state here.  This is on purpose--
          //   // > to make sure the spinner stays there until the page navigation finishes.)
          //   this.syncing = true;
          //   window.location = '/pay-order';
          // }
        },
    
        handleParsingForm: function() {
          // Clear out any pre-existing error messages.
          this.formErrors = {};
          this.formData.checkoutId =  this.checkoutId;
          var argins = this.formData;
          var checkout = this.checkout;
          var internalPaymentMethods = this.internalPaymentMethods;
          var me = this.me;
          var paymentMethodId = argins.paymentMethod;
    
          // Validate first name:
          if(!argins.paymentMethod) {
            this.formErrors.paymentMethod = true;
          }
          // if(!me.primeTrustChargeCardFundsTransferMethodId && !me.primeTrustChargeBankFundsTransferMethodId) {
          //   this.formErrors.noPaymentMethod = true;
          // }
    
          var isInteral = paymentMethodId.startsWith("internal_");
          if(isInteral){
            var fromAccountId = paymentMethodId.split("internal_");
            fromAccountId = fromAccountId[1];
            var total = parseFloat(checkout.total_charge);
            var funded = true;
            for (let i = 0; i < internalPaymentMethods.length; i++) {
              const paymentMethod = internalPaymentMethods[i];
              if(fromAccountId == paymentMethod.id){
                var spendingBalance = paymentMethod.spendingBalance;
                if(total > spendingBalance){
                  var funded = false;
                }
              }
              
            }
            if(!funded){
              this.formErrors.invalidQuantity = true;
    
            }
           
          }
    
    
            
            
    
    
          // If there were any issues, they've already now been communicated to the user,
          // so simply return undefined.  (This signifies that the submission should be
          // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
    
    }



  });

});

