/**
 * <quote>
 * -----------------------------------------------------------------------------
 * quote.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('quote', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
         // Form data
        formData: { /* … */ },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // Syncing / loading state
        syncing: false,

        // Server error state
        cloudError: '',

        // Success state when form has been submitted
        cloudSuccess: false,

        buyStableUnitsLink:'',
        isStableToken:'',
        paymentMethods:[],
        portfolios:[],
        
        redirect:'',
        stableToken:'',
        sellCurrency:{},
        flag:'',
        environment:'',
        symbol:'',
        tradeType:'',

        fromAccount:{},
        hasToBuy:"",
        hasSellBalance:"",

        
        

        loadingQuote: true,
        cloudLoadingError: '',
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="quote-component">
          <div class="container" v-if="!cloudSuccess">
          <div v-if="loadingQuote" class="text-center">
            <h1>Your quote is being prepared...</h1>
            <ajax-button type="submit" :syncing="loadingQuote" class="btn btn-primary mint">Refesh</ajax-button>
          </div>
          <div v-else-if="tradeType == 'buy'">
              <h1 class="text-center mt-5">Confirm and Pay</h1>
              <!-- {{orderId}} -->

              <div class="signup-form">
                <!-- <hr/> -->
                <ajax-form action="login" :syncing.sync="syncing" v-bind:syncing.sync="syncing"  :cloud-error.sync="cloudError" @submitted="submittedForm()" :handle-parsing="handleParsingForm">
                  <div :class="stableToken.shopifyBuyProductHandle +' '+ stableToken.symbol + ' form-group  united-product'">
                    <!-- <ajax-button type="submit" :syncing="syncing" class="btn-dark btn-lg btn-block">Place Order</ajax-button> -->
                    <div id="root" class="united-product united-token-product text-center float-none pt-5 pb-5 col-md-5 ml-auto mr-auto border border-dark">
                      <div class="row">
                              <h3 class="text-center col-12 blue">Buy {{sellCurrency.name}}  {{sellCurrency.symbolBase}}   </h3>
                              <div class="col-12">
                                  <br><br>
                                  Pay with cryptocurrency and have access to cash<br><br>
                                  <!-- 💳+ 💰= 😊 <br><br>
                                  Buy the UnitedCoin Card one time and get...<br><br><br>
                                  ▪️No Monthly Fees ▪️Direct Deposit<br><br>
                                  ▪️No Annual Fees ▪️Virtual Debit Card<br><br>
                                  ▪️No Account Fees ▪️Physical Debit Card<br><br>
                                  ▪️No Minimum Balance ▪️Access to Cash at ATMs <br><br>
                                  ▪️No Credit Check ▪️Send Money Worldwide <br><br>
                                  ▪️No Interest ▪️Deposit Cryptocurrencies<br><br><br>
                                  ⭐️2% CoinBack UNITS Rewards on All Purchases ⭐️<br><br><br><br> -->

                                  <!-- <br><br><br><br> -->
                              </div>
                              <hr>
                              <div class="col-12 " title="52.08 USD">
                                    <!-- <span class="value price"> </span>
                                    &nbsp;
                                    <span class="payment-currency">USD</span> -->
                                    <div class="form-group text-left">
                                        <label class="control-label" for="price">Price</label>
                                        <br><br>
                                        <div>$ <span class="price">{{ parseFloat(sellCurrency.price) }}</span></div>
                                        <!-- <div>$ <span class="price">{{ parseFloat(sellCurrency.price).toFixed(2) }}</span></div> -->
                                        <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                    </div>
                                    <div class="form-group text-left">
                                      <label class="control-label" for="quantity">Quantity</label>
                                      <br>
                                      <div class="row p-3" >
                                        <input @change="updateQuantity" class="form-control sellCurrency-quantity col-sm-10 " min=".00001" steps=".00001" value="1" :class="[formErrors.quantity ? 'is-invalid' : '']"  type="number"  aria-describedby="quantityHelp"   >
                                        <span class="col-sm-1 " > {{sellCurrency.symbolBase}} </span>
                                      </div>
                                      
                                      <input  class="form-control quantity" min=".00001" steps=".00001" value="1" :class="[formErrors.quantity ? 'is-invalid' : '']"  id="quantity" name="quantity" type="hidden"  aria-describedby="quantityHelp"   >
                                      <div class="invalid-feedback" v-if="formErrors.quantity">Please enter how much you want to buy </div>
                                      <!-- <small id="quantityHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                      <small class="invalid-quantity error  danger" style="display:none">This quantity exceeds your available balance</small>

                                  </div>
                                  <div class="form-group text-left">
                                      <label class="control-label" for="total">Total</label>
                                      <br>
                                      <div class="d-none">$ <span class="total">{{sellCurrency.displayPrice? sellCurrency.displayPrice : sellCurrency.price }}</span></div>
                                      <div class="row p-3" >
                                        <input @change="updateCost" value="" class="form-control sellCurrency-total col-sm-10 " min=".00001" steps=".00001" value="1" :class="[formErrors.total ? 'is-invalid' : '']"  type="number"  aria-describedby="totalHelp"   >
                                        <span class="col-sm-1 " > USD</span>
                                      </div>
                                      

                                      <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                  </div>
                                  <div class="form-group text-left">
                                      <label class="control-label" for="total">Frequency</label>
                                      <br><br>
                                      <div>
                                        <select name="frequency" id="frequency" class="form-control frequency">
                                          <option value="once">One Time</option>
                                          <option value="hourly">Hourly</option>
                                          <option value="daily">Daily</option>
                                          <option value="weekly">Weekly</option>
                                          <option value="monthly">Monthly</option>
                                        </select>
                                      </div>
                                      <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                  </div>
                                  <div class="danger invalid-minBuyValue" style="display:none">The value of this order must be equal to or exceed {{parseFloat(minBuyValue).toFixed(2)}} USD</div>

                                  <div class="form-group text-left">
                                      <label class="control-label" for="total">Portfolio</label>
                                      <br><br>
                                      <div>
                                        <select name="portfolioId" id="portfolioId" class="form-control portfolioId">
                                          <option v-for="portfolio in portfolios" :id="portfolio.id" :value="portfolio.id">{{portfolio.name}}</option>
                                          <option  id="none" value="">None</option>
                                       
                                        </select>
                                      </div>
                                      <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                  </div>
                                  <div class="danger invalid-minBuyValue" style="display:none">The value of this order must be equal to or exceed {{parseFloat(minBuyValue).toFixed(2)}} USD</div>

                              </div>

                        </div>
                        <div class="row">
                          <div v-if="paymentMethods.length > 0 && !isStableToken"  class="col-12 d-none">
                            <div  class="form-group text-left">
                              <label for="transfer-type">Payment Method</label>
                              <br><br>
                              <select v-if="paymentMethods.length > 0" class="form-control paymentMethod"  id="paymentMethod" type="text"  :class="[formErrors.paymentMethod ? 'is-invalid' : '']" v-model.trim="formData.paymentMethod" focus-first>
                              <!-- <select class="form-control" @change="changeTransferType" id="transferType" type="text"  :class="[formErrors.transferType ? 'is-invalid' : '']" v-model.trim="formData.transferType" focus-first> -->
                                <option v-for="paymentMethod in paymentMethods" selected="selected" :value="paymentMethod.id">{{paymentMethod.name}} - {{paymentMethod.spendingBalance}} {{paymentMethod.currency.symbolBase}}</option>
                                <!-- <option v-if="me.primeTrustChargeCardFundsTransferMethodId" selected="selected" value="card">My Card</option> -->
                                <!-- <option v-if="me.primeTrustChargeBankFundsTransferMethodId"  value="bank">My Bank</option> -->
                                <!-- <option value="deposit">Deposit</option> -->
                                <!-- <option value="external">Withdrawal</option> -->
                              </select>

                              <!-- <a class="link" :href="'/payment-methods/'+checkout.checkout_token_base" >+ Add Payment Method</a> -->
                              <!-- <div class="invalid-feedback" v-if="formErrors.paymentMethod">Select your payment method.</div> -->
                              <!-- <div class="danger pt-3" v-if="!me.primeTrustChargeCardFundsTransferMethodId && !me.primeTrustChargeBankFundsTransferMethodId">Add a valid payment method.</div> -->
                              <!-- <small id="adminHelp" class="form-text text-muted">How would you like to fund this payment?</small> -->
                              <br>
                              <br>
                              <br>
                            </div>
                          </div>
                          <div class=" col-12" >
                            <!-- {{stableToken}} -->
                            <!-- {{sellCurrency}} -->
                            <!-- {{paymentMethods}} -->
                            <!-- works with token cart -->
                            
                            <a v-if="paymentMethods.length == 0 && !isStableToken" :href="buyStableUnitsLink" class="col-12 btn btn-primary">Deposit Stable Units</a>
                            <!-- <button v-else="" class="col-12 btn btn-primary fast-cart">Buy Now</button> -->
                            <ajax-button v-else="" :syncing="syncing" class="col-12 btn btn-primary fast-cart">Buy Now</ajax-button>

                            <input type="hidden" class="shopifyVariantId" value="" >
                            <input type="hidden" class="tradeType" value="buy" >
                            <!-- <input type="hidden" class="productId" :value="stableToken.buyProductId" >
                            <input type="hidden" class="title" :value="stableToken.name" >
                            <input type="hidden" class="img" :value="stableToken.logo" >
                            <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                            <input type="hidden" class="variantPrice" :value="stableToken.price" > -->

                            <input type="hidden" class="productId" :value="stableToken.buyProductId" >
                            <!-- <input type="hidden" class="productId" :value="sellCurrency.id" > -->
                            <input type="hidden" class="title" :value="sellCurrency.name" >
                            <input type="hidden" class="img" :value="sellCurrency.logo" >
                            <input type="hidden" class="shopifyHandle" :value="sellCurrency.shopifyBuyProductHandle" >
                            <input type="hidden" class="variantPrice" :value="sellCurrency.price" >
                            <input type="hidden" class="sellCurrencyId" :value="sellCurrency.id" >
                            <!-- <input type="hidden" class="tokenId" :value="sellCurrency.id" > -->
                            <!-- <input type="hidden" class="price" :value="stableToken.price" > -->
                            <input type="hidden" class="type" value="token" >
                            <!-- <input type="hidden" class="quantity" value="1" > -->


                            <!-- {{buyCurrency.price}} -->
                            <!-- <input type="hidden" class="quantity" value="1" > -->
                            <!-- <cart-modal id="cart" :environment="environment" :syncing="syncing" :sell-currency-id="sellCurrency.exchangeTokenId" :checkout-redirect="redirect" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
                            <token-cart-modal id="token-cart"  :validate-payment-method="false" :payment-methods="paymentMethods" :environment="environment" :syncing="syncing" :sell-currency-id="sellCurrency.exchangeTokenId" :checkout-redirect="redirect" checkout-action="buyUnits" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>


                          </div>
                        </div>

                    </div>



                    <!-- <buy-button id="cart"  ></buy-button>  -->
                    <div id='product-component-1575250675382'></div>

                    <!-- <div id="bestrate-payout"></div> -->

                  </div>
                </ajax-form>
              </div>

          </div>
          <div v-else-if="tradeType == 'sell'">
            <h1 class="text-center mt-5">Confirm and Sell</h1>
            <!-- {{orderId}} -->
        
            <div class="signup-form">
              <!-- <hr/> -->
              <ajax-form action="login" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm()" :handle-parsing="handleParsingForm">
                <div :class="stableToken.shopifyBuyProductHandle +' '+ stableToken.symbol + ' form-group  united-product'">
                  <!-- <ajax-button type="submit" :syncing="syncing" class="btn-dark btn-lg btn-block">Place Order</ajax-button> -->
                  <div id="root" class="united-product united-token-product text-center float-none pt-5 pb-5 col-md-5 ml-auto mr-auto border border-dark">
                    <div class="row">
                            <h3 class="text-center col-12 blue">Sell {{sellCurrency.name}}   </h3>
                            <div class="col-12">
                                <br><br>
                                Sell your cryptocurrency<br><br>
                                <!-- 💳+ 💰= 😊 <br><br>
                                Buy the UnitedCoin Card one time and get...<br><br><br>
                                ▪️No Monthly Fees ▪️Direct Deposit<br><br>
                                ▪️No Annual Fees ▪️Virtual Debit Card<br><br>
                                ▪️No Account Fees ▪️Physical Debit Card<br><br>
                                ▪️No Minimum Balance ▪️Access to Cash at ATMs <br><br>
                                ▪️No Credit Check ▪️Send Money Worldwide <br><br>
                                ▪️No Interest ▪️Deposit Cryptocurrencies<br><br><br>
                                ⭐️2% CoinBack UNITS Rewards on All Purchases ⭐️<br><br><br><br> -->
        
                                <!-- <br><br><br><br> -->
                            </div>
                            <hr>
                            <div class="col-12 " title="52.08 USD">
                                  <!-- <span class="value price"> </span>
                                  &nbsp;
                                  <span class="payment-currency">USD</span> -->
                                  <div class="form-group text-left">
                                      <label class="control-label" for="price">Price</label>
                                      <br><br>
                                      <div>$ <span class="price">{{ parseFloat(sellCurrency.price).toFixed(3) }}</span></div>
                                      <!-- <small id="priceHelp" class="form-text text-muted">How much money would you like to raise?</small> -->
                                  </div>
                                  <div class="form-group text-left">
                                    <label class="control-label" for="quantity">Quantity {{hasToBuy ? "has to buy":"does no have to buy"}}</label>
                                    <br><br>
                                    <input @change="updateQuantity" class="form-control sellCurrency-quantity" min=".00001" steps=".00001" value="0" :class="[formErrors.quantity ? 'is-invalid' : '']"  type="number"  aria-describedby="quantityHelp"  :max="fromAccount.spendingBalance" >
                                    <input  class="form-control quantity"  min=".00001" steps=".00001" value="1" :class="[formErrors.quantity ? 'is-invalid' : '']"  id="quantity" name="quantity" type="hidden"  aria-describedby="quantityHelp" :max="fromAccount.spendingBalance"  >
                                    <b v-if="hasToBuy" id="quantityHelp" class="form-text ">Available Balance <u class="maxQuantity"> <span >0</span>  {{sellCurrency.symbolBase}} </u></b>
                                    <b v-else="" id="quantityHelp" class="form-text " @click="updateQuantity">Available Balance <u class="maxQuantity"> <span >{{fromAccount.spendingBalance}}</span>  {{fromAccount.currency.symbolBase}} </u></b>
                                    <small class="invalid-quantity error  danger" style="display:none">This quantity exceeds your available balance</small>
                                  </div>
                                <!-- <div class="form-group text-left">
                                    <label class="control-label" for="total">Total</label>
                                    <br><br>
                                    <div>$ <span class="total">0.00</span></div>
                                  
                                </div> -->
                                <div class="form-group text-left">
                                    <label class="control-label" for="total">Total</label>
                                    <br>
                                    <div class="d-none">$ <span class="total">{{sellCurrency.displayPrice? sellCurrency.displayPrice : sellCurrency.price }}</span></div>
                                    <div class="row p-3" >
                                      <input @change="updateCost" value="" class="form-control sellCurrency-total col-sm-10 " min=".00001" steps=".00001" value="1" :class="[formErrors.total ? 'is-invalid' : '']"  type="number"  aria-describedby="totalHelp"   >
                                      <span class="col-sm-1 " > USD</span>
                                    </div>
                                </div>

                                <div class="danger invalid-minBuyValue" style="display:none">The value of this order must be equal to or exceed {{parseFloat(minBuyValue).toFixed(2)}} USD</div>

                            </div>
        
                      </div>
                      <div class="row">
                        <div class=" col-12" >
                          <!-- {{stableToken}} -->
                          <!-- {{sellCurrency}} -->
                          <!-- works with token cart -->
                          <!-- {{hasToBuy}} -->
                          <a v-if="hasToBuy" :href="'/buy/'+sellCurrency.id" class="col-12 btn btn-primary">Buy Now</a>
                          <!-- <button v-else="" class="col-12 btn btn-primary fast-sell-cart">Sell Now</button> -->
                          <ajax-button v-else="" :syncing="syncing" class="col-12 btn btn-primary fast-sell-cart">Sell Now</ajax-button>

                          <input type="hidden" class="shopifyVariantId" value="" >
                          <!-- <input type="hidden" class="productId" :value="stableToken.buyProductId" >
                          <input type="hidden" class="title" :value="stableToken.name" >
                          <input type="hidden" class="img" :value="stableToken.logo" >
                          <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                          <input type="hidden" class="variantPrice" :value="stableToken.price" > -->
                          <input v-if="sellCurrency.stableToken" type="hidden" class="productId" :value="stableToken.buyProductId" >
                          <input v-else="" type="hidden" class="productId" :value="sellCurrency.buyProductId" >
                          <input type="hidden" class="title" :value="sellCurrency.name" >
                          <input type="hidden" class="img" :value="sellCurrency.logo" >
                          <input type="hidden" class="shopifyHandle" :value="sellCurrency.shopifyBuyProductHandle" >
                          <input type="hidden" class="variantPrice" :value="sellCurrency.price" >
                          <input type="hidden" class="sellCurrencyId" :value="sellCurrency.id" >
                          <!-- <input type="hidden" class="price" :value="stableToken.price" > -->
                          <input type="hidden" class="type" value="token" >
                          <!-- <input type="hidden" class="quantity" value="1" > -->
                          <input type="hidden" class="fromAccountId" :value="fromAccount.id" >
                          <input type="hidden" class="fromAccountSpendingBalance" :value="fromAccount.spendingBalance" >
        
        
        
                          <!-- {{buyCurrency.price}} -->
                          <!-- <input type="hidden" class="quantity" value="1" > -->
                          <!-- <cart-modal id="cart" :environment="environment" :syncing="syncing" :sell-currency-id="sellCurrency.exchangeTokenId" :checkout-redirect="redirect" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
                          <token-cart-modal id="token-cart" :environment="environment" :syncing="syncing" :sell-currency-id="sellCurrency.exchangeTokenId" :checkout-redirect="redirect" checkout-action="sellUnits" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>
        
        
                        </div>
                      </div>
        
                  </div>
        
        
        
                  <!-- <buy-button id="cart"  ></buy-button>  -->
                  <div id='product-component-1575250675382'></div>
        
                  <!-- <div id="bestrate-payout"></div> -->
        
                </div>
              </ajax-form>
            </div>

          </div>

          
        </div>
        <div class="container" v-if="cloudSuccess">
          <h1 class="text-center">Check your email!</h1>
          <div class="success-message">
            <hr/>
            <p>Your account is nearly ready. All you have to do is click the link we sent to <strong>{{formData.emailAddress}}</strong>.</p>
            <p>(You can still access your dashboard now, but some features will be unvavailable until we've verified your email address.)</p>
            <p><a class="btn btn-outline-info" href="/">Go to dashboard</a></p>
          </div>
        </div>
    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.symbol = this.$route.params.id;
        this.tradeType = this.$route.params.tradeType;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);
          console.log("about to listen");
          // this.watchMarkets();
        //   this.listen();
          await this.listen();  

          console.log("should listening",this.$route.params.id);

    },
    mounted: async function() {
        // this.widget = BRPayoutWidget.init("bestrate-payout", "44830270d912bf6ef75299c14c3b8eaf");
    
        // console.log("this.widget",this.widget);
        // this.widget.send({},{},{redirectUrl:"/placed-order"});
        // widget.send({email:'test@test.com'},{'Field 1':'Some text'},{});
        var payOrder = this;
        payOrder.syncing = true;
        this.updateQuantity();
    
    
    
    
      //   console.log("fast-cart length",$(".fast-cart").length);
      // $(".sellCurrency-quantity").change();
      await payOrder.updateQuantity();
      payOrder.syncing = false;
    
    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      bindUIAction: async function(e) {
       
        var Quote = this;
        $('input[type=radio][name=revenueToken]').change(async function() {
          await Quote.updateQuantity();
            
        });

        
          
  
  
      },
        listen: async function() {
          // The auto-connecting socket is exposed as `io.socket`.
    
          // Use `io.socket.on()` to listen for the 'hello' event:
          // io.socket.on(this.market.id, function (data) {
          //   console.log('Socket `' + data.id + '` joined the party!');
          // });
          var Quote = this;
        
          //show loading// syincing
          this.loadingQuote = true;
          // $(".market .market-pg").hide().addClass("d-none");
          // $(".market .loading").show().removeClass("d-none");
          // get market 
          
          // var data =  await Cloud.getQuote.with({tradeType:this.tradeType,symbol:this.symbol})
          // .tolerate(()=>{
          //   this.cloudLoadingError = true;
          // });
    
          // if(data.flag){
          //   _.extend(this, data);
          //   this.loadingQuote = false;
    
          // }else if(data.mustLogin){
          //   window.location.href = data.redirect;
          // } else{
          //   this.loadingQuote = false;
          // }

          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
            type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            url: "/wp-json/yohshow/api/v1/getQuote",
            data: {tradeType:this.tradeType,symbol:this.symbol},
            // headers:apiRequestHeader,
            success: function(resData, textStatus, request)
            {
                if(resData.flag){
                    _.extend(Quote, resData);
                    Quote.loadingQuote = false;
                }else if(resData.mustLogin){
                    window.location.href = resData.redirect;
                } else{
                    Quote.loadingQuote = false;
                }
                setTimeout(function(){ 
                    $(".fast-cart, .fast-sell-cart").on("click", function(event) {
                    Quote.syncing = true;
                    Quote.bindUIAction();
                        // console.log("payOrder.syncing",payOrder.syncing);
                    });
                }, 1000);

            }
            });
    
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/getQuote',
        //       data: {tradeType:this.tradeType,symbol:this.symbol},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(Quote, resData);
        //         Quote.loadingQuote = false;
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Quote.loadingQuote = false;
        //       }
        //       setTimeout(function(){ 
        //         $(".fast-cart, .fast-sell-cart").on("click", function(event) {
        //           Quote.syncing = true;
        //             // console.log("payOrder.syncing",payOrder.syncing);
        //         });
        //       }, 1000);
              
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
      
          
    
    
        },
        updateCost : function (){
          var exchangeFee = this.exchangeFee;
          var paymentDecimal = this.paymentDecimal;
    
          var price =  this.sellCurrency.displayPrice? this.sellCurrency.displayPrice : this.sellCurrency.price;
          // var price = parseFloat(price).toFixed(2);
          var price = parseFloat(price);
          var cost = $(".sellCurrency-total").val();
          var tradeType = $(".tradeType").val();
    
          price = parseFloat(price);
          cost = parseFloat(cost);
          exchangeFee = parseFloat(exchangeFee);
         
          // var costFee = cost * exchangeFee;
          if(price > 0){
            if(tradeType == "buy"){
              var quantity = safe.quantity("buy",cost,price,exchangeFee,paymentDecimal);
      
              // var quantity = cost/(price + (price * exchangeFee) ); 
            }else{
              var quantity = safe.quantity("sell",cost,price,exchangeFee,paymentDecimal);
            }
    
          }
          
          $(" .quantity, .sellCurrency-quantity").val(quantity);
          var minBuyValue = parseFloat( this.minBuyValue);
          if(minBuyValue > cost){
            this.formErrors.minBuyValue = true;
            $(".btn").attr("disabled","disabled");
            $(".invalid-minBuyValue").show();
          }else{
            this.formErrors.minBuyValue = false;
            $(".btn").removeAttr("disabled");
            $(".invalid-minBuyValue").hide();
    
          }
    
        },
    
        updateQuantity: async function(){
          var sellCurrencyQuantity = $('.sellCurrency-quantity').val();
          // var sellCurrencyQuantity = $(e.target).val();
          var stableToken = this.stableToken;
          var sellCurrency = this.sellCurrency;
          var sellCurrencyPrice = parseFloat(this.sellCurrency.price);
          var stableTokenQuantity = 0;
          sellCurrencyQuantity =  parseFloat(sellCurrencyQuantity);
          console.log("updateQuantity sellCurrencyQuantity",sellCurrencyQuantity);
          console.log("updateQuantity stableToken",stableToken);
          console.log("updateQuantity sellCurrency",sellCurrency);
          console.log("updateQuantity sellCurrencyPrice",sellCurrencyPrice);
          console.log("updateQuantity stableTokenQuantity",stableTokenQuantity);
          console.log("updateQuantity stableToken.exchangeTokenId == sellCurrency.exchangeTokenId",stableToken.exchangeTokenId == sellCurrency.exchangeTokenId);
          if(stableToken.exchangeTokenId == sellCurrency.exchangeTokenId){
            stableTokenQuantity = sellCurrencyQuantity;
            console.log("updateQuantity is stable sell currency stableTokenQuantity",stableTokenQuantity);
            var cost = stableTokenQuantity;
          }else {
            stableTokenQuantity = sellCurrencyPrice * sellCurrencyQuantity;
            console.log("updateQuantity is stable sell currency pre ceil stableTokenQuantity",stableTokenQuantity);
    
            stableTokenQuantity = Math.ceil(stableTokenQuantity);
            console.log("updateQuantity is stable sell currency post ceil stableTokenQuantity",stableTokenQuantity);
            var cost = stableTokenQuantity;
          }
          // $(".quantity").val(stableTokenQuantity);
          $(".quantity").val(sellCurrencyQuantity);
          var _quantity = $(".quantity").val();
          console.log("updateQuantity is stable sell currency _quantity",_quantity);
    
          var variantPrice = $(".variantPrice").val();
          console.log("updateQuantity is stable sell currency variantPrice",variantPrice);
    
          if(variantPrice){
            variantPrice = parseFloat(variantPrice);
          } else{
            // variantPrice = parseFloat(sellCurrencyPrice);
            variantPrice = 1.2;
          }
          console.log("updateQuantity is stable sell currency variantPrice",variantPrice);
    
    
          // var total = stableTokenQuantity * variantPrice;
          var total = sellCurrencyQuantity * variantPrice;
          total = total.toFixed(2);
          console.log("updateQuantity is stable sell currency total",total);
          $(".total").html(total);
          var _total = $(".total").html();
          console.log("updateQuantity is stable sell currency _total",_total);
          $(".sellCurrency-total").val(total);

    
        },
    
        submittedForm: async function() {
          if(this.isEmailVerificationRequired) {
            // If email confirmation is enabled, show the success message.
            this.cloudSuccess = true;
          }
          else {
            // Otherwise, redirect to the logged-in dashboard.
            // > (Note that we re-enable the syncing state here.  This is on purpose--
            // > to make sure the spinner stays there until the page navigation finishes.)
            this.syncing = true;
            window.location = '/pay-order';
          }
        },
    
        handleParsingForm: function() {
          // Clear out any pre-existing error messages.
          this.formErrors = {};
    
          var argins = this.formData;
    
          // Validate first name:
          if(!argins.firstName) {
            this.formErrors.firstName = true;
          }
    
    
          // If there were any issues, they've already now been communicated to the user,
          // so simply return undefined.  (This signifies that the submission should be
          // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
    
    }



  });

});

