/**
 * <share-modal>
 * -----------------------------------------------------------------------------
 * Transaction modal.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {

    Vue.component('shareModal', {

      //  ╔═╗╦═╗╔═╗╔═╗╔═╗
      //  ╠═╝╠╦╝║ ║╠═╝╚═╗
      //  ╩  ╩╚═╚═╝╩  ╚═╝
      props: [
        'id',// « The JS timestamp to format
        'label',// « The JS timestamp to format
        'shareLink',// « shareLink
        'message',// « message
        'tokenId',// « TODO use for promote buyings
      ],
      name: 'share-modal',
    
      //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
      //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
      //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
      data: function (){
        return {
          formatType: undefined,
          formattedTimestamp: '',
          interval: undefined
        };
      },
    
      //  ╦ ╦╔╦╗╔╦╗╦
      //  ╠═╣ ║ ║║║║
      //  ╩ ╩ ╩ ╩ ╩╩═╝
      template: `
      <div :id="id+'share-modals'" class=" mb-3 share-modals">
          <!-- Share btn -->

          <a class="share-btn   btn btn-sm btn-primary" tabindex="0" role="button" data-toggle="modal" data-target="#shareModal">
              <span class="">Share </span>
          </a>
          <!-- Share btn end -->
          <!-- Share Modal -->
          <div class="modal  shareModal" id="shareModal" tabindex="-1" role="dialog" aria-labelledby="shareModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shareModalLabel">{{label}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body" style="margin-left: auto;margin-right: auto;">
                    <!-- <div style="margin-left: auto;margin-right: auto;display: inline-block;"> -->
                        <p class="text-left">{{message}} </p>
                        <div class="a2a_kit a2a_kit_size_32 a2a_default_style text-center share-box" :data-a2a-url="shareLink" data-a2a-title="Yoh Show" style="margin-left: auto;margin-right: auto;display: inline-block;">
                                <!-- <a class="a2a_dd" href="https://www.addtoany.com/share"></a> -->
                                <!-- <a :href="shareLink" class="a2a_button_facebook"></a> -->
                                <a :href="shareLink" class="a2a_button_twitter"></a>
                                <a :href="shareLink" class="a2a_button_email"></a>
                                <a :href="shareLink" class="a2a_button_linkedin"></a>
                                <a :href="shareLink" class="a2a_button_telegram"></a>
                                <a :href="shareLink" class="a2a_button_reddit"></a>
                        <!-- </div> -->
                    </div>
                    <p class="share-btn text-left">
                      <label> Share Link:</label><br><br>
                      <h6 id="copyShareAddress" class="share-btn shareAddress">
                      {{shareLink}}
                      </h6>
                    </p>

                  
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" onClick="copyAddress(event)" href="copyShareAddress">Copy Link</button>
                </div>
                </div>
            </div>
      </div>
          <!-- Share Modal end -->
    
    
    
      </div>
        
      `,
    
      //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
      //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
      //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
      beforeMount: function() {
    
      },
      mounted: function() {
        console.log("this share modals id",this.id);
        console.log("this share modals prebind shareLink",this.shareLink);
        this.bindUIActions();
        console.log("this share modals post bind shareLink",this.shareLink);
      },
    
    
    
      //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
      //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
      //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
      methods: {
        bindUIActions: function() {
          var Share = this;
          $(".share-btn").on("click", function(event) {
            event.preventDefault();
            jQuery('#shareModal').modal("show");
        });
        },
    
      }
    
    });
  
});
