<?php
try {
  /**
   * Creates the yohshow api item for the plugin.
   *
   * @package YohShow
   */
  require_once(ABSPATH . 'wp-admin/includes/screen.php');

  /*
    let people pay in stable tokens
  */
  
  /*
  * This action hook registers our PHP class as a WooCommerce payment gateway
  */
  add_filter( 'woocommerce_payment_gateways', 'misha_add_gateway_class' );
  function misha_add_gateway_class( $gateways ) {
    $gateways[] = 'Yohshow_Payments'; // your class name is here
    return $gateways;
  }
  
  /*
  * The class itself, please note that it is inside plugins_loaded action hook
  */
  add_action( 'plugins_loaded', 'misha_init_gateway_class' );
  function misha_init_gateway_class() {
  
    class Yohshow_Payments extends WC_Payment_Gateway {
      /**
       * A reference the class responsible for rendering the submenu page.
       *
       * @$   YohShow_API
       * @access protected
       */
      protected $yohshow_api;
      protected $networks = [
        'main',
        'ethereum',
        'binance',
        'polygon',
        'avalanche',
        'fantom',
        'arbitrum',
        'optimism',
        'cronos',
        'moonbeam',
        'harmony',
        'celo',
        'metis',
        'aurora',
        'zksync',
        'linea',
        'scroll',
        'base',
        'mantle',
        'zkevm',
        'blast'
    ];
    protected $usdc_addresses = [
      'main' => '0xa0b86991c6218b36c1d19d4a2e9eb0ce3606eb48',
      'ethereum' => '0xa0b86991c6218b36c1d19d4a2e9eb0ce3606eb48',
      'binance' => '0x8ac76a51cc950d9822d68b83fe1ad97b32cd580d',
      'polygon' => '0x2791bca1f2de4661ed88a30c99a7a9449aa84174',
      'avalanche' => '0xb97ef9ef8734c71904d8002f8b6bc66dd9c48a6e',
      'fantom' => '0x04068da6c83afcfa0e13ba15a6696662335d5b75',
      'arbitrum' => '0xff970a61a04b1ca14834a43f5de4533ebddb5cc8',
      'optimism' => '0x7f5c764cbc14f9669b88837ca1490cca17c31607',
      'cronos' => '0xc21223249ca28397b4b6541dfddc237f743c6caa',
      'moonbeam' => '0x818ec0a7fe18ff94269904fced6ae3dae6d6dc0b',
      'harmony' => '0x985458e523db3d53125813ed68c274899e9dfab4',
      'celo' => '0x196f4727526eA7FB1e17b2071B3d8eAA38486988',
      'metis' => '0xEA32A96608495e54156Ae48931A7c20f0dcc1a21',
      'aurora' => '0xb12bfca5a55806aaf64e99521918a4bf0fc40802',
      'zksync' => '0x3355df6D4c9C3035724Fd0e3914dE96A5a83aaf4',
      'linea' => '0xee71b3cce94ea5391d6a8f9c909906e66a7d8c4b',
      'scroll' => '0x2c537c4fD69DB1e6A40B0F7CaF2c0C61154142d7',
      'base' => '0x8f552a71ef5b6f2f176bff90d4f0f0f9a64e6efc',
      'mantle' => '0x8f552a71ef5b6f2f176bff90d4f0f0f9a64e6efc', // same as Base for bridged USDC.e
      'zkevm' => '0xa8ce8aee21bc2a48a5ef670afcc9274c7bbbc035',
      'blast' => '0x4300000000000000000000000000000000000003' // USDB (native), but USDC bridged available
  ];
  protected $evm_chain_ids = [
    'main' => 1,
    'ethereum' => 1,
    'binance' => 56,
    'polygon' => 137,
    'avalanche' => 43114,
    'fantom' => 250,
    'arbitrum' => 42161,
    'optimism' => 10,
    'cronos' => 25,
    'moonbeam' => 1284,
    'harmony' => 1666600000,
    'celo' => 42220,
    'metis' => 1088,
    'aurora' => 1313161554,
    'zksync' => 324,
    'linea' => 59144,
    'scroll' => 534352,
    'base' => 8453,
    'mantle' => 5000,
    'zkevm' => 1101,
    'blast' => 81457
];
  
  
      /**
       * Class constructor, more about it in Step 3
      */
        public function __construct() {
          $this->init();

  
          $this->id = 'misha'; // payment gateway plugin ID
          $this->icon = ''; // URL of the icon that will be displayed on checkout page near your gateway name
          $this->has_fields = true; // in case you need a custom credit card form
          $this->method_title = 'Wazoo Giftard Gateway';
          $this->method_description = 'Transferable giftcard plugin'; // will be displayed on the options page
        
          // gateways can support subscriptions, refunds, saved payment methods,
          // but in this tutorial we begin with simple payments
          $this->supports = array(
            'products'
          );
        
          // Method with all the options fields
          $this->init_form_fields();
        
          // Load the settings.
          $this->init_settings();
          $this->app_token_exchange_id = get_option( 'app_token_exchange_id' );
          $this->title = $this->get_option( 'title' );
          $this->description = $this->get_option( 'description' );
          $this->enabled = $this->get_option( 'enabled' );

          $apiKey = get_option('exchange_apiKey');
          $apiSecret = get_option('exchange_apiSecret');

          $apiKeyTest = get_option('exchange_apiKeyTest');
          $apiSecretTest = get_option('exchange_apiSecretTest');

          

          $exchange_environment = get_option('exchange_environment');
          $this->testmode = false;
          if($exchange_environment !== "production"){
            $apiKey = $apiKeyTest;
            $apiSecret = $apiSecretTest;
            $this->testmode = true;

          }

          $this->private_key = $apiSecret;
          $this->publishable_key = $apiKey;

          // $this->testmode = 'yes' === $this->get_option( 'testmode' );
          // $this->private_key = $this->testmode ? $this->get_option( 'exchange_apiSecretTest' ) : $this->get_option( 'exchange_apiSecret' );
          // $this->publishable_key = $this->testmode ? $this->get_option( 'exchange_apiKeyTest' ) : $this->get_option( 'exchange_apiKey' );

          if ($this->publishable_key){
            $this->yohshow_api = new Yohshow_Api( $this->publishable_key,$this->private_key );
          }

          //$yohshow_tokenize = new Yohshow_Tokenize( $this->yohshow_api );
        
          // This action hook saves the settings
          add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
        
          // We need custom JavaScript to obtain a token
          add_action( 'wp_enqueue_scripts', array( $this, 'payment_scripts' ) );
        
          // You can also register a webhook here
          // add_action( 'woocommerce_api_{webhook name}', array( $this, 'webhook' ) );
        }
  
      /**
       * Plugin options, we deal with it in Step 3 too
      */
        public function init_form_fields(){
  
          $this->form_fields = array(
            'enabled' => array(
              'title'       => 'Enable/Disable',
              'label'       => 'Wazoo Giftcard Gateway',
              'type'        => 'checkbox',
              'description' => '',
              'default'     => 'no'
            ),
            'title' => array(
              'title'       => 'Title',
              'type'        => 'text',
              'description' => 'This controls the title which the user sees during checkout.',
              'default'     => 'My Balance',
              'desc_tip'    => true,
            ),
            'description' => array(
              'title'       => 'Description',
              'type'        => 'textarea',
              'description' => 'This controls the description which the user sees during checkout.',
              'default'     => 'Pay with your store credit via our super-cool payment gateway.',
            ),
            // 'testmode' => array(
            //   'title'       => 'Test mode',
            //   'label'       => 'Enable Test Mode',
            //   'type'        => 'checkbox',
            //   'description' => 'Place the payment gateway in test mode using test API keys.',
            //   'default'     => 'yes',
            //   'desc_tip'    => true,
            // ),
            'exchange_apiKeyTest' => array(
              'title'       => 'Test Publishable Key',
              'type'        => 'text'
            ),
            'exchange_apiSecretTest' => array(
              'title'       => 'Test Private Key',
              'type'        => 'password',
            ),
            'exchange_apiKey' => array(
              'title'       => 'Live Publishable Key',
              'type'        => 'text'
            ),
            'exchange_apiSecret' => array(
              'title'       => 'Live Private Key',
              'type'        => 'password'
            )
          );
        }
  
      /**
       * You will need it if you want your custom credit card form, Step 4 is about it
       */
      public function payment_fields() {
        // Ensure WooCommerce cart is available
        
  
        global $woocommerce;
        $total_amount = $woocommerce->cart->get_total("int");
        $items = $woocommerce->cart->get_cart();

        // $note = " test ". count($items );
 
        foreach($items as $item => $values) { 
            $_product =  wc_get_product( $values['data']->get_id()); 
            $price = get_post_meta($values['product_id'] , '_price', true);
            $line_item["price"] = $price; 
            $line_item["quantity"] = $values['quantity']; 
            $line_item["title"] = $_product->get_title(); 
            $note["items"][] = $line_item; 

        } 

        //get app info 
        $yohshow_api =  $this->yohshow_api;
        $apiKey =  $this->publishable_key;
   
        $appId = $appTokenResult->appId;
        $exchangeAccountId = $appTokenResult->exchangeAccountId;
        $appToken = $appTokenResult->appToken;
        $stableToken = $appTokenResult->stableToken;
        $networks = $appTokenResult->networks;
        $paymentMethodNetworks = $appTokenResult->paymentMethodNetworks;
        $defaultLightningNetwork = $appTokenResult->defaultLightningNetwork;
        $chainIdNetworks = $appTokenResult->chainIdNetworks;

        //load defualt netowrks and paymentMethodNetworks

        $networks = $this->networks;
        $usdc_addresses = $this->usdc_addresses;
        $chainIdNetworks = $this->evm_chain_ids;
        $defaultLightningNetwork = "polygon";
        

        
        

        for ($i=0; $i < count($networks) ; $i++) { 
          $network =  $networks[$i];
          $networkUsdc = $usdc_addresses[$network];


          $networkPaymentMethods[$network]["tokenBankAddress"] = "0xD735D6deb7D67BEa70AB29679f3d7F5482578D2F" ; 
          $networkPaymentMethods[$network]["tokenBankTokenId"] = "0";
          $networkPaymentMethods[$network]["tokenBankAccountId"] ="0" ;
          $networkPaymentMethods[$network]["paymentMethodAddress"] = $networkUsdc ;
          $networkPaymentMethods[$network]["paymentMethodTokenId"] ="0" ;
          $networkPaymentMethods[$network]["currencyAddress"] = $networkUsdc ;
          $networkPaymentMethods[$network]["currencyTokenId"] ="0" ;

          // $networkPaymentMethods["main"]["tokenBankAddress"] = "0xD735D6deb7D67BEa70AB29679f3d7F5482578D2F"; //brobot live wallet owner
          // $networkPaymentMethods["main"]["tokenBankTokenId"] = "0";
          // $networkPaymentMethods["main"]["tokenBankAccountId"] = "0";
          // // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
          // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
          // $networkPaymentMethods["main"]["paymentMethodTokenId"] = "0";

          // $networkPaymentMethods["main"]["currencyAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
          // $networkPaymentMethods["main"]["currencyTokenId"] = "0";
        }

        

        //
        //make note
        $uuid_id = uniqid();
        $time_stamp = time();
          //        $now = now();
          $payment_id = $uuid_id ."_". $time_stamp;
          $note["id"] = $payment_id; 
          $note["amount"] = $total_amount;
          $note["note"] = "payment";
        
        
        
       
        
        
        

        //server
          //amount //
          //id //
          //note //
          //to token id // token id
          //to address // bank address
          //to account id

          //array based on network
            //payment token id
            //payment token address

        //cliente
          //from token id
          //from address id
          //from account
          //network
          //current payment count

          //selected on network
            //payment token id
            //payment token address

        //

        // ok, let's display some description before the payment form
        if ( $this->description ) {
          // you can instructions for test mode, I mean test card numbers etc.
          if ( $this->testmode ) {
            $this->description .= ' TEST MODE ENABLED. In test mode, you can use the card numbers listed in <a href="#" target="_blank" rel="noopener noreferrer">documentation</a>.';
            $this->description  = trim( $this->description );
          }
          // display the description with <p> tags etc.
          echo wpautop( wp_kses_post( $this->description ) );
        }
      
        // I will echo() the form, but you can close PHP tags and print it directly in HTML
        echo '<fieldset id="wc-' . esc_attr( $this->id ) . '-cc-form" class="wc-credit-card-form wc-payment-form "" style="background:transparent;">';
      
        // Add this action hook if you want your custom payment gateway to support it
        do_action( 'woocommerce_credit_card_form_start', $this->id );
        //load default balances
        // $balances = $this->balances();
        $select = '<select name="account_id" id="account_id">';
          $select .= '<option  value="myWallet" class="blockchain"> My Wallet </option>';
          $select .= '<option  value="myWallet" class="blockchain"> MetaMask </option>';
        $select .= '</select>';

        
        //get balances
        // make balances select. only this
        // I recommend to use inique IDs, because other gateways could already use #ccNo, #expdate, #cvc
        //TODO put payment component here 
        // $YOH_SHOW_PAYMENT_LOCALS = array();

        if ( $this->testmode ) {
          //token bank configuration
          // $networkPaymentMethods["goerli"]["tokenBankAddress"] = "0xAa356aF86974af177Ad7ba1486D5C22171AAfF41";
          // $networkPaymentMethods["goerli"]["tokenBankTokenId"] = "1";
          // $networkPaymentMethods["goerli"]["tokenBankAccountId"] = "1";
          // // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
          // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xe7F717b05149CF4C3a8AdAE19f6B3314976b4580";//usdt test
          // $networkPaymentMethods["goerli"]["paymentMethodTokenId"] = "4";

          // $networkPaymentMethods["goerli"]["currencyAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
          // $networkPaymentMethods["goerli"]["currencyTokenId"] = "0";


          //regular wallet  configuration
          $networkPaymentMethods["goerli"]["tokenBankAddress"] = "0x0dB9E51cE9659D073648d473cA05C6974157e955";
          $networkPaymentMethods["goerli"]["tokenBankTokenId"] = "0";
          $networkPaymentMethods["goerli"]["tokenBankAccountId"] = "0";
          // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
          $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
          $networkPaymentMethods["goerli"]["paymentMethodTokenId"] = "0";

          $networkPaymentMethods["goerli"]["currencyAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
          $networkPaymentMethods["goerli"]["currencyTokenId"] = "0";



          $YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
          $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array("goerli");

        }else{
          //token bank configuration
            // $networkPaymentMethods["main"]["tokenBankAddress"] = "0xAa356aF86974af177Ad7ba1486D5C22171AAfF41";
            // $networkPaymentMethods["main"]["tokenBankTokenId"] = "1";
            // $networkPaymentMethods["main"]["tokenBankAccountId"] = "1";
            // // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
            // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xe7F717b05149CF4C3a8AdAE19f6B3314976b4580";//usdc live
            // $networkPaymentMethods["main"]["paymentMethodTokenId"] = "4";

            // $networkPaymentMethods["main"]["currencyAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
            // $networkPaymentMethods["main"]["currencyTokenId"] = "0";


            //real

            //regular wallet  configuration
            $networkPaymentMethods["main"]["tokenBankAddress"] = "0xD735D6deb7D67BEa70AB29679f3d7F5482578D2F"; //brobot live wallet owner
            $networkPaymentMethods["main"]["tokenBankTokenId"] = "0";
            $networkPaymentMethods["main"]["tokenBankAccountId"] = "0";
            // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
            $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
            $networkPaymentMethods["main"]["paymentMethodTokenId"] = "0";

            $networkPaymentMethods["main"]["currencyAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
            $networkPaymentMethods["main"]["currencyTokenId"] = "0";



            $YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
            $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array($defaultLightningNetwork);
            // $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = $networks;
            // $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array("main");


            // //test 

            // //regular wallet  configuration
            // $networkPaymentMethods["goerli"]["tokenBankAddress"] = "0x0dB9E51cE9659D073648d473cA05C6974157e955";
            // $networkPaymentMethods["goerli"]["tokenBankTokenId"] = "0";
            // $networkPaymentMethods["goerli"]["tokenBankAccountId"] = "0";
            // // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
            // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
            // $networkPaymentMethods["goerli"]["paymentMethodTokenId"] = "0";

            // $networkPaymentMethods["goerli"]["currencyAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
            // $networkPaymentMethods["goerli"]["currencyTokenId"] = "0";



            // $YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
            // $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array("goerli");








        }



        
 
        // $YOH_SHOW_PAYMENT_LOCALS["note"] = json_encode($note);
        $YOH_SHOW_PAYMENT_LOCALS["defaultLightningNetwork"] = $defaultLightningNetwork;
        $YOH_SHOW_PAYMENT_LOCALS["chainIdNetworks"] = $chainIdNetworks;
        
        $YOH_SHOW_PAYMENT_LOCALS["note"] = $note;
        // $YOH_SHOW_PAYMENT_LOCALS["note"] = "test";
        $YOH_SHOW_PAYMENT_LOCALS["amount"] = $total_amount;
        $YOH_SHOW_PAYMENT_LOCALS["payment_id"] = $payment_id;
        $YOH_SHOW_PAYMENT_LOCALS = json_encode($YOH_SHOW_PAYMENT_LOCALS);
        // echo '<div class="form-row form-row-wide yoh-wallet"><wallet></wallet></div>';
        // echo "<script> var YOH_SHOW_PAYMENT_LOCALS = JSON.parse('$YOH_SHOW_PAYMENT_LOCALS');  console.log('test YOH_SHOW_PAYMENT_LOCALS',YOH_SHOW_PAYMENT_LOCALS); </script>";
          

        // $exchange_api_base_url = get_option('exchange_api_base_url');


        // $apiKey = get_option('exchange_apiKey');
        //   $apiSecret = get_option('exchange_apiSecret');

        //   $apiKeyTest = get_option('exchange_apiKeyTest');
        //   $apiSecretTest = get_option('exchange_apiSecretTest');

          

        //   $exchange_environment = get_option('exchange_environment');

        //   <label>$exchange_api_base_url '.$exchange_api_base_url.' </label>

            
        //   <label>$this->private_key '.$this->private_key.' </label>
        //   <label>$this->publishable_key '.$this->publishable_key.' </label>

        //   <label>$this->testmode '.$this->testmode.' </label>

        //   <label>$apiKey '.$apiKey.' </label>
        //   <label>$apiSecret '.$apiSecret.' </label>

        //   <label>$apiKeyTest '.$apiKeyTest.' </label>
        //   <label>$apiSecretTest '.$apiSecretTest.' </label>
        //   <label>$exchange_environment '.$exchange_environment.' </label>

        echo '<div class="form-row form-row-wide yohshow-payment-fields">


          <div class="form-row form-row-first bootstrap">
            <label>From Account<span class="required">*</span></label>

          '.$select.'

          <input type="hidden" name="payment_id" value="'.$payment_id.'" />
          <input type="hidden" class="transactionHash" name="transactionHash" />
          <input type="hidden" class="network" name="network" />


          <!-- Button trigger modal -->
          <button type="button" class="btn btn-primary modal-payment-processing-btn d-none" data-toggle="modal" data-target="#exampleModal">
            Launch demo modal
          </button>

          <!-- Modal -->
          <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="exampleModalLabel"></h5>
          
                </div>
                <div class="modal-body text-center">
                  <h2 class="p-4 m-4">Processing Payment ...</h2>



                </div>
                <div class="modal-footer">
        
                </div>
              </div>
            </div>
          </div>

          </div>
          <div class="clear"></div>
          <script>
            var web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");

            var YOH_SHOW_PAYMENT_LOCALS = JSON.parse(\''.$YOH_SHOW_PAYMENT_LOCALS.'\'); // replace this with actual inline PHP

            var networkPaymentMethods = YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"];
            var amount = YOH_SHOW_PAYMENT_LOCALS["amount"];
            var note = YOH_SHOW_PAYMENT_LOCALS["note"];
            note = JSON.stringify(note);
            var paymentNetworks = YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"];
            paymentNetworks = paymentNetworks.join(",");
            document.addEventListener("DOMContentLoaded", function () {
                web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");

                YOH_SHOW_PAYMENT_LOCALS = JSON.parse(\''.$YOH_SHOW_PAYMENT_LOCALS.'\'); // replace this with actual inline PHP

                networkPaymentMethods = YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"];
                amount = YOH_SHOW_PAYMENT_LOCALS["amount"];
                note = YOH_SHOW_PAYMENT_LOCALS["note"];
                note = JSON.stringify(note);
                paymentNetworks = YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"];
                paymentNetworks = paymentNetworks.join(",");

                activatePlaceOrder();
                getAccounts();
            });

            //make call to get accounts
            

            //pay 
            function  getAccounts() {
              //make call to payment endpoint get accounts
              var data = {};
                        //console.log("get accounts data",data);
           
              jQuery.ajax({
                    type: "POST",
                  url: "/wp-json/yohshow/api/v1/payments/accounts",
                  data: data,
                    // headers:apiRequestHeader,
                    success: function(resData, textStatus, request)
                    {
                      
                        //reload YOH_SHOW_PAYMENT_LOCALS if offline is not true
                       
                        resData = JSON.parse(resData);

                        if(resData.flag && resData.online){
                          setTimeout(function() {


                                YOH_SHOW_PAYMENT_LOCALS = resData;


                                jQuery("#account_id").replaceWith(resData.select);
                                //jQuery("#account_id").html("");


                                activatePlaceOrder();
                            }, 2000);
                            

                        } else{

                        }
        
                    }
              });
           
            
            };
            async function  getNetworkName() {
     
              var web3 = new Web3(Web3.givenProvider || "ws://localhost:8545");
              const chainId = await web3.eth.getChainId();
              var networkKey =  YOH_SHOW_PAYMENT_LOCALS.chainIdNetworks[chainId];
              return networkKey;
            };

            function  activatePlaceOrder() {
     
                jQuery( "#place_order" ).click(async function(event) {
                    
                  var account_id = jQuery("#account_id").val();
                  var payment_method = jQuery("input[name=\'payment_method\']:checked").val();
                  
                  if(account_id == "myWallet" && payment_method == "misha" ){
                    event.preventDefault();
                    // alert("web3 shit");
                    var networkType =  await getNetworkName();
                    console.log("networkType",networkType);
                    if(networkPaymentMethods[networkType]){
                      jQuery( "#payWithWallet" ).click(); 
                      var toAddress = networkPaymentMethods[networkType]["tokenBankAddress"];  
                      var toTokenId = networkPaymentMethods[networkType]["tokenBankTokenId"];  
                      var toAccountId = networkPaymentMethods[networkType]["tokenBankAccountId"];  
                      var paymentAddress = networkPaymentMethods[networkType]["paymentMethodAddress"];  
                      var paymentTokenId = networkPaymentMethods[networkType]["paymentMethodTokenId"];  
                      var toAccountId = networkPaymentMethods[networkType]["tokenBankAccountId"];  

                      var currencyAddress = networkPaymentMethods[networkType]["currencyAddress"];  
                      var currencyTokenId = networkPaymentMethods[networkType]["currencyTokenId"]; 
          
                      console.log("YOH_SHOW_PAYMENT_LOCALS",YOH_SHOW_PAYMENT_LOCALS);
                      console.log("note",note);
        
      
                      var paymentResult = await testFunction(toAddress, toTokenId, toAccountId, amount, paymentAddress, paymentTokenId, currencyAddress, currencyTokenId, note); 
                      console.log("paymentResult",paymentResult);
      
                      //save info in form  and submit form
                      if(paymentResult.flag){
                        jQuery(".yohshow-payment-fields .transactionHash").val(paymentResult.transactionHash);
                        jQuery(".yohshow-payment-fields .network").val(networkType);
                        jQuery( event.target ).parents("form").submit(); 
                      }  

                    
                    }else{
                      alert("Please make sure you are on the Main Ethereum network or one of the following networks: " + paymentNetworks);
                      
                    }

                    
                    


                  }else{
                    // alert("web3 dont do shit");

                  }
                });
            };

          </script>
          
          ';
      
        do_action( 'woocommerce_credit_card_form_end', $this->id );
      
        echo '<div class="clear test  yoh-wallet"></div></fieldset>';
        /*



          show accounts select box
        */
      
      }
      /**
       * You will need it if you want your custom credit card form, Step 4 is about it
       */
      public function accounts() {
        try {
          if (function_exists('WC') && null === WC()->cart) {
              if (null === WC()->session) {
                  WC()->session = new WC_Session_Handler();
                  WC()->session->init();
              }
              WC()->cart = new WC_Cart();
              WC()->cart->get_cart();
          }

          $total = WC()->cart ? WC()->cart->get_total('int') : 0;

          $total_amount = WC()->cart->get_total("int");
          $items = WC()->cart->get_cart();

          error_log( "yoh show payments accounts this->yohshow_api->yohshow_api_key ". print_r( $this->yohshow_api->yohshow_api_key, true ) );
          error_log( "yoh show payments accounts this->yohshow_api->yohshow_api_secret ". print_r( $this->yohshow_api->yohshow_api_secret, true ) );

    
          // global $woocommerce;
          // $total_amount = $woocommerce->cart->get_total("int");

          // $items = $woocommerce->cart->get_cart();

          // $note = " test ". count($items );
  
          foreach($items as $item => $values) { 
              $_product =  wc_get_product( $values['data']->get_id()); 
              $price = get_post_meta($values['product_id'] , '_price', true);
              $line_item["price"] = $price; 
              $line_item["quantity"] = $values['quantity']; 
              $line_item["title"] = $_product->get_title(); 
              $note["items"][] = $line_item; 

          } 

          

          //get app info 
          $yohshow_api =  $this->yohshow_api;
          $apiKey =  $this->publishable_key;
          $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/$apiKey",array("apiKey"=>$apiKey));
          // error_log( "yoh show payments payment_fields appTokenResult ". print_r( $appTokenResult, true ) );


          $appId = $appTokenResult->appId;
          $exchangeAccountId = $appTokenResult->exchangeAccountId;
          $appToken = $appTokenResult->appToken;
          $stableToken = $appTokenResult->stableToken;
          $networks = $appTokenResult->networks;
          $paymentMethodNetworks = $appTokenResult->paymentMethodNetworks;
          $defaultLightningNetwork = $appTokenResult->defaultLightningNetwork;
          $chainIdNetworks = $appTokenResult->chainIdNetworks;
          
          

          for ($i=0; $i < count($networks) ; $i++) { 
            $tokenBookConfig =  $networks[$i];
            $network = $tokenBookConfig->network;
            $tokenBankAddress = $tokenBookConfig->tokenBankAddress;
            $libraryId = $tokenBookConfig->libraryId;

            $networkPaymentMethods[$network]["tokenBankAddress"] = $tokenBankAddress ; 
            $networkPaymentMethods[$network]["tokenBankTokenId"] = $libraryId;
            $networkPaymentMethods[$network]["tokenBankAccountId"] = $exchangeAccountId ;


            $networkPaymentMethods["main"]["tokenBankAddress"] = "0xD735D6deb7D67BEa70AB29679f3d7F5482578D2F"; //brobot live wallet owner
            $networkPaymentMethods["main"]["tokenBankTokenId"] = "0";
            $networkPaymentMethods["main"]["tokenBankAccountId"] = "0";
            // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
            $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
            $networkPaymentMethods["main"]["paymentMethodTokenId"] = "0";

            $networkPaymentMethods["main"]["currencyAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
            $networkPaymentMethods["main"]["currencyTokenId"] = "0";
          }
          for ($i=0; $i < count($paymentMethodNetworks) ; $i++) { 
            $tokenBookConfig =  $paymentMethodNetworks[$i];
            $network = $tokenBookConfig->network;
            $tetherBookAddress = $tokenBookConfig->tetherBookAddress;
            $paymentMethodTetherAddress = $tokenBookConfig->paymentMethodTetherAddress;
            $libraryId = $tokenBookConfig->libraryId;

            $networkPaymentMethods[$network]["paymentMethodAddress"] = $tetherBookAddress ; 
            $networkPaymentMethods[$network]["paymentMethodTokenId"] = $libraryId;

            $networkPaymentMethods[$network]["currencyAddress"] = $paymentMethodTetherAddress ; 
            $networkPaymentMethods[$network]["currencyTokenId"] = "0";


        
          }
          

          //
          //make note
          $uuid_id = uniqid();
          $time_stamp = time();
            //        $now = now();
            $payment_id = $uuid_id ."_". $time_stamp;
            $note["id"] = $payment_id; 
            $note["amount"] = $total_amount;
            $note["note"] = "payment";
          
          
          
          
          
          
          

          //server
            //amount //
            //id //
            //note //
            //to token id // token id
            //to address // bank address
            //to account id

            //array based on network
              //payment token id
              //payment token address

          //cliente
            //from token id
            //from address id
            //from account
            //network
            //current payment count

            //selected on network
              //payment token id
              //payment token address

          //


          $balances = $this->balances();
          $select = $balances['select'];
          
          //get balances
          // make balances select. only this
          // I recommend to use inique IDs, because other gateways could already use #ccNo, #expdate, #cvc
          //TODO put payment component here 
          // $YOH_SHOW_PAYMENT_LOCALS = array();

          if ( $this->testmode ) {
            //token bank configuration
            // $networkPaymentMethods["goerli"]["tokenBankAddress"] = "0xAa356aF86974af177Ad7ba1486D5C22171AAfF41";
            // $networkPaymentMethods["goerli"]["tokenBankTokenId"] = "1";
            // $networkPaymentMethods["goerli"]["tokenBankAccountId"] = "1";
            // // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
            // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xe7F717b05149CF4C3a8AdAE19f6B3314976b4580";//usdt test
            // $networkPaymentMethods["goerli"]["paymentMethodTokenId"] = "4";

            // $networkPaymentMethods["goerli"]["currencyAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
            // $networkPaymentMethods["goerli"]["currencyTokenId"] = "0";


            //regular wallet  configuration
            $networkPaymentMethods["goerli"]["tokenBankAddress"] = "0x0dB9E51cE9659D073648d473cA05C6974157e955";
            $networkPaymentMethods["goerli"]["tokenBankTokenId"] = "0";
            $networkPaymentMethods["goerli"]["tokenBankAccountId"] = "0";
            // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
            $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
            $networkPaymentMethods["goerli"]["paymentMethodTokenId"] = "0";

            $networkPaymentMethods["goerli"]["currencyAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
            $networkPaymentMethods["goerli"]["currencyTokenId"] = "0";



            $YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
            $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array("goerli");

          }else{
            //token bank configuration
              // $networkPaymentMethods["main"]["tokenBankAddress"] = "0xAa356aF86974af177Ad7ba1486D5C22171AAfF41";
              // $networkPaymentMethods["main"]["tokenBankTokenId"] = "1";
              // $networkPaymentMethods["main"]["tokenBankAccountId"] = "1";
              // // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
              // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xe7F717b05149CF4C3a8AdAE19f6B3314976b4580";//usdc live
              // $networkPaymentMethods["main"]["paymentMethodTokenId"] = "4";

              // $networkPaymentMethods["main"]["currencyAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
              // $networkPaymentMethods["main"]["currencyTokenId"] = "0";


              //real

              //regular wallet  configuration
              $networkPaymentMethods["main"]["tokenBankAddress"] = "0xD735D6deb7D67BEa70AB29679f3d7F5482578D2F"; //brobot live wallet owner
              $networkPaymentMethods["main"]["tokenBankTokenId"] = "0";
              $networkPaymentMethods["main"]["tokenBankAccountId"] = "0";
              // $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
              $networkPaymentMethods["main"]["paymentMethodAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
              $networkPaymentMethods["main"]["paymentMethodTokenId"] = "0";

              $networkPaymentMethods["main"]["currencyAddress"] = "0xA0b86991c6218b36c1d19D4a2e9Eb0cE3606eB48";//usdc live
              $networkPaymentMethods["main"]["currencyTokenId"] = "0";



              $YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
              $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array($defaultLightningNetwork);
              // $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array("main");


              // //test 

              // //regular wallet  configuration
              // $networkPaymentMethods["goerli"]["tokenBankAddress"] = "0x0dB9E51cE9659D073648d473cA05C6974157e955";
              // $networkPaymentMethods["goerli"]["tokenBankTokenId"] = "0";
              // $networkPaymentMethods["goerli"]["tokenBankAccountId"] = "0";
              // // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0xdAC17F958D2ee523a2206206994597C13D831ec7"; //usdt live
              // $networkPaymentMethods["goerli"]["paymentMethodAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
              // $networkPaymentMethods["goerli"]["paymentMethodTokenId"] = "0";

              // $networkPaymentMethods["goerli"]["currencyAddress"] = "0x2AEc9C6B92103EeC55d7bB156737135C0f6a63f5";//usdt test
              // $networkPaymentMethods["goerli"]["currencyTokenId"] = "0";



              // $YOH_SHOW_PAYMENT_LOCALS["networkPaymentMethods"] = $networkPaymentMethods;
              // $YOH_SHOW_PAYMENT_LOCALS["paymentNetworks"] = array("goerli");








          }



          // $YOH_SHOW_PAYMENT_LOCALS["flag"] = true;
          // $YOH_SHOW_PAYMENT_LOCALS["online"] = true;
          // $YOH_SHOW_PAYMENT_LOCALS = json_encode($YOH_SHOW_PAYMENT_LOCALS);
          // return $YOH_SHOW_PAYMENT_LOCALS;
          
  
          // $YOH_SHOW_PAYMENT_LOCALS["note"] = json_encode($note);
          $YOH_SHOW_PAYMENT_LOCALS["defaultLightningNetwork"] = $defaultLightningNetwork;
          $YOH_SHOW_PAYMENT_LOCALS["chainIdNetworks"] = $chainIdNetworks;
          
          $YOH_SHOW_PAYMENT_LOCALS["note"] = $note;
          // $YOH_SHOW_PAYMENT_LOCALS["note"] = "test";
          $YOH_SHOW_PAYMENT_LOCALS["amount"] = $total_amount;
          $YOH_SHOW_PAYMENT_LOCALS["payment_id"] = $payment_id;
          $YOH_SHOW_PAYMENT_LOCALS["select"] = $select;
          $YOH_SHOW_PAYMENT_LOCALS["flag"] = true;
          $YOH_SHOW_PAYMENT_LOCALS["online"] = true;
          $YOH_SHOW_PAYMENT_LOCALS = json_encode($YOH_SHOW_PAYMENT_LOCALS);
          return $YOH_SHOW_PAYMENT_LOCALS;
        } catch (\Throwable $th) {
          //throw $th;
          $YOH_SHOW_PAYMENT_LOCALS["error"] = true;
          $YOH_SHOW_PAYMENT_LOCALS["flag"] = false;
          $YOH_SHOW_PAYMENT_LOCALS["online"] = false;
          $YOH_SHOW_PAYMENT_LOCALS = json_encode($YOH_SHOW_PAYMENT_LOCALS);
          return $YOH_SHOW_PAYMENT_LOCALS;
        }

        


        


      
 
      
      }
      /*
      * Custom CSS and JS, in most cases required only when you decided to go with a custom credit card form
      */
      public function balances() {
        // //get balances based off login user
        $accountsResult = (object)$this->yohshow_api->balances();
        $accounts = $accountsResult->accounts;
        $stableToken = $accountsResult->stableToken;

        $payment_methods = array();
        $balances = array();
        // print_r($accountsResult);
        // print_r($accounts);
        $exchangeAccountOnly = false;
        foreach ( WC()->cart->get_cart() as $cart_item ) {
          $product_id = $cart_item['product_id'];
          $exchangeTokenId = get_post_meta($product_id,"exchange_token_id",true);
          if($exchangeTokenId){
            // $exchangeTokenIds[] = $exchangeTokenId;
            $tokenResult = (object) $this->yohshow_api->request("get","/tokens/$exchangeTokenId",array("tokenId"=>$exchangeTokenId));
            error_log( "yoh show payments balances cart product id  tokenResult->token->name ". print_r( $tokenResult->token->name, true ) );
            error_log( "yoh show payments balances cart product id  tokenResult->token->buyCurrency ". print_r( $tokenResult->token->buyCurrency, true ) );
            error_log( "yoh show payments balances cart product id  tokenResult->token->tetherNetwork ". print_r( $tokenResult->token->tetherNetwork, true ) );

            if( $tokenResult->token->buyCurrency && $tokenResult->token->id !== $stableToken->id ){
              // if($tokenResult->token->tetherNetwork || $tokenResult->token->buyCurrency){
              $exchangeAccountOnly = true;
              error_log( "yoh show payments balances cart product id must be exchangeAccountOnly ". print_r( $exchangeAccountOnly, true ) );

            }else{
              error_log( "yoh show payments balances cart product id  not exchangeAccountOnly ". print_r( $exchangeAccountOnly, true ) );

            }


          }

          error_log( "yoh show payments balances cart product id test product_id ". print_r( $product_id, true ) );
          error_log( "yoh show payments balances cart product id  test exchangeTokenId ". print_r( $exchangeTokenId, true ) );

        }
        error_log( "yoh show payments balances cart final  exchangeAccountOnly ". print_r( $exchangeAccountOnly, true ) );

        //TODO search for tokens from exchange
        //TODO if token is networkToken??? require only exchange balance to pay
          // else only spend from spending balance
        //DONE

        //TODO get lighting network account info appOrcaleAddress or token bank exchange account info/id


        $select = '<select name="account_id" id="account_id">';
        if(!$exchangeAccountOnly){

          $select .= '<option  value="myWallet" class="blockchain"> My Wallet </option>';
          $select .= '<option  value="myWallet" class="blockchain"> MetaMask </option>';
        }
        
        for ($i=0; $i < count($accounts); $i++) { 
            $account = (object) $accounts[$i];
            //echo '<pre>'; 
            //// var_dump("balances payment loop balance",$balance);
            //// var_dump("balances payment loop balance->currency->buyCurrency",$balance->currency->buyCurrency);
            // echo '</pre>';
            // print_r($account);
            // print_r($balance->currency);
            if($exchangeAccountOnly){

              if($account->currency == $stableToken->id && $account->name == "Exchange"){
                $payment_methods[] = $account;
                // $select .= '<option value="'.$account->id.'">'.$account->spendingBalance.' - '.$account->currency->name.'</option>';
                $select .= '<option value="'.$account->id.'">$ '.$account->spendingBalance.'</option>';
              }
            }else{
              if($account->currency == $stableToken->id && $account->name == "Spending"){
                $payment_methods[] = $account;
                // $select .= '<option value="'.$account->id.'">'.$account->spendingBalance.' - '.$account->currency->name.'</option>';
                $select .= '<option value="'.$account->id.'">$ '.$account->spendingBalance.'</option>';
              }

            }
            
        }
 
  


        $select .= '</select>';
        $result['select'] = $select; 
        $result['balances'] = $balances; 
        $result['payment_methods'] = $payment_methods; 
        return $result;
        
      }
  
      /*
      * Custom CSS and JS, in most cases required only when you decided to go with a custom credit card form
      */
      public function payment_scripts() {
  
        // // we need JavaScript to process a token only on cart/checkout pages, right?
        // if ( ! is_cart() && ! is_checkout() && ! isset( $_GET['pay_for_order'] ) ) {
        //   return;
        // }
      
        // // if our payment gateway is disabled, we do not have to enqueue JS too
        // if ( 'no' === $this->enabled ) {
        //   return;
        // }
      
        // // no reason to enqueue JavaScript if API keys are not set
        // if ( empty( $this->private_key ) || empty( $this->publishable_key ) ) {
        //   return;
        // }
      
        // // do not work with card detailes without SSL unless your website is in a test mode
        // if ( ! $this->testmode && ! is_ssl() ) {
        //   return;
        // }
      
        // // let's suppose it is our payment processor JavaScript that allows to obtain a token
        // wp_enqueue_script( 'misha_js', 'https://www.mishapayments.com/api/token.js' );
      
        // // and this is our custom JS in your plugin directory that works with token.js
        // wp_register_script( 'woocommerce_misha', plugins_url( 'misha.js', __FILE__ ), array( 'jquery', 'misha_js' ) );
      
        // // in most payment processors you have to use PUBLIC KEY to obtain a token
        // wp_localize_script( 'woocommerce_misha', 'misha_params', array(
        //   'publishableKey' => $this->publishable_key
        // ) );
      
        // wp_enqueue_script( 'woocommerce_misha' );
      
      }
  
      /*
      * Fields validation, more in Step 5
      */
      public function validate_fields(){
        /*
          make sure user has stable token balance 
        */
        if( empty( $_POST[ 'account_id' ]) ) {
          wc_add_notice(  'Please select which account you want to pay from', 'error' );
          return false;
        }
        return true;
      
      }
  
      /*
      * We're processing the payments here, everything about it is in Step 5
      */
      public function process_payment( $order_id ) {
        /*
          pay token with order note info make sure they only pay with exchange account 
        */
  
        global $woocommerce;
        
        // we need it to get any order detailes
        $order = wc_get_order( $order_id );
        $total_amount = $order->get_total();

        //TODO add code to to que web transaction

        $from_account_id = $_POST[ 'account_id' ];

        $paidWithWallet = false;
        if("myWallet" == $from_account_id){
          // veryify payment in buy_order
            //kek if transaktion has been used //
            // if transation komplete mark order as paid for //
            // if transastion pending, make order as pending //
            //mark transations as used  //
          $transactionHash = $_POST[ 'transactionHash' ];
          $network = $_POST[ 'network' ];
          $payment_id = $_POST[ 'payment_id' ];
          $transactionHashKey = "exchange_payment_hash_".$transactionHash;
          $transactionHashKeyUsed = get_option($transactionHashKey);
          $payment_idKey = "exchange_payment_id".$payment_id;
          $payment_idKeyUsed = get_option($payment_idKey);
          if($transactionHashKeyUsed){
            wc_add_notice(  'Transaction hash already used.', 'error' );
            return;
          }else if($payment_idKeyUsed){
            wc_add_notice(  'Payment ID already used.', 'error' );
            return;
          }else{
     
            $paymentInfo["paymentId"] = $payment_id;
            $paymentInfo["network"] = $network;
            $paymentInfo["transactionHash"] = $transactionHash;
            $paymentInfo["amount"] = $total_amount;


            $paymentResult = (array) $this->yohshow_api->verify_payment($paymentInfo);
            $transactionHashStatus = $paymentResult["status"];
            $receipt = $paymentResult["receipt"];
            if($paymentResult["error"]){
              wc_add_notice(  $paymentResult["msg"], 'error' );
              return;
            }
            $exchange_blockchain_payment_meta_id = update_post_meta($order_id,"exchange_blockchain_payment",true);
            $exchange_blockchain_transaction_hash_meta_id = update_post_meta($order_id,"exchange_blockchain_transaction_hash",$transactionHash);
            $exchange_blockchain_payment_id_meta_id = update_post_meta($order_id,"exchange_blockchain_payment_id",$payment_id);
            $exchange_blockchain_network_meta_id = update_post_meta($order_id,"exchange_blockchain_network",$network);

            update_option($transactionHashKey,true);
            update_option($payment_idKey,true);

            $order->add_order_note( "payment method - $from_account_id", true );
            $order->add_order_note( "network - $network", true );
            $order->add_order_note( "network paymentId - $paymentId", true );
            $receiptStr = json_encode($receipt);
            $order->add_order_note( "network receipt - $receiptStr", true );
            $order->add_order_note( "transactionHash - $transactionHash", true );
            $order->add_order_note( "transactionHash status - $transactionHashStatus", true );

            error_log("mywallet payment result status ".$paymentResult["status"]   );


            
            if($paymentResult["status"] == "success" ){
              

              // we received the payment
              $order->payment_complete();
                wc_reduce_stock_levels( $order_id );
              //$order->wc_reduce_stock_levels();

        
              // some notes to customer (replace true with false to make it private)
              $order->add_order_note( 'Hey, your order is paid! Thank you!', true );
        
              // Empty cart
              $woocommerce->cart->empty_cart();

              //updat order status to complete to trigger buy_order
              // $order->update_status("Completed", 'Paid and now process all exchange orders', TRUE);  
              $paidWithWallet = true;

        
              // Redirect to the thank you page
              // return array(
              //   'result' => 'success',
              //   'redirect' => $this->get_return_url( $order )
              // );

            }else if($paymentResult["status"] == "pending" ){
              // we received the payment
              // $order->payment_complete();
                wc_reduce_stock_levels( $order_id );
              //$order->wc_reduce_stock_levels();

        
              // some notes to customer (replace true with false to make it private)
              $order->add_order_note( "Hey, your order is pending a blockchain payment. $network - $transactionHash", true );
        
              // Empty cart
              $woocommerce->cart->empty_cart();
              $now = time();
              $clearing_date = strtotime('+5 minutes', $now);
              $exchange_pending_blockchain_payments = get_option( 'exchange_pending_blockchain_payments' );
              $pending_order["orderId"] =   $order_id;
              $pending_order["order_id"] =   $order_id;
              $pending_order["paymentId"] = $payment_id;
              $pending_order["payment_id"] = $payment_id;
              $pending_order["network"] = $network;
              $pending_order["transactionHash"] = $transactionHash;
              $pending_order["transaction_hash"] = $transactionHash;
              $pending_order["amount"] = $total_amount;
              $pending_order["clearing_date"] = $clearing_date;
              $pending_order["clearingDate"] = $clearing_date;
              

              if(false == $exchange_pending_blockchain_payments){
                $exchange_pending_blockchain_payments = array();
              }
              array_push($exchange_pending_blockchain_payments,$pending_order);

              $exchange_pending_blockchain_payments_meta_id = update_option( 'exchange_pending_blockchain_payments', $exchange_pending_blockchain_payments );
        
              // Redirect to the thank you page
              return array(
                'result' => 'success',
                'redirect' => $this->get_return_url( $order )
              );

            }
          }
          

        }
        if(true){
          $order_totals = $this->order_totals($order);
          $total_amount = $order_totals['total_amount'];
          $tokenized_total = $order_totals['tokenized_total'];
          $nontokenized_total = $order_totals['nontokenized_total'];

          if(!$paidWithWallet){
            $accountResults = (array) $this->yohshow_api->accounts($from_account_id);
            $account = (array) $accountResults['account'];
            $spendingBalance = $account['spendingBalance'];
            if(!$account){
              wc_add_notice(  'Processing error.', 'error' );
              return;
            }
            $funded = $spendingBalance >= $total_amount;

            if(!$funded){
              wc_add_notice(  'Insufficient funds.', 'error' );
              return;
            }
            $exchange_wallet_payment = update_post_meta($order_id,"exchange_wallet_payment",false);


          }else{
            $exchange_wallet_payment = update_post_meta($order_id,"exchange_wallet_payment",true);

          }

          
          $exchange_internal_payment = update_post_meta($order_id,"exchange_internal_payment",true);
          $exchange_internal_payment_method_account_id = update_post_meta($order_id,"exchange_internal_payment_method_account_id",$from_account_id);
          //add payment method to meta data
        
        
          /*
            * Array with parameters for API interaction
          */
          $args = array();
        
          /*
          * Your API interaction could be built with wp_remote_post()
            */

            

          //       $response = wp_remote_post( '{payment processor endpoint}', $args );

          
            try {
              $success = true;
              if($tokenized_total > 0 ){
                do_action( 'exchange_buy_order',$order_id );
                $exchange_order_fullfiled = get_post_meta($order_id,"exchange_order_fullfiled",true);
                if(!$exchange_order_fullfiled) $success =  false;
                error_log( "yoh show payments process payments exchange_order_fullfiled ". print_r( $exchange_order_fullfiled, true ) );


              }
              if($nontokenized_total > 0 ){
                // create payment transaction
                //issue tokens stable tokens
                $transaction_data["type"] = "payment";
                // $transaction_data["amount"] = $net_total_paid;
                $transaction_data["amount"] = $nontokenized_total;
                $transaction_data["tokenId"] = $this->app_token_exchange_id;
                $transaction_data["apiKey"] = $this->publishable_key;
                $transaction_data["apiSecret"] = $this->private_key;
                $transaction_data["issueBuyCurrency"] = false;
                $transaction_data["fromAccountId"] = $from_account_id;
                $transaction_data["note"] = "Store Order ".$order_id;
                // for paymenrt of non tokenized things
                $transaction = (array) $this->yohshow_api->request("POST","/tokens/createTransaction",$transaction_data);
                error_log( "yoh show payments process payments transaction ". print_r( $transaction, true ) );

                
                if(!$transaction['success']) $success =  false;


              }

            

              // if all transactions are success

              if($success){
                // we received the payment
                $order->payment_complete();
                  wc_reduce_stock_levels( $order_id );
                //$order->wc_reduce_stock_levels();

          
                // some notes to customer (replace true with false to make it private)
                $order->add_order_note( 'Hey, your order is paid! Thank you!', true );
          
                // Empty cart
                $woocommerce->cart->empty_cart();


          
                // Redirect to the thank you page
                return array(
                  'result' => 'success',
                  'redirect' => $this->get_return_url( $order )
                );

              }else {
                  update_post_meta($order_id,"exchange_internal_payment",false);

                  $exchange_internal_payment_error = get_post_meta($order_id,"exchange_internal_payment_error",true);
                  error_log( "yoh show payments process payments exchange_internal_payment_error ". print_r( $exchange_internal_payment_error, true ) );
                  
                  if($exchange_internal_payment_error){
                    wc_add_notice(  $exchange_internal_payment_error, 'error' );

                  }else{
                    wc_add_notice(  'Please try again...', 'error' );

                  }



                  return;
              }
          
            } catch (\Throwable $th) {
              //throw $th;
              $exchange_internal_payment = update_post_meta($order_id,"exchange_internal_payment",false);
              error_log($th  );
              wc_add_notice(  'Network error.', 'error ');
              return;
            }
          
        }
        


        
          
      
        if( !is_wp_error( $response ) ) {
      
          $body = json_decode( $response['body'], true );
      
          // it could be different depending on your payment processor
          if ( $body['response']['responseCode'] == 'APPROVED' ) {
      
            // we received the payment
            $order->payment_complete();
            $order->wc_reduce_stock_levels();
      
            // some notes to customer (replace true with false to make it private)
            $order->add_order_note( 'Hey, your order is paid! Thank you!', true );
      
            // Empty cart
            $woocommerce->cart->empty_cart();
      
            // Redirect to the thank you page
            return array(
              'result' => 'success',
              'redirect' => $this->get_return_url( $order )
            );
      
          } else {
            error_log( "there was an error 2" );
            error_log( $response );

            wc_add_notice(  'Please try again. 2', 'error' );
            return;
          }
      
        } else {
          wc_add_notice(  'Connection error.', 'error' );
          return;
        }
      
      }
  
      /*
      * In case you need a webhook, like PayPal IPN etc
      */
      public function webhook() {
  
      // ...
  
      }
      
      public function order_totals($order){
          $total_amount = $order->get_total();
          $line_items = $order->get_items();
          $tokenized_total = 0;
          $nontokenized_total = 0;
          // // var_dump("buy order line_items",$line_items);
          // for ($i=0; $i < count($line_items); $i++) { 
          foreach ($line_items as $i => $line_item) {
              // $line_item = $line_items[$i];
              // // var_dump("buy order line_item",$line_item);
              // exit;
              $product_id = $line_item->get_product_id();
              //extract meta data here
              
              $tokenized = get_post_meta($product_id,"tokenized",true);
            //   // var_dump("buy order tokenized",$tokenized);
            //   // var_dump("buy order product_id",$product_id);
              // exit;
              $line_item_id = $line_item->get_id();
              $quantity = $line_item->get_quantity();
              $total = $line_item->get_total();
              $get_total_tax = $line_item->get_total_tax();
              $checkout_redirect = $line_item->get_meta('checkout_redirect');
              $net_total_paid = $total - $get_total_tax;

              if($tokenized){
                $tokenized_total += $total; 
              }else{
                $nontokenized_total += $total; 
              }
          }
          $totals['checkout_redirect'] = isset($checkout_redirect) ? $checkout_redirect : "";
          $totals['total_amount'] = $total_amount;
          $totals['tokenized_total'] = $tokenized_total;
          $totals['nontokenized_total'] = $nontokenized_total;
          return $totals;
          

      }
      function init(){
          $this->enqueue_scripts();
          $this->create_endpoints();
          // $this->add_shortcodes();
      }
      public function create_endpoints(){

       
  
          $register_result = add_action( 'rest_api_init', function () {

              register_rest_route( 'yohshow/api/v1', '/payments/accounts', array(
                'methods' => 'POST',
                'callback' => array($this,"accounts")
              ) );  //

  
              
  
              
  
            } );
        
      }
      public function enqueue_scripts(){
          $this->enqueue_scripts_folder("assets/dependencies");
          $this->enqueue_scripts_folder("assets/js");
          $this->enqueue_scripts_folder("assets/js/components");
          $this->enqueue_scripts_folder("assets/js/components/exchange");
          $this->enqueue_scripts_folder("assets/js/pages");

      }




      public function enqueue_scripts_folder($path){
          foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
              // $file contains the name and extension of the file
              $file_name = basename($file);
              $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
              //echo '<pre>'; 
              //// var_dump("file_url",$file_url);
              //echo '</pre>';
              // exit;
              wp_enqueue_script( $file_name, $file_url,array("jquery","vue","vueRouter"));
          }
          // // var_dump("$path/*.css" );

          foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
              // $file contains the name and extension of the file
              $file_name = basename($file);
              $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
              // echo '<pre>'; 
              // // var_dump("file_url",$file_url);
              // echo '</pre>';
              // exit;
              wp_enqueue_style( $file_name, $file_url);
          }
          foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
              // $file contains the name and extension of the file
              $file_name = basename($file);
              $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
              // echo '<pre>'; 
              // // var_dump("file_url",$file_url);
              // echo '</pre>';
              // exit;
              wp_enqueue_style( $file_name, $file_url,array("jquery","vue","vueRouter"));
          }
      }
    }
  }
} catch (\Throwable $th) {
  //throw $th;
  error_log("Payment error - ".$th);
}
