<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */

$origin_url = '*';
    
// Check if production environment or not
if (false) {
// if (ENVIRONMENT === 'production') {
  $origin_url = esc_url_raw( site_url() );
}

// header( 'Access-Control-Allow-Origin: ' . $origin_url );
// header( 'test: ' . $origin_url );
// header( 'Content-Security-Policy: frame-src *' );
// header( 'Content-Security-Policy: frame-ancestors *' );


 

class Yohshow_Tokenize extends Yohshow_WP {


    public $standard_mint_price = 20;
    public $default_access_quantity = 1;
    public $token_sell_commmission = .1;
    
    public function __construct($yohshow_api) {
        parent::__construct($yohshow_api);
        $this->init();
      
    }
    function init(){
        // // var_dump("test balances init");
        // $this->register_scripts();
        $this->create_endpoints();
        $this->add_shortcodes();

        $this->add_actions();
        // $this->tokenize_app();
        //$this->start_session();
        $this->activate_taxonomy();
        $this->activate_cors();
        //exchange_pending_blockchain_payments

    }
    public function create_endpoints(){
      $register_result = add_action( 'rest_api_init', function () {

          register_rest_route( 'yohshow/api/v1', '/mint', array(
            'methods' => 'POST',
            'callback' => array($this,"mint")
          ) );  //

          register_rest_route( 'yohshow/api/v1', '/mint/overview', array(
            'methods' => 'POST',
            'callback' => array($this,"mint_overview")
          ) );  //
          register_rest_route( 'yohshow/api/v1', '/mint/upload', array(
            'methods' => 'POST',
            'callback' => array($this,"mint_upload")
          ) );  //

          register_rest_route( 'yohshow/api/v1', '/mint/update', array(
            // 'methods' => 'PUT',
            'methods' => 'POST',
            'callback' => array($this,"update_token")
          ) );  //

          register_rest_route( 'yohshow/api/v1', '/mint/deploy/init', array(
            // 'methods' => 'PUT',
            'methods' => 'POST',
            'callback' => array($this,"deploy_token_init")
          ) );  //
          register_rest_route( 'yohshow/api/v1', '/mint/deploy', array(
            // 'methods' => 'PUT',
            'methods' => 'POST',
            'callback' => array($this,"deploy_token")
          ) );  //

          register_rest_route( 'yohshow/api/v1', '/transaction/save', array(
            // 'methods' => 'PUT',
            'methods' => 'POST',
            'callback' => array($this,"save_transaction")
          ) );  //

          register_rest_route( 'yohshow/api/v1', '/auth/quote', array(
            // 'methods' => 'PUT',
            'methods' => 'POST',
            'callback' => array($this,"auth")
          ) );  //



        });
      
    }
    public function auth($request){
      // error_log("auth called!", 0);

      $post = $request->get_params();
      $apiKey = $post["apiKey"];
      $apiSecret = $post["apiSecret"];
      $action = $post["action"];

      // error_log( "auth post". print_r( $post, true ) );


      
  

      if($this->yohshow_api_key !== $apiKey || $this->yohshow_api_secret !== $apiSecret  ){

        $result["flag"] = false;
        $result["success"] = false;
        $result["msg"] = "Unauthroized";
        $result["message"] = "Unauthroized";
        $result["error"] = "Unauthroized";
        error_log( "auth result". print_r( $result, true ) );

        return $result;
 
      }


      if($action == "quote"){
        $quote_source_key = "exchange_quote_source";
        $quote_source = get_option( $quote_source_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

        //

        $quote_source_api_key_key = "exchange_quote_source_api_key";
        $quote_source_api_key = get_option( $quote_source_api_key_key );

        $quote_source_api_secret_key = "exchange_quote_source_api_secret";
        $quote_source_api_secret = get_option( $quote_source_api_secret_key );

        $quote_source_api_memo_key = "exchange_quote_source_api_memo";
        $quote_source_api_memo = get_option( $quote_source_api_memo_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

        $network = $quote_source;


        $result["flag"] = true;
        $result["success"] = true;
        $result["exchange"] = $network;
        $result["exchangeApiKey"] = $quote_source_api_key;
        $result["exchangeApiSecret"] = $quote_source_api_secret;
        $result["exchangeApiMemo"] = $quote_source_api_memo;
        $result["exchangeBuyCurrency"] = $quote_source_buy_currency;

        error_log( "auth result". print_r( $result, true ) );


        return $result;
        

      }


    }
    public function process_payments(){
      //job should be hourly
      //get last time job was ran
      $now = time();
      $exchange_pending_blockchain_payments_timestamp = get_option( "exchange_pending_blockchain_payments_timestamp" );

      $mustProcessPayments = $exchange_pending_blockchain_payments_timestamp ? round(($exchange_pending_blockchain_payments_timestamp - $now) / 300) : true;
      //if job was ran longer than a hour ago,
//        $mustProcessPayments = true;
      if($mustProcessPayments){
        $exchange_pending_blockchain_payments = get_option( "exchange_pending_blockchain_payments");
        $exchange_pending_blockchain_payments =  $exchange_pending_blockchain_payments  === false ? array() : $exchange_pending_blockchain_payments;
        $still_pending_payments = array();
        for ($i=0; $i < count($exchange_pending_blockchain_payments) ; $i++) {
          $exchange_pending_blockchain_payment = $exchange_pending_blockchain_payments[$i];  
          $exchange_pending_blockchain_payment_clearing_date = $exchange_pending_blockchain_payment["clearing_date"]; 
          $paymentNow = $now > $exchange_pending_blockchain_payment_clearing_date;
//          $paymentNow = true;
          if($paymentNow){
            //do payment
            $blockchain_payment = $this->blockchain_payment($exchange_pending_blockchain_payment);
            if($blockchain_payment["success"]){
              //update pending to finished
              //add to finished payments
              //remove from pending

            }else{
              $still_pending_payments[] = $exchange_pending_blockchain_payment;
            }
            
          }else{
            //add to new pending list 
            $still_pending_payments[] = $exchange_pending_blockchain_payment;
           }

        }
        $exchange_pending_blockchain_payments_meta_id = update_option( "exchange_pending_blockchain_payments",$still_pending_payments);
        $exchange_pending_blockchain_payments_timestamp_meta_id = update_option( "exchange_pending_blockchain_payments_timestamp",$now);

      }
        //get pending payments
        //if withdraw time is schedule
          //run withdraw
          //if with draw was success update withdraw and add to success ful withdraw and out of pending 

    }
    public function blockchain_payment($exchange_pending_blockchain_payment){
        try {
          $transactionHash = $exchange_pending_blockchain_payment[ 'transactionHash' ];
          $network = $exchange_pending_blockchain_payment[ 'network' ];
          $amount = $exchange_pending_blockchain_payment[ 'amount' ];
          $payment_id = $exchange_pending_blockchain_payment[ 'payment_id' ];
          $order_id = $exchange_pending_blockchain_payment[ 'order_id' ];

          $paymentInfo["paymentId"] = $payment_id;
          $paymentInfo["network"] = $network;
          $paymentInfo["transactionHash"] = $transactionHash;
          $paymentInfo["amount"] = $amount;
          $paymentResult = (array) $this->yohshow_api->verify_payment($paymentInfo);
          if($paymentResult["error"]){
            $result["success"] = false;
            $result["flag"] = false;
            $result["error"] = true;
            $result["msg"] = $paymentResult["msg"];
            return $result;
          } else{
            // $transactionHash = get_post_meta($order_id,"exchange_blockchain_transaction_hash",true);
            // $payment_id = get_post_meta($order_id,"exchange_blockchain_payment_id",true);
            // $network = get_post_meta($order_id,"exchange_blockchain_network",true);
            
            if($paymentResult["status"] == "complete" ){
              $order = wc_get_order( $order_id );
              // we received the payment
              $order->payment_complete();
                wc_reduce_stock_levels( $order_id );
              //$order->wc_reduce_stock_levels();

        
              // some notes to customer (replace true with false to make it private)
              $order->add_order_note( 'Hey, your order is paid! Thank you!', true );

              $result["success"] = true;
              $result["flag"] = true;
              $result["error"] = false;
              $result["msg"] = "success";
        
      

            }else {
              $result["success"] = false;
              $result["flag"] = false;
              $result["error"] = false;
              $result["msg"] = "payment pending";
            }

          }
        } catch (\Throwable $th) {
          //throw $th;
          $result["success"] = false;
          $result["flag"] = false;
          $result["error"] = true;
          $result["msg"] = "Payment cloud error";
          // return $result;
        }

        
 
        
        return $result;



























      $netAmount = $exchange_pending_blockchain_payment["netAmount"];
      $exchange_wp_user_id = $exchange_pending_blockchain_payment["exchange_wp_user_id"];
      $exchange_payment_id = $exchange_pending_blockchain_payment["exchange_payment_id"];
  
      $exchange_transaction_type = $exchange_pending_blockchain_payment["exchange_transaction_type"];
      $exchange_transaction_network = $exchange_pending_blockchain_payment["exchange_transaction_network"];
      
      $exchange_stripe_account_id = $exchange_pending_blockchain_payment["exchange_stripe_account_id"];
      try {
          $exchange_environment = get_option( "exchange_environment" );
          if($exchange_environment == "production"){
              $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );
          }else{
              $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );
          }
          $stripe = new \Stripe\StripeClient($exchange_stripe_apiSecret);
  
          $yohshow_stripe = new Yohshow_Stripe( $this->yohshow_api );
        //do payment to account of net fee
        $stripe_transfer = $stripe->transfers->create([
          "amount" => $netAmount,
          "currency" => "usd",
          "destination" => $exchange_stripe_account_id,
        ]);
        $stripe_transfer_id = $stripe_transfer->id;
        if($stripe_transfer_id){
          //info to store
            //site trandsaction index //
            //user transaction index?? probably not
            //exchange payment id //
            //stripe payment id //
            //payment type //
            //transaction composit key // external record/payment info - expayment infno
            //transaction type //
            //transaction type //
            //trandsaction index
            //trandsaction index
            //trandsaction index
            // $exchange_transaction_site_meta_ids = update_option("exchange_transaction_ids", array());
            // $exchange_withdraw_site_meta_ids = update_option("exchange_withdraw_ids", array());
            // $exchange_stripe_site_meta_ids = update_option("exchange_stripe_ids", array());
            // $exchange_stripe_withdraw_site_meta_ids = update_option("exchange_stripe_withdraw_ids", array());
            
  
            $exchange_transaction_ids = get_option("exchange_transaction_ids",array());
            $exchange_withdraw_ids = get_option("exchange_withdraw_ids",array());
            $exchange_stripe_ids = get_option("exchange_stripe_ids",array());
            $exchange_stripe_withdraw_ids = get_option("exchange_stripe_withdraw_ids",array());
  
            $exchange_environment_transaction_ids = get_option("exchange_".$exchange_environment."_transaction_ids",array());
            $exchange_environment_withdraw_ids = get_option("exchange_".$exchange_environment."_withdraw_ids",array());
            $exchange_environment_stripe_ids = get_option("exchange_".$exchange_environment."_stripe_ids",array());
            $exchange_environment_stripe_withdraw_ids = get_option("exchange_".$exchange_environment."_stripe_withdraw_ids",array());
  
            $exchange_transaction_cnt = count($exchange_transaction_ids);
            $exchange_transaction_type = "withdraw";
            $exchange_transaction_network = "stripe";
  
            //add enviorment to transation key
            $exchange_transaction_key = $exchange_transaction_cnt."_".$exchange_environment."_".$exchange_transaction_type."_".$exchange_transaction_network."_".$stripe_transfer_id."_".$exchange_payment_id. "_". $exchange_wp_user_id;
  
  
          //save site transfer
            //stripe withdraw ids
            //stripe ids
            // exchange withdraw ids / payment id
            // exchange transaction  ids / payment id
  
            array_push($exchange_transaction_ids,$exchange_transaction_key);
            array_push($exchange_withdraw_ids,$exchange_transaction_key);
            array_push($exchange_stripe_ids,$exchange_transaction_key);
            array_push($exchange_stripe_withdraw_ids,$exchange_transaction_key);
  
            $exchange_transaction_site_meta_ids = update_option("exchange_transaction_ids",$exchange_transaction_ids);
            $exchange_withdraw_site_meta_ids = update_option("exchange_withdraw_ids",$exchange_withdraw_ids);
            $exchange_stripe_site_meta_ids = update_option("exchange_stripe_ids",$exchange_stripe_ids);
            $exchange_stripe_withdraw_site_meta_ids = update_option("exchange_stripe_withdraw_ids",$exchange_stripe_withdraw_ids);
  
            array_push($exchange_environment_transaction_ids,$exchange_transaction_key);
            array_push($exchange_environment_withdraw_ids,$exchange_transaction_key);
            array_push($exchange_environment_stripe_ids,$exchange_transaction_key);
            array_push($exchange_environment_stripe_withdraw_ids,$exchange_transaction_key);
  
            $exchange_environment_transaction_site_meta_ids = update_option("exchange_".$exchange_environment."_transaction_ids",$exchange_environment_transaction_ids);
            $exchange_environment_withdraw_site_meta_ids = update_option("exchange_".$exchange_environment."_withdraw_ids",$exchange_environment_withdraw_ids);
            $exchange_environment_stripe_site_meta_ids = update_option("exchange_".$exchange_environment."_stripe_ids",$exchange_environment_stripe_ids);
            $exchange_environment_stripe_withdraw_site_meta_ids = update_option("exchange_".$exchange_environment."_stripe_withdraw_ids",$exchange_environment_stripe_withdraw_ids);
  
  
     
  
  
          //save user transfer
          $exchange_transaction_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_transaction_ids",$exchange_transaction_key);
          $exchange_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_withdraw_ids",$exchange_transaction_key);
          $exchange_stripe_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_stripe_ids",$exchange_transaction_key);
          $exchange_stripe_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_stripe_withdraw_ids",$exchange_transaction_key);
  
          $exchange_environment_transaction_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_transaction_ids",$exchange_transaction_key);
          $exchange_environment_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_withdraw_ids",$exchange_transaction_key);
          $exchange_environment_stripe_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_stripe_ids",$exchange_transaction_key);
          $exchange_environment_stripe_withdraw_user_meta_ids = add_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_stripe_withdraw_ids",$exchange_transaction_key);
  
          $exchange_pending_withdraws = get_user_meta($exchange_wp_user_id,"exchange_pending_withdraws",true);
          $exchange_pending_withdraws = $exchange_pending_withdraws? $exchange_pending_withdraws : array();
          unset($exchange_pending_withdraws[$exchange_payment_id]);
          $exchange_pending_withdraws_user_meta_id = update_user_meta($exchange_wp_user_id,"exchange_pending_withdraws",$exchange_pending_withdraws);
  
          $exchange_enviorment_pending_withdraws = get_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_pending_withdraws",true);
          $exchange_enviorment_pending_withdraws = $exchange_enviorment_pending_withdraws? $exchange_enviorment_pending_withdraws : array();
          unset($exchange_enviorment_pending_withdraws[$exchange_payment_id]);
          $exchange_enviorment_pending_withdraws_user_meta_id = update_user_meta($exchange_wp_user_id,"exchange_".$exchange_environment."_pending_withdraws",$exchange_enviorment_pending_withdraws);
  
          $flag = true;
          $msg = "success";
  
  
          
  
        }else{
          //throw $th;
          $flag = false;
          $msg = "Payment cloud ID error.";
        }
      } catch (\Throwable $th) {
        //throw $th;
        $stripe_transfer =false;
        $flag = false;
        $msg = "Payment cloud error.";
      }
      $result["success"] = $flag;
      $result["msg"] = $msg;
      return $result;
  
    }

    //scripts 
    public function add_shortcodes(){
      
      


    }
    public function activate_cors(){
      // add_action( 'init', array($this,"initCors") );
      add_action( 'send_headers', array($this,"initCors") );
      add_filter( 'wp_headers', array($this,"initCors"), 999 );
    }
    
    public function initCors( ) {
      $origin_url = '*';
    
      // Check if production environment or not
      if (false) {
      // if (ENVIRONMENT === 'production') {
        $origin_url = esc_url_raw( site_url() );
      }
    
//       header( 'Access-Control-Allow-Origin: ' . $origin_url );
//       header( 'test: ' . $origin_url );
// header( 'Content-Security-Policy: frame-src *' );
// header( 'Content-Security-Policy: frame-ancestors *' );

      // header( 'Access-Control-Allow-Methods: GET' );
      // header( 'Access-Control-Allow-Credentials: true' );
      // return $value;
      // exit;

    }
    
    public function activate_taxonomy(){
     $this->register_taxonomy();
//      $this->activate_links();
    }
    public function activate_links(){
//        return;
      try {
        if( !session_id() )
          {
            session_start();
          }
        $exchange_wp_user_id = isset($_SESSION["exchange_wp_user_id"]) ? $_SESSION["exchange_wp_user_id"] : false;
        $getUserNameResult = $this->get_username($exchange_wp_user_id);
        $username_link = isset($getUserNameResult["username_link"]) ? $getUserNameResult["username_link"]  : "";
        $loggedIn = $exchange_wp_user_id ? true:false;
        $logoutUrl = wp_logout_url( "/" );

//        $owner_taxonomy = get_taxonomy( 'owner' );
    
/*
            
*/
          ?>
          
          <script type="text/javascript" >
            jQuery( document ).ready(function() {





              if(jQuery(".yoh-balances").length == 0){
                jQuery('.exchange-link').off('click').on( "click", function(evt) {
                   evt.preventDefault();
                    var href = jQuery(evt.target).attr("href");
                    window.location.replace(href);
                });
              }
   
                

                jQuery(".exchange-my-wallet a").attr("href","<?php echo $username_link; ?>");
                jQuery(".exchange-log-out a").attr("href","<?php echo $logoutUrl; ?>");


                var exchangeAppCnt = jQuery(".exchange-app-pg").length;
                if(exchangeAppCnt == 0 ){
                  jQuery( ".exchange-logged-in a, .exchange-logged-in a" ).click(function(e) {
                    var link = jQuery(e.target).attr("href");
                    window.location = link;
                  });

                }
                
                <?php 
                  if($loggedIn){
                ?>
                  jQuery(".exchange-logged-in").show();
                  jQuery(".exchange-logged-out").hide();


                <?php
                  }else{
                ?>
                  jQuery(".exchange-logged-in").hide();
                  jQuery(".exchange-logged-out").show();
                
                <?php
                  }
                ?>
            });

          </script>
          <?php
    


      } catch (\Throwable $th) {
        //throw $th;
        $error = $th;
      }
      
      
    }
    public function register_taxonomy(){
        $labels = [
            "name" => __( "Collections", "yohshow" ),
            "singular_name" => __( "Collection", "yohshow" ),
        ];

      $args = [
        "label" => __( "Collections", "yohshow" ),
        "labels" => $labels,
        "public" => true,
        "publicly_queryable" => true,
        "hierarchical" => true,
        "show_ui" => true,
        "show_in_menu" => true,
        "show_in_nav_menus" => true,
        "query_var" => true,
        "rewrite" => [ 'slug' => 'collections', 'with_front' => false,  'hierarchical' => true, ],
        "show_admin_column" => false,
        "show_in_rest" => true,
        "show_tagcloud" => false,
        "rest_base" => "collections",
        "rest_controller_class" => "WP_REST_Terms_Controller",
        "show_in_quick_edit" => false,
        "show_in_graphql" => false,
      ];
      register_taxonomy( "collections", [ "product","attachment" ], $args );
        $labels = [
            "name" => __( "Owners", "yohshow" ),
            "singular_name" => __( "Owner", "yohshow" ),
        ];
      $args = [
        "label" => __( "Owners", "yohshow" ),
        "labels" => $labels,
        "public" => true,
        "publicly_queryable" => true,
        "hierarchical" => false,
        "show_ui" => true,
        "show_in_menu" => true,
        "show_in_nav_menus" => true,
        "query_var" => true,
        "rewrite" => [ 'slug' => 'owner', 'with_front' => true, ],
        "show_admin_column" => false,
        "show_in_rest" => true,
        "show_tagcloud" => false,
        "rest_base" => "owner",
        "rest_controller_class" => "WP_REST_Terms_Controller",
        "show_in_quick_edit" => false,
        "show_in_graphql" => false,
      ];
      register_taxonomy( "owner", [ "product" ], $args );

        $labels = [
            "name" => __( "Creators", "yohshow" ),
            "singular_name" => __( "Creator", "yohshow" ),
        ];
      $args = [
        "label" => __( "Creators", "yohshow" ),
        "labels" => $labels,
        "public" => true,
        "publicly_queryable" => true,
        "hierarchical" => false,
        "show_ui" => true,
        "show_in_menu" => true,
        "show_in_nav_menus" => true,
        "query_var" => true,
        "rewrite" => [ 'slug' => 'creator', 'with_front' => true, ],
        "show_admin_column" => false,
        "show_in_rest" => true,
        "show_tagcloud" => false,
        "rest_base" => "creator",
        "rest_controller_class" => "WP_REST_Terms_Controller",
        "show_in_quick_edit" => false,
        "show_in_graphql" => false,
      ];
      register_taxonomy( "creator", [ "product" ], $args );

      
      $labels = [
          "name" => __( "Utilities", "yohshow" ),
          "singular_name" => __( "Utility", "yohshow" ),
      ];
      $args = [
        "label" => __( "Utility", "yohshow" ),
        "labels" => $labels,
        "public" => true,
        "publicly_queryable" => true,
        "hierarchical" => false,
        "show_ui" => true,
        "show_in_menu" => true,
        "show_in_nav_menus" => true,
        "query_var" => true,
        "rewrite" => [ 'slug' => 'utility', 'with_front' => true, ],
        "show_admin_column" => false,
        "show_in_rest" => true,
        "show_tagcloud" => false,
        "rest_base" => "utility",
        "rest_controller_class" => "WP_REST_Terms_Controller",
        "show_in_quick_edit" => false,
        "show_in_graphql" => false,
      ];
      register_taxonomy( "utility", [ "product" ], $args );

    }

    public function mint_upload($request){
        try {
            $exchange_currently_minting_token_id = $_SESSION["exchange_currently_minting_token_id"];

            $post = $request->get_params();
            $files = $_FILES;
            $image_url = $files["photo"]['tmp_name'];
            $filename = $files["photo"]['name'];

            

            if($files["photo"]){
              $photoResult = $this->upload_attachment("photo");
              $photo_attach_id = $photoResult["attach_id"];
              // And finally assign featured image to post  
              set_post_thumbnail( $exchange_currently_minting_token_id, $photo_attach_id );
              $result["photo_attach_id"] = $photo_attach_id;


            }


            if($files["collectionPhoto"]){
              $collectionPhotoResult = $this->upload_attachment("collectionPhoto");
              $collectionPhoto_attach_id = $collectionPhotoResult["attach_id"];
              $collectionPhoto_attach_url = $collectionPhotoResult["attach_url"];
              //attach image or image url with collection term site option 
							$terms = get_the_terms( $exchange_currently_minting_token_id, 'collections' );
              $term = $terms[0];
              $collectionTermId = $term->term_id;
              $collectionTermKey = $term->term_id;
              $collectionTermKey ="exchange_collection_term_id_attachment_id_$collectionTermId";
              $exchange_collection_term_id_attachment_id = update_option($collectionTermKey,$collectionPhoto_attach_id);
              // done
              $result["collection_attach_id"] = $collectionPhoto_attach_id;


            }
            $avatar_upload_result = $this->avatar_upload($request);

            $result["success"] = true;
            unset($_SESSION["exchange_currently_minting_token_id"]); // Should do this here if not somewhere elese
            return json_encode($result);

        } catch (Exception $e) {

            $returnData['msg'] = $e->getMessage();
            $returnData['success'] = false;
            return json_encode($returnData);
        }

    }
    

    public function mint_overview($request){
      if( !session_id() )
        {
          session_start();
        }
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];
            $loggedIn = $exchange_wp_user_id ? true:false;
      $post = $request->get_params();
        $post['apiKey'] = $this->yohshow_api_key;


        if($loggedIn){
          $result = $this->send_request("/mint",$post);
          // $result = $this->send_request("/mint/overview",$post);
          $result_info = json_decode($result,true);
        }else{
          $result["mustLogin"] = true; 
          $result["redirect"] = "/login/mint/"; 
          $result_info["flag"] = false;
          $result = json_encode($result); 
          
        }
        
        if($result_info["flag"]){
        // if($result_info["success"]){
          $newToken = $result_info["newToken"];
          $token = $result_info["token"];

          if(!$newToken){
            //get/create product for token. 
            $tokenImport = $this->import_token($token);

            $symbol = $token['symbol'];
            $symbolBase = $token['symbolBase'];
            $token['ownershipPrice'] = floatval($token['ownershipPrice']);
            // $token['ownershipPrice'] = floatval($token['ownershipPrice']);

          // $exchange_action = "access";

//          if($exchange_action == "payment"){
//            $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
//            $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
//            $token_name =  "Pay " . $token->name;
//          }else if($exchange_action == "access"){
            $symbolKeyAccess = "exchange_product_access_symbol_".$symbol;
            $symbolBaseKeyAccess = "exchange_product_access_symbolBase_".$symbolBase;

          // }else if($exchange_action == "sell"){
          //   $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
          //   $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
          //   $token_name =  "Sell " . $token->name;
          // }else{
            $symbolKeyInvest = "exchange_product_symbol_".$symbol;
            $symbolBaseKeyInvest = "exchange_product_symbolBase_".$symbolBase;
            $token_name =  $token->name;
          // }

        

            $symbolKey_product_id = get_option( $symbolKeyAccess );

            if(!$symbolKey_product_id){
              $symbolKey_product_id = get_option( $symbolKeyInvest );

            }
            $symbolKey_product_id = intval($symbolKey_product_id);

            // $image = wp_get_attachment_image_src( get_post_thumbnail_id($symbolKey_product_id), 'single-post-thumbnail' );
            // $image_url = $image[0];

            // $args = array( 'post_type' => 'attachment', 'numberposts' => -1, 'post_status' => null, 'post_mime_type' => 'image', 'post_parent' => $symbolKey_product_id ); 
            // $args = array( 'post_parent' => $symbolKey_product_id ); 
            // $attachments = get_posts( $args );
            // if ( $attachments ) {
            //     foreach ( $attachments as $attachment ) {
            //       $image_url = $attachment;
            //     }
            // }
              $product = wc_get_product( $symbolKey_product_id );
              $image_url = wp_get_attachment_url( $product->get_image_id() );

              $terms = get_the_terms( $symbolKey_product_id, 'collections' );
              if($terms && count($terms)> 0){
                $term = $terms[0];
                $collection = $term->name;
                $collectionTermKey ="exchange_collection_term_id_attachment_id_$term->term_id";
                $exchange_collection_term_id_attachment_id = get_option($collectionTermKey);
                $collectionPhoto = wp_get_attachment_url($exchange_collection_term_id_attachment_id );

              }else{
                $term = false;
                $collection = false;
                $collectionTermKey = false;
                $exchange_collection_term_id_attachment_id = false;
                $collectionPhoto = false;
              }
              
              

              $token['logo'] = $image_url;
              $token['collectionPhoto'] = $collectionPhoto;
              $token['collection'] = $collection;

              $result_info["collection"] = $collection;
              $result_info["collectionPhoto"] = $collectionPhoto;
              

      

          }else{
            $token['logo'] = false;
            $token['collectionPhoto'] = false;
            $token['collection'] = false;

            $result_info["collection"] = false;
            $result_info["collectionPhoto"] = false;
          }

          
            

   

            $getUserNameResult = $this->get_username($exchange_wp_user_id);
            $username = $getUserNameResult["username"];
            $avatar = $getUserNameResult["avatar"];

            

            $user_term_ids_key = "user_collection_term_ids";
            $user_collection_term_ids = get_user_meta($exchange_wp_user_id,"user_collection_term_ids",true);
            $user_collection_term_ids = $user_collection_term_ids ? $user_collection_term_ids : [];
            $collections = get_terms( array('taxonomy' => 'collections', 'term_taxonomy_id' => $user_collection_term_ids) );
            $collections = wp_list_pluck($collections,"name");


            //get mint product
            $mint_token_product_id = get_option( 'mint_token_product_id' );
            $product = wc_get_product( $mint_token_product_id );
            $product_is_on_sale =  $product->is_on_sale();
            if($product_is_on_sale){
                $mint_price = $product->get_sale_price();
            }else{
                $mint_price = $product->get_regular_price();

            }

            

            
            

            $result_info["mintPrice"] = $mint_price;
            $result_info["token"] = $token;
            $result_info["username"] = $username;
            $result_info["avatar"] = $avatar;
            $result_info["collections"] = $collections;


            
            $result_info["loggedIn"] = $loggedIn;


            // isSuperAdmin
            $result_info["me"]["isSuperAdmin"] =  is_super_admin($exchange_wp_user_id);

            $result = json_encode($result_info);


          
        }

        /*
          if token id was set in post
          get token image //
          username ///
          make sure ownershipFor sell and ownershiPrice is float
        */
        return  $result;
    }
    public function create_token($token_info){
//      $token_info = $request->get_params();
        $token_info['apiKey'] = $this->yohshow_api_key;
        // $token_info['quickMint'] = true;
        $token_info['quickMint'] = true;
        
        $result = $this->send_request("/tokens/mint",$token_info); //change enpoint
        $resultProcess = $this->send_request("/tokens/process",$token_info);
        $result = json_decode($result,false);
        return  $result;
    }
    public function save_transaction($request){
        if( !session_id() )
        {
          session_start();
        }
        $post = $request->get_params();
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];
        /*
          get
            action
            product_id
            network
            -------------------
            hash

          save for
            user
            product
            site
          
          get transaction status

          save transaction status

          return transaction status
        */
        $type = $post["type"];
        $action = $post["action"];
        $product_id = $post["product_id"];
        $networkId = $post["networkId"];
        $network = $post["network"];
        $hash = $post["hash"];

        // $key = $type ."_". $action ."_". $networkId ."_". $network;

        // if($action == "sendGas"){
        //   $tokenTokenBookConfig["network"] = $network;
        //   $tokenTokenBookConfig["networkLabel"] = "Etherum";
        //   $tokenTokenBookConfig["deploymentStatus"] = "Unpaid";
        //   $tokenTokenBookConfig["balanceTetherAddress"] = "test";
        //   $tokenTokenBookConfig["id"] = $networkId;
           
        //   $result["flag"] = true;
        //   $result["success"] = true;
        //   $result["network"] = $tokenTokenBookConfig;
        //   return  json_encode($result);
        // }else if($action == "sendPayment"){
        //   $tokenTokenBookConfig["network"] = $network;
        //   $tokenTokenBookConfig["networkLabel"] = "Etherum";
        //   $tokenTokenBookConfig["deploymentStatus"] = "Pending";
        //   $tokenTokenBookConfig["balanceTetherAddress"] = "test";
        //   $tokenTokenBookConfig["id"] = $networkId;

        //   $result["flag"] = true;
        //   $result["success"] = true;
        //   $result["network"] = $tokenTokenBookConfig;
        //   return  json_encode($result);
        // }

        
        $post['apiKey'] = $this->yohshow_api_key;
        // TODO auth user can do
        $post['apiSecret'] = $this->yohshow_api_secret;
        $getTransactionResult = $this->send_request("/tokens/deploy/init",$post); //change enpoint

        $getTransactionResult = json_decode($getTransactionResult,true);



        if($getTransactionResult["success"]){
          $result = $getTransactionResult;
          $transaction["hash"] = $hash;
          $transaction["status"] = $getTransactionResult["status"];
          $transaction["key"] = $key;
          $transaction["id"] = $key;

          $result["flag"] = true;
          $result["success"] = true;
          $result["network"] = $result["tokenTokenBookConfig"]  ;

          if($product_id){
            $transaction_meta_id = update_post_meta($product_id,$key,$transaction);
            $transaction_meta_id = add_post_meta($product_id,"transactions",$transaction);
          }
          $transaction_meta_id = add_user_meta($exchange_wp_user_id,"transactions",$transaction);

        }else{
          $result["success"] = false;
          $result["msg"] = "Update token cloud error";
          $result["error"] = $getTransactionResult;
        }

        error_log( "save_transaction  result ". print_r( $result, true ) );

        
        return  json_encode($result);


    }
    public function deploy_token_init($request){
      /*
        update token in exchange //
        update product/post exchange token info // i dont want to do this i dont think or maybe TODO maybe 
        update stock from for sell status
        update price
        done
      */
        if( !session_id() )
        {
          session_start();
        }
        $post = $request->get_params();
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];


        $post['apiKey'] = $this->yohshow_api_key;
        // TODO auth user can do
        $post['apiSecret'] = $this->yohshow_api_secret;

        $exchange_token_id = $post["tokenId"];
        $exchange_token_symbol = $post["tokenSymbol"];

        $symbolKey = "exchange_product_access_symbol_".$exchange_token_symbol;
        $symbolKey_product_id = get_option( $symbolKey );

        error_log( "deploy_token_init  post ". print_r( $post, true ) );
        
  

        $deployTokenInitResult = $this->send_request("/tokens/deploy/init",$post); //change enpoint
        $deployTokenInitResult = json_decode($deployTokenInitResult,true);
        error_log( "deploy_token_init  deployTokenInitResult ". print_r( $deployTokenInitResult, true ) );

 

        $deployTokenResult = $deployTokenInitResult;
        
        // $deployTokenResult = $this->send_request("/tokens/deploy/",$post); //change enpoint
        // $deployTokenResult = json_decode($deployTokenResult,true);
        // return  $deployTokenResult;

        if($deployTokenResult["success"]){
          
          //stud info
            $networkLabels["mainNet"] = "Etherum";
            $network = $deployTokenResult["tokenTokenBookConfig"]["network"];
          $deployTokenResult["tokenTokenBookConfig"]["networkLabel"] = $networkLabels[$network];
          $deployTokenResult["tokenTokenBookConfig"]["deploymentStatus"] = "Underfueled";
          $deployTokenResult["tokenTokenBookConfig"]["balaceTetherAddress"] = "test";
          $result = $deployTokenResult;




        }else{
          $result["success"] = false;
          $result["msg"] = "Update token cloud error";
          $result["error"] = $deployTokenResult;
        }

        
        return  json_encode($result);
    }
    public function deploy_token($request){
      /*
        update token in exchange //
        update product/post exchange token info // i dont want to do this i dont think or maybe TODO maybe 
        update stock from for sell status
        update price
        done
      */
        if( !session_id() )
        {
          session_start();
        }
        $post = $request->get_params();
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];


        // $post['reDeployTetherBook'] = true;
        // $post['reDeployReceiptBook'] = true;
        
        $post['apiKey'] = $this->yohshow_api_key;
        // TODO auth user can do
        $post['apiSecret'] = $this->yohshow_api_secret;

        $exchange_token_id = $post["tokenId"];
        $exchange_token_symbol = $post["tokenSymbol"];

        $symbolKey = "exchange_product_access_symbol_".$exchange_token_symbol;
        $symbolKey_product_id = get_option( $symbolKey );

  
        error_log( "deploy_token  post ". print_r( $post, true ) );

        $deployTokenInitResult = $this->send_request("/tokens/deploy",$post); //change enpoint
        $deployTokenInitResult = json_decode($deployTokenInitResult,true);
        error_log( "deploy_token  deployTokenInitResult ". print_r( $deployTokenInitResult, true ) );

 

        $deployTokenResult = $deployTokenInitResult;
        
        // $deployTokenResult = $this->send_request("/tokens/deploy/",$post); //change enpoint
        // $deployTokenResult = json_decode($deployTokenResult,true);
        // return  $deployTokenResult;

        if($deployTokenResult["success"]){
          
          //stud info
          //   $networkLabels["mainNet"] = "Etherum";
          //   $network = $deployTokenResult["tokenTokenBookConfig"]["network"];
          // $deployTokenResult["tokenTokenBookConfig"]["networkLabel"] = $networkLabels[$network];
          // $deployTokenResult["tokenTokenBookConfig"]["deploymentStatus"] = "Pending";
          // $deployTokenResult["tokenTokenBookConfig"]["balaceTetherAddress"] = "test";
          $result = $deployTokenResult;




        }else{
          $result["success"] = false;
          $result["msg"] = "Update token cloud error";
          $result["error"] = $deployTokenResult;
        }

        
        return  json_encode($result);
    }

    public function update_token($request){
      /*
        update token in exchange //
        update product/post exchange token info // i dont want to do this i dont think or maybe TODO maybe 
        update stock from for sell status
        update price
        done
      */
        if( !session_id() )
        {
          session_start();
        }
        $post = $request->get_params();
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];


        $post['appApiKey'] = $post["apiKey"];
        $post['appApiSecret'] = $post["apiSecret"];
        $post['apiKey'] = $this->yohshow_api_key;
        // TODO auth user can do
        $post['apiSecret'] = $this->yohshow_api_secret;
        $post['quickMint'] = true;
        $post['collection'] = $post["collectionName"];
        $username = $post["username"];
        $collection = $post["collectionName"];

        $collection = $post["collection"];
        $collectionName = $post["collectionName"];

        $updateUsernameResult = $this->update_username($username);
        if($updateUsernameResult['success'] !== true){
          return json_encode($updateUsernameResult);
        }
        $ownerTermId = $updateUsernameResult['owner_term_id'];

        // $collectionOneToOne = false;
        // $updateCollectionNameResult = $this->create_term("collections", "collection", $collection, $collectionOneToOne);
        // if($updateCollectionNameResult['success'] !== true){
        //   return json_encode($updateCollectionNameResult);
        // }
        // $collectionTermId = $updateCollectionNameResult['collections_term_id'];
//        unset($post['publicAttributes']);

        
        $updateTokenResult = $this->send_request("/tokens/update/",$post); //change enpoint
        $updateTokenResult = json_decode($updateTokenResult,true);
        // return  $updateTokenResult;

        if($updateTokenResult["success"]){
          // $exchange_token_product_id_key =  "exchange_token_product_id_".$tokenId; 
          // $exchange_token_product_id =  get_option($exchange_token_product_id_key); 
          $token = $updateTokenResult["token"];

          $ownershipPrice = $post["ownershipPrice"];
          $ownershipForSell = $post["ownershipForSell"];


          //update user namae start
     

          //update user name end 


          $token['action'] = "access";
          $product = $this->create_product($token);
          wp_set_object_terms( $product->get_id(), (int) $ownerTermId, "owner" );
          // wp_set_object_terms( $product->get_id(), (int) $collectionTermId, "collections" );

				  $publicAttributes_id = update_post_meta( $product->get_id(), 'exchange_public_attributes', $token['publicAttributes'] );
				  $privateAttributes_id = update_post_meta( $product->get_id(), 'exchange_private_attributes', $token['privateAttributes'] );


          $product_url = get_permalink( $product->get_id() );
          $result["redirectUrl"] = $product_url;

          $result["token"] = $token;
          $result["success"] = true;
          $_SESSION["exchange_currently_minting_token_id"] = $product->get_id();



        }else{
          $result["success"] = false;
          $result["msg"] = "Update token cloud error";
          $result["error"] = $updateTokenResult;
        }





        



      

        
        return  json_encode($result);
    }
    public function mint($request){
      try {
        if( !session_id() )
        {
          session_start();
        }
        $post = $request->get_params();
        $username = $post["username"];
        $collection = $post["collection"];
        $collectionName = $post["collectionName"];
        $ownershipPrice = $post["ownershipPrice"];
        $ownershipForSell = $post["ownershipForSell"];
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];

        if($collection == "makeNewCollection"){
          $collection = $collectionName;
        }


        $updateUsernameResult = $this->update_username($username);
        if($updateUsernameResult['success'] !== true){
          return json_encode($updateUsernameResult);
        }
        $ownerTermId = $updateUsernameResult['owner_term_id'];
        $creatorTermId = $updateUsernameResult['creator_term_id'];

        $collectionOneToOne = false;
        $updateCollectionNameResult = $this->create_term("collections", "collection", $collection, $collectionOneToOne);
        if($updateCollectionNameResult['success'] !== true){
          return json_encode($updateCollectionNameResult);
        }
        $collectionTermId = $updateCollectionNameResult['collections_term_id'];

        //create collection code



        $post['apiKey'] = $this->yohshow_api_key;
        $post['mint'] = true;
        //create token and return token result with tokens ide
        // $files = $_FILES;
        $product = $this->create_product($post);
        $token["id"] = $product->get_id();
        $result["token"] = $token;
        $result["success"] = true;
        $_SESSION["exchange_currently_minting_token_id"] = $product->get_id();

        wp_set_object_terms( $product->get_id(), (int) $ownerTermId, "owner" );
        wp_set_object_terms( $product->get_id(), (int) $creatorTermId, "creator" );
        wp_set_object_terms( $product->get_id(), (int) $collectionTermId, "collections" );

        $publicAttributes_id = update_post_meta( $product->get_id(), 'exchange_public_attributes', $post['publicAttributes'] );
				  $privateAttributes_id = update_post_meta( $product->get_id(), 'exchange_private_attributes', $post['privateAttributes'] );

        
      } catch (\Throwable $th) {
        //throw $th;
        $result["success"] = false;
        $result["msg"] = "Cloud error";
        $result["error"] = $th;
        
      }
      



      

        
        return  json_encode($result);
    }
    function collection_index($product_id){
      $terms = get_the_terms( $product_id, 'collections' );
      $term = $terms[0];
      $collectionTermId = $term->term_id;
      //get collection count
        // $args = array( 
        //     'posts_per_page' => -1,
        //     'tax_query'      => array(
        //         array(
        //             'taxonomy'  => 'post_tag',
        //             'field'     => 'slug',
        //             'terms'     => sanitize_title( $brand_name )
        //         )
        //     )
        // );
        $args = array(
                   'posts_per_page' => -1,
                   'post_status' => array('draft','publish'),
                    // 'post_type' => 'recipe_cpt',
                    'tax_query' => array(
                        array(
                        'taxonomy' => 'collections',
                        'field' => 'term_id',
                        'terms' => $collectionTermId
                         )
                      )
                    );
                  $query = new WP_Query($args );
                  //update collection count in option 
                  $count = $query->found_posts;
                  $collectionCountKey ="exchange_collection_count_$collectionTermId";
                  $collectionCountKeyOption = update_option($collectionCountKey,$count);
          
                  //collection count is token id
                  update_post_meta( $product_id, "exchange_collection_index", $count);
                  //update all products / post in collection 
                  while ( $query->have_posts() ) {
                    $query->the_post();
                    $post_id = get_the_ID() ;
                    $exchange_collection_index = get_post_meta( $post_id, "exchange_collection_index", true);
          
                    $item_quantity = "$exchange_collection_index of $count";
                    $item_quantity_id = update_post_meta( $post_id, "item_quantity", $item_quantity);
          
          
                  }
    }



        /**
    * When order status is set to complete
    *
    * @since 1.0.0
    */
    function buy_order($order_id) {
      try {
        // error_log("buy_order called!", 0);

        /*
              If owner order status is complete
                  go through all order variants and get the product ids
                  if any products  have tokenized = true
                      place access buy order 

                      do action buy order

                      get lowest order
                      update product price
          */
        //   // var_dump("buy order order_id",$order_id);
          $yohshow_api =  $this->yohshow_api;
          $apiKey =  $this->yohshow_api_key;
          $apiSecret =  $this->yohshow_api_secret;
          $order = wc_get_order( $order_id );
          $order_status = $order->get_status();
          $customer_id = $order->get_customer_id();
          $exchange_order_fullfiled = get_post_meta($order_id,"exchange_order_fullfiled",true);
          // $this->var_error_log("logged in user customer_id $customer_id");

          if($exchange_order_fullfiled == true ){
          
                          return;
          } 
          $exchange_wallet_payment = get_post_meta($order_id,"exchange_wallet_payment",true);
          $exchange_internal_payment = get_post_meta($order_id,"exchange_internal_payment",true);
          $exchange_internal_payment_method_account_id = get_post_meta($order_id,"exchange_internal_payment_method_account_id",true);

          $issue_buy_currency = $exchange_internal_payment ? false:true;
          $issue_buy_currency = $exchange_wallet_payment ? true: $issue_buy_currency;

          //TODO update payment method at bottom cuz why not
          // $this->var_error_log("buy order exchange_internal_payment $exchange_internal_payment");
          // $this->var_error_log("buy order exchange_internal_payment_method_account_id $exchange_internal_payment_method_account_id");
          // $this->var_error_log("buy order issue_buy_currency $issue_buy_currency");

          


          if($customer_id){
              //must tokenize customer to make sure thses ids are set
            $customer_exchange_token_id = get_user_meta($customer_id, 'exchange_token_id',true);
            $customer_exchange_user_id = get_user_meta($customer_id, 'exchange_user_id',true);
            // $exchange_app_token_account_id = get_user_meta($customer_id, 'exchange_app_token_account_id',true);
            // $this->var_error_log("logged in user exchange_stable_token_account_id $exchange_stable_token_account_id");
            if($exchange_internal_payment_method_account_id && $exchange_internal_payment){
              $exchange_stable_token_account_id = $exchange_internal_payment_method_account_id;

            }else{
              $exchange_stable_token_account_id = get_user_meta($customer_id, 'exchange_stable_token_account_id',true);

            }

          }else{
              //must tokenize guest customer to make sure thses ids are set
            $exchange_stable_token_account_id = get_option('exchange_guest_stable_token_account_id');
            $customer_exchange_token_id = get_option('exchange_guest_token_id');
            $customer_exchange_user_id = get_option('exchange_guest_user_id');
            // $exchange_app_token_account_id = get_option('exchange_guest_app_token_account_id');

            // $this->var_error_log("guest user exchange_stable_token_account_id $exchange_stable_token_account_id");
          }
        //   // var_dump("buy order order_status",$order_status);

          // $login = $this->yohshow_api->login($emailAddress);

          // // var_dump("buy order login",$login);

          $success = true;
          $errorMsgSpecific = "";



          if($order_status == "completed" || $exchange_internal_payment || $exchange_wallet_payment){

            $exchange_order_action = get_post_meta($order_id,'exchange_order_action',true);
            error_log("buy_order called! exchange_order_action $exchange_order_action", 0);


            if($exchange_order_action == "withdraw"){
              $paymentTransfer = $this->withdraw_asset($order_id);
              if($paymentTransfer->success){

              }else{
                  $flag = false;
                  $message = $paymentTransfer->message;
              }

            }else {

                  $line_items = $order->get_items();
                  $looped_through = false;
                  $minted_products = false;
                  $quoteId = false;
                  $to_account_id = false;
                  $exchange_checkout_id = get_post_meta($order_id,'exchange_order_checkout_id',true);
                  if($exchange_checkout_id ){
                    $apiKey =  $this->yohshow_api_key;
                    $apiSecret =  $this->yohshow_api_secret;
                    $checkoutInfo = array(
                      'checkoutId' => $exchange_checkout_id,
                      'apiKey' => $apiKey,
                    );

                    $checkoutResult = (object) $this->yohshow_api->request("post","/checkout/get",$checkoutInfo); 
                    error_log( "buy_order  checkoutResult ". print_r( $checkoutResult, true ) );

                    if($checkoutResult->success){
                        $checkout = $checkoutResult->checkout;
                        $quoteId = $checkoutResult->checkout->quoteId;
                        $to_account_id = $checkoutResult->checkout->to_account_id;
                        
                        $checkoutError = false;

                    }else{
                      //error checkout does not exist
                      $checkoutError = true;
                    }

                  }

                  /*
                    get checkout //
                    get quote id //
                    get match quote id to invest currency
                    if invest currency buy currency
                      user bitmrt api keys with exucte quote id
                    

                  */


                  // // var_dump("buy order line_items",$line_items);
                  // for ($i=0; $i < count($line_items); $i++) { 
                  foreach ($line_items as $i => $line_item) {
                    $looped_through = true;

                      // $line_item = $line_items[$i];
                      // // var_dump("buy order line_item",$line_item);
                      // exit;
                      $product_id = $line_item->get_product_id();

                      
                      $tokenized = get_post_meta($product_id,"tokenized",true);
                    //   // var_dump("buy order tokenized",$tokenized);
                    //   // var_dump("buy order product_id",$product_id);
                      // exit;


                      if($tokenized){
                          $line_item_id = $line_item->get_id();
                          $line_item_fulfilled_key = "line_item_fulfilled_".$line_item_id;
                          $line_item_fulfilled = get_post_meta($order_id,$line_item_fulfilled_key,true);

                          if($line_item_fulfilled){
                            continue;
                          }

                          $quantity = $line_item->get_quantity();
                          $total = $line_item->get_total();
                          $get_total_tax = $line_item->get_total_tax();
                          $net_total_paid = $total - $get_total_tax;
                          $product = wc_get_product( $product_id );
                          $product_type = $product->get_type();
                          // TODO determin if product is on sale because sale price should be use
                          $product_is_on_sale =  $product->is_on_sale();
                          if($product_is_on_sale){
                              $product_price = $product->get_sale_price();
                          }else{
                              $product_price = $product->get_regular_price();

                          }

                        //   // var_dump("buy order line_item",$line_item);
                        //   // var_dump("buy order line_item_id",$line_item_id);
                        //   // var_dump("buy order quantity",$quantity);
                        //   // var_dump("buy order total",$total);
                        //   // var_dump("buy order get_total_tax",$get_total_tax);
                        //   // var_dump("buy order net_total_paid",$net_total_paid);
                          // // var_dump("buy order product",$product);
                        //   // var_dump("buy order product_type",$product_type);
                        //   // var_dump("buy order product_is_on_sale",$product_is_on_sale);
                          
                          // $market = get_post_meta($product_id,"access_market",true);
                          $market = get_post_meta($product_id,"market",true);


                          //need to credit user with total 
                          $exchange_token_id = get_post_meta($product_id,"exchange_token_id",true);       
                          $exchange_action = get_post_meta($product_id,"exchange_action",true); 

                          error_log( "buy_order market". print_r( $market ) );
                          error_log( "buy_order exchange_token_id". print_r( $exchange_token_id ) );
                          error_log( "buy_order exchange_action". print_r( $exchange_action ) );
                          error_log( "buy_order market". print_r( $market ) );


                  

                          
                          //issue tokens stable tokens

                          $transaction_data["type"] = $exchange_action;
                          $transaction_data["amount"] = $net_total_paid;
                          // $transaction_data["amount"] = 100;
                          $transaction_data["tokenId"] = $exchange_token_id;
                          $transaction_data["apiKey"] = $apiKey;
                          $transaction_data["apiSecret"] = $apiSecret;
                          $transaction_data["issueBuyCurrency"] = $issue_buy_currency;
                          $transaction_data["fromAccountId"] = $exchange_stable_token_account_id;

                          
            

                          

                          // var_dump("buy order pre send transaction_data ".$transaction_data);
                          
                          if($exchange_action == "invest" || $exchange_action == "payment"){
                              $transaction_data["note"] = $exchange_action == "invest" ? "Store token buy" : "Store token payment";

                              if($exchange_action == "invest"){


                                // if($customer_exchange_token_id){
                                //   $transaction_data["orderMeta"] = [];
                                //   $transaction_data["orderMeta"]["clientId"] = $customer_exchange_token_id;
                                //   $transaction_data["orderMeta"]["clientType"] = "token";
                                //   $transaction_data["orderMeta"]["brokerCommission"] = 0;
                                //   $transaction_data["orderMeta"] = json_encode($transaction_data["orderMeta"]);
                                // }
                                if($customer_exchange_user_id){
                                  $transaction_data["transactionOwnerId"] = $customer_exchange_user_id;
                                }
                              }
                              if($exchange_internal_payment){
                                ///get balance before
                                $accountResults = (array) $this->yohshow_api->accounts($exchange_internal_payment_method_account_id);
                                $account = (array) $accountResults['account'];
                                $preSpendingBalance = $account['spendingBalance'];
                              }else{
                                $preSpendingBalance = 0;
                              }

                              
                              if($quoteId){

                                $updaateCheckoutPaymentMethodInfo["checkoutId"] = $exchange_checkout_id;
                                $updaateCheckoutPaymentMethodInfo["paymentMethod"] = "internal_$exchange_stable_token_account_id";

                                $transaction = (array)$this->yohshow_api->request("POST","/checkout/payment-method/update",$updaateCheckoutPaymentMethodInfo);

                                $quote_source_key = "exchange_quote_source";
                                $quote_source = get_option( $quote_source_key );

                                $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
                                $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

                                //

                                $quote_source_api_key_key = "exchange_quote_source_api_key";
                                $quote_source_api_key = get_option( $quote_source_api_key_key );

                                $quote_source_api_secret_key = "exchange_quote_source_api_secret";
                                $quote_source_api_secret = get_option( $quote_source_api_secret_key );

                                $quote_source_api_memo_key = "exchange_quote_source_api_memo";
                                $quote_source_api_memo = get_option( $quote_source_api_memo_key );

                                $network = $quote_source;
                                $quoteInfo["apiKey"] = $apiKey;
                                $quoteInfo["apiSecret"] = $apiSecret;
                                $quoteInfo["quoteId"] = $quoteId;
                                $quoteInfo["externalOrderId"] = $order_id;
                                $quoteInfo["exchange"] = $network;
                                $quoteInfo["exchangeApiKey"] = $quote_source_api_key;
                                $quoteInfo["exchangeApiSecret"] = $quote_source_api_secret;
                                $quoteInfo["exchangeApiMemo"] = $quote_source_api_memo;

                                error_log("buy quote called! order_id $order_id ", 0);


                                $transaction = (array)$this->yohshow_api->request("POST","/market/quote/process",$quoteInfo);

                                //TODO if quote not exeuted add error to order note
                                //make sure order says in processing/
                                // stop processing the order and change the order back to processsing

                                if(!$transaction["success"]){
                                  $errorMsgSpecific = $transaction["msg"];
                                  // update_post_meta($order_id,"exchange_internal_payment_error",true);

                                  error_log( "buy_order process quote result from error". print_r( $transaction, $errorMsgSpecific  ) );

                                }


                          

                              }else{
                              error_log( "buy order invest transaction result non qoute invest action transaction_data". print_r( $transaction_data, true ) );

                                $transaction = (array)$this->yohshow_api->request("POST","/tokens/createTransaction",$transaction_data);
                              }
                              error_log( "buy order invest transaction result transaction_data". print_r( $transaction_data, true ) );
                              error_log( "buy order invest transaction result transaction". print_r( $transaction, true ) );
                              // var_dump("buy order post invest send transaction ",$transaction);
                            //   exit;

                            //confirm balance after

                            // $accountResults = (array) $this->yohshow_api->accounts($from_account_id);
                              // $account = (array) $accountResults['account'];
                              // $spendingBalance = $account['spendingBalance'];
                              // if(!$account){
                              //   wc_add_notice(  'Connection error.', 'error' );
                              //   return;
                              // }
                            if($transaction['success'] !== true){
                              if($exchange_internal_payment){
                                ///get balance before
                                $accountResults = (array) $this->yohshow_api->accounts($exchange_internal_payment_method_account_id);
                                $account = (array) $accountResults['account'];
                                $postSpendingBalance = $account['spendingBalance'];
                                $success = $preSpendingBalance > $postSpendingBalance;
                              }else{
                                $postSpendingBalance = 0;
                                $success = false;

                              }
                            }

                              // do_action("buy_order",$product_id); // why?
                          }else if($exchange_action == "mint" ){
                            //TODO
                                  // if the follow is not set just issue stable tokens to the account and payment is external

                                  // $product_id = get_post_meta($order_id,'exchange_order_product_ids_to_mint',true);
                              $transaction_data["note"] = "Store token mint payment";
                              $transaction_data["type"] = "payment";
                              //TODO add flag to check if payment was already made for line item
                              $transaction = (array)$this->yohshow_api->request("POST","/tokens/createTransaction",$transaction_data);
                              // var_dump("buy order post invest send transaction ",$transaction);
                              //   exit;
                              if($transaction['success'] !== true){
                                $success = false;
                              }

                              if($success || !$minted_products){


                                  $product_id = get_post_meta($order_id,'exchange_order_product_ids_to_mint',true);
        //                        foreach ($exchange_order_product_ids_to_mint as $key => $product_id) {
                                  $this->tokenize_product($product_id);
        //                        }
                                $minted_products = true;


                              }

                            
                          }else if($exchange_action == "access" ){

                            // pay token //
                            // pay current/old owner //
                            // transfer admin access
                            // update token terms for new owner
                            // transfer token owners as well. 
                            // done

                            $total_payment = floatval($transaction_data["amount"]);
                            $total_token_payment = $total_payment * $this->token_sell_commmission;
                            $total_token_payment = floor($total_token_payment * 100) / 100;
                            $total_owner_payment = $total_payment - $total_token_payment;
                            $transaction_data["amount"] = $total_token_payment;
                              //$unique = get_post_meta($product_id,'exchange_order_product_ids_to_mint',true);
                              $unique = true;
                            
                            if($unique){
                              $accessType = "admin";
        //                      $accessType = "owner";
                            }else{
                              $accessType = "manager";

                            }
                            $transaction_data["note"] = "Store $accessType access payment";
                            $transaction_data["type"] = "payment";
                            //first pay token

                            error_log( "buy order invest transaction result transaction_data". print_r( $transaction_data, true ) );

                            $transaction = (array)$this->yohshow_api->request("POST","/tokens/createTransaction",$transaction_data);

                            error_log( "buy order invest transaction result transaction". print_r( $transaction, true ) );

                            
                            //then pay token owner 
                            $terms = get_the_terms( $product_id, 'owner' );
                            $ownerTerm = $terms[0];
                            $ownerTermId = $ownerTerm->term_id;
                            $ownerKey ="exchange_username_term_id_owner_user_id_$ownerTermId";
                            $exchange_username_term_id_owner_user_id = get_option($ownerKey);
                            $owner_exchange_token_id =  get_user_meta($exchange_username_term_id_owner_user_id,"exchange_token_id",true);
                            $owner_exchange_user_id =  get_user_meta($exchange_username_term_id_owner_user_id,"exchange_user_id",true);
                            
    //                        $new_owner_exchange_user_id =  $_SESSION["exchange_user_id"];

                            $new_owner_exchange_user_id =  get_user_meta($customer_id,"exchange_user_id",true);

                            $new_owner_exchange_wp_user_id =  $customer_id;

              


                            


                            $transaction_data["amount"] = $total_owner_payment;
                            $transaction_data["tokenId"] = $owner_exchange_token_id;




                            error_log( "buy order invest transaction result 2?? transaction_data". print_r( $transaction_data, true ) );
                            


                            $transaction = (array)$this->yohshow_api->request("POST","/tokens/createTransaction",$transaction_data);
                            error_log( "buy order invest transaction result 2??? transaction". print_r( $transaction, true ) );

                            // var_dump("buy order post invest send transaction ",$transaction);
                            //   exit;
                            if($transaction['success'] !== true){
                              $success = false;
                            }

                            if($success ){
                              $exchange_user_id = get_user_meta($customer_id, 'exchange_user_id', true);
                              $exchange_user_id = get_user_meta($customer_id, 'exchange_user_id', true);

                              
                              $access_data["tokenId"] = $exchange_token_id;
                              $access_data["buyerUserID"] = $new_owner_exchange_user_id;
                              $access_data["sellerUserID"] = $owner_exchange_user_id;
                              $access_data["accessType"] = $accessType;
                              $access_data["hasAccess"] = true;
                              // $access_data["sellerTokenOwner"] = true;
                              // $access_data["action"] = $accessAction;
                                $access_data["apiKey"] = $apiKey;
                                $access_data["apiSecret"] = $apiSecret;
                                $access_data["transferAccess"] = true;
                                
                              /*





                              */
                            error_log( "buy order invest transaction result access_data". print_r( $access_data, true ) );

                              $access = (array)$this->yohshow_api->request("POST","/access/update",$access_data);
                            error_log( "buy order invest transaction result access". print_r( $access, true ) );

                              if($access["success"]){
                                  $user_current_username_term_id = get_user_meta($new_owner_exchange_wp_user_id,"exchange_username_term_id",true);
                                  if(!$user_current_username_term_id){
                                    $getUserNameResult = $this->get_username($new_owner_exchange_wp_user_id);
                                    $username = $getUserNameResult["username"];
                                    $user_current_username_term_id = $getUserNameResult["ownerTermId"];
                                    
                                  }else{
                                      $term = get_term( $user_current_username_term_id, 'owner' );
                                      $username = $term->slug;
                                  }

                                  wp_set_object_terms( $product_id,$username, "owner" );


                              }

                              //if successful update tag to new onwer. make user name if user doesnt have one



                                // $product_id = get_post_meta($order_id,'exchange_order_product_ids_to_mint',true);
        //                        foreach ($exchange_order_product_ids_to_mint as $key => $product_id) {
                                // $this->tokenize_product($product_id);
        //                        }


                            }

                          
                        }else if($exchange_action == "issueStableTokens"){
                              //issue stable tokens
                              error_log( "buy_order issueStableTokens action issue_buy_currency". print_r( $issue_buy_currency, true ) );

                              
                              if($issue_buy_currency){
                                // if($issue_buy_currency && $order_status == "completed"){
                                // if(!$exchange_internal_payment){
                                $issueTransfer['note'] = "Store Credit Purchase" ;
                                $issueTransfer['type'] = "deposit";
                                $issueTransfer['tokenId'] = $exchange_token_id;
                                $issueTransfer['apiKey'] = $apiKey;
                                $issueTransfer['apiSecret'] = $apiSecret;
                                $issueTransfer['toAccountId'] = $to_account_id ?  $to_account_id :  $exchange_stable_token_account_id;
                                $issueTransfer['fromAccountId'] = $exchange_stable_token_account_id;
                                
                                $issueTransfer['amount'] = $net_total_paid;
                                $issueTransfer['amount'] = $net_total_paid;
                                $transaction =(array)$this->yohshow_api->request("POST","/accountTransfer",$issueTransfer);
                                // var_dump("buy order post issueStableTokens to send transaction ",$transaction);
                                error_log( "buy_order issueStableTokens deposit transaction transaction". print_r( $transaction, true ) );

                              }else{
                                $transaction['success'] = true;
                                $success = true;
                              }
                              if($transaction['success'] !== true){
                                $success = false;
                              }
          
                
                              

                          }else if($exchange_action == "issueTetherTokens"){
                              //issue stable tokens
                          }else if($exchange_action == "promote"){
                              //create create promote transction
                          }

                          //TODO maybe add if statment if exchange has error fulliling line item
                          $line_item_fulfilled = update_post_meta($order_id,$line_item_fulfilled_key,$success);

                          //Add order now if not successful
                          if(!$success){
                            $errorMsg =  "There was an error fullfilling a line item. Exchange Action $exchange_action";

                            if($errorMsgSpecific){
                              $errorMsg . " - " .$errorMsgSpecific;
                            }
                            $order->add_order_note( $errorMsg );
                            // $order->update_status("Processing", 'Processing error', TRUE);  
                            error_log("buy_order errorMsg $errorMsg!", 0);
                            error_log("buy_order errorMsgSpecific $errorMsgSpecific!", 0);
                            update_post_meta($order_id,"exchange_internal_payment_error",$errorMsgSpecific);

                            return ;

                          }
                          

                          
                          // exit;

                      }

                  }
                  if($looped_through == false) return;
                  // exit;
                  //todo send call to update checkout
                  error_log( "buy order invest transaction result exchange_checkout_id". print_r( $exchange_checkout_id, true ) );

                  if($exchange_checkout_id){
                    //if the checkout is not process by and and is done throug woocommcer flow or just do this anyways 
                    
                    $payment_method = get_post_meta( $order_id, '_payment_method', true );
                    
                    $checkoutUpdateInfo["payment_method"] = $payment_method; 
                    $checkoutUpdateInfo["id"] = $exchange_checkout_id; 
                    $checkoutUpdateInfo["checkoutId"] = $exchange_checkout_id; 
                    
                    $checkoutUpdateInfo["paid"] = true; 
                    $checkoutUpdateInfo["financial_status"] = "paid"; 
                    $checkoutUpdateInfo["external_order_id"] = $order_id; 

                    
                    
                    $checkoutUpdateInfo["redeemed"] = true; 
                    $checkoutUpdateInfo["apiKey"] = $apiKey;
                    $checkoutUpdateInfo["apiSecret"] = $apiSecret;
                  error_log( "buy order invest transaction result checkoutUpdateInfo". print_r( $checkoutUpdateInfo, true ) );

                    $checkoutUpdateResult =(array)$this->yohshow_api->request("POST","/checkout/update",$checkoutUpdateInfo);
                  error_log( "buy order invest transaction result checkoutUpdateResult". print_r( $checkoutUpdateResult, true ) );

                    //if not success throw exchange eorro..
                    if(!$checkoutUpdateResult['success']){
                      $exchangeError = true;
                    }


                  }else{
                    //if any of the line items was tokenized consider making a checkout object to note order 
                    // this should be used if exchanged productes were prurchase in the woocommcere flow outside of the exchang flow
                  }
                  error_log( "buy order invest transaction result success". print_r( $success, true ) );

                  $exchange_order_fullfiled = update_post_meta($order_id,"exchange_order_fullfiled",$success);
                  $note = __('Fullfiled exchange order');
                  // Add the note
                  $order->add_order_note( $note );

            }




              
              


          }
      } catch (\Throwable $th) {
        error_log("buy_order error th $th!", 0);

        throw $th;
        
      }
      



  }
  public function enviorment_label(){

    $enviorment_label = $this->yohshow_api->enviorment_label();
    
    return $enviorment_label;

      // $exchange_environment = get_option('exchange_environment');
      // if($exchange_environment !== "production"){
      //   $enviorment_label = "_".$exchange_environment;

      // }else{
      //   $enviorment_label = "";

      // }
      // return $enviorment_label;
  }

  public function tokenize_app($tokenize_app = false){

      
      $apiKey =  $this->yohshow_api_key;
      
      $exchange_app_id = get_option( 'exchange_app_id' );
      $exchange_app_url = get_option( 'exchange_app_url' );
      // $exchange_app_url = false;
      $app_token_exchange_id = get_option( 'app_token_exchange_id' );
      $stable_token_exchange_id = get_option( 'stable_token_exchange_id' );
      $app_token_product_id = get_option( 'app_token_product_id' );
      $stable_token_product_id = get_option( 'stable_token_product_id' );
      $exchange_guest_user_email = get_option( 'exchange_guest_user_email' );

      $mint_token_product_id = get_option( 'mint_token_product_id' );
      $access_token_product_id = get_option( 'access_token_product_id' );

	    $exchange_environment = get_option('exchange_environment');
	    $exchange_current_environment = get_option('exchange_current_environment');
      $enviorment_label = $this->enviorment_label();

      // error_log("tokenize_app start exchange_app_url $exchange_app_url ", 0);




      
    //   // var_dump("app token make",$app_token_exchange_id);
    //   // var_dump("stable token make",$stable_token_exchange_id);
    //   // var_dump("app token make !app_token_exchange_id",!$app_token_exchange_id);
    //   // var_dump("stable token make !stable_token_exchange_id",!$stable_token_exchange_id);

    //   // var_dump("app token make app_token_product_id",$app_token_product_id);
      // var_dump("stable token make stable_token_product_id",$stable_token_product_id);
    //   // var_dump("app token make !app_token_product_id",!$app_token_product_id);
    //   // var_dump("stable token make !stable_token_product_id",!$stable_token_exchange_id);

    //   // var_dump("stable token make exchange_guest_user_email",$exchange_guest_user_email);
    //   // var_dump("stable token make !exchange_guest_user_email",!$exchange_guest_user_email);


      $must_make = !$app_token_exchange_id || !$stable_token_exchange_id || 
      !$app_token_product_id  || !$stable_token_product_id || 
      !$exchange_guest_user_email || !$exchange_app_id ||
      !$exchange_app_url || 
      !$mint_token_product_id || !$access_token_product_id ;
    //   // var_dump(" must make",$must_make );
      // exit;

      //    // var_dump(" must make tokenize_app",$tokenize_app );
      // exit;

      $tokenize_app  =  $exchange_environment == $exchange_current_environment ? $tokenize_app : true;


//       $tokenize_app = true;
      if( $must_make || $tokenize_app){
      // if( true){
          $yohshow_api =  $this->yohshow_api;
          $apiKey =  $this->yohshow_api_key;
          // error_log("tokenize_app update tokenize_app $tokenize_app ", 0);



          // // var_dump("app token make apiKey",$apiKey);


          $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/$apiKey",array("apiKey"=>$apiKey));
          // // var_dump("app token make appTokenResult",$appTokenResult);
          
          $appId = $appTokenResult->appId;
          $appToken = $appTokenResult->appToken;
          $stableToken = $appTokenResult->stableToken;
          // // var_dump("app token make appToken",$appToken);


          // exit;
          if(!$appToken){
              return;
          }

          if( !$exchange_app_id){
            $exchange_app_id = update_option( 'exchange_app_id',$appId);
            $exchange_app_id_enviorment_label = 'exchange_app_id'.$enviorment_label;
            $exchange_app_id = update_option( $exchange_app_id_enviorment_label,$appId);

            #
            
          }

          if( !$exchange_app_url || $tokenize_app){
            // error_log("tokenize_app update exchange_app_url $exchange_app_url ", 0);

            $site_url = get_site_url();
            $authUrl = $site_url.'/wp-json/yohshow/api/v1';
            $authQuoteEndpoint = '/auth/quote';
            $authLoginEndpoint = '/auth/login';
            $authSignupEndpoint = '/auth/signup';

          

            

            $app_info['apiKey'] = $this->yohshow_api_key;
            $app_info['apiSecret'] = $this->yohshow_api_secret;
            $app_info['authUrl'] = $authUrl;
            $app_info['authUrlStaging'] = $authUrl;
            $app_info['authUrlDevelopment'] = $authUrl;

            // $app_info['authUrl'] = $authUrl;
            // $app_info['authUrlStaging'] = $authUrlStaging;
            // $app_info['authUrlDevelopment'] = $authUrlDevelopment;

            $app_info['authQuoteEndpoint'] = $authQuoteEndpoint;
            $app_info['authLoginEndpoint'] = $authLoginEndpoint;
            $app_info['authSignupEndpoint'] = $authSignupEndpoint;

            // error_log( "tokenize_app update exchange_app_url app_info". print_r( $app_info, true ) );

            
            $result = $this->send_request("/app/config",$app_info); //change enpoint
            $result = json_decode($result,false);
            // error_log( "tokenize_app update exchange_app_url result". print_r( $result, true ) );


            if($result->success){
              // error_log( "tokenize_app update exchange_app_url must update url now" );

              $exchange_app_url = update_option( 'exchange_app_url',$authUrl);
              $exchange_app_url_enviorment_label = 'exchange_app_url'.$enviorment_label;
              $exchange_app_url = update_option( $exchange_app_url_enviorment_label,$authUrl);
            }

            #
            
          }


          if( !$app_token_exchange_id || $tokenize_app){
          // if( true){
              $appToken->action = "invest";
              // // var_dump(" must make product tokenize_app",$tokenize_app );
              // // var_dump(" must make product app_token_exchange_id",$app_token_exchange_id );
              // exit;
              $appTokenProduct = $this->create_product($appToken);
              // // var_dump("app token make appTokenProduct",$appTokenProduct);
              // exit;


              $app_token_exchange_id = $appToken->id;
              $app_token_product_id = $appTokenProduct->get_id();
            //   // var_dump("app token make pre app_token_exchange_id",$app_token_exchange_id);
            //   // var_dump("app token make pre app_token_product_id",$app_token_product_id);
              // exit;

              $app_token_exchange_id_meta_id = update_option( 'app_token_exchange_id',$app_token_exchange_id);
              $app_token_exchange_id_enviorment_label = 'app_token_exchange_id'.$enviorment_label;
              $app_token_exchange_id_enviorment_meta_id = update_option( $app_token_exchange_id_enviorment_label,$app_token_exchange_id);

         

              $app_token_product_id_meta_id = update_option( 'app_token_product_id',$app_token_product_id);
              $app_token_product_id_enviorment_label = 'app_token_product_id'.$enviorment_label;
              $app_token_product_id_enviorment_meta_id = update_option( $app_token_product_id_enviorment_label,$app_token_product_id);




            //   // var_dump("app token make post app_token_exchange_id",$app_token_exchange_id);
            //   // var_dump("app token make post app_token_product_id",$app_token_product_id);
              
              $app_token_exchange_id = get_option( 'app_token_exchange_id' );
            //   // var_dump("app token make get app_token_exchange_id",$app_token_exchange_id);




          }
          if( !$stable_token_exchange_id || $tokenize_app ){
          // if( true){
              $stableToken->action = "issueStableTokens";
              // // var_dump(" must make product tokenize_app",$tokenize_app );
              // // var_dump(" must make product stable_token_exchange_id",$stable_token_exchange_id );
              // exit;
              $stableTokenProduct = $this->create_product($stableToken);
              
              $stable_token_exchange_id = $stableToken->id;
              $stable_token_product_id = $stableTokenProduct->get_id();
            //   // var_dump("app token make pre stable_token_exchange_id",$stable_token_exchange_id);
            //   // var_dump("app token make pre stable_token_product_id",$stable_token_product_id);
              // exit;

              $stable_token_exchange_id_meta_id = update_option( 'stable_token_exchange_id',$stable_token_exchange_id);
              $stable_token_exchange_id_enviorment_label = 'stable_token_exchange_id'.$enviorment_label;
              $stable_token_exchange_id_enviorment_meta_id = update_option( $stable_token_exchange_id_enviorment_label,$stable_token_exchange_id);



              $stable_token_product_id_meta_id = update_option( 'stable_token_product_id',$stable_token_product_id);
              $stable_token_product_id_enviorment_label = 'stable_token_product_id'.$enviorment_label;
              $stable_token_product_id_enviorment_meta_id = update_option( $stable_token_product_id_enviorment_label,$stable_token_product_id);
            //   // var_dump("app token make post stable_token_exchange_id",$stable_token_exchange_id);
            //   // var_dump("app token make post stable_token_product_id",$stable_token_product_id);
              
              $stable_token_exchange_id = get_option( 'stable_token_exchange_id' );
            //   // var_dump("app token make get stable_token_exchange_id",$stable_token_exchange_id);
          }
          if(!$exchange_guest_user_email || $tokenize_app){

            $signup = (object) $this->yohshow_api->get_guest_user();

            // $guest_email = "guest@yohshow.com";

            // $exchange_guest_user_email_meta_id = update_option( 'exchange_guest_user_email',$guest_email);
            // $exchange_guest_user_email_enviorment_label = 'exchange_guest_user_email'.$enviorment_label;
            // $exchange_guest_user_email_enviorment_meta_id = update_option( $exchange_guest_user_email_enviorment_label,$exchange_guest_user_email);

            // // // var_dump("tokenize exchange_guest_user_email",$exchange_guest_user_email);

            // $signup = (object) $this->yohshow_api->get_user("Guest Customer",$guest_email);
            // // // var_dump("tokenize signup",$signup);

            // $exchange_guest_user_id = $signup->userId;
            // $exchange_guest_token_id = $signup->token->id;
            // $exchange_guest_wallet_id = $signup->wallet->id;
            // $exchange_guest_stable_token_account_id = $signup->stableTokenAccountId;
            // $exchange_guest_app_token_account_id = $signup->appTokenAccountId;
            // // // var_dump("tokenize pre exchange_guest_user_id",$exchange_guest_user_id);
            // // // var_dump("tokenize pre exchange_guest_token_id",$exchange_guest_token_id);
            // // // var_dump("tokenize pre exchange_guest_wallet_id",$exchange_guest_wallet_id);


            // $exchange_guest_user_id_meta_id = update_option('exchange_guest_user_id', $exchange_guest_user_id);
            // $exchange_guest_user_id_enviorment_label = 'exchange_guest_user_id'.$enviorment_label;
            // $exchange_guest_user_id_enviorment_meta_id = update_option( $exchange_guest_user_id_enviorment_label,$exchange_guest_user_id);


            // $exchange_guest_token_id_meta_id = update_option('exchange_guest_token_id', $exchange_guest_token_id);
            // $exchange_guest_token_id_enviorment_label = 'exchange_guest_token_id'.$enviorment_label;
            // $exchange_guest_token_id_enviorment_meta_id = update_option( $exchange_guest_token_id_enviorment_label,$exchange_guest_token_id);


            // $exchange_guest_stable_token_account_id_meta_id = update_option('exchange_guest_stable_token_account_id', $exchange_guest_stable_token_account_id);
            // $exchange_guest_stable_token_account_id_enviorment_label = 'exchange_guest_stable_token_account_id'.$enviorment_label;
            // $exchange_guest_stable_token_account_id_enviorment_meta_id = update_option( $exchange_guest_stable_token_account_id_enviorment_label,$exchange_guest_stable_token_account_id);

            // $exchange_guest_app_token_account_id_meta_id = update_option('exchange_guest_app_token_account_id', $exchange_guest_app_token_account_id);
            // $exchange_guest_app_token_account_id_enviorment_label = 'exchange_guest_app_token_account_id'.$enviorment_label;
            // $exchange_guest_app_token_account_id_enviorment_meta_id = update_option( $exchange_guest_app_token_account_id_enviorment_label,$exchange_guest_app_token_account_id);

            // // // var_dump("tokenize post exchange_guest_user_id",$exchange_guest_user_id);
            // // // var_dump("tokenize post exchange_guest_token_id",$exchange_guest_token_id);
            // // // var_dump("tokenize post exchange_guest_wallet_id",$exchange_guest_wallet_id);

            // exit;
          }

          if( !$mint_token_product_id || $tokenize_app){
                $mintAppToken = $appToken;
                $mintAppToken->action = "mint";
                $mintAppToken->price = $this->standard_mint_price;
                $mintTokenProduct = $this->create_product($mintAppToken);
                $mint_token_product_id = $mintTokenProduct->get_id();
                $mint_token_product_id_meta_id = update_option( 'mint_token_product_id',$mint_token_product_id);
                $mint_token_product_id_enviorment_label = 'mint_token_product_id'.$enviorment_label;
                $mint_token_product_id_enviorment_meta_id = update_option( $mint_token_product_id_enviorment_label,$mint_token_product_id);
                // $mint_token_product_id = get_option( 'mint_token_product_id' );
  
  
  
  
            }
            if( !$access_token_product_id || $tokenize_app){
              $accessAppToken = $appToken;
              $accessAppToken->action = "access";
              $accessAppToken->quantity = $this->default_access_quantity;
              $accessAppToken->price = $this->standard_access_price;
              $accessTokenProduct = $this->create_product($accessAppToken);
              $access_token_product_id = $accessTokenProduct->get_id();
              $access_token_product_id_meta_id = update_option( 'access_token_product_id',$access_token_product_id);
              $access_token_product_id_enviorment_label = 'access_token_product_id'.$enviorment_label;
              $access_token_product_id_enviorment_meta_id = update_option( $access_token_product_id_enviorment_label,$access_token_product_id);
              // $access_token_product_id = get_option( 'access_token_product_id' );

          }

          

      }else{
        //   // var_dump("app token made",$app_token_exchange_id);
        //   // var_dump("stable token made",$stable_token_exchange_id);
        //   // var_dump("app token made app_token_product_id",$app_token_product_id);
        //   // var_dump("stable token made stable_token_product_id",$stable_token_product_id);
        //   // var_dump("stable token made exchange_guest_user_email",$exchange_guest_user_email);
        //   // var_dump("stable token made exchange_app_id",$exchange_app_id);
      }
      if($exchange_environment !== $exchange_current_environment){
        update_option('exchange_current_environment', $exchange_environment);
      }


  }

  /**
   * Adds wp acctions and triggers
   */
  public function create_product($token,$updatePrice = false ) {
      $token_info = (array) $token;
//      (object) $token;
      $token = json_decode(json_encode($token_info), FALSE);
    global $woocommerce;
    $ownershipPrice = $token_info["ownershipPrice"];
        $ownershipForSell = $token_info["ownershipForSell"];
        $token_decription =  $token->decription;

        

    // /*
    //     need to create products
    //         //tokenized = true
    //         //exchange_token_id set
    //         //promo varient set
    //         //price set
    //         //market set
    //         //symbol set
    //         //minted true
    // */
    $mint = $token_info['mint'] ? $token_info['mint']  : false;
    /*
    if is ts a mint
      must be draft //
      dont need to save symbol or action //
      associate product with user ?? // maybe this is done automaticlly
      save token as token info for meta //
    
    */

    
    if($mint){
      $product = new WC_Product_Simple();
      $post_status = "draft";
      $token_name =  $token->name;
      $exchange_action = "access";




    }else{
      $post_status = "publish";

      $exchange_action = $token->action;

      $symbol = $token->symbol;
      $symbolBase = $token->symbolBase;

      

      if($exchange_action == "payment"){
        $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
        $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
        $token_name =  "Pay " . $token->name;
      }else if($exchange_action == "access"){
        $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
        $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
        // $token_name =  $token->name . " Access";
        $token_name =  $token->name;
      }else if($exchange_action == "sell"){
        $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
        $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
        $token_name =  "Sell " . $token->name;
      }else if($exchange_action == "mint"){
        $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
        $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
        $token_name = $token->name . " Mint";
      }
      else if($exchange_action == "invest"){
        $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
        $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
        $token_name = $token->name . " Ticket";
      }
      else{
        $symbolKey = "exchange_product_symbol_".$symbol;
        $symbolBaseKey = "exchange_product_symbolBase_".$symbolBase;
        $token_name =  $token->name;
      }

      

      $symbolKey_product_id = get_option( $symbolKey );
      $symbolBase_product_id = get_option( $symbolBaseKey );
        //find or create product here 
      if(!$symbolBase_product_id){
        $product = new WC_Product_Simple();
      }else{
        $product = wc_get_product( $symbolBase_product_id );
        $product = $product ? $product : new WC_Product_Simple();
      }
      if($updatePrice){
        $product->set_regular_price( $token->price );
        
      }
      if($exchange_action == "access"){
        $product->set_manage_stock( true );
        if($ownershipForSell  == "yes" || $ownershipForSell === true  ){
            $price = floatval($token->ownershipPrice);
//          $product->set_stock_quantity( $token->quantity );
            $product->set_stock_quantity( 1 );
            $product->set_regular_price( $price );


        }else{
          $product->set_stock_quantity( 0 );


        }

      }

    }

    $product->set_name( $token_name );
    $product->set_status( $post_status );
    // $product->set_description($token_decription );
    $product->set_virtual( true );
    $product->save();
    // var_dump("post save",$product);

    $product_id = $product->get_id();
    // var_dump($product);
    $tokenized = update_post_meta($product_id,"tokenized",true);
    

    if($mint){
      $exchange_token_info = update_post_meta($product_id,"exchange_token_info",$token_info);
      $exchange_product_type = get_post_meta($product_id,"exchange_product_type","token");


    }else{
      // $exchange_token_info = update_post_meta($product_id,"exchange_token_info",$token_info);
      //TODO convert envormeint lables here
      $this->update_token_product_data($product_id,$token);

        if($exchange_action){
          $exchange_action_meta_id = update_post_meta($product_id,"exchange_action",$exchange_action);

      }

      $promotion_agreement_data = array(
          'post_title'  => $product->get_name(),
          'post_name'   => 'product-'.$product_id.'-variation',
          'post_status' => $post_status,
          'post_parent' => $product_id,
          'post_type'   => 'product_variation',
          'guid'        => $product->get_permalink()
      );
      $symbolKey_product_id = update_option($symbolKey, $product_id);
      $symbolBaseKey_product_id = update_option($symbolBaseKey, $product_id);

  
      //   // Creating the product variation
      //   $variation_id = wp_insert_post( $promotion_agreement_data );
      // //   // var_dump($variation_id);
      //   $promotion_agreement = update_post_meta($variation_id,"promotion_agreement",true);
      //   $promotion_agreement_tokenized = update_post_meta($variation_id,"tokenized",true);
      //   $promotion_agreement_exchange_token_id = update_post_meta($variation_id,"exchange_token_id",$token->id);
      //   $promotion_agreement_exchange_action = update_post_meta($variation_id,"exchange_action","promote");
      //   $promotion_agreement_id = update_post_meta($product_id,"promotion_agreement_id",$variation_id);

    }

    //set product featured image here right?!

    if($exchange_action !== "access"){
      //get access product key
      $accessProductSymbolKey = "exchange_product_access_symbol_".$symbol;
      $accessProductSymbolBaseKey = "exchange_product_access_symbolBase_".$symbolBase;
      //get product
      $access_product_id = get_option( $accessProductSymbolKey );
      if($access_product_id){
        //get product feature image
        $access_product_image_id =  get_post_thumbnail_id( $access_product_id );
        
        //if product feature image
        if($access_product_image_id){
        // set this product to access product feature image
          set_post_thumbnail( $product_id, $access_product_image_id );
        }
        //else
        // set product to defautl image//right now nothing

        //set product owner
        $terms = get_the_terms( $access_product_id, 'owner' );
        if ($terms && ! is_wp_error($terms)){
          foreach($terms as $term){
            // should only happen once
            wp_set_object_terms( $product_id, $term->term_id, "owner" );
          }
        } 
        //set product creator 
        $terms = get_the_terms( $access_product_id, 'creator' );
        if ($terms && ! is_wp_error($terms)){
          foreach($terms as $term){
            // should only happen once
            wp_set_object_terms( $product_id, $term->term_id, "creator" );
          }
        } 

      }

      
    }

    //set product utlity terms
    if($exchange_action == "payment"){
      //payment
      $utility = "payment";
    }else if($exchange_action == "access"){
      //ownership
      $utility = "ownership";
    }else if($exchange_action == "sell"){
      //sell
      $utility = "sell";
    }else if($exchange_action == "mint"){
      //mint/service
      $utility = "mint";
    }
    else if($exchange_action == "invest"){
      //access
      $utility = "access";
    }
    else{
      //access
      $utility = "access";
    }
    wp_set_object_terms( $product_id, $utility, "utility" );


    


    
    return $product;

}
public function update_token_product_data($product_id,$token){

  $enviorment_label = $this->enviorment_label();

      
      $market_meta_id = update_post_meta($product_id,"market",$token->market);
      $market_enviorment_label = 'market'.$enviorment_label;
      $market_enviorment_meta_id = update_post_meta($product_id, $market_enviorment_label,$token->market);

      $access_market = update_post_meta($product_id,"access_market",$token->accessMarket);
      $access_market_enviorment_label = 'access_market'.$enviorment_label;
      $access_market_enviorment_meta_id = update_post_meta($product_id, $access_market_enviorment_label,$token->access_market);
      // $minted = update_post_meta($product_id,"minted",$token->minted);
      $exchange_token_id_meta_id = update_post_meta($product_id,"exchange_token_id",$token->id);
      $exchange_token_id_enviorment_label = 'exchange_token_id'.$enviorment_label;
      $exchange_token_id_enviorment_meta_id = update_post_meta($product_id, $exchange_token_id_enviorment_label,$token->id);
}

  /**
   * Adds wp acctions and triggers
   */
  public function tokenize_product($product_id ) {
    try {
      global $woocommerce;
      $product = wc_get_product( $product_id );
      $product = $product ? $product : new WC_Product_Simple();

      $token = get_post_meta($product_id,"exchange_token_info",true);
      $exchange_product_type = get_post_meta($product_id,"exchange_product_type",true);
      $exchange_token_minted = get_post_meta($product_id,"exchange_token_minted",true);
//      if($exchange_product_type == "token"){
        if($token){

        $token_info = (array) $token;
        $token_info["externalId"] = $product_id;
        $token = json_decode(json_encode($token_info), FALSE);
        $mint = isset($token->mint) ? $token->mint : false;
        $ownershipPrice = $token_info["ownershipPrice"];
        $ownershipForSell = $token_info["ownershipForSell"];

        // get customer id 
        //get product owner
	      $creatorTerms = get_the_terms( $product_id, 'creator' );
        $creatorTerm = $creatorTerms[0];
        $creatorTermId = $creatorTerm->term_id;

        $creatorKey ="exchange_creator_term_id_owner_user_id_$creatorTermId";
        $creator_wp_user_id = get_option($creatorKey);
        $mintOwnerUserId =  get_user_meta($creator_wp_user_id,"exchange_user_id",true);
        if($mintOwnerUserId){
          $token_info["mintOwnerUserId"] = $mintOwnerUserId;

        }



        //set action
        //create payment product
        //create sell 
        $token->action = "access";
        $exchange_action = "access";
        $updatePrice = true;
        $mintingToken = true;
        

      }else{
        $updatePrice = false;

        //create token for product not created by the mint page
        //set action
        //create revenue token product product
        //create sell product
        // $token->action = "access";
        $exchange_action = "access";


        $product_name = $product->get_name();
        $mintingToken = true;
        $token_info["name"] = $product_name;
        $token_info["quickMint"] = true;

        // $product_descrption = $product->get_descrption();
        // $product_name = $product->get_name();
        // $product_name = $product->get_name();



        // symbol: {
        //   description: 'symbol of token',
        //   example: 'symbol',
        //   required: false
        // },



        // country: {
        //   description: 'country of token',
        //   example: 'country',
        //   required: false
        // },
        // address: {
        //   description: 'address of token',
        //   example: 'address',
        //   required: false
        // },
        // city: {
        //   description: 'city of token',
        //   example: 'city',
        //   required: false
        // },
        // state: {
        //   description: 'state of token',
        //   example: 'state',
        //   required: false
        // },
        // zip: {
        //   description: 'zip of token',
        //   example: 'zip',
        //   required: false
        // },
        // website: {
        //   description: 'website of token',
        //   example: 'website',
        //   // required: false
        // },
        // twitter: {
        //   description: 'twitter of token',
        //   example: 'twitter',
        //   required: false
        // },
        // facebook: {
        //   description: 'facebook of token',
        //   example: 'facebook',
        //   required: false
        // },
        // instagram: {
        //   description: 'instagram of token',
        //   example: 'instagram',
        //   required: false
        // },
        // phone: {
        //   description: 'phone of token',
        //   example: 'phone',
        //   required: false
        // },

        // isStableToken: {
        //   description: 'Is this token a stable token',
        //   defaultsTo: true,
        //   type: 'boolean',
        //   required: false
        // },
        // stableFund: {
        //   description: 'Amount user wants to add to the stable token backing',
        //   defaultsTo: 0,
        //   type: 'number',
        //   required: false
        // },

        // externalId: {
        //   description: 'external parent id of current object being tokenzed',
        //   type: 'string',
        //   required: false
        // },



        // quickMint: {
        //   description: 'create tokent and exit a with processing status',
        //   type: 'boolean',
        //   required: false,
        //   defaultsTo: false
        // },

        // token.externalId = token.id;
        // token.externalType = "token";
        // token.quickMint = quickMint;


      }

      

      if($exchange_token_minted){
        //get token
        $filter['apiKey'] = $this->yohshow_api_key;
        $filter['externalId'] = $product_id;
        $token_search_info["filter"] = json_encode($filter);
        // $token_search_info['externalIdType'] = "token";
          $token_result = $this->send_request("/tokens",$token_search_info);
          $token_result = json_decode($token_result,false);
          $token = $token_result->tokens[0];
          $tokenId = $token->id;

      }else{
        $token_result = $this->create_token($token_info);
        $token = $token_result->token;
        $tokenId = $token->id;
        $exchange_token_minted = update_post_meta($product_id,"exchange_token_minted",true);
        //index collection
        $this->collection_index($product_id);
        

      }
      // $exchange_token_product_id_key =  "exchange_token_product_id_".$tokenId; 
      // $exchange_token_product_id =  update_option($exchange_token_product_id_key,$product_id); 

      

      // /*
      //     need to create products
      //         //tokenized = true
      //         //exchange_token_id set
      //         //promo varient set
      //         //price set
      //         //market set
      //         //symbol set
      //         //minted true
      // */
      /*
      if is ts a mint
        must be draft //
        dont need to save symbol or action //
        associate product with user ?? // maybe this is done automaticlly
        save token as token info for meta //
      
      */

   
        $post_status = "publish";

        // $exchange_action = $token->action;

        $symbol = $token->symbol;
        $symbolBase = $token->symbolBase;

        if($exchange_action == "payment"){
          $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
          $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
          $token_name =  "Pay " . $token->name;
        }else if($exchange_action == "access"){
          $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
          $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
          $token_name =  $mintingToken ?  $token->name  : $token->name;
        }else if($exchange_action == "sell"){
          $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
          $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
          $token_name =  "Sell " . $token->name;
        }else if($exchange_action == "invest"){
          $symbolKey = "exchange_product_".$exchange_action."_symbol_".$symbol;
          $symbolBaseKey = "exchange_product_".$exchange_action."_symbolBase_".$symbolBase;
          $token_name =  $mintingToken ?  $token->name . " Ticket"  : $token->name;
        }else{
          $symbolKey = "exchange_product_symbol_".$symbol;
          $symbolBaseKey = "exchange_product_symbolBase_".$symbolBase;
          $token_name =  $token->name;
        }
        $ownershipForSell = $token->ownershipForSell;

        

        $symbolKey_product_id = get_option( $symbolKey );
        $symbolBase_product_id = get_option( $symbolBaseKey );
          //find or create product here 

        if($updatePrice){
            if($exchange_action == "access"){
                $price = floatval($token->ownershipPrice);
            }else{
                $price = floatval($token->price);
            }
          $product->set_regular_price( $price );
        }
        if($exchange_action == "access"){
            $product->set_manage_stock( true );
            if($ownershipForSell  == "yes" || $ownershipForSell == true  ){
                $price = floatval($token->ownershipPrice);
//          $product->set_stock_quantity( $token->quantity );
                $product->set_stock_quantity( 1 );
                $product->set_regular_price( $price );

            }else{
                $product->set_stock_quantity( 0 );

            }

        }

      

      $product->set_name( $token_name );
      $product->set_status( $post_status );
      $product->save();
      // var_dump("post save",$product);

      $product_id = $product->get_id();
      $data = array(
        'ID' => $product_id,
        'post_status' => $post_status,
       );
      
      wp_update_post( $data );
      // var_dump($product);
      $tokenized = update_post_meta($product_id,"tokenized",true);
      

        // $exchange_token_info = update_post_meta($product_id,"exchange_token_info",$token_info);

        $this->update_token_product_data($product_id,$token);
        
          if($exchange_action){
            $exchange_action_meta = update_post_meta($product_id,"exchange_action",$exchange_action);

        }

        $promotion_agreement_data = array(
            'post_title'  => $product->get_name(),
            'post_name'   => 'product-'.$product_id.'-variation',
            'post_status' => $post_status,
            'post_parent' => $product_id,
            'post_type'   => 'product_variation',
            'guid'        => $product->get_permalink()
        );
        $symbolKey_product_id = update_option($symbolKey, $product_id);
        $symbolBaseKey_product_id = update_option($symbolBaseKey, $product_id);

    
        //   // Creating the product variation
        //   $variation_id = wp_insert_post( $promotion_agreement_data );
        // //   // var_dump($variation_id);
        //   $promotion_agreement = update_post_meta($variation_id,"promotion_agreement",true);
        //   $promotion_agreement_tokenized = update_post_meta($variation_id,"tokenized",true);
        //   $promotion_agreement_exchange_token_id = update_post_meta($variation_id,"exchange_token_id",$token->id);
        //   $promotion_agreement_exchange_action = update_post_meta($variation_id,"exchange_action","promote");
        //   $promotion_agreement_id = update_post_meta($product_id,"promotion_agreement_id",$variation_id);


        if($exchange_action == "access"){
          $token->action = "invest";
          $invest_product = $this->create_product($token,true);
          $token->action = "payment";
          $token->price = 1;
          $payment_product = $this->create_product($token,true); //make sure this makes price 1 dollar
        }else if($exchange_action == "invest"){
          $token->action = "access";
          $token->price = $ownershipPrice;
          
          $token->quantity = $this->default_access_quantity;
          $access_product = $this->create_product($token,true);
          $token->action = "payment";
          $token->price = 1;
          $payment_product = $this->create_product($token,true); //make sure this makes price 1 dollar
        }


      



      return $product;
    } catch (\Throwable $th) {
      //throw $th;
      $result["error"] = $th; 
      $result["success"] = false; 
    }


  }

  /**
   * Adds wp acctions and triggers
   */
  public function add_actions() {

      add_action( 'exchange_buy_order', array($this,'buy_order') );
      add_action( 'woocommerce_update_order', array($this,'buy_order') );
      add_action( 'woocommerce_new_order', array($this,'buy_order') );
      add_action( 'wp_login', array($this,'_login') );
      add_action( 'user_register', array($this,'_signup') );

      // Add hook for admin <head></head>
      add_action( 'admin_head', array($this,'activate_links')  );
      // Add hook for front-end <head></head>
      add_action( 'wp_head', array($this,'activate_links')  );
      add_action('wp_logout',array($this,'auto_redirect_after_logout') );
//      add_action('after_setup_theme',array($this,'remove_admin_bar') );



  }
  public function remove_admin_bar() {
    if (!current_user_can('administrator') && !is_admin()) {
      show_admin_bar(false);
    }
  }
  public function auto_redirect_after_logout(){
    wp_safe_redirect( home_url() );
    exit;
  }

  /**
   * checks if someone is signed into the app
   * Logins in user if  not logged in on exchange, 
   * logins in guest user if no one is log in  
   */
  public function start_session() {
    session_start();

    $user_using_correct_app = isset($_SESSION["user_exchange_api_key"]) && $_SESSION["user_exchange_api_key"] == $_SESSION["exchange_api_key"];
      // // var_dump("session app check user_exchange_api_key ",$_SESSION["user_exchange_api_key"]);
      // // var_dump("session app check exchange_api_key ",$_SESSION["exchange_api_key"]);
      // // var_dump("session app check user_using_correct_app",$user_using_correct_app);
    // exit;

      //TODO figure out if wp user matches the exchange user
    $logged_in = is_user_logged_in();
    $correct_user_id = true;
    if($logged_in){
        //login current user
        $user =  wp_get_current_user();
        $user_id = $user->ID;
    }else{
        // return;
      $user_id = 0;
    }
    $exchange_wp_user_id = isset($_SESSION["exchange_wp_user_id"]) ? $_SESSION["exchange_wp_user_id"] : false;
    $exchange_cookie = isset($_SESSION["exchange_cookie"]) ? $_SESSION["exchange_cookie"] : false;
    $correct_user_id = $user_id == $exchange_wp_user_id;

    if($exchange_cookie && $user_using_correct_app && $correct_user_id){
        //user is loggined now session needed
        // // var_dump("session logged in exchange_cookie",$exchange_cookie);

    }else{
        // // var_dump("session not logged in exchange_cookie",$exchange_cookie);
        // $logged_in = is_user_logged_in();
        if($logged_in){
            //login current user
          //  $user =  wp_get_current_user();
        //    // var_dump("session logged in user user",$user);

          //  $user_id = $user->ID;
        //    // var_dump("session logged in user user_id",$user_id);

           $login = (array) $this->_login($user_id);
          
           if(isset($login['tokenize_app']) ){
              // // var_dump('session user tokenize_app' ,$login['tokenize_app']);
              // exit;
              $this->tokenize_app(true);
           }
           //NOTE: these lines are redundent because of _login 
           $_SESSION["exchange_wp_user_id"] = $user_id;
           $_SESSION["exchange_guest_user"] = false;


           

        }else{
            //login guest user
            $exchange_guest_user_email = get_option( 'exchange_guest_user_email' );
            // // var_dump("session guest user exchange_guest_user_email",$exchange_guest_user_email);

            $login = (array)$this->yohshow_api->login($exchange_guest_user_email);
            // // var_dump("session guest user login",$login);

            $exchange_guest_token_id = get_option('exchange_guest_token_id');
            $exchange_guest_user_id = get_option('exchange_guest_user_id');
            $exchange_guest_wallet_id = get_option('exchange_guest_wallet_id');
            // // var_dump("session guest user exchange_guest_token_id",$exchange_guest_token_id);
            // // var_dump("session guest user exchange_guest_user_id",$exchange_guest_user_id);
            // // var_dump("session guest user exchange_guest_wallet_id",$exchange_guest_wallet_id);
            $_SESSION["exchange_user_id"] = $exchange_guest_user_id;
            $_SESSION["exchange_token_id"] = $exchange_guest_token_id;
            $_SESSION["exchange_wallet_id"] = $exchange_guest_wallet_id;
            $_SESSION["exchange_guest_user"] = true;
            $_SESSION["exchange_wp_user_id"] = 0;
            // // var_dump('session guest user tokenize_app' ,$login['tokenize_app']);
            // exit; 
            if($login['tokenize_app']){
              // // var_dump('session user guest tokenize_app' ,$login['tokenize_app']);
              // exit;
              $this->tokenize_app(true);
            }

        }
        // exit;
    }

 }
 public function import_token($token){
        $token_info = (array) $token;
        $token = json_decode(json_encode($token_info), FALSE);
        $token->action = "access";
      // // var_dump(" must make product tokenize_app",$tokenize_app );
      // // var_dump(" must make product app_token_exchange_id",$app_token_exchange_id );
      // exit;
      $tokenProduct = $this->create_product($token);
      // // var_dump("app token make tokenProduct",$tokenProduct);
      // exit;


      $result['success'] = true;
      $result['product'] = $tokenProduct;
      $result['token'] = $token;
      $result['exchange_id'] = $token->id;
      $result['product_id'] = $tokenProduct->get_id();
      return $result;
 }


  


 

    

}